REM file: Touch.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "TOUCH"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare filename variables
DIM SHARED Drive.Search AS STRING * 1
DIM SHARED Current.Directory AS STRING

' declare work variables
DIM SHARED Files.Counter AS INTEGER, Quit.Searching AS INTEGER
DIM SHARED Continuous.Display AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Remove.Slash AS INTEGER, Prepend.Drive AS INTEGER
DIM SHARED Nested.Levels AS INTEGER, Nested.Recurse AS INTEGER

' declare search work variables
DIM SHARED Search.From.Date AS SINGLE, Search.To.Date AS SINGLE
DIM SHARED Search.From.Time AS SINGLE, Search.To.Time AS SINGLE
DIM SHARED File.Size AS DOUBLE, Recurse.Directories AS INTEGER
DIM SHARED Display.Hidden AS INTEGER, Display.System AS INTEGER
DIM SHARED Display.Compress AS INTEGER, Display.Encrypt AS INTEGER
DIM SHARED Display.Readonly AS INTEGER, Display.Archive AS INTEGER
DIM SHARED Display.Any AS INTEGER, No.Display.Archive AS INTEGER
DIM SHARED No.Display.Readonly AS INTEGER, No.Display.System AS INTEGER
DIM SHARED No.Display.Compress AS INTEGER, No.Display.Encrypt AS INTEGER
DIM SHARED No.Display.Hidden AS INTEGER, No.Display.Any AS INTEGER
DIM SHARED Debug.Mode AS INTEGER, Prompt.Files AS INTEGER

' declare count variables
DIM SHARED Files.Counted AS DOUBLE
DIM SHARED Display.Search AS INTEGER
DIM SHARED Display.Filenames AS INTEGER

' declare file date\time and filesize work variables
DIM SHARED File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
DIM SHARED Search.Size.From AS DOUBLE, Search.Size.To AS DOUBLE
DIM SHARED Search.File.Size, Creation.Time AS INTEGER
DIM SHARED Access.Time AS INTEGER, Modified.Time AS INTEGER

' declare date\time work variables
DIM SHARED HourTemp AS INTEGER, MinuteTemp AS INTEGER, SecondTemp AS INTEGER
DIM SHARED MonthTemp AS INTEGER, DayTemp AS INTEGER, YearTemp AS INTEGER

' declare file date/time override work varibles
DIM SHARED Override.Create.Date AS INTEGER
DIM SHARED Override.Access.Date AS INTEGER
DIM SHARED Override.Modify.Date AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)

    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
    FUNCTION RemoveDirectoryA% (F$)
    FUNCTION CreateDirectoryA% (F$, X$)

    FUNCTION CloseHandle& (BYVAL hfile AS _OFFSET)
    FUNCTION GetFileTime& (BYVAL hFile AS _OFFSET, lpCreationTime AS FILETIME, lpLastAccessTime AS FILETIME, lpLastWriteTime AS FILETIME)
    FUNCTION SetFileTime& (BYVAL hFile AS _OFFSET, lpCreationTime AS FILETIME, lpLastAccessTime AS FILETIME, lpLastWriteTime AS FILETIME)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION SystemTimeToFileTime& (lpSystemTime AS SYSTEMTIME, lpFileTime AS FILETIME)

    FUNCTION GetLastError& ()
    FUNCTION FormatMessageA& (BYVAL f AS LONG, f$, BYVAL e AS LONG, BYVAL d AS LONG, g$, s AS LONG, h$)
END DECLARE

DECLARE LIBRARY
    FUNCTION CreateFile%& (filename$, BYVAL access&, BYVAL sharing&, BYVAL sec_attr%&, BYVAL create&, BYVAL flags&, BYVAL template%&)
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED CreateDate AS FILETIME
DIM SHARED AccessDate AS FILETIME
DIM SHARED ModifyDate AS FILETIME

DIM SHARED SourceCreateDate AS FILETIME
DIM SHARED SourceAccessDate AS FILETIME
DIM SHARED SourceModifyDate AS FILETIME

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING
DIM SHARED finddatatemp AS WIN32_FIND_DATAA

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' store command line
Command.Line = RTRIM$(COMMAND$)
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' get current drive
Current.Drive$ = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "File spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' check command line switches
Display.Archive = ParseLine("//A")
Display.Hidden = ParseLine("//H")
Display.Readonly = ParseLine("//O")
Display.System = ParseLine("//S")
Display.Compress = ParseLine("//M1")
Display.Encrypt = ParseLine("//M2")
Display.Any = ParseLine("//X")

No.Display.Archive = ParseLine("/A")
No.Display.Hidden = ParseLine("/H")
No.Display.Readonly = ParseLine("/O")
No.Display.System = ParseLine("/S")
No.Display.Compress = ParseLine("/M1")
No.Display.Encrypt = ParseLine("/M2")
No.Display.Any = ParseLine("/X")

Continuous.Display = ParseLine("/C")
Display.Search = ParseLine("/J")
Prompt.Files = ParseLine("/P")
Recurse.Directories = ParseLine("/R")
Prepend.Drive = ParseLine("/U")
Display.Filenames = ParseLine("/V")
Remove.Slash = ParseLine("/Y")
Display.Errors = ParseLine("/Z")

' read override switches.
Override.Create.Date = ParseLine("/7")
Override.Access.Date = ParseLine("/8")
Override.Modify.Date = ParseLine("/9")

' reset file counter variable
Continue = False
Files.Counted = 0#
   
' read date override switch
File.Date$ = DATE$
Imbedded = INSTR(UCASE$(Command.Line), "/5")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    File.Date$ = MID$(Command.Line, Imbedded + 2, 10)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 12)
    IF LEN(File.Date$) <> 10 THEN
        GOTO Boot.Error
    END IF
END IF

' store date values
MonthTemp = VAL(MID$(File.Date$, 1, 2))
DayTemp = VAL(MID$(File.Date$, 4, 2))
YearTemp = VAL(MID$(File.Date$, 7, 4))

' read time override switch
File.Time$ = TIME$
Imbedded = INSTR(UCASE$(Command.Line), "/6")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    File.Time$ = MID$(Command.Line, Imbedded + 2, 8)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 10)
    IF LEN(File.Time$) <> 8 THEN
        GOTO Boot.Error
    END IF
END IF

' store time values hh:mm:ss
HourTemp = VAL(MID$(File.Time$, 1, 2))
MinuteTemp = VAL(MID$(File.Time$, 4, 2))
SecondTemp = VAL(MID$(File.Time$, 7, 2))

' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = INSTR(UCASE$(Command.Line), "/D")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    D$ = MID$(Command.Line, Imbedded + 2, 21)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 23)
    IF LEN(D$) <> 21 THEN
        GOTO Boot.Error
    END IF
    IF MID$(D$, 11, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    S$ = RIGHT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    IF Search.From.Date < False OR Search.To.Date < False THEN
        GOTO Boot.Error
    END IF
END IF
Imbedded = INSTR(UCASE$(Command.Line), "/T")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    T$ = MID$(Command.Line, Imbedded + 2, 17)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 19)
    IF LEN(T$) <> 17 THEN
        GOTO Boot.Error
    END IF
    IF MID$(T$, 9, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.From.Time = T1! * 2048 + T2! * 32
    S$ = RIGHT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.To.Time = T1! * 2048 + T2! * 32
    IF Search.From.Time < False OR Search.To.Time < False THEN
        GOTO Boot.Error
    END IF
END IF

' get file size from command line
Search.File.Size = False
Search.Size.From = FalseD
Search.Size.To = FalseD
Imbedded = INSTR(UCASE$(Command.Line), "/F")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Search.File.Size = True
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Search.Size.From = Var#
    IF MID$(Command.Line, Imbedded, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    GOSUB Get.Numeric
    Search.Size.To = Var#
    Search.Size.From = Search.Size.From * 1024#
    Search.Size.To = Search.Size.To * 1024#
END IF

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
IF Creation.Time = False THEN
    IF Access.Time = False THEN
        IF Modified.Time = False THEN
            Modified.Time = True
        END IF
    END IF
END IF

' check command line switch
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Nested.Recurse = CINT(Var#)
END IF

' parse special debug switch.
Debug.Mode = ParseLine("/=")

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' reset work variables
Files.Counter = False
Quit.Searching = False
   
' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GOSUB Header

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF
    Command.Line = LTRIM$(Command.Line)
    Command.Line = RTRIM$(Command.Line)

    ' store current drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
        Command.Work = MID$(Command.Work, 3)
    ELSE
        Drive.Search = Current.Drive$
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' store current directory
    Directory.Search$ = ""
    Imbedded1 = INSTR(Command.Work, "\")
    Imbedded2 = Imbedded1
    WHILE Imbedded1
        Imbedded2 = Imbedded1
        Imbedded1 = INSTR(Imbedded1 + 1, Command.Work, "\")
    WEND
    IF Imbedded2 THEN
        Directory.Search$ = LEFT$(Command.Work, Imbedded2)
        Command.Work = MID$(Command.Work, Imbedded2 + 1)
    END IF
    IF Directory.Search$ = "" THEN
        IF LEFT$(Current.Directory, 2) = "\\" THEN
            Directory.Search$ = Current.Directory
        ELSE
            IF Drive.Search = Current.Drive$ THEN
                Directory.Search$ = MID$(Current.Directory, 3)
            ELSE
                Directory.Search$ = "\"
            END IF
        END IF
    END IF
    IF RIGHT$(Directory.Search$, 1) <> "\" THEN
        Directory.Search$ = Directory.Search$ + "\"
    END IF
   
    ' get filename spec
    Filename.Search$ = Command.Work
    IF Filename.Search$ = NUL THEN
        Filename.Search$ = "*.*"
    END IF
    Command.Work = NUL

    ' display search filename
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        IF LEFT$(Directory.Search$, 2) = "\\" THEN
            PRINT "Searching: " + Directory.Search$ + Filename.Search$
        ELSE
            PRINT "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
        END IF
    END IF

    ' call routine to search for files
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$, Filename.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Drive.Search$, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$, Filename.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

End.Touch:

' display end program
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    PRINT "Files touched ";
    PRINT FormatString$(Files.Counted)
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Touch v1.0a: File date/time update utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Touch [d:][\pathname\][filename][//ahosx][/cdfjnprtuvyz][/123][/56789]"
PRINT "Where:"
PRINT "   d:\pathname\filename is the search directory."
PRINT "   /c  continuous display       /u  prepend drive letter"
PRINT "   /j  display directories      /v  don't display filenames"
PRINT "   /nxxx  recurse override      /y  remove trailing slash"
PRINT "   /p  don't prompt to touch    /z  suppress error messages"
PRINT "   /r  recurse directories      /=  set debug mode"
PRINT "   /0  create file if not exist"
PRINT "   file override switches:"
PRINT "     /5mm/dd/yyyy  override touch file date"
PRINT "     /6hh:mm:ss    override touch file time"
PRINT "     /7  touch creation date/time"
PRINT "     /8  touch last access date/time"
PRINT "     /9  touch last modified (write) date/time"
PRINT "   display ranges: (/1  creation, /2  last access  /3  modify time)"
PRINT "     /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
PRINT "     /t  is range of file times in form hh:mm:ss-hh:mm:ss"
PRINT "     /f  is range of file sizes in form xxx-xxx in kilobytes"
PRINT "   display file attributes:"
PRINT "     // prefix for files with, / prefix for files without,"
PRINT "       a  archive, h  hidden, o  read-only, s  system, x  none"
PRINT "       m1  compressed, m2  encrypted"
COLOR Plain, Black
RETURN

Get.Numeric:
Var# = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var# = Var# * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Touch /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Touch v1.0a: File date/time update utility; "
END IF
RETURN

' critical error trap
Error.Routine:
Data.Error = ERR
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
IF BreakIS THEN
    Outpt$ = "q"
END IF
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Touch
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access directories
SUB Directories (Directory.Search$, Filename.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory filename
ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN
    ' search directory names
    CALL Filenames(Directory.Search$, Filename.Search$)

    ' check to recurse directories
    IF Recurse.Directories THEN

        ' recurse directories
        DO
            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            IF (Attribute AND &H10) = &H10 THEN

                ' store directory name
                Directory$ = finddata.cFileName
                Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

                ' check directory name
                IF Directory$ <> "." AND Directory$ <> ".." THEN
                    ' make next search directory
                    Next.Directory$ = Directory.Search$ + Directory$ + "\"

                    ' recursively search subdirectories
                    CALL Directories(Next.Directory$, Filename.Search$)
                END IF
            END IF

            ' check to quit
            IF Quit.Searching THEN
                EXIT DO
            END IF
        LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    END IF
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to access filenames in directory
SUB Filenames (Directory.Search$, Filename.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make filename
ASCIIZ = Directory.Search$ + Filename.Search$ + CHR$(0)

Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' check directory attribute
    Attribute = finddata.dwFileAttributes

    ' check for directory
    IF (Attribute AND &H10) = &H10 THEN
        ' display directory being searched
        CALL DisplayDirectory(Directory.Search$)
    END IF

    ' recurse filename
    DO
        ' store filename
        Filename$ = finddata.cFileName
        Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN

            ' store file data
            finddatatemp = finddata

            ' store file size
            File.Size = finddata.nFileSizeHigh * &H100000000~&& OR finddata.nFileSizeLow

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            IF (Attribute AND &H10) <> &H10 THEN
                CALL DisplayFiles(Directory.Search$, Filename$)
            END IF
        END IF

        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to display directory
SUB DisplayDirectory (Directory.Search$)
IF Display.Search THEN
    Filename$ = Directory.Search$
    IF Filename$ <> "\" THEN
        IF Remove.Slash THEN
            Slash = LEN(Filename$)
            Filename$ = LEFT$(Filename$, Slash - 1)
        END IF
    END IF
    IF Prepend.Drive THEN
        IF LEFT$(Filename$, 2) <> "\\" THEN
            Filename$ = Drive.Search + ":" + Filename$
        END IF
    END IF
    COLOR Green, Black
    PRINT Filename$
END IF
END SUB

' subroutine to count and display filenames
SUB DisplayFiles (Directory.Search$, Filename.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG

' check directory attribute
Attribute = finddatatemp.dwFileAttributes

' check for readonly file
IF (Attribute AND &H1) = &H1 THEN
    IF No.Display.Readonly THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Readonly THEN
        EXIT SUB
    END IF
END IF

' check for hidden file
IF (Attribute AND &H2) = &H2 THEN
    IF No.Display.Hidden THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Hidden THEN
        EXIT SUB
    END IF
END IF

' check for system file
IF (Attribute AND &H4) = &H4 THEN
    IF No.Display.System THEN
        EXIT SUB
    END IF
ELSE
    IF Display.System THEN
        EXIT SUB
    END IF
END IF

' check for archive file
IF (Attribute AND &H20) = &H20 THEN
    IF No.Display.Archive THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Archive THEN
        EXIT SUB
    END IF
END IF

' check for compressed file
IF (Attribute AND &H800) = &H800 THEN
    IF No.Display.Compress THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Compress THEN
        EXIT SUB
    END IF
END IF

' check for encrypted file
IF (Attribute AND &H4000) = &H4000 THEN
    IF No.Display.Encrypt THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Encrypt THEN
        EXIT SUB
    END IF
END IF

' check all attributes
IF Display.Any THEN
    IF (Attribute AND &H1) = &H1 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H2) = &H2 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H4) = &H4 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H20) = &H20 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H800) = &H800 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H4000) = &H4000 THEN
        EXIT SUB
    END IF
END IF
IF No.Display.Any THEN
    IF (Attribute AND &H1) = False THEN
        IF (Attribute AND &H2) = False THEN
            IF (Attribute AND &H4) = False THEN
                IF (Attribute AND &H20) = False THEN
                    IF (Attribute AND &H800) = False THEN
                        IF (Attribute AND &H4000) = False THEN
                            EXIT SUB
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF

' check file size
IF Search.File.Size THEN
    IF Search.Size.From = FalseD AND Search.Size.To = FalseD THEN
        IF File.Size <> FalseD THEN
            EXIT SUB
        END IF
    ELSE
        IF Search.Size.From > FalseD OR Search.Size.To > FalseD THEN
            IF Search.Size.From > FalseD THEN
                IF Search.Size.To = FalseD THEN
                    IF File.Size < Search.Size.From THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
            IF Search.Size.From = FalseD THEN
                IF Search.Size.To > FalseD THEN
                    IF File.Size > Search.Size.To THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
            IF Search.Size.From <= Search.Size.To THEN
                IF File.Size < Search.Size.From OR File.Size > Search.Size.To THEN
                    EXIT SUB
                END IF
            END IF
            IF Search.Size.From > Search.Size.To THEN
                IF File.Size < Search.Size.From AND File.Size > Search.Size.To THEN
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
END IF

' store file date and time
IF Creation.Time THEN
    x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
    GOSUB Convert.Date
    GOSUB Convert.Time
ELSE
    IF Access.Time THEN
        x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
        GOSUB Convert.Date
        GOSUB Convert.Time
    ELSE
        IF Modified.Time THEN
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
            GOSUB Convert.Date
            GOSUB Convert.Time
        END IF
    END IF
END IF

' check date\time range
IF Search.From.Date OR Search.To.Date THEN
    IF File.Work.Date < Search.From.Date THEN
        EXIT SUB
    END IF
    IF File.Work.Date > Search.To.Date THEN
        EXIT SUB
    END IF
END IF
IF Search.From.Time OR Search.To.Time THEN
    IF File.Work.Time < Search.From.Time THEN
        EXIT SUB
    END IF
    IF File.Work.Time > Search.To.Time THEN
        EXIT SUB
    END IF
END IF

' touch filename
CALL TouchFile(Directory.Search$, Filename.Search$)
EXIT SUB

Convert.Date:
YearTempX! = SysTime.wYear
MonthTempX! = SysTime.wMonth
DayTempX! = SysTime.wDay
File.Date$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wMonth)), 2) + "-"
File.Date$ = File.Date$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wDay)), 2) + "-"
File.Date$ = File.Date$ + LTRIM$(STR$(SysTime.wYear))
File.Work.Date = ((YearTempX! - 1980) * 512) + MonthTempX! * 32 + DayTempX!
RETURN

Convert.Time:
HourTempX! = SysTime.wHour
MinuteTempX! = SysTime.wMinute
SecondsTempX! = SysTime.wSecond
File.Time$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wHour)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wMinute)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wSecond)), 2)
File.Work.Time = HourTempX! * 2048 + MinuteTempX! * 32 + SecondsTempX!
RETURN
END SUB

' subroutine to touch date/time of a file
SUB TouchFile (Directory.Search$, Filename.Search$)
DIM ASCIIZ AS STRING * 260
DIM hfind AS _OFFSET

' make filename
ASCIIZ = Directory.Search$ + Filename.Search$ + CHR$(0)

' check for prompting
IF Prompt.Files = False THEN
    Prompt$ = "Touch " + Filename.Search$ + "(y/n/c/q)?"
    CALL MorePrompt(Prompt$, "yncq", Outpt$)
    SELECT CASE Outpt$
        CASE "c"
            Prompt.Files = True
        CASE "n"
            EXIT SUB
        CASE "q"
            Quit.Searching = True
            EXIT SUB
    END SELECT
END IF

' display filename
IF Display.Filenames = 0 THEN
    Filename$ = Directory.Search$ + Filename.Search$
    IF Prepend.Drive THEN
        IF LEFT$(Filename$, 2) <> "\\" THEN
            Filename$ = Drive.Search + ":" + Filename$
        END IF
    END IF
    COLOR Yellow, Black
    PRINT Filename$
END IF

' get source filename date/time.
hfind = CreateFile(ASCIIZ, &H180, &H3, 0, 3, 0, 0)
IF hfind <> INVALID_HANDLE_VALUE THEN
    x = GetFileTime&(hfind, SourceCreateDate, SourceAccessDate, SourceModifyDate)
    ' display any errors.
    IF x = 0 THEN
        IF Debug.Mode THEN
            Var$ = "Error (0x" + HEX$(GetLastError&) + ") reading filename date/time."
            CALL DisplayError(Var$)
        END IF
    END IF

    ' store default date/time.
    CreateDate = SourceCreateDate
    AccessDate = SourceAccessDate
    ModifyDate = SourceModifyDate

    ' store override date/time.
    GOSUB GetSysDate
    IF Override.Create.Date THEN
        x = SystemTimeToFileTime&(SysTime, CreateDate)
    END IF
    IF Override.Access.Date THEN
        x = SystemTimeToFileTime&(SysTime, AccessDate)
    END IF
    IF Override.Modify.Date THEN
        x = SystemTimeToFileTime&(SysTime, ModifyDate)
    END IF

    ' set the destination filename date/time.
    x = SetFileTime&(hfind, CreateDate, AccessDate, ModifyDate)
    ' display any errors.
    IF x = 0 THEN
        IF Debug.Mode THEN
            Var$ = "Error (0x" + HEX$(GetLastError&) + ") touching filename date/time."
            CALL DisplayError(Var$)
        END IF
    END IF
    x = CloseHandle(hfind)
ELSE
    Var$ = "Error (0x" + HEX$(GetLastError&) + ") opening filename."
    CALL DisplayError(Var$)
END IF

' update files counter
Files.Counted = Files.Counted + 1#
EXIT SUB

GetSysDate:
' store override variables
SysTime.wMonth = MonthTemp
SysTime.wDay = DayTemp
SysTime.wYear = YearTemp
SysTime.wHour = HourTemp
SysTime.wMinute = MinuteTemp
SysTime.wSecond = SecondTemp
RETURN
END SUB

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
x$ = ""
s$ = STR$(s#)
IF INSTR(s$, "D") THEN ' return string
    FormatString$ = s$
    EXIT FUNCTION
END IF
IF LEFT$(s$, 1) = "-" THEN ' store sign
    e$ = "-"
    s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
    q$ = MID$(s$, INSTR(s$, "."))
    s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

'handle& = CreateFile(f$, &H180, 0, 0, 1, 0, 0)
' parameters:
'   (1) pointer to filename
'   (2) access:
'     x80(128)  - read
'     x100(256) - write
'   (3) sharing
'   (4) security attributes
'   (5) create:
'     1 CREATE_NEW    = create only if not exist
'     2 CREATE_ALWAYS = always create new file
'     3 OPEN_EXISTING = open only if exists
'     4 OPEN_ALWAYS   = open file always
'     5 TRUNCATE_EXISTING = open/truncate to 0 only if exists
'   (6) - flags (standard OSHA)

