REM file: Touchdir.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "TOUCHDIR"

' define boolean values
CONST True = -1
CONST TrueD = -1#
CONST False = 0
CONST FalseD = 0#
CONST FalseS = 0!
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Magenta = 12
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare filename variables
DIM SHARED Current.Drive AS STRING * 1
DIM SHARED Drive.Search AS STRING * 1
DIM SHARED Current.Directory AS STRING

' declare work variables
DIM SHARED Files.Counter AS INTEGER, Quit.Searching AS INTEGER
DIM SHARED Continuous.Display AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Remove.Slash AS INTEGER, Prepend.Drive AS INTEGER
DIM SHARED Nested.Levels AS INTEGER, Nested.Recurse AS INTEGER

' declare search work variables
DIM SHARED Search.From.Date AS SINGLE, Search.To.Date AS SINGLE
DIM SHARED Search.From.Time AS SINGLE, Search.To.Time AS SINGLE
DIM SHARED File.Size AS DOUBLE, Recurse.Directories AS INTEGER
DIM SHARED Display.Hidden AS INTEGER, Display.System AS INTEGER
DIM SHARED Display.Readonly AS INTEGER, Display.Archive AS INTEGER
DIM SHARED Display.Any AS INTEGER, No.Display.Archive AS INTEGER
DIM SHARED No.Display.Readonly AS INTEGER, No.Display.System AS INTEGER
DIM SHARED No.Display.Hidden AS INTEGER, No.Display.Any AS INTEGER
DIM SHARED Debug.Mode AS INTEGER, Prompt.Files AS INTEGER

' declare count variables
DIM SHARED Dirs.Counted AS DOUBLE
DIM SHARED Files.Counted AS DOUBLE
DIM SHARED Display.Search AS INTEGER
DIM SHARED Display.Filenames AS INTEGER

' declare file date\time and filesize work variables
DIM SHARED File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
DIM SHARED Search.Size.From AS DOUBLE, Search.Size.To AS DOUBLE
DIM SHARED Search.File.Size, Creation.Time AS INTEGER
DIM SHARED Access.Time AS INTEGER, Modified.Time AS INTEGER
DIM SHARED Short.Display AS INTEGER, Truncate.Slash AS INTEGER
DIM SHARED Strip.Drive AS INTEGER, Short.Filenames AS INTEGER
DIM SHARED Display.Lowercase AS INTEGER

' declare date\time work variables
DIM SHARED HourTemp AS INTEGER, MinuteTemp AS INTEGER, SecondTemp AS INTEGER
DIM SHARED MonthTemp AS INTEGER, DayTemp AS INTEGER, YearTemp AS INTEGER

' declare file date/time override work varibles
DIM SHARED Override.Create.Date AS INTEGER
DIM SHARED Override.Access.Date AS INTEGER
DIM SHARED Override.Modify.Date AS INTEGER

' declare attribute switches
DIM SHARED Search.Archive AS INTEGER, Search.Hidden AS INTEGER
DIM SHARED Search.Readonly AS INTEGER, Search.System AS INTEGER
DIM SHARED Search.Compress AS INTEGER, Search.Encrypt AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1
CONST FILE_FLAG_BACKUP_SEMANTICS = &H02000000 ' CreateFile directory flag

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)

    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
    FUNCTION RemoveDirectoryA% (F$)
    FUNCTION CreateDirectoryA% (F$, X$)

    FUNCTION CloseHandle& (BYVAL hfile AS _OFFSET)
    FUNCTION GetFileTime& (BYVAL hFile AS _OFFSET, lpCreationTime AS FILETIME, lpLastAccessTime AS FILETIME, lpLastWriteTime AS FILETIME)
    FUNCTION SetFileTime& (BYVAL hFile AS _OFFSET, lpCreationTime AS FILETIME, lpLastAccessTime AS FILETIME, lpLastWriteTime AS FILETIME)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION SystemTimeToFileTime& (lpSystemTime AS SYSTEMTIME, lpFileTime AS FILETIME)

    FUNCTION GetLastError& ()
    FUNCTION FormatMessageA& (BYVAL f AS LONG, f$, BYVAL e AS LONG, BYVAL d AS LONG, g$, s AS LONG, h$)
END DECLARE

DECLARE LIBRARY
    FUNCTION CreateFile%& (filename$, BYVAL access&, BYVAL sharing&, BYVAL sec_attr%&, BYVAL create&, BYVAL flags&, BYVAL template%&)
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED CreateDate AS FILETIME
DIM SHARED AccessDate AS FILETIME
DIM SHARED ModifyDate AS FILETIME

DIM SHARED SourceCreateDate AS FILETIME
DIM SHARED SourceAccessDate AS FILETIME
DIM SHARED SourceModifyDate AS FILETIME

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING
DIM SHARED finddatatemp AS WIN32_FIND_DATAA

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' command line input loop
Command.Line = COMMAND$
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' get current drive/directory
Current.Drive = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' reset counters
Dirs.Counted = False
Display.Lines = False
Continuous.Display = False
Quit.Searching = False

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "Dir spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)

' check command line switches
Search.Archive = ParseLine("/A")
Search.Hidden = ParseLine("/H")
Search.Readonly = ParseLine("/O")
Search.System = ParseLine("/S")
Search.Compress = ParseLine("/J")
Search.Encrypt = ParseLine("/K")

Display.Filenames = ParseLine("/B")
Continuous.Display = ParseLine("/C")
Short.Display = ParseLine("/E")
Truncate.Slash = ParseLine("/G")
Prompt.Files = ParseLine("/P")
Strip.Drive = ParseLine("/Q")
Recurse.Directories = ParseLine("/R")
Prepend.Drive = ParseLine("/U")
Short.Filenames = ParseLine("/V")
Display.Lowercase = ParseLine("/Y")
Display.Errors = ParseLine("/Z")

' read date override switch
File.Date$ = DATE$
Imbedded = INSTR(UCASE$(Command.Line), "/5")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    File.Date$ = MID$(Command.Line, Imbedded + 2, 10)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 12)
    IF LEN(File.Date$) <> 10 THEN
        GOTO Boot.Error
    END IF
END IF

' store date values
MonthTemp = VAL(MID$(File.Date$, 1, 2))
DayTemp = VAL(MID$(File.Date$, 4, 2))
YearTemp = VAL(MID$(File.Date$, 7, 4))

' read time override switch
File.Time$ = TIME$
Imbedded = INSTR(UCASE$(Command.Line), "/6")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    File.Time$ = MID$(Command.Line, Imbedded + 2, 8)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 10)
    IF LEN(File.Time$) <> 8 THEN
        GOTO Boot.Error
    END IF
END IF

' store time values hh:mm:ss
HourTemp = VAL(MID$(File.Time$, 1, 2))
MinuteTemp = VAL(MID$(File.Time$, 4, 2))
SecondTemp = VAL(MID$(File.Time$, 7, 2))

' read override switches.
Override.Create.Date = ParseLine("/7")
Override.Access.Date = ParseLine("/8")
Override.Modify.Date = ParseLine("/9")

' parse special debug switch.
Debug.Mode = ParseLine("/=")

' get nested switch from command line
Nested.Levels = 256%
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Nested.Recurse = Var%
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF

' check trailing command line
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
IF Display.Header = False THEN
    IF Continuous.Display = False THEN
        COLOR White, Black
        GOSUB Header
    END IF
END IF

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF

    ' store search drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
    ELSE
        Drive.Search = Current.Drive
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' store current directory
    Directory.Search$ = Command.Work

    ' parse drive letter
    Temp.Directory$ = Directory.Search$
    IF MID$(Temp.Directory$, 2, 1) = ":" THEN
        Temp.Drive$ = UCASE$(LEFT$(Temp.Directory$, 1))
        Temp.Directory$ = MID$(Temp.Directory$, 3)
    ELSE
        Temp.Drive$ = Drive.Search
    END IF

    ' parse directory
    IF LEFT$(Temp.Directory$, 2) <> "\\" THEN
        IF LEFT$(Temp.Directory$, 1) <> "\" THEN
            IF Temp.Drive$ <> LEFT$(Current.Directory, 1) THEN
                Directory.Search$ = Drive.Search + ":\" + Temp.Directory$
            ELSE
                Directory.Search$ = Current.Directory + Temp.Directory$
            END IF
        ELSE
            Directory.Search$ = Temp.Drive$ + ":" + Temp.Directory$
        END IF
    END IF

    ' display search header
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        Display.Lines = Display.Lines + 1
        PRINT "Searching: " + Directory.Search$
    END IF

    ' call subroutine to search directories
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Temp.Drive$, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

End.Touchdir:

' display counters
IF Continuous.Display = False THEN
    IF Wide.Display THEN
        IF Display.Length THEN
            PRINT
        END IF
    END IF
    COLOR Yellow, Black
    PRINT "Directories counted"; Dirs.Counted
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Touchdir v1.0a: Directory date/time update utility;"
END IF
RETURN

Get.Numeric:
Var% = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var% = Var% * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Touchdir v1.0a: Directory date/time update utility;"
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Touchdir [d:]\path\ [/ahos][/cdptxz][/56789]"
PRINT "Where:"
PRINT "   /b  don't display files   /p  don't prompt to touch"
PRINT "   /c  continuous display    /q  strip drive letter"
PRINT "   /e  don't display path    /u  prepend drive letter"
PRINT "   /g  remove slash          /v  display short filenames"
PRINT "   /r  recurse directories   /y  display lowercase file"
PRINT "   /z  suppress errors       /nxxx  recurse levels override"
PRINT "   file override switches:"
PRINT "     /5mm/dd/yyyy  override touch file date"
PRINT "     /6hh:mm:ss    override touch file time"
PRINT "     /7  touch creation date/time"
PRINT "     /8  touch last access date/time"
PRINT "     /9  touch last modified (write) date/time"
PRINT "   Only touch files with bits:"
PRINT "     /a  archive   /h  hidden   /o  read-only   /s  system"
PRINT "     /j  compressed  /k  encrypted"
COLOR Plain, Black
RETURN
END

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Touchdir /? for help."
COLOR Plain, Black
END

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    RESUME NEXT
END IF
IF Wide.Display THEN
    IF Display.Length THEN
        Display.Length = False
        PRINT
    END IF
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        RESUME End.Touchdir
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access directories
SUB Directories (Directory.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET
DIM Recurse.Temp AS INTEGER

' reset wildcard flag
Wild = 0

' make directory filename
Temp.Dir$ = Directory.Search$
Recurse.Temp = Recurse.Directories
IF Recurse.Directories THEN
    IF INSTR(Temp.Dir$, "?") OR INSTR(Temp.Dir$, "*") THEN
        ' Recurse.Temp = False
    ELSE
        IF RIGHT$(Temp.Dir$, 1) <> "\" THEN
            Temp.Dir$ = Temp.Dir$ + "\"
        END IF
        Temp.Dir$ = Temp.Dir$ + "*.*"
    END IF
END IF
ASCIIZ = Temp.Dir$ + CHR$(0)

' find first long filename
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))

' check findirst error
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' filename/directory loop
    DO
        ' get file attributes
        Attribute = finddata.dwFileAttributes

        ' check directory attribute
        IF (Attribute AND &H10) = &H10 THEN

            ' store directory name
            Directory$ = finddata.cFileName
            V = INSTR(Directory$, CHR$(0))
            IF V THEN Directory$ = LEFT$(Directory$, V - 1)

            ' check directory name
            IF Directory$ <> "." AND Directory$ <> ".." THEN
                ' check unicode
                IF INSTR(Directory$, "?") THEN
                    Directory$ = finddata.cAlternateFileName
                    V = INSTR(Directory$, CHR$(0))
                    IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                END IF

                ' check to recurse directories
                IF Recurse.Temp = 0 THEN

                    ' display directory
                    GOSUB Display.Directory
                END IF

                ' check to recurse directories
                IF Recurse.Temp THEN

                    ' display directory
                    GOSUB Display.Directory

                    ' check recursion levels
                    Recursion% = True
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels + 1
                        IF Nested.Levels >= Nested.Recurse THEN
                            Recursion% = False
                        END IF
                    END IF

                    ' recursively search subdirectories
                    IF Recursion% THEN
                        CALL Directories(Next.Directory$)
                    END IF
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels - 1
                    END IF
                END IF
            END IF
        END IF

        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
EXIT SUB

Display.Directory:
' retract one directory if wildcard/global characters in trailing path
IF INSTR(Directory.Search$, "?") OR INSTR(Directory.Search$, "*") THEN
    Wild = -1
    FOR V = LEN(Directory.Search$) TO 1 STEP -1
        IF MID$(Directory.Search$, V, 1) = "\" THEN
            Directory.Search$ = LEFT$(Directory.Search$, V)
            EXIT FOR
        END IF
    NEXT
END IF

' make next search directory
IF RIGHT$(Directory.Search$, 1) <> "\" THEN
    Next.Directory$ = Directory.Search$ + "\" + Directory$
ELSE
    Next.Directory$ = Directory.Search$ + Directory$
END IF

' store directory name
Temp.Directory$ = finddata.cFileName
V = INSTR(Temp.Directory$, CHR$(0))
IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)

IF Temp.Directory$ = NUL THEN
    RETURN
END IF
IF Temp.Directory$ = "." THEN
    RETURN
END IF
IF Temp.Directory$ = ".." THEN
    RETURN
END IF

' construct directory for display
IF Recurse.Directories = 0 THEN
    IF Wild THEN
        IF RIGHT$(Directory.Search$, 1) <> "\" THEN
            Temp.Directory$ = Directory.Search$ + "\" + Directory$
        ELSE
            Temp.Directory$ = Directory.Search$ + Directory$
        END IF
    ELSE
        Temp.Directory$ = Directory.Search$
    END IF
ELSE
    Temp.Directory$ = Next.Directory$
    Wild = -1
END IF

' get short filename
IF Short.Filenames THEN
    Temp.Directory$ = finddata.cAlternateFileName
    V = INSTR(Temp.Directory$, CHR$(0))
    IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)
    IF Temp.Directory$ = NUL THEN
        Temp.Directory$ = finddata.cFileName
        V = INSTR(Temp.Directory$, CHR$(0))
        IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)
    END IF
END IF

' check directory attribute
Valid.Attribute = True

' check for read-only file
IF Search.Readonly THEN
    IF (Attribute AND &H1) <> &H1 THEN
        Valid.Attribute = False
    END IF
END IF

' check for hidden file
IF Search.Hidden THEN
    IF (Attribute AND &H2) <> &H2 THEN
        Valid.Attribute = False
    END IF
END IF

' check for system file
IF Search.System THEN
    IF (Attribute AND &H4) <> &H4 THEN
        Valid.Attribute = False
    END IF
END IF

' check for archive file
IF Search.Archive THEN
    IF (Attribute AND &H20) <> &H20 THEN
        Valid.Attribute = False
    END IF
END IF

' check for compressed file
IF Search.Compress THEN
    IF (Attribute AND &H800) <> &H800 THEN
        Valid.Attribute = False
    END IF
END IF

' check for compressed file
IF Search.Encrypt THEN
    IF (Attribute AND &H4000) <> &H4000 THEN
        Valid.Attribute = False
    END IF
END IF

' check for valid directory
IF Valid.Attribute THEN

    ' store directory name
    Outpt$ = RTRIM$(Temp.Directory$)
    IF Short.Display THEN
        IF RIGHT$(Outpt$, 1) = "\" THEN
            Outpt$ = LEFT$(Outpt$, LEN(Outpt$) - 1)
        END IF
        FOR Imbedded = LEN(Outpt$) TO 1 STEP -1
            IF MID$(Outpt$, Imbedded, 1) = "\" THEN
                Outpt$ = MID$(Outpt$, Imbedded + 1)
                EXIT FOR
            END IF
        NEXT
    END IF
    IF Truncate.Slash THEN
        IF Outpt$ <> "\" THEN
            IF RIGHT$(Outpt$, 1) = "\" THEN
                Outpt$ = LEFT$(Outpt$, LEN(Outpt$) - 1)
            END IF
        END IF
    END IF
    IF Short.Filenames = False OR Short.Display THEN
        IF MID$(Outpt$, 2, 1) <> ":" THEN
            IF LEFT$(Directory.Search$, 2) <> "\\" THEN
                Outpt$ = Drive.Search + ":" + Outpt$
            END IF
        END IF
    END IF
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        IF MID$(Outpt$, 2, 1) = ":" THEN
            Outpt$ = MID$(Outpt$, 3)
        END IF
    END IF
    IF Strip.Drive THEN
        IF MID$(Outpt$, 2, 1) = ":" THEN
            Outpt$ = MID$(Outpt$, 3)
        END IF
    END IF
    IF Prepend.Drive THEN
        IF LEFT$(Outpt$, 2) <> "\\" THEN
            IF MID$(Outpt$, 2, 1) <> ":" THEN
                Outpt$ = Drive.Search + ":" + Outpt$
            END IF
        END IF
    END IF
    IF Display.Lowercase THEN
        Outpt$ = LCASE$(Outpt$)
    END IF
    IF Append.Slash THEN
        IF RIGHT$(Outpt$, 1) <> "\" THEN
            Outpt$ = Outpt$ + "\"
        END IF
    END IF

    ' check slash switch
    IF Append.Slash THEN
        IF RIGHT$(Outpt$, 1) <> "\" THEN
            Outpt$ = Outpt$ + "\"
        END IF
    END IF

    ' store full directory pathname
    CALL TouchFile(Temp.Directory$, Outpt$)
END IF
RETURN
END SUB

' subroutine to touch date/time of a file
SUB TouchFile (Directory.Search$, Outpt$)
DIM ASCIIZ AS STRING * 260
DIM hfind AS _OFFSET

' make filename
ASCIIZ = Directory.Search$ + CHR$(0)

' check for prompting
IF Prompt.Files = False THEN
    Prompt$ = "Touch " + Outpt$ + "(y/n/c/q)?"
    CALL MorePrompt(Prompt$, "yncq", OutptX$)
    SELECT CASE OutptX$
        CASE "c"
            Prompt.Files = True
        CASE "n"
            EXIT SUB
        CASE "q"
            Quit.Searching = True
            EXIT SUB
    END SELECT
END IF

' display filename
IF Display.Filenames = 0 THEN
    COLOR Yellow, Black
    PRINT Outpt$
END IF

' get source filename date/time.
hfind = CreateFile(ASCIIZ, &H180, &H3, 0, 3, FILE_FLAG_BACKUP_SEMANTICS, 0)
IF hfind <> INVALID_HANDLE_VALUE THEN
    x = GetFileTime&(hfind, SourceCreateDate, SourceAccessDate, SourceModifyDate)
    ' display any errors.
    IF x = 0 THEN
        IF Debug.Mode THEN
            Var$ = "Error (0x" + HEX$(GetLastError&) + ") reading filename date/time."
            CALL DisplayError(Var$)
            CALL DisplayWinError(x)
        END IF
    END IF

    IF x THEN
        ' increment directories counted
        Dirs.Counted = Dirs.Counted + 1!
    END IF

    ' store default date/time.
    CreateDate = SourceCreateDate
    AccessDate = SourceAccessDate
    ModifyDate = SourceModifyDate

    ' store override date/time.
    IF Override.Create.Date THEN
        GOSUB GetSysDate
        x = SystemTimeToFileTime&(SysTime, CreateDate)
        ' display any errors.
        IF x = 0 THEN
            IF Debug.Mode THEN
                Var$ = "Error (0x" + HEX$(GetLastError&) + ") touching filename create date/time."
                CALL DisplayError(Var$)
                CALL DisplayWinError(x)
            END IF
        END IF
    END IF
    IF Override.Access.Date THEN
        GOSUB GetSysDate
        x = SystemTimeToFileTime&(SysTime, AccessDate)
        ' display any errors.
        IF x = 0 THEN
            IF Debug.Mode THEN
                Var$ = "Error (0x" + HEX$(GetLastError&) + ") touching filename access date/time."
                CALL DisplayError(Var$)
                CALL DisplayWinError(x)
            END IF
        END IF
    END IF
    IF Override.Modify.Date THEN
        GOSUB GetSysDate
        x = SystemTimeToFileTime&(SysTime, ModifyDate)
        ' display any errors.
        IF x = 0 THEN
            IF Debug.Mode THEN
                Var$ = "Error (0x" + HEX$(GetLastError&) + ") touching filename modify date/time."
                CALL DisplayError(Var$)
                CALL DisplayWinError(x)
            END IF
        END IF
    END IF

    ' set the destination filename date/time.
    x = SetFileTime&(hfind, CreateDate, AccessDate, ModifyDate)
    ' display any errors.
    IF x = 0 THEN
        IF Debug.Mode THEN
            Var$ = "Error (0x" + HEX$(GetLastError&) + ") touching filename date/time."
            CALL DisplayError(Var$)
            CALL DisplayWinError(x)
        END IF
    END IF
    x = CloseHandle(hfind)
ELSE
    Var$ = "Error (0x" + HEX$(GetLastError&) + ") opening filename."
    CALL DisplayError(Var$)
    CALL DisplayWinError(x)
END IF
EXIT SUB

GetSysDate:
' store override variables
SysTime.wMonth = MonthTemp
SysTime.wDay = DayTemp
SysTime.wYear = YearTemp
SysTime.wHour = HourTemp
SysTime.wMinute = MinuteTemp
SysTime.wSecond = SecondTemp
RETURN
END SUB

' prompt for more
SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
DO
    DO
        _LIMIT 50
        LOCATE , , 1
        Input.Char$ = INKEY$
        IF LEN(Input.Char$) THEN
            EXIT DO
        END IF
    LOOP
    Input.Char$ = LCASE$(Input.Char$)
    IF INSTR(Input.Mask$, Input.Char$) THEN
        PRINT Input.Char$
        Output.String$ = Input.Char$
        EXIT DO
    END IF
LOOP
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' displays error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' displays windows error
SUB DisplayWinError (x)
' define error message space
DIM m AS STRING * 32767
' check display errors flag
IF Display.Errors = False THEN
    ' call windows error message routine
    x& = FormatMessageA&(&H1200, "", GetLastError, 0, m$, 260, "")
    IF x& THEN
        COLOR Red, Black
        PRINT LEFT$(m$, x& - 2)
    END IF
END IF
END SUB

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

