REM file: Treedel.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "TREEDEL"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' initialize drive variables
DIM SHARED Drive.Number AS INTEGER
DIM SHARED Current.Drive AS STRING * 1
DIM SHARED Current.Directory AS STRING

' declare work variables
DIM SHARED Continuous.Display AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Prompt.Delete AS INTEGER, Quit.Searching AS INTEGER
DIM SHARED Display.Lowercase AS INTEGER, Short.Display AS INTEGER
DIM SHARED Windows.Detected AS INTEGER, Add.Slash AS INTEGER

' declare attribute variables
DIM SHARED No.Touch.Archive AS INTEGER, No.Touch.Hidden AS INTEGER
DIM SHARED No.Touch.Readonly AS INTEGER, No.Touch.System AS INTEGER
DIM SHARED No.Touch.Any AS INTEGER, Touch.Any AS INTEGER
DIM SHARED Touch.Archive AS INTEGER, Touch.Hidden AS INTEGER
DIM SHARED Touch.Readonly AS INTEGER, Touch.System AS INTEGER

DIM SHARED No.Touch.Encrypt AS INTEGER, Touch.Encrypt AS INTEGER
DIM SHARED No.Touch.Compress AS INTEGER, Touch.Compress AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
    FUNCTION GetDiskFreeSpaceExA& (filename$, free AS _UNSIGNED _INTEGER64, total AS _UNSIGNED _INTEGER64, free2 AS _UNSIGNED _INTEGER64)
    FUNCTION DeleteFileA% (F$)
    FUNCTION RemoveDirectoryA% (F$)
    FUNCTION SetCurrentDirectoryA% (f$)
    FUNCTION GetLastError& ()
END DECLARE

DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING
DIM SHARED finddatatemp AS WIN32_FIND_DATAA

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' get command line
Command.Line = RTRIM$(COMMAND$)
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' get current drive
Current.Drive = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "Dir spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' get switches from command line
No.Touch.Archive = ParseLine("//A")
No.Touch.Hidden = ParseLine("//H")
No.Touch.Readonly = ParseLine("//O")
No.Touch.System = ParseLine("//S")
No.Touch.Any = ParseLine("//Y")

No.Touch.Compress = ParseLine("//M1")
No.Touch.Encrypt = ParseLine("//M2")

Touch.Archive = ParseLine("/A")
Touch.Hidden = ParseLine("/H")
Touch.Readonly = ParseLine("/O")
Touch.System = ParseLine("/S")
Touch.Any = ParseLine("/Y")

Touch.Compress = ParseLine("/M1")
Touch.Encrypt = ParseLine("/M2")

Continuous.Display = ParseLine("/C")
Short.Display = ParseLine("/D")
Prompt.Delete = ParseLine("/P")
Display.Lowercase = ParseLine("/U")
Add.Slash = ParseLine("/X")
Display.Errors = ParseLine("/Z")

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' set searching work variables
Quit.Searching = False

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF

    ' store search drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search$ = LEFT$(Command.Work, 1)
    ELSE
        Drive.Search$ = Current.Drive
    END IF
    Drive.Search$ = UCASE$(Drive.Search$)

    ' store current directory
    Directory.Search$ = Command.Work

    ' parse drive letter
    Temp.Directory$ = Directory.Search$
    IF MID$(Temp.Directory$, 2, 1) = ":" THEN
        Temp.Drive$ = UCASE$(LEFT$(Temp.Directory$, 1))
        Temp.Directory$ = MID$(Temp.Directory$, 3)
    ELSE
        Temp.Drive$ = Drive.Search$
    END IF

    ' parse directory
    IF LEFT$(Temp.Directory$, 2) <> "\\" THEN
        IF LEFT$(Temp.Directory$, 1) <> "\" THEN
            IF Temp.Drive$ <> LEFT$(Current.Directory, 1) THEN
                Directory.Search$ = Drive.Search$ + ":\" + Temp.Directory$
            ELSE
                Directory.Search$ = Current.Directory + Temp.Directory$
            END IF
        ELSE
            Directory.Search$ = Temp.Drive$ + ":" + Temp.Directory$
        END IF
    END IF

    ' display search header
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        Display.Lines = Display.Lines + 1
        PRINT "Searching: " + Directory.Search$
    END IF

    ' call subroutine to search directories
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL TreeDirectories(Directory.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Temp.Drive$, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL TreeDirectories(Directory.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

End.Treedel:

' display end program
IF Continuous.Display = False THEN
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Treedel v1.0a: Directory delete utility; "
END IF
RETURN

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Treedel v1.0a: Directory delete utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Treedel [d:]\path\ [//ahosy][/cdpuyz]"
PRINT "Where:"
PRINT "   /c  continuous display"
PRINT "   /d  short file display"
PRINT "   /p  don't prompt before deleting"
PRINT "   /u  display lowercase"
PRINT "   /y  add trailing slash"
PRINT "   /z  suppress error messages"
PRINT "   delete directories with attributes:"
PRINT "     // prefix to not delete directories with,"
PRINT "     / prefix to delete directories only with,"
PRINT "       a  archive, h  hidden, o  read-only, s  system, y  none"
PRINT "       m1  compressed, m2  encrypted"
COLOR Plain, Black
RETURN
END

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Treedel /? for help."
COLOR Plain, Black
END

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Treedel
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access directories
SUB TreeDirectories (Directory.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory filename
ASCIIZ = Directory.Search$ + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' loop directories
    DO
        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF

        ' store directory attribute
        Attribute = finddata.dwFileAttributes

        ' check directory
        IF (Attribute AND &H10) = &H10 THEN

            ' check directory attributes
            CALL CheckAttribute(Attribute, Check)
            IF Check = 0 THEN

                ' store directory name
                Directory$ = finddata.cFileName
                Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

                ' check directory name
                IF Directory$ <> "." AND Directory$ <> ".." THEN

                    ' make directory
                    FOR Imbedded = LEN(Directory.Search$) TO 1 STEP -1
                        IF MID$(Directory.Search$, Imbedded, 1) = "\" THEN
                            Directory$ = LEFT$(Directory.Search$, Imbedded) + Directory$
                            EXIT FOR
                        END IF
                    NEXT

                    ' store short filename
                    IF INSTR(Directory$, "?") THEN
                        Directory$ = finddata.cAlternateFileName
                        V = INSTR(Directory$, CHR$(0))
                        IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                        IF Directory$ = NUL THEN
                            EXIT DO
                        END IF
                    END IF

                    ' prepare directory
                    IF RIGHT$(Directory$, 1) <> "\" THEN
                        Directory$ = Directory$ + "\"
                    END IF

                    ' check to prompt
                    Delete.Flag = False
                    IF Prompt.Delete = False THEN
                        Prompt$ = Directory$
                        IF Display.Lowercase THEN
                            Prompt$ = LCASE$(Prompt$)
                        END IF
                        Prompt$ = "Delete subdirectories in " + Prompt$
                        Prompt2$ = ""
                        IF (Attribute AND &H20) = &H20 THEN
                            Prompt2$ = Prompt2$ + "/a"
                        END IF
                        IF (Attribute AND &H1) = &H1 THEN
                            Prompt2$ = Prompt2$ + "/o"
                        END IF
                        IF (Attribute AND &H2) = &H2 THEN
                            Prompt2$ = Prompt2$ + "/h"
                        END IF
                        IF (Attribute AND &H4) = &H4 THEN
                            Prompt2$ = Prompt2$ + "/s"
                        END IF
                        IF (Attribute AND &H800) = &H800 THEN
                            Prompt2$ = Prompt2$ + "/c"
                        END IF
                        IF (Attribute AND &H4000) = &H4000 THEN
                            Prompt2$ = Prompt2$ + "/e"
                        END IF
                        IF LEN(Prompt2$) THEN
                            Prompt$ = Prompt$ + "{" + MID$(Prompt2$, 2) + "}"
                        END IF
                        Prompt$ = Prompt$ + "(y/n/c/q)?"
                        CALL MorePrompt(Prompt$, "yncq", Outpt$)
                        SELECT CASE Outpt$
                            CASE "c"
                                Prompt.Delete = True
                            CASE "n"
                                Delete.Flag = True
                            CASE "q"
                                Quit.Searching = True
                                EXIT DO
                        END SELECT
                    END IF

                    ' check to continue deleteing
                    IF Delete.Flag = False THEN
                        ' store directory filename
                        Temp.Dir$ = LEFT$(Directory$, LEN(Directory$) - 1)

                        ' display directory
                        IF Short.Display THEN
                            IF LEFT$(Temp.Dir$, 2) <> "\\" THEN
                                Temp.Dir$ = MID$(Temp.Dir$, 3)
                            END IF
                        END IF
                        IF Display.Lowercase THEN
                            Temp.Dir$ = LCASE$(Temp.Dir$)
                        END IF
                        IF Add.Slash THEN
                            Temp.Dir$ = Temp.Dir$ + "\"
                        END IF
                        COLOR Yellow, Black
                        IF Continuous.Display = False THEN
                            PRINT "Deleting: " + Temp.Dir$
                        ELSE
                            PRINT Temp.Dir$
                        END IF

                        ' routine to delete directories
                        CALL Directories(Directory$)
                    END IF
                END IF
            END IF
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to access subdirectories
SUB Directories (Directory.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory filename
ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' delete filenames
    CALL DeleteFiles(Directory.Search$)

    ' recurse subdirectories
    DO
        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF

        ' check directory attribute
        Attribute = finddata.dwFileAttributes

        ' check directory
        IF (Attribute AND &H10) = &H10 THEN

            ' store directory name
            Directory$ = finddata.cFileName
            Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

            ' check directory name
            IF Directory$ <> "." AND Directory$ <> ".." THEN

                ' store short filename
                IF INSTR(Directory$, "?") THEN
                    Directory$ = finddata.cAlternateFileName
                    V = INSTR(Directory$, CHR$(0))
                    IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                END IF

                ' make next search directory
                IF LEN(Directory$) THEN
                    Next.Directory$ = Directory.Search$ + Directory$ + "\"

                    ' recursively search subdirectories
                    CALL Directories(Next.Directory$)
                END IF
            END IF
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF

' delete directory
CALL DeleteDirectory(Directory.Search$)
END SUB

' subroutine to delete an empty directory
SUB DeleteDirectory (Directory$)
' declare subroutine variables
DIM ASCIIZ AS STRING * 260

' store directory filename
Var$ = Directory$
Var$ = LEFT$(Var$, LEN(Var$) - 1)
ASCIIZ = Var$ + CHR$(0)

' change directory attribute
AttrX& = GetFileAttributes(ASCIIZ)
AttrX& = AttrX& AND NOT &H1 ' remove read-only bit
x = SetFileAttributes&(ASCIIZ, AttrX&)

' delete directory
x = RemoveDirectoryA(ASCIIZ)

' display any errors
IF x = 0 THEN
    IF GetLastError = &H91 THEN ' ignore directory not empty
        Eat$ = NUL
    ELSE
        Var1$ = "Error 0x" + HEX$(GetLastError) + " deleting directory: " + Var$
        CALL DisplayError(Var1$)
    END IF
END IF
END SUB

' subroutine to delete files in a directory
SUB DeleteFiles (Directory$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM ASCIIZ2 AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make filename
ASCIIZ = Directory$ + "*.*" + CHR$(0)

Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' filename loop
    DO
        ' store filename
        Filename$ = finddata.cFileName
        Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN
            ' store filename
            ASCIIZ2 = Directory$ + Filename$ + CHR$(0)

            ' change filename attribute
            AttrX& = GetFileAttributes(ASCIIZ2)
            AttrX& = AttrX& AND NOT &H1 ' remove read-only bit
            x = SetFileAttributes&(ASCIIZ2, AttrX&)

            ' delete long filename
            x = DeleteFileA(ASCIIZ2)

            ' check error and delete 8.3 filename
            IF x = 0 THEN
                Short.Filename$ = finddata.cAlternateFileName
                V = INSTR(Short.Filename$, CHR$(0))
                IF V THEN Short.Filename$ = LEFT$(Short.Filename$, V - 1)
                ASCIIZ2 = Directory$ + Short.Filename$ + CHR$(0)

                ' change filename attribute
                AttrX& = GetFileAttributes(ASCIIZ2)
                AttrX& = AttrX& AND NOT &H1
                x = SetFileAttributes&(ASCIIZ2, AttrX&)

                ' delete short filename
                x = DeleteFileA(ASCIIZ2)
            END IF
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

SUB CheckAttribute (Attribute&, Check)
Check = False
' check for readonly file
IF Touch.Readonly THEN
    IF (Attribute& AND &H1) <> &H1 THEN
        Check = True
        EXIT SUB
    END IF
END IF
IF No.Touch.Readonly THEN
    IF (Attribute& AND &H1) = &H1 THEN
        Check = True
        EXIT SUB
    END IF
END IF

' check for hidden file
IF Touch.Hidden THEN
    IF (Attribute& AND &H2) <> &H2 THEN
        Check = True
        EXIT SUB
    END IF
END IF
IF No.Touch.Hidden THEN
    IF (Attribute& AND &H2) = &H2 THEN
        Check = True
        EXIT SUB
    END IF
END IF

' check for system file
IF Touch.System THEN
    IF (Attribute& AND &H4) <> &H4 THEN
        Check = True
        EXIT SUB
    END IF
END IF
IF No.Touch.System THEN
    IF (Attribute& AND &H4) = &H4 THEN
        Check = True
        EXIT SUB
    END IF
END IF

' check for archive file
IF Touch.Archive THEN
    IF (Attribute& AND &H20) <> &H20 THEN
        Check = True
        EXIT SUB
    END IF
END IF
IF No.Touch.Archive THEN
    IF (Attribute& AND &H20) = &H20 THEN
        Check = True
        EXIT SUB
    END IF
END IF

' check for compress file
IF Touch.Compress THEN
    IF (Attribute& AND &H800) <> &H800 THEN
        Check = True
        EXIT SUB
    END IF
END IF
IF No.Touch.Compress THEN
    IF (Attribute& AND &H800) = &H800 THEN
        Check = True
        EXIT SUB
    END IF
END IF

' check for encyrpted file
IF Touch.Encrypt THEN
    IF (Attribute& AND &H4000) <> &H4000 THEN
        Check = True
        EXIT SUB
    END IF
END IF
IF No.Touch.Encrypt THEN
    IF (Attribute& AND &H4000) = &H4000 THEN
        Check = True
        EXIT SUB
    END IF
END IF

' check for no attributes
IF Touch.Any THEN
    IF (Attribute& AND &H1) = &H1 THEN
        Check = True
        EXIT SUB
    END IF
    IF (Attribute& AND &H2) = &H2 THEN
        Check = True
        EXIT SUB
    END IF
    IF (Attribute& AND &H4) = &H4 THEN
        Check = True
        EXIT SUB
    END IF
    IF (Attribute& AND &H20) = &H20 THEN
        Check = True
        EXIT SUB
    END IF
    IF (Attribute& AND &H800) = &H800 THEN
        Check = True
        EXIT SUB
    END IF
    IF (Attribute& AND &H4000) = &H4000 THEN
        Check = True
        EXIT SUB
    END IF
END IF
IF No.Touch.Any THEN
    IF (Attribute& AND &H1) = &H0 THEN
        IF (Attribute& AND &H2) = &H0 THEN
            IF (Attribute& AND &H4) = &H0 THEN
                IF (Attribute& AND &H20) = &H0 THEN
                    IF (Attribute& AND &H800) = &H0 THEN
                        IF (Attribute& AND &H4000) = &H0 THEN
                            Check = True
                            EXIT SUB
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF
END SUB

' prompt for more
SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
DO
    DO
        _LIMIT 50
        LOCATE , , 1
        Input.Char$ = INKEY$
        IF LEN(Input.Char$) THEN
            EXIT DO
        END IF
    LOOP
    Input.Char$ = LCASE$(Input.Char$)
    IF INSTR(Input.Mask$, Input.Char$) THEN
        PRINT Input.Char$
        Output.String$ = Input.Char$
        EXIT DO
    END IF
LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

