REM file: Delete.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "DELETE"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST Yellow = 14
CONST White = 15

' initialize drive variables
DIM SHARED Drive.Number AS INTEGER
DIM SHARED Current.Drive AS INTEGER
DIM SHARED Current.Directory AS STRING

' declare work variables
DIM SHARED Continuous.Display AS INTEGER, Files.Deleted AS DOUBLE
DIM SHARED Total.Bytes AS DOUBLE, File.Size AS DOUBLE
DIM SHARED Prompt.Delete AS INTEGER, Continuous.Delete AS INTEGER

' declare search work variables
DIM SHARED File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
DIM SHARED Search.Size.From AS DOUBLE, Search.Size.To AS DOUBLE
DIM SHARED Search.From.Date AS SINGLE, Search.To.Date AS SINGLE
DIM SHARED Search.From.Time AS SINGLE, Search.To.Time AS SINGLE
DIM SHARED Search.File.Size, Creation.Time AS INTEGER
DIM SHARED Access.Time AS INTEGER, Modified.Time AS INTEGER

' declare recurse work variables
DIM SHARED Recurse.Directories AS INTEGER
DIM SHARED Quit.Deleting AS INTEGER

' declare delete work variables
DIM SHARED Delete.Hidden AS INTEGER, Delete.System AS INTEGER
DIM SHARED Delete.Readonly AS INTEGER, Delete.Archive AS INTEGER
DIM SHARED Dont.Delete.Hidden AS INTEGER, Dont.Delete.System AS INTEGER
DIM SHARED Dont.Delete.Readonly AS INTEGER, Dont.Delete.Archive AS INTEGER
DIM SHARED Dont.Delete.Any AS INTEGER, Delete.Any AS INTEGER

DIM SHARED Dont.Delete.Encrypt AS INTEGER, Delete.Encrypt AS INTEGER
DIM SHARED Dont.Delete.Compress AS INTEGER, Delete.Compress AS INTEGER

DIM SHARED Delete.File AS INTEGER, Display.Lowercase AS INTEGER
DIM SHARED Display.Errors AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
    FUNCTION GetDiskFreeSpaceExA& (filename$, free AS _UNSIGNED _INTEGER64, total AS _UNSIGNED _INTEGER64, free2 AS _UNSIGNED _INTEGER64)
    FUNCTION GetLastError& ()

    FUNCTION DeleteFileA% (F$)
    FUNCTION RemoveDirectoryA% (F$)
    FUNCTION CreateDirectoryA% (F$, X$)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING
DIM SHARED finddatatemp AS WIN32_FIND_DATAA

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' store command line
Command.Line = RTRIM$(Read.COMMAND$)
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' get current drive
Current.Drive = ASC(LEFT$(_CWD$, 1)) - 65
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "File spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' get attribute bit switches
Delete.Archive = ParseLine("//A")
Delete.Hidden = ParseLine("//H")
Delete.Readonly = ParseLine("//O")
Delete.System = ParseLine("//S")
Delete.Any = ParseLine("//X")

Dont.Delete.Archive = ParseLine("/A")
Dont.Delete.Hidden = ParseLine("/H")
Dont.Delete.Readonly = ParseLine("/O")
Dont.Delete.System = ParseLine("/S")
Dont.Delete.Any = ParseLine("/X")

Delete.Compress = ParseLine("//M1")
Delete.Encrypt = ParseLine("//M2")

Dont.Delete.Compress = ParseLine("/M1")
Dont.Delete.Encrypt = ParseLine("/M2")

' get switches from command line
Continuous.Display = ParseLine("/C")
Prompt.Delete = ParseLine("/P")
Recurse.Directories = ParseLine("/R")
Display.Lowercase = ParseLine("/U")
Display.Errors = ParseLine("/Z")

' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = INSTR(UCASE$(Command.Line), "/D")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    D$ = MID$(Command.Line, Imbedded + 2, 21)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 23)
    IF LEN(D$) <> 21 THEN
        GOTO Boot.Error
    END IF
    IF MID$(D$, 11, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    S$ = RIGHT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    IF Search.From.Date < False OR Search.To.Date < False THEN
        GOTO Boot.Error
    END IF
END IF
Imbedded = INSTR(UCASE$(Command.Line), "/T")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    T$ = MID$(Command.Line, Imbedded + 2, 17)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 19)
    IF LEN(T$) <> 17 THEN
        GOTO Boot.Error
    END IF
    IF MID$(T$, 9, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.From.Time = T1! * 2048 + T2! * 32 + T3!
    S$ = RIGHT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.To.Time = T1! * 2048 + T2! * 32 + T3!
    IF Search.From.Time < False OR Search.To.Time < False THEN
        GOTO Boot.Error
    END IF
END IF

' get file size from command line
Search.File.Size = False
Search.Size.From = FalseD
Search.Size.To = FalseD
Imbedded = INSTR(UCASE$(Command.Line), "/F")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Search.File.Size = True
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Search.Size.From = Var#
    IF MID$(Command.Line, Imbedded, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    GOSUB Get.Numeric
    Search.Size.To = Var#
    Search.Size.From = Search.Size.From * 1024#
    Search.Size.To = Search.Size.To * 1024#
END IF

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
IF Creation.Time = False THEN
    IF Access.Time = False THEN
        IF Modified.Time = False THEN
            Modified.Time = True
        END IF
    END IF
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' initialize some variables
Continuous.Delete = False
Files.Deleted = FalseD
Total.Bytes = FalseD
Quit.Deleting = False

' store command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GOSUB Header

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF
    Command.Line = LTRIM$(Command.Line)
    Command.Line = RTRIM$(Command.Line)

    ' store current drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Number = ASC(UCASE$(LEFT$(Command.Work, 1))) - 65
        Command.Work = MID$(Command.Work, 3)
    ELSE
        Drive.Number = Current.Drive
    END IF

    ' store current directory
    Directory.Search$ = ""
    Imbedded1 = INSTR(Command.Work, "\")
    Imbedded2 = Imbedded1
    WHILE Imbedded1
        Imbedded2 = Imbedded1
        Imbedded1 = INSTR(Imbedded1 + 1, Command.Work, "\")
    WEND
    IF Imbedded2 THEN
        Directory.Search$ = LEFT$(Command.Work, Imbedded2)
        Command.Work = MID$(Command.Work, Imbedded2 + 1)
    END IF
    IF Directory.Search$ = "" THEN
        IF LEFT$(Current.Directory, 2) = "\\" THEN
            Directory.Search$ = Current.Directory
        ELSE
            IF Drive.Number = Current.Drive THEN
                Directory.Search$ = MID$(Current.Directory, 3)
            ELSE
                Directory.Search$ = "\"
            END IF
        END IF
    END IF
    IF RIGHT$(Directory.Search$, 1) <> "\" THEN
        Directory.Search$ = Directory.Search$ + "\"
    END IF
   
    ' get filename spec
    Filename.Search$ = Command.Work
    IF Filename.Search$ = NUL THEN
        Filename.Search$ = "*.*"
    END IF
    Command.Work = NUL
   
    ' display search filename
    IF Continuous.Display = False THEN
        Prompt$ = Directory.Search$ + Filename.Search$
        IF Display.Lowercase THEN
            Prompt$ = LCASE$(Prompt$)
        END IF
        COLOR Yellow, Black
        IF LEFT$(Prompt$, 2) <> "\\" THEN
            Prompt$ = CHR$(Drive.Number + 65) + ":" + Prompt$
        END IF
        Prompt$ = "Searching: " + Prompt$
        PRINT Prompt$
    END IF

    ' call routine to search for files
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$, Filename.Search$)
    ELSE
        V = Drive.Number + 1
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$, Filename.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Deleting THEN
        EXIT DO
    END IF
LOOP

End.Delete:

' display end program
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    Total$ = "Files deleted "
    Total$ = Total$ + FormatString$(Files.Deleted)
    Total$ = Total$ + " Total bytes deleted "
    Total$ = Total$ + FormatString$(Total.Bytes)
    PRINT Total$
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Delete v1.0a: File delete utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Delete [d:\path\filename.ext][//ahosx][/cdfprtuz]"
PRINT "Where:"
PRINT "   /c  continuous display   /p  do not prompt before deleting"
PRINT "   /r  recurse directories  /u  display files in lowercase"
PRINT "   /z  suppress error messages"
PRINT "   display ranges: (/1  creation, /2  last access  /3  modify time)"
PRINT "     /d  range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
PRINT "     /t  range of file times in form hh:mm:ss-hh:mm:ss"
PRINT "     /f  range of file size xxx-xxx in kilobytes"
PRINT "   delete file attributes:"
PRINT "     // prefix for files with, / prefix for files without,"
PRINT "       a  archive, h  hidden, o  read-only, s  system, x  none"
PRINT "       m1  compressed, m2  encrypted"
COLOR Plain, Black
RETURN
END

Get.Numeric:
Var# = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var# = Var# * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Delete /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Delete v1.0a: File delete utility; "
END IF
RETURN
   
' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Delete
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to delete a filename
SUB DeleteFiles (Directory$, Filename$)
' declare subroutine variables
DIM ASCIIZ AS STRING * 260
DIM Attribute AS _UNSIGNED LONG

' get file attributes
Attribute = finddatatemp.dwFileAttributes

' reset delete flag
Delete.File = True

' check for directory
IF (Attribute AND &H10) = &H10 THEN
    EXIT SUB
END IF

' check for read-only file
IF (Attribute AND &H1) = &H1 THEN
    IF Dont.Delete.Readonly THEN
        EXIT SUB
    END IF
ELSE
    IF Delete.Readonly THEN
        EXIT SUB
    END IF
END IF

' check for hidden file
IF (Attribute AND &H2) = &H2 THEN
    IF Dont.Delete.Hidden THEN
        EXIT SUB
    END IF
ELSE
    IF Delete.Hidden THEN
        EXIT SUB
    END IF
END IF

' check for system file
IF (Attribute AND &H4) = &H4 THEN
    IF Dont.Delete.System THEN
        EXIT SUB
    END IF
ELSE
    IF Delete.System THEN
        EXIT SUB
    END IF
END IF

' check for archive file
IF (Attribute AND &H20) = &H20 THEN
    IF Dont.Delete.Archive THEN
        EXIT SUB
    END IF
ELSE
    IF Delete.Archive THEN
        EXIT SUB
    END IF
END IF

' check for compressed file
IF (Attribute AND &H800) = &H800 THEN
    IF Dont.Delete.Compress THEN
        EXIT SUB
    END IF
ELSE
    IF Delete.Compress THEN
        EXIT SUB
    END IF
END IF

' check for encrypted file
IF (Attribute AND &H4000) = &H4000 THEN
    IF Dont.Delete.Encrypt THEN
        EXIT SUB
    END IF
ELSE
    IF Delete.Encrypt THEN
        EXIT SUB
    END IF
END IF

' check all bits
IF Delete.Any THEN
    IF (Attribute AND &H1) = &H1 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H2) = &H2 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H4) = &H4 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H20) = &H20 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H800) = &H800 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H4000) = &H4000 THEN
        EXIT SUB
    END IF
END IF
IF Dont.Delete.Any THEN
    IF (Attribute AND &H1) = False THEN
        IF (Attribute AND &H2) = False THEN
            IF (Attribute AND &H4) = False THEN
                IF (Attribute AND &H20) = False THEN
                    IF (Attribute AND &H800) = False THEN
                        IF (Attribute AND &H4000) = False THEN
                            EXIT SUB
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF

' check file size
IF Search.File.Size THEN
    IF Search.Size.From = FalseD AND Search.Size.To = FalseD THEN
        IF File.Size <> FalseD THEN
            EXIT SUB
        END IF
    ELSE
        IF Search.Size.From > FalseD OR Search.Size.To > FalseD THEN
            IF Search.Size.From > FalseD THEN
                IF Search.Size.To = FalseD THEN
                    IF File.Size < Search.Size.From THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
            IF Search.Size.From = FalseD THEN
                IF Search.Size.To > FalseD THEN
                    IF File.Size > Search.Size.To THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
            IF Search.Size.From <= Search.Size.To THEN
                IF File.Size < Search.Size.From OR File.Size > Search.Size.To THEN
                    EXIT SUB
                END IF
            END IF
            IF Search.Size.From > Search.Size.To THEN
                IF File.Size < Search.Size.From AND File.Size > Search.Size.To THEN
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
END IF

' store file date and time
IF Creation.Time THEN
    x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
    GOSUB Convert.Date
    GOSUB Convert.Time
ELSE
    IF Access.Time THEN
        x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
        GOSUB Convert.Date
        GOSUB Convert.Time
    ELSE
        IF Modified.Time THEN
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
            GOSUB Convert.Date
            GOSUB Convert.Time
        END IF
    END IF
END IF

' check date\time range
IF Search.From.Date OR Search.To.Date THEN
    IF File.Work.Date < Search.From.Date THEN
        Delete.File = False
    END IF
    IF File.Work.Date > Search.To.Date THEN
        Delete.File = False
    END IF
END IF
IF Search.From.Time OR Search.To.Time THEN
    IF File.Work.Time < Search.From.Time THEN
        Delete.File = False
    END IF
    IF File.Work.Time > Search.To.Time THEN
        Delete.File = False
    END IF
END IF

' check delete flag
IF Delete.File THEN
    ' check delete type
    IF Continuous.Delete = False THEN
        ' check for prompt to delete
        IF Prompt.Delete THEN
            ' display filename
            Outpt$ = Directory$ + Filename$
            IF Display.Lowercase THEN
                Outpt$ = LCASE$(Outpt$)
            END IF
            COLOR Yellow, Black
            PRINT Outpt$
        ELSE
            ' prompt to delete
            Prompt$ = Directory$ + Filename$
            IF Display.Lowercase THEN
                Prompt$ = LCASE$(Prompt$)
            END IF
            IF LEFT$(Prompt$, 2) <> "\\" THEN
                Prompt$ = CHR$(Drive.Number + 65) + ":" + Prompt$
            END IF
            Prompt2$ = ""
            IF (Attribute AND &H20) = &H20 THEN
                Prompt2$ = Prompt2$ + "/a"
            END IF
            IF (Attribute AND &H1) = &H1 THEN
                Prompt2$ = Prompt2$ + "/o"
            END IF
            IF (Attribute AND &H2) = &H2 THEN
                Prompt2$ = Prompt2$ + "/h"
            END IF
            IF (Attribute AND &H4) = &H4 THEN
                Prompt2$ = Prompt2$ + "/s"
            END IF
            IF (Attribute AND &H800) = &H800 THEN
                Prompt2$ = Prompt2$ + "/c"
            END IF
            IF (Attribute AND &H4000) = &H4000 THEN
                Prompt2$ = Prompt2$ + "/e"
            END IF
            IF LEN(Prompt2$) THEN
                Prompt$ = Prompt$ + "{" + MID$(Prompt2$, 2) + "}"
            END IF
            Prompt$ = "Delete file " + Prompt$ + "(y/n/q/c)?"
            CALL MorePrompt(Prompt$, "ynqc", Outpt$)
            SELECT CASE Outpt$
                CASE "n"
                    Delete.File = False
                CASE "q"
                    Delete.File = False
                    Quit.Deleting = True
                CASE "c"
                    Continuous.Delete = True
            END SELECT
        END IF
    END IF

    ' check delete file flag
    IF Delete.File THEN
        ' make filename
        ASCIIZ = Directory$ + Filename$ + CHR$(0)

        ' change filename attribute
        AttrX = GetFileAttributes(ASCIIZ)
        AttrX = AttrX AND NOT &H1
        x = SetFileAttributes&(ASCIIZ, AttrX)

        ' delete long filename
        x = DeleteFileA(ASCIIZ)

        ' check error and delete 8.3 filename
        IF x = 0 THEN
            Short.Filename$ = finddatatemp.cAlternateFileName
            V = INSTR(Short.Filename$, CHR$(0))
            IF V THEN Short.Filename$ = LEFT$(Short.Filename$, V - 1)
            ASCIIZ = Directory$ + Short.Filename$ + CHR$(0)

            ' change filename attribute
            AttrX = GetFileAttributes(ASCIIZ)
            AttrX = AttrX AND NOT &H1
            x = SetFileAttributes&(ASCIIZ, AttrX)

            ' delete short filename
            x = DeleteFileA(ASCIIZ)
        END IF

        ' display any errors
        IF x = 0 THEN
            CALL DisplayError("Error 0x" + HEX$(GetLastError) + " deleting filename.")
        ELSE
            ' check display type
            IF Prompt.Delete = False THEN
                IF Continuous.Display = False THEN
                    Prompt$ = Directory$ + Filename$
                    IF Display.Lowercase THEN
                        Prompt$ = LCASE$(Prompt$)
                    END IF
                    COLOR Yellow, Black
                    IF LEFT$(Prompt$, 2) <> "\\" THEN
                        Prompt$ = CHR$(Drive.Number + 65) + ":" + Prompt$
                    END IF
                    Prompt$ = "Deleting: " + Prompt$
                    PRINT Prompt$
                END IF
            END IF
            ' update counters
            Files.Deleted = Files.Deleted + 1#
            Total.Bytes = Total.Bytes + File.Size
        END IF
    END IF
END IF
EXIT SUB

Convert.Date:
YearTemp! = SysTime.wYear
MonthTemp! = SysTime.wMonth
DayTemp! = SysTime.wDay
File.Date$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wMonth)), 2) + "-"
File.Date$ = File.Date$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wDay)), 2) + "-"
File.Date$ = File.Date$ + LTRIM$(STR$(SysTime.wYear))
File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
RETURN

Convert.Time:
HourTemp! = SysTime.wHour
MinuteTemp! = SysTime.wMinute
SecondsTemp! = SysTime.wSecond
File.Time$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wHour)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wMinute)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wSecond)), 2)
File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
RETURN
END SUB

' subroutine to access directories
SUB Directories (Directory.Search$, Filename.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory filename
ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' search directory names
    CALL Filenames(Directory.Search$, Filename.Search$)

    ' check to recurse directories
    IF Recurse.Directories THEN

        ' recurse directories
        DO
            ' check to quit
            IF Quit.Deleting THEN
                EXIT DO
            END IF

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            IF (Attribute AND &H10) = &H10 THEN
                ' store directory name
                Directory$ = finddata.cFileName
                Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

                ' check directory name
                IF Directory$ <> "." AND Directory$ <> ".." THEN

                    ' check unicode
                    IF INSTR(Directory$, "?") THEN
                        Directory$ = finddata.cAlternateFileName
                        V = INSTR(Directory$, CHR$(0))
                        IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                    END IF

                    ' make next search directory
                    Next.Directory$ = Directory.Search$ + Directory$ + "\"

                    ' recursively search subdirectories
                    CALL Directories(Next.Directory$, Filename.Search$)
                END IF
            END IF
        LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    END IF
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to delete filenames in directory
SUB Filenames (Directory.Search$, Filename.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make filename
ASCIIZ = Directory.Search$ + Filename.Search$ + CHR$(0)

Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' recurse filename
    DO

        ' store filename
        Filename$ = finddata.cFileName
        Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN
            ' store file size
            File.Size = finddata.nFileSizeHigh * &H100000000~&& OR finddata.nFileSizeLow

            ' store file data
            finddatatemp = finddata

            ' delete filename
            CALL DeleteFiles(Directory.Search$, Filename$)
        END IF

        ' check to quit
        IF Quit.Deleting THEN
            EXIT DO
        END IF

    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
x$ = ""
s$ = STR$(s#)
IF INSTR(s$, "D") THEN ' return string
    FormatString$ = s$
    EXIT FUNCTION
END IF
IF LEFT$(s$, 1) = "-" THEN ' store sign
    e$ = "-"
    s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
    q$ = MID$(s$, INSTR(s$, "."))
    s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


