REM file: Encrypt.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "ENCRYPT"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare attribute variables
DIM SHARED Set.Archive AS INTEGER, Set.Hidden AS INTEGER
DIM SHARED Set.Readonly AS INTEGER, Set.System AS INTEGER
DIM SHARED Clear.Archive AS INTEGER, Clear.Hidden AS INTEGER
DIM SHARED Clear.Readonly AS INTEGER, Clear.System AS INTEGER

' declare search work variables
DIM SHARED Continuous.Display AS INTEGER, Display.Filenames AS INTEGER
DIM SHARED Recurse.Directories AS INTEGER
DIM SHARED Quit.Searching AS INTEGER, Display.Errors AS INTEGER

' initialize drive work variables
DIM SHARED Drive.Search AS STRING * 1
DIM SHARED Crypted.Count AS DOUBLE, Crypted.Count2 AS DOUBLE
DIM SHARED Drive.Number AS INTEGER, Dirs.Counted AS DOUBLE
DIM SHARED Search.Drive AS INTEGER, Files.Counted AS DOUBLE
DIM SHARED Volumes.Counted AS INTEGER, Current.Directory AS STRING
DIM SHARED Lines.Counted AS INTEGER, More.Display AS INTEGER

' declare nest recursion variables
DIM SHARED Nested.Recurse AS INTEGER, Nested.Levels AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
    FUNCTION EncryptFileA (f$)
    FUNCTION DecryptFileA (f$, BYVAL f&)
END DECLARE

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED finddatatemp AS WIN32_FIND_DATAA
DIM SHARED DriveType AS STRING

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' command line input loop
Command.Line = Read.Command$
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' reset count variables
Crypted.Count = 0#
Crypted.Count2 = 0#
Dirs.Counted = 0#
Files.Counted = 0#
Display.Lines = False
Continuous.Display = False
Quit.Searching = False

' get current drive
Current.Drive$ = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "File spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)

' check command line switches
Set.Archive = ParseLine("//A")
Set.Hidden = ParseLine("//H")
Set.Readonly = ParseLine("//O")
Set.System = ParseLine("//S")
Clear.Archive = ParseLine("/A")
Clear.Hidden = ParseLine("/H")
Clear.Readonly = ParseLine("/O")
Clear.System = ParseLine("/S")
Continuous.Display = ParseLine("/C")
Recurse.Directories = ParseLine("/R")
Display.Filenames = ParseLine("/X")
Display.Errors = ParseLine("/Z")
More.Display = Continuous.Display

' get nested switch from command line
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Nested.Recurse = CINT(Var#)
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
IF Display.Header = False THEN
    IF Continuous.Display = False THEN
        COLOR White, Black
        GOSUB Header
    END IF
END IF

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF

    ' store current drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
        Command.Work = MID$(Command.Work, 3)
    ELSE
        Drive.Search = Current.Drive$
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' store current directory
    Directory.Search$ = ""
    Imbedded1 = INSTR(Command.Work, "\")
    Imbedded2 = Imbedded1
    WHILE Imbedded1
        Imbedded2 = Imbedded1
        Imbedded1 = INSTR(Imbedded1 + 1, Command.Work, "\")
    WEND
    IF Imbedded2 THEN
        Directory.Search$ = LEFT$(Command.Work, Imbedded2)
        Command.Work = MID$(Command.Work, Imbedded2 + 1)
    END IF
    IF Directory.Search$ = "" THEN
        IF LEFT$(Current.Directory, 2) = "\\" THEN
            Directory.Search$ = Current.Directory
        ELSE
            IF Drive.Search = Current.Drive$ THEN
                Directory.Search$ = MID$(Current.Directory, 3)
            ELSE
                Directory.Search$ = "\"
            END IF
        END IF
    END IF
    IF RIGHT$(Directory.Search$, 1) <> "\" THEN
        Directory.Search$ = Directory.Search$ + "\"
    END IF
   
    ' get filename spec
    Filename.Search$ = Command.Work
    IF Filename.Search$ = NUL THEN
        Filename.Search$ = "*.*"
    END IF
    Command.Work = NUL
   
    ' display search filename
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        IF LEFT$(Directory.Search$, 2) = "\\" THEN
            PRINT "Searching: " + Directory.Search$ + Filename.Search$
        ELSE
            PRINT "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
        END IF
        Lines.Counted = Lines.Counted + 1
    END IF

    ' call routine to search for files
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$, Filename.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Drive.Search$, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$, Filename.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

End.Encrypt:

' display counters
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    Total$ = FormatString$(Dirs.Counted)
    PRINT "Directories counted " + Total$
    Total$ = FormatString$(Files.Counted)
    PRINT "Files counted " + Total$

    Total$ = FormatString$(Crypted.Count2)
    PRINT "Directories encrypted " + Total$

    Total$ = FormatString$(Crypted.Count)
    PRINT "Files encrypted " + Total$

    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

Boot.Usage:
' make header
COLOR White, Black
PRINT "Encrypt v1.0a: File/directory encrypt utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Encrypt [d:][\path\]filename.ext [//ahos][/cnrxz]"
PRINT "Where:"
PRINT "   Set file bits:"
PRINT "     //a  archive   //h  hidden   //o  read-only   //s  system"
PRINT "   Clear file bits:"
PRINT "     /a  archive    /h  hidden    /o  read-only    /s  system"
PRINT "Remaining switches:"
PRINT "     /c  continuous display       /x  don't display filename"
PRINT "     /r  recurse directories      /z  don't display errors"
PRINT "     /n### override nested directories"
COLOR Plain, Black
RETURN

Get.Numeric:
Var# = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var# = Var# * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Encrypt /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Encrypt v1.0a: File/directory encrypt utility;"
END IF
RETURN

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Encrypt
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access directories
SUB Directories (Directory.Search$, Filename.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory filename
ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' search directory names
    CALL Filenames(Directory.Search$, Filename.Search$)

    ' check to recurse directories
    IF Recurse.Directories THEN

        ' recurse directories
        DO
            ' check to quit
            IF Quit.Searching THEN
                EXIT DO
            END IF

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            IF (Attribute AND &H10) = &H10 THEN

                ' store directory name
                Directory$ = finddata.cFileName
                Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

                ' check directory name
                IF Directory$ <> "." AND Directory$ <> ".." THEN

                    ' check unicode
                    IF INSTR(Directory$, "?") THEN
                        Directory$ = finddata.cAlternateFileName
                        V = INSTR(Directory$, CHR$(0))
                        IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                    END IF

                    ' make next search directory
                    Next.Directory$ = Directory.Search$ + Directory$ + "\"

                    ' check recursion levels
                    Recursion% = True
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels + 1
                        IF Nested.Levels >= Nested.Recurse THEN
                            Recursion% = False
                        END IF
                    END IF

                    ' recursively search subdirectories
                    IF Recursion% THEN
                        CALL Directories(Next.Directory$, Filename.Search$)
                    END IF
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels - 1
                    END IF
                END IF
            END IF

        LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
        x = FindClose(Wfile.Handle)
    END IF
END IF
END SUB

' subroutine to access filenames in directory
SUB Filenames (Directory.Search$, Filename.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make filename
ASCIIZ = Directory.Search$ + Filename.Search$ + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' search filenames
    DO
        ' store filename
        Filename$ = finddata.cFileName
        Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN

            ' store file data
            finddatatemp = finddata

            ' display filename
            CALL DisplayFiles(Directory.Search$, Filename$)
        END IF

        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to encrypt a filename
SUB DisplayFiles (Search.Directory$, Display.Filename$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260

' make filename
Search.Filename$ = Search.Directory$ + Display.Filename$

' check file attribute
Attribute = finddatatemp.dwFileAttributes

' check directory bit
IF (Attribute AND &H10) = &H10 THEN
    Directory.Set = True
ELSE
    Directory.Set = False
END IF

' clear directory bit to set directory attribute
Attribute = Attribute AND NOT &H10

' check to clear read-only bit
IF Clear.Readonly THEN
    Attribute = Attribute AND NOT &H1
END IF

' check to clear hidden bit
IF Clear.Hidden THEN
    Attribute = Attribute AND NOT &H2
END IF

' check to clear system bit
IF Clear.System THEN
    Attribute = Attribute AND NOT &H4
END IF

' check to clear archive bit
IF Clear.Archive THEN
    Attribute = Attribute AND NOT &H20
END IF

' check to set read-only bit
IF Set.Readonly THEN
    Attribute = Attribute OR &H1
END IF

' check to set hidden bit
IF Set.Hidden THEN
    Attribute = Attribute OR &H2
END IF

' check to set system bit
IF Set.System THEN
    Attribute = Attribute OR &H4
END IF

' check to set archive bit
IF Set.Archive THEN
    Attribute = Attribute OR &H20
END IF

' change filename attribute
ASCIIZ = Search.Filename$ + CHR$(0)
Old.Attribute& = Attribute
Attribute = Attribute AND NOT &H1 ' reset read-only bit
x = SetFileAttributes&(ASCIIZ, Attribute)

' encrypt filename
ASCIIZ = Search.Filename$ + CHR$(0)
V = EncryptFileA(ASCIIZ)

' restore filename attribute
ASCIIZ = Search.Filename$ + CHR$(0)
Attribute = Old.Attribute& ' restore attribute
x = SetFileAttributes&(ASCIIZ, Attribute)

' count files reset
IF Directory.Set THEN
    Dirs.Counted = Dirs.Counted + 1#
ELSE
    Files.Counted = Files.Counted + 1#
END IF

' display filename
IF Display.Filenames = False THEN
    IF Directory.Set THEN
        Outpt$ = Drive.Search + ":" + Search.Filename$
    ELSE
        IF LEFT$(Search.Directory$, 2) <> "\\" THEN
            Outpt$ = Drive.Search + ":" + Search.Filename$
        ELSE
            Outpt$ = Search.Filename$
        END IF
    END IF

    ' check display type
    IF More.Display = False THEN

        ' check line length
        Outpt.Length = LEN(Outpt$)
        Lines.Counted2 = False
        IF Outpt.Length > 240 THEN
            Lines.Counted = Lines.Counted + 4
            Lines.Counted2 = Lines.Counted2 + 4
        ELSE
            IF Outpt.Length > 160 THEN
                Lines.Counted = Lines.Counted + 3
                Lines.Counted2 = Lines.Counted2 + 3
            ELSE
                IF Outpt.Length > 80 THEN
                    Lines.Counted = Lines.Counted + 2
                    Lines.Counted2 = Lines.Counted2 + 2
                ELSE
                    Lines.Counted = Lines.Counted + 1
                    Lines.Counted2 = Lines.Counted2 + 1
                END IF
            END IF
        END IF
        ' prompt before display
        IF Lines.Counted >= 23 THEN
            Lines.Counted = False
            ' store lines after prompt
            Lines.Counted = Lines.Counted2
            COLOR Yellow, Black
            Prompt$ = "More(y/n/c)?"
            CALL MorePrompt(Prompt$, "ync", Outpt2$)
            SELECT CASE Outpt2$
                CASE "c"
                    More.Display = True
                CASE "n"
                    Quit.Searching = True
            END SELECT
        END IF
    END IF
    IF Quit.Searching = 0 THEN
        COLOR Yellow, Black
        PRINT Outpt$
        ' display error accessing file
        IF V = 0 THEN
            CALL DisplayError("Error encrypting file.")
        END IF
    END IF
END IF
' increment counters
IF V THEN
    IF Directory.Set THEN
        Crypted.Count2 = Crypted.Count2 + 1#
    ELSE
        Crypted.Count = Crypted.Count + 1#
    END IF
END IF
END SUB

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
x$ = ""
s$ = STR$(s#)
IF INSTR(s$, "D") THEN ' return string
    FormatString$ = s$
    EXIT FUNCTION
END IF
IF LEFT$(s$, 1) = "-" THEN ' store sign
    e$ = "-"
    s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
    q$ = MID$(s$, INSTR(s$, "."))
    s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function

