REM file: RDvolume.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "RDVOLUME"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' initialize filename buffer
DIM SHARED Drive.Search AS STRING * 1

' declare work variables
DIM SHARED Continuous.Display AS INTEGER
DIM SHARED Display.Errors AS INTEGER
DIM SHARED Display.Drive AS INTEGER
DIM SHARED Display.Volume AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetDriveType& (d$)
END DECLARE

' declare library variables.
DIM SHARED DriveType AS STRING

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
'x = SetCurrentDirectoryA(f$)

' get current drive
Current.Drive$ = LEFT$(_CWD$, 1)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' read command line
Command.Line = UCASE$(RTRIM$(Read.COMMAND$))
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "Drive letter: ";
    DO
        _LIMIT 100
        I$ = INKEY$
        IF LEN(I$) THEN
            I$ = UCASE$(I$)
            IF I$ >= "A" AND I$ <= "Z" THEN
                PRINT I$
                Command.Line = I$ + ":"
                EXIT DO
            END IF
            IF I$ = CHR$(13) THEN
                PRINT
                EXIT DO
            END IF
        END IF
    LOOP
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)
Command.Line = UCASE$(Command.Line)

' get switches from command line
Continuous.Display = ParseLine("/C")
Display.Drive = ParseLine("/D")
Display.Volume = ParseLine("/V")
Display.Errors = ParseLine("/Z")

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF

' check trailing command line
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' display header
GOSUB Header

' filename processing loop
DO
    ' store entire command
    Imbedded = INSTR(Command.Line, " ")
    IF Imbedded THEN
        Command.Work = LEFT$(Command.Line, Imbedded - 1)
        Command.Line = MID$(Command.Line, Imbedded + 1)
    ELSE
        Command.Work = Command.Line
        Command.Line = NUL
    END IF

    ' store current drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
        Command.Work = MID$(Command.Work, 3)
    ELSE
        Drive.Search = Current.Drive$
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' store drive letter
    V = ASC(UCASE$(LEFT$(Drive.Search, 1))) - 64
    IF DRIVEEXISTS(V) = 0 THEN
        Var$ = Drive.Search
        CALL Vlabel(Var$)
        IF RTRIM$(Var$) = NUL THEN
            Var$ = DriveType
        END IF

        ' display drive letter
        IF Display.Drive THEN
            COLOR Yellow, Black
            PRINT Drive.Search + ":";
        END IF

        ' display volume label
        IF Display.Volume = False THEN
            IF LEN(Var$) THEN
                COLOR Yellow, Black
                PRINT Var$
            END IF
        END IF
        IF Display.Drive AND Var$ = "" THEN
            PRINT
        ELSE
            IF Display.Drive AND Display.Volume THEN
                PRINT
            END IF
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF
LOOP

End.Rdvolume:

' display counters
IF Continuous.Display = False THEN
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            New.Drive = 0
            Volumes.Counted = 0
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Rdvolume v1.0a: Volume label display utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Rdvolume [d:][/cdvz]"
PRINT "Where:"
PRINT "   /c  continuous display"
PRINT "   /d  display drive letter"
PRINT "   /v  don't display volume label"
PRINT "   /z  suppress errors"
COLOR Plain, Black
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Rdvolume /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Rdvolume v1.0a: Volume label display utility;"
END IF
RETURN
   
' critical error trap
Error.Routine:
DataError = ERR
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
IF BreakIS THEN
    Outpt$ = "q"
END IF
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Rdvolume
    CASE "c"
        OutregsX.Flags = &H1
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' get volume label
SUB Vlabel (Var$)
' get drive info.
VarX$ = Var$ + ":\" + CHR$(0)
Var$ = NUL
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    ' get volume label.
    Var$ = RTRIM$(Vname$)
    v = INSTR(Var$, CHR$(0))
    IF v THEN Var$ = LEFT$(Var$, v - 1)
END IF
END SUB

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


