Rem file: Touch.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DefInt A-Z
Rem $Dynamic
_Title "TOUCH"

' define boolean values
Const True = -1
Const False = Not True
Const TrueD = -1#
Const FalseD = Not TrueD
Const NUL = ""

' define color values
Const Black = 0
Const Cyan = 11
Const Green = 10
Const Plain = 7
Const Red = 12
Const White = 15
Const Yellow = 14

' declare filename variables
Dim Shared Drive.Search As String * 1
Dim Shared Current.Directory As String

' declare work variables
Dim Shared Files.Counter As Integer, Quit.Searching As Integer
Dim Shared Continuous.Display As Integer, Display.Errors As Integer
Dim Shared Remove.Slash As Integer, Prepend.Drive As Integer
Dim Shared Nested.Levels As Integer, Nested.Recurse As Integer

' declare search work variables
Dim Shared Search.From.Date As Single, Search.To.Date As Single
Dim Shared Search.From.Time As Single, Search.To.Time As Single
Dim Shared File.Size As Double, Recurse.Directories As Integer
Dim Shared Display.Hidden As Integer, Display.System As Integer
Dim Shared Display.Compress As Integer, Display.Encrypt As Integer
Dim Shared Display.Readonly As Integer, Display.Archive As Integer
Dim Shared Display.Any As Integer, No.Display.Archive As Integer
Dim Shared No.Display.Readonly As Integer, No.Display.System As Integer
Dim Shared No.Display.Compress As Integer, No.Display.Encrypt As Integer
Dim Shared No.Display.Hidden As Integer, No.Display.Any As Integer
Dim Shared Debug.Mode As Integer, Prompt.Files As Integer

' declare count variables
Dim Shared Files.Counted As Double
Dim Shared Display.Search As Integer
Dim Shared Display.Filenames As Integer

' declare file date\time and filesize work variables
Dim Shared File.Work.Date As Single, File.Work.Time As Single
Dim Shared Search.Size.From As Double, Search.Size.To As Double
Dim Shared Search.File.Size, Creation.Time As Integer
Dim Shared Access.Time As Integer, Modified.Time As Integer

' declare date\time work variables
Dim Shared HourTemp As Integer, MinuteTemp As Integer, SecondTemp As Integer
Dim Shared MonthTemp As Integer, DayTemp As Integer, YearTemp As Integer

' declare file date/time override work varibles
Dim Shared Override.Create.Date As Integer
Dim Shared Override.Access.Date As Integer
Dim Shared Override.Modify.Date As Integer

' declare command line work variables
Dim Shared Command.Line As String
Dim Shared Command.Work As String
Dim Shared Last.Switch As Integer
Dim Shared Switch.Exist As Integer

' declare library constants.
Const MAX_PATH = 260
Const INVALID_HANDLE_VALUE = -1

' declare library structures.
Type FILETIME
   dwLowDateTime As _Unsigned Long
   dwHighDateTime As _Unsigned Long
End Type

Type SYSTEMTIME
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Type WIN32_FIND_DATAA
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path
   cAlternateFileName As String * 14
End Type

' declare external libraries.
Declare Dynamic Library "kernel32"
   Function FindFirstFileA~%& (ByVal lpFileName~%&, ByVal lpFindFileData~%&)
   Function FindNextFileA& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindClose& (ByVal hFindFile~%&)

   Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, ByVal nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, ByVal nFileSystemNameSize&)
   Function SetCurrentDirectoryA% (f$)
   Function RemoveDirectoryA% (F$)
   Function CreateDirectoryA% (F$, X$)

   Function CloseHandle& (ByVal hfile As _Offset)
   Function GetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function SetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function FileTimeToSystemTime& (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
   Function SystemTimeToFileTime& (lpSystemTime As SYSTEMTIME, lpFileTime As FILETIME)

   Function GetLastError& ()
   Function FormatMessageA& (ByVal f As Long, f$, ByVal e As Long, ByVal d As Long, g$, s As Long, h$)
End Declare

Declare Library
   Function CreateFile%& (filename$, ByVal access&, ByVal sharing&, ByVal sec_attr%&, ByVal create&, ByVal flags&, ByVal template%&)
   Function GetFileAttributes& (f$)
   Function SetFileAttributes& (f$, ByVal a&)
   Function GetDriveType& (d$)
   Function GetShortPathName& (InP$, OutP$, ByVal length&)
   Function GetModuleFileNameA (ByVal Module As Long, FileName As String, ByVal nSize As Long)
End Declare

' declare library variables.
Dim Shared CreateDate As FILETIME
Dim Shared AccessDate As FILETIME
Dim Shared ModifyDate As FILETIME

Dim Shared SourceCreateDate As FILETIME
Dim Shared SourceAccessDate As FILETIME
Dim Shared SourceModifyDate As FILETIME

' declare library variables.
Dim Shared SysTime As SYSTEMTIME
Dim Shared DriveType As String
Dim Shared finddatatemp As WIN32_FIND_DATAA

' declare standard error trap
On Error GoTo Error.Routine

' force default path
x$ = _StartDir$
f$ = x$ + Chr$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
If Command$ = "/?" Then
   GoSub Boot.Usage
   End
End If

' store command line
Command.Line = RTrim$(Read.Command$)
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' get current drive
Current.Drive$ = Left$(_CWD$, 1)
Current.Directory = _CWD$
If Right$(Current.Directory, 1) <> "\" Then
   Current.Directory = Current.Directory + "\"
End If

' check command line
If Command.Line = NUL Then
   ' display header
   Color White, Black
   GoSub Header
   Display.Header = True

   ' get command line input
   Print "File spec: ";
   Line Input Command.Line
   Do
      Color White, Black
      Print "Switches(?=list): ";
      Line Input Var$
      If Var$ = "?" Then
         GoSub Boot.Usage
      Else
         Command.Line = Command.Line + Var$
         Exit Do
      End If
   Loop
End If

' check command line switches
Display.Archive = ParseLine("//A")
Display.Hidden = ParseLine("//H")
Display.Readonly = ParseLine("//O")
Display.System = ParseLine("//S")
Display.Compress = ParseLine("//M1")
Display.Encrypt = ParseLine("//M2")
Display.Any = ParseLine("//X")

No.Display.Archive = ParseLine("/A")
No.Display.Hidden = ParseLine("/H")
No.Display.Readonly = ParseLine("/O")
No.Display.System = ParseLine("/S")
No.Display.Compress = ParseLine("/M1")
No.Display.Encrypt = ParseLine("/M2")
No.Display.Any = ParseLine("/X")

Continuous.Display = ParseLine("/C")
Display.Search = ParseLine("/J")
Prompt.Files = ParseLine("/P")
Recurse.Directories = ParseLine("/R")
Prepend.Drive = ParseLine("/U")
Display.Filenames = ParseLine("/V")
Remove.Slash = ParseLine("/Y")
Display.Errors = ParseLine("/Z")

' read override switches.
Override.Create.Date = ParseLine("/7")
Override.Access.Date = ParseLine("/8")
Override.Modify.Date = ParseLine("/9")

' reset file counter variable
Continue = False
Files.Counted = 0#
   
' read date override switch
File.Date$ = Date$
Imbedded = InStr(UCase$(Command.Line), "/5")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   File.Date$ = Mid$(Command.Line, Imbedded + 2, 10)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 12)
   If Len(File.Date$) <> 10 Then
      GoTo Boot.Error
   End If
End If

' store date values
MonthTemp = Val(Mid$(File.Date$, 1, 2))
DayTemp = Val(Mid$(File.Date$, 4, 2))
YearTemp = Val(Mid$(File.Date$, 7, 4))

' read time override switch
File.Time$ = Time$
Imbedded = InStr(UCase$(Command.Line), "/6")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   File.Time$ = Mid$(Command.Line, Imbedded + 2, 8)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 10)
   If Len(File.Time$) <> 8 Then
      GoTo Boot.Error
   End If
End If

' store time values hh:mm:ss
HourTemp = Val(Mid$(File.Time$, 1, 2))
MinuteTemp = Val(Mid$(File.Time$, 4, 2))
SecondTemp = Val(Mid$(File.Time$, 7, 2))

' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = InStr(UCase$(Command.Line), "/D")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   D$ = Mid$(Command.Line, Imbedded + 2, 21)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 23)
   If Len(D$) <> 21 Then
      GoTo Boot.Error
   End If
   If Mid$(D$, 11, 1) <> "-" Then
      GoTo Boot.Error
   End If
   S$ = Left$(D$, 10)
   D1! = Int(Val(Mid$(S$, 1, 2)))
   D2! = Int(Val(Mid$(S$, 4, 2)))
   D3! = Int(Val(Mid$(S$, 7, 4)))
   Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   S$ = Right$(D$, 10)
   D1! = Int(Val(Mid$(S$, 1, 2)))
   D2! = Int(Val(Mid$(S$, 4, 2)))
   D3! = Int(Val(Mid$(S$, 7, 4)))
   Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   If Search.From.Date < False Or Search.To.Date < False Then
      GoTo Boot.Error
   End If
End If
Imbedded = InStr(UCase$(Command.Line), "/T")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   T$ = Mid$(Command.Line, Imbedded + 2, 17)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 19)
   If Len(T$) <> 17 Then
      GoTo Boot.Error
   End If
   If Mid$(T$, 9, 1) <> "-" Then
      GoTo Boot.Error
   End If
   S$ = Left$(T$, 8)
   T1! = Int(Val(Mid$(S$, 1, 2)))
   T2! = Int(Val(Mid$(S$, 4, 2)))
   T3! = Int(Val(Mid$(S$, 7, 2)))
   Search.From.Time = T1! * 2048 + T2! * 32
   S$ = Right$(T$, 8)
   T1! = Int(Val(Mid$(S$, 1, 2)))
   T2! = Int(Val(Mid$(S$, 4, 2)))
   T3! = Int(Val(Mid$(S$, 7, 2)))
   Search.To.Time = T1! * 2048 + T2! * 32
   If Search.From.Time < False Or Search.To.Time < False Then
      GoTo Boot.Error
   End If
End If

' get file size from command line
Search.File.Size = False
Search.Size.From = FalseD
Search.Size.To = FalseD
Imbedded = InStr(UCase$(Command.Line), "/F")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   Search.File.Size = True
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
   GoSub Get.Numeric
   Search.Size.From = Var#
   If Mid$(Command.Line, Imbedded, 1) <> "-" Then
      GoTo Boot.Error
   End If
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
   GoSub Get.Numeric
   Search.Size.To = Var#
   Search.Size.From = Search.Size.From * 1024#
   Search.Size.To = Search.Size.To * 1024#
End If

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
If Creation.Time = False Then
   If Access.Time = False Then
      If Modified.Time = False Then
         Modified.Time = True
      End If
   End If
End If

' check command line switch
Imbedded = InStr(UCase$(Command.Line), "/N")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
   GoSub Get.Numeric
   Nested.Recurse = CInt(Var#)
End If

' parse special debug switch.
Debug.Mode = ParseLine("/=")

' recheck command line
If InStr(Command.Line, "/") Then
   GoTo Boot.Error
End If
Command.Line = RTrim$(Command.Line)
If Switch.Exist Then
   If Len(Command.Line) > Last.Switch Then
      GoTo Boot.Error
   End If
End If

' reset work variables
Files.Counter = False
Quit.Searching = False
   
' remove blanks from command line
Command.Line = RTrim$(Command.Line)
Command.Line = LTrim$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GoSub Header

' filename processing loop
Do
   ' store entire command
   If Left$(Command.Line, 1) = Chr$(34) Then
      Imbedded = InStr(2, Command.Line, Chr$(34))
      If Imbedded Then
         Command.Work = Mid$(Command.Line, 2, Imbedded - 2)
         Command.Line = Mid$(Command.Line, Imbedded + 1)
      Else
         Command.Work = Command.Line
         Command.Line = NUL
      End If
   Else
      Imbedded = InStr(Command.Line, " ")
      If Imbedded Then
         Command.Work = Left$(Command.Line, Imbedded - 1)
         Command.Line = Mid$(Command.Line, Imbedded + 1)
      Else
         Command.Work = Command.Line
         Command.Line = NUL
      End If
   End If
   Command.Line = LTrim$(Command.Line)
   Command.Line = RTrim$(Command.Line)

   ' store current drive
   If Mid$(Command.Work, 2, 1) = ":" Then
      Drive.Search = Left$(Command.Work, 1)
      Command.Work = Mid$(Command.Work, 3)
   Else
      Drive.Search = Current.Drive$
   End If
   Drive.Search = UCase$(Drive.Search)

   ' store current directory
   Directory.Search$ = ""
   Imbedded1 = InStr(Command.Work, "\")
   Imbedded2 = Imbedded1
   While Imbedded1
      Imbedded2 = Imbedded1
      Imbedded1 = InStr(Imbedded1 + 1, Command.Work, "\")
   Wend
   If Imbedded2 Then
      Directory.Search$ = Left$(Command.Work, Imbedded2)
      Command.Work = Mid$(Command.Work, Imbedded2 + 1)
   End If
   If Directory.Search$ = "" Then
      If Left$(Current.Directory, 2) = "\\" Then
         Directory.Search$ = Current.Directory
      Else
         If Drive.Search = Current.Drive$ Then
            Directory.Search$ = Mid$(Current.Directory, 3)
         Else
            Directory.Search$ = "\"
         End If
      End If
   End If
   If Right$(Directory.Search$, 1) <> "\" Then
      Directory.Search$ = Directory.Search$ + "\"
   End If
   
   ' get filename spec
   Filename.Search$ = Command.Work
   If Filename.Search$ = NUL Then
      Filename.Search$ = "*.*"
   End If
   Command.Work = NUL

   ' display search filename
   If Continuous.Display = False Then
      Color Yellow, Black
      If Left$(Directory.Search$, 2) = "\\" Then
         Print "Searching: " + Directory.Search$ + Filename.Search$
      Else
         Print "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
      End If
   End If

   ' call routine to search for files
   If Left$(Directory.Search$, 2) = "\\" Then
      Call Directories(Directory.Search$, Filename.Search$)
   Else
      V = Asc(UCase$(Left$(Drive.Search$, 1))) - 64
      If MEDIAEXISTS(V) Then
         Call Directories(Directory.Search$, Filename.Search$)
      End If
   End If

   ' check search filename
   If Command.Line = NUL Then
      Exit Do
   End If

   ' check quit searching
   If Quit.Searching Then
      Exit Do
   End If
Loop

End.Touch:

' display end program
If Continuous.Display = False Then
   Color Yellow, Black
   Print "Files touched ";
   Print FormatString$(Files.Counted)
   Color White, Black
   Prompt$ = "Press (A)gain, (Q)uit:"
   Print Prompt$;
   Do
      _Limit 50
      Locate , , 1
      I$ = InKey$
      If UCase$(I$) = "Q" Then
         Color Plain, Black
         System
      End If
      If UCase$(I$) = "A" Then
         Command.Line = NUL
         Color Plain, Black
         Print
         GoTo Start.Loop
      End If
   Loop
End If
Color Plain, Black
End

' display program usage
Boot.Usage:
' make header
Color White, Black
Print "Touch v1.0a: File date/time update utility; "
Color Yellow, Black
Print "Usage:"
Print "   Touch [d:][\pathname\][filename][//ahosx][/cdfjnprtuvyz][/123][/56789]"
Print "Where:"
Print "   d:\pathname\filename is the search directory."
Print "   /c  continuous display       /u  prepend drive letter"
Print "   /j  display directories      /v  don't display filenames"
Print "   /nxxx  recurse override      /y  remove trailing slash"
Print "   /p  don't prompt to touch    /z  suppress error messages"
Print "   /r  recurse directories      /=  set debug mode"
Print "   /0  create file if not exist"
Print "   file override switches:"
Print "     /5mm/dd/yyyy  override touch file date"
Print "     /6hh:mm:ss    override touch file time"
Print "     /7  touch creation date/time"
Print "     /8  touch last access date/time"
Print "     /9  touch last modified (write) date/time"
Print "   display ranges: (/1  creation, /2  last access  /3  modify time)"
Print "     /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
Print "     /t  is range of file times in form hh:mm:ss-hh:mm:ss"
Print "     /f  is range of file sizes in form xxx-xxx in kilobytes"
Print "   display file attributes:"
Print "     // prefix for files with, / prefix for files without,"
Print "       a  archive, h  hidden, o  read-only, s  system, x  none"
Print "       m1  compressed, m2  encrypted"
Color Plain, Black
Return

Get.Numeric:
Var# = False
Do
   Temp$ = Mid$(Command.Line, Imbedded, 1)
   If Temp$ >= "0" And Temp$ <= "9" Then
      Var# = Var# * 10 + Val(Temp$)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
   Else
      Exit Do
   End If
Loop
Return

Boot.Error:
Color White, Black
Print "Command line error. Type Touch /? for help."
Color Plain, Black
End

' make header
Header:
If Header.Flag Then
   Return
End If
Header.Flag = True
If Continuous.Display = False Then
   Color White, Black
   Print "Touch v1.0a: File date/time update utility; "
End If
Return

' critical error trap
Error.Routine:
Data.Error = Err
If Display.Errors Then
   Error.Level = True
   Resume Next
End If
Color Green, Black
Print "Critical error:"; DataError; " IDE line:"; _ErrorLine
Prompt$ = "Press R to retry, Q to quit, C to continue:"
Call MorePrompt(Prompt$, "rqc", Outpt$)
If BreakIS Then
   Outpt$ = "q"
End If
Select Case Outpt$
   Case "r"
      Resume
   Case "q"
      Error.Level = True
      Resume End.Touch
   Case "c"
      Resume Next
End Select
Color Plain, Black
End 0

' subroutine to access directories
Sub Directories (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make directory filename
   ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search directory names
      Call Filenames(Directory.Search$, Filename.Search$)

      ' check to recurse directories
      If Recurse.Directories Then

         ' recurse directories
         Do
            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            If (Attribute And &H10) = &H10 Then

               ' store directory name
               Directory$ = finddata.cFileName
               Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

               ' check directory name
               If Directory$ <> "." And Directory$ <> ".." Then
                  ' make next search directory
                  Next.Directory$ = Directory.Search$ + Directory$ + "\"

                  ' recursively search subdirectories
                  Call Directories(Next.Directory$, Filename.Search$)
               End If
            End If

            ' check to quit
            If Quit.Searching Then
               Exit Do
            End If
         Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      End If
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to access filenames in directory
Sub Filenames (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make filename
   ASCIIZ = Directory.Search$ + Filename.Search$ + Chr$(0)

   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' check directory attribute
      Attribute = finddata.dwFileAttributes

      ' check for directory
      If (Attribute And &H10) = &H10 Then
         ' display directory being searched
         Call DisplayDirectory(Directory.Search$)
      End If

      ' recurse filename
      Do
         ' store filename
         Filename$ = finddata.cFileName
         Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then

            ' store file data
            finddatatemp = finddata

            ' store file size
            File.Size = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            If (Attribute And &H10) <> &H10 Then
               Call DisplayFiles(Directory.Search$, Filename$)
            End If
         End If

         ' check to quit
         If Quit.Searching Then
            Exit Do
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to display directory
Sub DisplayDirectory (Directory.Search$)
   If Display.Search Then
      Filename$ = Directory.Search$
      If Filename$ <> "\" Then
         If Remove.Slash Then
            Slash = Len(Filename$)
            Filename$ = Left$(Filename$, Slash - 1)
         End If
      End If
      If Prepend.Drive Then
         If Left$(Filename$, 2) <> "\\" Then
            Filename$ = Drive.Search + ":" + Filename$
         End If
      End If
      Color Green, Black
      Print Filename$
   End If
End Sub

' subroutine to count and display filenames
Sub DisplayFiles (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long

   ' check directory attribute
   Attribute = finddatatemp.dwFileAttributes

   ' check for readonly file
   If (Attribute And &H1) = &H1 Then
      If No.Display.Readonly Then
         Exit Sub
      End If
   Else
      If Display.Readonly Then
         Exit Sub
      End If
   End If

   ' check for hidden file
   If (Attribute And &H2) = &H2 Then
      If No.Display.Hidden Then
         Exit Sub
      End If
   Else
      If Display.Hidden Then
         Exit Sub
      End If
   End If

   ' check for system file
   If (Attribute And &H4) = &H4 Then
      If No.Display.System Then
         Exit Sub
      End If
   Else
      If Display.System Then
         Exit Sub
      End If
   End If

   ' check for archive file
   If (Attribute And &H20) = &H20 Then
      If No.Display.Archive Then
         Exit Sub
      End If
   Else
      If Display.Archive Then
         Exit Sub
      End If
   End If

   ' check for compressed file
   If (Attribute And &H800) = &H800 Then
      If No.Display.Compress Then
         Exit Sub
      End If
   Else
      If Display.Compress Then
         Exit Sub
      End If
   End If

   ' check for encrypted file
   If (Attribute And &H4000) = &H4000 Then
      If No.Display.Encrypt Then
         Exit Sub
      End If
   Else
      If Display.Encrypt Then
         Exit Sub
      End If
   End If

   ' check all attributes
   If Display.Any Then
      If (Attribute And &H1) = &H1 Then
         Exit Sub
      End If
      If (Attribute And &H2) = &H2 Then
         Exit Sub
      End If
      If (Attribute And &H4) = &H4 Then
         Exit Sub
      End If
      If (Attribute And &H20) = &H20 Then
         Exit Sub
      End If
      If (Attribute And &H800) = &H800 Then
         Exit Sub
      End If
      If (Attribute And &H4000) = &H4000 Then
         Exit Sub
      End If
   End If
   If No.Display.Any Then
      If (Attribute And &H1) = False Then
         If (Attribute And &H2) = False Then
            If (Attribute And &H4) = False Then
               If (Attribute And &H20) = False Then
                  If (Attribute And &H800) = False Then
                     If (Attribute And &H4000) = False Then
                        Exit Sub
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If

   ' check file size
   If Search.File.Size Then
      If Search.Size.From = FalseD And Search.Size.To = FalseD Then
         If File.Size <> FalseD Then
            Exit Sub
         End If
      Else
         If Search.Size.From > FalseD Or Search.Size.To > FalseD Then
            If Search.Size.From > FalseD Then
               If Search.Size.To = FalseD Then
                  If File.Size < Search.Size.From Then
                     Exit Sub
                  End If
               End If
            End If
            If Search.Size.From = FalseD Then
               If Search.Size.To > FalseD Then
                  If File.Size > Search.Size.To Then
                     Exit Sub
                  End If
               End If
            End If
            If Search.Size.From <= Search.Size.To Then
               If File.Size < Search.Size.From Or File.Size > Search.Size.To Then
                  Exit Sub
               End If
            End If
            If Search.Size.From > Search.Size.To Then
               If File.Size < Search.Size.From And File.Size > Search.Size.To Then
                  Exit Sub
               End If
            End If
         End If
      End If
   End If

   ' store file date and time
   If Creation.Time Then
      x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
      GoSub Convert.Date
      GoSub Convert.Time
   Else
      If Access.Time Then
         x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
         GoSub Convert.Date
         GoSub Convert.Time
      Else
         If Modified.Time Then
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
            GoSub Convert.Date
            GoSub Convert.Time
         End If
      End If
   End If

   ' check date\time range
   If Search.From.Date Or Search.To.Date Then
      If File.Work.Date < Search.From.Date Then
         Exit Sub
      End If
      If File.Work.Date > Search.To.Date Then
         Exit Sub
      End If
   End If
   If Search.From.Time Or Search.To.Time Then
      If File.Work.Time < Search.From.Time Then
         Exit Sub
      End If
      If File.Work.Time > Search.To.Time Then
         Exit Sub
      End If
   End If

   ' touch filename
   Call TouchFile(Directory.Search$, Filename.Search$)
   Exit Sub

   Convert.Date:
   YearTempX! = SysTime.wYear
   MonthTempX! = SysTime.wMonth
   DayTempX! = SysTime.wDay
   File.Date$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
   File.Date$ = File.Date$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
   File.Date$ = File.Date$ + LTrim$(Str$(SysTime.wYear))
   File.Work.Date = ((YearTempX! - 1980) * 512) + MonthTempX! * 32 + DayTempX!
   Return

   Convert.Time:
   HourTempX! = SysTime.wHour
   MinuteTempX! = SysTime.wMinute
   SecondsTempX! = SysTime.wSecond
   File.Time$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
   File.Work.Time = HourTempX! * 2048 + MinuteTempX! * 32 + SecondsTempX!
   Return
End Sub

' subroutine to touch date/time of a file
Sub TouchFile (Directory.Search$, Filename.Search$)
   Dim ASCIIZ As String * 260
   Dim hfind As _Offset

   ' make filename
   ASCIIZ = Directory.Search$ + Filename.Search$ + Chr$(0)

   ' check for prompting
   If Prompt.Files = False Then
      Prompt$ = "Touch " + Filename.Search$ + "(y/n/c/q)?"
      Call MorePrompt(Prompt$, "yncq", Outpt$)
      Select Case Outpt$
         Case "c"
            Prompt.Files = True
         Case "n"
            Exit Sub
         Case "q"
            Quit.Searching = True
            Exit Sub
      End Select
   End If

   ' display filename
   If Display.Filenames = 0 Then
      Filename$ = Directory.Search$ + Filename.Search$
      If Prepend.Drive Then
         If Left$(Filename$, 2) <> "\\" Then
            Filename$ = Drive.Search + ":" + Filename$
         End If
      End If
      Color Yellow, Black
      Print Filename$
   End If

   'handle& = CreateFile(f$, &H180, 0, 0, 1, 0, 0)
   ' parameters:
   '   (1) pointer to filename
   '   (2) access:
   '     x80(128)  - read
   '     x100(256) - write
   '   (3) sharing
   '   (4) security attributes
   '   (5) create:
   '     1 CREATE_NEW    = create only if not exist
   '     2 CREATE_ALWAYS = always create new file
   '     3 OPEN_EXISTING = open only if exists
   '     4 OPEN_ALWAYS   = open file always
   '     5 TRUNCATE_EXISTING = open/truncate to 0 only if exists
   '   (6) - flags (standard OSHA)

   ' get source filename date/time.
   hfind = CreateFile(ASCIIZ, &H180, &H3, 0, 3, 0, 0)
   If hfind <> INVALID_HANDLE_VALUE Then
      x = GetFileTime&(hfind, SourceCreateDate, SourceAccessDate, SourceModifyDate)
      ' display any errors.
      If x = 0 Then
         If Debug.Mode Then
            Var$ = "Error (0x" + Hex$(GetLastError&) + ") reading filename date/time."
            Call DisplayError(Var$)
         End If
      End If

      ' store default date/time.
      CreateDate = SourceCreateDate
      AccessDate = SourceAccessDate
      ModifyDate = SourceModifyDate

      ' store override date/time.
      GoSub GetSysDate
      If Override.Create.Date Then
         x = SystemTimeToFileTime&(SysTime, CreateDate)
      End If
      If Override.Access.Date Then
         x = SystemTimeToFileTime&(SysTime, AccessDate)
      End If
      If Override.Modify.Date Then
         x = SystemTimeToFileTime&(SysTime, ModifyDate)
      End If

      ' set the destination filename date/time.
      x = SetFileTime&(hfind, CreateDate, AccessDate, ModifyDate)
      ' display any errors.
      If x = 0 Then
         If Debug.Mode Then
            Var$ = "Error (0x" + Hex$(GetLastError&) + ") touching filename date/time."
            Call DisplayError(Var$)
         End If
      End If
      x = CloseHandle(hfind)
   Else
      Var$ = "Error (0x" + Hex$(GetLastError&) + ") opening filename."
      Call DisplayError(Var$)
   End If

   ' update files counter
   Files.Counted = Files.Counted + 1#
   Exit Sub

   GetSysDate:
   ' store override variables
   SysTime.wMonth = MonthTemp
   SysTime.wDay = DayTemp
   SysTime.wYear = YearTemp
   SysTime.wHour = HourTemp
   SysTime.wMinute = MinuteTemp
   SysTime.wSecond = SecondTemp
   Return
End Sub

Sub MorePrompt (Input.String$, Input.Mask$, Output.String$)
   Color White, Black
   Print Input.String$ + " ";
   Input.Char$ = NUL
   Locate , , 1
   Do
      _Limit 100
      Input.Char$ = InKey$
      If Len(Input.Char$) Then
         Input.Char$ = LCase$(Input.Char$)
         If InStr(Input.Mask$, Input.Char$) Then
            Print Input.Char$
            Output.String$ = Input.Char$
            Exit Do
         End If
      End If
   Loop
End Sub

' displays carry flag error
Sub DisplayError (Temp$)
   ' check display errors flag
   If Display.Errors = False Then
      ' display error
      Color Red, Black
      Print Temp$
   End If
End Sub

' command line switch position function.
Function LastSwitch (Var)
   If Last.Switch = 0 Then
      Last.Switch = Var - 1
      Switch.Exist = -1
   Else
      If Var < Last.Switch Then
         Last.Switch = Var - 1
         Switch.Exist = -1
      End If
   End If
End Function

' command line parser
Function ParseLine (X$)
   Imbedded = InStr(Command.Line, LCase$(X$))
   If Imbedded Then
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
      Last.Switch = Imbedded - 1
      ParseLine = True
      Switch.Exist = -1
   Else
      Imbedded = InStr(Command.Line, UCase$(X$))
      If Imbedded Then
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
         Last.Switch = Imbedded - 1
         ParseLine = True
         Switch.Exist = -1
      Else
         ParseLine = False
      End If
   End If
End Function

' test volume media inserted.
Function MEDIAEXISTS (V)
   ' check drive exists.
   If DRIVEEXISTS(V) Then
      MEDIAEXISTS = False
      Exit Function
   End If

   ' get drive info.
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      MEDIAEXISTS = True
   Else
      MEDIAEXISTS = False
   End If
End Function

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = NUL
   Select Case VarX
      Case 0
         DriveType = "[UNKNOWN]"
      Case 1
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      DRIVEEXISTS = False
   Else
      DRIVEEXISTS = True
   End If
End Function

' formats a double numeric string
Function FormatString$ (s#)
   x$ = ""
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If
   x$ = e$ + x$ + q$ ' construct string
   FormatString$ = x$
End Function

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


