REM file: Xdirbas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "XDIR"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare filename variables
DIM SHARED Drive.Search AS STRING * 1
DIM SHARED Current.Directory AS STRING

' declare work variables
DIM SHARED Files.Counter AS INTEGER, Quit.Searching AS INTEGER
DIM SHARED Continuous.Display AS INTEGER, Dot.Count AS INTEGER
DIM SHARED Count.Forward AS INTEGER, Display.Dots AS INTEGER
DIM SHARED Redirected.Input AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Remove.Slash AS INTEGER, Prepend.Drive AS INTEGER
DIM SHARED Nested.Levels AS INTEGER, Nested.Recurse AS INTEGER
DIM SHARED Display.Errors2 AS INTEGER, Directory.Temp AS STRING

' declare search work variables
DIM SHARED Search.From.Date AS SINGLE, Search.To.Date AS SINGLE
DIM SHARED Search.From.Time AS SINGLE, Search.To.Time AS SINGLE
DIM SHARED File.Size AS DOUBLE, Recurse.Directories AS INTEGER
DIM SHARED Display.Hidden AS INTEGER, Display.System AS INTEGER
DIM SHARED Display.Readonly AS INTEGER, Display.Archive AS INTEGER
DIM SHARED Display.Any AS INTEGER, No.Display.Archive AS INTEGER
DIM SHARED No.Display.Readonly AS INTEGER, No.Display.System AS INTEGER
DIM SHARED No.Display.Hidden AS INTEGER, No.Display.Any AS INTEGER

DIM SHARED Display.Compress AS INTEGER, Display.Encrypt AS INTEGER
DIM SHARED No.Display.Compress AS INTEGER, No.Display.Encrypt AS INTEGER

' declare count variables
DIM SHARED Count.Dirs AS INTEGER, Dirs.Counted AS DOUBLE
DIM SHARED Count.Files AS INTEGER, Files.Counted AS DOUBLE
DIM SHARED Count.Bytes AS INTEGER, Bytes.Counted AS DOUBLE
DIM SHARED Count.Lines AS INTEGER, Lines.Counted AS DOUBLE
DIM SHARED Display.Search AS INTEGER, Display.Filenames AS INTEGER

' declare file date\time and filesize work variables
DIM SHARED File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
DIM SHARED Search.Size.From AS DOUBLE, Search.Size.To AS DOUBLE
DIM SHARED Search.File.Size, Creation.Time AS INTEGER
DIM SHARED Access.Time AS INTEGER, Modified.Time AS INTEGER

' declare sort variables
DIM SHARED Max.Lines AS DOUBLE
DIM SHARED Num AS DOUBLE, Span AS DOUBLE, Start AS DOUBLE, Element AS DOUBLE

' declare sort array
DIM SHARED Sort.Array(1) AS STRING

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' initialize filename buffer
CONST buflen = 32767
DIM SHARED Buffer AS STRING * BUFLEN
CONST DotCounts = 256 ' counter of dots in row

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
    FUNCTION RemoveDirectoryA% (F$)
    FUNCTION CreateDirectoryA% (F$, X$)
    FUNCTION GetLastError& ()
    FUNCTION FormatMessageA& (BYVAL f AS LONG, f$, BYVAL e AS LONG, BYVAL d AS LONG, g$, s AS LONG, h$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING
DIM SHARED finddatatemp AS WIN32_FIND_DATAA

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
'x = SetCurrentDirectoryA(f$)

' redimension sort array
REDIM Sort.Array(1 TO 128) AS STRING

' reset count variables
Max.Lines = 128

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' store command line
Command.Line = RTRIM$(Read.COMMAND$)
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' get current drive
Current.Drive$ = LEFT$(_CWD$, 1)
Current.Directory = _CWD$

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "File spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' check command line switches
Display.Archive = ParseLine("//A")
Display.Hidden = ParseLine("//H")
Display.Readonly = ParseLine("//O")
Display.System = ParseLine("//S")
Display.Any = ParseLine("//X")

No.Display.Archive = ParseLine("/A")
No.Display.Hidden = ParseLine("/H")
No.Display.Readonly = ParseLine("/O")
No.Display.System = ParseLine("/S")
No.Display.Any = ParseLine("/X")

Display.Compress = ParseLine("//M1")
Display.Encrypt = ParseLine("//M2")

No.Display.Compress = ParseLine("/M1")
No.Display.Encrypt = ParseLine("/M2")

Continuous.Display = ParseLine("/C")
Count.Dirs = ParseLine("/E")
Count.Files = ParseLine("/G")
Count.Bytes = ParseLine("/I")
Count.Lines = ParseLine("/K")
Display.Search = ParseLine("/J")
Recurse.Directories = ParseLine("/R")
Prepend.Drive = ParseLine("/U")
Display.Filenames = ParseLine("/V")
Remove.Slash = ParseLine("/Y")
Display.Errors2 = ParseLine("/Z1")
Display.Errors = ParseLine("/Z")
Display.Dots = ParseLine("/.")

' reset file counter variable
Continue = False
Count.Forward = False
Dirs.Counted = 0#
Dot.Count = False
Files.Counted = 0#
Lines.Counted = 0#
Total.Bytes = 0#
   
' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = INSTR(UCASE$(Command.Line), "/D")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    D$ = MID$(Command.Line, Imbedded + 2, 21)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 23)
    IF LEN(D$) <> 21 THEN
        GOTO Boot.Error
    END IF
    IF MID$(D$, 11, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    S$ = RIGHT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    IF Search.From.Date < False OR Search.To.Date < False THEN
        GOTO Boot.Error
    END IF
END IF
Imbedded = INSTR(UCASE$(Command.Line), "/T")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    T$ = MID$(Command.Line, Imbedded + 2, 17)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 19)
    IF LEN(T$) <> 17 THEN
        GOTO Boot.Error
    END IF
    IF MID$(T$, 9, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.From.Time = T1! * 2048 + T2! * 32
    S$ = RIGHT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.To.Time = T1! * 2048 + T2! * 32
    IF Search.From.Time < False OR Search.To.Time < False THEN
        GOTO Boot.Error
    END IF
END IF

' get file size from command line
Search.File.Size = False
Search.Size.From = FalseD
Search.Size.To = FalseD
Imbedded = INSTR(UCASE$(Command.Line), "/F")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Search.File.Size = True
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Search.Size.From = Var#
    IF MID$(Command.Line, Imbedded, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    GOSUB Get.Numeric
    Search.Size.To = Var#
    Search.Size.From = Search.Size.From * 1024#
    Search.Size.To = Search.Size.To * 1024#
END IF

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
IF Creation.Time = False THEN
    IF Access.Time = False THEN
        IF Modified.Time = False THEN
            Modified.Time = True
        END IF
    END IF
END IF

' check command line switch
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Nested.Recurse = CINT(Var#)
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' reset work variables
Files.Counter = False
Quit.Searching = False
   
' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GOSUB Header

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF
    Command.Line = LTRIM$(Command.Line)
    Command.Line = RTRIM$(Command.Line)

    ' store current drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
        Command.Work = MID$(Command.Work, 3)
    ELSE
        Drive.Search = Current.Drive$
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' store current directory
    Directory.Search$ = ""
    Imbedded1 = INSTR(Command.Work, "\")
    Imbedded2 = Imbedded1
    WHILE Imbedded1
        Imbedded2 = Imbedded1
        Imbedded1 = INSTR(Imbedded1 + 1, Command.Work, "\")
    WEND
    IF Imbedded2 THEN
        Directory.Search$ = LEFT$(Command.Work, Imbedded2)
        Command.Work = MID$(Command.Work, Imbedded2 + 1)
    END IF
    IF Directory.Search$ = "" THEN
        IF LEFT$(Current.Directory, 2) = "\\" THEN
            Directory.Search$ = Current.Directory
        ELSE
            IF Drive.Search = Current.Drive$ THEN
                Directory.Search$ = MID$(Current.Directory, 3)
            ELSE
                Directory.Search$ = "\"
            END IF
        END IF
    END IF
    IF RIGHT$(Directory.Search$, 1) <> "\" THEN
        Directory.Search$ = Directory.Search$ + "\"
    END IF
   
    ' get filename spec
    Filename.Search$ = Command.Work
    IF Filename.Search$ = NUL THEN
        Filename.Search$ = "*.*"
    END IF
    Command.Work = NUL

    ' display search filename
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        IF LEFT$(Directory.Search$, 2) = "\\" THEN
            PRINT "Searching: " + Directory.Search$ + Filename.Search$
        ELSE
            PRINT "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
        END IF
    END IF

    ' call routine to search for files
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$, Filename.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Drive.Search$, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$, Filename.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

' shell sort
Sort.Swaps = False
Num = Lines.Counted
Span = INT(Num / 2)
DO WHILE Span > False
    FOR Start = Span TO Num - 1
        FOR Element = (Start - Span + 1) TO 1 STEP -Span
            Sort.Column1$ = MID$(Sort.Array(Element), Sort.Column)
            Sort.Column2$ = MID$(Sort.Array(Element + Span), Sort.Column)
            IF Ignore.Case THEN
                Sort.Column1$ = UCASE$(Sort.Column1$)
                Sort.Column2$ = UCASE$(Sort.Column2$)
            END IF
            IF Reverse.Sort THEN
                IF Sort.Column2$ <= Sort.Column1$ THEN
                    EXIT FOR
                END IF
            ELSE
                IF Sort.Column1$ <= Sort.Column2$ THEN
                    EXIT FOR
                END IF
            END IF
            SWAP Sort.Array(Element), Sort.Array(Element + Span)
            Sort.Swaps = Sort.Swaps + 1
        NEXT
    NEXT
    Span = INT(Span / 2)
LOOP

' output array
FOR Array.Line# = 1 TO Lines.Counted
    PRINT Sort.Array(Array.Line#)
NEXT
End.Xdir:

' display end program
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    IF Count.Dirs THEN
        IF Display.Errors2 = 0 THEN
            PRINT "Directories counted ";
        END IF
        PRINT FormatString$(Dirs.Counted)
    END IF
    IF Count.Files THEN
        IF Display.Errors2 = 0 THEN
            PRINT "Files counted ";
        END IF
        PRINT FormatString$(Files.Counted)
    END IF
    IF Count.Lines THEN
        IF Display.Errors2 = 0 THEN
            PRINT "Lines counted ";
        END IF
        PRINT FormatString$(Lines.Counted)
    END IF
    IF Count.Bytes THEN
        IF Display.Errors2 = 0 THEN
            PRINT "Bytes counted ";
        END IF
        PRINT FormatString$(Bytes.Counted)
    END IF
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Xdir v1.0a: Directory/file sort utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Xdir [d:][\pathname\][filename][//ahosx][/cdefgijknrtuvyz][/123]"
PRINT "Where:"
PRINT "   d:\pathname\filename is the search directory."
PRINT "   /c  continuous display    /e  count directories"
PRINT "   /g  count files           /i  count total bytes"
PRINT "   /j  display directories   /k  count total lines"
PRINT "   /nxxx  recurse override   /r  recurse directories"
PRINT "   /u  prepend drive letter  /v  display filenames"
PRINT "   /y  remove trailing slash /z  suppress error messages"
PRINT "   /z1 don't display output  /.  don't display dots"
PRINT "   display ranges: (/1  creation, /2  last access  /3  modify time)"
PRINT "     /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
PRINT "     /t  is range of file times in form hh:mm:ss-hh:mm:ss"
PRINT "     /f  is range of file sizes in form xxx-xxx in kilobytes"
PRINT "   display file attributes:"
PRINT "     // prefix for files with, / prefix for files without,"
PRINT "       a  archive, h  hidden, o  read-only, s  system, x  none"
PRINT "       m1  compressed, m2  encrypted"
COLOR Plain, Black
RETURN

Get.Numeric:
Var# = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var# = Var# * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Xdir /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Xdir v1.0a: Directory/file sort utility; "
END IF
RETURN

' critical error trap
Error.Routine:
Data.Error = ERR
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
IF BreakIS THEN
    Outpt$ = "q"
END IF
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Xdir
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access directories
SUB Directories (Directory.Search$, Filename.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory filename
ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN
    ' search directory names
    CALL Filenames(Directory.Search$, Filename.Search$)

    ' check to recurse directories
    IF Recurse.Directories THEN

        ' recurse directories
        DO
            ' check to quit
            IF Quit.Deleting THEN
                EXIT DO
            END IF

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            IF (Attribute AND &H10) = &H10 THEN

                ' store directory name
                Directory$ = finddata.cFileName
                Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

                ' check unicode
                Unicode = 0
                IF INSTR(Directory$, "?") THEN
                    Unicode = -1
                    Directory$ = finddata.cAlternateFileName
                    V = INSTR(Directory$, CHR$(0))
                    IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                END IF

                ' check directory name
                IF Directory$ <> "." AND Directory$ <> ".." THEN
                    ' make next search directory
                    Next.Directory$ = Directory.Search$ + Directory$ + "\"

                    ' recursively search subdirectories
                    CALL Directories(Next.Directory$, Filename.Search$)
                END IF
            END IF
        LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
        x = FindClose(Wfile.Handle)
    END IF
END IF
END SUB

' subroutine to access filenames in directory
SUB Filenames (Directory.Search$, Filename.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make filename
ASCIIZ = Directory.Search$ + Filename.Search$ + CHR$(0)

Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' check directory attribute
    Attribute = finddata.dwFileAttributes

    ' check for directory
    IF (Attribute AND &H10) = &H10 THEN
        ' display directory being searched
        CALL DisplayDirectory(Directory.Search$)

        ' increment directories actually searched
        Dirs.Counted = Dirs.Counted + 1#
    END IF

    ' recurse filename
    DO
        ' store filename
        Filename$ = finddata.cFileName
        Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN

            ' store file data
            finddatatemp = finddata

            ' store file size
            File.Size = finddata.nFileSizeHigh * &H100000000~&& OR finddata.nFileSizeLow

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            IF (Attribute AND &H10) <> &H10 THEN
                CALL DisplayFiles(Directory.Search$, Filename$)
            END IF
        END IF

        ' check to quit
        IF Quit.Deleting THEN
            EXIT DO
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to display directory
SUB DisplayDirectory (Directory.Search$)
IF Display.Search THEN
    Filename$ = Directory.Search$
    IF Filename$ <> "\" THEN
        IF Remove.Slash THEN
            Slash = LEN(Filename$)
            Filename$ = LEFT$(Filename$, Slash - 1)
        END IF
    END IF
    IF Prepend.Drive THEN
        IF LEFT$(Filename$, 2) <> "\\" THEN
            Filename$ = Drive.Search + ":" + Filename$
        END IF
    END IF
    COLOR Green, Black
    PRINT Filename$
END IF
END SUB

' subroutine to count and display filenames
SUB DisplayFiles (Directory.Search$, Filename.Search$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG

' check directory attribute
Attribute = finddatatemp.dwFileAttributes

' check for readonly file
IF (Attribute AND &H1) = &H1 THEN
    IF No.Display.Readonly THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Readonly THEN
        EXIT SUB
    END IF
END IF

' check for hidden file
IF (Attribute AND &H2) = &H2 THEN
    IF No.Display.Hidden THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Hidden THEN
        EXIT SUB
    END IF
END IF

' check for system file
IF (Attribute AND &H4) = &H4 THEN
    IF No.Display.System THEN
        EXIT SUB
    END IF
ELSE
    IF Display.System THEN
        EXIT SUB
    END IF
END IF

' check for archive file
IF (Attribute AND &H20) = &H20 THEN
    IF No.Display.Archive THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Archive THEN
        EXIT SUB
    END IF
END IF

' check for compressed file
IF (Attribute AND &H800) = &H800 THEN
    IF No.Display.Compress THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Compress THEN
        EXIT SUB
    END IF
END IF

' check for encrypted file
IF (Attribute AND &H4000) = &H4000 THEN
    IF No.Display.Encrypt THEN
        EXIT SUB
    END IF
ELSE
    IF Display.Encrypt THEN
        EXIT SUB
    END IF
END IF

' check all attributes
IF Display.Any THEN
    IF (Attribute AND &H1) = &H1 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H2) = &H2 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H4) = &H4 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H20) = &H20 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H800) = &H800 THEN
        EXIT SUB
    END IF
    IF (Attribute AND &H4000) = &H4000 THEN
        EXIT SUB
    END IF
END IF
IF No.Display.Any THEN
    IF (Attribute AND &H1) = False THEN
        IF (Attribute AND &H2) = False THEN
            IF (Attribute AND &H4) = False THEN
                IF (Attribute AND &H20) = False THEN
                    IF (Attribute AND &H800) = False THEN
                        IF (Attribute AND &H4000) = False THEN
                            EXIT SUB
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF

' check file size
IF Search.File.Size THEN
    IF Search.Size.From = FalseD AND Search.Size.To = FalseD THEN
        IF File.Size <> FalseD THEN
            EXIT SUB
        END IF
    ELSE
        IF Search.Size.From > FalseD OR Search.Size.To > FalseD THEN
            IF Search.Size.From > FalseD THEN
                IF Search.Size.To = FalseD THEN
                    IF File.Size < Search.Size.From THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
            IF Search.Size.From = FalseD THEN
                IF Search.Size.To > FalseD THEN
                    IF File.Size > Search.Size.To THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
            IF Search.Size.From <= Search.Size.To THEN
                IF File.Size < Search.Size.From OR File.Size > Search.Size.To THEN
                    EXIT SUB
                END IF
            END IF
            IF Search.Size.From > Search.Size.To THEN
                IF File.Size < Search.Size.From AND File.Size > Search.Size.To THEN
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
END IF

' store file date and time
IF Creation.Time THEN
    x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
    GOSUB Convert.Date
    GOSUB Convert.Time
ELSE
    IF Access.Time THEN
        x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
        GOSUB Convert.Date
        GOSUB Convert.Time
    ELSE
        IF Modified.Time THEN
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
            GOSUB Convert.Date
            GOSUB Convert.Time
        END IF
    END IF
END IF

' check date\time range
IF Search.From.Date OR Search.To.Date THEN
    IF File.Work.Date < Search.From.Date THEN
        EXIT SUB
    END IF
    IF File.Work.Date > Search.To.Date THEN
        EXIT SUB
    END IF
END IF
IF Search.From.Time OR Search.To.Time THEN
    IF File.Work.Time < Search.From.Time THEN
        EXIT SUB
    END IF
    IF File.Work.Time > Search.To.Time THEN
        EXIT SUB
    END IF
END IF

' make directory filename
IF Display.Filenames THEN
    Filename$ = Directory.Search$ + Filename.Search$
    IF Prepend.Drive THEN
        IF LEFT$(Filename$, 2) <> "\\" THEN
            Filename$ = Drive.Search + ":" + Filename$
        END IF
    END IF
    COLOR Yellow, Black
    PRINT Filename$
END IF

' update bytes counted
Bytes.Counted = Bytes.Counted + File.Size

' update files counter
Files.Counted = Files.Counted + 1#

' check count flag
CALL StoreFileLines(Directory.Search$, Filename.Search$)
EXIT SUB

Convert.Date:
YearTemp! = SysTime.wYear
MonthTemp! = SysTime.wMonth
DayTemp! = SysTime.wDay
File.Date$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wMonth)), 2) + "-"
File.Date$ = File.Date$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wDay)), 2) + "-"
File.Date$ = File.Date$ + LTRIM$(STR$(SysTime.wYear))
File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
RETURN

Convert.Time:
HourTemp! = SysTime.wHour
MinuteTemp! = SysTime.wMinute
SecondsTemp! = SysTime.wSecond
File.Time$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wHour)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wMinute)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wSecond)), 2)
File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
RETURN
END SUB

' subroutine to count lines in a filename
SUB StoreFileLines (Directory.Search$, Filename.Search$)
' make filename
Filename.Count$ = Directory.Search$ + Filename.Search$

' store full directory pathname
Lines.Counted = Lines.Counted + 1
IF Lines.Counted > Max.Lines THEN
    Max.Lines = Max.Lines + 16
    REDIM _PRESERVE Sort.Array(1 TO Max.Lines) AS STRING
END IF
Sort.Array(Lines.Counted) = Filename.Count$
END SUB

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
x$ = ""
s$ = STR$(s#)
IF INSTR(s$, "D") THEN ' return string
    FormatString$ = s$
    EXIT FUNCTION
END IF
IF LEFT$(s$, 1) = "-" THEN ' store sign
    e$ = "-"
    s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
    q$ = MID$(s$, INSTR(s$, "."))
    s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


