Rem file: Zsort.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DefInt A-Z
Rem $DYNAMIC
_Title "ZSORT"

' define boolean values
Const True = -1
Const False = Not True
Const TrueD = -1#
Const FalseD = Not TrueD
Const NUL = ""

' define color values
Const Black = 0
Const Cyan = 11
Const Green = 10
Const Plain = 7
Const Red = 12
Const White = 15
Const Yellow = 14

' declare work variables
Dim Shared Reverse.Sort As Integer, Sort.Column As Integer
Dim Shared Lines.Counted As Double, Max.Lines As Double
Dim Shared Ignore.Case As Integer, Continuous.Display As Integer
Dim Shared Strip.Blanks As Integer, Sort.Swaps As Double
Dim Shared Last.Switch As Integer, Switch.Exist As Integer

' declare sort variables
Dim Shared Num As Double, Span As Double, Start As Double, Element As Double

' declare sort array
Dim Shared Sort.Array(1) As String

' declare command line work variables
Dim Shared Command.Line As String

' declare external libraries.
Declare Dynamic Library "kernel32"
    Function SetCurrentDirectoryA% (f$)
End Declare

' declare standard error trap
On Error GoTo Error.Routine

' redimension sort array
ReDim Sort.Array(1 To 128) As String

' reset count variables
Max.Lines = 128

' force default path
x$ = _StartDir$
f$ = x$ + Chr$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
If Command$ = "/?" Then
    GoTo Boot.Usage
End If

' read command line
Command.Line = RTrim$(Read.Command$)

' check command line switches
Continuous.Display = ParseLine("/C")
Ignore.Case = ParseLine("/I")
Reverse.Sort = ParseLine("/R")
Strip.Blanks = ParseLine("/T")

' get sort column
Sort.Column = 1
Imbedded = InStr(UCase$(Command.Line), "/N")
If Imbedded Then
    Var = LastSwitch(Imbedded)
    Imbedded2 = Imbedded + 2
    Do
        Switch$ = Mid$(Command.Line, Imbedded2, 1)
        If Switch$ >= "0" And Switch$ <= "9" Then
            Column$ = Column$ + Switch$
        Else
            Exit Do
        End If
        Imbedded2 = Imbedded2 + 1
    Loop
    If Column$ = NUL Then
        GoTo Boot.Error
    End If
    Sort.Column = Int(Val(Column$))
    If Sort.Column = False Then
        GoTo Boot.Error
    End If
    Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded2)
End If

' recheck command line
If InStr(Command.Line, "/") Then
    GoTo Boot.Error
End If
Command.Line = RTrim$(LTrim$(Command.Line))
If Command.Line = "" Then
    GoTo Boot.Error
End If

v = InStr(Command.Line, " ")
If v Then
    Filename1$ = Left$(Command.Line, v - 1)
    Filename2$ = Mid$(Command.Line, v + 1)
Else
    Filename1$ = Command.Line
    Filename2$ = "scrn:"
    If Filename1$ = "" Then
        GoTo Boot.Error
    End If
End If
If _FileExists(Filename1$) = 0 Then
    GoTo Boot.Error
End If
Open Filename1$ For Binary As #1
Count# = 0#
If LOF(1) > 0 Then
    Do Until EOF(1)
        Line Input #1, line1$
        Count# = Count# + Len(line1$) + 2#
        Lines.Counted = Lines.Counted + 1
        If Lines.Counted > Max.Lines Then
            Max.Lines = Max.Lines + 16
            ReDim _Preserve Sort.Array(Max.Lines) As String
        End If
        Sort.Array(Lines.Counted) = line1$
    Loop
    If Count# < LOF(1) Then
        Lines.Counted = Lines.Counted + 1
        If Lines.Counted > Max.Lines Then
            Max.Lines = Max.Lines + 16
            ReDim _Preserve Sort.Array(Max.Lines) As String
        End If
        Sort.Array(Lines.Counted) = ""
    End If
End If
Close #1

' shell sort
Sort.Swaps = False
Num = Lines.Counted
Span = Int(Num / 2)
Do While Span > False
    For Start = Span To Num - 1
        For Element = (Start - Span + 1) To 1 Step -Span
            Sort.Column1$ = RTrim$(Mid$(Sort.Array(Element), Sort.Column))
            Sort.Column2$ = RTrim$(Mid$(Sort.Array(Element + Span), Sort.Column))
            If Ignore.Case Then
                Sort.Column1$ = UCase$(Sort.Column1$)
                Sort.Column2$ = UCase$(Sort.Column2$)
            End If
            If Reverse.Sort Then
                If Sort.Column2$ = "" Then
                    Exit For
                Else
                    If Sort.Column2$ <= Sort.Column1$ Then
                        Exit For
                    End If
                End If
            Else
                If Sort.Column1$ = "" Then
                    Exit For
                Else
                    If Sort.Column1$ <= Sort.Column2$ Then
                        Exit For
                    End If
                End If
            End If
            Swap Sort.Array(Element), Sort.Array(Element + Span)
            Sort.Swaps = Sort.Swaps + 1
        Next
    Next
    Span = Int(Span / 2)
Loop

' output array
Open Filename2$ For Output As #1
For Array.Line# = 1 To Lines.Counted
    x$ = RTrim$(Sort.Array(Array.Line#))
    If x$ = "" Then
        If Strip.Blanks = 0 Then
            Print #1, Sort.Array(Array.Line#)
        End If
    Else
        If LCase$(Filename2$) = "scrn:" Then
            _ControlChr Off
            Print Sort.Array(Array.Line#)
            _ControlChr On
        Else
            Print #1, Sort.Array(Array.Line#)
        End If
    End If
Next
Close #1
End.Zsort:

' display counters
If Continuous.Display = False Then
    Color Yellow, Black
    Print "Lines counted"; Lines.Counted
    Print "Sort swaps made"; Sort.Swaps
    Prompt$ = "Press <enter> to exit to DOS:"
    Call MorePrompt(Prompt$, Chr$(13), Outpt$)
End If
Color Plain, Black
End

Boot.Usage:
' make header
Color White, Black
Print "Zsort v1.0a: Sort utility; "
Color Yellow, Black
Print "Usage:"
Print "   Zsort <inputname> [<outputname>] [/cinrt]"
Print "Where:"
Print "   <inputname> is the pathname of the input file."
Print "   <outputname> is the optional pathname of the output file."
Print "Switches:"
Print "   /c  continuous list"
Print "   /i  ignore case"
Print "   /n###  sort at column"
Print "   /r  reverse order"
Print "   /t  strip blank lines"
Color Plain, Black
End

Boot.Error:
Color White, Black
Print "Command line error. Type Zsort /? for help."
Color Plain, Black
End

' critical error trap
Error.Routine:
DataError = Err
Color Green, Black
Select Case DataError
    Case 9
        Print "Subscript out of range."
        Color 7, 0
        End
    Case 14
        Print "Out of string space."
        Color 7, 0
        End
    Case Else
        Temp.Outpt$ = "Critical error:" + Str$(DataError) + " IDE line:" + Str$(_ErrorLine)
End Select
Print Temp.Outpt$
Prompt$ = "Press R to retry, Q to quit, C to continue:"
Call MorePrompt(Prompt$, "rqc", Outpt$)
Select Case Outpt$
    Case "r"
        Resume
    Case "q"
        Error.Level = True
        Resume End.Zsort
    Case "c"
        Resume Next
End Select
Color Plain, Black
End 0

Sub MorePrompt (Input.String$, Input.Mask$, Output.String$)
    Color White, Black
    Print Input.String$ + " ";
    Input.Char$ = NUL
    Locate , , 1
    Do
        _Limit 100
        Input.Char$ = InKey$
        If Len(Input.Char$) Then
            Input.Char$ = LCase$(Input.Char$)
            If InStr(Input.Mask$, Input.Char$) Then
                Print Input.Char$
                Output.String$ = Input.Char$
                Exit Do
            End If
        End If
    Loop
End Sub

' command line switch position function.
Function LastSwitch (Var)
    LastSwitch = -1
    If Last.Switch = 0 Then
        Last.Switch = Var - 1
        Switch.Exist = -1
    Else
        If Var < Last.Switch Then
            Last.Switch = Var - 1
            Switch.Exist = -1
        End If
    End If
End Function

' command line parser
Function ParseLine (X$)
    Imbedded = InStr(Command.Line, LCase$(X$))
    If Imbedded Then
        Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    Else
        Imbedded = InStr(Command.Line, UCase$(X$))
        If Imbedded Then
            Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
            Last.Switch = Imbedded - 1
            ParseLine = True
            Switch.Exist = -1
        Else
            ParseLine = False
        End If
    End If
End Function

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


