Rem File compare utility. v1.1a PD 04/10/2025 QB64.

' store all default variables as integer
DefInt A-Z

' dimension arrays at runtime
Rem $Dynamic

' declare common variables
Dim Shared Buffer1 As String * 1
Dim Shared Buffer2 As String * 1
Dim Shared BufferFileName1 As String
Dim Shared BufferFileName2 As String
Dim Shared BypassPrompt As Integer
Dim Shared File1 As String
Dim Shared File2 As String
Dim Shared FileLength1 As Double
Dim Shared FileLength2 As Double
Dim Shared FileName As String
Dim Shared FileName2 As String
Dim Shared Position As Double
Dim Shared Position1 As Double
Dim Shared Position2 As Double
Dim Shared TotalBytes As Double

' declare constants
Const True = -1
Const False = 0
Const DFalse = 0#
Const Nul = ""

Dim Shared Quote As String * 1
Quote = Chr$(34)

' declare error routine
On Error GoTo Error.Routine

' display banner
_ScreenMove _Middle
_Title "FILECOMP"
Color 15, 0
Print "File compare v1.1a QB64."

' check command line
X$ = UCase$(Read.Command$)
X$ = Ltrim$(Rtrim$(X$))
If X$ = "/?" Then
   GoTo BootUsage
End If
L = InStr(X$, "/C")
If L > 0 Then
   BypassPrompt = True
   X$ = Left$(X$, L - 1) + Mid$(X$, L + 2)
End If
L = InStr(X$, "/L")
If L > 0 Then
   DisplayType = 1
   X$ = Left$(X$, L - 1) + Mid$(X$, L + 2)
Else
   L = InStr(X$, "/P")
   If L > 0 Then
      DisplayType = 3
      X$ = Left$(X$, L - 1) + Mid$(X$, L + 2)
   End If
End If
Do
   X$ = LTrim$(X$)
   X$ = RTrim$(X$)
   If Left$(X$, 3) = "/O:" Then
      If DisplayType > 0 Then
         GoTo BootError
      End If
      F = 0
      X$ = Mid$(X$, 4)
      If Left$(X$, 1) = Quote Then
         For L = 2 To Len(X$)
            If Mid$(X$, L, 1) = Quote Then
               DisplayType = 2
               FileName2 = Left$(X$, L - 1)
               FileName2 = Mid$(FileName2, 2)
               Open FileName2 For Append As #1
               X$ = Mid$(X$, L + 1)
               F = -1
               Exit For
            End If
         Next
      End If
      If F = 0 Then
         GoTo BootError
      End If
   Else
      If Left$(X$, 4) = "/F1:" Then
         If Len(F1$) Then
            GoTo BootError
         End If
         F = 0
         X$ = Mid$(X$, 5)
         If Left$(X$, 1) = Quote Then
            For L = 2 To Len(X$)
               If Mid$(X$, L, 1) = Quote Then
                  F1$ = Left$(X$, L - 1)
                  F1$ = Mid$(F1$, 2)
                  X$ = Mid$(X$, L + 1)
                  F = -1
                  Exit For
               End If
            Next
         End If
         If F = 0 Then
            GoTo BootError
         End If
      Else
         If Left$(X$, 4) = "/F2:" Then
            If Len(F2$) Then
               GoTo BootError
            End If
            F = 0
            X$ = Mid$(X$, 5)
            If Left$(X$, 1) = Quote Then
               For L = 2 To Len(X$)
                  If Mid$(X$, L, 1) = Quote Then
                     F2$ = Left$(X$, L - 1)
                     F2$ = Mid$(F2$, 2)
                     X$ = Mid$(X$, L + 1)
                     F = -1
                     Exit For
                  End If
               Next
            End If
            If F = 0 Then
               GoTo BootError
            End If
         Else
            Exit Do
         End If
      End If
   End If
Loop
X$ = RTrim$(X$)
If Len(X$) Then
   GoTo BootError
End If
If DisplayType = 0 Then
   ' read output type
   Color 14, 0
   Do
      Print "Output type(1=screen,2=file,3=printer,4=quit)? ";
      Locate , , 1
      Do
         _Limit 100
         InputChar$ = InKey$
         If InputChar$ >= "1" And InputChar$ <= "4" Then
            Exit Do
         End If
      Loop
      Print InputChar$
      DisplayType = Int(Val(InputChar$))
      Select Case DisplayType
         Case 1, 3 ' screen/lpt
            Exit Do
         Case 2
            FileName2 = _SaveFileDialog$("Output Filename", _CWD$)
            If Len(FileName2) Then
               If _FileExists(FileName2) Then
                  Print "File exists. Append anyway(y/n)";
                  Do
                     _Limit 100
                     InputChar$ = InKey$
                     If LCase$(InputChar$) = "y" Then
                        Print "y"
                        Exit Do
                     End If
                     If LCase$(InputChar$) = "n" Then
                        Print "n"
                        GoTo Terminate
                     End If
                  Loop
               End If
               Open FileName2 For Append As #1
               Exit Do
            End If
         Case 4
            GoTo Terminate
      End Select
   Loop
End If

' read filename#1
Do
   If Len(F1$) Then
      BufferFileName1 = F1$
   Else
      BufferFileName1 = _OpenFileDialog$("Filename#1", _CWD$)
      If BufferFileName1 = Nul Then
         GoTo Terminate
      End If
   End If
   FileName = BufferFileName1
   File1 = BufferFileName1
   GoSub GetFileInfo
   If Temp# = DFalse Then
      Color 15
      Print "File: "; Quote; BufferFileName1; Quote; " is zero-length."
      If Len(F1$) Then
         GoTo Terminate
      End If
   Else
      If Temp# = -1# Then
         Color 15
         Print "File: "; Quote; BufferFileName1; Quote; " does not exist."
         If Len(F1$) Then
            GoTo Terminate
         End If
      Else
         Exit Do
      End If
   End If
Loop
FileLength1 = Temp#
BufferFileName1 = FileName3$

' read filename#2
Do
   If Len(F2$) Then
      BufferFileName2 = F2$
   Else
      BufferFileName2 = _OpenFileDialog$("Filename#2", _CWD$)
      If BufferFileName2 = Nul Then
         GoTo Terminate
      End If
   End If
   FileName = BufferFileName2
   File2 = BufferFileName2
   GoSub GetFileInfo
   If Temp# = DFalse Then
      Color 15
      Print "File: "; Quote; BufferFileName2; Quote; " is zero-length."
      If Len(F2$) Then
         GoTo Terminate
      End If
   Else
      If Temp# = -1# Then
         Color 15
         Print "File "; Quote; BufferFileName2; Quote; " does not exist."
         If Len(F2$) Then
            GoTo Terminate
         End If
      Else
         Exit Do
      End If
   End If
Loop
FileLength2 = Temp#
BufferFileName2 = FileName3$

' compare file sizes
If FileLength1 <> FileLength2 Then
   Print "Files are different size."
   GoTo Terminate
End If

' check equivalent files
If File1 = File2 Then
   Print "Files are exactly the same."
   GoTo Terminate
End If

' open files for input
Open File1 For Binary As #4
Open File2 For Binary As #5

' reset display flags
Display1 = False
QuitFlag = False

' file input loop
Do
   ' read from file1
   Buffer1 = Nul
   Position1 = Position1 + 1
   Get #4, Position1, Buffer1

   ' read from file2
   Buffer2 = Nul
   Position2 = Position2 + 1
   Get #5, Position2, Buffer2

   ' check buffers
   If Buffer1 <> Buffer2 Then

      ' check display flag
      If Display1 = False Then
         GoSub Header
      End If

      ' display prompt
      If DisplayType = 1 Then
         If LineCount = 23 Then
            If BypassPrompt = False Then
               Color 15, 0
               Print "Press any key(q to quit):";
               Locate , , 1
               InputChar$ = Nul
               Do
                  _Limit 100
                  InputChar$ = InKey$
                  If InputChar$ <> Nul Then
                     If LCase$(InputChar$) = "q" Then
                        Print "q";
                        QuitFlag = True
                     End If
                     Exit Do
                  End If
               Loop
               Print
               If QuitFlag Then
                  Exit Do
               End If
            End If
            GoSub Header
         End If
      End If

      ' printer formfeed
      If DisplayType = 3 Then
         If LineCount >= 55 Then
            LPrint Chr$(12);
            GoSub Header
         End If
      End If

      ' create output string
      Output$ = "0x" + Right$("00000000" + Hex$(Position), 8) + " "
      Output$ = Output$ + "(" + Right$("0000000000" + Mid$(Str$(Position + 1), 2), 10) + ") "

      Var1 = Asc(Buffer1)
      Var1$ = "0x" + Right$("000" + Hex$(Var1), 2) + " "
      Var1$ = Var1$ + "(" + Right$("000" + Mid$(Str$(Var1), 2), 3) + ")"

      Var2 = Asc(Buffer2)
      Var2$ = "0x" + Right$("000" + Hex$(Var2), 2) + " "
      Var2$ = Var2$ + "(" + Right$("000" + Mid$(Str$(Var2), 2), 3) + ")"

      Output$ = Output$ + "   " + Var1$
      Output$ = Output$ + "   " + Var2$

      ' output string
      Select Case DisplayType
         Case 1 ' display on screen
            Color 14, 0
            Print Output$
            LineCount = LineCount + 1
         Case 2 ' print to file
            Print #1, Output$
         Case 3 ' send to printer
            LPrint Output$
            LineCount = LineCount + 1
      End Select

      ' increment mismatched byte counter
      TotalBytes = TotalBytes + 1#
   End If

   ' check escape key
   If InKey$ = Chr$(27) Then
      QuitFlag = True
   End If

   ' check quit flag
   If QuitFlag Then
      Exit Do
   End If

   ' increment file position
   Position = Position + 1
   If Position > FileLength1 Then
      Exit Do
   End If
Loop

' display final message
Color 15, 0
If Display1 = False Then
   Output$ = "Files: " + BufferFileName1 + "(" + Mid$(Str$(FileLength1), 2) + ")"
   Output$ = Output$ + " - " + BufferFileName2 + "(" + Mid$(Str$(FileLength2), 2) + ")"
   Output$ = Output$ + " are equal."
   Print Output$
   If DisplayType = 2 Then
      Print #1, ""
      Print #1, "FileComp: " + Date$ + " " + Time$
      Print #1, Output$
   Else
      If DisplayType = 3 Then
         LPrint Output$
      End If
   End If
Else
   Output$ = "Total bytes not matching:" + Str$(TotalBytes)
   Print Output$
   If DisplayType = 2 Then
      Print #1, Output$
   End If
   If DisplayType = 3 Then
      LPrint Output$
   End If
End If
If DisplayType = 2 Then
   Print "File info appended to " + FileName2
End If
If DisplayType = 3 Then
   LPrint Chr$(12);
End If
If DisplayType = 1 Then
   If BypassPrompt = False Then
      Print "Press any key:";
      Locate , , 1
      Do
         _Limit 100
         If InKey$ <> Nul Then
            Exit Do
         End If
      Loop
      Print
   End If
End If

' terminate program
Terminate:
Color 7, 0
Print "Returning to system:"
End

' display header
Header:
Color 15, 0
LineCount = 2
If Display1 = False Then
   LineCount = 3
   Output2$ = "Files: " + BufferFileName1 + "(" + Mid$(Str$(FileLength1), 2) + ")"
   Output2$ = Output2$ + " - " + BufferFileName2 + "(" + Mid$(Str$(FileLength2), 2) + ")"
   If DisplayType = 1 Then
      Print Output2$
   Else
      If DisplayType = 2 Then
         Print #1, ""
         Print #1, "FileComp: " + Date$ + " " + Time$
         Print #1, Output2$
      Else
         If DisplayType = 3 Then
            LPrint Output2$
         End If
      End If
   End If
End If
If Display1 Then
   If DisplayType = 1 Then
      If BypassPrompt Then
         Return
      End If
   End If
End If
Display1 = True
Strng1$ = BufferFileName1
Strng1$ = Strng1$ + Space$(12 - Len(Strng1$))
Strng2$ = BufferFileName2
Strng2$ = Strng2$ + Space$(12 - Len(Strng2$))
Output2$ = "Position offset (hex/asc)  " + Strng1$ + " " + Strng2$
Output3$ = "-------------------------  ------------ ------------"
If DisplayType = 1 Then
   Print Output2$
   Print Output3$
Else
   If DisplayType = 2 Then
      Print #1, Output2$
      Print #1, Output3$
   Else
      If DisplayType = 3 Then
         LPrint Output2$
         LPrint Output3$
      End If
   End If
End If
Return

' read filesize
GetFileInfo:
' reset filesize
Temp# = DFalse

' check file exists
FileName3$ = RTrim$(FileName)
If _FileExists(FileName3$) = 0 Then
   Temp# = -1#
   Return
End If

' open filename
Close #3
Open FileName3$ For Binary As #3

' store file size
Temp# = LOF(3)
Return

' boot error display
BootError:
Color 14, 0
Print "Command line error. Type Filecomp /? for help."
Color 7, 0
End

' boot usage display
BootUsage:
Color 14, 0
Print "Usage:"
Outpt$ = "  Filecomp [/C][/L|/P|/O:" + Quote + "file.ext" + Quote + "]"
Outpt$ = Outpt$ + "[/F1:" + Quote + "file.ext" + Quote + "]"
Outpt$ = Outpt$ + "[/F2:" + Quote + "file.ext" + Quote + "]"
Print Outpt$
Print "Where:"
Print "  /C  bypass prompts"
Print "Output:"
Print "  /L  display to screen, or"
Print "  /P  send to printer, or"
Print "  /O:" + Quote + "filename.ext" + Quote + " send to output file."
Print "    (must be enclosed in quotes)"
Print "Files to compare are:"
Print "  /F1:" + Quote + "c:\path\filename.ext" + Quote
Print "  /F2:" + Quote + "c:\path\filename.ext" + Quote
Print "    (must be enclosed in quotes)"
GoTo Terminate

' critical error trap
Error.Routine:
Color 7, 0
ErrorNum = Err
Temp.Outpt$ = "Critical error:" + Str$(ErrorNum)
Print Temp.Outpt$
Temp.Outpt$ = "IDE line:" + Str$(_ErrorLine)
Print Temp.Outpt$
End

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function

