REM Displays total/free/used disk space.

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1
CONST ERROR_FILE_NOT_FOUND = 2
CONST ERROR_NO_MORE_FILES = &H12

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
    FUNCTION GetDiskFreeSpaceExA& (filename$, free AS _UNSIGNED _INTEGER64, total AS _UNSIGNED _INTEGER64, free2 AS _UNSIGNED _INTEGER64)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED finddata AS WIN32_FIND_DATAA
DIM SHARED hfind AS _UNSIGNED _OFFSET
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING

Param$ = Ltrim$(Rtrim$(Read.Command$))
IF LEN(Param$) = 0 THEN
    COLOR 15
    PRINT "Enter drive letter(s): ";
    LINE INPUT Param$
END IF
IF LEN(Param$) THEN
    CALL List.Drives(Param$)
END IF
END

' lists specified drives
SUB List.Drives (Var$)
GOSUB drive.header
L = 0
X$ = UCASE$(Var$)
FOR C = 1 TO 26
    X = INSTR(X$, CHR$(C + 64))
    IF X THEN
        X = ASC(MID$(X$, X, 1))
        IF X >= 65 AND X <= 90 THEN
            X = X - 64
            IF C = X THEN
                GOSUB DisplayDrive
            END IF
        END IF
    END IF
    IF H = 20 THEN
        H = 0
        PRINT "-more-";
        WHILE INKEY$ = ""
        WEND
        PRINT
        GOSUB drive.header
    END IF
NEXT
COLOR 15, 0
IF Q = 0 THEN
    PRINT "<none>"
ELSE
    PRINT "Total drives"; L
END IF
EXIT SUB

DisplayDrive:
IF DRIVEEXISTS(C) = 0 THEN
    C$ = CHR$(C + 64)
    Out3$ = C$
    CALL TotalSpace(Out3$)
    X# = INT(VAL(Out3$))
    X1# = X#
    IF X# > 0# THEN
        H = H + 1
        L = L + 1
        Q = -1
        COLOR 14, 0
        PRINT C$; ":    ";
        S$ = STR$(X#)
        PRINT S$; SPACE$(16 - LEN(S$));
        Out3$ = C$
        CALL FreeSpace(Out3$)
        Y# = INT(VAL(Out3$))
        Y1# = Y#
        IF Y# > 0# THEN
            S$ = STR$(Y#)
        ELSE
            S$ = " <n/a>"
        END IF
        PRINT S$; SPACE$(16 - LEN(S$));
        IF X1# > 0# OR Y1# > 0# THEN
            Z# = X1# - Y1#
            S$ = STR$(Z#)
        ELSE
            S$ = " <n/a>"
        END IF
        PRINT S$
    END IF
END IF
RETURN

drive.header:
H = 2
COLOR 15, 0
PRINT "Drive  Total           Free            Used"
PRINT "-------------------------------------------"
RETURN
END SUB

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = ""
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = 0
ELSE
    DRIVEEXISTS = -1
END IF
END FUNCTION

' get drive freespace
SUB FreeSpace (Var$)
VarX$ = Var$ + ":\" + CHR$(0)
Var$ = ""
IF DriveType = "[CDROM]" THEN
    EXIT SUB
END IF
IF DriveType = "[REMOVABLE]" THEN
    EXIT SUB
END IF
R = GetDiskFreeSpaceExA(VarX$, free~&&, total~&&, free2~&&)
IF R THEN
    Var$ = LTRIM$(STR$(free~&&))
END IF
END SUB

' get drive totalspace
SUB TotalSpace (Var$)
VarX$ = Var$ + ":\" + CHR$(0)
Var$ = ""
IF DriveType = "[CDROM]" THEN
    EXIT SUB
END IF
IF DriveType = "[REMOVABLE]" THEN
    EXIT SUB
END IF
R = GetDiskFreeSpaceExA(VarX$, free~&&, total~&&, free2~&&)
IF R THEN
    Var$ = LTRIM$(STR$(total~&&))
END IF
END SUB

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function

