REM file: Nameit.bas - QB64 Utility v2.0a PD 2017.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "NAMEIT"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare work variables
DIM SHARED Continuous.Display AS INTEGER
DIM SHARED Display.Errors AS INTEGER
DIM SHARED Lower.Case AS INTEGER
DIM SHARED New.Name AS INTEGER
DIM SHARED Sensitive AS INTEGER
DIM SHARED Dir.Search AS INTEGER
DIM SHARED Quit.Searching AS INTEGER
DIM SHARED Output.Line AS STRING
DIM SHARED Lines.Couned AS INTEGER
DIM SHARED Dirs.Counted AS DOUBLE
DIM SHARED Files.Counted AS DOUBLE
DIM SHARED List.Only.Source AS INTEGER
DIM SHARED List.Only.Dest AS INTEGER
DIM SHARED List.Only.Not AS INTEGER
DIM SHARED List.Only.Short AS INTEGER
DIM SHARED Debug.Mode AS INTEGER
DIM SHARED DriveType AS STRING
DIM SHARED Short.Filename AS STRING

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST MAX_PATH2 = 520 ' length of a Unicode ASCIIZ string
CONST INVALID_HANDLE_VALUE = -1

' declare unicode variables
DIM SHARED FileIsUnicode AS INTEGER
DIM SHARED UnicodeShort AS STRING
DIM SHARED UnicodeLong AS STRING

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' windows structure for a wide FindFile
TYPE WIN32_FIND_DATAW
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH2
    cAlternateFileName AS STRING * 28
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindFirstFileW~%& (lpwszFileName$, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileW& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION MoveFileW (f$, g$)

    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION GetLastError& ()
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetDriveType& (d$)
    FUNCTION MoveFile (f$, g$)
END DECLARE

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' read command line
Command.Line = LTrim$(Rtrim$(Read.Command$))
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' reset count variables
Display.Lines = False
Continuous.Display = False
Quit.Searching = False
Dirs.Counted = False
Files.Counted = False

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "Source files: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)

' get switches from command line
Continuous.Display = ParseLine("/C")
Dir.Search = ParseLine("/D")
Lower.Case = ParseLine("/L")
Sensitive = ParseLine("/S")
Display.Errors = ParseLine("/Z")
List.Only.Short = ParseLine("/0")
List.Only.Source = ParseLine("/1")
List.Only.Dest = ParseLine("/2")
List.Only.Not = ParseLine("/3")
Debug.Mode = ParseLine("/=")

Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' get new filename from command line
Command.Line = RTRIM$(Command.Line)
New.Name = False
New.File$ = ""
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    IF INSTR(Imbedded + 1, Command.Line, "/") THEN
        GOTO Boot.Error
    END IF
    New.Name = True
    New.File$ = MID$(Command.Line, Imbedded + 2)
    IF LEFT$(New.File$, 1) = CHR$(34) AND RIGHT$(New.File$, 1) = CHR$(34) THEN
        New.File$ = MID$(New.File$, 2)
        New.File$ = LEFT$(New.File$, LEN(New.File$) - 1)
    ELSE
        IF INSTR(New.File$, " ") THEN
            GOTO Boot.Error
        END IF
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1)
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GOSUB Header

' filename processing loop
DO

    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Standard.Input$ + Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF
    Command.Line = LTRIM$(Command.Line)
    Command.Line = RTRIM$(Command.Line)

    ' store current filename
    Old.File$ = Command.Work
    Command.Work = NUL

    ' rename filename
    IF New.Name = False THEN
        New.File$ = Old.File$
    END IF
    IF Lower.Case THEN
        New.File$ = LCASE$(New.File$)
    END IF

    ' display search filename
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        PRINT "Searching: " + Old.File$
    END IF

    ' rename filenames
    CALL Filenames(Old.File$, New.File$)

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

End.Nameit:

' display counters
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    Total$ = FormatString$(Dirs.Counted)
    PRINT "Directories counted: "; Total$
    Total$ = FormatString$(Files.Counted)
    PRINT "Files counted: "; Total$
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
IF Debug.Mode THEN
    SYSTEM
END IF
END

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Nameit v1.0a: File rename utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Nameit [\path\]filename.ext [/n][/0123cdlsz]"
PRINT "Where:"
PRINT "   /nfilename.ext  new filename"
PRINT "   /c  continuous display"
PRINT "   /d  rename only directories"
PRINT "   /l  force to lowercase"
PRINT "   /s  force case-sensitive matching"
PRINT "   /z  suppress error messages"
PRINT "   /0  only display short source filename"
PRINT "   /1  only display source filename"
PRINT "   /2  only display dest filename"
PRINT "   /3  don't display filenames"
COLOR Plain, Black
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Nameit /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, False
    PRINT "Nameit v1.0a: File rename utility; "
END IF
RETURN

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Nameit
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access filenames
SUB Filenames (OldPath$, NewPath$)
    ' declare subroutine variables
    DIM Attribute AS _UNSIGNED LONG
    DIM ASCIIZ AS STRING * 260
    DIM finddata AS WIN32_FIND_DATAA
    DIM Wfile.Handle AS _UNSIGNED _OFFSET

    ' declare wide functions
    DIM ASCIIZ.FileW AS STRING * MAX_PATH2 ' a null terminated filename
    DIM finddataw AS WIN32_FIND_DATAW ' the windows filename structure
    DIM Wfile.HandleW AS _UNSIGNED _OFFSET ' windows file handle for FindFile

    ' get drive from source
    Drive$ = ""
    IF MID$(OldPath$, 2, 1) = ":" THEN
        Drive$ = LEFT$(OldPath$, 2)
        V = ASC(UCASE$(LEFT$(Drive$, 1))) - 64
        IF MEDIAEXISTS(V) = 0 THEN
            CALL DisplayError("Error accessing source drive.")
            EXIT SUB
        END IF
    END IF

    ' get path from source
    Path$ = ""
    FOR I = LEN(OldPath$) TO 1 STEP -1
        IF MID$(OldPath$, I, 1) = "\" THEN
            Path$ = LEFT$(OldPath$, I)
            EXIT FOR
        END IF
    NEXT
    IF MID$(Path$, 2, 1) = ":" THEN
        Path$ = MID$(Path$, 3)
    END IF

    ' make filename
    Var$ = RTRIM$(OldPath$)
    ASCIIZ = Var$ + CHR$(0)
    Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
    IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN
        ' search filenames
        DO
            ' check directory attribute
            Attribute = finddata.dwFileAttributes
            Flag = 0
            IF (Attribute AND &H10) = &H10 THEN
                IF Dir.Search THEN
                    Dirs.Counted = Dirs.Counted + 1
                    Flag = -1
                END IF
            ELSE
                IF Dir.Search = 0 THEN
                    Files.Counted = Files.Counted + 1
                    Flag = -1
                END IF
            END IF
            IF Flag THEN

                ' store filename
                Filename$ = finddata.cFileName
                Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

                ' store short filename
                Short.Filename$ = finddata.cAlternateFileName
                V = INSTR(Short.Filename$, CHR$(0))
                IF V THEN Short.Filename$ = LEFT$(Short.Filename$, V - 1)
                IF Short.Filename$ = NUL THEN
                    Short.Filename$ = finddata.cFileName
                    V = INSTR(Short.Filename$, CHR$(0))
                    IF V THEN Short.Filename$ = LEFT$(Short.Filename$, V - 1)
                END IF

                ' check filename
                IF Filename$ <> "." AND Filename$ <> ".." THEN

                    ' check unicode
                    IF INSTR(Filename$, "?") THEN
                        WideZ$ = AsciiToWide$(Short.Filename$) + CHR$(0)
                        Wfile.HandleW = FindFirstFileW(WideZ$ + CHR$(0), _OFFSET(finddataw))
                        IF Wfile.HandleW <> INVALID_HANDLE_VALUE THEN
                            UnicodeLong = finddataw.cFileName
                            UnicodeLong = LEFT$(UnicodeLong, wzLength(UnicodeLong))
                            r = FindClose(Wfile.HandleW)
                            CALL RenameWideFile(Drive$, Path$, UnicodeLong, NewPath$)
                        ELSE
                            PRINT "Error 0x"; HEX$(GetLastError); " "; WideZ$
                        END IF
                    ELSE
                        CALL RenameFile(Drive$, Path$, Filename$, NewPath$)
                    END IF
                END IF
            END IF

            ' check to quit
            IF Quit.Searching THEN
                EXIT DO
            END IF
        LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
        x = FindClose(Wfile.Handle)
    END IF
END SUB

' subroutine to rename file
SUB RenameFile (Drive1$, Path1$, File1$, File2$)
    ' initialize filename buffer
    DIM OldASCIIZ AS STRING * 260
    DIM NewASCIIZ AS STRING * 260
    OldDrive$ = Drive1$
    OldPath$ = Path1$
    OldFile$ = File1$
    NewFile$ = File2$

    ' check case sensiive
    IF Sensitive = 0 THEN
        OldFile$ = LCASE$(OldFile$)
        NewFile$ = LCASE$(NewFile$)
    END IF

    ' get drive from destination
    Drive$ = ""
    IF MID$(NewFile$, 2, 1) = ":" THEN
        Drive$ = LEFT$(NewFile$, 2)
        V = ASC(UCASE$(LEFT$(Drive$, 1))) - 64
        IF MEDIAEXISTS(V) = 0 THEN
            CALL DisplayError("Error accessing destination drive.")
            EXIT SUB
        END IF
        NewFile$ = MID$(NewFile$, 3)
    END IF

    ' get path from destination
    Path$ = ""
    FOR I = LEN(NewFile$) TO 1 STEP -1
        IF MID$(NewFile$, I, 1) = "\" THEN
            Path$ = LEFT$(NewFile$, I)
            NewFile$ = MID$(NewFile$, I + 1)
            EXIT FOR
        END IF
    NEXT

    ' remove unicode
    DO
        Var = INSTR(OldFile$, "?")
        IF Var THEN
            MID$(OldFile$, Var, 1) = " "
        ELSE
            EXIT DO
        END IF
    LOOP

    ' call matching function
    Mask$ = MaskNewName$(OldFile$, NewFile$)
    IF LEN(Mask$) THEN
        ' rename file
        OldASCIIZ = OldDrive$ + OldPath$ + OldFile$ + CHR$(0)
        NewASCIIZ = Drive$ + Path$ + Mask$ + CHR$(0)
        r = MoveFile(OldASCIIZ, NewASCIIZ)

        ' check error and try to rename short 8.3 filename
        IF r = 0 THEN
            OldASCIIZ = OldDrive$ + OldPath$ + Short.Filename$ + CHR$(0)
            r = MoveFile(OldASCIIZ, NewASCIIZ)
        END IF

        ' display search filename
        IF List.Only.Short THEN
            Output.Line$ = Short.Filename$
        ELSE
            IF List.Only.Source THEN
                Output.Line$ = OldFile$
            ELSE
                IF List.Only.Dest THEN
                    Output.Line$ = Mask$
                ELSE
                    Output.Line$ = OldFile$ + " - " + Mask$
                END IF
            END IF
        END IF
        IF List.Only.Not = False THEN
            CALL DisplayFilename
        END IF
        IF Quit.Searching THEN
            EXIT SUB
        END IF

        ' display any errors
        IF r = 0 THEN
            CALL DisplayError("Error 0x" + HEX$(GetLastError&) + " renaming filename.")
        END IF
    END IF
END SUB

' subroutine to rename unicode file
SUB RenameWideFile (Drive1$, Path1$, File1$, File2$)
    OldDrive$ = Drive1$
    OldPath$ = Path1$
    OldFile$ = File1$
    NewFile$ = File2$

    ' get drive from destination
    Drive$ = ""
    IF MID$(NewFile$, 2, 1) = ":" THEN
        Drive$ = LEFT$(NewFile$, 2)
        V = ASC(UCASE$(LEFT$(Drive$, 1))) - 64
        IF MEDIAEXISTS(V) = 0 THEN
            CALL DisplayError("Error accessing destination drive.")
            EXIT SUB
        END IF
        NewFile$ = MID$(NewFile$, 3)
    END IF

    ' get path from destination
    Path$ = ""
    FOR I = LEN(NewFile$) TO 1 STEP -1
        IF MID$(NewFile$, I, 1) = "\" THEN
            Path$ = LEFT$(NewFile$, I)
            NewFile$ = MID$(NewFile$, I + 1)
            EXIT FOR
        END IF
    NEXT

    ' call matching function
    NewFile$ = AsciiToWide$(NewFile$)
    Mask$ = MaskNewWideName(OldFile$, NewFile$)

    IF LEN(Mask$) THEN
        ' rename file
        OldASCIIZ$ = AsciiToWide$(OldDrive$) + AsciiToWide$(OldPath$) + OldFile$ + CHR$(0) + CHR$(0)
        NewASCIIZ$ = AsciiToWide$(Drive$) + AsciiToWide$(Path$) + Mask$ + CHR$(0) + CHR$(0)
        r = MoveFileW(OldASCIIZ$, NewASCIIZ$)

        ' display search filename
        NewMask$ = WideToAscii$(Mask$)
        IF List.Only.Short THEN
            Output.Line$ = Short.Filename$
        ELSE
            IF List.Only.Source THEN
                Output.Line$ = Short.Filename$
            ELSE
                IF List.Only.Dest THEN
                    Output.Line$ = NewMask$
                ELSE
                    Output.Line$ = Short.Filename$ + " - " + NewMask$
                END IF
            END IF
        END IF
        IF List.Only.Not = False THEN
            CALL DisplayFilename
        END IF
        IF Quit.Searching THEN
            EXIT SUB
        END IF

        ' display any errors
        IF r = 0 THEN
            CALL DisplayError("Error 0x" + HEX$(GetLastError&) + " renaming filename.")
        END IF
    END IF
END SUB

' make a wide ascii filename
FUNCTION AsciiToWide$ (Var$)
    Var2$ = Var$
    FOR X = 1 TO LEN(Var2$)
        VarX$ = VarX$ + MID$(Var2$, X, 1) + CHR$(0)
    NEXT
    AsciiToWide$ = VarX$
END FUNCTION

' make an ansi filename
FUNCTION WideToAscii$ (Var$)
    Var2$ = Var$
    FOR X = 1 TO LEN(Var2$) STEP 2
        VarX$ = VarX$ + MID$(Var2$, X, 1)
    NEXT
    WideToAscii$ = VarX$
END FUNCTION

' displays output line with prompt
SUB DisplayFilename
    ' check display type
    IF Continuous.Display = False THEN

        ' check line length
        Outpt.Length = LEN(Output.Line)
        Outpt.Length = INT(Outpt.Length / 80) + 1

        ' prompt before display
        IF Lines.Counted + Outpt.Length >= 23 THEN
            ' store lines after prompt
            Lines.Counted = Outpt.Length
            Prompt$ = "More(y/n/c)?"
            CALL MorePrompt(Prompt$, "ync", Outpt2$)
            SELECT CASE Outpt2$
                CASE "c"
                    Continuous.Display = True
                CASE "n"
                    Quit.Searching = True
            END SELECT
        END IF
    END IF
    IF Quit.Searching THEN
        EXIT SUB
    END IF
    COLOR Yellow, Black
    PRINT Output.Line
END SUB

REM inputs a filename and matches wildcards returning masked output filename.
FUNCTION MaskNewName$ (path$, mask$)
    IF path$ = "" THEN
        EXIT FUNCTION
    END IF
    IF INSTR(path$, "?") OR INSTR(path$, "*") THEN
        EXIT FUNCTION
    END IF
    FOR m = 0 TO LEN(mask$) - 1
        ch$ = MID$(mask$, m + 1, 1)
        q$ = MID$(path$, x + 1, 1)
        z$ = MID$(mask$, m + 2, 1)
        SELECT CASE ch$
            CASE "?"
                IF LEN(q$) AND q$ <> "." THEN
                    R$ = R$ + q$
                    x = x + 1
                END IF
            CASE "*"
                IF m = LEN(mask$) - 1 THEN
                    WHILE x < LEN(path$)
                        R$ = R$ + MID$(path$, x + 1, 1)
                        x = x + 1
                    WEND
                ELSE
                    SELECT CASE z$
                        CASE "."
                            FOR i = LEN(path$) - 1 TO 0 STEP -1
                                IF MID$(path$, i + 1, 1) = "." THEN
                                    EXIT FOR
                                END IF
                            NEXT
                            IF i < 0 THEN
                                R$ = R$ + MID$(path$, x + 1) + "."
                                i = LEN(path$)
                            ELSE
                                R$ = R$ + MID$(path$, x + 1, i - x + 1)
                            END IF
                            x = i + 1
                            m = m + 1
                        CASE "?"
                            R$ = R$ + MID$(path$, x + 1)
                            m = m + 1
                            x = LEN(path$)
                        CASE ELSE
                            FOR i = LEN(path$) - 1 TO 0 STEP -1
                                x$ = MID$(path$, i + 1, 1)
                                IF UCASE$(x$) = UCASE$(z$) THEN
                                    EXIT FOR
                                END IF
                            NEXT
                            IF i < 0 THEN
                                R$ = R$ + MID$(path$, x + 1) + z$
                                x = LEN(path$)
                                m = m + 1
                            ELSE
                                R$ = R$ + MID$(path$, x + 1, i - x)
                                x = i + 1
                            END IF
                    END SELECT
                END IF
            CASE "."
                DO WHILE x < LEN(path$)
                    IF MID$(path$, x + 1, 1) = "." THEN
                        x = x + 1
                        EXIT DO
                    END IF
                    x = x + 1
                LOOP
                R$ = R$ + ch$
            CASE ELSE
                IF LEN(q$) AND q$ <> "." THEN
                    x = x + 1
                END IF
                R$ = R$ + ch$
        END SELECT
    NEXT

    ' trim trailing dots and spaces
    DO
        IF RIGHT$(R$, 1) = "." THEN
            R$ = LEFT$(R$, LEN(R$) - 1)
        ELSE
            IF RIGHT$(R$, 1) = " " THEN
                R$ = LEFT$(R$, LEN(R$) - 1)
            ELSE
                EXIT DO
            END IF
        END IF
    LOOP

    ' return masked filename
    MaskNewName$ = R$
END FUNCTION

REM inputs a unicode filename and matches wildcards returning masked output filename.
FUNCTION MaskNewWideName$ (path$, mask$) ' * . M P 4
    FOR m = 0 TO LEN(mask$) - 1 STEP 2
        ch$ = MID$(mask$, m + 1, 1)
        ch2$ = MID$(mask$, m + 1, 2)
        q$ = MID$(path$, x + 1, 1)
        q2$ = MID$(path$, x + 1, 2)
        z$ = MID$(mask$, m + 3, 1)
        z2$ = MID$(mask$, m + 3, 2)
        SELECT CASE ch$
            CASE "?"
                IF LEN(q$) AND q$ <> "." THEN
                    R$ = R$ + q2$
                    x = x + 2
                END IF
            CASE "*"
                IF m >= LEN(mask$) - 2 THEN ' asterick at eol
                    WHILE x < LEN(path$)
                        R$ = R$ + MID$(path$, x + 1, 1)
                        x = x + 1
                    WEND
                ELSE
                    SELECT CASE z$
                        CASE "."
                            FOR i = LEN(path$) TO 0 STEP -2
                                IF MID$(path$, i + 1, 1) = "." THEN
                                    EXIT FOR
                                END IF
                            NEXT
                            IF i < 0 THEN
                                R$ = R$ + MID$(path$, x + 1) + "." + CHR$(0)
                                i = LEN(path$)
                            ELSE
                                R$ = R$ + MID$(path$, x + 1, i - x + 2)
                            END IF
                            x = i + 2
                            m = m + 2
                        CASE "?"
                            R$ = R$ + MID$(path$, x + 1)
                            m = m + 2
                            x = LEN(path$)
                        CASE ELSE
                            FOR i = LEN(path$) TO 0 STEP -2
                                x$ = MID$(path$, i + 1, 1)
                                IF UCASE$(x$) = UCASE$(z$) THEN
                                    EXIT FOR
                                END IF
                            NEXT
                            IF i < 0 THEN
                                R$ = R$ + MID$(path$, x + 1) + z2$
                                x = LEN(path$)
                                m = m + 2
                            ELSE
                                R$ = R$ + MID$(path$, x + 1, i - x + 1)
                                x = i + 2
                            END IF
                    END SELECT
                END IF
            CASE "."
                DO WHILE x < LEN(path$)
                    IF MID$(path$, x + 1, 1) = "." THEN
                        x = x + 2
                        EXIT DO
                    END IF
                    x = x + 2
                LOOP
                R$ = R$ + ch2$
            CASE ELSE
                IF LEN(q$) AND q$ <> "." THEN
                    x = x + 2
                END IF
                R$ = R$ + ch2$
        END SELECT
    NEXT

    ' trim trailing dots and spaces
    DO
        IF RIGHT$(R$, 1) = "." THEN
            R$ = LEFT$(R$, LEN(R$) - 1)
        ELSE
            IF RIGHT$(R$, 1) = " " THEN
                R$ = LEFT$(R$, LEN(R$) - 1)
            ELSE
                EXIT DO
            END IF
        END IF
    LOOP

    ' return masked filename
    MaskNewWideName$ = R$
END FUNCTION

FUNCTION wzLength~& (ustr$)
    FOR i% = 1 TO LEN(ustr$) STEP 2
        IF MID$(ustr$, i%, 2) = STRING$(2, CHR$(0)) THEN
            wzLength~& = i% - 1
            EXIT FUNCTION
        END IF
    NEXT i%
    wzLength~& = LEN(ustr$) - 1
END FUNCTION

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
    COLOR White, Black
    PRINT Input.String$ + " ";
    Input.Char$ = NUL
    LOCATE , , 1
    DO
        _LIMIT 100
        Input.Char$ = INKEY$
        IF LEN(Input.Char$) THEN
            Input.Char$ = LCASE$(Input.Char$)
            IF INSTR(Input.Mask$, Input.Char$) THEN
                PRINT Input.Char$
                Output.String$ = Input.Char$
                EXIT DO
            END IF
        END IF
    LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
    ' check display errors flag
    IF Display.Errors = False THEN
        ' display error
        COLOR Red, Black
        PRINT Temp$
    END IF
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
    IF Last.Switch = 0 THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    ELSE
        IF Var < Last.Switch THEN
            Last.Switch = Var - 1
            Switch.Exist = -1
        END IF
    END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
    Imbedded = INSTR(Command.Line, LCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        Imbedded = INSTR(Command.Line, UCASE$(X$))
        IF Imbedded THEN
            Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
            Last.Switch = Imbedded - 1
            ParseLine = True
            Switch.Exist = -1
        ELSE
            ParseLine = False
        END IF
    END IF
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
    x$ = ""
    s$ = STR$(s#)
    IF INSTR(s$, "D") THEN ' return string
        FormatString$ = s$
        EXIT FUNCTION
    END IF
    IF LEFT$(s$, 1) = "-" THEN ' store sign
        e$ = "-"
        s$ = MID$(s$, 2)
    END IF
    s$ = LTRIM$(s$) ' format string
    IF INSTR(s$, ".") THEN
        q$ = MID$(s$, INSTR(s$, "."))
        s$ = LEFT$(s$, INSTR(s$, ".") - 1)
    END IF
    FOR l = LEN(s$) TO 3 STEP -3
        x$ = MID$(s$, l - 2, 3) + "," + x$
    NEXT
    IF l > 0 THEN
        x$ = MID$(s$, 1, l) + "," + x$
    END IF
    IF LEN(s$) < 3 THEN
        x$ = s$
    END IF
    IF RIGHT$(x$, 1) = "," THEN
        x$ = LEFT$(x$, LEN(x$) - 1)
    END IF
    x$ = e$ + x$ + q$ ' construct string
    FormatString$ = x$
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
    ' check drive exists.
    IF DRIVEEXISTS(V) THEN
        MEDIAEXISTS = False
        EXIT FUNCTION
    END IF

    ' get drive info.
    VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
    Vname$ = SPACE$(MAX_PATH)
    Fname$ = SPACE$(MAX_PATH)
    R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
    IF R THEN
        MEDIAEXISTS = True
    ELSE
        MEDIAEXISTS = False
    END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
    VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
    VarX = GetDriveType(VarX$)
    DriveType = NUL
    SELECT CASE VarX
        CASE 0
            DriveType = "[UNKNOWN]"
        CASE 1
            DriveType = "[BADROOT]"
        CASE 2
            DriveType = "[REMOVABLE]"
        CASE 3
            DriveType = "[FIXED]"
        CASE 4
            DriveType = "[REMOTE]"
        CASE 5
            DriveType = "[CDROM]"
        CASE 6
            DriveType = "[RAMDISK]"
    END SELECT
    IF VarX > 1 THEN
        DRIVEEXISTS = False
    ELSE
        DRIVEEXISTS = True
    END IF
END FUNCTION

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function

