Rem file: Typey.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DefInt A-Z
Rem $DYNAMIC
_Title "TYPEY"

' define boolean values
Const True = -1
Const False = Not True
Const TrueD = -1#
Const FalseD = Not TrueD
Const NUL = ""

' define color values
Const Black = 0
Const Cyan = 11
Const Green = 10
Const Plain = 7
Const Red = 12
Const White = 15
Const Yellow = 14

' declare filename variables
Dim Shared Drive.Search As String * 1
Dim Shared Current.Directory As String

' declare work variables
Dim Shared Quit.Searching As Integer
Dim Shared Continuous.Display As Integer
Dim Shared Display.Errors As Integer
Dim Shared Prepend.Drive As Integer

' declare search work variables
Dim Shared Search.From.Date As Single, Search.To.Date As Single
Dim Shared Search.From.Time As Single, Search.To.Time As Single
Dim Shared File.Size As Double, Recurse.Directories As Integer
Dim Shared Display.Hidden As Integer, Display.System As Integer
Dim Shared Display.Readonly As Integer, Display.Archive As Integer
Dim Shared Display.Any As Integer, No.Display.Archive As Integer
Dim Shared No.Display.Readonly As Integer, No.Display.System As Integer
Dim Shared No.Display.Hidden As Integer, No.Display.Any As Integer

Dim Shared No.Display.Encrypt As Integer, Display.Encrypt As Integer
Dim Shared No.Display.Compress As Integer, Display.Compress As Integer

' declare count variables
Dim Shared Dirs.Counted As Double
Dim Shared Files.Counted As Double
Dim Shared Bytes.Counted As Double
Dim Shared Lines.Counted As Double
Dim Shared Display.Filenames As Integer

' declare file date\time and filesize work variables
Dim Shared File.Work.Date As Single, File.Work.Time As Single
Dim Shared Search.Size.From As Double, Search.Size.To As Double
Dim Shared Search.File.Size, Creation.Time As Integer
Dim Shared Access.Time As Integer, Modified.Time As Integer

' declare file display variables
Dim Shared Strip.Blanks As Integer, Sort.Column As Integer

' declare command line work variables
Dim Shared Command.Line As String
Dim Shared Command.Work As String
Dim Shared Last.Switch As Integer
Dim Shared Switch.Exist As Integer

' declare library constants.
Const MAX_PATH = 260
Const INVALID_HANDLE_VALUE = -1

' declare library structures.
Type FILETIME
    dwLowDateTime As _Unsigned Long
    dwHighDateTime As _Unsigned Long
End Type

Type SYSTEMTIME
    wYear As Integer
    wMonth As Integer
    wDayOfWeek As Integer
    wDay As Integer
    wHour As Integer
    wMinute As Integer
    wSecond As Integer
    wMilliseconds As Integer
End Type

Type WIN32_FIND_DATAA
    dwFileAttributes As _Unsigned Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As _Unsigned Long
    nFileSizeLow As _Unsigned Long
    dwReserved0 As _Unsigned Long
    dwReserved1 As _Unsigned Long
    cFileName As String * Max_path
    cAlternateFileName As String * 14
End Type

' declare external libraries.
Declare Dynamic Library "kernel32"
    Function FindFirstFileA~%& (ByVal lpFileName~%&, Byval lpFindFileData~%&)
    Function FindNextFileA& (ByVal hFindFile~%&, Byval lpFindFileData~%&)
    Function FindClose& (ByVal hFindFile~%&)
    Function FileTimeToSystemTime& (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
    Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, Byval nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, Byval nFileSystemNameSize&)
    Function SetCurrentDirectoryA% (f$)
    Function RemoveDirectoryA% (F$)
    Function CreateDirectoryA% (F$, X$)
    Function GetLastError& ()
    Function FormatMessageA& (ByVal f As Long, f$, Byval e As Long, Byval d As Long, g$, s As Long, h$)
End Declare

Declare Library
    Function GetFileAttributes& (f$)
    Function SetFileAttributes& (f$, Byval a&)
    Function GetDriveType& (d$)
    Function GetShortPathName& (InP$, OutP$, Byval length&)
    Function GetModuleFileNameA (ByVal Module As Long, FileName As String, Byval nSize As Long)
End Declare

' declare library variables.
Dim Shared SysTime As SYSTEMTIME
Dim Shared DriveType As String
Dim Shared finddatatemp As WIN32_FIND_DATAA

' declare standard error trap
On Error GoTo Error.Routine

' force default path
x$ = _StartDir$
f$ = x$ + Chr$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
If Command$ = "/?" Then
    GoTo Boot.Usage
End If

' get current drive
Current.Drive$ = Left$(_CWD$, 1)
Current.Directory = _CWD$

' store command line
Command.Line = LTrim$(RTrim$(Read.Command$))

' get switches from command line
No.Display.Archive = ParseLine("//A")
No.Display.Hidden = ParseLine("//H")
No.Display.Readonly = ParseLine("//O")
No.Display.System = ParseLine("//S")
No.Display.Any = ParseLine("//X")

Display.Archive = ParseLine("/A")
Display.Hidden = ParseLine("/H")
Display.Readonly = ParseLine("/O")
Display.System = ParseLine("/S")
Display.Any = ParseLine("/X")

No.Display.Compress = ParseLine("//M1")
No.Display.Encrypt = ParseLine("//M2")

Display.Compress = ParseLine("/M1")
Display.Encrypt = ParseLine("/M2")

Continuous.Display = ParseLine("/C")
Prompt.More = ParseLine("/P")
Recurse.Directories = ParseLine("/R")
Display.Errors = ParseLine("/Z")
Strip.Blanks = ParseLine("/I")

' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = InStr(UCase$(Command.Line), "/D")
If Imbedded Then
    Var = LastSwitch(Imbedded)
    D$ = Mid$(Command.Line, Imbedded + 2, 21)
    Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 23)
    If Len(D$) <> 21 Then
        GoTo Boot.Error
    End If
    If Mid$(D$, 11, 1) <> "-" Then
        GoTo Boot.Error
    End If
    S$ = Left$(D$, 10)
    D1! = Int(Val(Mid$(S$, 1, 2)))
    D2! = Int(Val(Mid$(S$, 4, 2)))
    D3! = Int(Val(Mid$(S$, 7, 4)))
    Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    S$ = Right$(D$, 10)
    D1! = Int(Val(Mid$(S$, 1, 2)))
    D2! = Int(Val(Mid$(S$, 4, 2)))
    D3! = Int(Val(Mid$(S$, 7, 4)))
    Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    If Search.From.Date < False Or Search.To.Date < False Then
        GoTo Boot.Error
    End If
End If
Imbedded = InStr(UCase$(Command.Line), "/T")
If Imbedded Then
    Var = LastSwitch(Imbedded)
    T$ = Mid$(Command.Line, Imbedded + 2, 17)
    Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 19)
    If Len(T$) <> 17 Then
        GoTo Boot.Error
    End If
    If Mid$(T$, 9, 1) <> "-" Then
        GoTo Boot.Error
    End If
    S$ = Left$(T$, 8)
    T1! = Int(Val(Mid$(S$, 1, 2)))
    T2! = Int(Val(Mid$(S$, 4, 2)))
    T3! = Int(Val(Mid$(S$, 7, 2)))
    Search.From.Time = T1! * 2048 + T2! * 32 + Int(T3! / 2)
    S$ = Right$(T$, 8)
    T1! = Int(Val(Mid$(S$, 1, 2)))
    T2! = Int(Val(Mid$(S$, 4, 2)))
    T3! = Int(Val(Mid$(S$, 7, 2)))
    Search.To.Time = T1! * 2048 + T2! * 32 + Int(T3! / 2)
    If Search.From.Time < False Or Search.To.Time < False Then
        GoTo Boot.Error
    End If
End If

' get display column
Sort.Column = 1
Imbedded = InStr(UCase$(Command.Line), "/N")
If Imbedded Then
    Var = LastSwitch(Imbedded)
    Imbedded2 = Imbedded + 2
    Do
        Switch$ = Mid$(Command.Line, Imbedded2, 1)
        If Switch$ >= "0" And Switch$ <= "9" Then
            Column$ = Column$ + Switch$
        Else
            Exit Do
        End If
        Imbedded2 = Imbedded2 + 1
    Loop
    If Column$ = NUL Then
        GoTo Boot.Error
    End If
    Sort.Column = Int(Val(Column$))
    If Sort.Column = False Then
        GoTo Boot.Error
    End If
    Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded2)
End If

' recheck command line
If InStr(Command.Line, "/") Then
    GoTo Boot.Error
End If
Command.Line = RTrim$(LTrim$(Command.Line))
If Switch.Exist Then
    If Len(Command.Line) > Last.Switch Then
        GoTo Boot.Error
    End If
End If
If Command.Line = "" Then
    GoTo Boot.Error
End If

' initialize work variables
Lines.Counted = False
More.Display = False
Quit.Searching = False

' remove blanks from command line
Command.Line = RTrim$(Command.Line)
Command.Line = LTrim$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GoSub Header

' filename processing loop
Do
    ' store entire command
    If Left$(Command.Line, 1) = Chr$(34) Then
        Imbedded = InStr(2, Command.Line, Chr$(34))
        If Imbedded Then
            Command.Work = Mid$(Command.Line, 2, Imbedded - 2)
            Command.Line = Mid$(Command.Line, Imbedded + 1)
        Else
            Command.Work = Command.Line
            Command.Line = NUL
        End If
    Else
        Imbedded = InStr(Command.Line, " ")
        If Imbedded Then
            Command.Work = Left$(Command.Line, Imbedded - 1)
            Command.Line = Mid$(Command.Line, Imbedded + 1)
        Else
            Command.Work = Command.Line
            Command.Line = NUL
        End If
    End If
    Command.Line = LTrim$(Command.Line)
    Command.Line = RTrim$(Command.Line)

    ' store current drive
    If Mid$(Command.Work, 2, 1) = ":" Then
        Drive.Search = Left$(Command.Work, 1)
        Command.Work = Mid$(Command.Work, 3)
    Else
        Drive.Search = Current.Drive$
    End If
    Drive.Search = UCase$(Drive.Search)

    ' store current directory
    Directory.Search$ = ""
    Imbedded1 = InStr(Command.Work, "\")
    Imbedded2 = Imbedded1
    While Imbedded1
        Imbedded2 = Imbedded1
        Imbedded1 = InStr(Imbedded1 + 1, Command.Work, "\")
    Wend
    If Imbedded2 Then
        Directory.Search$ = Left$(Command.Work, Imbedded2)
        Command.Work = Mid$(Command.Work, Imbedded2 + 1)
    End If
    If Directory.Search$ = "" Then
        If Left$(Current.Directory, 2) = "\\" Then
            Directory.Search$ = Current.Directory
        Else
            If Drive.Search$ = Current.Drive$ Then
                Directory.Search$ = Mid$(Current.Directory, 3)
            Else
                Directory.Search$ = "\"
            End If
        End If
    End If
    If Right$(Directory.Search$, 1) <> "\" Then
        Directory.Search$ = Directory.Search$ + "\"
    End If
   
    ' get filename spec
    Filename.Search$ = Command.Work
    If Filename.Search$ = NUL Then
        Exit Do
    End If
    Command.Work = NUL

    ' display search filename
    If Continuous.Display = False Then
        Color Yellow, Black
        If Left$(Directory.Search$, 2) = "\\" Then
            Print "Searching: " + Directory.Search$ + Filename.Search$
        Else
            Print "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
        End If
    End If

    ' call routine to search for files
    If Left$(Directory.Search$, 2) = "\\" Then
        Call Directories(Directory.Search$, Filename.Search$)
    Else
        V = Asc(UCase$(Left$(Drive.Search$, 1))) - 64
        If MEDIAEXISTS(V) Then
            Call Directories(Directory.Search$, Filename.Search$)
        End If
    End If

    ' check search filename
    If Command.Line = NUL Then
        Exit Do
    End If

    ' check quit searching
    If Quit.Searching Then
        Exit Do
    End If
Loop

End.Typey:

' display end program
If Continuous.Display = False Then
    Prompt$ = "Press <enter> to exit to DOS:"
    Call MorePrompt(Prompt$, Chr$(13), Outpt$)
End If
Color Plain, Black
End

' display program usage
Boot.Usage:
' make header
Color White, Black
Print "Typey v1.0a: File display utility; "
Color Yellow, Black
Print "Usage:"
Print "   Typey [d:\path\filename.ext][//ahosx][/cdfinprtz][/123]"
Print "Where:"
Print "   /c  continuous display   /i  strip blanks"
Print "   /p  prompt for more      /nxxx  column display"
Print "   /r  recurse directories"
Print "   /z  suppress error messages"
Print "   display ranges: (/1  creation, /2  last access  /3  modify time)"
Print "     /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
Print "     /t  is range of file times in form hh:mm:ss-hh:mm:ss"
Print "     /f  is range of file sizes in form xxx-xxx in kilobytes"
Print "   type files with attributes"
Print "     // prefix to not type files with,"
Print "     / prefix to type files only with,"
Print "       a  archive, h  hidden, o  read-only, s  system, x  none"
Print "       m1  compressed, m2  encrypted"
Color Plain, Black
End

Boot.Error:
Color White, Black
Print "Command line error. Type Typey /? for help."
Color Plain, Black
End

' make header
Header:
If Header.Flag Then
    Return
End If
Header.Flag = True
If Continuous.Display = False Then
    Color White, Black
    Print "Typey v1.0a: File content display utility; "
End If
Return

' critical error trap
Error.Routine:
DataError = Err
If Display.Errors Then
    Error.Level = True
    Resume Next
End If
Color Green, Black
Print "Critical error:"; DataError; " IDE line:"; _ErrorLine
Prompt$ = "Press R to retry, Q to quit, C to continue:"
Call MorePrompt(Prompt$, "rqc", Outpt$)
If BreakIS Then
    Outpt$ = "q"
End If
Select Case Outpt$
    Case "r"
        Resume
    Case "q"
        Error.Level = True
        Resume End.Typey
    Case "c"
        Resume Next
End Select
Color Plain, Black
End 0

' subroutine to access directories
Sub Directories (Directory.Search$, Filename.Search$)
    ' declare subroutine variables
    Dim Attribute As _Unsigned Long
    Dim ASCIIZ As String * 260
    Dim finddata As WIN32_FIND_DATAA
    Dim Wfile.Handle As _Unsigned _Offset

    ' make directory filename
    ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)

    ' start directory search
    Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
    If Wfile.Handle <> INVALID_HANDLE_VALUE Then
        ' search directory names
        Call Filenames(Directory.Search$, Filename.Search$)

        ' check to recurse directories
        If Recurse.Directories Then

            ' recurse directories
            Do
                ' check to quit
                If Quit.Deleting Then
                    Exit Do
                End If

                ' check directory attribute
                Attribute = finddata.dwFileAttributes

                If (Attribute And &H10) = &H10 Then

                    ' store directory name
                    Directory$ = finddata.cFileName
                    Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

                    ' check directory name
                    If Directory$ <> "." And Directory$ <> ".." Then
                        ' check unicode
                        If InStr(Directory$, "?") Then
                            Directory$ = finddata.cAlternateFileName
                            V = InStr(Directory$, Chr$(0))
                            If V Then Directory$ = Left$(Directory$, V - 1)
                        End If

                        ' make next search directory
                        Next.Directory$ = Directory.Search$ + Directory$ + "\"

                        ' recursively search subdirectories
                        Call Directories(Next.Directory$, Filename.Search$)
                    End If
                End If
            Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
        End If
        x = FindClose(Wfile.Handle)
    End If
End Sub

' subroutine to access filenames in directory
Sub Filenames (Directory.Search$, Filename.Search$)
    ' declare subroutine variables
    Dim Attribute As _Unsigned Long
    Dim ASCIIZ As String * 260
    Dim finddata As WIN32_FIND_DATAA
    Dim Wfile.Handle As _Unsigned _Offset

    ' make filename
    ASCIIZ = Directory.Search$ + Filename.Search$ + Chr$(0)

    Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
    If Wfile.Handle <> INVALID_HANDLE_VALUE Then

        ' check directory attribute
        Attribute = finddata.dwFileAttributes

        ' check for directory
        If (Attribute And &H10) = &H10 Then
            ' increment directories actually searched
            Dirs.Counted = Dirs.Counted + 1#
        End If

        ' recurse filename
        Do
            ' store filename
            Filename$ = finddata.cFileName
            Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

            ' check filename
            If Filename$ <> "." And Filename$ <> ".." Then

                ' store file data
                finddatatemp = finddata

                ' store file size
                File.Size = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

                ' check directory attribute
                Attribute = finddata.dwFileAttributes

                ' check for directory
                If (Attribute And &H10) <> &H10 Then
                    Call DisplayFiles(Directory.Search$, Filename$)
                End If
            End If

            ' check to quit
            If Quit.Deleting Then
                Exit Do
            End If
        Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
        x = FindClose(Wfile.Handle)
    End If
End Sub

' subroutine to count and display filenames
Sub DisplayFiles (Directory.Search$, Filename.Search$)
    ' declare subroutine variables
    Dim Attribute As _Unsigned Long

    ' check directory attribute
    Attribute = finddatatemp.dwFileAttributes

    ' check for readonly file
    If (Attribute And &H1) = &H1 Then
        If No.Display.Readonly Then
            Exit Sub
        End If
    Else
        If Display.Readonly Then
            Exit Sub
        End If
    End If

    ' check for hidden file
    If (Attribute And &H2) = &H2 Then
        If No.Display.Hidden Then
            Exit Sub
        End If
    Else
        If Display.Hidden Then
            Exit Sub
        End If
    End If

    ' check for system file
    If (Attribute And &H4) = &H4 Then
        If No.Display.System Then
            Exit Sub
        End If
    Else
        If Display.System Then
            Exit Sub
        End If
    End If

    ' check for archive file
    If (Attribute And &H20) = &H20 Then
        If No.Display.Archive Then
            Exit Sub
        End If
    Else
        If Display.Archive Then
            Exit Sub
        End If
    End If

    ' check for compressed file
    If (Attribute And &H800) = &H800 Then
        If No.Display.Compress Then
            Exit Sub
        End If
    Else
        If Display.Compress Then
            Exit Sub
        End If
    End If

    ' check for encrypted file
    If (Attribute And &H4000) = &H4000 Then
        If No.Display.Encrypt Then
            Exit Sub
        End If
    Else
        If Display.Encrypt Then
            Exit Sub
        End If
    End If

    ' check all attributes
    If Display.Any Then
        If (Attribute And &H1) = &H1 Then
            Exit Sub
        End If
        If (Attribute And &H2) = &H2 Then
            Exit Sub
        End If
        If (Attribute And &H4) = &H4 Then
            Exit Sub
        End If
        If (Attribute And &H20) = &H20 Then
            Exit Sub
        End If
        If (Attribute And &H800) = &H800 Then
            Exit Sub
        End If
        If (Attribute And &H4000) = &H4000 Then
            Exit Sub
        End If
    End If
    If No.Display.Any Then
        If (Attribute And &H1) = False Then
            If (Attribute And &H2) = False Then
                If (Attribute And &H4) = False Then
                    If (Attribute And &H20) = False Then
                        If (Attribute And &H800) = False Then
                            If (Attribute And &H4000) = False Then
                                Exit Sub
                            End If
                        End If
                    End If
                End If
            End If
        End If
    End If

    ' check file size
    If Search.File.Size Then
        If Search.Size.From = FalseD And Search.Size.To = FalseD Then
            If File.Size <> FalseD Then
                Exit Sub
            End If
        Else
            If Search.Size.From > FalseD Or Search.Size.To > FalseD Then
                If Search.Size.From > FalseD Then
                    If Search.Size.To = FalseD Then
                        If File.Size < Search.Size.From Then
                            Exit Sub
                        End If
                    End If
                End If
                If Search.Size.From = FalseD Then
                    If Search.Size.To > FalseD Then
                        If File.Size > Search.Size.To Then
                            Exit Sub
                        End If
                    End If
                End If
                If Search.Size.From <= Search.Size.To Then
                    If File.Size < Search.Size.From Or File.Size > Search.Size.To Then
                        Exit Sub
                    End If
                End If
                If Search.Size.From > Search.Size.To Then
                    If File.Size < Search.Size.From And File.Size > Search.Size.To Then
                        Exit Sub
                    End If
                End If
            End If
        End If
    End If

    ' store file date and time
    If Creation.Time Then
        x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
        GoSub Convert.Date
        GoSub Convert.Time
    Else
        If Access.Time Then
            x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
            GoSub Convert.Date
            GoSub Convert.Time
        Else
            If Modified.Time Then
                x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
                GoSub Convert.Date
                GoSub Convert.Time
            End If
        End If
    End If

    ' check date\time range
    If Search.From.Date Or Search.To.Date Then
        If File.Work.Date < Search.From.Date Then
            Exit Sub
        End If
        If File.Work.Date > Search.To.Date Then
            Exit Sub
        End If
    End If
    If Search.From.Time Or Search.To.Time Then
        If File.Work.Time < Search.From.Time Then
            Exit Sub
        End If
        If File.Work.Time > Search.To.Time Then
            Exit Sub
        End If
    End If

    ' make directory filename
    If Display.Filenames Then
        Filename$ = Directory.Search$ + Filename.Search$
        If Prepend.Drive Then
            If Left$(Filename$, 2) <> "\\" Then
                Filename$ = Drive.Search + ":" + Filename$
            End If
        End If
        Color Yellow, Black
        Print Filename$
    End If

    ' update bytes counted
    Bytes.Counted = Bytes.Counted + File.Size

    ' update files counter
    Files.Counted = Files.Counted + 1#

    ' send contents of file to screen
    Call DisplayFileLines(Directory.Search$, Filename.Search$)
    Exit Sub

    Convert.Date:
    YearTemp! = SysTime.wYear
    MonthTemp! = SysTime.wMonth
    DayTemp! = SysTime.wDay
    File.Date$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
    File.Date$ = File.Date$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
    File.Date$ = File.Date$ + LTrim$(Str$(SysTime.wYear))
    File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
    Return

    Convert.Time:
    HourTemp! = SysTime.wHour
    MinuteTemp! = SysTime.wMinute
    SecondsTemp! = SysTime.wSecond
    File.Time$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
    File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
    File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
    File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
    Return
End Sub

' subroutine to display lines in a filename
Sub DisplayFileLines (Directory.Search$, Filename.Search$)
    ' make filename
    Filename.Count$ = Directory.Search$ + Filename.Search$
    If _FileExists(Filename.Count$) Then
        X = FreeFile
        Open Filename.Count$ For Binary Shared As #X
        Count# = 0#
        If LOF(X) > 0 Then
            Do Until EOF(X)
                Color 7, 0
                Line Input #X, X$
                Count# = Count# + Len(X$) + 2#
                X$ = Mid$(X$, Sort.Column)
                If RTrim$(X$) = "" Then
                    If Strip.Blanks = 0 Then
                        Print X$
                    End If
                Else
                    _ControlChr Off
                    Print X$
                    _ControlChr On
                End If
            Loop
        End If
        If Count# < LOF(X) Then
            If Strip.Blanks = 0 Then
                Print
            End If
        End If
        Close #X
    End If
End Sub

Sub MorePrompt (Input.String$, Input.Mask$, Output.String$)
    Color White, Black
    Print Input.String$ + " ";
    Input.Char$ = NUL
    Locate , , 1
    Do
        _Limit 100
        Input.Char$ = InKey$
        If Len(Input.Char$) Then
            Input.Char$ = LCase$(Input.Char$)
            If InStr(Input.Mask$, Input.Char$) Then
                Print Input.Char$
                Output.String$ = Input.Char$
                Exit Do
            End If
        End If
    Loop
End Sub

' displays carry flag error
Sub DisplayError (Temp$)
    ' check display errors flag
    If Display.Errors = False Then
        ' display error
        Color Red, Black
        Print Temp$
    End If
End Sub

' command line switch position function.
Function LastSwitch (Var)
    LastSwitch = -1
    If Last.Switch = 0 Then
        Last.Switch = Var - 1
        Switch.Exist = -1
    Else
        If Var < Last.Switch Then
            Last.Switch = Var - 1
            Switch.Exist = -1
        End If
    End If
End Function

' command line parser
Function ParseLine (X$)
    Imbedded = InStr(Command.Line, LCase$(X$))
    If Imbedded Then
        Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    Else
        Imbedded = InStr(Command.Line, UCase$(X$))
        If Imbedded Then
            Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
            Last.Switch = Imbedded - 1
            ParseLine = True
            Switch.Exist = -1
        Else
            ParseLine = False
        End If
    End If
End Function

' test volume media inserted.
Function MEDIAEXISTS (V)
    ' check drive exists.
    If DRIVEEXISTS(V) Then
        MEDIAEXISTS = False
        Exit Function
    End If

    ' get drive info.
    VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
    Vname$ = Space$(MAX_PATH)
    Fname$ = Space$(MAX_PATH)
    r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
    If r Then
        MEDIAEXISTS = True
    Else
        MEDIAEXISTS = False
    End If
End Function

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
    VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
    VarX = GetDriveType(VarX$)
    DriveType = NUL
    Select Case VarX
        Case 0
            DriveType = "[UNKNOWN]"
        Case 1
            DriveType = "[BADROOT]"
        Case 2
            DriveType = "[REMOVABLE]"
        Case 3
            DriveType = "[FIXED]"
        Case 4
            DriveType = "[REMOTE]"
        Case 5
            DriveType = "[CDROM]"
        Case 6
            DriveType = "[RAMDISK]"
    End Select
    If VarX > 1 Then
        DRIVEEXISTS = False
    Else
        DRIVEEXISTS = True
    End If
End Function

' formats a double numeric string
Function FormatString$ (s#)
    x$ = ""
    s$ = Str$(s#)
    If InStr(s$, "D") Then ' return string
        FormatString$ = s$
        Exit Function
    End If
    If Left$(s$, 1) = "-" Then ' store sign
        e$ = "-"
        s$ = Mid$(s$, 2)
    End If
    s$ = LTrim$(s$) ' format string
    If InStr(s$, ".") Then
        q$ = Mid$(s$, InStr(s$, "."))
        s$ = Left$(s$, InStr(s$, ".") - 1)
    End If
    For l = Len(s$) To 3 Step -3
        x$ = Mid$(s$, l - 2, 3) + "," + x$
    Next
    If l > 0 Then
        x$ = Mid$(s$, 1, l) + "," + x$
    End If
    If Len(s$) < 3 Then
        x$ = s$
    End If
    If Right$(x$, 1) = "," Then
        x$ = Left$(x$, Len(x$) - 1)
    End If
    x$ = e$ + x$ + q$ ' construct string
    FormatString$ = x$
End Function

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


