REM file: Drives.bas - Public Domain DOS Utility for QB64.
REM Version 1.0a created 06/03/2016

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare work variables
DIM SHARED Default.Drive AS INTEGER, Drives AS INTEGER
DIM SHARED Last.Drive AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Continuous.Display AS INTEGER, Display.Current AS INTEGER
DIM SHARED Skip.Drives AS INTEGER, Display.Colon AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING, Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external kernel libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

' declare external libraries.
DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED finddata AS WIN32_FIND_DATA, hfind AS _UNSIGNED _OFFSET
DIM SHARED SysTime AS SYSTEMTIME, DriveType AS STRING

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
'x = SetCurrentDirectoryA(f$)

' dimension work variables
REDIM Skip.Drives(1 TO 26) AS INTEGER

' get current drive
Default.Drive = ASC(LEFT$(_CWD$, 1)) - 65 ' 0=a, 1=b,..

' get maximum drives
Last.Drive = 26

' get command line
Command.Line = UCASE$(Read.Command$)
Command.Line = Ltrim$(RTRIM$(Command.Line))
Start.Loop:
Last.Switch = 0
Switch.Exist = 0
IF Command.Line = "" THEN
    Display.Header = True
    COLOR White, Black
    PRINT "Drives v1.0a:"
    COLOR Yellow, Black
    LOCATE , , 1
    DO
        LINE INPUT "Switches(?=list): ", Var$
        IF Var$ = "" THEN
            EXIT DO
        END IF
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = UCASE$(Var$)
            EXIT DO
        END IF
    LOOP
END IF
IF Command.Line = "/?" THEN
    COLOR White, Black
    PRINT "Drives v1.0a: Drive letter display utility; "
    GOSUB Boot.Usage
    COLOR Plain, Black
    END
END IF

' check command line switches
Skip.Drives(1) = ParseLine("/A")
Skip.Drives(2) = ParseLine("/B")
Continuous.Display = ParseLine("/C")
Display.Colon = ParseLine("/W")
Display.Current = ParseLine("/X")
Display.Errors = ParseLine("/Z")

' get skip drives list
FOR Var = 3 TO 26
    Skip.Drives(Var) = ParseLine("/1:" + CHR$(Var + 64))
NEXT

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' check command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
IF LEN(Command.Line) THEN
    GOTO Boot.Error
END IF

' make header
IF Continuous.Display = False THEN
    IF Display.Header = False THEN
        COLOR White, Black
        PRINT "Drives v1.0a: Drive letter display utility;"
    END IF
END IF

' display drives
COLOR Yellow, Black
IF Display.Current THEN
    IF Skip.Drives(Default.Drive + 1) = False THEN
        PRINT CHR$(Default.Drive + 65);
        IF Display.Colon = 0 THEN
            PRINT ":"
        ELSE
            PRINT
        END IF
    END IF
ELSE
    FOR Drives = 1 TO Last.Drive
        IF Skip.Drives(Drives) = False THEN
            IF DRIVEEXISTS(Drives) = 0 THEN
                PRINT CHR$(Drives + 64);
                IF Display.Colon = 0 THEN
                    PRINT ":"
                ELSE
                    PRINT
                END IF
            END IF
        END IF
    NEXT
END IF
End.Drives:

' finish header
IF Continuous.Display = False THEN
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            New.Drive = 0
            Volumes.Counted = 0
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Drives [/abcwxz1]"
PRINT "Where:"
PRINT "   /a  ignore drive A:"
PRINT "   /b  ignore drive B:"
PRINT "   /c  continuous display"
PRINT "   /w  don't display colon"
PRINT "   /x  list only current drive"
PRINT "   /z  suppress errors"
PRINT "   /1:d  skip drive d (d is C to Z)"
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Drives /? for help."
COLOR Plain, Black
END

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; STR$(DataError); " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        RESUME End.Drives
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' prompt for keypress in string
SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
DO
    LOCATE , , 1
    DO
        _LIMIT 100
        Input.Char$ = INKEY$
        IF LEN(Input.Char$) THEN
            EXIT DO
        END IF
    LOOP
    Input.Char$ = LCASE$(Input.Char$)
    IF INSTR(Input.Mask$, Input.Char$) THEN
        PRINT Input.Char$
        Output.String$ = Input.Char$
        EXIT DO
    END IF
LOOP
END SUB

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
IF VarX > 1 THEN
    DRIVEEXISTS = 0
ELSE
    DRIVEEXISTS = -1
END IF
END FUNCTION

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


