Rem file: Whereis.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DefInt A-Z
Rem $Dynamic
_Title "WHEREIS"

' define boolean values
Const True = -1
Const TrueD = -1#
Const False = 0
Const FalseD = 0#
Const FalseS = 0!
Const NUL = ""

' define color values
Const Black = 0
Const Cyan = 11
Const Green = 10
Const Magenta = 12
Const Plain = 7
Const Red = 12
Const White = 15
Const Yellow = 14

' define filelist constant
Const RecurseLevel = 8

' declare work variables
Dim Shared Files.Counter As Integer, Quit.Searching As Integer
Dim Shared Continuous.Display As Integer, Double.Line As Integer
Dim Shared Files.Counted As Double, More.Display As Integer
Dim Shared Dirs.Counted As Double, Display.Dirs.Counted As Integer
Dim Shared Dirs.Displayed As Double, Drive.Search As String * 1
Dim Shared Length As Integer, Volumes.Counted As Integer

' declare search work variables
Dim Shared Search.From.Date As Single, Search.To.Date As Single
Dim Shared Search.From.Time As Single, Search.To.Time As Single
Dim Shared File.Size As Double, Recurse.Directories As Integer
Dim Shared Display.Hidden As Integer, Display.System As Integer
Dim Shared Display.Readonly As Integer, Display.Archive As Integer
Dim Shared Display.Attribute As Integer, Display.Errors As Integer
Dim Shared Display.Volume As Integer '  Redirected.Input As Integer
Dim Shared Display.Any As Integer, No.Display.Archive As Integer
Dim Shared No.Display.Readonly As Integer, No.Display.System As Integer
Dim Shared No.Display.Hidden As Integer, No.Display.Any As Integer
Dim Shared No.Display.Directory As Integer, No.Display.Drive As Integer
Dim Shared Display.Compress As Integer, No.Display.Compress As Integer
Dim Shared Display.Encrypt As Integer, No.Display.Encrypt As Integer
Dim Shared Display.Directory As Integer, Short.Display As Integer
Dim Shared Wide.Display As Integer, Wide.List As Integer
Dim Shared Current.Drive As String * 1, Display.Search As Integer
Dim Shared Remove.Slash As Integer, Skip.Current As Integer
Dim Shared First.Directory As Integer, Max.Recurse As Integer
Dim Shared Display.Only.Errors As Integer, Short.Directory As String
Dim Shared Current.Directory As String, Exclude.File As Integer

' declare file date\time and filesize work variables
Dim Shared File.Work.Date As Single, File.Work.Time As Single
Dim Shared Total.Bytes As Double, Parameters(1) As String * 348
Dim Shared Search.Size.From As Double, Search.Size.To As Double
Dim Shared Search.File.Size, Display.Lowercase As Integer
Dim Shared Creation.Time As Integer, Short.Filenames As Integer
Dim Shared Access.Time As Integer, Modified.Time As Integer

' declare nest recursion variables
Dim Shared Nested.Recurse As Integer, Nested.Levels As Integer

' declare command line work variables
Dim Shared Command.Line As String ' Command.Line.Redirect As String
Dim Shared Command.Work As String, Last.Switch As Integer
Dim Shared Switch.Exist As Integer, Debug.Mode As Integer

' declare filelist variables
Dim Shared Enable.Redirect As Integer, Ignore.Prompts As Integer

' declare dos command work variables
Dim Shared DOS.Command As String, Exclude.List As String
Dim Shared Disable.Cmd As Integer

' declare error trap variables
Dim Shared DataError As Integer, Error.Flag As Integer

' dimension arrays
ReDim Parameters(1 To 12) As String * 348

' declare library constants.
Const MAX_PATH = 260
Const INVALID_HANDLE_VALUE = -1

' declare library structures.
Type FILETIME
   dwLowDateTime As _Unsigned Long
   dwHighDateTime As _Unsigned Long
End Type

Type SYSTEMTIME
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Type WIN32_FIND_DATAA
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path
   cAlternateFileName As String * 14
End Type

' declare external libraries.
Declare Dynamic Library "kernel32"
   Function FindFirstFileA~%& (ByVal lpFileName~%&, ByVal lpFindFileData~%&)
   Function FindNextFileA& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindClose& (ByVal hFindFile~%&)
   Function FileTimeToSystemTime& (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
   Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, ByVal nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, ByVal nFileSystemNameSize&)
   Function GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
   Function GetDiskFreeSpaceExA& (filename$, free As _Unsigned _Integer64, total As _Unsigned _Integer64, free2 As _Unsigned _Integer64)
   Function SetCurrentDirectoryA% (f$)
End Declare

Declare Library
   Function GetFileAttributes& (f$)
   Function SetFileAttributes& (f$, ByVal a&)
   Function GetDriveType& (d$)
   Function GetShortPathName& (InP$, OutP$, ByVal length&)
   Function GetModuleFileNameA (ByVal Module As Long, FileName As String, ByVal nSize As Long)
End Declare

Declare Dynamic Library "advapi32"
   Function FileEncryptionStatusA% (f$, f&)
End Declare

' declare library variables.
Dim Shared SysTime As SYSTEMTIME
Dim Shared DriveType As String
Dim Shared finddatatemp As WIN32_FIND_DATAA

' declare standard error trap
On Error GoTo Error.Routine

' force default path
x$ = _StartDir$
f$ = x$ + Chr$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
If Command$ = "/?" Then
   GoSub Boot.Usage
   End
End If

' store command line
Command.Line = LTrim$(RTrim$(Read.Command$))
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' get current drive
Current.Drive = Left$(_CWD$, 1)
Current.Directory = _CWD$
If Right$(Current.Directory, 1) <> "\" Then
   Current.Directory = Current.Directory + "\"
End If

' check command line
If Command.Line = NUL Then
   ' display header
   Color White, Black
   GoSub Header
   Display.Header = True

   ' get command line input
   Print "File spec: ";
   Line Input Command.Line
   Do
      Color White, Black
      Print "Switches(?=list): ";
      Line Input Var$
      If Var$ = "?" Then
         GoSub Boot.Usage
      Else
         Command.Line = Command.Line + Var$
         Exit Do
      End If
   Loop
End If

' store command line
Command.Line = RTrim$(Command.Line)

' get exclude switch
Exclude.List = NUL
Imbedded = InStr(Command.Line, "/(")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   Exclude.List = NUL
   Next.Bracket = InStr(Imbedded + 2, Command.Line, ")")
   If Next.Bracket Then
      Exclude.List = Mid$(Command.Line, Imbedded + 2, Next.Bracket - Imbedded - 2)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Next.Bracket + 1)
   End If
   If Exclude.List = NUL Then
      GoTo Boot.Error
   End If
End If
Command.Line = RTrim$(Command.Line)

' get dos command
DOS.Command = NUL
Imbedded = InStr(Command.Line, "/[")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   DOS.Command = NUL
   Next.Bracket = InStr(Imbedded + 2, Command.Line, "]")
   If Next.Bracket Then
      DOS.Command = Mid$(Command.Line, Imbedded + 2, Next.Bracket - Imbedded - 2)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Next.Bracket + 1)
   End If
   If DOS.Command = NUL Then
      GoTo Boot.Error
   End If
End If
Command.Line = RTrim$(Command.Line)

' edit special DOS command parameters
Imbedded = InStr(DOS.Command, "//1")
While Imbedded
   DOS.Command = Left$(DOS.Command, Imbedded - 1) + ">" + Mid$(DOS.Command, Imbedded + 3)
   Imbedded = InStr(DOS.Command, "//1")
Wend
Imbedded = InStr(DOS.Command, "//2")
While Imbedded
   DOS.Command = Left$(DOS.Command, Imbedded - 1) + "<" + Mid$(DOS.Command, Imbedded + 3)
   Imbedded = InStr(DOS.Command, "//2")
Wend
Imbedded = InStr(DOS.Command, "//3")
While Imbedded
   DOS.Command = Left$(DOS.Command, Imbedded - 1) + "|" + Mid$(DOS.Command, Imbedded + 3)
   Imbedded = InStr(DOS.Command, "//3")
Wend
Imbedded = InStr(DOS.Command, "//4")
While Imbedded
   DOS.Command = Left$(DOS.Command, Imbedded - 1) + "%" + Mid$(DOS.Command, Imbedded + 3)
   Imbedded = InStr(DOS.Command, "//4")
Wend
Imbedded = InStr(DOS.Command, "//5")
While Imbedded
   DOS.Command = Left$(DOS.Command, Imbedded - 1) + "]" + Mid$(DOS.Command, Imbedded + 3)
   Imbedded = InStr(DOS.Command, "//5")
Wend

' check command line switches
Display.Archive = ParseLine("//A")
Display.Hidden = ParseLine("//H")
Display.Directory = ParseLine("//I")
Display.Readonly = ParseLine("//O")
Display.System = ParseLine("//S")
Display.Any = ParseLine("//X")

Display.Compress = ParseLine("//M1")
Display.Encrypt = ParseLine("//M2")

No.Display.Archive = ParseLine("/A")
No.Display.Hidden = ParseLine("/H")
No.Display.Directory = ParseLine("/I")
No.Display.Readonly = ParseLine("/O")
No.Display.System = ParseLine("/S")
No.Display.Any = ParseLine("/X")

No.Display.Compress = ParseLine("/M1")
No.Display.Encrypt = ParseLine("/M2")

No.Display.Drive = ParseLine("/B")
Continuous.Display = ParseLine("/C")
Short.Display = ParseLine("/E")
Display.Search = ParseLine("/G")
Skip.Current = ParseLine("/J")
Short.Filenames = ParseLine("/K")
Double.Line = ParseLine("/L")
Disable.Cmd = ParseLine("/P")
Display.Dirs.Counted = ParseLine("/Q")
Recurse.Directories = ParseLine("/R")
Remove.Slash = ParseLine("/U")
Display.Volume = ParseLine("/V")
Wide.Display = ParseLine("/W")
Display.Lowercase = ParseLine("/Y")
Display.Only.Errors = ParseLine("/Z1")
Display.Errors = ParseLine("/Z")
Enable.Redirect = ParseLine("/@")
Ignore.Prompts = ParseLine("/#")
Debug.Mode = ParseLine("/-=")

' check wide display
If Wide.Display Then
   Double.Line = False
   Short.Display = True
   Short.Filenames = True
End If

' set attribute display variable
Display.Attribute = False
If Display.Archive Or No.Display.Archive Then
   Display.Attribute = True
End If
If Display.Hidden Or No.Display.Hidden Then
   Display.Attribute = True
End If
If Display.Readonly Or No.Display.Readonly Then
   Display.Attribute = True
End If
If Display.System Or No.Display.System Then
   Display.Attribute = True
End If
If Display.Any Or No.Display.Any Then
   Display.Attribute = True
End If
If Display.Directory Or No.Display.Directory Then
   Display.Attribute = True
End If
If Display.Compress Or No.Display.Compress Then
   Display.Attribute = True
End If
If Display.Encrypt Or No.Display.Encrypt Then
   Display.Attribute = True
End If

' reset file counter variable
Dirs.Counted = FalseD
Dirs.Displayed = FalseD
Files.Counted = FalseD
More.Display = False
   
' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = InStr(UCase$(Command.Line), "/D")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   D$ = Mid$(Command.Line, Imbedded + 2, 21)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 23)
   If Len(D$) <> 21 Then
      GoTo Boot.Error
   End If
   If Mid$(D$, 11, 1) <> "-" Then
      GoTo Boot.Error
   End If
   S$ = Left$(D$, 10)
   D1! = Int(Val(Mid$(S$, 1, 2)))
   D2! = Int(Val(Mid$(S$, 4, 2)))
   D3! = Int(Val(Mid$(S$, 7, 4)))
   Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   S$ = Right$(D$, 10)
   D1! = Int(Val(Mid$(S$, 1, 2)))
   D2! = Int(Val(Mid$(S$, 4, 2)))
   D3! = Int(Val(Mid$(S$, 7, 4)))
   Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   If Search.From.Date < False Or Search.To.Date < False Then
      GoTo Boot.Error
   End If
End If
Imbedded = InStr(UCase$(Command.Line), "/T")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   T$ = Mid$(Command.Line, Imbedded + 2, 17)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 19)
   If Len(T$) <> 17 Then
      GoTo Boot.Error
   End If
   If Mid$(T$, 9, 1) <> "-" Then
      GoTo Boot.Error
   End If
   S$ = Left$(T$, 8)
   T1! = Int(Val(Mid$(S$, 1, 2)))
   T2! = Int(Val(Mid$(S$, 4, 2)))
   T3! = Int(Val(Mid$(S$, 7, 2)))
   Search.From.Time = T1! * 2048 + T2! * 32 + T3!
   S$ = Right$(T$, 8)
   T1! = Int(Val(Mid$(S$, 1, 2)))
   T2! = Int(Val(Mid$(S$, 4, 2)))
   T3! = Int(Val(Mid$(S$, 7, 2)))
   Search.To.Time = T1! * 2048 + T2! * 32 + T3!
   If Search.From.Time < False Or Search.To.Time < False Then
      GoTo Boot.Error
   End If
End If

' get file size from command line
Search.File.Size = False
Search.Size.From = FalseD
Search.Size.To = FalseD
Imbedded = InStr(UCase$(Command.Line), "/F")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   Search.File.Size = True
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
   GoSub Get.Numeric
   Search.Size.From = Var#
   If Mid$(Command.Line, Imbedded, 1) <> "-" Then
      GoTo Boot.Error
   End If
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
   GoSub Get.Numeric
   Search.Size.To = Var#
   Search.Size.From = Search.Size.From * 1024#
   Search.Size.To = Search.Size.To * 1024#
End If

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
If Creation.Time = False Then
   If Access.Time = False Then
      If Modified.Time = False Then
         Modified.Time = True
      End If
   End If
End If

' get nested switch from command line
Imbedded = InStr(UCase$(Command.Line), "/N")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
   GoSub Get.Numeric
   Nested.Recurse = CInt(Var#)
End If

' recheck command line
If InStr(Command.Line, "/") Then
   GoTo Boot.Error
End If
Command.Line = RTrim$(Command.Line)
If Switch.Exist Then
   If Len(Command.Line) > Last.Switch Then
      GoTo Boot.Error
   End If
End If

' reset work variables
Files.Counter = False
Nested.Levels = False
Quit.Searching = False
Total.Bytes = False
Files.Counted = False
Dirs.Counted = False
Volumes.Counted = False

' remove blanks from command line
Command.Line = RTrim$(Command.Line)
Command.Line = LTrim$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GoSub Header

' filename processing loop
Do
   ' store entire command
   If Left$(Command.Line, 1) = Chr$(34) Then
      Imbedded = InStr(2, Command.Line, Chr$(34))
      If Imbedded Then
         Command.Work = Mid$(Command.Line, 2, Imbedded - 2)
         Command.Line = Mid$(Command.Line, Imbedded + 1)
      Else
         Command.Work = Command.Line
         Command.Line = NUL
      End If
   Else
      Imbedded = InStr(Command.Line, " ")
      If Imbedded Then
         Command.Work = Left$(Command.Line, Imbedded - 1)
         Command.Line = Mid$(Command.Line, Imbedded + 1)
      Else
         Command.Work = Command.Line
         Command.Line = NUL
      End If
   End If
   Command.Line = LTrim$(Command.Line)
   Command.Line = RTrim$(Command.Line)

   ' locate filelist character
   Flag = False
   Command.Out$ = Command.Work
   Command.Out2$ = NUL
   If Mid$(Command.Out$, 2, 1) = ":" Then
      Command.Out2$ = Left$(Command.Out$, 2)
      Command.Out$ = Mid$(Command.Out$, 3)
   End If
   If Left$(Command.Out$, 1) = "@" Then
      Flag = True
      Command.Out$ = Mid$(Command.Out$, 2)
   Else
      For Var = Len(Command.Out$) To 1 Step -1
         If Mid$(Command.Out$, Var, 1) = "\" Then
            Char$ = Mid$(Command.Out$, Var + 1)
            If Left$(Char$, 1) = "@" Then
               Flag = True
               Command.Out$ = Left$(Command.Out$, Var) + Mid$(Char$, 2)
            End If
            Exit For
         End If
      Next
   End If
   If Len(Command.Out2$) Then
      Command.Out$ = Command.Out2$ + Command.Out$
   End If

   ' process work filename
   If Flag And Enable.Redirect Then

      ' concatenate work filename
      Var$ = Command.Work ' command line filename
      For Var = Len(Var$) To 1 Step -1
         If Mid$(Var$, Var, 1) = "\" Then
            Var$ = Mid$(Var$, Var + 1)
            Exit For
         End If
      Next
      If Mid$(Var$, 2, 1) = ":" Then
         Var$ = Mid$(Var$, 3)
      End If
      Filename2$ = Var$
      Var$ = Mid$(Var$, 2)
      Var2$ = Command.Out$
      For Var = Len(Var2$) To 1 Step -1
         If Mid$(Var2$, Var, 1) = "\" Then
            Var2$ = Left$(Var2$, Var)
            Var$ = Var2$ + Var$
            Exit For
         End If
      Next

      ' check excluded file
      If Len(Exclude.List) Then
         Filename1$ = UCase$(RTrim$(Exclude.List))
         Filename2$ = UCase$(RTrim$(Filename2$))
         Call CheckExcluded(Filename1$, Filename2$)
         If Exclude.File Then
            Max.Recurse = 0
            Call ProcessCommand
            GoTo Next.Filename
         End If
      End If

      ' prompt for filelist
      If Ignore.Prompts = False Then

         ' prompt to use filelist
         Prompt$ = "Use '" + LCase$(Var$) + "' as filelist(y/n/q)?"
         Call MorePrompt(Prompt$, "ynq", Outpt$)
         Select Case Outpt$
            Case "q"
               Quit.Searching = True
               GoTo Next.Filename
            Case "n"
               Max.Recurse = 0
               Call ProcessCommand
               GoTo Next.Filename
         End Select
      End If

      ' open work filename
      DataError = False
      Error.Flag = True
      Close #1
      Open Command.Out$ For Input Shared As #1
      Error.Flag = False

      ' check error flag
      If DataError Then
         Call DisplayError("Error opening filelist.")
      Else
         ' process input filenames
         Max.Recurse = 0
         Do Until EOF(1)
            ' get next filename
            Line Input #1, Command.Work

            ' process search filename
            Command.Work = RTrim$(Command.Work)
            If Len(Command.Work) Then
               Call ProcessCommand
               ' check recurse error
               If Max.Recurse >= RecurseLevel Then
                  Exit Do
               End If
            End If
         Loop
      End If
   Else
      ' process remaining filenames
      Max.Recurse = 0
      Call ProcessCommand
   End If

   ' continue label
   Next.Filename:

   ' check search filename
   If Command.Line = NUL Then
      Exit Do
   End If

   ' check quit searching
   If Quit.Searching Then
      Exit Do
   End If
Loop

End.Whereis:

' display end program
If Continuous.Display = False Then
   If Display.Search = False Then
      If Double.Line = False Then
         If Wide.List Then
            Wide.List = False
            Print
         End If
      End If
   End If
   Color Yellow, Black
   If Display.Volume Then
      Total$ = FormatString$(CDbl(Volumes.Counted))
      Print "Volumes counted: "; Total$
   Else
      If Display.Dirs.Counted = False Then
         Total$ = FormatString$(Dirs.Counted)
         Print "Directories counted: "; Total$
      Else
         Total$ = FormatString$(Dirs.Displayed)
         Print "Directories displayed: "; Total$
      End If
      Total$ = FormatString$(Files.Counted)
      Print "Files counted: "; Total$
      If Double.Line Then
         Total$ = FormatString$(Total.Bytes)
         Print "Bytes counted: "; Total$
      End If
   End If
   Color White, Black
   Prompt$ = "Press (A)gain, (Q)uit:"
   Print Prompt$;
   Do
      _Limit 50
      Locate , , 1
      I$ = InKey$
      If UCase$(I$) = "Q" Then
         Color Plain, Black
         System
      End If
      If UCase$(I$) = "A" Then
         Command.Line = NUL
         Color Plain, Black
         Print
         GoTo Start.Loop
      End If
   Loop
End If

' reset color
Color Plain, Black
End

' process command work
' make header
Header:
If Header.Flag Then
   Return
End If
Header.Flag = True
If Continuous.Display = False Then
   Color White, Black
   Print "Whereis v1.0a: File search utility;"
End If
Return

' display program usage
Boot.Usage:
Display.Page = 1
Do
   Select Case Display.Page
      Case 1
         GoSub Display.Page.One
      Case 2
         GoSub Display.Page.Two
   End Select
   Prompt$ = "Press 1, 2, or q to quit:"
   Call MorePrompt(Prompt$, "12q", Outpt$)
   Select Case Outpt$
      Case "1"
         Display.Page = 1
      Case "2"
         Display.Page = 2
      Case "q"
         Color Plain, Black
         Return
   End Select
Loop
Color Plain, Black
Print "Exiting to DOS:"
End

Display.Page.One:
GoSub Display.Header
Print "  /b  suppress drive letter      /c  continuous display"
Print "  /e  short filename display     /g  display search directories"
Print "  /j  skip current directory     /k  use 8.3 short filenames"
Print "  /l  double line display        /nxxx  nested directories"
Print "  /q  directory count override   /r  recurse directories"
Print "  /u  remove trailing slash      /v  display volume label"
Print "  /w  wide file list             /y  display lowercase"
Print "  /z  no error messages          /z1 display only errors"
Print "display ranges:"
Print "  /1  creation, /2  last access, /3  modify time"
Print "  /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
Print "  /t  is range of file times in form hh:mm:ss-hh:mm:ss"
Print "  /f  is range of file sizes in form xxx-xxx in kilobytes"
Return

Display.Page.Two:
GoSub Display.Header
Print "  filelist switches:"
Print "    /@  enable filelists   /#  ignore filelist prompts"
Print "  exclude file list switch:"
Print "    /(<filename.ext>)"
Print "      excludes files containing ? and * characters."
Print "  display file attributes: // prefix for files with, / prefix for files without"
Print "    a  archive, h  hidden, i  directory, o  read-only, s  system"
Print "    m1  compressed,  m2  encrypted, x  none"
Print "  DOS command: /[<command>]"
Print "    with command replacement parameters: (use /p for /c override);"
Print "      %1 = d:, %2 = d:\, %3 = d:\pathname, %4 = d:\pathname\"
Print "      %5 = d:\pathname\filename.ext, %6 = \pathname, %7 = \pathname\"
Print "      %8 = \pathname\filename.ext, %9 = filename.ext, %a = filename"
Print "      %b = .ext, %c = ext, //1 = >, //2 = <, //3 = |, //4 = %, //5 = ]"
Return

Display.Header:
Cls
Color White, Black
Print "Whereis v1.0a: File search utility;"
Color Yellow, Black
Print "Usage:"
Print "  Whereis [@][d:\path\filename.ext][//ahiosx][/bcdefgjklnpqrtuvwyz@#][/123]"
Print "Where:"
Return

Get.Numeric:
Var# = False
Do
   Temp$ = Mid$(Command.Line, Imbedded, 1)
   If Temp$ >= "0" And Temp$ <= "9" Then
      Var# = Var# * 10 + Val(Temp$)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
   Else
      Exit Do
   End If
Loop
Return

Boot.Error:
Color White, Black
Print "Command line error. Type Whereis /? for help."
Color Plain, Black
End

' critical error trap
Error.Routine:
DataError = Err
If Error.Flag Then
   Resume Next
End If
If Display.Errors Then
   Error.Level = True
   Resume Next
End If
If Wide.List Then
   Wide.List = False
   Print
End If
Color Green, Black
Print "Critical error:"; DataError; " IDE line:"; _ErrorLine
Prompt$ = "Press R to retry, Q to quit, C to continue:"
Call MorePrompt(Prompt$, "rqc", Outpt$)
Select Case Outpt$
   Case "r"
      Resume
   Case "q"
      Error.Level = True
      Resume End.Whereis
   Case "c"
      Resume Next
End Select
End 0

Rem constructs and checks filelist filename exists.
Rem   returns ambiguated filename.
Function FILELISTEXISTS$ (Var$)
   ' construct filelist filename.
   VarX$ = Var$
   V = InStr(VarX$, "@")
   If V = 0 Then
      FILELISTEXISTS$ = NUL
      Exit Function
   End If
   For V = Len(VarX$) To 1 Step -1
      If Mid$(VarX$, V, 1) = "@" Then
         Exit For
      End If
   Next
   If V = 1 Then ' @filelist.txt
      VarX$ = Mid$(VarX$, V + 1)
   Else
      If V > 1 Then
         If Mid$(VarX$, V - 1, 1) = "\" Then ' \dos\@filelist.txt
            VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 1)
         Else
            If Mid$(VarX$, V - 1, 1) = ":" Then ' c:@filelist.txt
               VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 1)
            End If
         End If
      End If
   End If
   ' check filelist filename exists.
   If InStr(V, VarX$, "\") Then ' c:\@path\filename.ext
      FILELISTEXISTS$ = NUL
   Else
      If _FileExists(VarX$) = 0 Then
         FILELISTEXISTS$ = NUL
      Else
         FILELISTEXISTS$ = VarX$
      End If
   End If
End Function

Sub ProcessCommand
   ' check recurse error
   If Max.Recurse >= RecurseLevel Then
      Exit Sub
   End If

   ' store current drive
   If Mid$(Command.Work, 2, 1) = ":" Then
      Drive.Search = Left$(Command.Work, 1)
      Command.Work = Mid$(Command.Work, 3)
   Else
      Drive.Search = Current.Drive
   End If
   Drive.Search = UCase$(Drive.Search)

   ' store current directory
   Directory.Search$ = ""
   Imbedded1 = InStr(Command.Work, "\")
   Imbedded2 = Imbedded1
   While Imbedded1
      Imbedded2 = Imbedded1
      Imbedded1 = InStr(Imbedded1 + 1, Command.Work, "\")
   Wend
   If Imbedded2 Then
      Directory.Search$ = Left$(Command.Work, Imbedded2)
      Command.Work = Mid$(Command.Work, Imbedded2 + 1)
   End If
   If Directory.Search$ = "" Then
      If Left$(Current.Directory, 2) = "\\" Then
         Directory.Search$ = Current.Directory
      Else
         If Drive.Search = Current.Drive Then
            Directory.Search$ = Mid$(Current.Directory, 3)
         Else
            Directory.Search$ = "\"
         End If
      End If
   End If
   If Right$(Directory.Search$, 1) <> "\" Then
      Directory.Search$ = Directory.Search$ + "\"
   End If
   
   ' get filename spec
   Filename.Search$ = Command.Work
   If Filename.Search$ = NUL Then
      Filename.Search$ = "*.*"
   End If
   Command.Work = NUL
   
   ' display search filename
   If Continuous.Display = False Then
      Color Yellow, Black
      If Left$(Directory.Search$, 2) = "\\" Then
         Print "Searching: " + Directory.Search$ + Filename.Search$
      Else
         If Display.Volume Then
            Print "Searching: " + Drive.Search + ":"
         Else
            If Left$(Directory.Search$, 1) = "@" Then
               Print "Searching: " + Directory.Search$ + Filename.Search$
            Else
               Print "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
            End If
         End If
      End If
      Files.Counter = Files.Counter + 1
   End If

   ' call routine to search for files
   If Display.Volume Then
      Call DisplayVolume(Drive.Search)
   Else
      If Left$(Directory.Search$, 2) = "\\" Then
         Call Directories(Directory.Search$, Filename.Search$)
      Else
         V = Asc(UCase$(Left$(Drive.Search$, 1))) - 64
         If MEDIAEXISTS(V) Then
            Call Directories(Directory.Search$, Filename.Search$)
         End If
      End If
   End If
End Sub

' subroutine to access directories
Sub Directories (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' check to quit
   If Quit.Searching Then
      Exit Sub
   End If

   ' check recurse error
   If Max.Recurse >= RecurseLevel Then
      Exit Sub
   End If

   ' display directories searched
   If Display.Search Then
      ' check skip directory
      Flag = True
      If Skip.Current Then
         If First.Directory = False Then
            First.Directory = True
            Flag = False
         End If
      End If
      If Flag Then
         ' count only directories displayed
         Dirs.Displayed = Dirs.Displayed + 1#
         ' store directory
         Filename$ = Directory.Search$
         If Filename$ <> "" Then
            If Remove.Slash Then
               Filename$ = Left$(Filename$, Len(Filename$) - 1)
            End If
         End If
         ' store drive letter
         If No.Display.Drive = False Then
            If Left$(Filename$, 2) <> "\\" Then
               Filename$ = Drive.Search + ":" + Filename$
            End If
         End If
         ' store directory
         Outpt$ = Filename$
         Length = Len(Outpt$)
         ' calculate display lines
         Call PageCount
         ' check overflow past line 22
         If Files.Counter > 22 Then
            Call PagePrompt
            If Quit.Searching Then
               Exit Sub
            End If
            ' reset display lines
            Call PageCount
         End If
         ' display directory
         Color Yellow, Black
         Print Outpt$
         ' check paginate
         Call PagePrompt
         If Quit.Searching Then
            Exit Sub
         End If
      End If
   End If

   ' store directory asciiz
   If Left$(Directory.Search$, 2) <> "\\" Then
      If Left$(Directory.Search$, 1) = "@" Then
         ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)
      Else
         ASCIIZ = Drive.Search + ":" + Directory.Search$ + "*.*" + Chr$(0)
      End If
   Else
      ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)
   End If

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search directory names
      Call Filenames(Directory.Search$, Filename.Search$)

      ' check to recurse directories
      If Recurse.Directories Then

         ' recurse directories
         Do
            ' check to quit
            If Quit.Searching Then
               Exit Do
            End If

            ' check max recurse levevl
            If Max.Recurse >= RecurseLevel Then
               Exit Do
            End If

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            If (Attribute And &H10) = &H10 Then

               ' store directory name
               Directory$ = finddata.cFileName
               Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

               ' check directory name
               If Directory$ <> "." And Directory$ <> ".." Then

                  ' check unicode
                  If InStr(Directory$, "?") Then
                     Directory$ = finddata.cAlternateFileName
                     V = InStr(Directory$, Chr$(0))
                     If V Then Directory$ = Left$(Directory$, V - 1)
                  End If

                  ' make next search directory
                  Next.Directory$ = Directory.Search$ + Directory$ + "\"

                  ' check recursion levels
                  Recursion% = True
                  If Nested.Recurse > False Then
                     Nested.Levels = Nested.Levels + 1
                     If Nested.Levels >= Nested.Recurse Then
                        Recursion% = False
                     End If
                  End If

                  ' recursively search subdirectories
                  If Recursion% Then
                     Call Directories(Next.Directory$, Filename.Search$)
                  End If
                  If Nested.Recurse > False Then
                     Nested.Levels = Nested.Levels - 1
                  End If
               End If
            End If
         Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      End If
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to access filenames in directory
Sub Filenames (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' check to quit
   If Quit.Searching Then
      Exit Sub
   End If

   ' check recurse error
   If Max.Recurse >= RecurseLevel Then
      Exit Sub
   End If

   ' make filename
   Var1$ = Directory.Search$
   If Left$(Var1$, 2) <> "\\" Then
      If Left$(Var1$, 1) = "\" Then
         Var1$ = Drive.Search + ":" + Var1$
      End If
   End If
   Var2$ = Filename.Search$
   If Left$(Var2$, 1) = "@" And Enable.Redirect Then
      Var2$ = Mid$(Var2$, 2)
   End If

   Var1$ = RTrim$(Var1$)
   Var2$ = RTrim$(Var2$)

   ASCIIZ = Var1$ + Var2$ + Chr$(0)
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search filenames
      Do
         ' check to quit
         If Quit.Searching Then
            Exit Do
         End If

         ' store file data
         finddatatemp = finddata

         ' check directory attribute
         Attribute = finddata.dwFileAttributes

         ' check for directory
         If (Attribute And &H10) = &H10 Then
            ' increment directories actually searched
            Dirs.Counted = Dirs.Counted + 1#
         End If

         ' store filename
         Filename$ = finddata.cFileName
         Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

         ' store short filename
         Short.Directory$ = finddata.cAlternateFileName
         V = InStr(Short.Directory$, Chr$(0))
         If V Then Short.Directory$ = Left$(Short.Directory$, V - 1)
         If Short.Directory$ = NUL Then
            Short.Directory$ = finddata.cFileName
            V = InStr(Short.Directory$, Chr$(0))
            If V Then Short.Directory$ = Left$(Short.Directory$, V - 1)
         End If

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then
            ' store file size
            File.Size = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

            ' recursively call filelists
            If Left$(Filename.Search$, 1) = "@" And Enable.Redirect Then
               Filelist.Filename$ = Directory.Search$ + Filename$

               ' check recursion level
               Max.Recurse = Max.Recurse + 1
               If Max.Recurse >= RecurseLevel Then
                  Call DisplayError("Recursive filelist error.")
                  Flag = False
                  Exit Do
               End If

               ' reset prompt flag
               Flag = True

               ' concatenate work filename
               Var$ = Filename$ ' command line filename
               For Var = Len(Var$) To 1 Step -1
                  If Mid$(Var$, Var, 1) = "\" Then
                     Var$ = Mid$(Var$, Var + 1)
                     Exit For
                  End If
               Next
               If Mid$(Var$, 2, 1) = ":" Then
                  Var$ = Mid$(Var$, 3)
               End If
               Filename2$ = Var$
               Var2$ = Filelist.Filename$
               For Var = Len(Var2$) To 1 Step -1
                  If Mid$(Var2$, Var, 1) = "\" Then
                     Var2$ = Left$(Var2$, Var)
                     Var$ = Var2$ + Var$
                     Exit For
                  End If
               Next

               ' check excluded file
               If Len(Exclude.List) Then
                  Filename1$ = UCase$(RTrim$(Exclude.List))
                  Filename2$ = UCase$(RTrim$(Filename2$))
                  Call CheckExcluded(Filename1$, Filename2$)
                  If Exclude.File Then
                     Flag = False
                  End If
               End If

               ' prompt for filelist
               If Ignore.Prompts = False Then

                  ' prompt to use filelist
                  If Flag Then
                     Prompt$ = "Use '" + LCase$(Var$) + "' as filelist(y/n/q)?"
                     Call MorePrompt(Prompt$, "ynq", Outpt$)
                     Select Case Outpt$
                        Case "q"
                           Quit.Searching = True
                           Flag = False
                        Case "n"
                           Flag = False
                     End Select
                  End If
               End If

               ' open work filename
               If Flag Then
                  V = FreeFile
                  DataError = False
                  Error.Flag = True
                  Open Filelist.Filename$ For Input Shared As #V
                  Error.Flag = False

                  ' check error flag
                  If DataError Then
                     Call DisplayError("Error opening filelist.")
                  Else
                     ' process input filenames
                     Do Until EOF(V)
                        Line Input #V, Next.Filename$
                        Next.Filename$ = RTrim$(Next.Filename$)
                        If Len(Next.Filename$) Then
                           ' process search filename
                           Command.Work = Next.Filename$
                           Call ProcessCommand
                           ' check recurse error
                           If Max.Recurse >= RecurseLevel Then
                              Exit Do
                           End If
                        End If
                     Loop
                     Close #V
                  End If
               End If
            Else
               ' display filename info
               Call DisplayFiles(Directory.Search$, Filename$)
            End If
         End If

         ' check to quit
         If Quit.Searching Then
            Exit Do
         End If

         ' check max recurse levevl
         If Max.Recurse >= RecurseLevel Then
            Exit Do
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to display volume information
Sub DisplayVolume (Var$)
   ' check drive exists
   D = Asc(Var$) - 64
   If DRIVEEXISTS(D) Then
      Exit Sub
   End If

   ' increment volume counter
   Volumes.Counted = Volumes.Counted + 1

   ' get drive info.
   VarX$ = Var$ + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)

   ' display volume information
   Color Yellow, Black
   Print Var$; ":";
   If R = 0 Then
      Print DriveType;
      If Double.Line Then
         Color Red, Black
         Print " (????-????)";
         Color White, Black
         Print " [????]";
      End If
      Print
      Exit Sub
   End If

   ' volume label
   Outpt$ = RTrim$(Vname$)
   v = InStr(Outpt$, Chr$(0))
   If v Then Outpt$ = Left$(Outpt$, v - 1)
   If Outpt$ = "" Then Outpt$ = "<none>"
   Print Outpt$;
   If Double.Line = False Then
      Print
      Exit Sub
   End If

   ' display volume serial number
   Color Red, Black
   Outpt$ = Left$(Hex$(serial~&), 4) + "-" + Right$(Hex$(serial~&), 4)
   Print " ("; Outpt$; ")";

   ' display volume system type.
   Color White, Black
   Outpt$ = RTrim$(Fname$)
   v = InStr(Outpt$, Chr$(0))
   If v Then Outpt$ = Left$(Outpt$, v - 1)
   Print " ["; Outpt$; "]"
End Sub

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = ""
   Select Case VarX
      Case 0
         DriveType = "[UNKNOWN]"
      Case 1
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      DRIVEEXISTS = 0
   Else
      DRIVEEXISTS = -1
   End If
End Function

' test volume media inserted.
Function MEDIAEXISTS (V)
   ' check drive exists.
   If DRIVEEXISTS(V) Then
      MEDIAEXISTS = False
      Exit Function
   End If

   ' get drive info.
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      MEDIAEXISTS = True
   Else
      MEDIAEXISTS = False
   End If
End Function

' subroutine to display a filename
Sub DisplayFiles (Search.Directory$, Search.Filename$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260

   ' get file attributes
   Attribute = finddatatemp.dwFileAttributes

   ' make filename
   File.List$ = Search.Directory$ + Search.Filename$
   If Left$(File.List$, 2) <> "\\" Then
      File.List$ = Drive.Search$ + ":" + File.List$
   End If
   ASCIIZ = File.List$ + Chr$(0)

   ' check file attribute
   If Display.Attribute Then

      ' check for readonly file
      If Display.Readonly Then
         If (Attribute And 1) <> 1 Then
            Exit Sub
         End If
      End If
      If No.Display.Readonly Then
         If (Attribute And 1) = 1 Then
            Exit Sub
         End If
      End If

      ' check for hidden file
      If Display.Hidden Then
         If (Attribute And 2) <> 2 Then
            Exit Sub
         End If
      End If
      If No.Display.Hidden Then
         If (Attribute And 2) = 2 Then
            Exit Sub
         End If
      End If

      ' check for system file
      If Display.System Then
         If (Attribute And 4) <> 4 Then
            Exit Sub
         End If
      End If
      If No.Display.System Then
         If (Attribute And 4) = 4 Then
            Exit Sub
         End If
      End If

      ' check for directory file
      If Display.Directory Then
         If (Attribute And &H10) <> &H10 Then
            Exit Sub
         End If
      End If
      If No.Display.Directory Then
         If (Attribute And &H10) = &H10 Then
            Exit Sub
         End If
      End If

      ' check for archive file
      If Display.Archive Then
         If (Attribute And &H20) <> &H20 Then
            Exit Sub
         End If
      End If
      If No.Display.Archive Then
         If (Attribute And &H20) = &H20 Then
            Exit Sub
         End If
      End If

      ' check for compressed file
      If Display.Compress Then
         If (Attribute And &H800) <> &H800 Then
            Exit Sub
         End If
      End If
      If No.Display.Compress Then
         If (Attribute And &H800) = &H800 Then
            Exit Sub
         End If
      End If

      ' check for encrypted file
      If Display.Encrypt Then
         If (Attribute And &H4000) <> &H4000 Then
            Exit Sub
         End If
      End If
      If No.Display.Encrypt Then
         If (Attribute And &H4000) = &H4000 Then
            Exit Sub
         End If
      End If

      ' check for no attributes
      If Display.Any Then
         If (Attribute And 1) = 1 Then
            Exit Sub
         End If
         If (Attribute And 2) = 2 Then
            Exit Sub
         End If
         If (Attribute And 4) = 4 Then
            Exit Sub
         End If
         If (Attribute And &H10) = &H10 Then
            Exit Sub
         End If
         If (Attribute And &H20) = &H20 Then
            Exit Sub
         End If
         If (Attribute And &H800) = &H800 Then
            Exit Sub
         End If
         If (Attribute And &H4000) = &H4000 Then
            Exit Sub
         End If
      End If
      If No.Display.Any Then
         If (Attribute And 1) = False Then
            If (Attribute And 2) = False Then
               If (Attribute And 4) = False Then
                  If (Attribute And &H10) = False Then
                     If (Attribute And &H20) = False Then
                        If (Attribute And &H800) = &H0 Then
                           If (Attribute And &H4000) = &H0 Then
                              Exit Sub
                           End If
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If

   ' check file size
   If Search.File.Size Then
      If Search.Size.From = FalseD And Search.Size.To = FalseD Then
         If File.Size <> FalseD Then
            Exit Sub
         End If
      Else
         If Search.Size.From > FalseD Or Search.Size.To > FalseD Then
            If Search.Size.From > FalseD Then
               If Search.Size.To = FalseD Then
                  If File.Size < Search.Size.From Then
                     Exit Sub
                  End If
               End If
            End If
            If Search.Size.From = FalseD Then
               If Search.Size.To > FalseD Then
                  If File.Size > Search.Size.To Then
                     Exit Sub
                  End If
               End If
            End If
            If Search.Size.From <= Search.Size.To Then
               If File.Size < Search.Size.From Or File.Size > Search.Size.To Then
                  Exit Sub
               End If
            End If
            If Search.Size.From > Search.Size.To Then
               If File.Size < Search.Size.From And File.Size > Search.Size.To Then
                  Exit Sub
               End If
            End If
         End If
      End If
   End If

   ' store file date and time
   If Creation.Time Then
      x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
      GoSub Convert.Date
      GoSub Convert.Time
   Else
      If Access.Time Then
         x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
         GoSub Convert.Date
         GoSub Convert.Time
      Else
         If Modified.Time Then
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
            GoSub Convert.Date
            GoSub Convert.Time
         End If
      End If
   End If

   ' check date\time range
   If Search.From.Date Or Search.To.Date Then
      If Debug.Mode Then
         Print "Searchdate:"; Search.From.Date; "-"; Search.To.Date
         Print "Fileworkdate:"; File.Work.Date
      End If
      If File.Work.Date < Search.From.Date Then
         Exit Sub
      End If
      If File.Work.Date > Search.To.Date Then
         Exit Sub
      End If
   End If
   If Search.From.Time Or Search.To.Time Then
      If Debug.Mode Then
         Print "Searchtime:"; Search.From.Time; "-"; Search.To.Time
         Print "Fileworktime:"; File.Work.Time
      End If
      If File.Work.Time < Search.From.Time Then
         Exit Sub
      End If
      If File.Work.Time > Search.To.Time Then
         Exit Sub
      End If
   End If

   ' make filename
   File.List$ = Search.Filename$
   Display.Filename$ = Search.Filename$
   If Short.Filenames Then
      Display.Filename$ = Short.Directory$
   End If
   If Short.Display Then
      File.List$ = Display.Filename$
   Else
      File.List$ = Search.Directory$ + Display.Filename$
   End If
   If No.Display.Drive = False Then
      If Left$(File.List$, 2) <> "\\" Then
         File.List$ = Drive.Search + ":" + File.List$
      End If
   End If
   If Left$(Search.Directory$, 2) = "\\" Then
      If Mid$(File.List$, 2, 1) = ":" Then
         File.List$ = Mid$(File.List$, 3)
      End If
   End If
   If (Attribute And &H10) = &H10 Then
      If Display.Only.Errors = False Then
         If Remove.Slash = False Then
            File.List$ = File.List$ + "\"
         End If
      End If
   End If

   ' check excluded file
   If Len(Exclude.List) Then
      Filename1$ = UCase$(RTrim$(Exclude.List))
      Filename2$ = UCase$(RTrim$(Search.Filename$))
      Call CheckExcluded(Filename1$, Filename2$)
      If Exclude.File Then
         Exit Sub
      End If
   End If

   ' check for directory bit
   If (Attribute And &H10) <> &H10 Then
      ' increment files counted
      Files.Counted = Files.Counted + 1#
      Total.Bytes = Total.Bytes + File.Size
   End If

   ' display directory/filename
   If Display.Search = False Then
      ' check for directory bit
      If (Attribute And &H10) = &H10 Then
         Dirs.Displayed = Dirs.Displayed + 1#
      End If

      ' format filename
      If Display.Lowercase Then
         Outpt$ = LCase$(File.List$)
      Else
         If Short.Filenames Then
            Outpt$ = UCase$(File.List$)
         Else
            Outpt$ = RTrim$(File.List$)
         End If
      End If

      ' reset line length
      Length = Len(Outpt$)

      ' display wide format
      If Wide.Display Then
         Color Yellow, Black
         If Len(Outpt$) > 15 Then
            Outpt$ = Left$(Outpt$, 14) + "~"
         End If
         Outpt$ = Left$(Outpt$, 15)
         Outpt$ = Outpt$ + Space$(16 - Len(Outpt$))
         Print Outpt$;
         Wide.List = Wide.List + 1
         If Wide.List = 5 Then
            Wide.List = False
            Print
            Files.Counter = Files.Counter + 1
         End If
      Else
         ' check past line 22
         Call PageCount
         If Files.Counter > 22 Then
            Call PagePrompt
            If Quit.Searching Then
               Exit Sub
            End If
            ' reset display lines
            Call PageCount
         End If

         ' display filename
         Color Yellow, Black
         Print Outpt$
      End If

      ' reset paginate
      Call PagePrompt
      If Quit.Searching Then
         Exit Sub
      End If

      ' check max recurse levevl
      If Max.Recurse >= RecurseLevel Then
         Exit Sub
      End If

      ' reset line length
      Length = False

      ' check extended display info
      If Double.Line Then
         ' increment counter for extra line
         Files.Counter = Files.Counter + 1

         ' reset display flag
         Var = False

         ' display file date\time
         Color Green, Black
         If Creation.Time Then
            GoSub Make.Date1
            GoSub Convert.Date
            GoSub Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
            Var = True
         End If
         If Access.Time Then
            If Creation.Time Then
               Outpt$ = "\"
               Length = Length + Len(Outpt$)
               Color White, Black
               Print Outpt$;
               Color Green, Black
               GoSub LengthCount
            End If
            GoSub Make.Date2
            GoSub Convert.Date
            GoSub Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
            Var = True
         End If
         If Modified.Time Then
            If Creation.Time Or Access.Time Then
               Outpt$ = "\"
               Length = Length + Len(Outpt$)
               Color White, Black
               Print Outpt$;
               Color Green, Black
               GoSub LengthCount
            End If
            GoSub Make.Date3
            GoSub Convert.Date
            GoSub Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
            Var = True
         End If
         If Var Then ' check flag
            Outpt$ = " "
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
         End If

         ' check for directory bit
         If (Attribute And &H10) = &H10 Then
            Size$ = "<dir>"
         Else
            Size$ = FormatString$(File.Size)
         End If

         ' display file size
         Color Red, Black
         Outpt$ = Size$
         Length = Length + Len(Outpt$)
         Print Outpt$;
         GoSub LengthCount
         Color White, Black

         ' check for directory file
         If (Attribute And &H10) = &H10 Then
            Outpt$ = " Directory"
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
         End If

         ' check for archive file
         If (Attribute And &H20) = &H20 Then
            Outpt$ = " Archive"
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
         End If

         ' check for read-only file
         If (Attribute And 1) = 1 Then
            Outpt$ = " Read-only"
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
         End If

         ' check for hidden file
         If (Attribute And 2) = 2 Then
            Outpt$ = " Hidden"
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
         End If

         ' check for system file
         If (Attribute And 4) = 4 Then
            Outpt$ = " System"
            Length = Length + Len(Outpt$)
            Print Outpt$;
            GoSub LengthCount
         End If

         ' check for compressed
         If (Attribute And &H800) = &H800 Then
            Outpt$ = " Compressed"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         ' check for encryption
         If (Attribute And &H4000) = &H4000 Then
            Outpt$ = " Encrypted"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If
         Print
      End If

      ' check paginate
      Call PagePrompt
      If Quit.Searching Then
         Exit Sub
      End If

      ' check max recurse levevl
      If Max.Recurse >= RecurseLevel Then
         Exit Sub
      End If
   End If

   End.Display:

   ' check to run DOS command
   If Len(DOS.Command) Then
      Call ExecuteCommand(Search.Directory$ + Display.Filename$)
   End If
   Exit Sub

   ' calculate line length
   LengthCount:
   ' check line length
   If Length > 80 Then
      Files.Counter = Files.Counter + 1
      Length = False
   End If
   ' check past line 22
   If Files.Counter > 22 Then
      Call PagePrompt
      Length = False
   End If
   Return

   Make.Date1:
   x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
   Return

   Make.Date2:
   x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
   Return

   Make.Date3:
   x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
   Return

   Convert.Date:
   YearTemp! = SysTime.wYear
   MonthTemp! = SysTime.wMonth
   DayTemp! = SysTime.wDay
   File.Date$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
   File.Date$ = File.Date$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
   File.Date$ = File.Date$ + LTrim$(Str$(SysTime.wYear))
   File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
   Return

   Convert.Time:
   HourTemp! = SysTime.wHour
   MinuteTemp! = SysTime.wMinute
   SecondsTemp! = SysTime.wSecond
   File.Time$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
   File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
   Return
End Sub

' counts display lines
Sub PageCount
   If Length > 240 Then
      Files.Counter = Files.Counter + 4
   Else
      If Length > 160 Then
         Files.Counter = Files.Counter + 3
      Else
         If Length > 80 Then
            Files.Counter = Files.Counter + 2
         Else
            Files.Counter = Files.Counter + 1
         End If
      End If
   End If
End Sub

' check to paginate
Sub PagePrompt
   If Files.Counter >= 22 Then
      Files.Counter = False
      If Continuous.Display = False Then
         If More.Display = False Then
            Prompt$ = "More(y/n/c)?"
            Call MorePrompt(Prompt$, "ync", Outpt$)
            Select Case Outpt$
               Case "c"
                  More.Display = True
               Case "n"
                  Quit.Searching = True
            End Select
         End If
      End If
   End If
End Sub

Sub MorePrompt (Input.String$, Input.Mask$, Output.String$)
   Color White, Black
   Print Input.String$ + " ";
   Input.Char$ = NUL
   Locate , , 1
   Do
      _Limit 100
      Input.Char$ = InKey$
      If Len(Input.Char$) Then
         Input.Char$ = LCase$(Input.Char$)
         If InStr(Input.Mask$, Input.Char$) Then
            Print Input.Char$
            Output.String$ = Input.Char$
            Exit Do
         End If
      End If
   Loop
End Sub

' displays carry flag error
Sub DisplayError (Temp$)
   ' check display errors flag
   If Display.Errors = False Then
      ' display error
      Color Red, Black
      Print Temp$
   End If
End Sub

' subroutine to execute DOS command
Sub ExecuteCommand (DOS.Filename$)
   ' make replacement parameters
   DOS.Pathname$ = DOS.Filename$
   Imbedded1 = InStr(DOS.Pathname$, "\")
   Imbedded2 = False
   While Imbedded1
      Imbedded2 = Imbedded1
      Imbedded1 = InStr(Imbedded1 + 1, DOS.Pathname$, "\")
   Wend
   Filename$ = Mid$(DOS.Pathname$, Imbedded2 + 1)
   If Imbedded2 Then
      DOS.Pathname$ = Left$(DOS.Pathname$, Imbedded2 - 1)
   Else
      DOS.Pathname$ = NUL
   End If
   Extension$ = NUL
   Imbedded = InStr(Filename$, ".")
   If Imbedded Then
      Extension$ = Mid$(Filename$, Imbedded + 1)
      Filename$ = Left$(Filename$, Imbedded - 1)
   End If

   ' store replacement parameters
   If Left$(DOS.Filename$, 2) = "\\" Then
      Parameters(1) = "\\"
      Parameters(2) = "\\"
      Parameters(3) = DOS.Pathname$
      Parameters(4) = DOS.Pathname$ + "\"
      Parameters(5) = DOS.Filename$
   Else
      Parameters(1) = Drive.Search + ":"
      Parameters(2) = Drive.Search + ":\"
      Parameters(3) = Drive.Search + ":" + DOS.Pathname$
      Parameters(4) = Drive.Search + ":" + DOS.Pathname$ + "\"
      Parameters(5) = Drive.Search + ":" + DOS.Filename$
   End If
   Parameters(6) = DOS.Pathname$
   Parameters(7) = DOS.Pathname$ + "\"
   Parameters(8) = DOS.Filename$
   Parameters(9) = Filename$ + "." + Extension$
   Parameters(10) = Filename$
   Parameters(11) = "." + Extension$
   Parameters(12) = Extension$

   ' create DOS command
   Execute.Command$ = DOS.Command

   ' replace parameters
   Count = 1
   Do
      If Count >= Len(Execute.Command$) Then
         Exit Do
      End If
      Imbed$ = Mid$(Execute.Command$, Count, 1)
      If Imbed$ = "%" Then
         Imbed2$ = Mid$(Execute.Command$, Count + 1, 1)
         Select Case UCase$(Imbed2$)
            Case "1" To "9", "A" To "C"
               Count2 = Val("&H" + Imbed2$)
               Execute.Command$ = Left$(Execute.Command$, Count - 1) + RTrim$(Parameters(Count2)) + Mid$(Execute.Command$, Count + 2)
               Count = Count + Len(RTrim$(Parameters(Count2)))
            Case Else
               Count = Count + 1
         End Select
      Else
         Count = Count + 1
      End If
   Loop

   ' start DOS command shell
   If Len(Execute.Command$) Then
      ' check display counter
      If Wide.List Then
         Wide.List = False
         Print
      End If

      ' read command path from environment
      Comspec$ = Environ$("COMSPEC")
      If Len(Comspec$) Then
         ' call shell routine
         If Disable.Cmd Then
            Shell.Command$ = Comspec$ + " /C " + Execute.Command$
         Else
            Shell.Command$ = Comspec$ + " /K " + Execute.Command$
         End If
         Shell Shell.Command$
      End If
   End If
End Sub

' routine compares occurrence of filename1$ in filename2$
' with pattern matching.
Sub CheckExcluded (Filename1$, Filename2$)
   Exclude.File = True ' assume mask matches filename2.
   Length1 = 1
   Length2 = 1
   Do
      ' global replacement.
      If Mid$(Filename1$, Length1, 1) = "*" Then
         Do
            Length1 = Length1 + 1
            If Length1 > Len(Filename1$) Then
               Exit Sub
            End If
            ' global replacement followed by exclusion character.
            ' searches remaining string until exclusion character found or not.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               Do
                  If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                     Length2 = Length2 + 1
                  Else
                     Exclude.File = False
                     Exit Sub
                  End If
                  If Length2 > Len(Filename2$) Then
                     Exit Sub
                  End If
               Loop
            End If
            ' global replacement followed by ? or another *
            ' skips to next character.
            If Mid$(Filename1$, Length1, 1) <> "*" Then
               If Mid$(Filename1$, Length1, 1) <> "?" Then
                  Exit Do
               End If
            End If
         Loop
         ' global replacement.
         ' searches for next matching character.
         Do
            If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
               Exit Do
            Else
               Length2 = Length2 + 1
            End If
            If Length2 > Len(Filename2$) Then
               Exit Do
            End If
         Loop
      Else
         ' character replacement.
         ' matches any next character.
         If Mid$(Filename1$, Length1, 1) = "?" Then
            Length1 = Length1 + 1
            Length2 = Length2 + 1
         Else
            ' exclusion character.
            ' checks next character unmatched.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Exclude.File = False
                  Exit Do
               End If
            Else
               ' matches next character.
               If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Exclude.File = False
                  Exit Do
               End If
               ' check string lengths.
               If Length1 > Len(Filename1$) Then
                  If Length2 <= Len(Filename2$) Then
                     Exclude.File = False
                  End If
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
End Sub

' command line switch position function.
Function LastSwitch (Var)
   If Last.Switch = 0 Then
      Last.Switch = Var - 1
      Switch.Exist = -1
   Else
      If Var < Last.Switch Then
         Last.Switch = Var - 1
         Switch.Exist = -1
      End If
   End If
   LastSwitch = -1
End Function

' command line parser
Function ParseLine (X$)
   Imbedded = InStr(Command.Line, LCase$(X$))
   If Imbedded Then
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
      Last.Switch = Imbedded - 1
      ParseLine = True
      Switch.Exist = -1
   Else
      Imbedded = InStr(Command.Line, UCase$(X$))
      If Imbedded Then
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
         Last.Switch = Imbedded - 1
         ParseLine = True
         Switch.Exist = -1
      Else
         ParseLine = False
      End If
   End If
End Function

' formats a double numeric string
Function FormatString$ (s#)
   x$ = ""
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If
   x$ = e$ + x$ + q$ ' construct string
   FormatString$ = x$
End Function

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


