Rem Memory Usage Monitor

_Define A-Z As _UNSIGNED _INTEGER64

Declare Library "mem"
    Function MemInUsePercent~&&
    Function TotalPhysicalMem~&&
    Function FreePhysicalMem~&&
    Function TotalPagingFile~&&
    Function FreePagingFile~&&
    Function TotalVirtualMem~&&
    Function FreeVirtualMem~&&
    Function FreeExtendedMem~&&
    Function GetCPULoad#
End Declare

' byte suffix type
Dim Shared Var2 As Integer

' check os
If InStr(_OS$, "[WINDOWS]") = 0 Then
    Print "This program only works in Windows."
    End
End If
If InStr(_OS$, "[ANDROID]") Then
    Print "This program only works in Windows."
    End
End If

_Title "MEMORY USAGE"
Do
    _Delay 1
    I$ = InKey$
    If _Exit Or I$ = Chr$(27) Then
        End
    End If
    Cls
    Color 14, 0
    Print "Press <escape> to quit."
    Print
    Color 15, 0

    ' GetCPULoad = 0 is idle, 1 is fully used.
    '  Multiply by 100 for a percentage
    '    PRINT "CPU used:"; STR$(INT(GetCPULoad * 10000) / 100); "%"

    Print "CPU used:";
    S$ = Str$(Int(GetCPULoad * 10000) / 100) ' 100.00
    If InStr(S$, ".") Then
        X$ = Mid$(S$, InStr(S$, ".") + 1)
        S$ = Left$(S$, InStr(S$, ".") - 1)
        X$ = Left$(X$, 3)
        S$ = S$ + "." + X$
    Else
        S$ = S$ + ".0"
    End If
    Print S$; "%" ' 100.00

    Print "Memory used:"; Str$(MemInUsePercent); "%"
    Print

    Print "Total Physical Memory: "
    T = TotalPhysicalMem
    GoSub DisplayBytes

    Print "Free Physical Memory: "
    T = FreePhysicalMem
    GoSub DisplayBytes

    Print "Total Paging File: "
    T = TotalPagingFile
    GoSub DisplayBytes

    Print "Free Paging File: "
    T = FreePagingFile
    GoSub DisplayBytes

    Print "Total Virtual Memory: "
    T = TotalVirtualMem
    GoSub DisplayBytes

    Print "Free Virtual Memory:"
    T = FreeVirtualMem
    GoSub DisplayBytes

    ' always seems to be zero:
    '    PRINT "Free Extended Virtual Memory:"
    '    T = FreeExtendedMem
    '    GOSUB DisplayBytes
Loop
End

' format output line
DisplayBytes:
S$ = ""
For Var2 = 0 To 3
    S$ = S$ + ByteFormat$(T)
Next
Print S$
Return

' format byte for output line
Function ByteFormat$ (S)
    T$ = Suffix$(S)
    Select Case Var2
        Case 0 ' bytes
            ' 1,234,567,789
            T$ = Space$(15 - Len(T$)) + T$
        Case 1 ' kilo
            ' 4,567,789.0 KB
            T$ = Space$(16 - Len(T$)) + T$
        Case 2 ' mega
            ' 7,789.01 MB
            T$ = Space$(13 - Len(T$)) + T$
        Case 3 ' giga
            ' 9.012 GB
            T$ = Space$(10 - Len(T$)) + T$
    End Select
    ByteFormat$ = T$
End Function

' calculate byte suffix.
Function Suffix$ (Var)
    Dim Var3 As Single
    ' Var - input value
    ' Var2 - 0 = bytes, 1 = kilo, 2 = mega, 3 = giga
    Rem B  (Byte) = 00x - 0FFx
    Rem KB (Kilobyte) = 1024 B
    Rem MB (Megabyte) = 1024 KB
    Rem GB (Gigabyte) = 1024 MB

    ' check exponent.
    Var3 = CSng(Var)
    s$ = Str$(Var3)
    If InStr(s$, "D") Then
        Suffix$ = s$
        Exit Function
    End If

    ' check bytes.
    If Var2 = 0 Then
        Suffix$ = FormatString$(Var)
        Exit Function
    End If

    ' calculate byte suffix.
    For TempA = 1 To Var2
        Var3 = Var3 / 1024
    Next

    ' calculate byte string
    Varx$ = FormatString$(Var3)

    ' make byte suffix.
    Var$ = ""
    Select Case Var2
        Case 1
            Var$ = "KB"
        Case 2
            Var$ = "MB"
        Case 3
            Var$ = "GB"
    End Select

    ' get single precision decimal place.
    If Int(Var3) <> Var3 Then
        x$ = Str$(Var3)
        x = InStr(x$, ".")
        x$ = Mid$(x$, x)
        Select Case Var2
            Case 1 ' KB
                x$ = Left$(x$, 2)
            Case 2 ' MB
                x$ = Left$(x$, 3)
            Case 3 ' GB
                x$ = Left$(x$, 4)
        End Select
        Varx$ = Varx$ + x$
    Else
        Varx$ = Varx$ + ".0"
    End If

    ' append suffix.
    Suffix$ = Varx$ + " " + Var$
End Function

' formats a numeric string.
Function FormatString$ (s)
    x$ = ""
    s$ = Str$(s)
    s$ = LTrim$(s$)
    For l = Len(s$) To 3 Step -3
        x$ = Mid$(s$, l - 2, 3) + "," + x$
    Next
    If l > 0 Then
        x$ = Mid$(s$, 1, l) + "," + x$
    End If
    If Len(s$) < 3 Then
        x$ = s$
    End If
    If Right$(x$, 1) = "," Then
        x$ = Left$(x$, Len(x$) - 1)
    End If
    FormatString$ = x$
End Function

