Rem QB64SHELL - command line prompt shell windows program for QB64 PD 2025.

' define all default variables.
DefLng A-Z

' declare redim variables.
Rem $Dynamic

' set all shared variables.
Rem $Include:'qb64shell.inc'

' declare standard error trap.
On Error GoTo Error.Routine

' set midi sound font.
$If VERSION < 4.0.0 Then
   $UNSTABLE: MIDI
   $MIDISOUNDFONT: DEFAULT
$End If

' display titlebar icon.
Call StartDisplay

' store command arrays.
Call InitData(0)

' reset multi-dimensional command history arrays.
For VarQ1 = 1 To 3
   For VarQ2 = 1 To MaxHistory
      History2(VarQ1, VarQ2) = ""
   Next
Next

' initialize some variables.
Token.List = " -+*/\^()[]{}<>=|&!%~?:#@`;," + Chr$(34) ' cannot be changed.
White.Space = Chr$(32) + Chr$(9) ' can be changed.

' force all ascii output.
_ControlChr Off

' force default path.
Start.Directory = _CWD$
x$ = _StartDir$
StartDir$ = x$
If Right$(StartDir$, 1) <> "\" Then
   StartDir$ = StartDir$ + "\"
End If
f$ = x$ + Chr$(0)
x = SetCurrentDirectoryA(f$)

' store default path in table
ReDim DriveTable(26) As String
ReDim NetPathTable(1) As String
ReDim PathTable(1) As String
NetPathCount = 0
PathCount = 1
PathMax = 1
PathTable(1) = _StartDir$
If Left$(x$, 2) = "\\" Then
   NetPathCount = 1
   NetPathTable(1) = _CWD$
Else
   V = Asc(Left$(x$, 1)) - 64
   DriveTable(V) = _CWD$
End If

' parse config file
Call ReadKeys
Call ReadConfig

' init user profiles
Username = ""
Password = ""
UsernameTemp = ""
Call InitProfiles(0)

' play intro
If SoundEffect = 0 Then
   If _FileExists(SoundFile) Then
      _SndPlayFile (SoundFile)
   End If
End If

' intialize some variables.
Call InitVars

' initialize server name.
Call StoreServerName

' read config file.
Call ReadConfigFile

' get current drive/directory.
Call GetDrive(Drive.Number, OldDirectory$)

' force user as admin.
If IsUserAnAdmin = 0 Then
   Call ShellExecute(0, "runas" + Chr$(0), Command$(0) + Chr$(0), Command$ + Chr$(0), 0, 5)
   System
End If

' get file from url
If SoundEffect = 0 Then
   Call GrabURL(0, "")
End If
Call GrabURL(-2, "")

' declare startup settings
_Title Program
On Timer(1) CPUtrap

' start timer trap.
t1 = _FreeTimer
On Timer(t1, 1) Timer.Trap
Timer(t1) On
VarQ = _Exit

' initialize screen saver
'ScreenSaverActive = 0
'ScreenSaverResolution = 0!
ScreenSaverTimer = 0!
KeyPressed = 0
MousePressed = 0
 
' start screen saver timer trap.
t2 = _FreeTimer
On Timer(t2, 1) Saver.Trap
Timer(t2) On

' restore screen coordinates
_ScreenMove WindowX, WindowY

' get command line
Call ParseCommandLine
If CPUOFF = 0 Then
   Timer On
End If

' start memory monitor timer trap.
MonitorCount = 0
MonitorTimer = 60 ' seconds
MonitorLimit = 10 ' megabytes
MonitorSuffix = 0
t3 = _FreeTimer
On Timer(t3, 1) Monitor.Trap
Timer(t3) On

' start alarm timer trap (added 05/28/2023)
t8 = _FreeTimer
t9! = 1!
On Timer(t8, t9!) CheckAlarms ' alarms
Timer(t8) On

Rem List of all timers:
Rem    CPUtrap
Rem    Ctrl-Break Timer.Trap
Rem    ScreenSaver Saver.Trap
Rem    Monitor.Trap
Rem    CheckAlarms

' define and turn on keys
Color Plain
Cls
Call SetKeys
If KEYOFF = 0 Then
   Key On
End If

' display program name and version
Status = 0
If SOFF = 0 Then
   Color Yellow
   Locate 24, 1, 1
   Call DisplayVersion
   Status = -1
End If

' display toolbar
Call Toolbar

' define viewport of text screen
If SOFF = 0 Then
   View Print 2 To 23
Else
   View Print 2 To 24
End If

' start prompt input loop
Cls
Color White
If Status Then
   Locate 23, 1, 1
Else
   Locate 24, 1, 1
End If

' get username profile
If ProfilesActive Then
   Call GetUserProfile(V, UsernameTemp)
   Color Yellow
   If V Then
      Print "User " + RTrim$(UserProfileRecord.Username) + " logged in at " + Date$ + " " + Time$
   Else
      Print "User logged in at " + Date$ + " " + Time$
   End If
End If
StartLoop:
Do
   Do
      ' declare standard error trap
      Error.Resume0:
      On Error GoTo Error.Routine
      If RestartWhatisBox Then
         RestartWhatisBox = 0
         r = WhatisBox("sqr(2)", "")
      End If
      Control.Break = False
      Display.Errors = False
      Strip.Blanks = False
      Strip.Drives = False
      ' reset stdio handles
      If StdinHandle Then
         Close #StdinHandle
      End If
      Close #StdoutHandle
      StdoutHandle = FreeFile
      StdoutFile$ = "scrn:"
      Open "scrn:" For Output As StdoutHandle
      Do
         Color White
         Locate , 1, 1
         Call DisplayPrompt
         Color Plain, Black
         Locate , , 1
         Temp0 = 1
         x$ = LTrim$(KeyboardLine$(1)): Print
         ' parse drop down menu selection
         M = CurrentMenu
         N = CurrentMenuSelection
         CurrentMenu = 0
         Select Case M
            Case 3, 6 ' hex screen/file dump/print
               Color Plain, Black
               Print "Error: Only works in screen editor."

               ' store screen area.
               CurrentX = CsrLin
               CurrentY = Pos(0)
               Call DisplayToolBar
               Color Plain, Black
               Locate CurrentX, CurrentY, 1
            Case 5 ' jump byte/line
               Color Plain, Black
               Print "Error: Jump only works in screen editor."

               ' store screen area.
               CurrentX = CsrLin
               CurrentY = Pos(0)
               Call DisplayToolBar
               Color Plain, Black
               Locate CurrentX, CurrentY, 1
            Case 7 ' search byte/line
               Color Plain, Black
               Print "Error: Search only works in screen editor."

               ' store screen area.
               CurrentX = CsrLin
               CurrentY = Pos(0)
               Call DisplayToolBar
               Color Plain, Black
               Locate CurrentX, CurrentY, 1
            Case 1
               Select Case N
                  Case 1 ' open file
                     ' store screen area.
                     CurrentX = CsrLin
                     CurrentY = Pos(0)
                     Call SaveScreen

                     ' read information from file menu box.
                     Call ClearKeys
                     Call DisplayToolBar

                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     Filename = _SaveFileDialog$(Title$, StartDir$, Filter$)
                     Call SetKeys

                     ' restore screen lower area.
                     If Status = 0 Then
                        View Print 2 To 24
                        Color Plain
                        Cls
                        Call RestoreScreen
                        Locate 23, 1, 1
                        Color White
                        Call DisplayPrompt
                        Print
                        Locate 24, 1, 1
                     Else
                        Color Yellow
                        Call DisplayVersion
                        View Print 2 To 23
                        Color Plain
                        Cls
                        Call RestoreScreen
                     End If
                     If KEYOFF = 0 Then
                        Key On
                     End If

                     ' restore screen area.
                     Call RestoreScreen
                     Color Plain, Black
                     Locate CurrentX, CurrentY, 1
                     If Len(Filename) Then
                        View Print 1 To 25
                        Key Off
                        Cls
                        Color White, Black
                        Locate 25, 1
                        VarC = 0
                        Var$ = Filename
                        Call ClearKeys
                        Call ScrnEdit(Var$, VarZ, VarC)
                        Call SetKeys
                        Var1$ = Nul
                        Var2$ = Nul
                        Select Case VarZ
                           Case 0
                              Var1$ = " Exit "
                              Var2$ = "File edited."
                           Case -1
                              Var1$ = " Saved "
                              Var2$ = "File stored to disk."
                              Var2$ = Var2$ + "|" + "Bytes: " + FormatString$(FileSize)
                           Case -2
                              Var1$ = " Error "
                              Var2$ = "Error creating file."
                           Case -3
                              Var1$ = " Error "
                              Var2$ = "Invalid filename."
                           Case -4
                              Var1$ = " Error "
                              Var2$ = "Interrupt."
                           Case -5
                              Var1$ = " Error "
                              Var2$ = "Overflow."
                        End Select
                        Call DisplayToolBar
                        If Status = 0 Then
                           View Print 2 To 24
                           Color Plain
                           Cls
                           Call RestoreScreen
                           Locate 23, 1, 1
                           Color White
                           Call DisplayPrompt
                           Print
                           Locate 24, 1, 1
                        Else
                           View Print 2 To 24
                           Locate 24, 1, 1
                           Color Yellow
                           Call DisplayVersion
                           View Print 2 To 23
                           Color Plain
                           Cls
                           Call RestoreScreen
                        End If
                        If KEYOFF = 0 Then
                           Key On
                        End If
                        If Len(Var1$) Then
                           VarX = MessageBox(Var1$, Var2$)
                        End If
                     End If
                  Case 2 ' close file
                     File.Loaded = 0
                     Color Plain, Black
                     Print "File handles closed."

                     ' store screen area.
                     CurrentX = CsrLin
                     CurrentY = Pos(0)
                     Call DisplayToolBar
                     Color Plain, Black
                     Locate CurrentX, CurrentY, 1
                  Case 3 ' print file
                     ' store screen area.
                     CurrentX = CsrLin
                     CurrentY = Pos(0)
                     Call SaveScreen

                     ' read information from file menu box.
                     Call ClearKeys
                     Call DisplayToolBar

                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Print File" + Chr$(0)
                     Filename = _OpenFileDialog$(Title$, StartDir$, Filter$)
                     Call SetKeys

                     ' restore screen lower area.
                     If Status = 0 Then
                        View Print 2 To 24
                        Color Plain
                        Cls
                        Call RestoreScreen
                        Locate 23, 1, 1
                        Color White
                        Call DisplayPrompt
                        Print
                        Locate 24, 1, 1
                     Else
                        View Print 2 To 24
                        Locate 24, 1, 1
                        Color Yellow
                        Call DisplayVersion
                        View Print 2 To 23
                        Color Plain
                        Cls
                        Call RestoreScreen
                     End If
                     Call DisplayToolBar
                     If KEYOFF = 0 Then
                        Key On
                     End If

                     ' restore screen area.
                     Call RestoreScreen
                     Color Plain, Black
                     Locate CurrentX, CurrentY, 1
                     ' print file
                     If Len(Filename) Then
                        If InStr(Filename, "?") = 0 Then
                           x = FreeFile
                           Open Filename For Input As #x
                           Do Until EOF(x)
                              Line Input #x, Strng
                              ' replace unprintable characters
                              For V = 1 To Len(Strng)
                                 If Asc(Mid$(Strng, V, 1)) < 32 Then
                                    Mid$(Strng, V, 1) = "."
                                 End If
                              Next
                              LPrint Strng
                           Loop
                           LPrint Chr$(12);
                           Close #x
                        End If
                     End If
                  Case 4 ' view file info
                     ' store screen area.
                     CurrentX = CsrLin
                     CurrentY = Pos(0)
                     Call SaveScreen

                     ' read information from file menu box.
                     Call ClearKeys
                     Call DisplayToolBar

                     ' do theOOpen file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell View File" + Chr$(0)
                     Filename = _OpenFileDialog$(Title$, StartDir$, Filter$)
                     Call SetKeys

                     ' restore screen lower area.
                     If Status = 0 Then
                        View Print 2 To 24
                        Color Plain
                        Cls
                        Call RestoreScreen
                        Locate 23, 1, 1
                        Color White
                        Call DisplayPrompt
                        Print
                        Locate 24, 1, 1
                     Else
                        View Print 2 To 24
                        Locate 24, 1, 1
                        Color Yellow
                        Call DisplayVersion
                        View Print 2 To 23
                        Color Plain
                        Cls
                        Call RestoreScreen
                     End If
                     Call DisplayToolBar
                     If KEYOFF = 0 Then
                        Key On
                     End If

                     ' restore screen area.
                     Call RestoreScreen
                     Color Plain, Black
                     Locate CurrentX, CurrentY, 1
                     If Len(Filename) Then
                        CurrentCommand = 0
                        CommandCount = 0
                        StdoutFile$ = "scrn:"
                        COMMAND2$ = Quote + Filename + Quote + " /C"
                        Call ViewFileInfo(Filename)
                     End If
                  Case 5 ' type file
                     ' store screen area.
                     CurrentX = CsrLin
                     CurrentY = Pos(0)
                     Call SaveScreen

                     ' read information from file menu box.
                     Call ClearKeys
                     Call DisplayToolBar

                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Type File" + Chr$(0)
                     Filename = _OpenFileDialog$(Title$, StartDir$, Filter$)
                     Call SetKeys

                     ' restore screen lower area.
                     If Status = 0 Then
                        View Print 2 To 24
                        Color Plain
                        Cls
                        Call RestoreScreen
                        Locate 23, 1, 1
                        Color White
                        Call DisplayPrompt
                        Print
                        Locate 24, 1, 1
                     Else
                        View Print 2 To 24
                        Locate 24, 1, 1
                        Color Yellow
                        Call DisplayVersion
                        View Print 2 To 23
                        Color Plain
                        Cls
                        Call RestoreScreen
                     End If
                     Call DisplayToolBar
                     If KEYOFF = 0 Then
                        Key On
                     End If

                     ' restore screen area.
                     Call RestoreScreen
                     Color Plain, Black
                     Locate CurrentX, CurrentY, 1
                     If Len(Filename) Then
                        If InStr(Filename, "?") = 0 Then
                           CurrentCommand = 0
                           CommandCount = 0
                           StdoutFile$ = "scrn:"
                           COMMAND2$ = Quote + Filename + Quote + " /C"
                           Call TypeY(Var)
                        End If
                     End If
                  Case 6 ' exit program
                     If QuitBox Then
                        Call WriteConfig
                        Call WriteProfile
                        Call PutUserStats(V#)
                        Color Plain, Black
                        System
                     End If
               End Select
            Case 2
               Select Case N
                  Case 1 ' ascii chart
                     Call AsciiChart
                     Call DisplayToolBar
                  Case 2 ' hex chart
                     Call HexChart
                     Call DisplayToolBar
               End Select
            Case 4
               Select Case N
                  Case 1, 2 ' append byte/string
                     Color Plain, Black
                     Print "Error: Append only works in screen editor."

                     ' store screen area.
                     CurrentX = CsrLin
                     CurrentY = Pos(0)
                     Call DisplayToolBar
                     Color Plain, Black
                     Locate CurrentX, CurrentY, 1
                  Case 3 ' redraw
                     View Print 1 To 25
                     Key Off
                     Cls
                     Color White, Black
                     Locate 25, 1
                     Call Toolbar
                     If Status = 0 Then
                        View Print 2 To 24
                        Color Plain
                        Locate 24, 1, 1
                     Else
                        Locate 24, 1, 1
                        Color Yellow
                        Call DisplayVersion
                        View Print 2 To 23
                        Color Plain
                        Locate 23, 1, 1
                     End If
                     If KEYOFF = 0 Then
                        Key On
                     End If
               End Select
         End Select
         If Len(x$) Then
            Exit Do
         End If
      Loop
      Display.Errors = False
      Strip.Blanks = False
      Strip.Drives = False
      If Left$(UCase$(x$), 7) = "COMMAND" Then
         x$ = "SHELL" + Mid$(x$, 8)
         Call ShellSub(x$)
         GoTo StartLoop
      End If
      If Left$(UCase$(x$), 3) = "CMD" Then
         x$ = "SHELL" + Mid$(x$, 4)
         Call ShellSub(x$)
         GoTo StartLoop
      End If
      If Left$(UCase$(x$), 5) = "SHELL" Then
         Call ShellSub(x$)
         GoTo StartLoop
      End If
      If Mid$(x$, 2, 1) = ":" Then
         Call SwitchDrive(x$)
         GoTo StartLoop
      End If
      If Left$(x$, 2) = "\\" Then
         Call SwitchNetpath(x$)
         GoTo StartLoop
      End If

      ' read all redirect symbols
      Call PreParse(x$, V, z)
      If V = -1 Then
         x = -1
         Print "Error: ";
         Select Case z
            Case 1
               Print "Multiple redirect symbols."
            Case 2
               Print "Multiple redirect error symbols."
            Case 3
               Print "Multiple redirect output symbols."
            Case 4
               Print "Invalid redirect filename characters."
            Case 5
               Print "Cannot open stdin filename."
            Case 6
               Print "Cannot open stdout filename."
            Case 7
               Print "Cannot open stderr filename."
         End Select
      Else
         ' close output handle
         If StdoutHandle Then
            Close StdoutHandle
         End If

         ' open output handle
         StdoutHandle = FreeFile
         If Stdout = 0 Then
            StdoutFile$ = "scrn:"
            Open "scrn:" For Output As StdoutHandle
         Else
            If Stdout = 1 Then
               Open StdoutFile$ For Output As StdoutHandle
            Else
               If Stdout = 2 Then
                  Open StdoutFile$ For Append As StdoutHandle
               End If
            End If
         End If

         ' close error handle
         If StderrHandle Then
            Close StderrHandle
         End If

         ' open error handle
         StderrHandle = FreeFile
         If Stderr = 0 Then
            StderrFile$ = "scrn:"
            Open "scrn:" For Output As StderrHandle
         Else
            If Stderr = -1 Then
               Open StderrFile$ For Append As StderrHandle
            End If
         End If

         ' read stdin
         Call PreFetch

         ' reset timers
         Timer Off
         _Title Program
         Display.Errors = False
         Strip.Blanks = False
         Strip.Drives = False
         Call SimpleParse(x$, x)
         If CPUOFF = 0 Then
            Timer On
         Else
            _Title Program
         End If
      End If
      If x = -2 Then
         ' declare error routine
         On Error GoTo Whatis.Error.Routine
         Error.Resume1:

         ' whatis input loop
         Control.Break = False
         Do
            If Len(x$) Then
               Error.Trap.Type = 0
               Out2 = x$
               x$ = ""
               Parse.Type = 1
               Recurse = 0
               WhatsError = 0
               Call Enter.Equate
               Exit Do
            End If
            Error.Trap.Type = -1
            Color Yellow, Black
            Locate , 1, 1
            Print "Whatis>";
            Locate , , 1
            ' get input line
            Color Plain, Black
            Temp0 = 2
            Out2 = KeyboardLine$(2): Print
            ' parse input line
            Call Remove.Spaces
            If UCase$(Out2) = "QUIT" Then
               Exit Do
            End If
            ' calculate line
            Parse.Type = 2
            Recurse = 0
            WhatisError = 0
            Call Enter.Equate
         Loop
      End If
      If x = 0 Then
         Timer Off
         _Title Program
         Call ComplexInit(x$, x, z)
         If x = 0 Then
            x = -1
            If z = 1 Then
               Print "Error: Missing command. Type HELP for help."
            End If
            If z = 2 Then
               Print "Error: Mismatched brackets. Type HELP for help."
            End If
            If z = 3 Then
               Print "Error: Unknown command. Type HELP for help."
            End If
         Else
            TeeCalls = 0
            ParseCalls = 0
            For CurrentCommand = 1 To CommandCount
               ' copy stdout to stdin
               If CurrentCommand > 1 Then
                  If StdoutLines > StdinMax Then
                     StdinMax = StdoutLines
                     ReDim _Preserve StdinArray(StdinMax) As String
                  End If
                  For StdoutCount = 1 To StdoutLines
                     StdinArray(StdoutCount) = StdoutArray(StdoutCount)
                  Next
                  StdinLines = StdoutLines
               End If
               Display.Errors = False
               Strip.Blanks = False
               Strip.Drives = False
               ' process next command in stream
               x$ = CommandList(CurrentCommand)
               Call ComplexParse(x$, x)
               If x = 0 Then ' command not found
                  Exit For
               End If
               If x = -2 Then ' command line switch error
                  Exit For
               End If
            Next
         End If
         If CPUOFF = 0 Then
            Timer On
         Else
            _Title Program
         End If
      End If
      If x = 0 Then
         Exit Do
      End If
   Loop
   Print "Type HELP for help."
Loop
Sleep 5
End

' whatisbox error routine
WhatError:
DataError = Err
Cls
Print "Whatis box error"; Err; "IDE line"; _ErrorLine
Select Case DataError
   ' standard errors.
   Case 7
      Print "Out of memory."
   Case 9
      Print "Subscript out of range."
   Case 14
      Print "Out of string space."
   Case 53
      Print "File not found."
   Case 57
      Print "Media error."
   Case 61
      Print "Disk full."
   Case 70
      Print "Permission denied."
   Case 71
      Print "Disk not ready."
      ' extended errors.
   Case 5
      Print "Error #001: Illegal function call."
   Case 6
      Print "Error #002: Overflow."
   Case 9
      Print "Error #003: Subscript out of range."
   Case 11
      Print "Error #004: Division by zero."
   Case 92
      If Strng = ")" Then
         Print "Error #005: Whatis: <token error>"
      Else
         If Strng = Quote Then
            Print "Error #005: Whatis: <quote error>"
         Else
            Print "Error #005: Whatis: "; Strng
         End If
      End If
   Case 130
      Print "Error #006: Bad numeric specifier."
   Case 140
      Print "Error #007: Bad exponent specifier."
   Case 145
      Print "Error #008: Bad DEFFN declaration."
   Case 110
      Print "Error #009: Unknown swap statement."
   Case 112
      Print "Error #010: Negative square root."
   Case Else
      Print "Critical error: " + Quote + LTrim$(Str$(DataError)) + Quote + " in WhatisBox."
End Select
Print "Restarting Whatis box."
RestartWhatisBox = -1
Resume Error.Resume0

' whatis error routine
Whatis.Error.Routine:
Error.Mode = Err
Select Case Error.Mode
   ' standard errors.
   Case 7
      Print #StderrHandle, "Out of memory."
   Case 9
      Print #StderrHandle, "Subscript out of range."
   Case 14
      Print #StderrHandle, "Out of string space."
   Case 53
      Print #StderrHandle, "File not found."
   Case 57
      Print #StderrHandle, "Media error."
   Case 61
      Print #StderrHandle, "Disk full."
   Case 70
      Print #StderrHandle, "Permission denied."
   Case 71
      Print #StderrHandle, "Disk not ready."
      ' extended errors.
   Case 5
      Print #StderrHandle, "Error #001: Illegal function call."
   Case 6
      Print #StderrHandle, "Error #002: Overflow."
   Case 9
      Print #StderrHandle, "Error #003: Subscript out of range."
   Case 11
      Print #StderrHandle, "Error #004: Division by zero."
   Case 92
      If Strng = ")" Then
         Print #StderrHandle, "Error #005: Whatis: <token error>"
      Else
         If Strng = Quote Then
            Print #StderrHandle, "Error #005: Whatis: <quote error>"
         Else
            Print #StderrHandle, "Error #005: Whatis: "; Strng
         End If
      End If
   Case 130
      Print #StderrHandle, "Error #006: Bad numeric specifier."
   Case 140
      Print #StderrHandle, "Error #007: Bad exponent specifier."
   Case 145
      Print #StderrHandle, "Error #008: Bad DEFFN declaration."
   Case 110
      Print #StderrHandle, "Error #009: Unknown swap statement."
   Case 112
      Print #StderrHandle, "Error #010: Negative square root."
   Case Else
      Print #StderrHandle, "Critical error: " + Quote + LTrim$(Str$(Error.Mode)) + Quote + " in Whatis."
      '    PRINT "Error #000: Error"; Error.Mode
End Select
If Error.Trap.Type Then
   Resume Error.Resume1
Else
   Resume Error.Resume0
End If

' critical error trap
Error.Routine:
' check _openclient
If clientdetect Then
   clienthandle = 0
   Resume Next
End If
' process error
DataError = Err
DataError2 = Err
If WhatisError Then
   Prompt$ = "$P$G"
   Resume Next
End If
If Error.Flag Then
   Resume Next
End If
If Display.Errors Then
   Error.Level = True
   Resume Next
End If
' check share violations.
If Err = 70 Then
   Share.Count = Share.Count + 1
   If Share.Count < MaxViolations Then
      Resume
   End If
   Share.Count = False
End If

If Wide.List Then
   Wide.List = False
   Print
End If

' store error in log file.
x$ = "Critical error:" + Str$(DataError) + "; IDE line:" + Str$(_ErrorLine) + " " + Date$ + " " + Time$
' check netpath
If Left$(StartDir$, 2) = "\\" Then GoTo NextError
' check path for file
Var$ = StartDir$
V = Asc(UCase$(Left$(Var$, 1))) - 64
If DRIVEEXISTS(V) Then GoTo NextError
If DriveType = "[CDROM]" Then GoTo NextError

' store error flags
DataError = 0
Error.Flag = -1

' write error to file
x = FreeFile
Open CriticalErrorLogFile$ For Append As #x
Error.Flag = 0
If DataError Then
   GoTo NextError
End If

Print #x, x$
Close #x
NextError:

' display error.
Color Green, Black
x$ = "Critical error:" + Str$(DataError2) + "; IDE line:" + Str$(_ErrorLine)
Print x$

' trap error return type.
Prompt2$ = "Press C to continue, R to retry, S exit to system, A to abort, Q to quit:"
Call MorePrompt(Prompt2$, "crasq", Outpt$)
Color Plain, Black
Select Case Outpt$
   Case "a"
      Call WriteConfig
      Call WriteProfile
      Call PutUserStats(V#)
      Color Plain, Black
      End
   Case "s"
      Call WriteConfig
      Call WriteProfile
      Call PutUserStats(V#)
      Color Plain, Black
      System
   Case "q"
      Error.Level = True
      Resume Error.Resume0
   Case "r"
      Resume
   Case "c"
      Resume Next
End Select
Color Plain, Black
End 0

' memory monitor trap
Sub Monitor.Trap
   If MONITORON = 0 Then
      Exit Sub
   End If
   If MonitorLimit = 0# Then
      Exit Sub
   End If
   If MonitorTimer = 0 Then
      Exit Sub
   End If
   MonitorCount = MonitorCount + 1
   If MonitorCount <= MonitorTimer Then
      Exit Sub
   End If
   MonitorCount = 0
   X# = MonitorLimit * Mega
   If FreePhysicalMem > X# Then
      Exit Sub
   End If
   s1$ = LTrim$(Str$(MonitorTimer))
   s2$ = LTrim$(Str$(MonitorLimit))
   s3$ = s1$: s4$ = s2$
   r = MonitorBox(s1$, s2$)
   If DisplaySelect Then
      MONITORON = 0
      Exit Sub
   End If
   If r = 0 Then
      Exit Sub
   End If
   If r = 2 Then
      Call WriteConfig
      Call WriteProfile
      Call PutUserStats(V#)
      Color Plain, Black
      Exit Sub
   End If
   If r = 1 Then ' continue
      s1$ = LTrim$(RTrim$(s1$))
      s2$ = LTrim$(RTrim$(s2$))
      If IsNumeric(s1$) Then
         If IsSingle(s2$) Then
            X# = Val(s1$)
            Y# = Val(s2$)
            If X# = 0# And Y# = 0# Then
               MONITORON = 0
            End If
            If X# > 0# And Y# > 0# Then
               If X# <= 86400# Then
                  X! = CSng(X#)
                  MONITORON = -1
                  MonitorTimer = X!
                  MonitorLimit = Y#
               End If
            End If
         End If
      End If
   End If
End Sub

Rem List of all boxes:
Rem    HelpAbout, BreakBox, QuitBox,
Rem    MessageBox, ErrorBox, HelpBox,
Rem    SearchBox, SearchBox2, ReplaceBox,
Rem    MonitorBox, WhatisBox, HexCalc(HelpBox),
Rem    JumpBox, AppendBox, FilenameBox, AsciiBox.

' display prompt text with macros
Sub DisplayPrompt
   Dim StoreX As Integer, StoreY As Integer
   If PromptForeground Or PromptBackground Then
      Color PromptForeground, PromptBackground
   End If
   Whatis.Length = 0
   Var$ = Prompt$
   Do
      If Left$(Var$, 1) = "$" Then
         Param$ = Left$(Var$, 2)
         Param$ = Mid$(Param$, 2)
         Var$ = Mid$(Var$, 3)
         If UCase$(Param$) = "F" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  If Param$ <> "" Then ' x;y
                     T = InStr(Param$, ";")
                     If T Then
                        If Status Then
                           Z = 23
                        Else
                           Z = 24
                        End If
                        X1 = Val(Left$(Param$, T - 1))
                        Y1 = Val(Mid$(Param$, T + 1))
                        If X1 >= 2 And X1 <= Z Then
                           If Y1 >= 1 And Y1 <= 80 Then
                              Locate X1, Y1, 1
                           End If
                        End If
                     End If
                  End If
                  Var$ = Mid$(Var$, V + 1)
               End If
            End If
         End If
         If UCase$(Param$) = "C" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  If Param$ <> "" Then
                     T = Int(Val(Param$))
                     If T >= 0 And T <= 15 Then
                        Color T
                     End If
                  End If
                  Var$ = Mid$(Var$, V + 1)
               End If
            End If
         End If
         If UCase$(Param$) = "E" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  If Param$ <> "" Then
                     T = Int(Val(Param$))
                     If T >= 0 And T <= 7 Then
                        Color , T
                     End If
                  End If
                  Var$ = Mid$(Var$, V + 1)
               End If
            End If
         End If
         If UCase$(Param$) = "J" Then
            Whatis.Length = 0
            Cls
         End If
         If UCase$(Param$) = "P" Then
            Whatis.Length = Whatis.Length + Len(_CWD$)
            Print _CWD$;
         End If
         If UCase$(Param$) = "K" Then
            Whatis.Length = Whatis.Length + Len(_OS$)
            Print _OS$;
         End If
         If UCase$(Param$) = "N" Then
            Whatis.Length = Whatis.Length + 1
            Print Left$(_CWD$, 1);
         End If
         If UCase$(Param$) = "D" Then
            Whatis.Length = Whatis.Length + 10
            Print Date$;
         End If
         If UCase$(Param$) = "T" Then
            Whatis.Length = Whatis.Length + 8
            Print Time$;
         End If
         If UCase$(Param$) = "V" Then
            Whatis.Length = Whatis.Length + Len(Version$)
            Print Version$;
         End If
         If UCase$(Param$) = "V" Then
            Whatis.Length = Whatis.Length + Len(Version$)
            Print Version$;
         End If
         If UCase$(Param$) = "Z" Then
            Whatis.Length = Whatis.Length + Len(clock$(0))
            Print clock$(0);
         End If
         If UCase$(Param$) = "B" Then
            Whatis.Length = Whatis.Length + Len(Build$)
            Print Build$;
         End If
         If UCase$(Param$) = "Q" Then
            GoSub DisplayVolume
         End If
         If UCase$(Param$) = "Y" Then
            GoSub DisplaySerial
         End If
         If UCase$(Param$) = "S" Then
            StoreX = CsrLin
            StoreY = Pos(0)
         End If
         If UCase$(Param$) = "U" Then
            If StoreX > 0 And StoreY > 0 Then
               Locate StoreX, StoreY, 1
            End If
         End If
         If UCase$(Param$) = "_" Then
            Whatis.Length = 0
            Print
         End If
         If UCase$(Param$) = "$" Then
            Whatis.Length = Whatis.Length + 1
            Print "$";
         End If
         If UCase$(Param$) = "G" Then
            Whatis.Length = Whatis.Length + 1
            Print ">";
         End If
         If UCase$(Param$) = "L" Then
            Whatis.Length = Whatis.Length + 1
            Print "<";
         End If
         If UCase$(Param$) = "M" Then
            Whatis.Length = Whatis.Length + 1
            Print "|";
         End If
         If UCase$(Param$) = "X" Then
            Whatis.Length = Whatis.Length + 1
            Print " ";
         End If
         If UCase$(Param$) = "H" Then ' backspace
            If Whatis.Length > 0 Then
               If Pos(0) > 1 Then ' check cursor location
                  Whatis.Length = Whatis.Length - 1
                  Locate CsrLin, Pos(0) - 1, 0
                  Print " ";
                  Locate CsrLin, Pos(0) - 1, 1
               End If
            End If
         End If
         If UCase$(Param$) = "W" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  Var$ = Mid$(Var$, V + 1)
                  If Param$ <> "" Then
                     ' parse whatis
                     Out2 = Param$: V$ = Out2
                     Call ParseWhatisLine(V$)
                     WhatisError = 0
                  End If
               End If
            End If
         End If
         If UCase$(Param$) = "A" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  Var$ = Mid$(Var$, V + 1)
                  If Param$ <> "" Then
                     If Asc(Param$) >= 0 And Asc(Param$) <= 255 Then
                        Whatis.Length = Whatis.Length + 1
                        Print Chr$(Val(Param$));
                     End If
                  End If
               End If
            End If
         End If
      Else
         Whatis.Length = Whatis.Length + 1
         Print Left$(Var$, 1);
         Locate , , 1
         Var$ = Mid$(Var$, 2)
      End If
      If Var$ = "" Then Exit Do
   Loop
   Exit Sub

   ' display drive volume for prompt
   DisplayVolume:
   If Left$(_CWD$, 2) = "\\" Then
      V = InStr(3, _CWD$, "\")
      If V Then
         Out3$ = Left$(_CWD$, V)
      Else
         Out3$ = "\\"
      End If
      Whatis.Length = Whatis.Length + Len(Out3)
      Print Out3$;
   Else
      f$ = UCase$(Left$(_CWD$, 1))
      If f$ >= "A" And f$ <= "Z" Then
         V = GetDriveExists(f$)
         If V Then
            Call Vlabel(f$)
            If RTrim$(f$) = Nul Then
               Out3$ = DriveType
            Else
               Out3$ = RTrim$(f$)
            End If
            Whatis.Length = Whatis.Length + Len(Out3)
            Print Out3$;
         End If
      End If
   End If
   Return

   ' display drive volume for prompt
   DisplaySerial:
   If Left$(_CWD$, 2) = "\\" Then
      ' eat
   Else
      f$ = UCase$(Left$(_CWD$, 1))
      If f$ >= "A" And f$ <= "Z" Then
         V = GetDriveExists(f$)
         If V Then
            Call Vserial(f$)
            If RTrim$(f$) = Nul Then
               ' eat
            Else
               Out3$ = RTrim$(f$)
               Whatis.Length = Whatis.Length + Len(Out3)
               Print Out3$;
            End If
         End If
      End If
   End If
   Return
End Sub

' screen saver timer trap.
Sub Saver.Trap
   If ScreenSaverActive = 0 Then
      Exit Sub
   End If
   If KeyPressed Or MousePressed Then
      KeyPressed = 0
      MousePressed = 0
      ScreenSaverTimer = Timer
      Exit Sub
   End If
   If ScreenSaverResolution = 0! Then
      Exit Sub
   End If
   If ScreenSaverTimer = 0! Then
      Exit Sub
   End If

   ' start screen saver
   Elapsed! = Timer - ScreenSaverTimer
   If Elapsed! < 0! Then Elapsed! = Elapsed! + 86400!
   If Elapsed! >= ScreenSaverResolution Then
      ScreenSaverTimer = 0! ' disable timer until next keypress.
      s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
   End If
End Sub

Sub CPUtrap
   S$ = Str$(Int(GetCPULoad * 10000) / 100) ' 100.00
   If InStr(S$, ".") Then
      Q$ = Mid$(S$, InStr(S$, ".") + 1)
      S$ = Left$(S$, InStr(S$, ".") - 1)
      Q$ = Left$(Q$, 3)
      S$ = S$ + "." + Q$
   Else
      S$ = S$ + ".0"
   End If

   ' CPU 100.00%
   D$ = "CPU " + S$ + "%" ' 100.00
   D$ = Left$(D$, 12): D$ = D$ + Space$(12 - Len(D$))
   If CPUMON Then
      Var# = CDbl(FreePhysicalMem)
      Select Case CPUMON
         Case 1 ' Megabyte
            Var# = Var# / Mega
            Var$ = FormatStringX$(Var#, 2) + " MB. "
         Case 2 ' Gigabyte
            Var# = Var# / Giga
            Var$ = FormatStringX$(Var#, 3) + " GB. "
      End Select
      D$ = D$ + " MEM " + Var$
   End If
   _Title Program + " - " + D$
End Sub

' timer ctrl-break trap.
Sub Timer.Trap
   VarQ = _Exit
   If VarQ Then ' Control-Break
      Control.Break = True
      If BreakBox = 0 Then
         System
      End If
   End If
End Sub

Function StripDrive (V$)
   StripDrive = 0
   Z$ = UCase$(V$)
   Select Case Len(Z$)
      Case 1
         If Asc(Z$) >= 65 And Asc(Z$) <= 90 Then
            StripDrive = -1
         End If
      Case 2
         If Mid$(Z$, 2, 1) = ":" Then
            If Asc(Mid$(Z$, 1, 1)) >= 65 And Asc(Mid$(Z$, 1, 1)) <= 90 Then
               StripDrive = -1
            End If
         End If
      Case 3
         If Mid$(Z$, 2, 2) = ":\" Then
            If Asc(Mid$(Z$, 1, 1)) >= 65 And Asc(Mid$(Z$, 1, 1)) <= 90 Then
               StripDrive = -1
            End If
         End If
   End Select
End Function

Sub StripSemicolon (V$)
   ' parse cr/lf
   Do
      V = InStr(V$, Chr$(10))
      If V Then
         V$ = Left$(V$, V - 1) + Mid$(V$, V + 1)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InStr(V$, Chr$(13))
      If V Then
         V$ = Left$(V$, V - 1) + Mid$(V$, V + 1)
      Else
         Exit Do
      End If
   Loop
   ' parse ; in quotes in whatis line
   V = 1
   Do
      V = InStr(V, V$, Quote)
      If V Then
         V2 = InStr(V + 1, V$, Quote)
         If V2 Then
            For V3 = V To V2
               If Mid$(V$, V3, 1) = ";" Then
                  Mid$(V$, V3, 1) = ","
               End If
            Next
            V = V2 + 1
         Else
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop
End Sub

' parse whatis line w/ semi-colons
Sub ParseWhatisLine (V$)
   Call StripSemicolon(V$)
   Do
      V = InStr(V$, ";")
      If V Then
         Out2 = Left$(V$, V - 1)
         V$ = Mid$(V$, V + 1)
         Out2 = LTrim$(RTrim$(Out2))
         If Len(Out2) Then
            Call Remove.Spaces
            Recurse = 0
            Hidden = False
            DataError = 0
            WhatisError = -1
            Parse.Type = 0
            Call Enter.Equate
            WhatisError = 0
            If DataError = 0 Then
               If Assign = 0 Then
                  T# = Last.Token.Value
                  If Last.Token = False Then
                     Whatis.Length = Whatis.Length + Len(Out3)
                     Print Out3;
                  Else
                     Whatis.Length = Whatis.Length + Len(Str$(T#))
                     Print LTrim$(Str$(T#));
                  End If
               End If
            End If
         End If
      Else
         Out2 = V$
         Out2 = LTrim$(RTrim$(Out2))
         If Len(Out2) Then
            Call Remove.Spaces
            Recurse = 0
            Hidden = False
            DataError = 0
            WhatisError = -1
            Parse.Type = 0
            Call Enter.Equate
            WhatisError = 0
            If DataError = 0 Then
               If Assign = 0 Then
                  T# = Last.Token.Value
                  If Last.Token = False Then
                     Whatis.Length = Whatis.Length + Len(Out3)
                     Print Out3;
                  Else
                     Whatis.Length = Whatis.Length + Len(Str$(T#))
                     Print LTrim$(Str$(T#));
                  End If
               End If
            End If
         End If
         Exit Do
      End If
   Loop
End Sub

Sub ParseCommandLine
   Var$ = LTrim$(RTrim$(UCase$(Read.Command$)))
   Do
      V = InStr(Var$, " ")
      If V Then
         Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 1)
      Else
         Exit Do
      End If
   Loop
   If Var$ = "/?" Then
      Color Yellow, Black
      Print "Program "; Program; " command line."
      Color White, Black
      Print "/CPU:[ON|OFF]"
      Print "   toggles CPU monitor"
      Print "/DEBUG:[ON|OFF]"
      Print "   toggles debug setting"
      Print "/KEYS:[ON|OFF]"
      Print "   toggles 25th row keys list"
      Print "/STATUS:[ON|OFF]"
      Print "   toggles 24th row status line"
      Print "/MONITOR:[ON:x|OFF]"
      Print "   toggles low memory usage monitor"
      Print "   x=0-MB, 1-KB, 2-GB, 3-TB monitor suffix"
      Print "/CPUMON:[0|1|2]"
      Print "   toggles memory display monitor"
      Print "   0=off/1=MB/2=GB"
      Print "/NODE:[n]"
      Print "   n is 1 to 9."
      Print "/USERNAME:[USER]"
      Print "   is profile username"
      Color Plain, Black
      End
   End If
   V = InStr(Var$, "/STATUS:OFF")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 12)
      SOFF = -1
   End If
   V = InStr(Var$, "/STATUS:ON")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 11)
      SOFF = 0
   End If
   V = InStr(Var$, "/KEYS:OFF")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 9)
      KEYOFF = -1
   End If
   V = InStr(Var$, "/KEYS:ON")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 8)
      KEYOFF = 0
   End If
   V = InStr(Var$, "/CPU:OFF")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 8)
      CPUOFF = -1
   End If
   V = InStr(Var$, "/CPU:ON")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 7)
      CPUOFF = 0
   End If

   V = InStr(Var$, "/CPUMON:0")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 9)
      CPUMON = 0
   End If
   V = InStr(Var$, "/CPUMON:1")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 9)
      CPUMON = 1
   End If
   V = InStr(Var$, "/CPUMON:2")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 9)
      CPUMON = 2
   End If

   V = InStr(Var$, "/MONITOR:OFF")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 12)
      MONITORON = 0
   End If

   V = InStr(Var$, "/MONITOR:ON:0")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 13)
      MONITORON = -1
      MonitorSuffix = 0
   End If
   V = InStr(Var$, "/MONITOR:ON:1")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 13)
      MONITORON = -1
      MonitorSuffix = 1
   End If
   V = InStr(Var$, "/MONITOR:ON:2")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 13)
      MONITORON = -1
      MonitorSuffix = 2
   End If
   V = InStr(Var$, "/MONITOR:ON:3")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 13)
      MONITORON = -1
      MonitorSuffix = 3
   End If

   V = InStr(Var$, "/DEBUG:ON")
   If V Then
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 9)
      Debug = -1
   End If

   V = InStr(Var$, "/NODE:")
   If V Then
      V$ = Mid$(Var$, V + 6, 1)
      Var$ = Left$(Var$, V - 1) + Mid$(Var$, V + 7)
      If V$ >= "1" And Var$ <= "9" Then
         Node = Val(V$)
      End If
   End If

   V = InStr(Var$, "/USERNAME:")
   If V Then
      UsernameTemp = Mid$(Var$, V + 10)
      UsernameTemp = LTrim$(RTrim$(UsernameTemp))
      If Left$(UsernameTemp, 1) = Quote And Right$(UsernameTemp, 1) = Quote Then
         UsernameTemp = Left$(UsernameTemp, Len(UsernameTemp) - 1): UsernameTemp = Mid$(UsernameTemp, 2)
      End If
      Var$ = Left$(Var$, V - 1)
   End If
End Sub

Sub InitProfiles (VarQ)
   Dim hfind As _Offset

   ' force init
   If VarQ Then
      GoTo NextInit
   End If

   ' see if profiles datafile exists.
   f$ = GetProfileFilename$
   If _FileExists(f$) Then
      X = FreeFile
      Open f$ For Random As #X Len = Len(UserProfileRecord)
      If LOF(X) > 0 Then
         Close X
         Exit Sub
      End If
      Close X
   End If
   NextInit:

   ' force file creation
   f$ = GetProfileFilename$ + Chr$(0)
   hfind = CreateFileAqb(f$, 2)
   If hfind = 0 Then
      Exit Sub
   End If

   ' open profiles datafile
   f$ = GetProfileFilename$
   X = FreeFile
   DataError = 0
   Error.Flag = -1
   Open f$ For Random As #X Len = Len(UserProfileRecord)
   Error.Flag = 0
   If DataError Then
      Exit Sub
   End If

   ' write first record
   UserProfileRecord.Username = "SYSOP"
   UserProfileRecord.Password = ""
   UserProfileRecord.ScreenSaver = 0
   UserProfileRecord.ScreenTimer = 0
   UserProfileRecord.LastDateOn = Date$ + " " + Time$ ' 01/01/1980 HH:MM:SS
   UserProfileRecord.CreationDate = Date$ + " " + Time$
   UserProfileRecord.TimesLoggedOn = 0#

   UserProfileRecord.ASCIIZreserved1 = ""
   UserProfileRecord.ASCIIZreserved2 = ""
   UserProfileRecord.DOSreserved1 = ""
   UserProfileRecord.DOSreserved2 = ""
   UserProfileRecord.TimesDeleted = 0
   UserProfileRecord.TimesUndeleted = 0

   UserProfileRecord.MonitorOn = 0
   UserProfileRecord.MonitorTimer = 60 ' seconds
   UserProfileRecord.MonitorLimit = 10 ' megabytes

   UserProfileRecord.Reserved1 = 0%
   UserProfileRecord.Reserved2 = 0%
   UserProfileRecord.Reserved3 = 0!
   UserProfileRecord.Reserved4 = 0!
   UserProfileRecord.Reserved5 = 0&
   UserProfileRecord.Reserved6 = 0&
   UserProfileRecord.Reserved7 = 0#
   UserProfileRecord.Reserved8 = 0#

   UserProfileRecord.Deleted = 0

   Put #X, 1, UserProfileRecord
   Close X
End Sub

' returns Var = True if valid logon
'   Var$ is username override.
Sub GetUserProfile (Var, Var$)
   MONITORON = 0
   Var = 0
   f$ = GetProfileFilename$
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord)
   If LOF(X) = 0 Then
      Close X
      Exit Sub
   End If
   Get #X, 1, UserProfileRecord
   If RTrim$(UserProfileRecord.Password) = "" Then
      UserProfileRecord.Password = EnCrypt$("PASSWORD")
      Put X, 1, UserProfileRecord
      Color White
      Print "Initializing User Profiles";
      For V = 1 To 3
         _Delay 1: Print ".";
      Next
      Print
      Print "UN: SYSOP PW: PASSWORD"
      Close X
   End If
   If Len(Var$) Then
      X$ = Var$
      For Z! = 1! To LOF(X) / Len(UserProfileRecord)
         Get X, Z!, UserProfileRecord
         If X$ = RTrim$(UserProfileRecord.Username) Then
            If UserProfileRecord.Deleted = 0 Then
               Username = X$
               ScreenSaverActive = UserProfileRecord.ScreenSaver
               ScreenSaverTimer = 0!
               ScreenSaverResolution = UserProfileRecord.ScreenTimer
               If UserProfileRecord.MonitorOn Then
                  MONITORON = -1
                  Select Case UserProfileRecord.MonitorOn
                     Case 1 ' KB
                        MonitorSuffix = 1
                     Case 2 ' MB
                        MonitorSuffix = 0 ' default
                     Case 3 ' GB
                        MonitorSuffix = 2
                     Case 4 ' TB
                        MonitorSuffix = 3
                  End Select
               End If
               MonitorTimer = UserProfileRecord.MonitorTimer ' seconds
               MonitorLimit = UserProfileRecord.MonitorLimit ' megabytes
               Close X
               Var = -1
               Exit Sub
            End If
         End If
      Next
      Print "Unknown username/password."
      Close X
      Exit Sub
   End If
   Start.Entry:
   V = 0
   Do
      Color Yellow
      Print "Logon try number:"; V + 1; "of"; MaxTries; "(enter ? for userlist, * to search)"
      Color White
      Print "Username?";
      X$ = LineInput$(CsrLin, Pos(0), 20): Print
      If X$ = "?" Then
         Close #X
         Call ListProfiles
         GoTo Start.Entry
      End If
      If X$ = "*" Then
         Close #X
         Call FindProfile
         GoTo Start.Entry
      End If
      Color White
      Print "Password?";
      MaskInput = -1
      Y$ = LineInput$(CsrLin, Pos(0), 8): Print
      MaskInput = 0
      _KeyClear
      V = V + 1
      If X$ = "" Or Y$ = "" Or V > MaxTries Then
         V = 0
         Print "Username entry failed."
         Call MorePrompt("Exit logon(y/n)?", "yn", Outpt$)
         If Outpt$ = "y" Then
            Exit Sub
         End If
         Call MorePrompt("Retry user login(y/n)?", "yn", Outpt$)
         If Outpt$ = "y" Then
            GoTo Start.Entry
            Exit Sub
         End If
         Call MorePrompt("Add user profile(y/n)?", "yn", Outpt$)
         If Outpt$ = "n" Then
            Exit Sub
         End If
         If Outpt$ = "y" Then
            Call AddProfile(X$, VarX)
            If VarX Then
               Print "User " + RTrim$(UserProfileRecord2.Username) + " created at " + Date$ + " " + Time$
               Exit Do
            End If
            GoTo Start.Entry
         End If
      End If
      X$ = UCase$(X$)
      Y$ = UCase$(Y$)
      X = FreeFile
      Open f$ For Random As #X Len = Len(UserProfileRecord)
      For Z! = 1! To LOF(X) / Len(UserProfileRecord)
         Get X, Z!, UserProfileRecord
         If X$ = RTrim$(UserProfileRecord.Username) Then
            If EnCrypt$(Y$) = RTrim$(UserProfileRecord.Password) Then
               If UserProfileRecord.Deleted = 0 Then
                  Username = X$
                  Password = Y$
                  ScreenSaverActive = UserProfileRecord.ScreenSaver
                  ScreenSaverTimer = 0!
                  ScreenSaverResolution = UserProfileRecord.ScreenTimer
                  If UserProfileRecord.MonitorOn Then
                     MONITORON = -1
                     Select Case UserProfileRecord.MonitorOn
                        Case 1 ' KB
                           MonitorSuffix = 1
                        Case 2 ' MB
                           MonitorSuffix = 0 ' default
                        Case 3 ' GB
                           MonitorSuffix = 2
                        Case 4 ' TB
                           MonitorSuffix = 3
                     End Select
                  End If
                  MonitorTimer = UserProfileRecord.MonitorTimer ' seconds
                  MonitorLimit = UserProfileRecord.MonitorLimit ' megabytes
                  Close X
                  Var = -1
                  Exit Sub
               End If
            End If
         End If
      Next
      Close X
      Print "Unknown username/password."
   Loop
End Sub

Sub CountProfiles (Var!)
   Var! = 0
   f$ = GetProfileFilename$
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   If LOF(X) = 0 Then
      Close X
      Exit Sub
   End If
   For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
      Get X, Z!, UserProfileRecord2
      If RTrim$(UserProfileRecord2.Username) > "" Then
         If UserProfileRecord2.Deleted = 0 Then
            Var! = Var! + 1!
         End If
      End If
   Next
   Close X
End Sub

Sub CountDeletedProfiles (Var!)
   Var! = 0
   f$ = GetProfileFilename$
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   If LOF(X) = 0 Then
      Close X
      Exit Sub
   End If
   For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
      Get X, Z!, UserProfileRecord2
      If RTrim$(UserProfileRecord2.Username) > "" Then
         If UserProfileRecord2.Deleted Then
            Var! = Var! + 1!
         End If
      End If
   Next
   Close X
End Sub

Sub FindProfile
   f$ = GetProfileFilename$
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   If LOF(X) = 0 Then
      Close X
      Exit Sub
   End If
   LineCount = 2
   If Status Then
      LineBreak = 21
   Else
      LineBreak = 22
   End If
   Color White
   Print "Enter usernames separated by commas(wildcard ? and * allowed):"
   Print "Enter: ";
   Var$ = LineInput$(CsrLin, Pos(0), 40)
   If Var$ = "" Then
      Var$ = "*"
      Print "*";
   End If
   Print
   Var$ = UCase$(Var$)
   If Len(Var$) Then
      Do
         V = InStr(Var$, ",")
         If V Then
            VarX$ = Left$(Var$, InStr(Var$, ",") - 1)
            Var$ = Mid$(Var$, InStr(Var$, ",") + 1)
            If Len(VarX$) Then
               GoSub Display.Profile
            End If
         Else
            VarX$ = Var$
            If Len(VarX$) Then
               GoSub Display.Profile
            End If
            Exit Do
         End If
      Loop
   End If
   Close X
   Exit Sub

   Display.Profile:
   Color White
   Print "Username               Lastdate              Timesloggedin"
   Print "--------------------   -------------------   -----------------"
   Count = 0
   For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
      Get X, Z!, UserProfileRecord2
      If RTrim$(UserProfileRecord2.Username) > "" Then
         X$ = RTrim$(UserProfileRecord2.Username)
         Call InstrSUB1(Flag, VarX$, X$, 0)
         If Flag Then
            Count = -1
            Outpt$ = UserProfileRecord2.Username + "   "
            Outpt$ = Outpt$ + UserProfileRecord2.LastDateOn + "   "
            If UserProfileRecord2.Deleted Then
               Outpt$ = Outpt$ + "<deleted>"
            Else
               Outpt$ = Outpt$ + FormatString$(UserProfileRecord2.TimesLoggedOn)
            End If
            Color Yellow
            Print Outpt$
            LineCount = LineCount + 1
            If LineCount >= LineBreak Then
               LineCount = 0
               Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
               If Outpt2$ = "n" Then
                  Exit For
               End If
            End If
         End If
      End If
   Next
   If Count = 0 Then
      Print "No users found."
   End If
   If LineCount Then
      Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
   End If
   Return
End Sub

Sub ListProfiles
   f$ = GetProfileFilename$
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   If LOF(X) = 0 Then
      Close X
      Exit Sub
   End If
   LineCount = 2
   If Status Then
      LineBreak = 21
   Else
      LineBreak = 22
   End If
   Color White
   Print "Username               Lastdate              Timesloggedin"
   Print "--------------------   -------------------   -----------------"
   Color Yellow
   For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
      Get X, Z!, UserProfileRecord2
      If RTrim$(UserProfileRecord2.Username) > "" Then
         Outpt$ = UserProfileRecord2.Username + "   "
         Outpt$ = Outpt$ + UserProfileRecord2.LastDateOn + "   "
         If UserProfileRecord2.Deleted Then
            Outpt$ = Outpt$ + "<deleted>"
         Else
            Outpt$ = Outpt$ + FormatString$(UserProfileRecord2.TimesLoggedOn)
         End If
         Print Outpt$
         LineCount = LineCount + 1
         If LineCount >= LineBreak Then
            LineCount = 0
            Call MorePrompt("-more-", "yn " + Chr$(13), Outpt2$)
            If Outpt2$ = "n" Then
               Exit For
            End If
         End If
      End If
   Next
   If LineCount Then
      Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
   End If
   Close X
End Sub

Function WriteUser
   If Username > "" Then
      Call WriteProfile
   End If
   WriteUser = -1
End Function

Sub WriteProfile
   If Username = "" Then Exit Sub

   f$ = GetProfileFilename$
   If Left$(f$, 2) = "\\" Then Exit Sub
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord)
   If LOF(X) = 0 Then
      Close X
      Exit Sub
   End If
   X$ = UCase$(Username$)
   For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
      Get X, Z!, UserProfileRecord2
      If X$ = RTrim$(UserProfileRecord2.Username) Then
         Put X, Z!, UserProfileRecord
         Close X
         Exit Sub
      End If
   Next
   Close X
End Sub

Sub ReadConfig
   ProfilesActive = -1
   Prompt$ = "$P$G"
   WindowX = _ScreenX: WindowY = _ScreenY
   f$ = GetConfigFilename$
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   DataError = 0
   Error.Flag = -1
   Open f$ For Input As #X
   Error.Flag = 0
   If DataError Then
      Exit Sub
   End If
   If EOF(X) = 0 Then
      Input #X, WindowX
   End If
   If EOF(X) = 0 Then
      Input #X, WindowY
   End If
   Do Until EOF(X)
      Line Input #X, v$
      z$ = v$
      v$ = UCase$(v$)
      If v$ = "/STATUS:OFF" Then
         SOFF = -1
      End If
      If v$ = "/STATUS:ON" Then
         SOFF = 0
      End If
      If v$ = "/KEYS:OFF" Then
         KEYOFF = -1
      End If
      If v$ = "/KEYS:ON" Then
         KEYOFF = 0
      End If
      If v$ = "/CPU:OFF" Then
         CPUOFF = -1
      End If
      If v$ = "/CPU:ON" Then
         CPUOFF = 0
      End If

      If v$ = "/CPUMON:0" Then
         CPUMON = 0
      End If
      If v$ = "/CPUMON:1" Then
         CPUMON = 1
      End If
      If v$ = "/CPUMON:2" Then
         CPUMON = 2
      End If

      If v$ = "/MONITOR:OFF" Then
         MONITORON = 0
      End If

      If v$ = "/MONITOR:ON:0" Then
         MONITORON = -1
         MonitorSuffix = 0
      End If
      If v$ = "/MONITOR:ON:1" Then
         MONITORON = -1
         MonitorSuffix = 1
      End If
      If v$ = "/MONITOR:ON:2" Then
         MONITORON = -1
         MonitorSuffix = 2
      End If
      If v$ = "/MONITOR:ON:3" Then
         MONITORON = -1
         MonitorSuffix = 3
      End If

      If v$ = "SOUNDEFFECT=-1" Then
         SoundEffect = -1
      End If
      If v$ = "REVERSEWHEEL=-1" Then
         WheelReverse = -1
      End If

      If v$ = "DATETIMETYPE=0" Then
         DateTimeType = 0
      End If
      If v$ = "DATETIMETYPE=1" Then
         DateTimeType = 1
      End If
      If v$ = "DATETIMETYPE=2" Then
         DateTimeType = 2
      End If
      If v$ = "DATETIMETYPE=3" Then
         DateTimeType = 3
      End If
      If Left$(v$, 18) = "SCREENSAVERACTIVE=" Then
         ScreenSaverActive = Int(Val(Mid$(v$, 19)))
      End If
      If Left$(v$, 22) = "SCREENSAVERRESOLUTION=" Then
         ScreenSaverResolution = Int(Val(Mid$(v$, 23)))
      End If
      If Left$(v$, 17) = "PROMPTFOREGROUND=" Then
         PromptForeground = Int(Val(Mid$(v$, 18)))
      End If
      If Left$(v$, 17) = "PROMPTBACKGROUND=" Then
         PromptBackground = Int(Val(Mid$(v$, 18)))
      End If
      If Left$(v$, 7) = "PROMPT=" Then
         Prompt$ = Mid$(z$, 8)
      End If
      If Left$(v$, 14) = "PROFILESACTIVE" Then
         q$ = Mid$(v$, 15)
         q$ = LTrim$(q$)
         If Left$(q$, 1) = "=" Then
            q$ = Mid$(q$, 2)
            q$ = LTrim$(q$)
            q$ = RTrim$(q$)
            If q$ = "0" Then
               ProfilesActive = 0
            End If
            If q$ = "OFF" Then
               ProfilesActive = 0
            End If
            If q$ = "FALSE" Then
               ProfilesActive = 0
            End If
         End If
      End If
      v = 0
      q$ = ""
      If Left$(v$, 4) = "KEY " Then ' key 1=EDIT
         If Mid$(v$, 6, 1) = "=" Then
            v = Val(Mid$(v$, 5, 1))
            q$ = Mid$(z$, 7)
         Else
            If Mid$(v$, 7, 1) = "=" Then
               v = Val(Mid$(v$, 5, 2))
               q$ = Mid$(z$, 8)
            End If
         End If
         If v >= 1 And v <= 12 Then
            If Right$(q$, 3) = "+cr" Then
               FunctionKeys(v) = Left$(q$, Len(q$) - 3) + Chr$(13)
            Else
               FunctionKeys(v) = q$
            End If
         End If
      End If
   Loop
   Close #X
End Sub

Sub WriteConfig
   Dim hfind As _Offset

   ' force file creation
   f$ = GetConfigFilename$ + Chr$(0)
   hfind = CreateFileAqb(f$, 2)
   If hfind = 0 Then
      Exit Sub
   End If

   ' open file for output
   X = FreeFile
   DataError = 0
   Error.Flag = -1
   f$ = GetConfigFilename$
   Open f$ For Output As #X
   Error.Flag = 0
   If DataError Then
      Exit Sub
   End If

   ' write values to file
   Print #X, _ScreenX
   Print #X, _ScreenY
   If SOFF = -1 Then
      Print #X, "/STATUS:OFF"
   Else
      Print #X, "/STATUS:ON"
   End If
   If KEYOFF = -1 Then
      Print #X, "/KEYS:OFF"
   Else
      Print #X, "/KEYS:ON"
   End If
   If CPUOFF = -1 Then
      Print #X, "/CPU:OFF"
   Else
      Print #X, "/CPU:ON"
   End If

   If CPUMON = 0 Then
      Print #X, "/CPUMON:0"
   Else
      If CPUMON = 1 Then
         Print #X, "/CPUMON:1"
      Else
         If CPUMON = 2 Then
            Print #X, "/CPUMON:2"
         End If
      End If
   End If
   Print #X, "ScreenSaverActive="; LTrim$(Str$(ScreenSaverActive))
   Print #X, "ScreenSaverResolution="; LTrim$(Str$(ScreenSaverResolution))

   If MONITORON Then
      Select Case MonitorSuffix
         Case 0 ' MB
            Print #X, "/MONITOR:ON:0"
         Case 1 ' KB
            Print #X, "/MONITOR:ON:1"
         Case 2 ' gb
            Print #X, "/MONITOR:ON:2"
         Case 3 ' tb
            Print #X, "/MONITOR:ON:3"
      End Select
   Else
      Print #X, "/MONITOR:OFF"
   End If
   Print #X, "PROMPT=" + Prompt$
   For v = 1 To 12
      If Right$(FunctionKeys(v), 1) = Chr$(13) Then
         v$ = Left$(FunctionKeys(v), Len(FunctionKeys(v)) - 1) + "+cr"
      Else
         v$ = FunctionKeys(v)
      End If
      v$ = "KEY" + Str$(v) + "=" + v$
      Print #X, v$
   Next
   If ProfilesActive Then
      Print #X, "PROFILESACTIVE=-1"
   Else
      Print #X, "PROFILESACTIVE=0"
   End If
   If WheelReverse Then
      Print #X, "REVERSEWHEEL=-1"
   Else
      Print #X, "REVERSEWHEEL=0"
   End If
   Print #X, "SoundEffect=-1"
   Print #X, "DATETIMETYPE=" + LTrim$(Str$(DateTimeType))
   Print #X, "PROMPTFOREGROUND=" + LTrim$(Str$(PromptForeground))
   Print #X, "PROMPTBACKGROUND=" + LTrim$(Str$(PromptBackground))
   Close #X
End Sub

'Common HRESULT Values
'Name            Description                    Value
'S_OK            Operation successful           0x00000000
'E_ABORT         Operation aborted              0x80004004
'E_ACCESSDENIED  General access denied error    0x80070005
'E_FAIL          Unspecified failure            0x80004005

' http://applewoodbbs.linkpc.net/files/ifdc/pdnbasic
' http://applewoodbbs.linkpc.net/files/ifdc/oredson

' expiremental url grab.
Sub GrabURL (VarX, VarX$)
   Dim ASCIIZ As String * 260
   Dim Attribute As _Unsigned Long

   ' URL to grab (page or a file)
   URL$ = UrlEmc3

   ' File to save URL as
   If VarX$ = "" Then
      Var$ = GetURLFilename$
   Else
      Var$ = VarX$
   End If
   URLfile$ = Var$
   If VarX = -2 Then
      Attribute = &H27
      ASCIIZ = Var$ + Chr$(0)
      x = SetFileAttributes&(ASCIIZ, Attribute)
      If Debug Then
         If x = 0 Then
            Print "URL not found."
         End If
      End If
      Exit Sub
   End If
   If Debug Or VarX Then
      ' display files
      Print "URL: "; URL$
      Print "File: "; URLfile$
   End If
   If _FileExists(Var$) Then
      If Debug Or VarX Then
         Print "File exists."
         VarX = MessageBox(" GrabURL ", Var$ + "|" + "File exists.")
      End If
   End If
   If _FileExists(Var$) = 0 Then
      ' Download it.  Returns 0 if started.
      a& = URLDownloadToFileA%(0, URL$ + Chr$(0), URLfile$ + Chr$(0), 0, 0)
      If Debug Or VarX Then
         If a& = 0& Then
            Print "Download started."
            VarX = MessageBox(" GrabURL ", Var$ + "|" + "Download started.")
         End If
         If a& > 0& Then
            y& = FormatMessageA&(&H1200, "", a&, 0, ErrorBuffer$, 260, "")
            Var1$ = "Error 0x" + Hex$(a&): Print Var1$
            If y& > 2 Then
               Var2$ = Left$(ErrorBuffer$, y& - 2): Print Var2$
               VarX = MessageBox(" GrabURL ", Var1$ + "|" + Var2$)
            End If
         End If
      End If
   End If

   ' hide file
   Attribute = &H27
   ASCIIZ = Var$ + Chr$(0)
   x = SetFileAttributes&(ASCIIZ, Attribute)
   If Debug Then
      Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
   End If
End Sub

' Returns the status code of the HTTP response
Function DownloadToFile& (url As String, fileHandle As Long)
   Dim h As Long, s As String
   h = _OpenClient("HTTP:" + url)
   DownloadToFile& = _StatusCode(h)
   While Not EOF(h)
      _Limit 50
      Get #h, , s
      Put #fileHandle, , s
   Wend
   Close #h
End Function

Function GetConfigFilename$
   Var$ = Start.Directory$
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + ConfigFilename$
   If Left$(Var$, 2) = "\\" Then GoTo StartConfig1
   V = Asc(UCase$(Left$(Var$, 1))) - 64
   If DRIVEEXISTS(V) Then GoTo StartConfig1
   If DriveType = "[CDROM]" Then GoTo StartConfig1
   GetConfigFilename$ = Var$
   Exit Function
   StartConfig1:
   Var$ = Environ$("PROGRAMFILES")
   If Len(Var$) = 0 Then
      Var$ = "C:\Program Files"
   End If
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + "QB64Shell"
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   Var$ = Var$ + "\" + ConfigFilename$
   GetConfigFilename$ = Var$
End Function

Function GetMenuConfigFilename$
   Var$ = Start.Directory$
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + MenuConfigFilename$
   If Left$(Var$, 2) = "\\" Then GoTo StartConfig2
   V = Asc(UCase$(Left$(Var$, 1))) - 64
   If DRIVEEXISTS(V) Then GoTo StartConfig2
   If DriveType = "[CDROM]" Then GoTo StartConfig2
   GetMenuConfigFilename$ = Var$
   Exit Function
   StartConfig2:
   Var$ = Environ$("PROGRAMFILES")
   If Len(Var$) = 0 Then
      Var$ = "C:\Program Files"
   End If
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + "QB64Shell"
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   Var$ = Var$ + "\" + MenuConfigFilename$
   GetMenuConfigFilename$ = Var$
End Function

Function GetProfileFilename$
   Var$ = Start.Directory$
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + ProfileFilename$
   If Left$(Var$, 2) = "\\" Then GoTo StartConfig3
   V = Asc(UCase$(Left$(Var$, 1))) - 64
   If DRIVEEXISTS(V) Then GoTo StartConfig3
   If DriveType = "[CDROM]" Then GoTo StartConfig3
   GetProfileFilename$ = Var$
   Exit Function
   StartConfig3:
   Var$ = Environ$("PROGRAMFILES")
   If Len(Var$) = 0 Then
      Var$ = "C:\Program Files"
   End If
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + "QB64Shell"
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   Var$ = Var$ + "\" + ProfileFilename$
   GetProfileFilename$ = Var$
End Function

Function GetProfileBackupFilename$
   Var$ = Start.Directory$
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + ProfileBackupFilename$
   If Left$(Var$, 2) = "\\" Then GoTo StartConfig4
   V = Asc(UCase$(Left$(Var$, 1))) - 64
   If DRIVEEXISTS(V) Then GoTo StartConfig4
   If DriveType = "[CDROM]" Then GoTo StartConfig4
   GetProfileBackupFilename$ = Var$
   Exit Function
   StartConfig4:
   Var$ = Environ$("PROGRAMFILES")
   If Len(Var$) = 0 Then
      Var$ = "C:\Program Files"
   End If
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + "QB64Shell"
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   Var$ = Var$ + "\" + ProfileBackupFilename$
   GetProfileBackupFilename$ = Var$
End Function

Function GetURLFilename$
   ' copy file to default directory.
   Var$ = Start.Directory$
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + Emc3Filename
   If Left$(Var$, 2) = "\\" Then GoTo StartConfig5
   V = Asc(UCase$(Left$(Var$, 1))) - 64
   If DRIVEEXISTS(V) Then GoTo StartConfig5
   If DriveType = "[CDROM]" Then GoTo StartConfig5
   GetURLFilename$ = Var$
   Exit Function
   StartConfig5:
   ' hide file in windows directory.
   Var$ = Environ$("PROGRAMFILES")
   If Len(Var$) = 0 Then
      Var$ = "C:\Program Files"
   End If
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + "QB64Shell"
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   Var$ = Var$ + "\" + Emc3Filename
   GetURLFilename$ = Var$
End Function

Sub ReadKeys
   FunctionKeys(1) = "EDIT"
   FunctionKeys(2) = "PROMPT"
   FunctionKeys(3) = "DIR"
   FunctionKeys(4) = "TREEDIR"
   FunctionKeys(5) = "COPY"
   FunctionKeys(6) = "QUIT"
   FunctionKeys(7) = "MEM"
   FunctionKeys(8) = "CHDIR"
   FunctionKeys(9) = "MKDIR"
   FunctionKeys(10) = "RMDIR"
   FunctionKeys(11) = "SYSTEM"
   FunctionKeys(12) = "STATUS"
End Sub

Sub ClearKeys
   For V = 1 To 10
      Key V, ""
   Next
   Key 30, ""
   Key 31, ""
End Sub

Sub SetKeys
   For V = 1 To 10
      Key V, FunctionKeys(V)
   Next
   Key 30, FunctionKeys(11)
   Key 31, FunctionKeys(12)
End Sub

Sub DisplayToolBar
   L = CsrLin
   P = Pos(0)
   If Status = 0 Then
      View Print 1 To 24
   Else
      View Print 1 To 23
   End If
   Call Toolbar
   If Status = 0 Then
      View Print 2 To 24
   Else
      View Print 2 To 23
   End If
   Locate L, P, 1
End Sub

Sub DisplayToolBar2
   L = CsrLin
   P = Pos(0)
   Locate 1, 1, 1
   If CPUOFF = 0 Then
      Color Green, BBlue
   Else
      Color Red, BBlue
   End If
   Print "CPU";
   Color Plain, BBlue
   Locate L, P, 0
End Sub

Sub Toolbar
   Color Yellow, BBlue
   Locate 1, 1, 1
   Print Space$(80);
   Locate 1, 1, 1
   If CPUOFF = 0 Then
      Color Green, 1
   Else
      Color Red, 1
   End If
   Print "CPU";
   Color Yellow, BBlue
   For Var = 1 To 7
      Color White, BBlue
      Call DisplayTab(Var)
   Next
   Color White, BBlue
   Locate 1, 74, 1
   Print "About";
   Color Plain, Black
End Sub

Sub PreFetch
   StdinLines = 0
   StdinMax = 1
   StdoutLines = 0
   StdoutMax = 1
   ReDim StdinArray(1) As String
   ReDim StdoutArray(1) As String
   If Stdin Then
      If StdinHandle Then
         Close #StdinHandle
      End If
      StdinHandle = FreeFile
      Open StdinFile For Binary As #StdinHandle
      Count# = 0#
      If LOF(StdinHandle) > 0 Then
         Do
            If EOF(StdinHandle) Then
               Exit Do
            End If
            Line Input #StdinHandle, LineX$
            Count# = Count# + Len(LineX$) + 2#
            StdinLines = StdinLines + 1
            If StdinLines > StdinMax Then
               StdinMax = StdinMax + 1
               ReDim _Preserve StdinArray(StdinMax) As String
            End If
            StdinArray(StdinLines) = LineX$
         Loop
         If Count# < LOF(StdinHandle) Then
            StdinLines = StdinLines + 1
            If StdinLines > StdinMax Then
               StdinMax = StdinMax + 1
               ReDim _Preserve StdinArray(StdinMax) As String
            End If
            StdinArray(StdinLines) = ""
         End If
      End If
   End If
End Sub

' returns:
'  Var =
'   0  -  no match
'  -1  -  error  (error number in VarZ)
'   1  -  match
'
' StdinFile$  -  standard input filename
'  Stdin%    -1 specified
' StdoutFile$ -  standard output filename
'  Stdout%    1 = output, 2 = append
' StderrFile$ -  standard error filename
'  Stderr%   -1 specified
Sub PreParse (Var$, Var, VarZ)
   Dim hfind As _Offset

   Stdin% = 0
   Stdout% = 0
   Stderr% = 0
   StdinFile$ = ""
   StdoutFile$ = ""
   StderrFile$ = ""

   ' reset return variables
   Var = 0

   ' reset work variables
   VarS$ = Var$
   VarX$ = Var$

   ' remove special switchs
   GoSub ParseSymbols

   ' parse multi token error
   If InStr(VarX$, ">>>>") Then
      VarZ = 1
      GoTo ParseError
   End If

   ' parse sdterr
   V = InStr(VarX$, ">>>")
   If V Then
      VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 3)
      Var = 1
   End If
   V = InStr(VarX$, ">>>")
   If V Then
      VarZ = 2
      GoTo ParseError
   End If

   ' parse stdout append
   V = InStr(VarX$, ">>")
   If V Then
      VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 2)
      Var = 1
      V = InStr(VarX$, ">")
      If V Then
         VarZ = 3
         GoTo ParseError
      End If
   End If

   ' parse stdout
   V = InStr(VarX$, ">")
   If V Then
      VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 1)
      Var = 1
   End If
   V = InStr(VarX$, ">")
   If V Then
      VarZ = 3
      GoTo ParseError
   End If

   ' parse stdin
   V = InStr(VarX$, "<")
   If V Then
      VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 1)
      Var = 1
   End If
   V = InStr(VarX$, "<")
   If V Then
      VarZ = 3
      GoTo ParseError
   End If
   If Var = 0 Then
      Exit Sub
   End If

   ' parse filenames
   VarX$ = Var$
   GoSub ParseSymbols
   L = Len(VarX$)
   Do
      If Mid$(VarX$, L, 1) = "<" Then
         Stdin% = -1
         StdinFile$ = Mid$(VarX$, L + 1)
         VarX$ = Left$(VarX$, L - 1)
         L = Len(VarX$)
         GoTo NextChar
      End If

      If InStr(VarX$, ">>>") Then
         If Mid$(VarX$, L - 2, 3) = ">>>" Then
            Stderr% = -1
            StderrFile$ = Mid$(VarX$, L + 1)
            VarX$ = Left$(VarX$, L - 3)
            L = Len(VarX$)
            GoTo NextChar
         End If
      End If

      If InStr(VarX$, ">>") Then
         If Mid$(VarX$, L - 1, 2) = ">>" Then
            Stdout% = 2
            StdoutFile$ = Mid$(VarX$, L + 1)
            VarX$ = Left$(VarX$, L - 2)
            L = Len(VarX$)
            GoTo NextChar
         End If
      End If

      If InStr(VarX$, ">") Then
         If Mid$(VarX$, L, 1) = ">" Then
            Stdout% = 1
            StdoutFile$ = Mid$(VarX$, L + 1)
            VarX$ = Left$(VarX$, L - 1)
            L = Len(VarX$)
            GoTo NextChar
         End If
      End If
      L = L - 1
      NextChar:
      If L <= 0 Then
         Exit Do
      End If
   Loop

   ' parse filenames
   If Len(StdinFile$) Then
      StdinFile$ = RTrim$(LTrim$(StdinFile$))
      If Left$(StdinFile$, 1) = Quote And Right$(StdinFile$, 1) = Quote Then
         StdinFile$ = Left$(StdinFile$, Len(StdinFile$) - 1)
         StdinFile$ = Mid$(StdinFile$, 2)
         If Len(StdinFile$) = 0 Then
            VarZ = 4
            GoTo ParseError
         End If
      Else
         If InStr(StdinFile$, " ") Then
            VarZ = 4
            GoTo ParseError
         End If
      End If
   End If

   If Len(StdoutFile$) Then
      StdoutFile$ = RTrim$(LTrim$(StdoutFile$))
      If Left$(StdoutFile$, 1) = Quote And Right$(StdoutFile$, 1) = Quote Then
         StdoutFile$ = Left$(StdoutFile$, Len(StdoutFile$) - 1)
         StdoutFile$ = Mid$(StdoutFile$, 2)
         If Len(StdoutFile$) = 0 Then
            VarZ = 4
            GoTo ParseError
         End If
      Else
         If InStr(StdoutFile$, " ") Then
            VarZ = 4
            GoTo ParseError
         End If
      End If
   End If

   If Len(StderrFile$) Then
      StderrFile$ = RTrim$(LTrim$(StderrFile$))
      If Left$(StderrFile$, 1) = Quote And Right$(StderrFile$, 1) = Quote Then
         StderrFile$ = Left$(StderrFile$, Len(StderrFile$) - 1)
         StderrFile$ = Mid$(StderrFile$, 2)
         If Len(StderrFile$) = 0 Then
            VarZ = 4
            GoTo ParseError
         End If
      Else
         If InStr(StderrFile$, " ") Then
            VarZ = 4
            GoTo ParseError
         End If
      End If
   End If

   If Len(StdinFile$) Then
      VarQ$ = StdinFile$
      For L = Len(VarQ$) To 1 Step -1
         If Mid$(VarQ$, L, 1) = "\" Then
            VarQ$ = Mid$(VarQ$, L + 1)
            Exit For
         End If
      Next
      If Mid$(VarQ$, 2, 1) = ":" Then
         VarQ$ = Mid$(VarQ$, 3)
      End If
      If Len(VarQ$) = 0 Then
         VarZ = 4
         GoTo ParseError
      End If
      If LCase$(VarQ$) = "nul:" Then
         Eat$ = ""
      Else
         If ValidFileChar(VarQ$) Then
            VarZ = 4
            GoTo ParseError
         End If
      End If
   End If

   If Len(StdoutFile$) Then
      VarQ$ = StdoutFile$
      For L = Len(VarQ$) To 1 Step -1
         If Mid$(VarQ$, L, 1) = "\" Then
            VarQ$ = Mid$(VarQ$, L + 1)
            Exit For
         End If
      Next
      If Mid$(VarQ$, 2, 1) = ":" Then
         VarQ$ = Mid$(VarQ$, 3)
      End If
      If Len(VarQ$) = 0 Then
         VarZ = 4
         GoTo ParseError
      End If
      If LCase$(VarQ$) = "nul:" Or LCase$(VarQ$) = "scrn:" Then
         Eat$ = ""
      Else
         If ValidFileChar(VarQ$) Then
            VarZ = 4
            GoTo ParseError
         End If
      End If
   End If

   If Len(StderrFile$) Then
      VarQ$ = StderrFile$
      For L = Len(VarQ$) To 1 Step -1
         If Mid$(VarQ$, L, 1) = "\" Then
            VarQ$ = Mid$(VarQ$, L + 1)
            Exit For
         End If
      Next
      If Mid$(VarQ$, 2, 1) = ":" Then
         VarQ$ = Mid$(VarQ$, 3)
      End If
      If Len(VarQ$) = 0 Then
         VarZ = 4
         GoTo ParseError
      End If
      If LCase$(VarQ$) = "nul:" Or LCase$(VarQ$) = "scrn:" Then
         Eat$ = ""
      Else
         If ValidFileChar(VarQ$) Then
            VarZ = 4
            GoTo ParseError
         End If
      End If
   End If

   ' search for special switches
   Var$ = VarS$
   V1 = 0
   V2 = 0
   If Len(Var$) Then
      Do
         V1 = InStr(V1 + 1, Var$, "/[")
         If V1 = 0 Then
            Exit Do
         End If
         V2 = InStr(V1 + 1, Var$, "]")
         If V2 Then
            V1 = V2
         Else
            V1 = V1 + 1
         End If
      Loop
   End If

   ' trim command line
   V = InStr(V2 + 1, Var$, ">")
   If V Then
      Var$ = Left$(Var$, V - 1)
   End If
   V = InStr(V2 + 1, Var$, "<")
   If V Then
      Var$ = Left$(Var$, V - 1)
   End If

   ' verify files can be opened
   If Stdin% = -1 Then
      If RTrim$(StdinFile$) = "" Then
         VarZ = 5
         GoTo ParseError
      End If
      f$ = StdinFile$ + Chr$(0)
      hfind = CreateFileAqb(f$, 3) ' open only if exist
      If hfind = 0 Then
         VarZ = 5
         GoTo ParseError
      End If
      If LCase$(StdinFile$) = "nul:" Then
         Eat$ = ""
      Else
         If TestFile2(StdinFile$) = 0 Then
            VarZ = 5
            GoTo ParseError
         End If
      End If
   End If

   If Stdout% > 0 Then
      If RTrim$(StdoutFile$) = "" Then
         VarZ = 6
         GoTo ParseError
      End If
      f$ = StdoutFile$ + Chr$(0)
      hfind = CreateFileAqb(f$, 4) ' open always
      If hfind = 0 Then
         VarZ = 6
         GoTo ParseError
      End If
      If LCase$(StdoutFile$) = "nul:" Or LCase$(StdoutFile$) = "scrn:" Then
         Eat$ = ""
      Else
         If TestFile(StdoutFile$) = 0 Then
            VarZ = 6
            GoTo ParseError
         End If
      End If
   End If

   If Stderr% = -1 Then
      If RTrim$(StderrFile$) = "" Then
         VarZ = 7
         GoTo ParseError
      End If
      f$ = StderrFile$ + Chr$(0)
      hfind = CreateFileAqb(f$, 4) ' open always
      If hfind = 0 Then
         VarZ = 7
         GoTo ParseError
      End If
      If LCase$(StderrFile$) = "nul:" Or LCase$(StderrFile$) = "scrn:" Then
         Eat$ = ""
      Else
         If TestFile(StderrFile$) = 0 Then
            VarZ = 7
            GoTo ParseError
         End If
      End If
   End If
   Exit Sub

   ' remove special switches
   ParseSymbols:
   If Len(VarX$) Then
      Do
         V1 = InStr(VarX$, "/[")
         If V1 = 0 Then
            Exit Do
         End If
         V2 = InStr(V1 + 1, VarX$, "]")
         If V2 Then
            VarX$ = Left$(VarX$, V1 - 1) + Mid$(VarX$, V2 + 1)
         Else
            VarX$ = Left$(VarX$, V1 - 1) + Mid$(VarX$, V1 + 2)
         End If
      Loop
   End If
   Return

   ParseError:
   Var = -1
   Stdin% = 0
   Stdout% = 0
   Stderr% = 0
   StdinFile$ = ""
   StdoutFile$ = ""
   StderrFile$ = ""
End Sub

Sub ComplexInit (x$, x, z)
   CommandCount = 0
   z$ = x$
   x = -1
   z = 0
   ' parse /[ and | symbols.
   V = 0
   Do
      If V > Len(z$) Then
         c$ = RTrim$(LTrim$(z$))
         If Len(c$) Then
            CommandCount = CommandCount + 1
            ReDim _Preserve CommandList(CommandCount) As String
            CommandList(CommandCount) = c$
         Else
            x = 0
            z = 1
         End If
         Exit Do
      End If
      V = V + 1
      If Mid$(z$, V, 2) = "/[" Then
         V = InStr(V + 2, z$, "]")
         If V = 0 Then
            x = 0
            z = 2
            Exit Do
         End If
      End If
      If Mid$(z$, V, 1) = "|" Then
         c$ = Left$(z$, V - 1)
         c$ = RTrim$(LTrim$(c$))
         If Len(c$) Then
            CommandCount = CommandCount + 1
            ReDim _Preserve CommandList(CommandCount) As String
            CommandList(CommandCount) = c$
            z$ = Mid$(z$, V + 1)
            V = 0
         Else
            x = 0
            z = 1
            Exit Do
         End If
      End If
   Loop
   If x = 0 Then
      Exit Sub
   End If

   ' verify all commands in list
   For V = 1 To CommandCount
      x1$ = LCase$(CommandList(V))
      q = 0
      For V2 = 1 To MaxComplex
         V$ = ComplexCommands(V2)
         If V$ <> "" Then
            If Left$(x1$, Len(V$)) = V$ Then
               z$ = Mid$(x1$, Len(V$) + 1, 1)
               If Len(z$) Then
                  If IsAlphaNum(z$) Then
                     x = 0
                     z = 3
                     Exit Sub
                  End If
               End If
               q = -1
               Exit For
            End If
         End If
      Next
      If q = 0 Then
         x = 0
         z = 3
         Exit For
      End If
   Next
End Sub

Sub ComplexParse (x$, x)
   x = 0
   x1$ = LCase$(x$)
   For V = 1 To MaxComplex
      V$ = ComplexCommands(V)
      If V$ <> "" Then
         If Left$(x1$, Len(V$)) = V$ Then
            x = -1

            ' display current command line title
            _Title Program + " - " + UCase$(V$)

            ' get next command in list
            x1$ = RTrim$(x$)
            COMMAND2$ = Mid$(x1$, Len(V$) + 1)

            ' force stdin for all streamed commands
            Stdin = -1

            ' check command parameter
            If Len(COMMAND2$) Then
               z$ = Left$(COMMAND2$, 1)
               If IsSymbol(z$) Then
                  ' eat
               Else
                  x = -2
                  Exit Sub
               End If
            End If

            ' call the actual command in stream
            Var = 0
            Select Case V
               Case 1
                  Call Xcount(Var)
               Case 2
                  Call TouchDir(Var)
               Case 3
                  Call Touch(Var)
               Case 4
                  Call Dirattr(Var)
               Case 5
                  Call Setattr(Var)
               Case 6
                  Encrypt.Call = 0
                  Call Encrypt(Var)
               Case 7
                  Encrypt.Call = -1
                  Call Encrypt(Var)
               Case 8
                  Call Treedel(Var)
               Case 9
                  Call Stree(Var)
               Case 10 ' delete
                  Call Delete(Var)
               Case 11 ' rename
                  Call Nameit(Var)
               Case 12
                  Call Drives(Var)
               Case 13
                  Call Label(Var)
               Case 14
                  Call ListVols(Var)
               Case 15
                  ' avoid multiple tee calls
                  If TeeCalls = 0 Then
                     TeeCalls = -1
                     Call TeeFunction(Var)
                  End If
               Case 16
                  Call Copyit(Var)
               Case 17
                  ' avoid multiple parse calls
                  If ParseCalls = 0 Then
                     ParseCalls = -1
                     Call ParseTest(Var)
                  End If
               Case 18
                  Call Zsort(Var)
               Case 19
                  Call TypeY(Var)
               Case 20
                  Call MoreX(Var)
               Case 21
                  Call FindY(Var)
               Case 22, 23
                  Call NewDir(Var)
               Case 24, 25
                  Call MakDir(Var)
               Case 26, 27
                  Call DelDir(Var)
               Case 28
                  Call MakeFile(Var)
               Case 29
                  Call Whereis(Var, 0)
               Case 30 ' dirs
                  Call Stree(Var)
               Case 31
                  Call ListSerial(Var)
               Case 32
                  Call ListFattype(Var)
               Case 33 ' del
                  Call Delete(Var)
               Case 34 ' dir
                  Call Stree(Var)
               Case 35 ' ren
                  Call Nameit(Var)
            End Select
            ' command switch error
            If Var Then
               x = -2
               Exit For
            End If
         End If
      End If
   Next
End Sub

Sub SimpleParse (x$, x)
   x = 0
   x1$ = LCase$(x$)
   For V = 1 To MaxSimple
      V$ = SimpleCommands(V)
      If Left$(x1$, Len(V$)) = V$ Then
         x = -1
         z$ = Mid$(x1$, Len(V$) + 1, 1)
         If Len(z$) Then
            If IsAlphaNum(z$) Then
               Print "Type HELP for help."
               Exit Sub
            End If
         End If
         If Stdin Then
            Print "Error: Command does not support redirected input."
            Exit Sub
         End If
         If LTrim$(RTrim$(Mid$(x1$, Len(V$) + 1))) = "/?" Then
            Call DisplayHelp(V$)
            Exit Sub
         End If
         _Title Program + " - " + UCase$(V$)
         If V = 1 Then GoTo PromptFunc
         x1$ = RTrim$(x1$)
         If SimpleCommandsN(V) = 0 Then
            If x1$ <> V$ Then
               Print "Type " + UCase$(V$) + " /? for help."
               Exit Sub
            End If
         End If
         If V = 2 Then GoTo RedrawFunc
         If V = 3 Then GoTo CpuFunc
         If V = 4 Then GoTo MemFunc
         If V = 5 Then GoTo ClsFunc
         If V = 6 Then GoTo EditFunc
         If V = 7 Then GoTo DebugFunc
         If V = 8 Then GoTo VerFunc
         If V = 9 Then GoTo HelpFunc
         If V = 10 Then GoTo ColorsFunc
         If V = 11 Then GoTo QuitProgram
         If V = 12 Then GoTo AbortProgram
         If V = 13 Then GoTo KeyFunc
         If V = 14 Then GoTo StatusFunc
         If V = 15 Then GoTo MenuFunc
         If V = 16 Then GoTo DateFunc
         If V = 17 Then GoTo TimeFunc
         If V = 18 Then GoTo ClockFunc
         If V = 19 Then GoTo HexCalcFunc
         If V = 20 Then GoTo AsciiChartFunc
         If V = 21 Then GoTo HexChartFunc
         If V = 22 Then GoTo WhatisFunc
         If V = 23 Then GoTo ToggleFunc
         If V = 24 Then GoTo AboutFunc
         If V = 25 Then GoTo ToggleFunc2
         If V = 26 Then GoTo ToggleFunc3
         If V = 27 Then GoTo BlankFunc
         If V = 28 Then GoTo SaverFunc
         If V = 29 Then GoTo ProfilesFunc
         If V = 30 Then GoTo MonitorFunc
         If V = 31 Then GoTo PushdFunc
         If V = 32 Then GoTo PopdFunc
         If V = 33 Then GoTo CompareFunc
         If V = 34 Then GoTo CompareFunc2
         If V = 35 Then GoTo FileListFunc
         If V = 36 Then GoTo DirListFunc
         If V = 37 Then GoTo DriveListFunc
         If V = 38 Then GoTo AlarmFunc
         If V = 39 Then GoTo TableFunc
         If V = 40 Then GoTo ViewFunc
         If V = 41 Then GoTo AllListFunc
         If V = 42 Then GoTo Relogin
         If V = 43 Then GoTo HistoryFunc
         If V = 44 Then GoTo PlayFunc
         If V = 45 Then GoTo GrabFunc
         If V = 46 Then GoTo SearchFunc
         If V = 47 Then GoTo KeymapFunc
      End If
   Next
   Exit Sub

   ' grab or test url
   GrabFunc:
   Color Yellow
   If Len(x1$) Then x1$ = Mid$(x1$, 8) ' graburl
   x1$ = RTrim$(LTrim$(x1$))
   If Len(x1$) Then
      z$ = x1$
      If LCase$(z$) = "test" Then
         Print "Enter url filename to test:";
         Url$ = KeyboardLine$(3): Print
         If Url$ = "" Then
            ' URL to grab (page or a file)
            Url$ = UrlEmc3
            Print "Grab: "; Url$
         End If
         client$ = Url$
         If Left$(client$, 2) = "//" Then
            client$ = "HTTP:" + client$
         End If
         If Left$(LCase$(client$), 5) = "http:" Or Left$(LCase$(client$), 6) = "https:" Then
            eat$ = ""
         Else
            client$ = "HTTP:" + client$
         End If
         If Len(client$) Then
            clientdetect = -1
            clienthandle = _OpenClient(client$)
            clientdetect = 0
            If clienthandle = 0 Then
               Print "Cannot open client."
            Else
               Close clienthandle
               Print "Client exists."
            End If
         End If
      Else
         Print "Try " + Quote + "Graburl test" + Quote + "."
      End If
      Exit Sub
   End If

   Print "Enter filename to get url from:";
   Url$ = KeyboardLine$(3): Print
   If Url$ = "" Then
      ' URL to grab (page or a file)
      Url$ = UrlEmc3
      Print "Grab: "; Url$
   End If
   If Len(Url$) Then
      Print "Enter filename to send url to:";
      Urlfile$ = KeyboardLine$(3): Print
      If Urlfile$ = "" Then
         Urlfile$ = GetURLFilename$
         Print "Send:"; Urlfile$
      End If
      If Len(Urlfile$) Then
         x = DownloadToFileX&(Url$, Urlfile$)
         Color Yellow
         Print "Return:"; x;
         If x >= 200 And x < 300 Then
            Print "Success"
         Else
            If x = 404 Then
               Print "Not found";
            End If
            If x >= 300 And x < 400 Then
               Print "Redirect error";
            End If
            If x >= 400 And x < 500 Then
               Print "Client error";
            End If
            If x >= 500 Then
               Print "Server error";
            End If
            Print " Failure"
         End If
      End If
   End If
   Exit Sub

   KeymapFunc:
   If Len(x1$) Then x1$ = Mid$(x1$, 7) ' mapper
   x1$ = RTrim$(LTrim$(x1$))
   Key Off
   Call ClearKeys
   Call Keymapper(x1$)
   Call SetKeys
   xx = ClearKeyboard2
   If KEYOFF = 0 Then
      Key On
   End If
   Exit Sub

   ' play <parameter>
   '   paramater equals: load/font/types/list/melody/length/stop/pause/resume/volume/move or
   '   filename.ext where .ext is a sound file extension equal to:
   '   "WAV","AIFF","AIFC","FLAC","OGG","MP3","IT","XM","S3M","MOD"
   '   "RAD","AHX","HVL","MUS","HMI","HMP","HMQ","KAR","LDS","MDS"
   '   "MIDS","RCP","R36","G18","G36","RMI","MID","MIDI","XFM","XMI","QOA"
   PlayFunc:
   If Len(x1$) Then x1$ = Mid$(x1$, 5)
   x1$ = RTrim$(LTrim$(x1$))
   If Len(x1$) Then
      z$ = x1$
      If Left$(z$, 1) = Quote And Right$(z$, 1) = Quote Then
         z$ = Left$(z$, Len(z$) - 1)
         z$ = Mid$(z$, 2)
      End If
      If z$ = "help" Then
         Print #StdoutHandle, "PLAY LOAD/FONT/TYPES/LIST/MELODY/LENGTH/STOP/PAUSE/RESUME/VOLUME/MOVE"
         Print #StdoutHandle, " or <filename.ext>"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  plays default sound file."
         Print #StdoutHandle, "    'Load' plays soundfile from dialog box."
         Print #StdoutHandle, "    'Font' loads soundfile font from dialog box."
         Print #StdoutHandle, "    'Types' displays list of sound file extensions."
         Print #StdoutHandle, "    'List' displays list of all sound filenames."
         Print #StdoutHandle, "    'Melody' plays music variable."
         Print #StdoutHandle, "    'Length' displays music file length."
         Print #StdoutHandle, "    'Stop' closes and stops music being played."
         Print #StdoutHandle, "    'Pause' halts current music being playing."
         Print #StdoutHandle, "    'Resume' continues currently halted music."
         Print #StdoutHandle, "    'Volume' inceases/decreases using +/- or value between 0 and 1."
         Print #StdoutHandle, "    'Move' resets currently played music plus 10 seconds."
         Print #StdoutHandle, "      optional Move -<n> or +<n> moves less or more in <n> seconds."
         Print #StdoutHandle, "  Also specifies filename to play."
         Exit Sub
      End If
      If Left$(z$, 6) = "volume" Then
         If SoundHandle <> 0 Then
            z$ = Mid$(z$, 7)
            z$ = LTrim$(z$)
            If Len(z$) Then
               If z$ = "+" Then ' increment volume
                  If SoundVolume + .1 <= 1 Then
                     SoundVolume = SoundVolume + .1
                     _SndVol SoundHandle, SoundVolume
                  End If
               Else
                  If z$ = "-" Then ' decrement volume
                     If SoundVolume - .1 >= 0 Then
                        SoundVolume = SoundVolume - .1
                        _SndVol SoundHandle, SoundVolume
                     End If
                  Else
                     If Int(Val(z$)) >= 0 And Int(Val(z$)) <= 10 Then ' interval
                        SoundVolume = Int(Val(z$)) / 10
                        _SndVol SoundHandle, SoundVolume
                     End If
                  End If
               End If
            End If
         End If
         Exit Sub
      End If
      If z$ = "types" Then
         Call DisplayFontFilesX
         Exit Sub
      End If
      If z$ = "list" Then
         Found = 0
         For V = 1 To MaxSoundFileExtensions
            Var$ = "*." + SoundFileExtensions(V)
            If _Files$(Var$) <> "" Then
               Found = -1
               Call ListFiles(Var$, -1)
               Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
            End If
         Next
         If Found = 0 Then
            Print "No files found."
            Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
         End If
         Exit Sub
      End If
      If z$ = "melody" Then
         VarZ$ = Melody$
         Play VarZ$
         Exit Sub
      End If
      If z$ = "melody2" Then
         VarZ$ = Melody2$
         Play VarZ$
         Exit Sub
      End If
      If z$ = "restart" Then
         If SoundHandle <> 0 Then
            '_SndSetPos SoundHandle, 0!
            Print #StdoutHandle, "File restarted."
            _SndPlay SoundHandle
            SoundVolume = 1!
            _SndVol SoundHandle, SoundVolume
            Exit Sub
         End If
      End If
      If z$ = "length" Then
         If SoundHandle <> 0 Then
            S& = _SndLen(SoundHandle)
            S$ = Str$(S&)
            If InStr(S$, ".") Then
               S$ = Left$(S$, InStr(S$, ".") + 2)
            End If
            Print #StdoutHandle, "Handle"; SoundHandle; " is"; S$; " seconds.";
            S& = _SndGetPos(SoundHandle)
            S$ = Str$(S&)
            If InStr(S$, ".") Then
               S$ = Left$(S$, InStr(S$, ".") + 2)
            End If
            Print #StdoutHandle, " Position is"; S$; " seconds.";
            Print #StdoutHandle, " Volume level is"; Str$(SoundVolume); "."
            If _SndPaused(SoundHandle) = -1 Then
               Print #StdoutHandle, "  File is paused."
            End If
            Exit Sub
         End If
      End If
      If LCase$(Left$(z$, 4)) = "move" Then
         If SoundHandle <> 0 Then
            z$ = LTrim$(Mid$(z$, 5))
            If Left$(z$, 1) = "+" Then
               z! = Val(Mid$(z$, 2))
               z2! = _SndGetPos(SoundHandle)
               z2! = z2! + z!
               _SndSetPos SoundHandle, z2!
               Exit Sub
            End If
            If Left$(z$, 1) = "-" Then
               z! = Val(Mid$(z$, 2))
               z2! = _SndGetPos(SoundHandle)
               z2! = z2! - z!
               If z2! < 0! Then
                  z2! = 0!
               End If
               If z2! >= 0! Then
                  _SndSetPos SoundHandle, z2!
               End If
               Exit Sub
            End If
            If LTrim$(RTrim$(z$)) = "" Then
               z! = 10!
            Else
               z! = Val(z$)
            End If
            z2! = _SndGetPos(SoundHandle)
            z2! = z2! + z!
            _SndSetPos SoundHandle, z2!
            Exit Sub
         End If
      End If
      If LCase$(z$) = "stop" Then
         If SoundHandle <> 0 Then
            _SndStop SoundHandle
            _SndClose SoundHandle
            SoundHandle = 0
            Print #StdoutHandle, "File closed."
         Else
            Print #StdoutHandle, "File not loaded."
         End If
         Exit Sub
      End If
      If LCase$(z$) = "pause" Then
         If SoundHandle <> 0 Then
            If _SndPaused(SoundHandle) = 0 Then
               _SndPause SoundHandle
               Print #StdoutHandle, "File paused."
            Else
               Print #StdoutHandle, "File already paused."
            End If
         Else
            Print #StdoutHandle, "File not loaded."
         End If
         Exit Sub
      End If
      If LCase$(z$) = "resume" Then
         If SoundHandle <> 0 Then
            If _SndPaused(SoundHandle) = -1 Then
               _SndPlay SoundHandle
               Print #StdoutHandle, "File resume."
            Else
               Print #StdoutHandle, "File not paused."
            End If
         Else
            Print #StdoutHandle, "File not loaded."
         End If
         Exit Sub
      End If
      If LCase$(z$) = "load" Then
         ' load soundfile
         '   case-sensitive compatible with Linux
         VarX$ = ""
         For Temp = 1 To MaxSoundFileExtensions
            VarX$ = VarX$ + "|*." + LCase$(RTrim$(SoundFileExtensions(Temp)))
         Next
         For Temp = 1 To MaxSoundFileExtensions
            VarX$ = VarX$ + "|*." + UCase$(RTrim$(SoundFileExtensions(Temp)))
         Next
         Filter$ = "All files (*.*)" + VarX$
         Title$ = "QB64Shell Open Sound File"
         Filename = _OpenFileDialog$(Title$, StartDir$, Filter$)
         If Len(Filename) Then
            ' play a music file.
            If VerifyPlay2(Filename) Then
               Color Yellow
               If SoundHandle <> 0 Then
                  _SndStop SoundHandle
                  _SndClose SoundHandle
               End If
               Print "Loading file: "; Filename
               SoundHandle = _SndOpen(Filename) ' get file handle
               If SoundHandle <> 0 Then
                  SoundVolume = 1!
                  _SndVol SoundHandle, SoundVolume
                  S& = _SndLen(SoundHandle)
                  S$ = Str$(S&)
                  If InStr(S$, ".") Then
                     S$ = Left$(S$, InStr(S$, ".") + 2)
                  End If
                  Print "Handle"; SoundHandle; "is"; S$; " seconds."
                  _SndPlay SoundHandle
                  Color White
                  Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
               End If
            Else
               Print "Filename "; Filename; " not found."
            End If
         Else
            Print "Filename not found."
         End If
         Exit Sub
      End If
      If LCase$(z$) = "font" Then
         ' load soundfont
         '   case-sensitive compatible with Linux
         VarX$ = ""
         For Temp = 1 To MaxSoundFontExtensions
            VarX$ = VarX$ + "|*." + LCase$(RTrim$(SoundFontExtensions(Temp)))
         Next
         For Temp = 1 To MaxSoundFontExtensions
            VarX$ = VarX$ + "|*." + UCase$(RTrim$(SoundFontExtensions(Temp)))
         Next
         Filter$ = "All files (*.*)" + VarX$
         Title$ = "QB64Shell Open Font File"
         Filename = _OpenFileDialog$(Title$, StartDir$, Filter$)
         If Len(Filename) Then
            For Temp = 1 To MaxSoundFontExtensions
               Var$ = "." + LCase$(SoundFontExtensions(Temp))
               If LCase$(Right$(Filename, Len(Var$))) = Var$ Then
                  ' check QB64PE version.
                  $If VERSION < 4.0.0 Then
                     $MIDISOUNDFONT: Filename
                     Print #StdoutHandle, "Sound font: " + Filename + " loaded."
                  $End If
                  $If VERSION >= 4.0.0 Then
                     _MIDISoundBank Filename
                     Print #StdoutHandle, "Sound font: " + Filename + " loaded."
                  $End If
                  Exit Sub
               End If
            Next
         End If
         Print #StdoutHandle, "Sound font filename not found."
         Exit Sub
      End If
      If _FileExists(z$) Then
         VarX = VerifyPlay(z$)
         If VarX Then
            If LCase$(StdoutFile$) = "scrn:" Then
               Print #StdoutHandle, "Loading file: ";
            End If
            Print #StdoutHandle, z$
            If SoundHandle <> 0 Then
               _SndStop SoundHandle
               _SndClose SoundHandle
               SoundHandle = 0
            End If
            SoundHandle = _SndOpen(z$)
            If SoundHandle <> 0 Then
               _SndPlay SoundHandle
               SoundVolume = 1!
               _SndVol SoundHandle, SoundVolume
            Else
               Print #StdoutHandle, "Sound file not found."
            End If
         Else
            Print #StdoutHandle, "Sound file not found."
         End If
      Else
         Print #StdoutHandle, "Sound file not found."
      End If
   Else
      If _FileExists(SoundFile) Then
         '_SndPlayFile (SoundFile)
         If SoundHandle <> 0 Then
            _SndStop SoundHandle
            _SndClose SoundHandle
            SoundHandle = 0
         End If
         SoundHandle = _SndOpen(SoundFile)
         If SoundHandle <> 0 Then
            Print #StdoutHandle, SoundFile
            _SndPlay SoundHandle
            SoundVolume = 1!
            _SndVol SoundHandle, SoundVolume
         Else
            Print #StdoutHandle, "Sound file not found."
         End If
      Else
         Print #StdoutHandle, "Sound file not found."
      End If
   End If
   Exit Sub

   HistoryFunc:
   If x1$ = "history" Then
      Call History
      Exit Sub
   End If
   ' history list/help/reset
   If Len(x1$) Then x1$ = Mid$(x1$, 8)
   x1$ = RTrim$(LTrim$(x1$))
   If Len(x1$) Then
      z$ = x1$
      If z$ = "list" Then
         f = 0
         For VarQ2 = 1 To MaxHistory
            V$ = LTrim$(RTrim$(History2(1, VarQ2)))
            If Len(V$) Then
               If f = 0 Then
                  Color White
                  Print #StdoutHandle, "Command history:"
                  f = -1
               End If
               Color Yellow
               Print #StdoutHandle, V$
            End If
         Next
         f = 0
         For VarQ2 = 1 To MaxHistory
            V$ = LTrim$(RTrim$(History2(2, VarQ2)))
            If Len(V$) Then
               If f = 0 Then
                  Color White
                  Print #StdoutHandle, "Netpath history:"
                  f = -1
               End If
               Color Yellow
               Print #StdoutHandle, V$
            End If
         Next
      Else
         If z$ = "help" Then
            Print #StdoutHandle, "HISTORY [RESET][LIST]"
            Print #StdoutHandle, ""
            Print #StdoutHandle, "  Displays user account."
            Print #StdoutHandle, "    [RESET] resets history arrays."
            Print #StdoutHandle, "    [LIST] displays history arrays."
         Else
            If z$ = "reset" Then
               ' reset multi-dimensional command history arrays
               For VarQ1 = 1 To 3
                  EndOfHistoryFlag(VarQ1) = 0
                  HistoryCount2(VarQ1) = 0
                  For VarQ2 = 1 To MaxHistory
                     History2(VarQ1, VarQ2) = ""
                  Next
               Next
               Print #StdoutHandle, "History reset."
            Else
               Print #StdoutHandle, "Type " + Quote + "History help" + Quote + " for help."
            End If
         End If
      End If
   End If
   Exit Sub

   Relogin:
   Call GetUserProfile(V, "")
   Exit Sub

   Rem In DateFunc and TimeFunc the error
   Rem   a required privilege is not held by the client.
   Rem is solved by running qb64pe as admin.
   Rem (although QBshell will attempt to force user as admin).

   DateFunc:
   Print "Current date: "; Date$
   If Len(x1$) Then x1$ = Mid$(x1$, 5)
   x1$ = RTrim$(LTrim$(x1$))
   If Len(x1$) Then
      z$ = x1$
   Else
      Print "Enter date(mm-dd-yyyy)";
      Input z$
   End If
   ' roll forward.
   z$ = LTrim$(RTrim$(z$))
   If Len(z$) Then
      z = ValidDate(z$)
      If z Then
         z = ValidDate2(z$) ' check rollback
         If z Then
            ' mm-dd-yyyy
            x = GetLocalTime(SysTime)
            SysTime.wMonth = Int(Val(Left$(z$, 2)))
            SysTime.wDay = Int(Val(Mid$(z$, 4, 2)))
            SysTime.wYear = Int(Val(Right$(z$, 4)))
            x = SetLocalTime(SysTime)
            If x = 0 Then
               Print #StdoutHandle, "Error Date reset: " + z$
               Print #StderrHandle, DisplayWinError$(x)
            Else
               Print #StdoutHandle, "Date reset to: " + z$
            End If
         Else
            Print #StdoutHandle, "Error Date reset: " + z$
         End If
      Else
         Print #StdoutHandle, "Invalid date."
      End If
   End If
   Exit Sub

   TimeFunc:
   Print "Current time: "; Time$
   If Len(x1$) Then x1$ = Mid$(x1$, 5)
   x1$ = RTrim$(LTrim$(x1$))
   If Len(x1$) Then
      z$ = x1$
   Else
      Print "Enter time(hh:mm:ss)";
      Input z$
   End If
   ' roll forward.
   z$ = LTrim$(RTrim$(z$))
   If Len(z$) Then
      z = ValidTime(z$)
      If z Then
         z = ValidTime2(z$) ' check rollback
         If z Then
            ' hh:mm:ss
            x = GetLocalTime(SysTime)
            SysTime.wHour = Int(Val(Left$(z$, 2)))
            SysTime.wMinute = Int(Val(Mid$(z$, 4, 2)))
            SysTime.wSecond = Int(Val(Right$(z$, 2)))
            x = SetLocalTime(SysTime)
            If x = 0 Then
               Print #StdoutHandle, "Error Time reset: " + z$
               Print #StderrHandle, DisplayWinError$(x)
            Else
               Print #StdoutHandle, "Time reset to: " + z$
            End If
         Else
            Print #StdoutHandle, "Error Time reset: " + z$
         End If
      Else
         Print #StdoutHandle, "Invalid time."
      End If
   End If
   Exit Sub

   DebugFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "debug" Then
      If Debug Then
         Print #StdoutHandle, "DEBUG is on."
      Else
         Print #StdoutHandle, "DEBUG is off."
      End If
      Exit Sub
   End If
   x1$ = Mid$(x1$, 6)
   If Left$(x1$, 1) = " " Then
      x1$ = Mid$(x1$, 2)
      x1$ = RTrim$(LTrim$(x1$))
      If InStr(x1$, " ") Then
         x2$ = Left$(x1$, InStr(x1$, " ") - 1)
         If x2$ = "test" Then
            x1$ = Mid$(x1$, InStr(x1$, " ") + 1)
         Else
            Print #StdoutHandle, "Type DEBUG /? for help."
            Exit Sub
         End If
      End If
      If InStr(x1$, " ") Then
         Print #StdoutHandle, "Type DEBUG /? for help."
         Exit Sub
      End If
      Select Case x1$
         Case "commands"
            Call InitData(1)
         Case "toggle"
            Debug = Not Debug
            If Debug Then
               Print #StdoutHandle, "Debug on."
            Else
               Print #StdoutHandle, "Debug off."
            End If
         Case "off"
            Debug = 0
            Print #StdoutHandle, "Debug off."
         Case "on"
            Debug = -1
            Print #StdoutHandle, "Debug on."
         Case "test"
            r = Sqr(-1)
         Case "squareroot"
            r = Sqr(-1)
         Case "wheelreverse"
            WheelReverse = Not WheelReverse
            If WheelReverse Then
               Print #StdoutHandle, "Wheel reverse on."
            Else
               Print #StdoutHandle, "Wheel reverse off."
            End If
         Case "mouse"
            Color White
            Print #StdoutHandle, "Mouse detect. Press <esc> to exit."
            If WheelReverse Then
               Print #StdoutHandle, "  Mouse wheel reverse on."
            End If
            Wheel1 = 0
            Wheel2 = 0
            Do
               x$ = INKEYz$
               If x$ = Chr$(27) Then Exit Do
               x = MouseDriver2
               If MouseButton1 = -1 Then MouseButton1 = 0: Print #StdoutHandle, "Button1"
               If MouseButton1 = 2 Then MouseButton1 = 0: Print #StdoutHandle, "Double-Button1"
               If MouseButton2 = -1 Then MouseButton2 = 0: Print #StdoutHandle, "Button2"
               If MouseButton2 = 2 Then MouseButton2 = 0: Print #StdoutHandle, "Double-Button2"
               If MouseButton3 = -1 Then MouseButton3 = 0: Print #StdoutHandle, "Button3"
               If MouseButton3 = 2 Then MouseButton3 = 0: Print #StdoutHandle, "Double-Button3"
               If MouseX Or MouseY Then Print #StdoutHandle, "Coor:" + Str$(MouseX) + Str$(MouseY)
               If MouseWheel Then
                  If MouseWheel = -1 Then
                     Wheel1 = Wheel1 + 1
                     Print #StdoutHandle, "Mousewheel Up" + Str$(Wheel1)
                  End If
                  If MouseWheel = 1 Then
                     Wheel2 = Wheel2 + 1
                     Print #StdoutHandle, "Mousewheel Down" + Str$(Wheel2)
                  End If
               End If
            Loop
         Case "mousex" ' extended mouse
            Color White
            Print #StdoutHandle, "Mouse detect. Press <esc> to exit."
            If WheelReverse Then
               Print #StdoutHandle, "  Mouse wheel reverse on."
            End If
            Wheel1 = 0
            Wheel2 = 0
            Do
               x$ = INKEYz$
               If x$ = Chr$(27) Then Exit Do
               x = MouseDriver3
               If MouseButton1 = -1 Then MouseButton1 = 0: Print #StdoutHandle, "Button1"
               If MouseButton1 = 2 Then MouseButton1 = 0: Print #StdoutHandle, "Double-Button1"
               If MouseButton1 = 3 Then MouseButton1 = 0: Print #StdoutHandle, "Triple-Button1"
               If MouseButton2 = -1 Then MouseButton2 = 0: Print #StdoutHandle, "Button2"
               If MouseButton2 = 2 Then MouseButton2 = 0: Print #StdoutHandle, "Double-Button2"
               If MouseButton2 = 3 Then MouseButton2 = 0: Print #StdoutHandle, "Triple-Button2"
               If MouseButton3 = -1 Then MouseButton3 = 0: Print #StdoutHandle, "Button3"
               If MouseButton3 = 2 Then MouseButton3 = 0: Print #StdoutHandle, "Double-Button3"
               If MouseButton3 = 3 Then MouseButton3 = 0: Print #StdoutHandle, "Triple-Button3"
               If MouseX Or MouseY Then Print #StdoutHandle, "Coor:" + Str$(MouseX) + Str$(MouseY)
               If MouseWheel Then
                  If MouseWheel = -1 Then
                     Wheel1 = Wheel1 + 1
                     Print #StdoutHandle, "Mousewheel Up" + Str$(Wheel1)
                  End If
                  If MouseWheel = 1 Then
                     Wheel2 = Wheel2 + 1
                     Print #StdoutHandle, "Mousewheel Down" + Str$(Wheel2)
                  End If
               End If
            Loop
         Case "mousez" ' extended mouse with quad-click
            Color White
            Print #StdoutHandle, "Mouse detect. Press <esc> to exit."
            If WheelReverse Then
               Print #StdoutHandle, "  Mouse wheel reverse on."
            End If
            Wheel1 = 0
            Wheel2 = 0
            Do
               x$ = INKEYz$
               If x$ = Chr$(27) Then Exit Do
               x = MouseDriver4
               If MouseButton1 = -1 Then MouseButton1 = 0: Print #StdoutHandle, "Button1"
               If MouseButton1 = 2 Then MouseButton1 = 0: Print #StdoutHandle, "Double-Button1"
               If MouseButton1 = 3 Then MouseButton1 = 0: Print #StdoutHandle, "Triple-Button1"
               If MouseButton1 = 4 Then MouseButton1 = 0: Print #StdoutHandle, "Quad-Button1"
               If MouseButton2 = -1 Then MouseButton2 = 0: Print #StdoutHandle, "Button2"
               If MouseButton2 = 2 Then MouseButton2 = 0: Print #StdoutHandle, "Double-Button2"
               If MouseButton2 = 3 Then MouseButton2 = 0: Print #StdoutHandle, "Triple-Button2"
               If MouseButton2 = 4 Then MouseButton2 = 0: Print #StdoutHandle, "Quad-Button2"
               If MouseButton3 = -1 Then MouseButton3 = 0: Print #StdoutHandle, "Button3"
               If MouseButton3 = 2 Then MouseButton3 = 0: Print #StdoutHandle, "Double-Button3"
               If MouseButton3 = 3 Then MouseButton3 = 0: Print #StdoutHandle, "Triple-Button3"
               If MouseButton3 = 4 Then MouseButton3 = 0: Print #StdoutHandle, "Quad-Button3"
               If MouseX Or MouseY Then Print #StdoutHandle, "Coor:" + Str$(MouseX) + Str$(MouseY)
               If MouseWheel Then
                  If MouseWheel = -1 Then
                     Wheel1 = Wheel1 + 1
                     Print #StdoutHandle, "Mousewheel Up" + Str$(Wheel1)
                  End If
                  If MouseWheel = 1 Then
                     Wheel2 = Wheel2 + 1
                     Print #StdoutHandle, "Mousewheel Down" + Str$(Wheel2)
                  End If
               End If
            Loop
         Case "graburl"
            Print "Enter filename to get url from:";
            Url$ = KeyboardLine$(3): Print
            If Url$ = "" Then
               ' URL to grab (page or a file)
               Url$ = UrlEmc3
               Print "Grab: "; Url$
            End If
            If Len(Url$) Then
               Print "Enter filename to send url to:";
               Urlfile$ = KeyboardLine$(3): Print
               If Urlfile$ = "" Then
                  Urlfile$ = GetURLFilename$ '
                  Print "Send:"; Urlfile$
               End If
               If Len(Urlfile$) Then
                  x = DownloadToFileX&(Url$, Urlfile$)
                  Print "Return:"; x;
                  If x >= 200 And x < 300 Then
                     Print " Success"
                  Else
                     If x = 404 Then
                        Print " Not found";
                     End If
                     If x >= 300 And x < 400 Then
                        Print " Redirect error";
                     End If
                     If x >= 400 And x < 500 Then
                        Print " Client error";
                     End If
                     If x >= 500 Then
                        Print " Server error";
                     End If
                     Print " Failure"
                  End If
               End If
            End If
         Case "errorlog"
            f$ = CriticalErrorLogFile$
            If _FileExists(f$) Then
               If Status Then
                  z = 23
               Else
                  z = 24
               End If
               l = 0
               x = FreeFile
               Open f$ For Input As #x
               Do
                  If EOF(x) Then Exit Do
                  Line Input #x, z$
                  Color Yellow, Black
                  Print #StdoutHandle, z$
                  l = l + 1
                  If l >= z Then
                     l = 0
                     If LCase$(StdoutFile$) = "scrn:" Then
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  End If
               Loop
               Close #x
               If l Then
                  If LCase$(StdoutFile$) = "scrn:" Then
                     Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                  End If
               End If
            Else
               Print #StdoutHandle, "Error log not found."
               If LCase$(StdoutFile$) = "scrn:" Then
                  Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
               End If
            End If
         Case "copyerrorlog"
            f$ = ErrorLogFile$
            If _FileExists(f$) Then
               If Status Then
                  z = 23
               Else
                  z = 24
               End If
               l = 0
               x = FreeFile
               Open f$ For Input As #x
               Do
                  If EOF(x) Then Exit Do
                  Line Input #x, z$
                  Color Yellow, Black
                  Print #StdoutHandle, z$
                  l = l + 1
                  If l >= z Then
                     l = 0
                     If LCase$(StdoutFile$) = "scrn:" Then
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  End If
               Loop
               Close #x
               If l Then
                  If LCase$(StdoutFile$) = "scrn:" Then
                     Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                  End If
               End If
            Else
               Print #StdoutHandle, "Error log not found."
               If LCase$(StdoutFile$) = "scrn:" Then
                  Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
               End If
            End If
         Case "error"
            ' display specific error
            Print "Test value? ";
            Var$ = LineInput$(CsrLin, Pos(0), 40): Print
            x& = Int(Val(Var$))
            y& = FormatMessageA&(&H1200, "", x&, 0, ErrorBuffer$, 260, "")
            If y& = 0 Then
               ' message does not exist in message table
               y& = FormatMessageA&(&H1200, "", GetLastError, 0, ErrorBuffer$, 260, "")
               Print #StdoutHandle, "Error 0x"; Hex$(GetLastError); " ("; GetLastError; ")"
               If y& > 2 Then
                  Print #StdoutHandle, Left$(ErrorBuffer$, y& - 2)
               End If
            Else
               Print #StdoutHandle, "Error 0x"; Hex$(x&); " ("; x&; ")"
               Print #StdoutHandle, Left$(ErrorBuffer$, y& - 2)
            End If
         Case "filenamebox"
            Var$ = FilenameBox$(3)
            Print #StdoutHandle, "Return: "; Var$
         Case "asciibox"
            Ascii$ = AsciiBox$
            Print #StdoutHandle, "Return: "; Ascii$
         Case "errorbox"
            If ErrorBox(" Debug ", "Sample error test.") Then
               Print #StdoutHandle, "Entered OK"
            Else
               Print #StdoutHandle, "Entered Cancel"
            End If
         Case "messagebox"
            r = MessageBox(" Debug ", "Sample message test.|" + Date$ + " " + Time$)
         Case "monitorbox"
            m = DisplaySelect ' store monitor state
            s1$ = LTrim$(Str$(MonitorTimer))
            s2$ = LTrim$(Str$(MonitorLimit))
            s3$ = s1$: s4$ = s2$
            r = MonitorBox(s1$, s2$) ' 0=exit
            DisplaySelect = m ' restore monitor state
            MonitorTimer = Int(Val(s3$))
            MonitorLimit = Int(Val(s4$))
            If r = 2 Then ' system
               Print #StdoutHandle, "System"
            End If
            If r = 1 Then ' continue
               If s1$ = "" Then
                  Print #StdoutHandle, "Timer: <nul> seconds."
               Else
                  Print #StdoutHandle, "Timer: "; s1$; " seconds."
               End If
               If s2$ = "" Then
                  Print #StdoutHandle, "Limit: <nul> MB."
               Else
                  Select Case MonitorSuffix
                     Case 0 ' mega
                        Print #StdoutHandle, "Memory monitor set to" + Str$(MonitorLimit) + " MB."
                     Case 1 ' kilo
                        Print #StdoutHandle, "Memory monitor set to" + Str$(MonitorLimit * 1000) + " KB."
                     Case 2 ' giga
                        Print #StdoutHandle, "Memory monitor set to" + Str$(MonitorLimit / (1024)) + " GB."
                     Case 3 ' tera
                        Print #StdoutHandle, "Memory monitor set to" + Str$(MonitorLimit / (1024 * 1024)) + " TB."
                  End Select
               End If
            End If
         Case "timetype"
            DateTimeType = DateTimeType + 1
            If DateTimeType = 3 Then
               DateTimeType = 0
            End If
            Print #StdoutHandle, "Time type set to: ";
            Select Case DateTimeType
               Case 0
                  Print #StdoutHandle, "Create"
               Case 1
                  Print #StdoutHandle, "Access"
               Case 2
                  Print #StdoutHandle, "Modify"
            End Select
         Case "sound"
            If _FileExists(SoundFile) Then
               Print #StdoutHandle, SoundFile
               _SndPlayFile (SoundFile)
            Else
               Print #StdoutHandle, "Sound file not found."
            End If
         Case Else
            Print #StdoutHandle, "Type DEBUG /? for help."
      End Select
   Else
      Print #StdoutHandle, "Type HELP for help."
   End If
   Exit Sub

   ToggleFunc:
   Fullscreen = Not Fullscreen
   If Fullscreen Then
      _FullScreen
      If _FullScreen = 0 Then
         _FullScreen _Off
         Fullscreen = 0
      End If
   Else
      _FullScreen _Off
   End If
   View Print 1 To 25
   Key Off
   Cls
   Color White, Black
   Locate 25, 1
   Call Toolbar
   If Status = 0 Then
      View Print 2 To 24
      Color Plain
      Locate 24, 1, 1
   Else
      Locate 24, 1, 1
      Color Yellow
      Call DisplayVersion
      View Print 2 To 23
      Color Plain
      Locate 23, 1, 1
   End If
   If KEYOFF = 0 Then
      Key On
   End If
   Exit Sub

   ' screen
   ToggleFunc2:
   Fullscreen = -1
   _FullScreen
   If _FullScreen = 0 Then
      _FullScreen _Off
      Fullscreen = 0
   End If
   View Print 1 To 25
   Key Off
   Cls
   Color White, Black
   Locate 25, 1
   Call Toolbar
   If Status = 0 Then
      View Print 2 To 24
      Color Plain
      Locate 24, 1, 1
   Else
      Locate 24, 1, 1
      Color Yellow
      Call DisplayVersion
      View Print 2 To 23
      Color Plain
      Locate 23, 1, 1
   End If
   If KEYOFF = 0 Then
      Key On
   End If
   Exit Sub

   ' window
   ToggleFunc3:
   Fullscreen = 0
   _FullScreen _Off
   View Print 1 To 25
   Key Off
   Cls
   Color White, Black
   Locate 25, 1
   Call Toolbar
   If Status = 0 Then
      View Print 2 To 24
      Color Plain
      Locate 24, 1, 1
   Else
      Locate 24, 1, 1
      Color Yellow
      Call DisplayVersion
      View Print 2 To 23
      Color Plain
      Locate 23, 1, 1
   End If
   If KEYOFF = 0 Then
      Key On
   End If
   Exit Sub

   ' search window
   SearchFunc:
   If Len(x1$) Then x1$ = Mid$(x1$, 7) ' search
   x1$ = RTrim$(LTrim$(x1$))
   If Len(x1$) Then
      z$ = x1$
   Else
      z$ = ""
   End If
   View Print 1 To 25
   Key Off
   Cls
   Color White, Black
   Call ClearKeys
   Call SearchFiles(z$)
   Call SetKeys
   Cls
   Color White, Black
   Locate 25, 1
   Call Toolbar
   If Status = 0 Then
      View Print 2 To 24
      Color Plain
      Locate 24, 1, 1
   Else
      Locate 24, 1, 1
      Color Yellow
      Call DisplayVersion
      View Print 2 To 23
      Color Plain
      Locate 23, 1, 1
   End If
   If KEYOFF = 0 Then
      Key On
   End If
   Exit Sub

   AboutFunc:
   V$ = Program + " " + FullVersion$ + " OS " + _OS$
   Print #StdoutHandle, V$
   Print #StdoutHandle, "Author: " + Author
   Print #StdoutHandle, "Email: " + Email
   Print #StdoutHandle, "Url: " + Urls
   Call HelpAbout
   Exit Sub

   SaverFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "screensaver" Then
      If ScreenSaverActive Then
         Print #StdoutHandle, "Screensaver active."
         If ScreenSaverResolution = 0! Then
            Print #StdoutHandle, "Screensaver timer not set."
         Else
            V! = ScreenSaverResolution
            Var$ = "Screensaver timer:"
            Var$ = Var$ + Str$(V!) + " seconds"
            If V! > 60! Then
               V! = V! / 60!
               Var2$ = Str$(V!)
               If InStr(Var2$, ".") = 0 Then
                  Var2$ = Var2$ + ".0"
               Else
                  Var2$ = Left$(Var2$, InStr(Var2$, ".") + 1)
               End If
               Var$ = Var$ + " (" + LTrim$(Var2$) + " minutes)"
            End If
            Print #StdoutHandle, Var$
         End If
      Else
         Print #StdoutHandle, "Screensaver inactive."
      End If
      Exit Sub
   End If
   x1$ = Mid$(x1$, 12)
   If Left$(x1$, 1) = " " Then
      x1$ = Mid$(x1$, 2)
      x1$ = RTrim$(LTrim$(x1$))
      If x1$ = "help" Then
         Print #StdoutHandle, "SCREENSAVER [ON][OFF][BLANK][<n>]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Turns screensaver on, off, blank, or sets to <n> seconds."
         Print #StdoutHandle, "  Specify SCREENSAVER HH:MM:SS for valid time set on."
         Print #StdoutHandle, "     Specify SCREENSAVER <n>s valid time set seconds."
         Print #StdoutHandle, "     Specify SCREENSAVER <n>m valid time set minutes."
         Print #StdoutHandle, "     Specify SCREENSAVER <n>h valid time set hours."
         Exit Sub
      End If
      If x1$ = "off" Then
         ScreenSaverActive = 0
         Print #StdoutHandle, "Screensaver off."
         Exit Sub
      End If
      If x1$ = "blank" Then
         s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
         Exit Sub
      End If
      If Left$(x1$, 2) = "on" Then
         If x1$ = "on" Then
            ScreenSaverActive = -1
            Print #StdoutHandle, "Screensaver on."
            Exit Sub
         End If
         x1$ = Mid$(x1$, 3)
         x1$ = RTrim$(LTrim$(x1$))
         z$ = Left$(x1$, 1)
         If z$ = "," Or z$ = "=" Then
            x1$ = Mid$(x1$, 2)
         Else
            If z$ >= "0" And z$ <= "9" Then
               eat$ = Nul
            Else
               Print #StdoutHandle, "Type HELP for help."
               Exit Sub
            End If
         End If
      End If
      x1$ = RTrim$(LTrim$(x1$))
      z = ValidTime(x1$)
      If z Then ' HH:MM:SS
         V! = Int(Val(Right$(x1$, 2)))
         V! = V! + Int(Val(Mid$(x1$, 4, 2))) * 60!
         V! = V! + Int(Val(Left$(x1$, 2))) * 3600!
         x1$ = LTrim$(Str$(V!))
      End If
      m = 0
      If Right$(x1$, 1) = "s" Then
         x1$ = Left$(x1$, Len(x1$) - 1)
      Else
         If Right$(x1$, 1) = "m" Then
            m = -1
            x1$ = Left$(x1$, Len(x1$) - 1)
         Else
            If Right$(x1$, 1) = "h" Then
               m = -2
               x1$ = Left$(x1$, Len(x1$) - 1)
            End If
         End If
      End If
      x1$ = RTrim$(LTrim$(x1$))
      If IsNumeric(x1$) Then
         V! = Int(Val(x1$))
         If m = -1 Then V! = V! * 60! ' minutes
         If m = -2 Then V! = V! * 3600! ' hours
         If V! >= 1! And V! <= 86400! Then
            ScreenSaverActive = -1
            ScreenSaverResolution = V!
            Print #StdoutHandle, "Screensaver timer set."
         Else
            Print #StdoutHandle, "Invalid screensaver timer value."
         End If
      Else
         Print #StdoutHandle, "Invalid screensaver timer value."
      End If
   Else
      Print #StdoutHandle, "Type HELP for help."
   End If
   Exit Sub

   ProfilesFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "profiles" Then
      If ProfilesActive Then
         Print #StdoutHandle, "User profiles active."
         Call CountProfiles(V!)
         Print #StdoutHandle, "Total of" + Str$(V!) + " users."
         Call CountDeletedProfiles(V!)
         Print #StdoutHandle, "Total of" + Str$(V!) + " deleted users."
         If Username > "" Then
            Print #StdoutHandle, "You are currently logged on as: " + Username
            Call GetUserStats(V#)
            Print #StdoutHandle, "You have logged on: " + FormatString$(V#) + " times."
         End If
      Else
         Print #StdoutHandle, "User profiles not active."
      End If
      Exit Sub
   End If
   x1$ = Mid$(x1$, 9)
   If Left$(x1$, 1) = " " Then
      x1$ = Mid$(x1$, 2)
      x1$ = RTrim$(LTrim$(x1$))
      If x1$ = "init" Then
         Call InitProfiles(-1)
         Username = "SYSOP"
         Call GetUserProfile(V, "")
         If V Then
            ProfilesActive = -1
            Print #StdoutHandle, "User Profiles init."
         Else
            ProfilesActive = 0
            Print #StdoutHandle, "User Profiles init fail."
         End If
         Exit Sub
      End If
      If x1$ = "on" Then
         If ProfilesActive = 0 Then
            Call InitProfiles(0)
         Else
            Call WriteProfile
         End If
         Call GetUserProfile(V, "")
         If V Then
            ProfilesActive = -1
            Print #StdoutHandle, "User Profiles on."
         Else
            ProfilesActive = 0
            Print #StdoutHandle, "User Profiles logon fail."
         End If
         Exit Sub
      End If
      If x1$ = "off" Then
         If ProfilesActive Then
            Call WriteProfile
         End If
         ProfilesActive = 0
         Print #StdoutHandle, "User Profiles off."
         Exit Sub
      End If
      If x1$ = "list" Then
         Call ListProfiles
         Exit Sub
      End If
      If x1$ = "add" Then
         Call AddProfile("", VarX)
         Exit Sub
      End If
      If x1$ = "edit" Or x1$ = "editor" Then
         Call EditProfiles
         Exit Sub
      End If
      If x1$ = "logon" Or x1$ = "relogon" Then
         If ProfilesActive = 0 Then
            Print #StdoutHandle, "User profiles not active."
            Exit Sub
         End If
         Call WriteProfile
         Username = ""
         Password = ""
         Call GetUserProfile(V, "")
         Exit Sub
      End If
      Print #StdoutHandle, "Type PROFILES /? for help."
   Else
      Print #StdoutHandle, "Type HELP for help."
   End If
   Exit Sub

   CpuFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "cpu" Then
      If CPUOFF Then
         Print #StdoutHandle, "CPU monitor is off."
      Else
         Print #StdoutHandle, "CPU monitor is on."
      End If
      Exit Sub
   End If
   x1$ = Mid$(x1$, 4)
   If Left$(x1$, 1) = " " Then
      x1$ = Mid$(x1$, 2)
      x1$ = RTrim$(LTrim$(x1$))
      If x1$ = "off" Then
         Timer Off
         CPUOFF = -1
         _Title Program
         Call DisplayToolBar
      Else
         If x1$ = "on" Then
            CPUOFF = 0
            Timer On
            Call DisplayToolBar
         Else
            If x1$ = "memory" Then
               Select Case CPUMON
                  Case 0
                     CPUMON = 1 ' MB
                     Print #StdoutHandle, "CPU MB memory monitor on."
                  Case 1
                     CPUMON = 2 ' GB
                     Print #StdoutHandle, "CPU GB memory monitor on."
                  Case 2
                     CPUMON = 0
                     Print #StdoutHandle, "CPU memory monitor off."
               End Select
            Else
               Print #StdoutHandle, "Type CPU /? for help."
            End If
         End If
      End If
   Else
      Print #StdoutHandle, "Type HELP for help."
   End If
   Exit Sub

   MonitorFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "monitor" Then
      If MONITORON = 0 Then
         Print #StdoutHandle, "Memory monitor not active."
      Else
         Print #StdoutHandle, "Memory monitor active."
         Print #StdoutHandle, "Memory counter set to" + Str$(MonitorTimer) + " seconds."
         Select Case MonitorSuffix
            Case 0 ' mega (default)
               Print #StdoutHandle, "Memory monitor set to" + Str$(MonitorLimit) + " MB."
            Case 1 ' kilo
               Print #StdoutHandle, "Memory monitor set to" + Str$(MonitorLimit * 1000) + " KB."
            Case 2 ' giga
               Print #StdoutHandle, "Memory monitor set to" + Str$(MonitorLimit / (1024)) + " GB."
            Case 3 ' tera
               Print #StdoutHandle, "Memory monitor set to" + Str$(MonitorLimit / (1024 * 1024)) + " TB."
         End Select
      End If
      Exit Sub
   End If
   x1$ = Mid$(x1$, 8) ' monitor
   If Left$(x1$, 1) = " " Then
      x1$ = Mid$(x1$, 2)
      x1$ = RTrim$(LTrim$(x1$))
      If x1$ = "toggle" Then
         If MONITORON Then
            MONITORON = 0
         Else
            MONITORON = -1
         End If
         If MONITORON Then
            Print #StdoutHandle, "Memory Monitor on."
         Else
            Print #StdoutHandle, "Memory Monitor off."
         End If
         Exit Sub
      End If
      If x1$ = "off" Then
         MONITORON = 0
         Print #StdoutHandle, "Memory monitor off."
      Else
         If x1$ = "on" Then
            MONITORON = -1
            Print #StdoutHandle, "Memory monitor on."
            MonitorCount = 0
         Else
            If Left$(x1$, 5) = "limit" Then
               x1$ = LTrim$(Mid$(x1$, 6))
               If Left$(x1$, 1) = "=" Then
                  x1$ = Mid$(x1$, 2)
               End If
               G = 0
               K = 0
               T = 0
               x1$ = LTrim$(RTrim$(x1$))
               z1$ = Right$(x1$, 1)
               If z1$ >= "a" And z1$ <= "z" Then
                  If z1$ = "k" Or z1$ = "m" Or z1$ = "g" Or z1$ = "t" Then
                     ' eat
                  Else
                     Print #StdoutHandle, "Type MONITOR /? for help."
                     Exit Sub
                  End If
               End If
               If Right$(x1$, 1) = "t" Then ' terabytes
                  x1$ = Left$(x1$, Len(x1$) - 1)
                  T = -1
               End If
               If Right$(x1$, 1) = "g" Then ' gigabytes
                  x1$ = Left$(x1$, Len(x1$) - 1)
                  G = -1
               End If
               If Right$(x1$, 1) = "m" Then ' megabytes
                  x1$ = Left$(x1$, Len(x1$) - 1)
                  'm = -1 default
               End If
               If Right$(x1$, 1) = "k" Then ' kilobytes
                  x1$ = Left$(x1$, Len(x1$) - 1)
                  K = -1
               End If
               If IsSingle(x1$) Then
                  X# = Val(x1$)
                  If X# = 0# Then
                     MONITORON = 0
                     Print #StdoutHandle, "Memory monitor off."
                  Else
                     If X# > 0# Then
                        MonitorCount = 0
                        MonitorSuffix = 0
                        If K Then ' kilobytes
                           MONITORON = -1
                           MonitorLimit = X# / 1000#
                           MonitorSuffix = 1
                           Print #StdoutHandle, "Memory monitor set to" + Str$(X#) + " KB."
                        Else
                           If G Then ' gigabytes
                              MONITORON = -1
                              MonitorLimit = X# * 1024#
                              MonitorSuffix = 2
                              Print #StdoutHandle, "Memory monitor set to" + Str$(X#) + " GB."
                           Else
                              If T Then ' terabytes
                                 MONITORON = -1
                                 MonitorLimit = X# * 1024# * 1024#
                                 MonitorSuffix = 3
                                 Print #StdoutHandle, "Memory monitor set to" + Str$(X#) + " TB."
                              Else ' default megabytes
                                 MONITORON = -1
                                 MonitorLimit = X#
                                 MonitorSuffix = 0
                                 Print #StdoutHandle, "Memory monitor set to" + Str$(X#) + " MB."
                              End If
                           End If
                        End If
                     Else
                        Print #StdoutHandle, "Type MONITOR /? for help."
                     End If
                  End If
               Else
                  Print #StdoutHandle, "Type MONITOR /? for help."
               End If
            Else
               If Left$(x1$, 5) = "timer" Then
                  x1$ = LTrim$(Mid$(x1$, 6))
                  If Left$(x1$, 1) = "=" Then
                     x1$ = Mid$(x1$, 2)
                  End If
                  x1$ = LTrim$(RTrim$(x1$))
                  If IsNumeric(x1$) Then
                     X# = Val(x1$)
                     If X# = 0# Then
                        MONITORON = 0
                        Print #StdoutHandle, "Memory monitor off."
                     Else
                        If X# > 0# Then
                           If X# <= 86400# Then
                              X! = CSng(X#)
                              MONITORON = -1
                              MonitorCount = 0
                              MonitorTimer = X!
                              Print #StdoutHandle, "Memory counter set to" + Str$(MonitorTimer) + " seconds."
                           End If
                        Else
                           Print #StdoutHandle, "Type MONITOR /? for help."
                        End If
                     End If
                  Else
                     Print #StdoutHandle, "Type MONITOR /? for help."
                  End If
               Else
                  Print #StdoutHandle, "Type MONITOR /? for help."
               End If
            End If
         End If
      End If
   Else
      Print #StdoutHandle, "Type HELP for help."
   End If
   Exit Sub

   PushdFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "pushd" Then
      If PathCount = 1 Then
         Print #StdoutHandle, "No paths in table."
      Else
         Print #StdoutHandle, Str$(PathCount - 1) + " paths in table."
      End If
      Exit Sub
   End If
   x1$ = Mid$(x1$, 6) ' pushd
   x1$ = RTrim$(LTrim$(x1$))
   If Left$(x1$, 1) = Quote Then
      x1$ = Mid$(x1$, 2)
   End If
   If Right$(x1$, 1) = Quote Then
      x1$ = Left$(x1$, Len(x1$) - 1)
   End If
   f$ = x1$ + Chr$(0)
   r = SetCurrentDirectoryA(f$)
   If r = 0 Then
      Call DisplayWinError(r)
      Exit Sub
   End If
   PathCount = PathCount + 1
   If PathCount > PathMax Then
      PathMax = PathMax + 1
      ReDim _Preserve PathTable(PathMax) As String
   End If
   PathTable(PathCount) = _CWD$
   Exit Sub

   PopdFunc:
   If PathCount = 1 Then
      Print #StdoutHandle, "No paths in table."
      Exit Sub
   End If
   PathCount = PathCount - 1
   f$ = PathTable(PathCount) + Chr$(0)
   r = SetCurrentDirectoryA(f$)
   If r = 0 Then
      Call DisplayWinError(r)
   End If
   Exit Sub

   ' compare contents of 2 directoires.
   CompareFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "compdir" Then
      x1$ = Nul
      CountOnly = 0
   Else
      x1$ = Mid$(x1$, 8) ' compdir
      x1$ = RTrim$(LTrim$(x1$))
      CountOnly = 0
      V = InStr(x1$, "count")
      If V Then
         CountOnly = -1
         x1$ = Left$(x1$, V - 1) + Mid$(x1$, V + 5) ' count
      End If
      x1$ = RTrim$(LTrim$(x1$))
      If Left$(x1$, 2) = "/f" Then
         x1$ = Mid$(x1$, 3)
         If Left$(x1$, 1) = Quote Then
            Q = InStr(2, x1$, Quote)
            If Q Then
               f$ = Mid$(x1$, 2): f$ = Left$(f$, InStr(f$, Quote) - 1)
               x1$ = LTrim$(RTrim$(Mid$(x1$, Q + 1)))
            End If
         End If
         x1$ = RTrim$(LTrim$(x1$))
         If Left$(x1$, 2) = "/g" Then
            x1$ = Mid$(x1$, 3)
            If Left$(x1$, 1) = Quote Then
               Q = InStr(2, x1$, Quote)
               If Q Then
                  g$ = Mid$(x1$, 2): g$ = Left$(g$, InStr(g$, Quote) - 1)
                  x1$ = LTrim$(RTrim$(Mid$(x1$, Q + 1)))
                  If f$ <> "" And g$ <> "" Then
                     Color Plain
                     Print #StdoutHandle, "Match "; f$; " with "; g$
                     If _DirExists(f$) And _DirExists(g$) Then
                        Call VerifyFiles(f$, g$, CountOnly)
                     Else
                        Print #StdoutHandle, "Paths not found."
                     End If
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
      If x1$ <> "" Then
         Print #StdoutHandle, "Type COMPDIR /? for help."
         Exit Sub
      End If
   End If

   Color White
   f$ = _SelectFolderDialog$("Enter first directory", _CWD$)
   If f$ <> "" Then
      Color White
      g$ = _SelectFolderDialog$("Enter second directory", _CWD$)
      If g$ <> "" Then
         If _DirExists(f$) And _DirExists(g$) Then
            Color Plain
            Call VerifyFiles(f$, g$, CountOnly)
            Exit Sub
         End If
      End If
   End If
   Color White
   Print #StdoutHandle, "Paths not found."
   Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
   Exit Sub

   ' compare 2 files.
   CompareFunc2:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "compfile" Then
      x1$ = Nul
      ByteList = 0
   Else
      x1$ = Mid$(x1$, 9) ' compfile
      x1$ = RTrim$(LTrim$(x1$))
      ByteList = 0
      V = InStr(x1$, "list")
      If V Then
         ByteList = -1
         x1$ = Left$(x1$, V - 1) + Mid$(x1$, V + 4) ' list
      End If
      x1$ = RTrim$(LTrim$(x1$))
      If Left$(x1$, 2) = "/f" Then
         x1$ = Mid$(x1$, 3)
         If Left$(x1$, 1) = Quote Then
            Q = InStr(2, x1$, Quote)
            If Q Then
               f$ = Mid$(x1$, 2): f$ = Left$(f$, InStr(f$, Quote) - 1)
               x1$ = LTrim$(RTrim$(Mid$(x1$, Q + 1)))
            End If
         End If
         x1$ = RTrim$(LTrim$(x1$))
         If Left$(x1$, 2) = "/g" Then
            x1$ = Mid$(x1$, 3)
            If Left$(x1$, 1) = Quote Then
               Q = InStr(2, x1$, Quote)
               If Q Then
                  g$ = Mid$(x1$, 2): g$ = Left$(g$, InStr(g$, Quote) - 1)
                  x1$ = LTrim$(RTrim$(Mid$(x1$, Q + 1)))
                  If f$ <> "" And g$ <> "" Then
                     Color Plain
                     Print #StdoutHandle, "Match "; f$; " with "; g$
                     If _FileExists(f$) And _FileExists(g$) Then
                        Call VerifyFiles2(f$, g$, ByteList)
                     Else
                        Print #StdoutHandle, "Files not found."
                     End If
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
      If x1$ <> "" Then
         Print #StdoutHandle, "Type COMPFILE /? for help."
         Exit Sub
      End If
   End If

   Filter$ = "All files (*.*)|*.*"
   Title$ = "QB64Shell Open File" + Chr$(0)
   f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)
   If f$ <> "" Then
      Filter$ = "All files (*.*)|*.*"
      Title$ = "QB64Shell Open File" + Chr$(0)
      g$ = _OpenFileDialog$(Title$, StartDir$, Filter$)
      If g$ <> "" Then
         If _FileExists(f$) And _FileExists(g$) Then
            Color Plain
            Call VerifyFiles2(f$, g$, ByteList)
            Exit Sub
         End If
      End If
   End If
   Color White
   Print #StdoutHandle, "Files not found."
   Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
   Exit Sub

   FileListFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "listfile" Then
      Var1$ = "*.*"
   Else
      x1$ = Mid$(x1$, 9) ' listfile
      Var1$ = RTrim$(LTrim$(x1$))
   End If
   Call CallListFiles(Var1$, -1)
   If LCase$(StdoutFile$) = "scrn:" Then
      Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
   End If
   Exit Sub

   DirListFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "listdir" Then
      Var1$ = "*.*"
   Else
      x1$ = Mid$(x1$, 8) ' listdir
      Var1$ = RTrim$(LTrim$(x1$))
   End If
   Call CallListFiles(Var1$, 0)
   If LCase$(StdoutFile$) = "scrn:" Then
      Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
   End If
   Exit Sub

   AllListFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "listall" Then
      Var1$ = "*.*"
   Else
      x1$ = Mid$(x1$, 8) ' listall
      x1$ = RTrim$(LTrim$(x1$))
      If Left$(x1$, 4) = "/all" Then
         Var1$ = Mid$(x1$, 5)
         Var1$ = RTrim$(LTrim$(Var1$))
         StoreF$ = Var1$
         Call CallListFiles(StoreF$, -2) ' both
         If LCase$(StdoutFile$) = "scrn:" Then
            Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
         End If
         Exit Sub
      End If
      If Left$(x1$, 5) = "/both" Then
         Var1$ = Mid$(x1$, 6)
         Var1$ = RTrim$(LTrim$(Var1$))
         StoreF$ = Var1$
         Call CallListFiles(StoreF$, -2) ' both
         If LCase$(StdoutFile$) = "scrn:" Then
            Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
         End If
         Exit Sub
      End If
      Var1$ = RTrim$(LTrim$(x1$))
   End If
   StoreF$ = Var1$
   Call CallListFiles(StoreF$, 0) ' dirs
   If LCase$(StdoutFile$) = "scrn:" Then
      Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
   End If
   Call CallListFiles(StoreF$, -1) ' files
   If LCase$(StdoutFile$) = "scrn:" Then
      Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
   End If
   Exit Sub

   DriveListFunc:
   x1$ = Mid$(x1$, 10) ' listdrive
   Var1$ = RTrim$(LTrim$(x1$))
   Call ListDrives(Var1$)
   Exit Sub

   StatusFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "status" Then
      Print #StdoutHandle, "Type STATUS /? for help."
      Exit Sub
   End If
   x1$ = Mid$(x1$, 7)
   If Left$(x1$, 1) = " " Then
      x1$ = Mid$(x1$, 2)
      x1$ = RTrim$(LTrim$(x1$))
      If x1$ = "off" Then
         If Status Then
            Call SaveScreen
            SOFF = -1
            Status = 0
            View Print 2 To 24
            Color Plain
            Cls
            Call RestoreScreen
            Locate 23, 1, 1
            Color White
            Call DisplayPrompt
            Print
            Locate 24, 1, 1
         End If
      Else
         If x1$ = "on" Then
            If Status = 0 Then
               Call SaveScreen
               SOFF = 0
               Status = -1
               Locate 24, 1, 1
               Color Yellow
               Call DisplayVersion
               View Print 2 To 23
               Color Plain
               Cls
               Call RestoreScreen
               Print
               Locate 23, 1, 1
            End If
         Else
            Print #StdoutHandle, "Type STATUS /? for help."
         End If
      End If
   Else
      Print #StdoutHandle, "Type HELP for help."
   End If
   Exit Sub

   KeyFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "key" Then
      Print #StdoutHandle, "Type KEY /? for help."
      Exit Sub
   End If
   x1$ = Mid$(x1$, 4)
   If Left$(x1$, 1) = " " Then
      x1$ = Mid$(x1$, 2)
      x1$ = RTrim$(LTrim$(x1$))
      If x1$ = "on" Then
         KEYOFF = 0
         Key On
      Else
         If x1$ = "off" Then
            KEYOFF = -1
            Key Off
         Else
            If x1$ = "list" Then
               Key List
            Else
               If x1$ = "reset" Then
                  Call ReadKeys
                  Call SetKeys
                  Print #StdoutHandle, "Keys reset."
               Else
                  y$ = Mid$(x$, 4)
                  y = InStr(y$, ",")
                  If y Then
                     z = Val(Left$(y$, y - 1))
                     z$ = Mid$(y$, y + 1)
                     If z >= 1 And z <= 12 Then
                        Q = z
                        If z = 11 Then z = 30
                        If z = 12 Then z = 31
                        If LCase$(Right$(z$, 3)) = "+cr" Then
                           z$ = Left$(z$, Len(z$) - 3) + Chr$(13)
                        End If
                        Key z, z$
                        FunctionKeys(Q) = z$
                     Else
                        Print #StdoutHandle, "Type KEY /? for help."
                     End If
                  Else
                     Print #StdoutHandle, "Type KEY /? for help."
                  End If
               End If
            End If
         End If
      End If
   Else
      Print #StdoutHandle, "Type HELP for help."
   End If
   Exit Sub

   AbortProgram:
   Call WriteConfig
   Call WriteProfile
   Call PutUserStats(V#)
   Color Plain, Black
   System
   Exit Sub

   QuitProgram:
   If QuitBox Then
      Call WriteConfig
      Call WriteProfile
      Call PutUserStats(V#)
      Color Plain, Black
      System
   End If
   Exit Sub

   MenuFunc:
   Call Menu
   Exit Sub

   MemFunc:
   If x1$ = "mem" Then
      Print #StdoutHandle, "Total Physical Memory: "; FormatString$(CDbl(TotalPhysicalMem))
      Print #StdoutHandle, "Free Physical Memory: "; FormatString$(CDbl(FreePhysicalMem))
      Used# = CDbl(TotalPhysicalMem) - CDbl(FreePhysicalMem)
      Print #StdoutHandle, "Used Physical Memory: "; FormatString$(Used#)
   Else
      x1$ = Mid$(x1$, 4)
      If Left$(x1$, 1) = " " Then
         If LTrim$(RTrim$(Mid$(x1$, 2))) = "paging" Then
            Print #StdoutHandle, "Total Paging File: "; FormatString$(CDbl(TotalPagingFile))
            Print #StdoutHandle, "Free Paging File: "; FormatString$(CDbl(FreePagingFile))
            Used# = CDbl(TotalPagingFile) - CDbl(FreePagingFile)
            Print #StdoutHandle, "Used Paging File: "; FormatString$(Used#)
         Else
            If LTrim$(RTrim$(Mid$(x1$, 2))) = "virtual" Then
               Print #StdoutHandle, "Total Virtual Memory: "; FormatString$(CDbl(TotalVirtualMem))
               Print #StdoutHandle, "Free Virtual Memory: "; FormatString$(CDbl(FreeVirtualMem))
               Used# = CDbl(TotalVirtualMem) - CDbl(FreeVirtualMem)
               Print #StdoutHandle, "Used Virtual Memory: "; FormatString$(Used#)
            Else
               Print #StdoutHandle, "Type MEM /? for help."
            End If
         End If
      Else
         Print #StdoutHandle, "Type HELP for help."
      End If
   End If
   Exit Sub

   ClockFunc:
   Print #StdoutHandle, clock$(0)
   Exit Sub

   VerFunc:
   Print #StdoutHandle, Program + " " + FullVersion$
   Exit Sub

   ClsFunc:
   Cls
   Exit Sub

   BlankFunc:
   s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
   Exit Sub

   EditFunc:
   If x1$ = "edit" Then
      Call SaveScreen
      If File.Loaded Then
         If ErrorBox(" EditFile ", "Continue editing?") Then
            VarC = -1
            GoTo EditFunc1
         End If
      End If
      EditFlag = 0
      Var$ = FilenameBox$(3)
      If Var$ = "" Then
         Exit Sub
      End If
      VarC = 0
      GoTo EditFunc1
   Else
      EditFlag = 0
      x1$ = Mid$(x1$, 5)
      If Left$(x1$, 1) = " " Then
         Var$ = Mid$(x1$, 2)
         Var$ = RTrim$(LTrim$(Var$))
         If Len(Var$) Then
            If LCase$(Var$) = "config" Then
               EditFlag = -1
               Var$ = GetMenuConfigFilename$
            End If
            Call SaveScreen
            VarC = 0
            GoTo EditFunc1
         End If
         Print #StdoutHandle, "Type EDIT /? for help."
      Else
         Print #StdoutHandle, "Type HELP for help."
      End If
   End If
   Exit Sub

   EditFunc1:
   View Print 1 To 25
   Key Off
   Cls
   Color White, Black
   Locate 25, 1
   If Left$(Var$, 1) = Quote Then
      If Right$(Var$, 1) = Quote Then
         Var$ = Left$(Var$, Len(Var$) - 1)
         Var$ = Mid$(Var$, 2)
      End If
   End If
   Call ClearKeys
   Call ScrnEdit(Var$, VarZ, VarC)
   Call SetKeys
   Var1$ = Nul
   Var2$ = Nul
   If VarZ Then
      If VarZ = -1 Then
         Var1$ = " Saved "
         Var2$ = "File stored to disk."
      Else
         If VarZ = -2 Then
            Var1$ = " Error "
            Var2$ = "Error creating file."
         Else
            If VarZ = -3 Then
               Var1$ = " Error "
               Var2$ = "Invalid filename."
            Else
               If VarZ = -4 Then
                  Var1$ = " Error "
                  Var2$ = "Interrupt."
               Else
                  If VarZ = -5 Then
                     Var1$ = " Error "
                     Var2$ = "Overflow."
                  End If
               End If
            End If
         End If
      End If
   End If
   Call Toolbar
   If Status = 0 Then
      View Print 2 To 24
      Color Plain
      Cls
      Call RestoreScreen
      Locate 23, 1, 1
      Color White
      Call DisplayPrompt
      Print
      Locate 24, 1, 1
   Else
      Locate 24, 1, 1
      Color Yellow
      Call DisplayVersion
      View Print 2 To 23
      Color Plain
      Cls
      Call RestoreScreen
   End If
   If KEYOFF = 0 Then
      Key On
   End If
   If Len(Var1$) Then
      VarX = MessageBox(Var1$, Var2$)
   End If
   If VarZ = -1 Then
      If EditFlag Then
         Call ReadConfigFile
      End If
   End If
   Exit Sub

   ViewFunc:
   If x1$ = "viewfile" Then
      Var$ = FilenameBox$(3)
      If Var$ = "" Then
         Exit Sub
      End If
      If _FileExists(Var$) Then
         Call ViewFileInfo(Var$)
      Else
         Print #StdoutHandle, "File not found."
      End If
   Else
      x1$ = Mid$(x1$, 9)
      If Left$(x1$, 1) = " " Then
         Var$ = Mid$(x1$, 2)
         Var$ = RTrim$(LTrim$(Var$))
         If Var$ = "" Then
            Exit Sub
         End If
         If _FileExists(Var$) Then
            Call ViewFileInfo(Var$)
         Else
            Print #StdoutHandle, "File not found."
         End If
      Else
         Print #StdoutHandle, "Type HELP for help."
      End If
   End If
   Exit Sub

   RedrawFunc:
   View Print 1 To 25
   Key Off
   Cls
   Color White, Black
   Locate 25, 1
   Call Toolbar
   If Status = 0 Then
      View Print 2 To 24
      Color Plain
      Locate 24, 1, 1
   Else
      Locate 24, 1, 1
      Color Yellow
      Call DisplayVersion
      View Print 2 To 23
      Color Plain
      Locate 23, 1, 1
   End If
   If KEYOFF = 0 Then
      Key On
   End If
   Exit Sub

   HexCalcFunc:
   Call HexCalc
   Exit Sub

   AsciiChartFunc:
   Call AsciiChart
   Exit Sub

   HexChartFunc:
   Call HexChart
   Exit Sub

   WhatisFunc:
   x1$ = Mid$(x1$, 7)
   x$ = LTrim$(x1$)
   If LCase$(x$) = "box" Then
      r = WhatisBox("sqr(2)", "")
   Else
      x = -2
   End If
   Exit Sub

   TableFunc:
   x1$ = Mid$(x1$, 6)
   x$ = LTrim$(x1$)
   Call DisplayTable(x$)
   Exit Sub

   AlarmFunc:
   x1$ = Mid$(x1$, 6)
   x$ = LTrim$(x1$)
   If x$ <> "" Then
      Call AlarmMenu(x$)
   Else
      Call AlarmMenu("HELP")
   End If
   Exit Sub

   HelpFunc:
   If x1$ = "help" Then
      Call DisplayHelp("commands")
   Else
      x1$ = Mid$(x1$, 5)
      If Left$(x1$, 1) = " " Then
         x1$ = Mid$(x1$, 2)
         x1$ = RTrim$(x1$)
         Call DisplayHelp(x1$)
      Else
         Print #StdoutHandle, "Type HELP for help."
      End If
   End If
   Exit Sub

   PromptFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "prompt" Then
      Print #StdoutHandle, "Prompt is "; Prompt$
      Exit Sub
   End If
   x1$ = Mid$(x1$, 7)
   If Left$(x1$, 1) = " " Then
      x$ = Mid$(x$, 8)
      If x$ = "edit" Then
         Color White
         Print "Prompt?";
         x$ = LineInput$(CsrLin, Pos(0), 20): Print
         If Len(x$) Then
            Prompt$ = x$
         End If
         Exit Sub
      End If
      Prompt$ = x$
   Else
      Print #StdoutHandle, "Type PROMPT /? for help."
   End If
   Exit Sub

   ColorsFunc:
   x1$ = RTrim$(LTrim$(x1$))
   If x1$ = "color" Then
      Print #StdoutHandle, "Type COLOR /? for help."
      Exit Sub
   End If
   x1$ = Mid$(x1$, 6)
   If Left$(x1$, 1) = " " Then
      y$ = Mid$(x1$, 2)
      V = InStr(y$, ",")
      If V Then
         f$ = Left$(y$, V - 1)
         b$ = Mid$(y$, V + 1)
         f$ = LTrim$(RTrim$(f$))
         b$ = LTrim$(RTrim$(b$))
         If f$ = "" And b$ = "" Then
            Print #StdoutHandle, "Type COLOR /? for help."
            Exit Sub
         End If
         If Len(f$) And Len(b$) Then
            If GetColor(f$) Then
               fore = GetColor(f$)
               If fore = -1 Then fore = 0
            Else
               fore = Int(Val(f$))
            End If
            If GetColor2(b$) Then
               back = GetColor2(b$)
               If back = -1 Then back = 0
            Else
               back = Int(Val(b$))
            End If
            If fore >= 0 And fore <= 15 And back >= 0 And back <= 7 Then
               PromptForeground = fore
               PromptBackground = back
               Exit Sub
            End If
         Else
            If Len(f$) Then
               If GetColor(f$) Then
                  fore = GetColor(f$)
                  If fore = -1 Then fore = 0
               Else
                  fore = Int(Val(f$))
               End If
               If fore >= 0 And fore <= 15 Then
                  PromptForeground = fore
                  Exit Sub
               End If
            Else
               If Len(b$) Then
                  If GetColor2(b$) Then
                     back = GetColor2(b$)
                     If back = -1 Then back = 0
                  Else
                     back = Int(Val(b$))
                  End If
                  If back >= 0 And back <= 7 Then
                     PromptBackground = back
                     Exit Sub
                  End If
               End If
            End If
         End If
      Else
         If GetColor(y$) Then
            fore = GetColor(y$)
            If fore = -1 Then fore = 0
         Else
            fore = Int(Val(y$))
         End If
         If fore >= 0 And fore <= 15 Then
            PromptForeground = fore
            Exit Sub
         End If
      End If
      Print #StdoutHandle, "Type COLOR /? for help."
   Else
      Print #StdoutHandle, "Type HELP for help."
   End If
End Sub

Sub DisplayVersion
   V$ = Program + " " + FullVersion$ + " OS " + _OS$
   V$ = Left$(V$, 79)
   Print V$;
End Sub

Sub DisplayHelp (V$)
   Select Case V$
      Case "search"
         Print #StdoutHandle, "SEARCH <filespec>"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Starts the filename list window"
         Print #StdoutHandle, "  which scans files and edits any file."
         Print #StdoutHandle, "  optional filespec to search."
      Case "viewfile"
         Print #StdoutHandle, "VIEWFILE [FILE]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Prompts and displays info of a filename."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Where:"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Optional file displays the file info."
      Case "play"
         Print #StdoutHandle, "PLAY LOAD/FONT/TYPES/LIST/MELODY/LENGTH/STOP/PAUSE/RESUME/VOLUME/MOVE"
         Print #StdoutHandle, " or <filename.ext>"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  plays default sound file."
         Print #StdoutHandle, "    'Load' plays soundfile from dialog box."
         Print #StdoutHandle, "    'Font' loads soundfile font from dialog box."
         Print #StdoutHandle, "    'Types' displays list of sound file extensions."
         Print #StdoutHandle, "    'List' displays list of all sound filenames."
         Print #StdoutHandle, "    'Melody' plays music variable."
         Print #StdoutHandle, "    'Length' displays music file length."
         Print #StdoutHandle, "    'Stop' closes and stops music being played."
         Print #StdoutHandle, "    'Pause' halts current music being playing."
         Print #StdoutHandle, "    'Resume' continues currently halted music."
         Print #StdoutHandle, "    'Volume' inceases/decreases using +/- or value between 0 and 1."
         Print #StdoutHandle, "    'Move' resets currently played music plus 10 seconds."
         Print #StdoutHandle, "      optional Move -<n> or +<n> moves less or more in <n> seconds."
         Print #StdoutHandle, "  Also specifies filename to play."
      Case "table"
         Print #StdoutHandle, "TABLE"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Displays drive/netpath tables."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "TABLE [OPTION]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Searches tables for string option."
         Print #StdoutHandle, "  May contain ? and * characters."
      Case "alarm", "alarms"
         VarZ = -1
         Color White
         Print #StdoutHandle, "Helplist for alarms.."
         Color Yellow
         Print #StdoutHandle, "ALARM [OPTION]"
         Print #StdoutHandle, " ON/OFF"
         Print #StdoutHandle, "  Sets alarm trap on or off."
         Print #StdoutHandle, " SET"
         Print #StdoutHandle, "  Sets seconds per alarm for" + Str$(MaxAlarms) + " alarms."
         Print #StdoutHandle, " BEEP"
         Print #StdoutHandle, "  Toggles alarm beeps."
         Print #StdoutHandle, " CLEAR"
         Print #StdoutHandle, "  Clears all alarms."
         Print #StdoutHandle, " LIST"
         Print #StdoutHandle, "  Lists settings for all alarms set."
         Print #StdoutHandle, " COUNT"
         Print #StdoutHandle, "  Displays number of alarms set."
         Print #StdoutHandle, " TYPE"
         Print #StdoutHandle, "  Toggles alarm time display."
         Print #StdoutHandle, " COLOR"
         Print #StdoutHandle, "  Sets alarm colors."
         Print #StdoutHandle, " MUSIC"
         Print #StdoutHandle, "  Toggles alarm music play."
      Case "copy", "history"
         Call History
      Case "shell"
         Print #StdoutHandle, "SHELL"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Shells to DOS"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "SHELL <command>"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Shells to DOS and performs command."
      Case "redraw"
         Print #StdoutHandle, "REDRAW"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Redraws the main shell screen."
      Case "menu"
         Print #StdoutHandle, "MENU"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Starts simple menu function for access to files/directories."
      Case "date"
         Print #StdoutHandle, "DATE [dd-mm-yyyy]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Displays and sets date."
      Case "time"
         Print #StdoutHandle, "TIME [hh:mm:ss]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Displays and sets time."
      Case "toggle"
         Print #StdoutHandle, "TOGGLE"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Toggles full screen mode."
      Case "cpu"
         Print #StdoutHandle, "CPU [ON][OFF][MEMORY]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Turns cpu status on or off."
         Print #StdoutHandle, "  'memory' toggles memory usage on or off."
      Case "screensaver"
         Print #StdoutHandle, "SCREENSAVER [ON][OFF][BLANK][<n>]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Turns screensaver on, off, blank, or sets to <n> seconds."
         Print #StdoutHandle, "  Specify SCREENSAVER HH:MM:SS for valid time set on."
         Print #StdoutHandle, "     Specify SCREENSAVER <n>s valid time set seconds."
         Print #StdoutHandle, "     Specify SCREENSAVER <n>m valid time set minutes."
         Print #StdoutHandle, "     Specify SCREENSAVER <n>h valid time set hours."
      Case "graburl"
         Print #StdoutHandle, "GRABURL [TEST]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Starts a url filename download."
         Print #StdoutHandle, "  Optional Test for existing url filename."
      Case "debug"
         Print #StdoutHandle, "DEBUG [ON][OFF][TOGGLE]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Toggles/Turns debug on or off."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Other debug functions:"
         Print #StdoutHandle, "    Test - tests a square root of -1"
         Print #StdoutHandle, "    Error - tests a windows error."
         Print #StdoutHandle, "    Errorbox - tests an error box."
         Print #StdoutHandle, "    Messagebox - tests the message box."
         Print #StdoutHandle, "    Monitorbox - tests the monitor box."
         Print #StdoutHandle, "    Timetype - displays the timer type."
         Print #StdoutHandle, "    Sound - plays the THX sound file."
         Print #StdoutHandle, "    Mouse - tests mouse."
         Print #StdoutHandle, "    Wheelreverse - Toggles mouse wheel."
         Print #StdoutHandle, "    Errorlog - displays content of critical errorlog file."
         Print #StdoutHandle, "    Copyerrorlog - displays content of copyit errorlog file."
      Case "status"
         Print #StdoutHandle, "STATUS [ON][OFF]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Turns status line on or off."
      Case "key"
         Print #StdoutHandle, "KEY [ON][OFF][LIST][RESET][<n>,<text>]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Turns key statusline on, off, lists current keys, resets keys,"
         Print #StdoutHandle, "  assigns <text> to a key number to <n> from 1 to 12."
      Case "system"
         Print #StdoutHandle, "SYSTEM"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Abort program and exit to system."
      Case "quit"
         Print #StdoutHandle, "QUIT"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Quit program and exit to system."
      Case "mem"
         Print #StdoutHandle, "MEM [VIRTUAL][PAGING]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Display total/free/used physical system RAM."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "    'virtual' displays virtual RAM."
         Print #StdoutHandle, "    'paging' displays paging file RAM."
      Case "clock"
         Print #StdoutHandle, "CLOCK"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Display current date and time."
      Case "ver"
         Print #StdoutHandle, "VER"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Display program version."
      Case "mapper"
         Print #StdoutHandle, "MAPPER [LIST][RESET][SAVE][LOAD]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Starts the keyboard mapper."
         Print #StdoutHandle, "    'list' all keyboard scancodes."
         Print #StdoutHandle, "    'reset' clear all keymap arrays."
         Print #StdoutHandle, "    'save' save key map arrays."
         Print #StdoutHandle, "    'load' load key map arrays."
      Case "cls"
         Print #StdoutHandle, "CLS"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Clears text screen viewport."
      Case "edit"
         Print #StdoutHandle, "EDIT"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Starts the full screen editor."
      Case "hexcalc"
         Print #StdoutHandle, "HEXCALC"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Starts the Hexidecimal-Decimal calculator."
      Case "ascii"
         Print #StdoutHandle, "ASCII"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Displays charts of ASCII values and characters."
      Case "hexchart"
         Print #StdoutHandle, "HEXCHART"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Displays charts of hexidecimal values and characters."
      Case "whatis"
         Print #StdoutHandle, "WHATIS [BOX]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Starts the recursive descent parser."
         Print #StdoutHandle, "  Optional 'box' starts the recursive descent parser whatisbox."
      Case "help"
         Print #StdoutHandle, "HELP [COMMAND]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Displays commands available or help for specific command."
      Case "prompt"
         Print #StdoutHandle, "PROMPT [edit]|[text]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Changes the QB64shell command prompt."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "    text    Specifies a new command prompt."
         Print #StdoutHandle, "    edit    Prompts for prompt value."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Prompt can contain the following special codes:"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "    $D   Current date      $T   Current time"
         Print #StdoutHandle, "    $N   Current drive     $P   Current drive and path"
         Print #StdoutHandle, "    $Q   Current volume    $V   QB64shell version"
         Print #StdoutHandle, "    $R   QB64shell release $B   QB64shell build"
         Print #StdoutHandle, "    $H   Backspace         $_   Carriage return and linefeed"
         Print #StdoutHandle, "    $J   Clear screen      $$   Display a $ character."
         Print #StdoutHandle, "    $G   Display > symbol  $L   Display a < symbol"
         Print #StdoutHandle, "    $M   Display | symbol  $F[x;y]  Set cursor"
         Print #StdoutHandle, "    $S   Store cursor      $U   Restore cursor"
         Print #StdoutHandle, "    $X   Display space     $Z   Display clock"
         Print #StdoutHandle, "    $C[n]  Change foreground color   $E[n]  Change background color"
         Print #StdoutHandle, "    $W[<exp$>]  Display parsed value $A[<n>]  Insert ascii code."
      Case "color"
         Print #StdoutHandle, "COLOR <foreground>,<background>"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Changes the shell prompt color."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Color code values:"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Fore/Background  Foreground"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "   0  Black         8  Gray"
         Print #StdoutHandle, "   1  Blue          9  Light Blue"
         Print #StdoutHandle, "   2  Green        10  Light green"
         Print #StdoutHandle, "   3  Cyan         11  Light cyan"
         Print #StdoutHandle, "   4  Red          12  Light red"
         Print #StdoutHandle, "   5  Magenta      13  Light magenta"
         Print #StdoutHandle, "   6  Brown        14  Yellow"
         Print #StdoutHandle, "   7  White        15  High-intensity white"
      Case "commandlist"
         Call InitData(1)
      Case "commands"
         Print #StdoutHandle, "QB64shell commands:"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Basic commands:"
         Print #StdoutHandle, "  CLS     CPU       KEY       MEM       VER      TOGGLE   MONITOR"
         Print #StdoutHandle, "  CLOCK   DATE      TIME      MENU      HELP     EDIT     PROFILES"
         Print #StdoutHandle, "  DEBUG   COLOR     PROMPT    STATUS    SYSTEM   QUIT     SEARCH"
         Print #StdoutHandle, "  ASCII   HEXCHART  HEXCALC   REDRAW    WHATIS   COUNT    TABLE"
         Print #StdoutHandle, "  ALARM   PLAY      HISTORY   MAPPER    SCREENSAVER"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Filters:  FIND      MORE      SORT      TYPE     TEE"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Filename commands:"
         Print #StdoutHandle, "  COMPFILE COPY     DELETE    DIR/FILES MKFILE    RENAME"
         Print #StdoutHandle, "  ENCRYPT  DECRYPT  GETATTR   SETATTR   LISTFILE  TOUCHFILE"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Directory commands: COMPDIR   LISTDIR   PUSHD     POPD"
         Print #StdoutHandle, "  TREEDIR  TREEDEL  TOUCHDIR  CHDIR     MKDIR     RMDIR"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Volume commands:"
         Print #StdoutHandle, "  DRIVES   LABEL    VOL       LISTDRIVE SERIAL    FATTYPE"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "See also " + Quote + "HELP STREAM" + Quote + " for additional command parsing."
      Case "stream"
         Print #StdoutHandle, "Streaming is done using the following symbols on the command line:"
         Print #StdoutHandle, "  <  redirect input from file."
         Print #StdoutHandle, "  >  redirect output to file."
         Print #StdoutHandle, "  >>  append redirected output to file."
         Print #StdoutHandle, "  >>>  append errors to file."
         Print #StdoutHandle, "  |   redirect i/o from command to next."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Example usage:"
         Print #StdoutHandle, "   Dir *.lst /c | Copyit /dtemp /c"
         Print #StdoutHandle, "   Treedir temp*.* /r/b/c | Dir *.lst /c"
         Print #StdoutHandle, "   Type Filelist.txt /c | Sort /c > output.lst"
      Case "profiles"
         Print #StdoutHandle, "PROFILES [ON][OFF][LIST][EDIT]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Turns profiles on or off, lists profiles, edits profiles."
      Case "monitor"
         Print #StdoutHandle, "MONITOR [ON][OFF][LIMIT][TIMER]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Turns memory monitor on or off, sets limit and timer."
         Print #StdoutHandle, "     Limit is free RAM in MB. For example, MONITOR LIMIT=20"
         Print #StdoutHandle, "       When appended limit is k/m/g/t sets to kilo/mega/giga/tera bytes."
         Print #StdoutHandle, "       For example: MONITOR LIMIT=2G"
         Print #StdoutHandle, "     Timer is checking in seconds. For example, MONITOR TIMER=60"
      Case "pushd"
         Print #StdoutHandle, "PUSHD <path/netpath>"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Pushs a fully qualified pathname or a network pathname"
         Print #StdoutHandle, "  on the stack and moves default prompt to the path."
      Case "popd"
         Print #StdoutHandle, "POPD"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Pops the current path off the stack."
      Case "compdir"
         Print #StdoutHandle, "COMPDIR [COUNT] [/F" + Quote + "path" + Quote + " /G" + Quote + "path" + Quote + "]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Compares the files in two directories for equivalent"
         Print #StdoutHandle, "  files of same name, size, and content."
         Print #StdoutHandle, "  Optional COUNT only displays number of matching files."
         Print #StdoutHandle, "  Optional /F" + Quote + "path" + Quote + " with /G" + Quote + "path" + Quote + " matchs specified paths."
      Case "compfile"
         Print #StdoutHandle, "COMPFILE [LIST] [/F" + Quote + "file" + Quote + " /G" + Quote + "file" + Quote + "]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Compares two files for equivalent size and contents."
         Print #StdoutHandle, "  Optional LIST displays table of offsets and hex/ascii values."
         Print #StdoutHandle, "  Optional /F" + Quote + "file" + Quote + " with /G" + Quote + "file" + Quote + " matchs specified files."
      Case "listfile"
         Print #StdoutHandle, "LISTFILE [<spec>]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Lists files and files in a specification."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Where the 7 attributes from left to right are:"
         Print #StdoutHandle, "  A - archive"
         Print #StdoutHandle, "  D - directory"
         Print #StdoutHandle, "  S - system"
         Print #StdoutHandle, "  R - read-only"
         Print #StdoutHandle, "  H - hidden"
         Print #StdoutHandle, "  C - compressed"
         Print #StdoutHandle, "  E - encrypted"
      Case "listdir"
         Print #StdoutHandle, "LISTDIR [<spec>]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Lists directories and directories in a specification."
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Where the 7 attributes from left to right are:"
         Print #StdoutHandle, "  A - archive"
         Print #StdoutHandle, "  D - directory"
         Print #StdoutHandle, "  S - system"
         Print #StdoutHandle, "  R - read-only"
         Print #StdoutHandle, "  H - hidden"
         Print #StdoutHandle, "  C - compressed"
         Print #StdoutHandle, "  E - encrypted"
      Case "listall"
         Print #StdoutHandle, "LISTALL [<spec>]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Lists directories/filenames and directories/filenames in a specification."
         Print #StdoutHandle, "  When prepended with /all or /both displays both directories/filenames."
      Case "listdrive"
         Print #StdoutHandle, "LISTDRIVE [<spec>]"
         Print #StdoutHandle, ""
         Print #StdoutHandle, "  Lists current drives, and their labels, volume types, and"
         Print #StdoutHandle, "  free/total/used space. Also specify drive letters as parameters."
      Case Else
         Print #StdoutHandle, "Type HELP /? for help."
   End Select
End Sub

Sub History
   If Username > "" Then
      Call GetUserStats(V#)
      VarQ$ = "COPY stats:"
      If Len(RTrim$(UserProfileRecord2.Username)) Then
         VarQ$ = VarQ$ + " " + RTrim$(UserProfileRecord2.Username)
         If IsUserAnAdmin& Then VarQ$ = VarQ$ + " (admin)" Else VarQ$ = VarQ$ + " (user)"
      End If
      If Len(RTrim$(UserProfileRecord2.LastDateOn)) Then
         VarQ$ = VarQ$ + " (last date on; " + RTrim$(UserProfileRecord2.LastDateOn) + ")"
      End If
      Print #StdoutHandle, VarQ$
      Print #StdoutHandle, " Files copied: " + FormatString$(CDbl(UserProfileRecord2.Reserved1)) + "."
      Print #StdoutHandle, " Bytes copied: " + FormatString$(UserProfileRecord2.Reserved8) + "."
      Print #StdoutHandle, " Files deleted: " + FormatString$(CDbl(UserProfileRecord2.Reserved2)) + "."
      Print #StdoutHandle, " Files edited: " + FormatString$(CDbl(UserProfileRecord2.Reserved5)) + "."
      Print #StdoutHandle, " Bytes edited: " + FormatString$(UserProfileRecord2.Reserved7) + "."
      Print #StdoutHandle, " Directories copied: " + FormatString$(CDbl(UserProfileRecord2.Reserved6)) + "."
      Print #StdoutHandle, " Directories created: " + FormatString$(CDbl(UserProfileRecord2.Reserved3)) + "."
      Print #StdoutHandle, " Directories deleted: " + FormatString$(CDbl(UserProfileRecord2.Reserved4)) + "."
      If Len(RTrim$(UserProfileRecord2.ASCIIZreserved1)) Then
         Print #StdoutHandle, " Last file saved: " + RTrim$(UserProfileRecord2.ASCIIZreserved1)
      End If
      If Len(RTrim$(UserProfileRecord2.ASCIIZreserved2)) Then
         Print #StdoutHandle, " Last file edited: " + RTrim$(UserProfileRecord2.ASCIIZreserved2)
      End If
      Exit Sub
   End If
   Print #StdoutHandle, "User not logged in. Try Relogin instead."
End Sub

Sub HelpAbout
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   ' get box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   If AboutXcoor Then Xcoor3 = AboutXcoor
   If AboutYcoor Then Ycoor3 = AboutYcoor

   ' adjust xcoor
   If Status Then
      Z = 23
      If Xcoor3 + 7 > Z Then
         Xcoor3 = Xcoor3 - 1
      End If
   End If

   ' draw box
   GoSub DrawAboutBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYx$
      If X$ = "" Then
         X& = _KeyHit
         If X& > 0 Then
            If X& = KEY_RALT& Then
               Exit Do
            End If
            If X& = KEY_LALT& Then
               Exit Do
            End If
            If X& = KEY_RSHIFT& Then
               Exit Do
            End If
            If X& = KEY_LSHIFT& Then
               Exit Do
            End If
         End If
      End If
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case Chr$(1) ' ctrl-a
                     X$ = ""
                     BackGround4 = BackGround4 + 1
                     If BackGround4 = 8 Then
                        BackGround4 = 0
                     End If
                     GoSub DrawAboutBox
                  Case Chr$(2) ' ctrl-b
                     X$ = ""
                     BackGround4 = BackGround4 - 1
                     If BackGround4 < 0 Then
                        BackGround4 = 7
                     End If
                     GoSub DrawAboutBox
                  Case Chr$(4) ' ctrl-d
                     X$ = ""
                     AboutBoxBorderColor = AboutBoxBorderColor + 1
                     If AboutBoxBorderColor = 16 Then
                        AboutBoxBorderColor = 0
                     End If
                     GoSub DrawAboutBox
                  Case Chr$(5) ' ctrl-e
                     X$ = ""
                     AboutBoxTitleColor = AboutBoxTitleColor + 1
                     If AboutBoxTitleColor = 16 Then
                        AboutBoxTitleColor = 0
                     End If
                     GoSub DrawAboutBox
                  Case Chr$(6) ' ctrl-f
                     X$ = ""
                     AboutBoxTextColor = AboutBoxTextColor + 1
                     If AboutBoxTextColor = 16 Then
                        AboutBoxTextColor = 0
                     End If
                     GoSub DrawAboutBox
                  Case Else
                     Exit Do
               End Select
            Case 2
               V = Asc(Right$(X$, 1))
               Select Case V
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen2
                     GoSub DrawAboutBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawAboutBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawAboutBox
                     End If
                     _KeyClear
                  Case 75, 115 ' left/ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawAboutBox
                     End If
                     _KeyClear
                  Case 77, 116 ' right/ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawAboutBox
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      If Len(X$) Then
         Exit Do
      End If
      If Status Then
         Z = 23
      Else
         Z = 24
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen2
                        GoSub DrawAboutBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX >= Xcoor3 + 1 And MouseX <= Xcoor3 + 17 Then
               If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
                  Exit Do
               End If
            End If
         End If
      End If
      If MouseButton2 Then
         If MouseX >= Xcoor3 And MouseX <= Xcoor3 + 17 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               Exit Do
            End If
         End If
      End If
      If MouseButton3 Then
         Exit Do
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen2
               GoSub DrawAboutBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            If Status Then
               Z = 23
            Else
               Z = 24
            End If
            X$ = ""
            If Xcoor3 + 7 < Z Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen2
               GoSub DrawAboutBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates.
   AboutXcoor = Xcoor3
   AboutYcoor = Ycoor3

   ' restore screen area.
   Call RestoreScreen2
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   Exit Sub

   ' draw box
   DrawAboutBox:
   Color AboutBoxBorderColor, BackGround4
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);
   Color AboutBoxTitleColor
   Locate Xcoor3, Ycoor3 + 12, 0
   Print " About ";

   ' display about text
   Color AboutBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 1, 0
   Print "Program: " + Program
   Locate Xcoor3 + 2, Ycoor3 + 1, 0
   Print "Version: " + Version + " " + Release
   Locate Xcoor3 + 3, Ycoor3 + 1, 0
   Print "Publish: " + Publish
   Locate Xcoor3 + 4, Ycoor3 + 1, 0
   Print "Author: " + Author
   Locate Xcoor3 + 5, Ycoor3 + 1, 0
   Print "Email: " + Email
   Locate Xcoor3 + 6, Ycoor3 + 1, 0
   Print Urls
   Return
End Sub

Rem MessageBox with OK/Cancel
Function QuitBox
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   ' declare quit box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   If QuitXcoor Then Xcoor3 = QuitXcoor
   If QuitYcoor Then Ycoor3 = QuitYcoor

   ' adjust xcoor
   If Status Then
      Z = 23
      If Xcoor3 + 7 > Z Then
         Xcoor3 = Xcoor3 - 1
      End If
   End If

   ' draw box
   BoxButton = 1
   GoSub DrawQuitBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYz$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "O"
                     BoxButton = 1
                     Exit Do
                  Case "C"
                     BoxButton = 2
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 2
                     Exit Do
                  Case Chr$(9) ' tab
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawQuitBoxButtons
                  Case Chr$(1) ' ctrl-a
                     BackGround6 = BackGround6 + 1
                     If BackGround6 = 8 Then
                        BackGround6 = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(2) ' ctrl-b
                     BackGround7 = BackGround7 + 1
                     If BackGround7 = 8 Then
                        BackGround7 = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(4) ' ctrl-d
                     QuitBoxBorderColor = QuitBoxBorderColor + 1
                     If QuitBoxBorderColor = 16 Then
                        QuitBoxBorderColor = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(5) ' ctrl-e
                     QuitBoxTitleColor = QuitBoxTitleColor + 1
                     If QuitBoxTitleColor = 16 Then
                        QuitBoxTitleColor = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(6) ' ctrl-f
                     QuitBoxTextColor = QuitBoxTextColor + 1
                     If QuitBoxTextColor = 16 Then
                        QuitBoxTextColor = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(7) ' ctrl-g
                     QuitBoxButton1Color = QuitBoxButton1Color + 1
                     If QuitBoxButton1Color = 16 Then
                        QuitBoxButton1Color = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(8) ' ctrl-h
                     QuitBoxButton2Color = QuitBoxButton2Color + 1
                     If QuitBoxButton2Color = 16 Then
                        QuitBoxButton2Color = 0
                     End If
                     GoSub DrawQuitBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 75, 15 ' left/shift-tab
                     If BoxButton = 2 Then
                        BoxButton = 1
                     Else
                        BoxButton = 2
                     End If
                     GoSub DrawQuitBoxButtons
                  Case 77 ' right
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawQuitBoxButtons
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen2
                     GoSub DrawQuitBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen2
                           GoSub DrawQuitBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           Call RestoreScreen2
                           GoSub DrawQuitBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen2
                           GoSub DrawQuitBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen2
                           GoSub DrawQuitBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      If Status Then
         Z = 23
      Else
         Z = 24
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen2
                        GoSub DrawQuitBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 4 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
                  BoxButton = 2
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 4 Then
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
               If BoxButton = 2 Then
                  BoxButton = 1
                  GoSub DrawQuitBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
               If BoxButton = 1 Then
                  BoxButton = 2
                  GoSub DrawQuitBoxButtons
               End If
            End If
         End If
      End If
      If MouseButton2 Then
         VarX = MessageBox(" Quit ", "Quitbox " + Date$ + " " + Time$)
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen2
               GoSub DrawQuitBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            If Status Then
               Z = 23
            Else
               Z = 24
            End If
            X$ = ""
            If Xcoor3 + 7 < Z Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen2
               GoSub DrawQuitBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates
   QuitXcoor = Xcoor3
   QuitYcoor = Ycoor3

   ' restore screen area.
   Call RestoreScreen2
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then
      QuitBox = -1
   Else
      QuitBox = 0
   End If
   Exit Function

   ' draw box
   DrawQuitBox:
   Color QuitBoxBorderColor, BackGround6
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);
   Color QuitBoxTitleColor
   Locate Xcoor3, Ycoor3 + 12, 0
   Print " Quit ";

   ' display quit text
   Color QuitBoxTextColor
   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   Print QuitBoxText$
   GoSub DrawQuitBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawQuitBoxButtons:
   If BoxButton = 1 Then
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color QuitBoxButton1Color, BackGround7
      Print "<OK>";
      Locate Xcoor3 + 4, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 4, Ycoor3 + 8, 0
      Color QuitBoxButton2Color, BackGround7
      Print "<Cancel>";
      Locate Xcoor3 + 4, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   Else
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color QuitBoxButton2Color, BackGround7
      Print "<OK>";
      Locate Xcoor3 + 4, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 4, Ycoor3 + 8, 0
      Color QuitBoxButton1Color, BackGround7
      Print "<Cancel>";
      Locate Xcoor3 + 4, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   End If
   Color Plain, Black
   Return
End Function

Rem MessageBox with YES/NO/Cancel
Rem    only with full screen editor.
Function QuitBox2 (Var1$)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen3

   ' declare quit box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   If QuitXcoor2 Then Xcoor3 = QuitXcoor2
   If QuitYcoor2 Then Ycoor3 = QuitYcoor2

   ' draw box
   BoxButton = 1
   GoSub DrawQuitBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYz$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 3
                     Exit Do
                  Case Chr$(9) ' tab
                     BoxButton = BoxButton + 1
                     If BoxButton = 4 Then
                        BoxButton = 1
                     End If
                     GoSub DrawQuitBoxButtons
                  Case Chr$(1) ' ctrl-a
                     BackGround6 = BackGround6 + 1
                     If BackGround6 = 8 Then
                        BackGround6 = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(2) ' ctrl-b
                     BackGround7 = BackGround7 + 1
                     If BackGround7 = 8 Then
                        BackGround7 = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(4) ' ctrl-d
                     QuitBoxBorderColor = QuitBoxBorderColor + 1
                     If QuitBoxBorderColor = 16 Then
                        QuitBoxBorderColor = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(5) ' ctrl-e
                     QuitBoxTitleColor = QuitBoxTitleColor + 1
                     If QuitBoxTitleColor = 16 Then
                        QuitBoxTitleColor = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(6) ' ctrl-f
                     QuitBoxTextColor = QuitBoxTextColor + 1
                     If QuitBoxTextColor = 16 Then
                        QuitBoxTextColor = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(7) ' ctrl-g
                     QuitBoxButton1Color = QuitBoxButton1Color + 1
                     If QuitBoxButton1Color = 16 Then
                        QuitBoxButton1Color = 0
                     End If
                     GoSub DrawQuitBox
                  Case Chr$(8) ' ctrl-h
                     QuitBoxButton2Color = QuitBoxButton2Color + 1
                     If QuitBoxButton2Color = 16 Then
                        QuitBoxButton2Color = 0
                     End If
                     GoSub DrawQuitBox
                  Case Else
                     If UCase$(X$) = "Y" Then
                        BoxButton = 1
                        Exit Do
                     End If
                     If UCase$(X$) = "N" Then
                        BoxButton = 2
                        Exit Do
                     End If
                     If UCase$(X$) = "C" Then
                        BoxButton = 3
                        Exit Do
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 75, 15 ' left/shift-tab
                     BoxButton = BoxButton - 1
                     If BoxButton = 0 Then
                        BoxButton = 3
                     End If
                     GoSub DrawQuitBoxButtons
                  Case 77 ' right
                     BoxButton = BoxButton + 1
                     If BoxButton = 4 Then
                        BoxButton = 1
                     End If
                     GoSub DrawQuitBoxButtons
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen3
                     GoSub DrawQuitBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     X$ = ""
                     If Xcoor3 < 17 Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen3
                           GoSub DrawQuitBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     X$ = ""
                     If Xcoor3 < 13 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     Else
                        If Xcoor3 < 17 Then
                           Xcoor3 = 17
                           Call RestoreScreen3
                           GoSub DrawQuitBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen3
                           GoSub DrawQuitBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen3
                           GoSub DrawQuitBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= 17 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen3
                        GoSub DrawQuitBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 4 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 6 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 9 And MouseY <= Ycoor3 + 12 Then
                  BoxButton = 2
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 15 And MouseY <= Ycoor3 + 22 Then
                  BoxButton = 3
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 4 Then
            '<YES>  <NO>  <Cancel>
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 6 Then
               If BoxButton <> 1 Then
                  BoxButton = 1
                  GoSub DrawQuitBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 9 And MouseY <= Ycoor3 + 12 Then
               If BoxButton <> 2 Then
                  BoxButton = 2
                  GoSub DrawQuitBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 15 And MouseY <= Ycoor3 + 22 Then
               If BoxButton <> 3 Then
                  BoxButton = 3
                  GoSub DrawQuitBoxButtons
               End If
            End If
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates
   QuitXcoor2 = Xcoor3
   QuitYcoor2 = Ycoor3

   ' restore screen area.
   Call RestoreScreen3
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then ' YES
      QuitBox2 = -1
   Else
      If BoxButton = 2 Then ' NO
         QuitBox2 = 1
      Else
         QuitBox2 = 0 ' Cancel
      End If
   End If
   Exit Function

   ' draw box
   DrawQuitBox:
   Color QuitBoxBorderColor, BackGround6
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);
   Color QuitBoxTitleColor
   Locate Xcoor3, Ycoor3 + 12, 0
   Print " Quit ";

   ' display quit text
   Color QuitBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 2, 0
   Print Var1$;
   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   Print QuitBoxText2$
   GoSub DrawQuitBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawQuitBoxButtons:
   Select Case BoxButton
      '<YES>  <NO>  <Cancel>
      Case 1
         Locate Xcoor3 + 4, Ycoor3 + 2, 0
         Color QuitBoxButton1Color, QuitBoxButtonBackGround
         Print "<YES>";
         Locate Xcoor3 + 4, Ycoor3 + 3, 0
         Color Magenta
         Print "Y";

         Locate Xcoor3 + 4, Ycoor3 + 9, 0
         Color QuitBoxButton2Color, QuitBoxButtonBackGround
         Print "<NO>";
         Locate Xcoor3 + 4, Ycoor3 + 10, 0
         Color Magenta
         Print "N";

         Locate Xcoor3 + 4, Ycoor3 + 15, 0
         Color QuitBoxButton2Color, QuitBoxButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 4, Ycoor3 + 16, 0
         Color Magenta
         Print "C";
      Case 2
         Locate Xcoor3 + 4, Ycoor3 + 2, 0
         Color QuitBoxButton2Color, QuitBoxButtonBackGround
         Print "<YES>";
         Locate Xcoor3 + 4, Ycoor3 + 3, 0
         Color Magenta
         Print "Y";

         Locate Xcoor3 + 4, Ycoor3 + 9, 0
         Color QuitBoxButton1Color, QuitBoxButtonBackGround
         Print "<NO>";
         Locate Xcoor3 + 4, Ycoor3 + 10, 0
         Color Magenta
         Print "N";

         Locate Xcoor3 + 4, Ycoor3 + 15, 0
         Color QuitBoxButton2Color, QuitBoxButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 4, Ycoor3 + 16, 0
         Color Magenta
         Print "C";
      Case 3
         Locate Xcoor3 + 4, Ycoor3 + 2, 0
         Color QuitBoxButton2Color, QuitBoxButtonBackGround
         Print "<YES>";
         Locate Xcoor3 + 4, Ycoor3 + 3, 0
         Color Magenta
         Print "Y";

         Locate Xcoor3 + 4, Ycoor3 + 9, 0
         Color QuitBoxButton2Color, QuitBoxButtonBackGround
         Print "<NO>";
         Locate Xcoor3 + 4, Ycoor3 + 10, 0
         Color Magenta
         Print "N";

         Locate Xcoor3 + 4, Ycoor3 + 15, 0
         Color QuitBoxButton1Color, QuitBoxButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 4, Ycoor3 + 16, 0
         Color Magenta
         Print "C";
   End Select
   Color Plain, Black
   Return
End Function

Rem MessageBox with OK/Cancel
Function ErrorBox (Var0$, Var1$)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   ' declare error box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10

   ' set error box colors
   ErrorBoxBorderColor = Yellow
   ErrorBoxTitleColor = White
   ErrorBoxTextColor = White
   ErrorBoxButton1Color = White
   ErrorBoxButton2Color = Plain
   ErrorBackGround1 = 1
   ErrorBackGround2 = 0

   ' draw box
   BoxButton = 1
   GoSub DrawErrorBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYz$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "O"
                     BoxButton = 1
                     Exit Do
                  Case "C"
                     BoxButton = 2
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 2
                     Exit Do
                  Case Chr$(9) ' tab
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawErrorBoxButtons
                  Case Chr$(1) ' ctrl-a
                     ErrorBackGround1 = ErrorBackGround1 + 1
                     If ErrorBackGround1 = 8 Then
                        ErrorBackGround1 = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(2) ' ctrl-b
                     ErrorBackGround2 = ErrorBackGround2 + 1
                     If ErrorBackGround2 = 8 Then
                        ErrorBackGround2 = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(4) ' ctrl-d
                     ErrorBoxBorderColor = ErrorBoxBorderColor + 1
                     If ErrorBoxBorderColor = 16 Then
                        ErrorBoxBorderColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(5) ' ctrl-e
                     ErrorBoxTitleColor = ErrorBoxTitleColor + 1
                     If ErrorBoxTitleColor = 16 Then
                        ErrorBoxTitleColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(6) ' ctrl-f
                     ErrorBoxTextColor = ErrorBoxTextColor + 1
                     If ErrorBoxTextColor = 16 Then
                        ErrorBoxTextColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(7) ' ctrl-g
                     ErrorBoxButton1Color = ErrorBoxButton1Color + 1
                     If ErrorBoxButton1Color = 16 Then
                        ErrorBoxButton1Color = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(8) ' ctrl-h
                     ErrorBoxButton2Color = ErrorBoxButton2Color + 1
                     If ErrorBoxButton2Color = 16 Then
                        ErrorBoxButton2Color = 0
                     End If
                     GoSub DrawErrorBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 75, 15 ' left/shift-tab
                     If BoxButton = 2 Then
                        BoxButton = 1
                     Else
                        BoxButton = 2
                     End If
                     GoSub DrawErrorBoxButtons
                  Case 77 ' right
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawErrorBoxButtons
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen2
                     GoSub DrawErrorBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      If Status Then
         Z = 23
      Else
         Z = 24
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 4 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
                  BoxButton = 2
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 4 Then
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
               If BoxButton = 2 Then
                  BoxButton = 1
                  GoSub DrawErrorBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
               If BoxButton = 1 Then
                  BoxButton = 2
                  GoSub DrawErrorBoxButtons
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen2
               GoSub DrawErrorBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            If Status Then
               Z = 23
            Else
               Z = 24
            End If
            X$ = ""
            If Xcoor3 + 7 < Z Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen2
               GoSub DrawErrorBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   Call RestoreScreen2
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then
      ErrorBox = -1
   Else
      ErrorBox = 0
   End If
   Exit Function

   ' draw box
   DrawErrorBox:
   Color ErrorBoxBorderColor, ErrorBackGround1
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   TempX = 16 - Len(Var0$) \ 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color ErrorBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print Var0$;

   ' display error text
   Color ErrorBoxTextColor
   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   Print Var1$
   GoSub DrawErrorBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawErrorBoxButtons:
   If BoxButton = 1 Then
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color ErrorBoxButton1Color, ErrorBackGround2
      Print "<OK>";
      Locate Xcoor3 + 4, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 4, Ycoor3 + 8, 0
      Color ErrorBoxButton2Color, ErrorBackGround2
      Print "<Cancel>";
      Locate Xcoor3 + 4, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   Else
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color ErrorBoxButton2Color, ErrorBackGround2
      Print "<OK>";
      Locate Xcoor3 + 4, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 4, Ycoor3 + 8, 0
      Color ErrorBoxButton1Color, ErrorBackGround2
      Print "<Cancel>";
      Locate Xcoor3 + 4, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   End If
   Color Plain, Black
   Return
End Function

Rem MessageBox with OK
Function MessageBox (Var0$, Var1$)
   Dim TempArrayY3(1 To 2000) As Integer
   Dim TempArrayZ3(1 To 2000) As Integer

   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   GoSub SaveScreenX

   ' declare error box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10

   ' set error box colors
   MessageBoxBorderColor = Yellow
   MessageBoxTitleColor = White
   MessageBoxTextColor = White
   MessageBoxButton1Color = White
   MessageBoxButton2Color = Plain
   MessageBackGround1 = 1
   MessageBackGround2 = 0

   ' draw box
   GoSub DrawMessageBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYz$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "O"
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     Exit Do
                  Case Chr$(1) ' ctrl-a
                     MessageBackGround1 = MessageBackGround1 + 1
                     If MessageBackGround1 = 8 Then
                        MessageBackGround1 = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(2) ' ctrl-b
                     MessageBackGround2 = MessageBackGround2 + 1
                     If MessageBackGround2 = 8 Then
                        MessageBackGround2 = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(4) ' ctrl-d
                     MessageBoxBorderColor = MessageBoxBorderColor + 1
                     If MessageBoxBorderColor = 16 Then
                        MessageBoxBorderColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(5) ' ctrl-e
                     MessageBoxTitleColor = MessageBoxTitleColor + 1
                     If MessageBoxTitleColor = 16 Then
                        MessageBoxTitleColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(6) ' ctrl-f
                     MessageBoxTextColor = MessageBoxTextColor + 1
                     If MessageBoxTextColor = 16 Then
                        MessageBoxTextColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(7) ' ctrl-g
                     MessageBoxButton1Color = MessageBoxButton1Color + 1
                     If MessageBoxButton1Color = 16 Then
                        MessageBoxButton1Color = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(8) ' ctrl-h
                     MessageBoxButton2Color = MessageBoxButton2Color + 1
                     If MessageBoxButton2Color = 16 Then
                        MessageBoxButton2Color = 0
                     End If
                     GoSub DrawMessageBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     GoSub RestoreScreenX
                     GoSub DrawMessageBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 75, 115 ' left/ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 77, 116 ' right/ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           GoSub RestoreScreenX
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           GoSub RestoreScreenX
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           GoSub RestoreScreenX
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           GoSub RestoreScreenX
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      If Status Then
         Z = 23
      Else
         Z = 24
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        GoSub RestoreScreenX
                        GoSub DrawMessageBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 4 Then
               If MouseY >= Ycoor3 + 14 And MouseY <= Ycoor3 + 17 Then
                  Exit Do
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               GoSub RestoreScreenX
               GoSub DrawMessageBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            If Status Then
               Z = 23
            Else
               Z = 24
            End If
            X$ = ""
            If Xcoor3 + 7 < Z Then
               Xcoor3 = Xcoor3 + 1
               GoSub RestoreScreenX
               GoSub DrawMessageBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   GoSub RestoreScreenX
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   MessageBox = -1
   Exit Function

   ' draw box
   DrawMessageBox:
   Color MessageBoxBorderColor, MessageBackGround1
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   TempX = 16 - Len(Var0$) \ 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color MessageBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print Var0$;

   ' display message color
   If Var0$ = " Alarm " Then
      Color AlarmTrapColor
   Else
      Color MessageBoxTextColor
   End If

   ' see if there are 2 | bars
   V = InStr(Var1$, "|")
   If V Then
      X = InStr(V + 1, Var1$, "|")
      If X Then
         VarX$ = Left$(Var1$, V - 1)
         Var1$ = Mid$(Var1$, V + 1)
         Z = InStr(Var1$, "|")
         VarY$ = Left$(Var1$, Z - 1)
         VarZ$ = Mid$(Var1$, Z + 1)

         ' display message text
         Locate Xcoor3 + 1, Ycoor3 + 2, 0
         Print VarX$
         Locate Xcoor3 + 2, Ycoor3 + 2, 0
         Print VarY$
         Locate Xcoor3 + 3, Ycoor3 + 2, 0
         Print VarZ$
         GoTo NextChar
      End If
   End If

   ' check if there are 1 | bar
   If InStr(Var1$, "|") Then
      VarX$ = Left$(Var1$, InStr(Var1$, "|") - 1)
      VarY$ = Mid$(Var1$, InStr(Var1$, "|") + 1)
      ' display message text
      Locate Xcoor3 + 2, Ycoor3 + 2, 0
      Print VarX$
      Locate Xcoor3 + 3, Ycoor3 + 2, 0
      Print VarY$
      GoTo NextChar
   End If

   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   ' display message text
   Print Var1$

   NextChar:
   GoSub DrawMessageBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawMessageBoxButtons:
   Locate Xcoor3 + 4, Ycoor3 + 14, 0
   Color MessageBoxButton1Color, MessageBackGround2
   Print "<OK>";

   Locate Xcoor3 + 4, Ycoor3 + 15, 0
   Color Magenta
   Print "O";

   Color Plain, Black
   Return

   ' screen save
   SaveScreenX:
   If Status Then
      V = 23
   Else
      V = 24
   End If
   For Var1 = 2 To V
      For Var2 = 1 To 80
         TempZ1 = Screen(Var1, Var2) ' screen char
         TempZ2 = Screen(Var1, Var2, 1) ' char color
         TempArrayY3((Var1 - 1) * 80 + Var2) = TempZ1
         TempArrayZ3((Var1 - 1) * 80 + Var2) = TempZ2
      Next
   Next
   Return

   ' screen restore
   RestoreScreenX:
   If Status Then
      V = 23
   Else
      V = 24
   End If
   For Var1 = 2 To V
      For Var2 = 1 To 80
         VarB = Int(TempArrayZ3((Var1 - 1) * 80 + Var2) / 16)
         VarF = TempArrayZ3((Var1 - 1) * 80 + Var2) Mod 16
         TempZ1 = TempArrayY3((Var1 - 1) * 80 + Var2)
         Locate Var1, Var2, 1
         Color VarF, VarB
         Print Chr$(TempZ1);
      Next
   Next
   Return
End Function

Rem HelpBox with OK
Function HelpBox
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen3

   ' declare error box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10

   ' set error box colors
   MessageBoxBorderColor = Yellow
   MessageBoxTitleColor = White
   MessageBoxTextColor = White
   MessageBoxButton1Color = White
   MessageBoxButton2Color = Plain
   MessageBackGround1 = 1
   MessageBackGround2 = 0

   ' draw box
   GoSub DrawMessageBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYz$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "O"
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     Exit Do
                  Case Chr$(1) ' ctrl-a
                     MessageBackGround1 = MessageBackGround1 + 1
                     If MessageBackGround1 = 8 Then
                        MessageBackGround1 = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(2) ' ctrl-b
                     MessageBackGround2 = MessageBackGround2 + 1
                     If MessageBackGround2 = 8 Then
                        MessageBackGround2 = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(4) ' ctrl-d
                     MessageBoxBorderColor = MessageBoxBorderColor + 1
                     If MessageBoxBorderColor = 16 Then
                        MessageBoxBorderColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(5) ' ctrl-e
                     MessageBoxTitleColor = MessageBoxTitleColor + 1
                     If MessageBoxTitleColor = 16 Then
                        MessageBoxTitleColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(6) ' ctrl-f
                     MessageBoxTextColor = MessageBoxTextColor + 1
                     If MessageBoxTextColor = 16 Then
                        MessageBoxTextColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(7) ' ctrl-g
                     MessageBoxButton1Color = MessageBoxButton1Color + 1
                     If MessageBoxButton1Color = 16 Then
                        MessageBoxButton1Color = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(8) ' ctrl-h
                     MessageBoxButton2Color = MessageBoxButton2Color + 1
                     If MessageBoxButton2Color = 16 Then
                        MessageBoxButton2Color = 0
                     End If
                     GoSub DrawMessageBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = SearchXcoor
                     Ycoor3 = SearchYcoor
                     Call RestoreScreen3
                     GoSub DrawMessageBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     X$ = ""
                     If Xcoor3 < 16 Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen3
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     X$ = ""
                     If Xcoor3 < 12 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     Else
                        If Xcoor3 < 16 Then
                           Xcoor3 = 16
                           Call RestoreScreen3
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen3
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen3
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= 16 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen3
                        GoSub DrawMessageBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            ' click on OK
            If MouseX = Xcoor3 + 9 Then
               If MouseY >= Ycoor3 + 14 And MouseY <= Ycoor3 + 17 Then
                  Exit Do
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen3
               GoSub DrawMessageBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 < 16 Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen3
               GoSub DrawMessageBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   Call RestoreScreen3
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   HelpBox = -1
   Exit Function

   ' draw box
   DrawMessageBox:
   Color MessageBoxBorderColor, MessageBackGround1
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 9
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 10, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   Var0$ = " Help "
   TempX = 16 - Len(Var0$) \ 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color MessageBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print Var0$;

   ' display message text
   Color MessageBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 2, 0
   Print " F1 - Help      Alt-D Dump"
   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   Print " F2 - Savefile  Alt-J Jump"
   Locate Xcoor3 + 3, Ycoor3 + 2, 0
   Print " F3 - Search    Alt-E Edit"
   Locate Xcoor3 + 4, Ycoor3 + 2, 0
   Print " Ctrl-E Repeat   (append)"
   Locate Xcoor3 + 5, Ycoor3 + 2, 0
   Print " Ctrl-F Search  Alt-P Print"
   Locate Xcoor3 + 6, Ycoor3 + 2, 0
   Print " Ctrl-G Goto    Alt-S Search"
   Locate Xcoor3 + 7, Ycoor3 + 2, 0
   Print " F4/Ctrl-K AppendFile"
   Locate Xcoor3 + 8, Ycoor3 + 2, 0
   Print " F5/Ctrl-L InsertFile"
   GoSub DrawMessageBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawMessageBoxButtons:
   Locate Xcoor3 + 9, Ycoor3 + 14, 0
   Color MessageBoxButton1Color, MessageBackGround2
   Print "<OK>";

   Locate Xcoor3 + 9, Ycoor3 + 15, 0
   Color Magenta
   Print "O";

   Color Plain, Black
   Return
End Function

Function SearchBox (X$, Var1) ' Var1=1 Hex, =2 Ascii.
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen3

   ' declare input box coordinates.
   XC = Xcoor3 + 3
   YC = Ycoor3 + 8
   LC = 22
   If SearchXcoor Then Xcoor3 = SearchXcoor
   If SearchYcoor Then Ycoor3 = SearchYcoor

   ' draw box
   BoxButton = 1
   WildcardSelect = 0
   SensitiveSelect = 0
   GoSub DrawSearchBox

   ' init entry area position.
   Xposition1 = 1
   Xposition2 = 0

   ' display edit entry area.
   LineX = 0
   If Len(X$) Then
      LineX = -1
   End If
   Insert = -1
   GoSub DisplayFileLine

   ' wait for keypress or mouse
   _KeyClear
   Control.Break = False
   Monitor.Box = False
   Do
      If Control.Break Or Monitor.Box Then
         Control.Break = False
         Monitor.Box = False
         GoSub ToggleInsert
      End If

      I$ = INKEYz$
      If Len(I$) Then
         Select Case Len(I$)
            Case 1
               Select Case I$
                  Case Chr$(8) ' backspace
                     If BoxButton = 1 Then
                        If Len(X$) Then
                           If LineX Then
                              LineX = 0
                              X$ = ""
                              Xposition1 = 1
                              Xposition2 = 0
                              GoSub DisplayFileLine
                           End If
                           If Xposition2 > 0 Then
                              If Insert Then ' destructive backspace
                                 X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                              End If
                              Xposition2 = Xposition2 - 1
                              If Xposition2 - LC <= Xposition1 Then
                                 Xposition1 = Xposition1 - 1
                                 If Xposition1 < 1 Then
                                    Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case Chr$(13)
                     If BoxButton = 5 Then
                        BoxButton = 0
                     Else
                        BoxButton = -1
                     End If
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 0
                     Exit Do
                  Case Chr$(9) ' tab
                     BoxButton = BoxButton + 1
                     If BoxButton = 6 Then
                        BoxButton = 1
                     End If
                     Select Case BoxButton
                        Case 1 ' entry area
                           GoSub DisplayFileLine
                        Case 2 ' checkbox1
                           Locate Xcoor3 + 4, Ycoor3 + 2, 1, 8, 8
                        Case 3 ' checkbox2
                           Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
                        Case 4 ' ok
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 5, 1, 8, 8
                        Case 5 'cancel
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 11, 1, 8, 8
                     End Select
                  Case Chr$(1) ' ctrl-a
                     SearchBoxBackGround = SearchBoxBackGround + 1
                     If SearchBoxBackGround = 8 Then
                        SearchBoxBackGround = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(2) ' ctrl-b
                     SearchBoxButtonBackGround = SearchBoxButtonBackGround + 1
                     If SearchBoxButtonBackGround = 8 Then
                        SearchBoxButtonBackGround = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(4) ' ctrl-d
                     SearchBoxBorderColor = SearchBoxBorderColor + 1
                     If SearchBoxBorderColor = 16 Then
                        SearchBoxBorderColor = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(5) ' ctrl-e
                     SearchBoxTitleColor = SearchBoxTitleColor + 1
                     If SearchBoxTitleColor = 16 Then
                        SearchBoxTitleColor = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(6) ' ctrl-f
                     SearchBoxTextColor = SearchBoxTextColor + 1
                     If SearchBoxTextColor = 16 Then
                        SearchBoxTextColor = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(7) ' ctrl-g
                     SearchBoxButton1Color = SearchBoxButton1Color + 1
                     If SearchBoxButton1Color = 16 Then
                        SearchBoxButton1Color = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(11) ' ctrl-k
                     SearchBoxButton2Color = SearchBoxButton2Color + 1
                     If SearchBoxButton2Color = 16 Then
                        SearchBoxButton2Color = 0
                     End If
                     GoSub DrawSearchBox
                  Case Else
                     If BoxButton >= 2 And BoxButton <= 5 Then
                        If UCase$(I$) = "W" Then
                           WildcardSelect = Not WildcardSelect
                           GoSub DrawSearchCheckBoxs
                        End If
                        If UCase$(I$) = "S" Then
                           SensitiveSelect = Not SensitiveSelect
                           GoSub DrawSearchCheckBoxs
                        End If
                        If UCase$(I$) = "O" Then
                           BoxButton = -1
                           Exit Do
                        End If
                        If UCase$(I$) = "C" Then
                           BoxButton = 0
                           Exit Do
                        End If
                     End If
                     If BoxButton = 2 Then ' checkbox1
                        If I$ = " " Then
                           WildcardSelect = Not WildcardSelect
                           GoSub DrawSearchCheckBoxs
                        End If
                     End If
                     If BoxButton = 3 Then ' checkbox2
                        If I$ = " " Then
                           SensitiveSelect = Not SensitiveSelect
                           GoSub DrawSearchCheckBoxs
                        End If
                     End If
                     If BoxButton = 1 Then
                        ' append/insert character into edit area.
                        VarI = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           VarI = 0 ' disallow control charcters
                        End If
                        If VarI Then
                           If LineX Then
                              LineX = 0
                              X$ = ""
                              Xposition1 = 1
                              Xposition2 = 0
                           End If
                           If Insert Then
                              X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                              Xposition2 = Xposition2 + 1
                              If Xposition2 > LC Then
                                 Xposition1 = Xposition1 + 1
                              End If
                           Else
                              If Xposition2 + 1 > Len(X$) Then
                                 X$ = X$ + I$ ' append
                                 Xposition2 = Xposition2 + 1
                                 If Xposition2 > LC Then
                                    Xposition1 = Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X$, Xposition2 + 1, 1) = I$
                                 Xposition2 = Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(I$, 1))
                  Case 82 ' Insert
                     If BoxButton = 1 Then
                        Insert = Not Insert
                        If Insert Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                  Case 83 ' Delete
                     If BoxButton = 1 Then
                        LineX = 0
                        GoSub DisplayFileLine
                        If Len(X$) > 0 Then
                           X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 71 ' Home
                     If BoxButton = 1 Then
                        LineX = 0
                        If Xposition2 > 0 Then
                           Xposition1 = 1
                           Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 79 ' End
                     If BoxButton = 1 Then
                        LineX = 0
                        If Xposition2 < Len(X$) Then
                           Xposition2 = Len(X$)
                           Xposition1 = Xposition2 - LC + 1
                           If Xposition1 < 1 Then
                              Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 75 ' Left
                     If BoxButton = 1 Then
                        LineX = 0
                        If Len(X$) Then
                           If Xposition2 > 0 Then
                              Xposition2 = Xposition2 - 1
                              If Xposition2 - LC <= Xposition1 Then
                                 Xposition1 = Xposition1 - 1
                                 If Xposition1 < 1 Then
                                    Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                  Case 77 ' Right
                     If BoxButton = 1 Then
                        LineX = 0
                        If Len(X$) Then
                           If Xposition2 < Len(X$) Then
                              Xposition2 = Xposition2 + 1
                              If Xposition2 > Xposition1 + LC - 1 Then
                                 Xposition1 = Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case 72 ' up
                     If BoxButton = 2 Then ' checkbox1
                        WildcardSelect = -1
                        GoSub DrawSearchCheckBoxs
                     End If
                     If BoxButton = 3 Then ' checkbox2
                        SensitiveSelect = -1
                        GoSub DrawSearchCheckBoxs
                     End If
                  Case 80 ' down
                     If BoxButton = 2 Then ' checkbox1
                        WildcardSelect = 0
                        GoSub DrawSearchCheckBoxs
                     End If
                     If BoxButton = 3 Then ' checkbox2
                        SensitiveSelect = 0
                        GoSub DrawSearchCheckBoxs
                     End If
                  Case 15 ' shift-tab
                     BoxButton = BoxButton - 1
                     If BoxButton = 0 Then
                        BoxButton = 5
                     End If
                     Select Case BoxButton
                        Case 1 ' entry area
                           GoSub DisplayFileLine
                        Case 2 ' checkbox1
                           Locate Xcoor3 + 4, Ycoor3 + 2, 1, 8, 8
                        Case 3 ' checkbox2
                           Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
                        Case 4 ' ok
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 5, 1, 8, 8
                        Case 5 'cancel
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 11, 1, 8, 8
                     End Select
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = SearchXcoor
                     Ycoor3 = SearchYcoor
                     Call RestoreScreen3
                     GoSub DrawSearchBox
                     _KeyClear
                  Case 141 ' ctrl-up
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                     _KeyClear
                  Case 145 ' ctrl-down
                     If Xcoor3 < 17 Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen3
                           GoSub DrawSearchBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     If Xcoor3 < 13 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     Else
                        If Xcoor3 < 17 Then
                           Xcoor3 = 17
                           Call RestoreScreen3
                           GoSub DrawSearchBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen3
                           GoSub DrawSearchBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen3
                           GoSub DrawSearchBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= 17 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else ' click on button
            If MouseX = XC Then
               ' entry area
               If MouseY >= YC And MouseY <= YC + LC Then
                  BoxButton = 1
                  GoSub DrawSearchBox
               End If
            End If
            If MouseX = Xcoor3 + 4 Then
               ' click checkbox 1
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 3 Then
                  WildcardSelect = Not WildcardSelect
                  GoSub DrawSearchCheckBoxs
               End If
            End If
            If MouseX = Xcoor3 + 5 Then
               ' click checkbox 2
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 3 Then
                  SensitiveSelect = Not SensitiveSelect
                  GoSub DrawSearchCheckBoxs
               End If
            End If
            If MouseX = Xcoor3 + 6 Then
               ' click OK
               If MouseY >= Ycoor3 + 5 And MouseY <= Ycoor3 + 8 Then
                  BoxButton = -1
                  Exit Do
               End If
               ' click cancel
               If MouseY >= Ycoor3 + 11 And MouseY <= Ycoor3 + 18 Then
                  BoxButton = 0
                  Exit Do
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen3
               GoSub DrawSearchBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 < 17 Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen3
               GoSub DrawSearchBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates
   SearchXcoor = Xcoor3
   SearchYcoor = Ycoor3

   ' restore screen area.
   Call RestoreScreen3
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton Then
      SearchBox = -1
   Else
      SearchBox = 0
   End If
   Locate , , 1, 8, 8
   _KeyClear
   Exit Function

   ' draw box
   DrawSearchBox:
   Color SearchBoxBorderColor, SearchBoxBackGround
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   SearchBoxTitle$ = " Search "
   TempX = 16 - Len(SearchBoxTitle$) / 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color SearchBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print SearchBoxTitle$;

   ' display search text
   If Var1 = 1 Then
      Color SearchBoxTextColor
      Locate Xcoor3 + 1, Ycoor3 + 1, 0
      Print "Enter HEX bytes"
      Locate Xcoor3 + 2, Ycoor3 + 1, 0
      Print "  (space separated)"
   End If
   If Var1 = 2 Then
      Color SearchBoxTextColor
      Locate Xcoor3 + 1, Ycoor3 + 1, 0
      Print "Enter ASCII string:"
   End If

   Locate Xcoor3 + 3, Ycoor3 + 1, 0
   Print "Entry: ";

   Locate Xcoor3 + 4, Ycoor3 + 1, 0
   Color SearchBoxButton1Color, SearchBoxBackGround
   Print "[ ] Use Wildcards";
   Locate Xcoor3 + 4, Ycoor3 + 9, 0
   Color Magenta
   Print "W";

   Locate Xcoor3 + 5, Ycoor3 + 1, 0
   Color SearchBoxButton1Color, SearchBoxBackGround
   Print "[ ] Case Sensitive";
   Locate Xcoor3 + 5, Ycoor3 + 10, 0
   Color Magenta
   Print "S";

   GoSub DrawSearchCheckBoxs
   GoSub DrawSearchBoxButtons
   XC = Xcoor3 + 3
   YC = Ycoor3 + 8

   Color White, Black
   Locate XC, YC, 1
   Print Space$(LC);

   Select Case BoxButton
      Case 1 ' entry area
         GoSub DisplayFileLine
      Case 2 ' checkbox1
         Locate Xcoor3 + 4, Ycoor3 + 2, 1
      Case 3 ' checkbox2
         Locate Xcoor3 + 5, Ycoor3 + 2, 1
      Case 4 ' ok
         GoSub DrawSearchBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 5, 1
      Case 5 'cancel
         GoSub DrawSearchBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 11, 1
   End Select
   Locate , , , 8, 8
   Return

   ' display checkboxs
   DrawSearchCheckBoxs:
   '-[ ] Use wildcards
   '-[ ] Case-sensitive
   If WildcardSelect Then
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color SearchBoxButton1Color, SearchBoxButtonBackGround
      Print "X";
   Else
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color SearchBoxButton1Color, SearchBoxButtonBackGround
      Print " ";
   End If
   If SensitiveSelect Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color SearchBoxButton1Color, SearchBoxButtonBackGround
      Print "X";
   Else
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color SearchBoxButton1Color, SearchBoxButtonBackGround
      Print " ";
   End If
   If BoxButton = 2 Then
      Locate Xcoor3 + 4, Ycoor3 + 2, 1, 8, 8
   Else
      If BoxButton = 3 Then
         Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
      End If
   End If
   Return

   ' display buttuns
   DrawSearchBoxButtons:
   Select Case BoxButton
      Case 4 ' OK
         Locate Xcoor3 + 6, Ycoor3 + 5, 0
         Color SearchBoxButton1Color, SearchBoxButtonBackGround
         Print "<OK>";
         Locate Xcoor3 + 6, Ycoor3 + 6, 0
         Color Magenta
         Print "O";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";
      Case 5 ' cancel
         Locate Xcoor3 + 6, Ycoor3 + 5, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<OK>";
         Locate Xcoor3 + 6, Ycoor3 + 6, 0
         Color Magenta
         Print "O";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color SearchBoxButton1Color, SearchBoxButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";
      Case Else
         Locate Xcoor3 + 6, Ycoor3 + 5, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<OK>";
         Locate Xcoor3 + 6, Ycoor3 + 6, 0
         Color Magenta
         Print "O";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";
   End Select
   Color White, Black
   Return

   ' display current entry area.
   DisplayFileLine:
   Locate XC, YC, 1
   Print Space$(LC);

   ' display edit line and position cursor.
   Locate XC, YC, 1
   If Len(X$) Then
      If LineX Then
         Color Black, Plain
      Else
         Color White
      End If
      Print Mid$(X$, Xposition1, LC);
   End If
   Locate XC, YC + Xposition2 - Xposition1 + 1, 1
   If Insert Then
      Locate , , 1, 8, 8 ' line cursor
   Else
      Locate , , 1, 0, 8 ' block cursor
   End If
   Color White, Black
   Return

   ToggleInsert:
   If Insert Then
      Locate , , 1, 8, 8 ' line cursor
   Else
      Locate , , 1, 0, 8 ' block cursor
   End If
   Return
End Function

Rem SearchReplaceBox
Function SearchBox2 (X1$, X2$)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen3

   ' declare input box coordinates.
   XC1 = Xcoor3 + 2
   YC1 = Ycoor3 + 1
   XC2 = Xcoor3 + 4
   YC2 = Ycoor3 + 1
   LC = 30
   If SearchXcoor Then Xcoor3 = SearchXcoor
   If SearchYcoor Then Ycoor3 = SearchYcoor

   ' draw box
   BoxButton = 1
   SensitiveSelect = 0
   GoSub DrawSearchBox

   ' init entry area position.
   Box1Xposition1 = 1
   Box1Xposition2 = 0
   Box2Xposition1 = 1
   Box2Xposition2 = 0

   ' display edit entry area.
   Insert1 = -1
   Insert2 = -1
   LineX2 = 0
   If Len(X2$) Then
      LineX2 = -1
   End If
   BoxButton = 2
   GoSub DisplayFileLine

   LineX1 = 0
   If Len(X1$) Then
      LineX1 = -1
   End If
   BoxButton = 1
   GoSub DisplayFileLine

   ' wait for keypress or mouse
   _KeyClear
   Control.Break = False
   Monitor.Box = False
   Do
      If Control.Break Or Monitor.Box Then
         Control.Break = False
         Monitor.Box = False
         GoSub ToggleInsert
      End If

      I$ = INKEYz$
      If Len(I$) Then
         Select Case Len(I$)
            Case 1
               Select Case I$
                  Case Chr$(8) ' backspace
                     If BoxButton = 1 Then
                        If Len(X1$) Then
                           If LineX1 Then
                              LineX1 = 0
                              X1$ = ""
                              Box1Xposition1 = 1
                              Box1Xposition2 = 0
                              GoSub DisplayFileLine
                           End If
                           If Box1Xposition2 > 0 Then
                              If Insert1 Then ' destructive backspace
                                 X1$ = Left$(X1$, Box1Xposition2 - 1) + Mid$(X1$, Box1Xposition2 + 1)
                              End If
                              Box1Xposition2 = Box1Xposition2 - 1
                              If Box1Xposition2 - LC <= Box1Xposition1 Then
                                 Box1Xposition1 = Box1Xposition1 - 1
                                 If Box1Xposition1 < 1 Then
                                    Box1Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        If Len(X2$) Then
                           If LineX2 Then
                              LineX2 = 0
                              X2$ = ""
                              Box2Xposition1 = 1
                              Box2Xposition2 = 0
                              GoSub DisplayFileLine
                           End If
                           If Box2Xposition2 > 0 Then
                              If Insert2 Then ' destructive backspace
                                 X2$ = Left$(X2$, Box2Xposition2 - 1) + Mid$(X2$, Box2Xposition2 + 1)
                              End If
                              Box2Xposition2 = Box2Xposition2 - 1
                              If Box2Xposition2 - LC <= Box2Xposition1 Then
                                 Box2Xposition1 = Box2Xposition1 - 1
                                 If Box2Xposition1 < 1 Then
                                    Box2Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27) ' exit
                     BoxButton = 6
                     Exit Do
                  Case Chr$(9) ' tab
                     BoxButton = BoxButton + 1
                     If BoxButton = 7 Then
                        BoxButton = 1
                     End If
                     Select Case BoxButton
                        Case 1, 2 ' entry area
                           GoSub DrawSearchBoxButtons
                           GoSub DisplayFileLine
                        Case 3 ' checkbox
                           Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
                        Case 4 ' replace
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 1, 1, 8, 8
                        Case 5 ' replaceall
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 11, 1, 8, 8
                        Case 6 ' exit
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 25, 1, 8, 8
                     End Select
                  Case Chr$(1) ' ctrl-a
                     SearchBoxBackGround = SearchBoxBackGround + 1
                     If SearchBoxBackGround = 8 Then
                        SearchBoxBackGround = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(2) ' ctrl-b
                     SearchBoxButtonBackGround = SearchBoxButtonBackGround + 1
                     If SearchBoxButtonBackGround = 8 Then
                        SearchBoxButtonBackGround = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(4) ' ctrl-d
                     SearchBoxBorderColor = SearchBoxBorderColor + 1
                     If SearchBoxBorderColor = 16 Then
                        SearchBoxBorderColor = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(5) ' ctrl-e
                     SearchBoxTitleColor = SearchBoxTitleColor + 1
                     If SearchBoxTitleColor = 16 Then
                        SearchBoxTitleColor = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(6) ' ctrl-f
                     SearchBoxTextColor = SearchBoxTextColor + 1
                     If SearchBoxTextColor = 16 Then
                        SearchBoxTextColor = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(7) ' ctrl-g
                     SearchBoxButton1Color = SearchBoxButton1Color + 1
                     If SearchBoxButton1Color = 16 Then
                        SearchBoxButton1Color = 0
                     End If
                     GoSub DrawSearchBox
                  Case Chr$(11) ' ctrl-k
                     SearchBoxButton2Color = SearchBoxButton2Color + 1
                     If SearchBoxButton2Color = 16 Then
                        SearchBoxButton2Color = 0
                     End If
                     GoSub DrawSearchBox
                  Case Else
                     If BoxButton >= 3 And BoxButton <= 6 Then
                        If UCase$(I$) = "S" Then
                           SensitiveSelect = Not SensitiveSelect
                           GoSub DrawSearchCheckBoxs
                        End If
                        If UCase$(I$) = "R" Then
                           BoxButton = 4
                           Exit Do
                        End If
                        If UCase$(I$) = "A" Then
                           BoxButton = 5
                           Exit Do
                        End If
                        If UCase$(I$) = "E" Then
                           BoxButton = 6
                           Exit Do
                        End If
                     End If
                     If BoxButton = 3 Then ' checkbox
                        If I$ = " " Then
                           SensitiveSelect = Not SensitiveSelect
                           GoSub DrawSearchCheckBoxs
                        End If
                     End If
                     If BoxButton = 1 Then
                        ' append/insert character into edit area.
                        VarI = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           VarI = 0 ' disallow control charcters
                        End If
                        If VarI Then
                           If LineX1 Then
                              LineX1 = 0
                              X1$ = ""
                              Box1Xposition1 = 1
                              Box1Xposition2 = 0
                           End If
                           If Insert1 Then
                              X1$ = Left$(X1$, Box1Xposition2) + I$ + Mid$(X1$, Box1Xposition2 + 1)
                              Box1Xposition2 = Box1Xposition2 + 1
                              If Box1Xposition2 > LC Then
                                 Box1Xposition1 = Box1Xposition1 + 1
                              End If
                           Else
                              If Box1Xposition2 + 1 > Len(X1$) Then
                                 X1$ = X1$ + I$ ' append
                                 Box1Xposition2 = Box1Xposition2 + 1
                                 If Box1Xposition2 > LC Then
                                    Box1Xposition1 = Box1Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X1$, Box1Xposition2 + 1, 1) = I$
                                 Box1Xposition2 = Box1Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        ' append/insert character into edit area.
                        VarI = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           VarI = 0 ' disallow control charcters
                        End If
                        If VarI Then
                           If LineX2 Then
                              LineX2 = 0
                              X2$ = ""
                              Box2Xposition1 = 1
                              Box2Xposition2 = 0
                           End If
                           If Insert2 Then
                              X2$ = Left$(X2$, Box2Xposition2) + I$ + Mid$(X2$, Box2Xposition2 + 1)
                              Box2Xposition2 = Box2Xposition2 + 1
                              If Box2Xposition2 > LC Then
                                 Box2Xposition1 = Box2Xposition1 + 1
                              End If
                           Else
                              If Box2Xposition2 + 1 > Len(X2$) Then
                                 X2$ = X2$ + I$ ' append
                                 Box2Xposition2 = Box2Xposition2 + 1
                                 If Box2Xposition2 > LC Then
                                    Box2Xposition1 = Box2Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X2$, Box2Xposition2 + 1, 1) = I$
                                 Box2Xposition2 = Box2Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(I$, 1))
                  Case 82 ' Insert
                     If BoxButton = 1 Then
                        Insert1 = Not Insert1
                        If Insert1 Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                     If BoxButton = 2 Then
                        Insert2 = Not Insert2
                        If Insert2 Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                  Case 83 ' Delete
                     If BoxButton = 1 Then
                        LineX1 = 0
                        GoSub DisplayFileLine
                        If Len(X1$) > 0 Then
                           X1$ = Left$(X1$, Box1Xposition2) + Mid$(X1$, Box1Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        GoSub DisplayFileLine
                        If Len(X2$) > 0 Then
                           X2$ = Left$(X2$, Box2Xposition2) + Mid$(X2$, Box2Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 71 ' Home
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Box1Xposition2 > 0 Then
                           Box1Xposition1 = 1
                           Box1Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Box2Xposition2 > 0 Then
                           Box2Xposition1 = 1
                           Box2Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 79 ' End
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Box1Xposition2 < Len(X1$) Then
                           Box1Xposition2 = Len(X1$)
                           Box1Xposition1 = Box1Xposition2 - LC + 1
                           If Box1Xposition1 < 1 Then
                              Box1Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Box2Xposition2 < Len(X2$) Then
                           Box2Xposition2 = Len(X2$)
                           Box2Xposition1 = Box2Xposition2 - LC + 1
                           If Box2Xposition1 < 1 Then
                              Box2Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 75 ' Left
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Len(X1$) Then
                           If Box1Xposition2 > 0 Then
                              Box1Xposition2 = Box1Xposition2 - 1
                              If Box1Xposition2 - LC <= Box1Xposition1 Then
                                 Box1Xposition1 = Box1Xposition1 - 1
                                 If Box1Xposition1 < 1 Then
                                    Box1Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Len(X2$) Then
                           If Box2Xposition2 > 0 Then
                              Box2Xposition2 = Box2Xposition2 - 1
                              If Box2Xposition2 - LC <= Box2Xposition1 Then
                                 Box2Xposition1 = Box2Xposition1 - 1
                                 If Box2Xposition1 < 1 Then
                                    Box2Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                  Case 77 ' Right
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Len(X1$) Then
                           If Box1Xposition2 < Len(X1$) Then
                              Box1Xposition2 = Box1Xposition2 + 1
                              If Box1Xposition2 > Box1Xposition1 + LC - 1 Then
                                 Box1Xposition1 = Box1Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Len(X2$) Then
                           If Box2Xposition2 < Len(X2$) Then
                              Box2Xposition2 = Box2Xposition2 + 1
                              If Box2Xposition2 > Box2Xposition1 + LC - 1 Then
                                 Box2Xposition1 = Box2Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case 72 ' up
                     If BoxButton = 3 Then ' checkbox
                        SensitiveSelect = -1
                        GoSub DrawSearchCheckBoxs
                     End If
                  Case 80 ' down
                     If BoxButton = 3 Then ' checkbox
                        SensitiveSelect = 0
                        GoSub DrawSearchCheckBoxs
                     End If
                  Case 15 ' shift-tab
                     BoxButton = BoxButton - 1
                     If BoxButton = 0 Then
                        BoxButton = 6
                     End If
                     Select Case BoxButton
                        Case 1, 2 ' entry area
                           GoSub DrawSearchBoxButtons
                           GoSub DisplayFileLine
                        Case 3 ' checkbox
                           Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
                        Case 4 ' replace
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 1, 1, 8, 8
                        Case 5 ' replace all
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 11, 1, 8, 8
                        Case 6 ' exit
                           GoSub DrawSearchBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 25, 1, 8, 8
                     End Select
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = SearchXcoor
                     Ycoor3 = SearchYcoor
                     Call RestoreScreen3
                     GoSub DrawSearchBox
                     _KeyClear
                  Case 141 ' ctrl-up
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                     _KeyClear
                  Case 145 ' ctrl-down
                     If Xcoor3 < 17 Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen3
                           GoSub DrawSearchBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     If Xcoor3 < 13 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     Else
                        If Xcoor3 < 17 Then
                           Xcoor3 = 17
                           Call RestoreScreen3
                           GoSub DrawSearchBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen3
                           GoSub DrawSearchBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen3
                           GoSub DrawSearchBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= 17 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen3
                        GoSub DrawSearchBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else ' click on button
            If MouseX = XC1 Then
               ' entry area 1
               If MouseY >= YC1 And MouseY <= YC1 + LC Then
                  BoxButton = 1
                  GoSub DrawSearchBox
               End If
            End If
            If MouseX = XC2 Then
               ' entry area 2
               If MouseY >= YC2 And MouseY <= YC2 + LC Then
                  BoxButton = 2
                  GoSub DrawSearchBox
               End If
            End If
            If MouseX = Xcoor3 + 5 Then
               ' click checkbox
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 3 Then
                  SensitiveSelect = Not SensitiveSelect
                  GoSub DrawSearchCheckBoxs
               End If
            End If
            If MouseX = Xcoor3 + 6 Then
               ' click <replace>
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 9 Then
                  BoxButton = 4
                  Exit Do
               End If
               ' click <replace all>
               If MouseY >= Ycoor3 + 11 And MouseY <= Ycoor3 + 23 Then
                  BoxButton = 5
                  Exit Do
               End If
               ' click <exit>
               If MouseY >= Ycoor3 + 25 And MouseY <= Ycoor3 + 30 Then
                  BoxButton = 6
                  Exit Do
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen3
               GoSub DrawSearchBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 < 17 Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen3
               GoSub DrawSearchBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates
   SearchXcoor = Xcoor3
   SearchYcoor = Ycoor3

   ' restore screen area.
   Call RestoreScreen3
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   Select Case BoxButton
      Case 1 ' search
         SearchBox2 = 1
      Case 2 ' replace
         SearchBox2 = 2
      Case 3 ' sensitive
         SearchBox2 = 1
      Case 4 ' replace
         SearchBox2 = 1
      Case 5 ' replaceall
         SearchBox2 = 2
      Case 6 ' cancel
         SearchBox2 = 0
   End Select
   Locate , , 1, 8, 8
   _KeyClear
   Exit Function

   ' draw box
   DrawSearchBox:
   Color SearchBoxBorderColor, SearchBoxBackGround
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   SearchBoxTitle$ = " Search "
   TempX = 16 - Len(SearchBoxTitle$) / 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color SearchBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print SearchBoxTitle$;

   ' display search text
   Color SearchBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 1, 0
   Print "Search string:"
   Locate Xcoor3 + 3, Ycoor3 + 1, 0
   Print "Replacement string:"

   Locate Xcoor3 + 5, Ycoor3 + 1, 0
   Color SearchBoxButton1Color, SearchBoxBackGround
   Print "[ ] Case Sensitive";
   Locate Xcoor3 + 5, Ycoor3 + 10, 0
   Color Magenta
   Print "S";

   GoSub DrawSearchCheckBoxs
   GoSub DrawSearchBoxButtons
   Locate , , , 8, 8
   XC1 = Xcoor3 + 2
   YC1 = Ycoor3 + 1
   XC2 = Xcoor3 + 4
   YC2 = Ycoor3 + 1

   Color White, Black
   Locate XC1, YC1, 1
   Print Space$(LC);
   Locate XC2, YC2, 1
   Print Space$(LC);
   If Len(X1$) Then
      Locate XC1, YC1, 1
      Color White
      Print Mid$(X1$, Box1Xposition1, LC);
   End If
   If Len(X2$) Then
      Locate XC2, YC2, 1
      Color White
      Print Mid$(X2$, Box2Xposition1, LC);
   End If

   Select Case BoxButton
      Case 1, 2 ' entry area
         GoSub DisplayFileLine
      Case 3 ' checkbox
         Locate Xcoor3 + 5, Ycoor3 + 2, 1
      Case 4 ' replace
         GoSub DrawSearchBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 1, 1
      Case 5 ' replaceall
         GoSub DrawSearchBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 11, 1
      Case 6 ' cancel
         GoSub DrawSearchBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 25, 1
   End Select
   Return

   ' display checkboxs
   DrawSearchCheckBoxs:
   '-[ ] Case-sensitive
   If SensitiveSelect Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color SearchBoxButton1Color, SearchBoxButtonBackGround
      Print "X";
   Else
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color SearchBoxButton1Color, SearchBoxButtonBackGround
      Print " ";
   End If
   If BoxButton = 3 Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
   End If
   Return

   ' display buttuns
   DrawSearchBoxButtons:
   '-<Replace> <Replace All> <Exit>
   Select Case BoxButton
      Case 4 ' replace
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color SearchBoxButton1Color, SearchBoxButtonBackGround
         Print "<Replace>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "R";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Replace All>";
         Locate Xcoor3 + 6, Ycoor3 + 20, 0
         Color Magenta
         Print "A";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case 5 ' replaceall
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Replace>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "R";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color SearchBoxButton1Color, SearchBoxButtonBackGround
         Print "<Replace All>";
         Locate Xcoor3 + 6, Ycoor3 + 20, 0
         Color Magenta
         Print "A";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case 6 ' cancel
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Replace>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "R";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Replace All>";
         Locate Xcoor3 + 6, Ycoor3 + 20, 0
         Color Magenta
         Print "A";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color SearchBoxButton1Color, SearchBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case Else
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Replace>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "R";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Replace All>";
         Locate Xcoor3 + 6, Ycoor3 + 20, 0
         Color Magenta
         Print "A";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color SearchBoxButton2Color, SearchBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
   End Select
   Color White, Black
   Return

   ' display current entry area.
   DisplayFileLine:
   If BoxButton = 1 Then
      Locate XC1, YC1, 1
      Print Space$(LC);
   End If
   If BoxButton = 2 Then
      Locate XC2, YC2, 1
      Print Space$(LC);
   End If

   ' display edit line and position cursor.
   If BoxButton = 1 Then
      Locate XC1, YC1, 1
      If Len(X1$) Then
         If LineX1 Then
            Color Black, Plain
         Else
            Color White
         End If
         Print Mid$(X1$, Box1Xposition1, LC);
      End If
      Locate XC1, YC1 + Box1Xposition2 - Box1Xposition1 + 1, 1
      If Insert1 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
      Color White, Black
   End If

   If BoxButton = 2 Then
      Locate XC2, YC2, 1
      If Len(X2$) Then
         If LineX2 Then
            Color Black, Plain
         Else
            Color White
         End If
         Print Mid$(X2$, Box2Xposition1, LC);
      End If
      Locate XC2, YC2 + Box2Xposition2 - Box2Xposition1 + 1, 1
      If Insert2 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
      Color White, Black
   End If
   Return

   ' reset cursor
   ToggleInsert:
   If BoxButton = 1 Then
      If Insert1 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
   End If
   If BoxButton = 2 Then
      If Insert2 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
   End If
   Return
End Function

Rem ReplaceBox w/ Replace/Skip/Cancel
Function ReplaceBox (X, X!)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' get replace box colors
   ReplaceBoxBorderColor = Yellow
   ReplaceBoxTitleColor = White
   ReplaceBoxTextColor = White
   ReplaceBoxButton1Color = White
   ReplaceBoxButton2Color = Plain
   ReplaceBackGround = 1
   ReplaceButtonBackGround = 0

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen3

   ' declare replace box coordinates.
   Xcoor3 = X
   Ycoor3 = 10

   ' draw box
   BoxButton = 1
   GoSub DrawReplaceBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYz$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 3
                     Exit Do
                  Case Chr$(9) ' tab
                     BoxButton = BoxButton + 1
                     If BoxButton = 4 Then
                        BoxButton = 1
                     End If
                     GoSub DrawReplaceBoxButtons
                  Case Chr$(1) ' ctrl-a
                     ReplaceBackGround = ReplaceBackGround + 1
                     If ReplaceBackGround = 8 Then
                        ReplaceBackGround = 0
                     End If
                     GoSub DrawReplaceBox
                  Case Chr$(2) ' ctrl-b
                     ReplaceButtonBackGround = ReplaceButtonBackGround + 1
                     If ReplaceButtonBackGround = 8 Then
                        ReplaceButtonBackGround = 0
                     End If
                     GoSub DrawReplaceBox
                  Case Chr$(4) ' ctrl-d
                     ReplaceBoxBorderColor = ReplaceBoxBorderColor + 1
                     If ReplaceBoxBorderColor = 16 Then
                        ReplaceBoxBorderColor = 0
                     End If
                     GoSub DrawReplaceBox
                  Case Chr$(5) ' ctrl-e
                     ReplaceBoxTitleColor = ReplaceBoxTitleColor + 1
                     If ReplaceBoxTitleColor = 16 Then
                        ReplaceBoxTitleColor = 0
                     End If
                     GoSub DrawReplaceBox
                  Case Chr$(6) ' ctrl-f
                     ReplaceBoxTextColor = ReplaceBoxTextColor + 1
                     If ReplaceBoxTextColor = 16 Then
                        ReplaceBoxTextColor = 0
                     End If
                     GoSub DrawReplaceBox
                  Case Chr$(7) ' ctrl-g
                     ReplaceBoxButton1Color = ReplaceBoxButton1Color + 1
                     If ReplaceBoxButton1Color = 16 Then
                        ReplaceBoxButton1Color = 0
                     End If
                     GoSub DrawReplaceBox
                  Case Chr$(8) ' ctrl-h
                     ReplaceBoxButton2Color = ReplaceBoxButton2Color + 1
                     If ReplaceBoxButton2Color = 16 Then
                        ReplaceBoxButton2Color = 0
                     End If
                     GoSub DrawReplaceBox
                  Case Else
                     If UCase$(X$) = "R" Then
                        BoxButton = 1
                        Exit Do
                     End If
                     If UCase$(X$) = "S" Then
                        BoxButton = 2
                        Exit Do
                     End If
                     If UCase$(X$) = "C" Then
                        BoxButton = 3
                        Exit Do
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 75, 15 ' left/shift-tab
                     BoxButton = BoxButton - 1
                     If BoxButton = 0 Then
                        BoxButton = 3
                     End If
                     GoSub DrawReplaceBoxButtons
                  Case 77 ' right
                     BoxButton = BoxButton + 1
                     If BoxButton = 4 Then
                        BoxButton = 1
                     End If
                     GoSub DrawReplaceBoxButtons
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = X
                     Ycoor3 = 10
                     Call RestoreScreen3
                     GoSub DrawReplaceBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     X$ = ""
                     If Xcoor3 < 17 Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen3
                           GoSub DrawReplaceBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     X$ = ""
                     If Xcoor3 < 13 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     Else
                        If Xcoor3 < 17 Then
                           Xcoor3 = 17
                           Call RestoreScreen3
                           GoSub DrawReplaceBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen3
                           GoSub DrawReplaceBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen3
                           GoSub DrawReplaceBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= 17 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen3
                        GoSub DrawReplaceBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 6 Then
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 9 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 12 And MouseY <= Ycoor3 + 17 Then
                  BoxButton = 2
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 20 And MouseY <= Ycoor3 + 27 Then
                  BoxButton = 3
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 6 Then
            '<Replace>  <Skip>  <Cancel>
            If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 9 Then
               If BoxButton <> 1 Then
                  BoxButton = 1
                  GoSub DrawReplaceBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 12 And MouseY <= Ycoor3 + 17 Then
               If BoxButton <> 2 Then
                  BoxButton = 2
                  GoSub DrawReplaceBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 20 And MouseY <= Ycoor3 + 27 Then
               If BoxButton <> 3 Then
                  BoxButton = 3
                  GoSub DrawReplaceBoxButtons
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen3
               GoSub DrawReplaceBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 < 17 Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen3
               GoSub DrawReplaceBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _KeyClear
   _Delay .1

   ' restore screen area.
   Call RestoreScreen3
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then ' Replace
      ReplaceBox = -1
   Else
      If BoxButton = 2 Then ' Skip
         ReplaceBox = 1
      Else
         ReplaceBox = 0 ' Cancel
      End If
   End If
   Exit Function

   ' draw box
   DrawReplaceBox:
   Color ReplaceBoxBorderColor, ReplaceBackGround
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);
   Color ReplaceBoxTitleColor
   Locate Xcoor3, Ycoor3 + 10, 0
   Print " Replace ";

   ' display replace text
   Color ReplaceBoxTextColor
   Locate Xcoor3 + 2, Ycoor3 + 1, 0
   Var1$ = "Text in line:" + Str$(X!)
   Print Var1$;
   Locate Xcoor3 + 4, Ycoor3 + 1, 0
   Var1$ = "Replace text?"
   Print Var1$;
   GoSub DrawReplaceBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawReplaceBoxButtons:
   Select Case BoxButton
      '<Replace>  <Skip>  <Cancel>
      Case 1
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color ReplaceBoxButton1Color, ReplaceButtonBackGround
         Print "<Replace>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "R";

         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color ReplaceBoxButton2Color, ReplaceButtonBackGround
         Print "<Skip>";
         Locate Xcoor3 + 6, Ycoor3 + 13, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 20, 0
         Color ReplaceBoxButton2Color, ReplaceButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 21, 0
         Color Magenta
         Print "C";
      Case 2
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color ReplaceBoxButton2Color, ReplaceButtonBackGround
         Print "<Replace>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "R";

         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color ReplaceBoxButton1Color, ReplaceButtonBackGround
         Print "<Skip>";
         Locate Xcoor3 + 6, Ycoor3 + 13, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 20, 0
         Color ReplaceBoxButton2Color, ReplaceButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 21, 0
         Color Magenta
         Print "C";
      Case 3
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color ReplaceBoxButton2Color, ReplaceButtonBackGround
         Print "<Replace>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "R";

         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color ReplaceBoxButton2Color, ReplaceButtonBackGround
         Print "<Skip>";
         Locate Xcoor3 + 6, Ycoor3 + 13, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 4, Ycoor3 + 20, 0
         Color ReplaceBoxButton1Color, ReplaceButtonBackGround
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 21, 0
         Color Magenta
         Print "C";
   End Select
   Color Plain, Black
   Return
End Function

Rem MemoryMonitorBox
Function MonitorBox (X1$, X2$)
   Dim TempArrayY3(1 To 2000) As Integer
   Dim TempArrayZ3(1 To 2000) As Integer

   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   GoSub SaveScreenX

   ' get search box colors
   MonitorBoxBorderColor = Yellow
   MonitorBoxTitleColor = White
   MonitorBoxTextColor = White
   MonitorBoxButton1Color = White
   MonitorBoxButton2Color = Plain
   MonitorBoxBackGround = 1
   MonitorBoxButtonBackGround = 0

   ' declare input box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   XC1 = Xcoor3 + 2
   YC1 = Ycoor3 + 1
   XC2 = Xcoor3 + 4
   YC2 = Ycoor3 + 1
   LC = 30

   ' draw box
   BoxButton = 1
   DisplaySelect = 0
   GoSub DrawMonitorBox

   ' init entry area position.
   Box1Xposition1 = 1
   Box1Xposition2 = 0
   Box2Xposition1 = 1
   Box2Xposition2 = 0

   ' display edit entry area.
   Insert1 = -1
   Insert2 = -1
   LineX2 = 0
   If Len(X2$) Then
      LineX2 = -1
   End If
   BoxButton = 2
   GoSub DisplayFileLine

   LineX1 = 0
   If Len(X1$) Then
      LineX1 = -1
   End If
   BoxButton = 1
   GoSub DisplayFileLine

   ' wait for keypress or mouse
   _KeyClear
   Control.Break = False
   Monitor.Box = False
   Do
      If Control.Break Or Monitor.Box Then
         Control.Break = False
         Monitor.Box = False
         GoSub ToggleInsert
      End If

      I$ = INKEYz$
      If Len(I$) Then
         Select Case Len(I$)
            Case 1
               Select Case I$
                  Case Chr$(8) ' backspace
                     If BoxButton = 1 Then
                        If Len(X1$) Then
                           If LineX1 Then
                              LineX1 = 0
                              X1$ = ""
                              Box1Xposition1 = 1
                              Box1Xposition2 = 0
                              GoSub DisplayFileLine
                           End If
                           If Box1Xposition2 > 0 Then
                              If Insert1 Then ' destructive backspace
                                 X1$ = Left$(X1$, Box1Xposition2 - 1) + Mid$(X1$, Box1Xposition2 + 1)
                              End If
                              Box1Xposition2 = Box1Xposition2 - 1
                              If Box1Xposition2 - LC <= Box1Xposition1 Then
                                 Box1Xposition1 = Box1Xposition1 - 1
                                 If Box1Xposition1 < 1 Then
                                    Box1Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        If Len(X2$) Then
                           If LineX2 Then
                              LineX2 = 0
                              X2$ = ""
                              Box2Xposition1 = 1
                              Box2Xposition2 = 0
                              GoSub DisplayFileLine
                           End If
                           If Box2Xposition2 > 0 Then
                              If Insert2 Then ' destructive backspace
                                 X2$ = Left$(X2$, Box2Xposition2 - 1) + Mid$(X2$, Box2Xposition2 + 1)
                              End If
                              Box2Xposition2 = Box2Xposition2 - 1
                              If Box2Xposition2 - LC <= Box2Xposition1 Then
                                 Box2Xposition1 = Box2Xposition1 - 1
                                 If Box2Xposition1 < 1 Then
                                    Box2Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27) ' exit
                     BoxButton = 6
                     Exit Do
                  Case Chr$(9) ' tab
                     BoxButton = BoxButton + 1
                     If BoxButton = 7 Then
                        BoxButton = 1
                     End If
                     Select Case BoxButton
                        Case 1, 2 ' entry area
                           GoSub DrawMonitorBoxButtons
                           GoSub DisplayFileLine
                        Case 3 ' checkbox
                           Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
                        Case 4 ' replace
                           GoSub DrawMonitorBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 1, 1, 8, 8
                        Case 5 ' replaceall
                           GoSub DrawMonitorBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 11, 1, 8, 8
                        Case 6 ' exit
                           GoSub DrawMonitorBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 25, 1, 8, 8
                     End Select
                  Case Chr$(1) ' ctrl-a
                     MonitorBoxBackGround = MonitorBoxBackGround + 1
                     If MonitorBoxBackGround = 8 Then
                        MonitorBoxBackGround = 0
                     End If
                     GoSub DrawMonitorBox
                  Case Chr$(2) ' ctrl-b
                     MonitorBoxButtonBackGround = MonitorBoxButtonBackGround + 1
                     If MonitorBoxButtonBackGround = 8 Then
                        MonitorBoxButtonBackGround = 0
                     End If
                     GoSub DrawMonitorBox
                  Case Chr$(4) ' ctrl-d
                     MonitorBoxBorderColor = MonitorBoxBorderColor + 1
                     If MonitorBoxBorderColor = 16 Then
                        MonitorBoxBorderColor = 0
                     End If
                     GoSub DrawMonitorBox
                  Case Chr$(5) ' ctrl-e
                     MonitorBoxTitleColor = MonitorBoxTitleColor + 1
                     If MonitorBoxTitleColor = 16 Then
                        MonitorBoxTitleColor = 0
                     End If
                     GoSub DrawMonitorBox
                  Case Chr$(6) ' ctrl-f
                     MonitorBoxTextColor = MonitorBoxTextColor + 1
                     If MonitorBoxTextColor = 16 Then
                        MonitorBoxTextColor = 0
                     End If
                     GoSub DrawMonitorBox
                  Case Chr$(7) ' ctrl-g
                     MonitorBoxButton1Color = MonitorBoxButton1Color + 1
                     If MonitorBoxButton1Color = 16 Then
                        MonitorBoxButton1Color = 0
                     End If
                     GoSub DrawMonitorBox
                  Case Chr$(11) ' ctrl-k
                     MonitorBoxButton2Color = MonitorBoxButton2Color + 1
                     If MonitorBoxButton2Color = 16 Then
                        MonitorBoxButton2Color = 0
                     End If
                     GoSub DrawMonitorBox
                  Case Else
                     If BoxButton >= 3 And BoxButton <= 6 Then
                        If UCase$(I$) = "D" Then
                           DisplaySelect = Not DisplaySelect
                           GoSub DrawSearchCheckBoxs
                        End If
                        If UCase$(I$) = "S" Then
                           BoxButton = 4
                           Exit Do
                        End If
                        If UCase$(I$) = "C" Then
                           BoxButton = 5
                           Exit Do
                        End If
                        If UCase$(I$) = "E" Then
                           BoxButton = 6
                           Exit Do
                        End If
                     End If
                     If BoxButton = 3 Then ' checkbox
                        If I$ = " " Then
                           DisplaySelect = Not DisplaySelect
                           GoSub DrawSearchCheckBoxs
                        End If
                     End If
                     If BoxButton = 1 Then
                        ' append/insert character into edit area.
                        VarI = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           VarI = 0 ' disallow control charcters
                        End If
                        If VarI Then
                           If LineX1 Then
                              LineX1 = 0
                              X1$ = ""
                              Box1Xposition1 = 1
                              Box1Xposition2 = 0
                           End If
                           If Insert1 Then
                              X1$ = Left$(X1$, Box1Xposition2) + I$ + Mid$(X1$, Box1Xposition2 + 1)
                              Box1Xposition2 = Box1Xposition2 + 1
                              If Box1Xposition2 > LC Then
                                 Box1Xposition1 = Box1Xposition1 + 1
                              End If
                           Else
                              If Box1Xposition2 + 1 > Len(X1$) Then
                                 X1$ = X1$ + I$ ' append
                                 Box1Xposition2 = Box1Xposition2 + 1
                                 If Box1Xposition2 > LC Then
                                    Box1Xposition1 = Box1Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X1$, Box1Xposition2 + 1, 1) = I$
                                 Box1Xposition2 = Box1Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        ' append/insert character into edit area.
                        VarI = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           VarI = 0 ' disallow control charcters
                        End If
                        If VarI Then
                           If LineX2 Then
                              LineX2 = 0
                              X2$ = ""
                              Box2Xposition1 = 1
                              Box2Xposition2 = 0
                           End If
                           If Insert2 Then
                              X2$ = Left$(X2$, Box2Xposition2) + I$ + Mid$(X2$, Box2Xposition2 + 1)
                              Box2Xposition2 = Box2Xposition2 + 1
                              If Box2Xposition2 > LC Then
                                 Box2Xposition1 = Box2Xposition1 + 1
                              End If
                           Else
                              If Box2Xposition2 + 1 > Len(X2$) Then
                                 X2$ = X2$ + I$ ' append
                                 Box2Xposition2 = Box2Xposition2 + 1
                                 If Box2Xposition2 > LC Then
                                    Box2Xposition1 = Box2Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X2$, Box2Xposition2 + 1, 1) = I$
                                 Box2Xposition2 = Box2Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(I$, 1))
                  Case 82 ' Insert
                     If BoxButton = 1 Then
                        Insert1 = Not Insert1
                        If Insert1 Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                     If BoxButton = 2 Then
                        Insert2 = Not Insert2
                        If Insert2 Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                  Case 83 ' Delete
                     If BoxButton = 1 Then
                        LineX1 = 0
                        GoSub DisplayFileLine
                        If Len(X1$) > 0 Then
                           X1$ = Left$(X1$, Box1Xposition2) + Mid$(X1$, Box1Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        GoSub DisplayFileLine
                        If Len(X2$) > 0 Then
                           X2$ = Left$(X2$, Box2Xposition2) + Mid$(X2$, Box2Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 71 ' Home
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Box1Xposition2 > 0 Then
                           Box1Xposition1 = 1
                           Box1Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Box2Xposition2 > 0 Then
                           Box2Xposition1 = 1
                           Box2Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 79 ' End
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Box1Xposition2 < Len(X1$) Then
                           Box1Xposition2 = Len(X1$)
                           Box1Xposition1 = Box1Xposition2 - LC + 1
                           If Box1Xposition1 < 1 Then
                              Box1Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Box2Xposition2 < Len(X2$) Then
                           Box2Xposition2 = Len(X2$)
                           Box2Xposition1 = Box2Xposition2 - LC + 1
                           If Box2Xposition1 < 1 Then
                              Box2Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 75 ' Left
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Len(X1$) Then
                           If Box1Xposition2 > 0 Then
                              Box1Xposition2 = Box1Xposition2 - 1
                              If Box1Xposition2 - LC <= Box1Xposition1 Then
                                 Box1Xposition1 = Box1Xposition1 - 1
                                 If Box1Xposition1 < 1 Then
                                    Box1Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Len(X2$) Then
                           If Box2Xposition2 > 0 Then
                              Box2Xposition2 = Box2Xposition2 - 1
                              If Box2Xposition2 - LC <= Box2Xposition1 Then
                                 Box2Xposition1 = Box2Xposition1 - 1
                                 If Box2Xposition1 < 1 Then
                                    Box2Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                  Case 77 ' Right
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Len(X1$) Then
                           If Box1Xposition2 < Len(X1$) Then
                              Box1Xposition2 = Box1Xposition2 + 1
                              If Box1Xposition2 > Box1Xposition1 + LC - 1 Then
                                 Box1Xposition1 = Box1Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Len(X2$) Then
                           If Box2Xposition2 < Len(X2$) Then
                              Box2Xposition2 = Box2Xposition2 + 1
                              If Box2Xposition2 > Box2Xposition1 + LC - 1 Then
                                 Box2Xposition1 = Box2Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case 72 ' up
                     If BoxButton = 3 Then ' checkbox
                        DisplaySelect = -1
                        GoSub DrawSearchCheckBoxs
                     End If
                  Case 80 ' down
                     If BoxButton = 3 Then ' checkbox
                        DisplaySelect = 0
                        GoSub DrawSearchCheckBoxs
                     End If
                  Case 15 ' shift-tab
                     BoxButton = BoxButton - 1
                     If BoxButton = 0 Then
                        BoxButton = 6
                     End If
                     Select Case BoxButton
                        Case 1, 2 ' entry area
                           GoSub DrawMonitorBoxButtons
                           GoSub DisplayFileLine
                        Case 3 ' checkbox
                           Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
                        Case 4 ' replace
                           GoSub DrawMonitorBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 1, 1, 8, 8
                        Case 5 ' replace all
                           GoSub DrawMonitorBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 11, 1, 8, 8
                        Case 6 ' exit
                           GoSub DrawMonitorBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 25, 1, 8, 8
                     End Select
                  Case 76, 143 ' keypad-5 center
                     Xcoor3 = 10
                     Ycoor3 = 10
                     GoSub RestoreScreenX
                     GoSub DrawMonitorBox
                     _KeyClear
                  Case 141 ' ctrl-up
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     End If
                     _KeyClear
                  Case 145 ' ctrl-down
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           GoSub RestoreScreenX
                           GoSub DrawMonitorBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           GoSub RestoreScreenX
                           GoSub DrawMonitorBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           GoSub RestoreScreenX
                           GoSub DrawMonitorBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           GoSub RestoreScreenX
                           GoSub DrawMonitorBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      If Status Then
         Z = 23
      Else
         Z = 24
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        GoSub RestoreScreenX
                        GoSub DrawMonitorBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else ' click on button
            If MouseX = XC1 Then
               ' entry area 1
               If MouseY >= YC1 And MouseY <= YC1 + LC Then
                  BoxButton = 1
                  GoSub DrawMonitorBox
               End If
            End If
            If MouseX = XC2 Then
               ' entry area 2
               If MouseY >= YC2 And MouseY <= YC2 + LC Then
                  BoxButton = 2
                  GoSub DrawMonitorBox
               End If
            End If
            If MouseX = Xcoor3 + 5 Then
               ' click checkbox
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 3 Then
                  DisplaySelect = Not DisplaySelect
                  GoSub DrawSearchCheckBoxs
               End If
            End If
            If MouseX = Xcoor3 + 6 Then
               ' click <system>
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 8 Then
                  BoxButton = 4
                  Exit Do
               End If
               ' click <continue>
               If MouseY >= Ycoor3 + 11 And MouseY <= Ycoor3 + 20 Then
                  BoxButton = 5
                  Exit Do
               End If
               ' click <exit>
               If MouseY >= Ycoor3 + 25 And MouseY <= Ycoor3 + 30 Then
                  BoxButton = 6
                  Exit Do
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               GoSub RestoreScreenX
               GoSub DrawMonitorBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            If Status Then
               Z = 23
            Else
               Z = 24
            End If
            If Xcoor3 + 7 < Z Then
               Xcoor3 = Xcoor3 + 1
               GoSub RestoreScreenX
               GoSub DrawMonitorBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   GoSub RestoreScreenX
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   Select Case BoxButton
      Case 1 ' timer
         MonitorBox = 1
      Case 2 ' limit
         MonitorBox = 1
      Case 3 ' don't display
         MonitorBox = 1
      Case 4 ' restart
         MonitorBox = 2
      Case 5 ' continue
         MonitorBox = 1
      Case 6 ' exit
         MonitorBox = 0
   End Select
   Locate , , 1, 8, 8
   _KeyClear
   Monitor.Box = -1
   Exit Function

   ' draw box
   DrawMonitorBox:
   Color MonitorBoxBorderColor, MonitorBoxBackGround
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   MonitorBoxTitle$ = " MEMORY LOW WARNING "
   TempX = 16 - Len(MonitorBoxTitle$) / 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color MonitorBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print MonitorBoxTitle$;

   ' display search text
   Color MonitorBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 1, 0
   Print "Monitor timer(seconds):"
   Locate Xcoor3 + 3, Ycoor3 + 1, 0

   Print "Monitor limit(MB.):"

   Locate Xcoor3 + 5, Ycoor3 + 1, 0
   Color MonitorBoxButton1Color, MonitorBoxBackGround
   Print "[ ] Don't display again";
   Locate Xcoor3 + 5, Ycoor3 + 5, 0
   Color Magenta
   Print "D";

   GoSub DrawSearchCheckBoxs
   GoSub DrawMonitorBoxButtons
   Locate , , , 8, 8
   XC1 = Xcoor3 + 2
   YC1 = Ycoor3 + 1
   XC2 = Xcoor3 + 4
   YC2 = Ycoor3 + 1

   Color White, Black
   Locate XC1, YC1, 1
   Print Space$(LC);
   Locate XC2, YC2, 1
   Print Space$(LC);
   If Len(X1$) Then
      Locate XC1, YC1, 1
      Color White
      Print Mid$(X1$, Box1Xposition1, LC);
   End If
   If Len(X2$) Then
      Locate XC2, YC2, 1
      Color White
      Print Mid$(X2$, Box2Xposition1, LC);
   End If

   Select Case BoxButton
      Case 1, 2 ' entry area
         GoSub DisplayFileLine
      Case 3 ' checkbox
         Locate Xcoor3 + 5, Ycoor3 + 2, 1
      Case 4 ' replace
         GoSub DrawMonitorBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 1, 1
      Case 5 ' replaceall
         GoSub DrawMonitorBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 11, 1
      Case 6 ' cancel
         GoSub DrawMonitorBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 25, 1
   End Select
   Return

   ' display checkboxs
   DrawSearchCheckBoxs:
   '-[ ] Don't display again
   If DisplaySelect Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color MonitorBoxButton1Color, MonitorBoxButtonBackGround
      Print "X";
   Else
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color MonitorBoxButton1Color, MonitorBoxButtonBackGround
      Print " ";
   End If
   If BoxButton = 3 Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
   End If
   Return

   ' display buttuns
   DrawMonitorBoxButtons:
   '-<System>  <Continue>    <Exit>
   Select Case BoxButton
      Case 4 ' replace
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color MonitorBoxButton1Color, MonitorBoxButtonBackGround
         Print "<System>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<Continue>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case 5 ' replaceall
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<System>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color MonitorBoxButton1Color, MonitorBoxButtonBackGround
         Print "<Continue>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case 6 ' cancel
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<System>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<Continue>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color MonitorBoxButton1Color, MonitorBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case Else
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<System>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<Continue>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color MonitorBoxButton2Color, MonitorBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
   End Select
   Color White, Black
   Return

   ' display current entry area.
   DisplayFileLine:
   If BoxButton = 1 Then
      Locate XC1, YC1, 1
      Print Space$(LC);
   End If
   If BoxButton = 2 Then
      Locate XC2, YC2, 1
      Print Space$(LC);
   End If

   ' display edit line and position cursor.
   If BoxButton = 1 Then
      Locate XC1, YC1, 1
      If Len(X1$) Then
         If LineX1 Then
            Color Black, Plain
         Else
            Color White
         End If
         Print Mid$(X1$, Box1Xposition1, LC);
      End If
      Locate XC1, YC1 + Box1Xposition2 - Box1Xposition1 + 1, 1
      If Insert1 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
      Color White, Black
   End If

   If BoxButton = 2 Then
      Locate XC2, YC2, 1
      If Len(X2$) Then
         If LineX2 Then
            Color Black, Plain
         Else
            Color White
         End If
         Print Mid$(X2$, Box2Xposition1, LC);
      End If
      Locate XC2, YC2 + Box2Xposition2 - Box2Xposition1 + 1, 1
      If Insert2 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
      Color White, Black
   End If
   Return

   ' reset cursor
   ToggleInsert:
   If BoxButton = 1 Then
      If Insert1 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
   End If
   If BoxButton = 2 Then
      If Insert2 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
   End If
   Return

   ' screen save
   SaveScreenX:
   If Status Then
      V = 23
   Else
      V = 24
   End If
   For Var1 = 2 To V
      For Var2 = 1 To 80
         TempZ1 = Screen(Var1, Var2) ' screen char
         TempZ2 = Screen(Var1, Var2, 1) ' char color
         TempArrayY3((Var1 - 1) * 80 + Var2) = TempZ1
         TempArrayZ3((Var1 - 1) * 80 + Var2) = TempZ2
      Next
   Next
   Return

   ' screen restore
   RestoreScreenX:
   If Status Then
      V = 23
   Else
      V = 24
   End If
   For Var1 = 2 To V
      For Var2 = 1 To 80
         VarB = Int(TempArrayZ3((Var1 - 1) * 80 + Var2) / 16)
         VarF = TempArrayZ3((Var1 - 1) * 80 + Var2) Mod 16
         TempZ1 = TempArrayY3((Var1 - 1) * 80 + Var2)
         Locate Var1, Var2, 1
         Color VarF, VarB
         Print Chr$(TempZ1);
      Next
   Next
   Return
End Function

' alarm timer trap
Sub CheckAlarms
   ' check alarms
   For VarZZ = 1 To MaxAlarms
      If AlarmTime(VarZZ) = 0! Then
         AlarmFlags(VarZZ) = 0
      End If
   Next
   For VarZZ = 1 To MaxAlarms
      VarZ5 = AlarmFlags(VarZZ)
      VarZ2! = AlarmStart(VarZZ)
      VarZ3! = AlarmTime(VarZZ)
      If VarZ5 Then
         If VarZ2! > 0! And VarZ3! > 0! Then
            ElapsedTime! = Timer - VarZ2!
            If ElapsedTime! < 0! Then
               ElapsedTime! = ElapsedTime! + 86400!
            End If
            If ElapsedTime! >= VarZ3! Then
               TimeElapsed = True
            Else
               TimeElapsed = False
            End If
            If TimeElapsed Then
               VarZ = -1
               AlarmFlags(VarZZ) = False
               If AlarmBeep(VarZZ) = 0 Then
                  If MakeBeep Then
                     Sound Freq, Duration
                     _Delay AlarmDelay
                  End If
               End If
               If AlarmBeep(VarZZ) > 0 Then
                  If MakeBeep Then
                     For VarZZ2 = 1 To AlarmBeep(VarZZ)
                        Sound Freq, Duration
                        _Delay AlarmDelay
                     Next
                  End If
               End If
               If AlarmMusic(VarZZ) Then
                  VarZ$ = Melody$
                  Play VarZ$
               End If
               If AlarmColor(VarZZ) Then
                  AlarmTrapColor = AlarmColor(VarZZ)
               Else
                  AlarmTrapColor = White
               End If
               If AlarmType(VarZZ) = 0 Then
                  x = MessageBox(" Alarm ", "Alarm" + Str$(VarZZ) + " notice!|Time is " + Date$ + " " + Time$)
               Else
                  x = MessageBox(" Alarm ", "Alarm" + Str$(VarZZ) + " notice!")
               End If
               Color White, Black
            End If
         End If
      End If
   Next
End Sub

Sub DisplayTable (Var$)
   If LCase$(Var$) = "help" Or Var$ = "/?" Then
      Print #StdoutHandle, "TABLE"
      Print #StdoutHandle, ""
      Print #StdoutHandle, " Displays drive/netpath tables."
      Print #StdoutHandle, ""
      Print #StdoutHandle, "TABLE [OPTION]"
      Print #StdoutHandle, ""
      Print #StdoutHandle, " Searches tables for string option."
      Print #StdoutHandle, " May contain ? and * characters."
      Exit Sub
   End If
   Color Yellow
   f = 0
   Z1 = 0
   For V = 1 To 26
      If DriveTable(V) <> "" Then
         Var1$ = RTrim$(DriveTable(V))
         If Var$ = "" Then
            Z1 = -1
            If f = 0 Then
               Print #StdoutHandle, "Drive table:"
               f = -1
            End If
            Print #StdoutHandle, DriveTable(V)
         Else
            Call InstrSUB1(Flag, Var$, Var1$, 0)
            If Flag Then
               Z1 = -1
               If f = 0 Then
                  Print #StdoutHandle, "Drive table:"
                  f = -1
               End If
               Print #StdoutHandle, DriveTable(V)
            End If
         End If
      End If
   Next
   If Z1 Then
      Call KeyPrompt
   End If
   Color Yellow
   f = 0
   Z2 = 0
   For V = 1 To NetPathCount
      If NetPathTable(V) <> "" Then
         Var1$ = RTrim$(NetPathTable(V))
         If Var$ = "" Then
            Z2 = -1
            If f = 0 Then
               Print #StdoutHandle, "Netpath table:"
               f = -1
            End If
            Print #StdoutHandle, RTrim$(NetPathTable(V))
         Else
            Call InstrSUB1(Flag, Var$, Var1$, 0)
            If Flag Then
               Z2 = -1
               If f = 0 Then
                  Print #StdoutHandle, "Netpath table:"
                  f = -1
               End If
               Print #StdoutHandle, RTrim$(NetPathTable(V))
            End If
         End If
      End If
   Next
   If Z2 Then
      Call KeyPrompt
   End If
   If Z1 = 0 And Z2 = 0 Then
      Print #StdoutHandle, "No items found."
   End If
End Sub

' alarm menu
Sub AlarmMenu (Var$)
   Select Case UCase$(Var$)
      Case "ON"
         Timer(t8) On
         Print "Alarm trap on."
      Case "OFF"
         Timer(t8) Off
         Print "Alarm timer off."
         For VarZZ = 1 To MaxAlarms
            AlarmFlags(VarZZ) = 0
         Next
      Case "HELP"
         Color White
         Print "Helplist for alarms.."
         Color Yellow
         Print "ON/OFF"
         Print "  Sets alarm trap on or off."
         Print "SET"
         Print "  Sets seconds per alarm for" + Str$(MaxAlarms) + " alarms."
         Print "BEEP"
         Print "  Toggles alarm beeps."
         Print "CLEAR"
         Print "  Clears all alarms."
         Print "LIST"
         Print "  Lists settings for all alarms set."
         Print "COUNT"
         Print "  Displays number of alarms set."
         Print "TYPE"
         Print "  Toggles alarm time display."
         Print "COLOR"
         Print "  Sets alarm colors."
         Print "MUSIC"
         Print "  Toggles alarm music play."
         Color White
         Call KeyPrompt
      Case "CLEAR"
         For VarZZ = 1 To MaxAlarms
            AlarmFlags(VarZZ) = 0
            AlarmStart(VarZZ) = 0!
            AlarmTime(VarZZ) = 0!
            AlarmColor(VarZZ) = 0
            AlarmMusic(VarZZ) = 0
         Next
         Print "All alarms cleared."
      Case "COUNT"
         VarZ = -1
         Temp5 = 0
         For VarZZ = 1 To MaxAlarms
            If AlarmFlags(VarZZ) Then
               Temp5 = Temp5 + 1
            End If
         Next
         If Temp5 = 0 Then
            Print "No alarms are set."
         Else
            Print "There are" + Str$(Temp5) + " alarms set."
         End If
      Case "LIST"
         Temp5 = 0: TempC = 0
         VarZ = -1
         VarZ1 = 0
         For VarZZ = 1 To MaxAlarms
            If AlarmFlags(VarZZ) Then
               VarZ1 = -1
               Var2$ = "Alarm" + Str$(VarZZ) + " set to" + Str$(AlarmTime(VarZZ)) + " seconds."
               Elapsed! = Timer - AlarmStart(VarZZ)
               If Elapsed! < 0! Then Elapsed! = Elapsed! + 86400!
               Remaining! = AlarmTime(VarZZ) - Elapsed!
               Var3$ = LTrim$(Str$(Remaining!))
               If InStr(Var3$, ".") Then
                  Var3$ = Left$(Var3$, InStr(Var3$, ".") - 1)
               End If
               Var2$ = Var2$ + " (" + Var3$ + " seconds remaining)"
               If AlarmType(VarZZ) = 0 Then
                  Var2$ = Var2$ + " [time display on]"
               Else
                  Var2$ = Var2$ + " [time display off]"
               End If
               If AlarmBeep(VarZZ) >= 0 Then
                  Var2$ = Var2$ + " {beep on}"
               Else
                  Var2$ = Var2$ + " {beep off}"
               End If
               Print Var2$
               Temp5 = Temp5 + 1
            End If
         Next
         If Temp5 Then
            Call KeyPrompt
         Else
            Print "No alarms set."
         End If
      Case "BEEP"
         Print "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? ";
         Var$ = KeyboardLine$(3): Print
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            If AlarmFlags(VarZZ) Then
               Print "Enter number of beeps(on/off/<n>)? ";
               Var$ = KeyboardLine$(3): Print
               VarZZ2 = Int(Val(Var$))
               Select Case UCase$(Var$)
                  Case "ON"
                     AlarmBeep(VarZZ) = 0
                     Print "Alarm beep on."
                  Case "OFF"
                     AlarmBeep(VarZZ) = -1
                     Print "Alarm beep off."
                  Case Else
                     If VarZZ2 >= 1 Then
                        AlarmBeep(VarZZ) = VarZZ2
                        Print "Alarm beep on."
                     Else
                        Print "Alarm not set."
                     End If
               End Select
            Else
               Print "Alarm not set."
            End If
         Else
            Print "Unknown alarm."
         End If
      Case "MUSIC"
         Print "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? ";
         Var$ = KeyboardLine$(3): Print
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            If AlarmFlags(VarZZ) Then
               AlarmMusic(VarZZ) = Not AlarmMusic(VarZZ)
               If AlarmMusic(VarZZ) = 0 Then
                  Print "Alarm music off."
               Else
                  Print "Alarm music on."
               End If
            Else
               Print "Alarm not set."
            End If
         Else
            Print "Unknown alarm."
         End If
      Case "TYPE"
         Print "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? ";
         Var$ = KeyboardLine$(3): Print
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            If AlarmFlags(VarZZ) Then
               AlarmType(VarZZ) = Not AlarmType(VarZZ)
               If AlarmType(VarZZ) = 0 Then
                  Print "Alarm time display on."
               Else
                  Print "Alarm time display off."
               End If
            Else
               Print "Alarm not set."
            End If
         Else
            Print "Unknown alarm."
         End If
      Case "SET"
         Print "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? ";
         Var$ = KeyboardLine$(3): Print
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            Print "Enter alarm time(seconds)? ";
            Var2$ = KeyboardLine$(3): Print
            VarZZ2! = Int(Val(Var2$))
            If VarZZ2! = 0! Then
               AlarmFlags(VarZZ) = 0
               Print "Alarm" + Str$(VarZZ) + " cleared."
            Else
               If VarZZ2! > 0! And VarZZ2! <= 86400! Then
                  AlarmFlags(VarZZ) = -1
                  AlarmStart(VarZZ) = Timer
                  AlarmTime(VarZZ) = VarZZ2!
                  AlarmType(VarZZ) = 0
                  AlarmBeep(VarZZ) = 0
                  AlarmColor(VarZZ) = 0
                  AlarmMusic(VarZZ) = 0
                  Print "Alarm" + Str$(VarZZ) + " set."
               Else
                  Print "Illegal alarm time."
               End If
            End If
         Else
            Print "Unknown alarm."
         End If
      Case "COLOR"
         StartColor:
         Print "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? ";
         Var$ = KeyboardLine$(3): Print
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            Print "Enter alarm color(?=Help, 1-7)? ";
            Var2$ = KeyboardLine$(3): Print
            VarZZ2 = Int(Val(Var2$))
            If Var2$ = "?" Then
               Print "Foreground intensity:"
               Print "  1  Light blue"
               Print "  2  Light green"
               Print "  3  Light cyan"
               Print "  4  Light red"
               Print "  5  Light magenta"
               Print "  6  Yellow"
               Print "  7  White"
               Color Yellow
               Call KeyPrompt
               GoTo StartColor
            End If
            If VarZZ2 = 0 Then
               AlarmColor(VarZZ) = 0
               Print "Alarm" + Str$(VarZZ) + " color cleared."
            Else
               If VarZZ2 >= 1 And VarZZ2 <= 7 Then
                  AlarmColor(VarZZ) = VarZZ2 + 8
                  Print "Alarm" + Str$(VarZZ) + " color set."
               Else
                  Print "Illegal alarm color."
               End If
            End If
         Else
            Print "Unknown alarm."
         End If
   End Select
End Sub

Rem WhatisBox
Function WhatisBox (X1$, X2$)
   On Error GoTo WhatError
   Dim TempArrayY3(1 To 2000) As Integer
   Dim TempArrayZ3(1 To 2000) As Integer

   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   GoSub SaveScreenX

   ' get search box colors
   WhatisBoxBorderColor = Yellow
   WhatisBoxTitleColor = White
   WhatisBoxTextColor = White
   WhatisBoxButton1Color = White
   WhatisBoxButton2Color = Plain
   WhatisBoxBackGround = 1
   WhatisBoxButtonBackGround = 0

   ' declare input box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   XC1 = Xcoor3 + 2
   YC1 = Ycoor3 + 1
   XC2 = Xcoor3 + 4
   YC2 = Ycoor3 + 1
   LC = 30

   ' draw box
   BoxButton = 1
   DisplaySelect2 = 0
   GoSub DrawWhatisBox

   ' init entry area position.
   Box1Xposition1 = 1
   Box1Xposition2 = 0
   Box2Xposition1 = 1
   Box2Xposition2 = 0

   ' display edit entry area.
   Insert1 = -1
   Insert2 = -1
   LineX2 = 0
   If Len(X2$) Then
      LineX2 = -1
   End If
   BoxButton = 2
   GoSub DisplayFileLine

   LineX1 = 0
   If Len(X1$) Then
      LineX1 = -1
   End If
   BoxButton = 1
   GoSub DisplayFileLine

   ' wait for keypress or mouse
   _KeyClear
   Control.Break = False
   Monitor.Box = False
   Do
      If Control.Break Or Monitor.Box Then
         Control.Break = False
         Monitor.Box = False
         GoSub ToggleInsert
      End If

      I$ = INKEYz$
      If Len(I$) Then
         Select Case Len(I$)
            Case 1
               Select Case I$
                  Case Chr$(8) ' backspace
                     If BoxButton = 1 Then
                        If Len(X1$) Then
                           If LineX1 Then
                              LineX1 = 0
                              X1$ = ""
                              Box1Xposition1 = 1
                              Box1Xposition2 = 0
                              GoSub DisplayFileLine
                           End If
                           If Box1Xposition2 > 0 Then
                              If Insert1 Then ' destructive backspace
                                 X1$ = Left$(X1$, Box1Xposition2 - 1) + Mid$(X1$, Box1Xposition2 + 1)
                              End If
                              Box1Xposition2 = Box1Xposition2 - 1
                              If Box1Xposition2 - LC <= Box1Xposition1 Then
                                 Box1Xposition1 = Box1Xposition1 - 1
                                 If Box1Xposition1 < 1 Then
                                    Box1Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        If Len(X2$) Then
                           If LineX2 Then
                              LineX2 = 0
                              X2$ = ""
                              Box2Xposition1 = 1
                              Box2Xposition2 = 0
                              GoSub DisplayFileLine
                           End If
                           If Box2Xposition2 > 0 Then
                              If Insert2 Then ' destructive backspace
                                 X2$ = Left$(X2$, Box2Xposition2 - 1) + Mid$(X2$, Box2Xposition2 + 1)
                              End If
                              Box2Xposition2 = Box2Xposition2 - 1
                              If Box2Xposition2 - LC <= Box2Xposition1 Then
                                 Box2Xposition1 = Box2Xposition1 - 1
                                 If Box2Xposition1 < 1 Then
                                    Box2Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case Chr$(13)
                     If BoxButton = 1 Then
                        Out2 = LTrim$(RTrim$(X1$))
                        If Out2 = "" Then
                           If DisplaySelect2 = 0 Then
                              X2$ = "<nul>"
                              BoxButton = 2
                              GoSub DisplayFileLine
                           End If
                           If DisplaySelect2 Then
                              X2$ = Nul
                              BoxButton = 2
                              GoSub DisplayFileLine
                           End If
                        End If
                        If Len(Out2) Then
                           Call Remove.Spaces
                           Recurse = 0
                           Hidden = False
                           DataError = 0
                           WhatisError = -1
                           Parse.Type = 0
                           Call Enter.Equate
                           WhatisError = 0
                           If DataError Then
                              Select Case DataError
                                 Case -1
                                    If DisplaySelect2 = 0 Then
                                       X2$ = "<error>"
                                       BoxButton = 2
                                       GoSub DisplayFileLine
                                    End If
                                    If DisplaySelect2 Then
                                       X2$ = Nul
                                       BoxButton = 2
                                       GoSub DisplayFileLine
                                    End If
                                 Case -2
                                    If DisplaySelect2 = 0 Then
                                       X2$ = "<delimiter error>"
                                       BoxButton = 2
                                       GoSub DisplayFileLine
                                    End If
                                    If DisplaySelect2 Then
                                       X2$ = Nul
                                       BoxButton = 2
                                       GoSub DisplayFileLine
                                    End If
                                 Case Else
                                    If DisplaySelect2 = 0 Then
                                       X2$ = "<error>"
                                       BoxButton = 2
                                       GoSub DisplayFileLine
                                    End If
                                    If DisplaySelect2 Then
                                       X2$ = Nul
                                       BoxButton = 2
                                       GoSub DisplayFileLine
                                    End If
                              End Select
                           End If
                           If DataError = 0 Then
                              If Assign Then
                                 If DisplaySelect2 = 0 Then
                                    X2$ = "<assign>"
                                    BoxButton = 2
                                    GoSub DisplayFileLine
                                 End If
                                 If DisplaySelect2 Then
                                    X2$ = Nul
                                    BoxButton = 2
                                    GoSub DisplayFileLine
                                 End If
                              End If
                              If Assign = 0 Then
                                 T# = Last.Token.Value
                                 If Last.Token = False Then
                                    X2$ = Out3
                                    BoxButton = 2
                                    GoSub DisplayFileLine
                                 Else
                                    X2$ = Str$(T#)
                                    BoxButton = 2
                                    GoSub DisplayFileLine
                                 End If
                              End If
                           End If
                        End If
                     End If
                     If BoxButton >= 3 And BoxButton <= 5 Then
                        Exit Do
                     End If
                     ' exit
                     If BoxButton = 6 Then
                        X1$ = ""
                        BoxButton = 1
                        GoSub DisplayFileLine
                        X2$ = ""
                        BoxButton = 2
                        GoSub DisplayFileLine
                     End If
                  Case Chr$(27) ' exit
                     BoxButton = 6
                     Exit Do
                  Case Chr$(9) ' tab
                     BoxButton = BoxButton + 1
                     If BoxButton = 7 Then
                        BoxButton = 1
                     End If
                     Select Case BoxButton
                        Case 1, 2 ' entry area
                           GoSub DrawWhatisBoxButtons
                           GoSub DisplayFileLine
                        Case 3 ' checkbox
                           Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
                        Case 4 ' replace
                           GoSub DrawWhatisBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 1, 1, 8, 8
                        Case 5 ' replaceall
                           GoSub DrawWhatisBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 11, 1, 8, 8
                        Case 6 ' exit
                           GoSub DrawWhatisBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 25, 1, 8, 8
                     End Select
                  Case Chr$(1) ' ctrl-a
                     WhatisBoxBackGround = WhatisBoxBackGround + 1
                     If WhatisBoxBackGround = 8 Then
                        WhatisBoxBackGround = 0
                     End If
                     GoSub DrawWhatisBox
                  Case Chr$(2) ' ctrl-b
                     WhatisBoxButtonBackGround = WhatisBoxButtonBackGround + 1
                     If WhatisBoxButtonBackGround = 8 Then
                        WhatisBoxButtonBackGround = 0
                     End If
                     GoSub DrawWhatisBox
                  Case Chr$(4) ' ctrl-d
                     WhatisBoxBorderColor = WhatisBoxBorderColor + 1
                     If WhatisBoxBorderColor = 16 Then
                        WhatisBoxBorderColor = 0
                     End If
                     GoSub DrawWhatisBox
                  Case Chr$(5) ' ctrl-e
                     WhatisBoxTitleColor = WhatisBoxTitleColor + 1
                     If WhatisBoxTitleColor = 16 Then
                        WhatisBoxTitleColor = 0
                     End If
                     GoSub DrawWhatisBox
                  Case Chr$(6) ' ctrl-f
                     WhatisBoxTextColor = WhatisBoxTextColor + 1
                     If WhatisBoxTextColor = 16 Then
                        WhatisBoxTextColor = 0
                     End If
                     GoSub DrawWhatisBox
                  Case Chr$(7) ' ctrl-g
                     WhatisBoxButton1Color = WhatisBoxButton1Color + 1
                     If WhatisBoxButton1Color = 16 Then
                        WhatisBoxButton1Color = 0
                     End If
                     GoSub DrawWhatisBox
                  Case Chr$(11) ' ctrl-k
                     WhatisBoxButton2Color = WhatisBoxButton2Color + 1
                     If WhatisBoxButton2Color = 16 Then
                        WhatisBoxButton2Color = 0
                     End If
                     GoSub DrawWhatisBox
                  Case Else
                     If BoxButton >= 3 And BoxButton <= 6 Then
                        If UCase$(I$) = "D" Then
                           DisplaySelect2 = Not DisplaySelect2
                           GoSub DrawSearchCheckBoxs
                        End If
                        If UCase$(I$) = "S" Then
                           BoxButton = 4
                           Exit Do
                        End If
                        If UCase$(I$) = "C" Then
                           BoxButton = 5
                           Exit Do
                        End If
                        If UCase$(I$) = "E" Then
                           BoxButton = 6
                           Exit Do
                        End If
                     End If
                     If BoxButton = 3 Then ' checkbox
                        If I$ = " " Then
                           DisplaySelect2 = Not DisplaySelect2
                           GoSub DrawSearchCheckBoxs
                        End If
                     End If
                     If BoxButton = 1 Then
                        ' append/insert character into edit area.
                        VarI = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           VarI = 0 ' disallow control charcters
                        End If
                        If VarI Then
                           If LineX1 Then
                              LineX1 = 0
                              X1$ = ""
                              Box1Xposition1 = 1
                              Box1Xposition2 = 0
                           End If
                           If Insert1 Then
                              X1$ = Left$(X1$, Box1Xposition2) + I$ + Mid$(X1$, Box1Xposition2 + 1)
                              Box1Xposition2 = Box1Xposition2 + 1
                              If Box1Xposition2 > LC Then
                                 Box1Xposition1 = Box1Xposition1 + 1
                              End If
                           Else
                              If Box1Xposition2 + 1 > Len(X1$) Then
                                 X1$ = X1$ + I$ ' append
                                 Box1Xposition2 = Box1Xposition2 + 1
                                 If Box1Xposition2 > LC Then
                                    Box1Xposition1 = Box1Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X1$, Box1Xposition2 + 1, 1) = I$
                                 Box1Xposition2 = Box1Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        ' append/insert character into edit area.
                        VarI = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           VarI = 0 ' disallow control charcters
                        End If
                        If VarI Then
                           If LineX2 Then
                              LineX2 = 0
                              X2$ = ""
                              Box2Xposition1 = 1
                              Box2Xposition2 = 0
                           End If
                           If Insert2 Then
                              X2$ = Left$(X2$, Box2Xposition2) + I$ + Mid$(X2$, Box2Xposition2 + 1)
                              Box2Xposition2 = Box2Xposition2 + 1
                              If Box2Xposition2 > LC Then
                                 Box2Xposition1 = Box2Xposition1 + 1
                              End If
                           Else
                              If Box2Xposition2 + 1 > Len(X2$) Then
                                 X2$ = X2$ + I$ ' append
                                 Box2Xposition2 = Box2Xposition2 + 1
                                 If Box2Xposition2 > LC Then
                                    Box2Xposition1 = Box2Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X2$, Box2Xposition2 + 1, 1) = I$
                                 Box2Xposition2 = Box2Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(I$, 1))
                  Case 82 ' Insert
                     If BoxButton = 1 Then
                        Insert1 = Not Insert1
                        If Insert1 Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                     If BoxButton = 2 Then
                        Insert2 = Not Insert2
                        If Insert2 Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                  Case 83 ' Delete
                     If BoxButton = 1 Then
                        LineX1 = 0
                        GoSub DisplayFileLine
                        If Len(X1$) > 0 Then
                           X1$ = Left$(X1$, Box1Xposition2) + Mid$(X1$, Box1Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        GoSub DisplayFileLine
                        If Len(X2$) > 0 Then
                           X2$ = Left$(X2$, Box2Xposition2) + Mid$(X2$, Box2Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 71 ' Home
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Box1Xposition2 > 0 Then
                           Box1Xposition1 = 1
                           Box1Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Box2Xposition2 > 0 Then
                           Box2Xposition1 = 1
                           Box2Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 79 ' End
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Box1Xposition2 < Len(X1$) Then
                           Box1Xposition2 = Len(X1$)
                           Box1Xposition1 = Box1Xposition2 - LC + 1
                           If Box1Xposition1 < 1 Then
                              Box1Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Box2Xposition2 < Len(X2$) Then
                           Box2Xposition2 = Len(X2$)
                           Box2Xposition1 = Box2Xposition2 - LC + 1
                           If Box2Xposition1 < 1 Then
                              Box2Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 75 ' Left
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Len(X1$) Then
                           If Box1Xposition2 > 0 Then
                              Box1Xposition2 = Box1Xposition2 - 1
                              If Box1Xposition2 - LC <= Box1Xposition1 Then
                                 Box1Xposition1 = Box1Xposition1 - 1
                                 If Box1Xposition1 < 1 Then
                                    Box1Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Len(X2$) Then
                           If Box2Xposition2 > 0 Then
                              Box2Xposition2 = Box2Xposition2 - 1
                              If Box2Xposition2 - LC <= Box2Xposition1 Then
                                 Box2Xposition1 = Box2Xposition1 - 1
                                 If Box2Xposition1 < 1 Then
                                    Box2Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                  Case 77 ' Right
                     If BoxButton = 1 Then
                        LineX1 = 0
                        If Len(X1$) Then
                           If Box1Xposition2 < Len(X1$) Then
                              Box1Xposition2 = Box1Xposition2 + 1
                              If Box1Xposition2 > Box1Xposition1 + LC - 1 Then
                                 Box1Xposition1 = Box1Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                     If BoxButton = 2 Then
                        LineX2 = 0
                        If Len(X2$) Then
                           If Box2Xposition2 < Len(X2$) Then
                              Box2Xposition2 = Box2Xposition2 + 1
                              If Box2Xposition2 > Box2Xposition1 + LC - 1 Then
                                 Box2Xposition1 = Box2Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case 72 ' up
                     If BoxButton = 3 Then ' checkbox
                        DisplaySelect2 = -1
                        GoSub DrawSearchCheckBoxs
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = Xcoor3 - 1
                           GoSub RestoreScreenX
                           GoSub DrawWhatisBox
                        End If
                     End If
                  Case 80 ' down
                     If BoxButton = 3 Then ' checkbox
                        DisplaySelect2 = 0
                        GoSub DrawSearchCheckBoxs
                     Else
                        If Status Then
                           Z = 23
                        Else
                           Z = 24
                        End If
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Xcoor3 + 1
                           GoSub RestoreScreenX
                           GoSub DrawWhatisBox
                        End If
                     End If
                  Case 15 ' shift-tab
                     BoxButton = BoxButton - 1
                     If BoxButton = 0 Then
                        BoxButton = 6
                     End If
                     Select Case BoxButton
                        Case 1, 2 ' entry area
                           GoSub DrawWhatisBoxButtons
                           GoSub DisplayFileLine
                        Case 3 ' checkbox
                           Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
                        Case 4 ' replace
                           GoSub DrawWhatisBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 1, 1, 8, 8
                        Case 5 ' replace all
                           GoSub DrawWhatisBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 11, 1, 8, 8
                        Case 6 ' exit
                           GoSub DrawWhatisBoxButtons
                           Locate Xcoor3 + 6, Ycoor3 + 25, 1, 8, 8
                     End Select
                  Case 76, 143 ' keypad-5 center
                     Xcoor3 = 10
                     Ycoor3 = 10
                     GoSub RestoreScreenX
                     GoSub DrawWhatisBox
                     _KeyClear
                  Case 141 ' ctrl-up
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     End If
                     _KeyClear
                  Case 145 ' ctrl-down
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           GoSub RestoreScreenX
                           GoSub DrawWhatisBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           GoSub RestoreScreenX
                           GoSub DrawWhatisBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           GoSub RestoreScreenX
                           GoSub DrawWhatisBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           GoSub RestoreScreenX
                           GoSub DrawWhatisBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      If Status Then
         Z = 23
      Else
         Z = 24
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        GoSub RestoreScreenX
                        GoSub DrawWhatisBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else ' click on button
            If MouseX = XC1 Then
               ' entry area 1
               If MouseY >= YC1 And MouseY <= YC1 + LC Then
                  BoxButton = 1
                  GoSub DrawWhatisBox
               End If
            End If
            If MouseX = XC2 Then
               ' entry area 2
               If MouseY >= YC2 And MouseY <= YC2 + LC Then
                  BoxButton = 2
                  GoSub DrawWhatisBox
               End If
            End If
            If MouseX = Xcoor3 + 5 Then
               ' click checkbox
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 3 Then
                  DisplaySelect2 = Not DisplaySelect2
                  GoSub DrawSearchCheckBoxs
               End If
            End If
            If MouseX = Xcoor3 + 6 Then
               ' click <system>
               If MouseY >= Ycoor3 + 1 And MouseY <= Ycoor3 + 8 Then
                  BoxButton = 4
                  Exit Do
               End If
               ' click <continue>
               If MouseY >= Ycoor3 + 11 And MouseY <= Ycoor3 + 20 Then
                  BoxButton = 5
                  Exit Do
               End If
               ' click <exit>
               If MouseY >= Ycoor3 + 25 And MouseY <= Ycoor3 + 30 Then
                  BoxButton = 6
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseButton2 Then
            VarX = MessageBox(" Whatis ", "Whatisbox " + Date$ + " " + Time$)
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               GoSub RestoreScreenX
               GoSub DrawWhatisBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            If Status Then
               Z = 23
            Else
               Z = 24
            End If
            If Xcoor3 + 7 < Z Then
               Xcoor3 = Xcoor3 + 1
               GoSub RestoreScreenX
               GoSub DrawWhatisBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   GoSub RestoreScreenX
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   WhatisBox = -1
   Locate , , 1, 8, 8
   _KeyClear
   If BoxButton = 4 Then
      If BreakBox = 0 Then
         System
      End If
   End If
   Exit Function

   ' draw box
   DrawWhatisBox:
   Color WhatisBoxBorderColor, WhatisBoxBackGround
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   WhatisBoxTitle$ = " Whatis Box "
   TempX = 16 - Len(WhatisBoxTitle$) / 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color WhatisBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print WhatisBoxTitle$;

   ' display search text
   Color WhatisBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 1, 0
   Print "Whatis:"
   Locate Xcoor3 + 3, Ycoor3 + 1, 0
   Print "Result:"

   Locate Xcoor3 + 5, Ycoor3 + 1, 0
   Color WhatisBoxButton1Color, WhatisBoxBackGround
   Print "[ ] Don't display errors";
   Locate Xcoor3 + 5, Ycoor3 + 5, 0
   Color Magenta
   Print "D";

   GoSub DrawSearchCheckBoxs
   GoSub DrawWhatisBoxButtons
   Locate , , , 8, 8
   XC1 = Xcoor3 + 2
   YC1 = Ycoor3 + 1
   XC2 = Xcoor3 + 4
   YC2 = Ycoor3 + 1

   Color White, Black
   Locate XC1, YC1, 1
   Print Space$(LC);
   Locate XC2, YC2, 1
   Print Space$(LC);
   If Len(X1$) Then
      Locate XC1, YC1, 1
      Color White
      Print Mid$(X1$, Box1Xposition1, LC);
   End If
   If Len(X2$) Then
      Locate XC2, YC2, 1
      Color White
      Print Mid$(X2$, Box2Xposition1, LC);
   End If

   Select Case BoxButton
      Case 1, 2 ' entry area
         GoSub DisplayFileLine
      Case 3 ' checkbox
         Locate Xcoor3 + 5, Ycoor3 + 2, 1
      Case 4 ' replace
         GoSub DrawWhatisBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 1, 1
      Case 5 ' replaceall
         GoSub DrawWhatisBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 11, 1
      Case 6 ' cancel
         GoSub DrawWhatisBoxButtons
         Locate Xcoor3 + 6, Ycoor3 + 25, 1
   End Select
   Return

   ' display checkboxs
   DrawSearchCheckBoxs:

   '-[ ] Don't display errors
   If DisplaySelect2 Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color WhatisBoxButton1Color, WhatisBoxButtonBackGround
      Print "X";
   Else
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color WhatisBoxButton1Color, WhatisBoxButtonBackGround
      Print " ";
   End If
   If BoxButton = 3 Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 1, 8, 8
   End If
   Return

   ' display buttuns
   DrawWhatisBoxButtons:
   '-<System>  <Continue>    <Exit>
   Select Case BoxButton
      Case 4 ' replace
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color WhatisBoxButton1Color, WhatisBoxButtonBackGround
         Print "<System>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<Continue>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case 5 ' replaceall
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<System>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color WhatisBoxButton1Color, WhatisBoxButtonBackGround
         Print "<Continue>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case 6 ' cancel
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<System>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<Continue>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color WhatisBoxButton1Color, WhatisBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
      Case Else
         Locate Xcoor3 + 6, Ycoor3 + 1, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<System>";
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color Magenta
         Print "S";

         Locate Xcoor3 + 6, Ycoor3 + 11, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<Continue>";
         Locate Xcoor3 + 6, Ycoor3 + 12, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 25, 0
         Color WhatisBoxButton2Color, WhatisBoxButtonBackGround
         Print "<Exit>";
         Locate Xcoor3 + 6, Ycoor3 + 26, 0
         Color Magenta
         Print "E";
   End Select
   Color White, Black
   Return

   ' display current entry area.
   DisplayFileLine:
   If BoxButton = 1 Then
      Locate XC1, YC1, 1
      Print Space$(LC);
   End If
   If BoxButton = 2 Then
      Locate XC2, YC2, 1
      Print Space$(LC);
   End If

   ' display edit line and position cursor.
   If BoxButton = 1 Then
      Locate XC1, YC1, 1
      If Len(X1$) Then
         If LineX1 Then
            Color Black, Plain
         Else
            Color White
         End If
         Print Mid$(X1$, Box1Xposition1, LC);
      End If
      Locate XC1, YC1 + Box1Xposition2 - Box1Xposition1 + 1, 1
      If Insert1 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
      Color White, Black
   End If

   If BoxButton = 2 Then
      Locate XC2, YC2, 1
      If Len(X2$) Then
         If LineX2 Then
            Color Black, Plain
         Else
            Color White
         End If
         Print Mid$(X2$, Box2Xposition1, LC);
      End If
      Locate XC2, YC2 + Box2Xposition2 - Box2Xposition1 + 1, 1
      If Insert2 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
      Color White, Black
   End If
   Return

   ' reset cursor
   ToggleInsert:
   If BoxButton = 1 Then
      If Insert1 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
   End If
   If BoxButton = 2 Then
      If Insert2 Then
         Locate , , 1, 8, 8 ' line cursor
      Else
         Locate , , 1, 0, 8 ' block cursor
      End If
   End If
   Return

   ' screen save
   SaveScreenX:
   If Status Then
      V = 23
   Else
      V = 24
   End If
   For Var1 = 2 To V
      For Var2 = 1 To 80
         TempZ1 = Screen(Var1, Var2) ' screen char
         TempZ2 = Screen(Var1, Var2, 1) ' char color
         TempArrayY3((Var1 - 1) * 80 + Var2) = TempZ1
         TempArrayZ3((Var1 - 1) * 80 + Var2) = TempZ2
      Next
   Next
   Return

   ' screen restore
   RestoreScreenX:
   If Status Then
      V = 23
   Else
      V = 24
   End If
   For Var1 = 2 To V
      For Var2 = 1 To 80
         VarB = Int(TempArrayZ3((Var1 - 1) * 80 + Var2) / 16)
         VarF = TempArrayZ3((Var1 - 1) * 80 + Var2) Mod 16
         TempZ1 = TempArrayY3((Var1 - 1) * 80 + Var2)
         Locate Var1, Var2, 1
         Color VarF, VarB
         Print Chr$(TempZ1);
      Next
   Next
   Return
End Function

Rem BreakBox with OK/Quit
Function BreakBox
   Dim TempArrayY3(1 To 2000) As Integer
   Dim TempArrayZ3(1 To 2000) As Integer

   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   GoSub SaveScreenX

   ' declare break box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10

   ' set break box colors
   BreakBoxBorderColor = Yellow
   BreakBoxTitleColor = White
   BreakBoxTextColor = White
   BreakBoxButton1Color = White
   BreakBoxButton2Color = Plain
   BreakBackGround1 = 1
   BreakBackGround2 = 0

   ' draw box
   BoxButton = 1
   GoSub DrawBreakBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      VarQ = _Exit
      If VarQ Then ' Control-Break
         System
      End If

      X$ = INKEYz$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "O"
                     BoxButton = 1
                     Exit Do
                  Case "Q"
                     BoxButton = 2
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 1
                     Exit Do
                  Case Chr$(9) ' tab
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawBreakBoxButtons
                  Case Chr$(1) ' ctrl-a
                     BreakBackGround1 = BreakBackGround1 + 1
                     If BreakBackGround1 = 8 Then
                        BreakBackGround1 = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(2) ' ctrl-b
                     BreakBackGround2 = BreakBackGround2 + 1
                     If BreakBackGround2 = 8 Then
                        BreakBackGround2 = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(4) ' ctrl-d
                     BreakBoxBorderColor = BreakBoxBorderColor + 1
                     If BreakBoxBorderColor = 16 Then
                        BreakBoxBorderColor = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(5) ' ctrl-e
                     BreakBoxTitleColor = BreakBoxTitleColor + 1
                     If BreakBoxTitleColor = 16 Then
                        BreakBoxTitleColor = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(6) ' ctrl-f
                     BreakBoxTextColor = BreakBoxTextColor + 1
                     If BreakBoxTextColor = 16 Then
                        BreakBoxTextColor = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(7) ' ctrl-g
                     BreakBoxButton1Color = BreakBoxButton1Color + 1
                     If BreakBoxButton1Color = 16 Then
                        BreakBoxButton1Color = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(8) ' ctrl-h
                     BreakBoxButton2Color = BreakBoxButton2Color + 1
                     If BreakBoxButton2Color = 16 Then
                        BreakBoxButton2Color = 0
                     End If
                     GoSub DrawBreakBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 75, 15 ' left/shift-tab
                     If BoxButton = 2 Then
                        BoxButton = 1
                     Else
                        BoxButton = 2
                     End If
                     GoSub DrawBreakBoxButtons
                  Case 77 ' right
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawBreakBoxButtons
                  Case 76, 143 ' keypad-5 center
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     GoSub RestoreScreenX
                     GoSub DrawBreakBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           GoSub RestoreScreenX
                           GoSub DrawBreakBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     X$ = ""
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           GoSub RestoreScreenX
                           GoSub DrawBreakBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           GoSub RestoreScreenX
                           GoSub DrawBreakBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           GoSub RestoreScreenX
                           GoSub DrawBreakBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      If Status Then
         Z = 23
      Else
         Z = 24
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 5 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 13 Then
                  BoxButton = 2
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 5 Then
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
               If BoxButton = 2 Then
                  BoxButton = 1
                  GoSub DrawBreakBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
               If BoxButton = 1 Then
                  BoxButton = 2
                  GoSub DrawBreakBoxButtons
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               GoSub RestoreScreenX
               GoSub DrawBreakBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            If Status Then
               Z = 23
            Else
               Z = 24
            End If
            X$ = ""
            If Xcoor3 + 7 < Z Then
               Xcoor3 = Xcoor3 + 1
               GoSub RestoreScreenX
               GoSub DrawBreakBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   GoSub RestoreScreenX
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then
      BreakBox = -1
   Else
      BreakBox = 0
   End If
   Exit Function

   ' draw box
   DrawBreakBox:
   Color BreakBoxBorderColor, BreakBackGround1
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   Var0$ = " Break "
   TempX = 16 - Len(Var0$) \ 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color BreakBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print Var0$;

   ' display error text
   Color BreakBoxTextColor

   Var1$ = "Control-Break trap."
   Locate Xcoor3 + 1, Ycoor3 + 2, 0
   Print Var1$

   Var2$ = "Press <OK> to continue."
   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   Print Var2$

   Var3$ = "Press <Quit> to end program."
   Locate Xcoor3 + 3, Ycoor3 + 2, 0
   Print Var3$

   GoSub DrawBreakBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawBreakBoxButtons:
   If BoxButton = 1 Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color BreakBoxButton1Color, BreakBackGround2
      Print "<OK>";
      Locate Xcoor3 + 5, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 5, Ycoor3 + 8, 0
      Color BreakBoxButton2Color, BreakBackGround2
      Print "<Quit>";
      Locate Xcoor3 + 5, Ycoor3 + 9, 0
      Color Magenta
      Print "Q";
   Else
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color BreakBoxButton2Color, BreakBackGround2
      Print "<OK>";
      Locate Xcoor3 + 5, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 5, Ycoor3 + 8, 0
      Color BreakBoxButton1Color, BreakBackGround2
      Print "<Quit>";
      Locate Xcoor3 + 5, Ycoor3 + 9, 0
      Color Magenta
      Print "Q";
   End If
   Color Plain, Black
   Return

   ' screen save
   SaveScreenX:
   If Status Then
      V = 23
   Else
      V = 24
   End If
   For Var1 = 2 To V
      For Var2 = 1 To 80
         TempZ1 = Screen(Var1, Var2) ' screen char
         TempZ2 = Screen(Var1, Var2, 1) ' char color
         TempArrayY3((Var1 - 1) * 80 + Var2) = TempZ1
         TempArrayZ3((Var1 - 1) * 80 + Var2) = TempZ2
      Next
   Next
   Return

   ' screen restore
   RestoreScreenX:
   If Status Then
      V = 23
   Else
      V = 24
   End If
   For Var1 = 2 To V
      For Var2 = 1 To 80
         VarB = Int(TempArrayZ3((Var1 - 1) * 80 + Var2) / 16)
         VarF = TempArrayZ3((Var1 - 1) * 80 + Var2) Mod 16
         TempZ1 = TempArrayY3((Var1 - 1) * 80 + Var2)
         Locate Var1, Var2, 1
         Color VarF, VarB
         Print Chr$(TempZ1);
      Next
   Next
   Return
End Function

' formats a double numeric string
Function FormatString$ (s#)
   x$ = ""
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If
   x$ = e$ + x$ + q$ ' construct string
   FormatString$ = x$
End Function

Sub ParseTest (ErrFlag)
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   Command.Line.Redirect$ = Command.Line
   StdinCount = 1
   ErrFlag = 0
   Do
      ' get standard input
      Standard.Input$ = ""
      If Stdin Then
         If StdinLines > 0 Then ' nul:
            Do Until StdinCount > StdinLines
               Standard.Input$ = StdinArray(StdinCount)
               Standard.Input$ = RTrim$(LTrim$(Standard.Input$))
               If Standard.Input$ <> "" Then
                  Exit Do
               End If
               StdinCount = StdinCount + 1
            Loop
            If StdinCount > StdinLines Then
               Exit Do
            End If
         End If
      End If

      ' store entire command
      Command.Line = Command.Line.Redirect$

      ' filename processing loop
      Do
         ' store redirected input
         Standard.Input$ = RTrim$(Standard.Input$)
         Standard.Input$ = LTrim$(Standard.Input$)
         If Left$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Mid$(Standard.Input$, 2)
         End If
         If Right$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Left$(Standard.Input$, Len(Standard.Input$) - 1)
         End If

         ' store entire command
         If Left$(Command.Line, 1) = Quote Then
            Imbedded = InStr(2, Command.Line, Quote)
            If Imbedded Then
               Command.Work = Standard.Input$ + Mid$(Command.Line, 2, Imbedded - 2)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         Else
            Imbedded = InStr(Command.Line, " ")
            If Imbedded Then
               Command.Work = Standard.Input$ + Left$(Command.Line, Imbedded - 1)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         End If
         Command.Line = LTrim$(Command.Line)
         Command.Line = RTrim$(Command.Line)

         ' display parsed command line
         X$ = Command.Work
         If LCase$(StdoutFile$) = "scrn:" Then
            Print X$
         Else
            Call AddStdout3(X$)
         End If

         ' check search filename
         If Command.Line = "" Then
            Exit Do
         End If

         ' check quit searching
         If Quit.Searching Then
            Exit Do
         End If
      Loop

      ' check stdin
      StdinCount = StdinCount + 1
      If StdinCount > StdinLines Then
         Exit Do
      End If
   Loop
End Sub

Sub TeeFunction (ErrFlag)
   Command.Line = COMMAND2$
   Strip.Tee.Drives = ParseLine("/D")
   Strip.Tee.Blanks = ParseLine("/T")
   X = ParseLineX("/") ' remove all switches
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   Command.Line.Redirect$ = Command.Line
   StdinCount = 1
   ErrFlag = 0
   Do
      ' get standard input
      Standard.Input$ = ""
      If Stdin Then
         If StdinLines > 0 Then ' nul:
            Do Until StdinCount > StdinLines
               Standard.Input$ = StdinArray(StdinCount)
               Standard.Input$ = RTrim$(LTrim$(Standard.Input$))
               If Standard.Input$ <> "" Then
                  Exit Do
               End If
               StdinCount = StdinCount + 1
            Loop
            If StdinCount > StdinLines Then
               Exit Do
            End If
         End If
      End If

      ' store entire command
      Command.Line = Command.Line.Redirect$

      ' filename processing loop
      Do
         ' store redirected input
         Standard.Input$ = RTrim$(Standard.Input$)
         Standard.Input$ = LTrim$(Standard.Input$)
         If Left$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Mid$(Standard.Input$, 2)
         End If
         If Right$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Left$(Standard.Input$, Len(Standard.Input$) - 1)
         End If

         ' store entire command
         If Left$(Command.Line, 1) = Quote Then
            Imbedded = InStr(2, Command.Line, Quote)
            If Imbedded Then
               Command.Work = Standard.Input$ + Mid$(Command.Line, 2, Imbedded - 2)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         Else
            Imbedded = InStr(Command.Line, " ")
            If Imbedded Then
               Command.Work = Standard.Input$ + Left$(Command.Line, Imbedded - 1)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         End If
         Command.Line = LTrim$(Command.Line)
         Command.Line = RTrim$(Command.Line)

         ' display parsed command line
         X$ = Command.Work
         SetOutpt = -1
         If Strip.Tee.Blanks Then
            If RTrim$(X$) = "" Then
               SetOutpt = 0
            End If
         End If
         If Strip.Tee.Drives Then
            If StripDrive(RTrim$(X$)) Then
               SetOutpt = 0
            End If
         End If
         If SetOutpt Then
            If LCase$(StdoutFile$) = "scrn:" Then
               Print X$
            Else
               Call AddStdout3(X$)
            End If
         End If

         ' check search filename
         If Command.Line = "" Then
            Exit Do
         End If

         ' check quit searching
         If Quit.Searching Then
            Exit Do
         End If
      Loop

      ' check stdin
      StdinCount = StdinCount + 1
      If StdinCount > StdinLines Then
         Exit Do
      End If
   Loop
End Sub

' uses direct keyboard input to get an input line
'   and edit multi-dimensional command history arrays with line-wrapping,
'     where Temp0 (history array type) equals:
'       1=command prompt
'       2=whatis prompt

' VarP = 1 - netpath history, 2 - command history, 3 - no history.

Function KeyboardLine$ (VarP)
   ' position of prompt
   Insert = -1
   L = CsrLin
   P = Pos(0)
   Locate L, P, 1

   ' position in entry string
   X = 1
   Var$ = ""
   MaxLength = 128
   Print "";
   Locate , , 1, 8, 8
   CurrentMenu = 0
   Control.Break = False
   Monitor.Box = False
   Start.Timer = Timer
   Do
      ' check alt key press
      Q& = _KeyHit
      If Q& = KEY_LALT& Then
         CurrentMenu = 1
         Call Menu2
         GoSub DisplayLine2
         Var$ = ""
         Exit Do
      End If
      If Q& = KEY_RALT& Then
         CurrentMenu = 1
         Call Menu2
         GoSub DisplayLine2
         Var$ = ""
         Exit Do
      End If

      ' check mouse activity
      Z = MouseDriver
      If MouseButton1 Then
         ' select drop down menu.
         If MouseX = 1 Then
            NewMenuSelection = 0
            Select Case MouseY
               Case 1 To 3 ' cpu
                  CPUOFF = Not CPUOFF
                  If CPUOFF Then
                     Timer Off
                     _Title Program
                     Call DisplayToolBar
                  Else
                     Timer On
                     Call DisplayToolBar
                  End If
               Case 74 To 78 ' about
                  Call HelpAbout
               Case 6 To 9 ' File
                  NewMenuSelection = 1
               Case 16 To 21 ' Charts
                  NewMenuSelection = 2
               Case 26 To 29 ' Dump
                  NewMenuSelection = 3
               Case 36 To 39 ' Edit
                  NewMenuSelection = 4
               Case 46 To 49 ' Jump
                  NewMenuSelection = 5
               Case 56 To 60 ' Print
                  NewMenuSelection = 6
               Case 64 To 69 ' Search
                  NewMenuSelection = 7
            End Select
            If NewMenuSelection Then
               CurrentMenu = NewMenuSelection
               NewMenuSelection = 0
               CurrentMenuSelection = 1
               Call DropDownMenu(Var)
               GoSub DisplayLine2
               Var$ = ""
               Exit Do
            End If
         End If
      End If

      ' check keyboard timer
      If VarP = 1 Then
         Time.Elapsed = Timer - Start.Timer
         If Time.Elapsed < 0 Then
            Time.Elapsed = Time.Elapsed + 86400
         End If
         If Time.Elapsed >= 1 Then
            Start.Timer = Timer
            Color White
            Locate L, 1, 1
            Call DisplayPrompt
            Color Plain, Black
            GoSub DisplayLine2
            Locate , , 1
         End If
      End If

      ' get key input
      Locate , , 1
      Var2$ = INKEYx$
      If Len(Var2$) Then
         Select Case Len(Var2$)
            Case 1
               Select Case Var2$
                  Case Chr$(3) ' Control-C
                     If Len(Var$) Then
                        GoSub DisplayLine2
                        Var$ = ""
                        Exit Do
                     End If
                  Case Chr$(9) ' tab
                     If VarP = 1 Then
                        If NetPathHistory = 0 Then
                           If NetPathCount >= 1 Then
                              NetPathHistory = 1
                              GoSub EraseLine
                              Var$ = RTrim$(NetPathTable(1))
                              GoSub DisplayLine
                           End If
                        Else
                           If NetPathHistory < NetPathCount Then
                              NetPathHistory = NetPathHistory + 1
                              GoSub EraseLine
                              Var$ = RTrim$(NetPathTable(NetPathHistory))
                              GoSub DisplayLine
                           Else
                              If NetPathHistory = NetPathCount Then
                                 NetPathHistory = NetPathCount + 1
                                 GoSub EraseLine
                                 Var$ = ""
                                 GoSub DisplayLine
                              End If
                           End If
                        End If
                     Else
                        If X + TabStop <= Len(Var$) Then
                           X = X + TabStop
                        Else
                           X = Len(Var$) + 1
                        End If
                        GoSub DisplayLine2
                     End If
                  Case Chr$(13) ' return
                     If VarP <= 2 Then
                        GoSub EnterHistory
                     End If
                     Exit Do
                  Case Chr$(8) ' backspace
                     If X > 1 Then
                        If Insert Then
                           Var$ = Left$(Var$, X - 2) + Mid$(Var$, X)
                           X = X - 1
                           GoSub DisplayLine
                        Else
                           X = X - 1
                           GoSub DisplayLine2
                        End If
                     End If
                  Case Chr$(27) ' escape
                     NetPathHistory = 0
                     GoSub EraseLine
                  Case Else ' store input
                     If Insert Then
                        ' always insert char
                        Var$ = Left$(Var$, X - 1) + Var2$ + Mid$(Var$, X)
                        ' truncate end of line
                        Var$ = Left$(Var$, MaxLength)
                        If X <= MaxLength Then
                           X = X + 1
                        End If
                        GoSub DisplayLine
                     Else
                        If X <= MaxLength Then
                           Var$ = Left$(Var$, X - 1) + Var2$ + Mid$(Var$, X + 1)
                           X = X + 1
                           GoSub DisplayLine2
                        End If
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(Var2$, 1))
                  Case 141 ' Ctrl-Up = insert ascii sequence
                     Key1 = 0
                     Key1$ = ""
                     Do
                        V$ = INKEYz$
                        If Len(V$) Then
                           If V$ >= "0" And V$ <= "9" Then
                              Key1 = Key1 + 1
                              Key1$ = Key1$ + V$
                              If Key1 = 3 Then
                                 Exit Do
                              End If
                           End If
                        End If
                     Loop
                     Var1 = Val(Key1$)
                     If Var1 >= 0 And Var1 <= 255 Then
                        Var2$ = Chr$(Var1)
                        If Insert Then
                           ' always insert char
                           Var$ = Left$(Var$, X - 1) + Var2$ + Mid$(Var$, X)
                           ' truncate end of line
                           Var$ = Left$(Var$, MaxLength)
                           If X <= MaxLength Then
                              X = X + 1
                           End If
                           GoSub DisplayLine
                        Else
                           If X <= MaxLength Then
                              Var$ = Left$(Var$, X - 1) + Var2$ + Mid$(Var$, X + 1)
                              X = X + 1
                              GoSub DisplayLine2
                           End If
                        End If
                     End If
                  Case 71 ' Home
                     X = 1
                     GoSub DisplayLine2
                  Case 79 ' End
                     X = Len(Var$) + 1
                     GoSub DisplayLine2
                  Case 115 ' Ctrl-Left
                     Do
                        If X = 1 Then
                           Exit Do
                        End If
                        X = X - 1
                        If Mid$(Var$, X - 1, 1) = " " Then
                           If Mid$(Var$, X, 1) <> " " Then
                              Exit Do
                           End If
                        End If
                     Loop
                     GoSub DisplayLine2
                  Case 116 ' Ctrl-Right
                     Do
                        If X > Len(Var$) Then
                           Exit Do
                        End If
                        If Mid$(Var$, X, 1) = " " Then
                           If Mid$(Var$, X + 1, 1) <> " " Then
                              X = X + 1
                              Exit Do
                           End If
                        End If
                        X = X + 1
                     Loop
                     GoSub DisplayLine2
                  Case 15 ' Shift-Tab
                     If VarP = 1 Then
                        If NetPathHistory = 0 Then
                           If NetPathCount >= 1 Then
                              NetPathHistory = NetPathCount
                              GoSub EraseLine
                              Var$ = RTrim$(NetPathTable(NetPathHistory))
                              GoSub DisplayLine
                           End If
                        Else
                           If NetPathHistory > 1 Then
                              NetPathHistory = NetPathHistory - 1
                              GoSub EraseLine
                              Var$ = RTrim$(NetPathTable(NetPathHistory))
                              GoSub DisplayLine
                           End If
                        End If
                     Else
                        If X - TabStop >= 1 Then
                           X = X - TabStop
                        Else
                           X = 1
                        End If
                        GoSub DisplayLine2
                     End If
                  Case 75 ' left
                     If X > 1 Then
                        X = X - 1
                        GoSub DisplayLine2
                     End If
                  Case 77 ' right
                     If X <= Len(Var$) Then
                        X = X + 1
                        GoSub DisplayLine2
                     End If
                  Case 82 ' Insert
                     Insert = Not Insert
                     If Insert Then
                        Locate , , 1, 8, 8 ' line cursor
                     Else
                        Locate , , 1, 0, 8 ' blobk cursor
                     End If
                  Case 83 ' Delete
                     If X > 0 Then
                        Var$ = Left$(Var$, X - 1) + Mid$(Var$, X + 1)
                        GoSub DisplayLine
                     End If
                  Case 72 ' up - back history
                     If VarP <= 2 Then
                        GoSub GetCount
                        If Var1 > 0 Then
                           If EndOfHistoryFlag(Temp0) Then
                              EndOfHistoryFlag(Temp0) = 0
                              GoSub EraseLine
                              HistoryCount2(Temp0) = Var1
                              Var$ = RTrim$(History2(Temp0, Var1))
                              X = Len(Var$) + 1
                              GoSub DisplayLine
                              Var1 = 0
                           End If
                        End If
                        If Var1 > 0 Then
                           Select Case HistoryCount2(Temp0)
                              Case 0
                                 GoSub EraseLine
                                 HistoryCount2(Temp0) = Var1
                                 Var$ = RTrim$(History2(Temp0, Var1))
                                 X = Len(Var$) + 1
                                 GoSub DisplayLine
                              Case 1
                                 GoSub EraseLine
                                 Var$ = RTrim$(History2(Temp0, 1))
                                 X = Len(Var$) + 1
                                 GoSub DisplayLine
                              Case Else
                                 If HistoryCount2(Temp0) - 1 > 0 Then
                                    GoSub EraseLine
                                    HistoryCount2(Temp0) = HistoryCount2(Temp0) - 1
                                    Var$ = RTrim$(History2(Temp0, HistoryCount2(Temp0)))
                                    X = Len(Var$) + 1
                                    GoSub DisplayLine
                                 End If
                           End Select
                        End If
                     End If
                  Case 80 ' down - forward history
                     If VarP <= 2 Then
                        GoSub GetCount
                        ' return blank line at end of history
                        If Var1 > 0 Then
                           If Var1 = HistoryCount2(Temp0) Then
                              EndOfHistoryFlag(Temp0) = -1
                              GoSub EraseLine
                              Var$ = ""
                              X = 1
                              GoSub DisplayLine
                              Var1 = 0
                           End If
                        End If
                        ' otherwise move to history
                        If Var1 > 0 Then
                           Select Case HistoryCount2(Temp0)
                              Case 0
                                 GoSub EraseLine
                                 HistoryCount2(Temp0) = Var1
                                 Var$ = RTrim$(History2(Temp0, Var1))
                                 X = Len(Var$) + 1
                                 GoSub DisplayLine
                              Case 1 To MaxHistory - 1
                                 If HistoryCount2(Temp0) + 1 <= Var1 Then
                                    GoSub EraseLine
                                    HistoryCount2(Temp0) = HistoryCount2(Temp0) + 1
                                    Var$ = RTrim$(History2(Temp0, HistoryCount2(Temp0)))
                                    X = Len(Var$) + 1
                                    GoSub DisplayLine
                                 Else
                                    If HistoryCount2(Temp0) = Var1 Then
                                       GoSub EraseLine
                                       Var$ = RTrim$(History2(Temp0, Var1))
                                       X = Len(Var$) + 1
                                       GoSub DisplayLine
                                    End If
                                 End If
                              Case MaxHistory
                                 GoSub EraseLine
                                 Var$ = RTrim$(History2(Temp0, MaxHistory))
                                 X = Len(Var$) + 1
                                 GoSub DisplayLine
                           End Select
                        End If
                     End If
                  Case 119 ' ctrl-home
                     If VarP <= 2 Then
                        GoSub GetCount
                        If Var1 > 0 Then
                           GoSub EraseLine
                           HistoryCount2(Temp0) = 1
                           Var$ = RTrim$(History2(Temp0, 1))
                           X = Len(Var$) + 1
                           GoSub DisplayLine
                        End If
                     End If
                  Case 117 ' ctrl-end
                     If VarP <= 2 Then
                        GoSub GetCount
                        If Var1 > 0 Then
                           GoSub EraseLine
                           HistoryCount2(Temp0) = Var1
                           Var$ = RTrim$(History2(Temp0, Var1))
                           X = Len(Var$) + 1
                           GoSub DisplayLine
                        End If
                     End If
               End Select
         End Select
      End If
   Loop

   ' return input line
   Locate , , 1, 8, 8
   KeyboardLine$ = Var$
   Exit Function

   ' store edit line in history array.
   EnterHistory:
   If Len(Var$) Then
      GoSub GetCount
      ' init
      EndOfHistoryFlag(Temp0) = -1
      If Var1 = 0 Then
         HistoryCount2(Temp0) = 1
         History2(Temp0, 1) = Var$
      Else
         ' add history
         If Var1 < MaxHistory Then
            HistoryCount2(Temp0) = Var1 + 1
            History2(Temp0, Var1 + 1) = Var$
         Else
            ' pack history
            For Var = 1 To MaxHistory - 1
               History2(Temp0, Var) = History2(Temp0, Var + 1)
            Next
            HistoryCount2(Temp0) = MaxHistory
            History2(Temp0, MaxHistory) = Var$
         End If
      End If
   End If
   Return

   ' clear edit line.
   EraseLine:
   Locate L, P, 1
   For V = 1 To Len(Var$)
      Print " ";
   Next
   Locate L, P, 1
   Var$ = ""
   X = 1
   Return

   ' display current entry area.
   DisplayLine:
   Locate L, P, 1
   Var2$ = Var$ + " "
   For V = 1 To Len(Var2$)
      Print Mid$(Var2$, V, 1);
      ' bump prompt up if at corner
      If Status Then
         If CsrLin = 23 And Pos(0) = 80 Then L = L - 1: Print
      Else
         If CsrLin = 24 And Pos(0) = 80 Then L = L - 1: Print
      End If
   Next

   ' position cursor.
   DisplayLine2:
   Locate L, P, 1
   For V = 1 To X - 1
      Print Mid$(Var$, V, 1);
   Next
   Color Plain, Black
   Return

   ' get number of history in list.
   GetCount:
   Var1 = 0
   For Var2 = MaxHistory To 1 Step -1
      If RTrim$(History2(Temp0, Var2)) <> "" Then
         Var1 = Var2
         Exit For
      End If
   Next
   Return
End Function

Function ValidDate (Var$)
   ' mm-dd-yyyy or mm/dd/yyyy
   Var$ = RTrim$(Var$)
   If Len(Var$) <> 10 Then
      ValidDate = False
      Exit Function
   End If
   V1$ = Mid$(Var$, 3, 1)
   V2$ = Mid$(Var$, 6, 1)
   If V1$ = "-" And V1$ = "-" Then
      Eat$ = Nul
   Else
      If V1$ = "/" And V2$ = "/" Then
         Eat$ = Nul
      Else
         ValidDate = False
         Exit Function
      End If
   End If
   For Var = 1 To 10
      V$ = Mid$(Var$, Var, 1)
      Select Case Var
         Case 1, 2, 4, 5, 7, 8, 9, 10
            If V$ >= "0" And V$ <= "9" Then
               Eat$ = Nul
            Else
               ValidDate = False
               Exit Function
            End If
      End Select
   Next
   M = Int(Val(Mid$(Var$, 1, 2)))
   D = Int(Val(Mid$(Var$, 4, 2)))
   Y = Int(Val(Mid$(Var$, 7, 4)))
   If M >= 1 And M <= 12 Then
      If D >= 1 And D <= 31 Then
         If Y >= 1980 And Y <= 2078 Then
            L = 0
            If Y / 4 = Y \ 4 Then
               L = -1
            End If
            If Y / 100 = Y \ 100 Then
               L = 0
            End If
            If Y / 400 = Y \ 400 Then
               L = -1
            End If
            Select Case M
               Case 1, 3, 5, 7, 8, 10, 12
                  If D <= 31 Then
                     ValidDate = -1
                     Exit Function
                  End If
               Case 4, 6, 9, 11
                  If D <= 30 Then
                     ValidDate = -1
                     Exit Function
                  End If
               Case 2
                  If L Then
                     If D <= 29 Then
                        ValidDate = -1
                        Exit Function
                     End If
                  End If
                  If D <= 28 Then
                     ValidDate = -1
                     Exit Function
                  End If
            End Select
         End If
      End If
   End If
   ValidDate = 0
End Function

Function ValidTime (Var$)
   ' hh:mm:ss
   Var$ = RTrim$(Var$)
   If Len(Var$) <> 8 Then
      ValidTime = False
      Exit Function
   End If
   For Var = 1 To 8
      V$ = Mid$(Var$, Var, 1)
      Select Case Var
         Case 1, 2, 4, 5, 7, 8
            If V$ >= "0" And V$ <= "9" Then
               Eat$ = ""
            Else
               ValidTime = False
               Exit Function
            End If
         Case Else
            If V$ <> ":" Then
               ValidTime = False
               Exit Function
            End If
      End Select
   Next
   H = Int(Val(Mid$(Var$, 1, 2)))
   M = Int(Val(Mid$(Var$, 4, 2)))
   S = Int(Val(Mid$(Var$, 7, 2)))
   If H >= 0 And H <= 23 Then
      If M >= 0 And M <= 59 Then
         If S >= 0 And S <= 59 Then
            ValidTime = -1
            Exit Function
         End If
      End If
   End If
   ValidTime = 0
End Function

Function clock$ (X)
   ' mm-dd-yyyy hh:mm:ss
   If X Then
      clock$ = Date$ + " " + Time$
      Exit Function
   End If

   ' Def FNclock$=Format$(Now,"ddd dd mmm yyyy\, hh:mma/p")
   M = Val(Left$(Date$, 2))
   D = Val(Mid$(Date$, 4, 2))
   Y = Val(Right$(Date$, 4))

   If M < 3 Then M = M + 12: Y = Y - 1
   W = ((13 * M + 3) \ 5 + D + Y + Y \ 4 - Y \ 100 + Y \ 400 + 1) Mod 7
   var$ = Mid$("SunMonTueWedThuFriSat", W * 3 + 1, 3)
   var$ = var$ + " " + Mid$(Date$, 4, 2) ' dd

   T = (Val(Mid$(Date$, 1, 2)) - 1) * 3 + 1
   var$ = var$ + " " + Mid$("JanFebMarAprMayJunJulAugSepOctNovDec", T, 3)

   var$ = var$ + " " + Mid$(Date$, 7, 4) ' yyyy

   T = Val(Left$(Time$, 2))
   If T > 11 Then T = T - 12
   If T = 0 Then T = 12
   var$ = var$ + ", " + Right$("00" + LTrim$(Str$(T)), 2) ' hh
   var$ = var$ + ":" + Mid$(Time$, 4, 2) ' mm

   T = Val(Left$(Time$, 2))
   If T < 12 Then
      var$ = var$ + "a"
   Else
      var$ = var$ + "p"
   End If
   clock$ = var$
End Function

Sub ViewFileInfo (Var$)
   Dim finddata As WIN32_FIND_DATAA
   Dim hfind As _Unsigned _Offset

   If InStr(Var$, "?") Then
      Var1$ = " Error "
      Var2$ = "Invalid filename."
      VarX = MessageBox(Var1$, Var2$)
      Exit Sub
   End If

   If InStr(Var$, "*") Then
      Var1$ = " Error "
      Var2$ = "Invalid filename."
      VarX = MessageBox(Var1$, Var2$)
      Exit Sub
   End If

   VarX$ = Var$
   If Mid$(VarX$, 2, 1) = ":" Then
      Print #StdoutHandle, "Drive "; Left$(VarX$, 3)
      VarX$ = Mid$(VarX$, 3)
   End If
   If Left$(VarX$, 2) = "\\" Then
      V = InStr(3, VarX$, "\")
      V = InStr(V + 1, VarX$, "\")
      Print #StdoutHandle, "Netpath: "; Left$(VarX$, V)
      VarX$ = Mid$(VarX$, V)
   End If
   For V = Len(VarX$) To 1 Step -1
      If Mid$(VarX$, V, 1) = "\" Then
         Path$ = Left$(VarX$, V)
         File$ = Mid$(VarX$, V + 1)
         Exit For
      End If
   Next
   Print #StdoutHandle, "Pathname: "; Path$

   File$ = UnAmbiguateFile$(Var$)
   Print #StdoutHandle, "Filename: "; File$

   VarX$ = UCase$(AmbiguateFile$(Var$))
   Print #StdoutHandle, "Short filename: "; VarX$

   ' display file attributes/date/time.
   FileSize = False
   TempASCIIZ = Var$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(TempASCIIZ), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Attribute = finddata.dwFileAttributes
      Print #StdoutHandle, "Attributes: ";
      If (Attribute And &H1) = &H1 Then ' read-only
         Print #StdoutHandle, "Read-Only ";
      End If
      If (Attribute And &H2) = &H2 Then ' hidden
         Print #StdoutHandle, "Hidden ";
      End If
      If (Attribute And &H4) = &H4 Then ' system
         Print #StdoutHandle, "System ";
      End If
      If (Attribute And &H20) = &H20 Then ' archive
         Print #StdoutHandle, "Archive ";
      End If
      ' check for compressed
      If (Attribute And &H800) = &H800 Then
         Print #StdoutHandle, "Compressed ";
      End If
      ' check for encryption
      If (Attribute And &H4000) = &H4000 Then
         Print #StdoutHandle, "Encrypted";
      End If
      Print #StdoutHandle, ""
      FileSize = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow
      x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
      Print #StdoutHandle, "Create: "; GetDateTime
      VarQ$ = "Create: " + GetDateTime
      x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
      Print #StdoutHandle, "Access: "; GetDateTime
      x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
      Print #StdoutHandle, "Modify: "; GetDateTime
      x = FindClose(hfind)
   End If
   Print #StdoutHandle, "Filesize: "; FormatString$(FileSize)

   x = FileEncryptionStatusA(TempASCIIZ, f&)
   If x Then
      Print #StdoutHandle, "Encryption: ";
      Select Case f&
         Case 0
            Print #StdoutHandle, "File can be encrypted."
         Case 1
            Print #StdoutHandle, "File is encrypted."
         Case 2
            Print #StdoutHandle, "File is system."
         Case 3
            Print #StdoutHandle, "File is root."
         Case 4
            Print #StdoutHandle, "File is system directory."
         Case 5
            Print #StdoutHandle, "Encryption status unknown."
         Case 6
            Print #StdoutHandle, "File system does not support encryption."
         Case 7
            Print #StdoutHandle, "Reserved."
         Case 8
            Print #StdoutHandle, "File is read-only."
         Case Else
            Print #StdoutHandle, "Unknown."
      End Select
   End If
   VarX = MessageBox(" FileInfo ", "Filename: " + File$ + "|" + "Filesize: " + FormatString$(FileSize) + "|" + VarQ$)
End Sub

' encrypts string
Function EnCrypt$ (Var2$)
   Var$ = Var2$
   Var1 = Len(Var$)
   If Var1 = 0 Then
      EnCrypt = ""
      Exit Function
   End If
   For Var2 = 0 To Var1 - 1
      VarZ = Asc(Mid$(Var$, Var2 + 1, 1))
      VarZ = VarZ Xor Var1
      If Var2 = False Then
         VarZ = VarZ Xor Primekey
      Else
         VarZ = VarZ Xor Var2
         VarZ = VarZ Xor Asc(Mid$(Var$, Var2, 1))
      End If
      Mid$(Var$, Var2 + 1, 1) = Chr$(VarZ)
   Next
   If Var1 = 1 Then
      EnCrypt = Var$
      Exit Function
   End If
   For Var2 = Var1 - 1 To 0 Step -1
      VarZ = Asc(Mid$(Var$, Var2 + 1, 1))
      VarZ = VarZ Xor Var1
      If Var2 = Var1 - 1 Then
         VarZ = VarZ Xor Primekey
      Else
         VarZ = VarZ Xor Var2
         VarZ = VarZ Xor Asc(Mid$(Var$, Var2 + 2, 1))
      End If
      Mid$(Var$, Var2 + 1, 1) = Chr$(VarZ)
   Next
   EnCrypt = Var$
End Function

' user profiles editor menu
Sub EditProfiles
   ' check locked profiles
   If LockProfiles Then
      If ProfilesActive = 0 Then
         Print "User profiles not active."
         Exit Sub
      End If
      If Username <> "SYSOP" Then
         Print "User profiles editor locked."
         Exit Sub
      End If
   End If
   Do
      Color Yellow
      Print "User Profiles Editor Options ";
      If Username > "" Then
         Call GetUserStats(V#)
         If Len(RTrim$(UserProfileRecord2.Username)) Then
            Print "for";
            VarQ$ = " " + RTrim$(UserProfileRecord2.Username)
            Color Red
            Print VarQ$;
         End If
      End If
      Print
      Color White
      Print "  (A)dd"
      Print "  (C)hange"
      Print "  (D)elete"
      Print "  (F)ind"
      Print "  (I)nit"
      Print "  (L)ist"
      Print "  (P)ack"
      Print "  (S)ort"
      Print "  (U)ndelete"
      Color Yellow
      Print "Enter option(Q to quit)?";
      Color White
      Do
         Locate , , 1
         x$ = INKEYz$
         If Len(x$) Then
            If x$ = Chr$(13) Then
               ' eat
            Else
               Print x$
               Exit Do
            End If
         End If
      Loop
      If UCase$(x$) = "Q" Then
         Color Plain
         Exit Sub
      End If
      Select Case UCase$(x$)
         Case "A"
            Call AddProfile("", VarX)
         Case "C"
            Call ChangeProfile
         Case "D"
            Call DeleteProfile
         Case "F"
            Call FindProfile
         Case "I"
            Call InitProfile
         Case "L"
            Call ListProfiles
         Case "P"
            Call PackProfiles
         Case "S"
            Call SortProfiles
         Case "U"
            Call UndeleteProfile
      End Select
   Loop
End Sub

Sub InitProfile
   v$ = "Are you sure you want to init profiles(y/n)? "
   Call MorePrompt(v$, "yn", Outpt$)
   If Outpt$ = "y" Then
      Call InitProfiles(-1)
      Username = "SYSOP"
      Call GetUserProfile(V, "")
      If V Then
         ProfilesActive = -1
         Print #StdoutHandle, "User Profiles init."
      Else
         ProfilesActive = 0
         Print #StdoutHandle, "User Profiles init fail."
      End If
   End If
End Sub

Sub AddProfile (Var1$, VarX)
   VarX = 0
   Do
      Color White
      If Len(Var1$) Then
         Call MorePrompt("Add " + Var1$ + "(y/n)? ", "yn", Outpt$)
         If LCase$(Outpt$) = "n" Then
            Print "Username?";
            X$ = LineInput$(CsrLin, Pos(0), 20): Print
         End If
         If LCase$(Outpt$) = "y" Then
            X$ = Var1$
         End If
      Else
         Print "Username?";
         X$ = LineInput$(CsrLin, Pos(0), 20): Print
      End If
      Color White
      Print "Password?";
      MaskInput = -1
      Y$ = LineInput$(CsrLin, Pos(0), 8): Print
      MaskInput = 0
      If X$ = "" Or Y$ = "" Then
         Print "Username entry failed."
         Exit Do
      End If
      X$ = UCase$(X$)
      Y$ = UCase$(Y$)
      If Len(X$) < 3 Then
         Print "Username must be at least 3 characters."
      Else
         If Len(Y$) < 3 Then
            Print "Password must be at least 3 characters."
         Else
            If Len(X$) > 20 Then
               Print "Username can be at most 20 characters."
            Else
               If Len(Y$) > 8 Then
                  Print "Password can be at most 8 characters."
               Else
                  If InStr(X$, " ") Then
                     Print "Invalid characters in username."
                  Else
                     If ValidFileChar(X$) Then
                        Print "Invalid characters in username."
                     Else
                        f$ = GetProfileFilename$
                        X = FreeFile
                        Open f$ For Random As #X Len = Len(UserProfileRecord2)
                        V = 0
                        For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
                           Get X, Z!, UserProfileRecord2
                           If X$ = RTrim$(UserProfileRecord2.Username) Then
                              Print "Username already exists."
                              V = -1
                              Exit For
                           End If
                        Next
                        If V = 0 Then
                           UserProfileRecord2.Username = X$
                           UserProfileRecord2.Password = EnCrypt$(Y$)
                           UserProfileRecord2.ScreenSaver = 0
                           UserProfileRecord2.ScreenTimer = 0
                           UserProfileRecord2.LastDateOn = Date$ + " " + Time$ ' 01/01/1980 HH:MM:SS
                           UserProfileRecord2.CreationDate = Date$ + " " + Time$
                           UserProfileRecord2.TimesLoggedOn = 0#

                           UserProfileRecord2.ASCIIZreserved1 = ""
                           UserProfileRecord2.ASCIIZreserved2 = ""
                           UserProfileRecord2.DOSreserved1 = ""
                           UserProfileRecord2.DOSreserved2 = ""
                           UserProfileRecord2.TimesDeleted = 0
                           UserProfileRecord2.TimesUndeleted = 0

                           UserProfileRecord2.MonitorOn = 0
                           UserProfileRecord2.MonitorTimer = 60 ' seconds
                           UserProfileRecord2.MonitorLimit = 10 ' megabytes

                           UserProfileRecord2.Reserved1 = 0%
                           UserProfileRecord2.Reserved2 = 0%
                           UserProfileRecord2.Reserved3 = 0!
                           UserProfileRecord2.Reserved4 = 0!
                           UserProfileRecord2.Reserved5 = 0&
                           UserProfileRecord2.Reserved6 = 0&
                           UserProfileRecord2.Reserved7 = 0#
                           UserProfileRecord2.Reserved8 = 0#

                           UserProfileRecord2.Deleted = 0
                           Z! = LOF(X) / Len(UserProfileRecord2) + 1!
                           Put #X, Z!, UserProfileRecord2
                           Print "Username created."
                           VarX = -1
                           Exit Do
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
   Loop
   Close X
   Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
End Sub

Sub ChangeProfile
   f$ = GetProfileFilename$
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   Do
      Color White
      Print "Username?";
      X$ = LineInput$(CsrLin, Pos(0), 20): Print
      Color White
      Print "Password?";
      MaskInput = -1
      Y$ = LineInput$(CsrLin, Pos(0), 8): Print
      MaskInput = 0
      If X$ = "" Or Y$ = "" Then
         Print "Username entry failed."
         Exit Do
      End If
      X$ = UCase$(X$)
      Y$ = UCase$(Y$)
      If Len(X$) < 3 Then
         Print "Username must be at least 3 characters."
      Else
         If Len(Y$) < 3 Then
            Print "Password must be at least 3 characters."
         Else
            If Len(X$) > 20 Then
               Print "Username can be at most 20 characters."
            Else
               If Len(Y$) > 8 Then
                  Print "Password can be at most 8 characters."
               Else
                  For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
                     Get X, Z!, UserProfileRecord2
                     If X$ = RTrim$(UserProfileRecord2.Username) Then
                        UserProfileRecord2.Password = EnCrypt$(Y$)
                        Put #X, Z!, UserProfileRecord2
                        Print "Username changed."
                        Exit Do
                     End If
                  Next
                  Print "Username not found."
               End If
            End If
         End If
      End If
   Loop
   Close X
   Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
End Sub

Sub DeleteProfile
   f$ = GetProfileFilename$
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   Do
      Color White
      Print "Username?";
      X$ = LineInput$(CsrLin, Pos(0), 20): Print
      Color White
      If X$ = "" Then
         Print "Username entry failed."
         Exit Do
      End If
      X$ = UCase$(X$)
      If X$ = "SYSOP" Then
         Print "Cannot delete Sysop."
         Exit Do
      End If
      If Username > "" Then
         If X$ = Username Then
            Print "Cannot delete yourself."
            Exit Do
         End If
      End If
      If Len(X$) < 3 Then
         Print "Username must be at least 3 characters."
      Else
         If Len(X$) > 20 Then
            Print "Username can be at most 20 characters."
         Else
            For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
               Get X, Z!, UserProfileRecord2
               If X$ = RTrim$(UserProfileRecord2.Username) Then
                  If UserProfileRecord2.Deleted Then
                     Print "Username already deleted."
                  Else
                     UserProfileRecord2.Deleted = -1
                     UserProfileRecord2.TimesDeleted = UserProfileRecord2.TimesDeleted + 1
                     Put #X, Z!, UserProfileRecord2
                     Print "Username deleted."
                  End If
                  Exit Do
               End If
            Next
            Print "Username not found."
         End If
      End If
   Loop
   Close X
   Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
End Sub

Sub PackProfiles
   f$ = GetProfileFilename$
   g$ = GetProfileBackupFilename$
   If _FileExists(g$) Then
      x$ = g$ + Chr$(0)
      r = DeleteFileA(x$)
   End If

   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   Y = FreeFile
   Open g$ For Random As #Y Len = Len(UserProfileRecord2)

   ' copy datafile to backup
   For Z1! = 1! To LOF(X) / Len(UserProfileRecord2)
      Get X, Z1!, UserProfileRecord2
      Put Y, Z1!, UserProfileRecord2
   Next
   Close X, Y

   ' delete profiles datafile
   x$ = f$ + Chr$(0)
   r = DeleteFileA(x$)

   ' copy backup to datafile packing deleted usernames
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   Y = FreeFile
   Open g$ For Random As #Y Len = Len(UserProfileRecord2)
   Z3! = 0!
   For Z1! = 1! To LOF(Y) / Len(UserProfileRecord2)
      Get #Y, Z1!, UserProfileRecord2
      If UserProfileRecord2.Deleted Then
         Z3! = Z3! + 1!
      Else
         Z2! = LOF(X) / Len(UserProfileRecord2) + 1!
         Put #X, Z2!, UserProfileRecord2
      End If
   Next
   Close X, Y
   Print "Profiles packed. Users deleted:"; Z3!
   Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
End Sub

Sub SortProfiles
   f$ = GetProfileFilename$
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord)
   Call MorePrompt("Sort (a)scending/(d)escending?", "ad", Outpt2$)
   V = -1
   If Outpt2$ = "d" Then
      V = 0
   End If
   Var$ = Nul
   Call MorePrompt("Skip username(y/n)? ", "yn", Outpt2$)
   If Outpt2$ = "y" Then
      Print "Enter usernames separated by commas(wildcard ? and * allowed)? ";
      Line Input Var$
      Var$ = UCase$(Var$)
   End If

   ' bubble sort skipping sysop.
   Z3! = 0!
   For Z1! = 2! To LOF(X) / Len(UserProfileRecord)
      For Z2! = Z1! + 1! To LOF(X) / Len(UserProfileRecord)
         Get X, Z1!, UserProfileRecord3
         Get X, Z2!, UserProfileRecord2
         Flag1 = -1: Flag2 = -1
         If Len(Var$) Then
            Do
               V = InStr(Var$, ",")
               If V Then
                  VarX$ = Left$(Var$, InStr(Var$, ",") - 1)
                  Var$ = Mid$(Var$, InStr(Var$, ",") + 1)
                  If Len(VarX$) Then
                     X$ = RTrim$(UserProfileRecord2.Username)
                     Call InstrSUB1(Flag1, VarX$, X$, 0)
                     X$ = RTrim$(UserProfileRecord3.Username)
                     Call InstrSUB1(Flag2, VarX$, X$, 0)
                     If Flag1 Or Flag2 Then
                        Exit Do
                     End If
                  End If
               Else
                  VarX$ = Var$
                  If Len(VarX$) Then
                     X$ = RTrim$(UserProfileRecord2.Username)
                     Call InstrSUB1(Flag1, VarX$, X$, 0)
                     X$ = RTrim$(UserProfileRecord3.Username)
                     Call InstrSUB1(Flag2, VarX$, X$, 0)
                  End If
                  Exit Do
               End If
            Loop
         End If
         If Flag1 And Flag2 Then
            If V Then
               If UserProfileRecord3.Username > UserProfileRecord2.Username Then
                  Z3! = Z3! + 1!
                  Put X, Z1!, UserProfileRecord2
                  Put X, Z2!, UserProfileRecord3
               End If
            Else
               If UserProfileRecord3.Username < UserProfileRecord2.Username Then
                  Z3! = Z3! + 1!
                  Put X, Z1!, UserProfileRecord2
                  Put X, Z2!, UserProfileRecord3
               End If
            End If
         End If
      Next
   Next
   Close X
   Print "User profiles sorted. Swaps made:"; Z3!
   Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
End Sub

Sub UndeleteProfile
   f$ = GetProfileFilename$
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord2)
   Do
      Color White
      Print "Username?";
      X$ = LineInput$(CsrLin, Pos(0), 20): Print
      Color White
      If X$ = "" Then
         Print "Username entry failed."
         Exit Do
      End If
      X$ = UCase$(X$)
      If Len(X$) < 3 Then
         Print "Username must be at least 3 characters."
      Else
         If Len(X$) > 20 Then
            Print "Username can be at most 20 characters."
         Else
            For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
               Get X, Z!, UserProfileRecord2
               If X$ = RTrim$(UserProfileRecord2.Username) Then
                  If UserProfileRecord2.Deleted = 0 Then
                     Print "Username not deleted."
                  Else
                     UserProfileRecord2.Deleted = 0
                     UserProfileRecord2.TimesUndeleted = UserProfileRecord2.TimesUndeleted + 1
                     Put #X, Z!, UserProfileRecord2
                     Print "Username undeleted."
                  End If
                  Exit Do
               End If
            Next
            Print "Username not found."
         End If
      End If
   Loop
   Close X
   Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
End Sub

Sub GetUserStats (V#)
   V# = 0#
   f$ = GetProfileFilename$
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord)
   If LOF(X) = 0 Then
      Close X
      Exit Sub
   End If
   For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
      Get X, Z!, UserProfileRecord2
      If RTrim$(UserProfileRecord2.Username) = RTrim$(Username) Then
         V# = UserProfileRecord2.TimesLoggedOn
         Exit For
      End If
   Next
   Close #X
End Sub

Sub PutUserStats (V#)
   V# = 0#
   f$ = GetProfileFilename$
   If _FileExists(f$) = 0 Then Exit Sub
   X = FreeFile
   Open f$ For Random As #X Len = Len(UserProfileRecord)
   If LOF(X) = 0 Then
      Close X
      Exit Sub
   End If
   For Z! = 1! To LOF(X) / Len(UserProfileRecord2)
      Get X, Z!, UserProfileRecord2
      If RTrim$(UserProfileRecord2.Username) = RTrim$(Username) Then
         V# = UserProfileRecord2.TimesLoggedOn
         V# = V# + 1#
         UserProfileRecord2.TimesLoggedOn = V#
         UserProfileRecord2.LastDateOn = Date$ + " " + Time$ ' 01/01/1980 HH:MM:SS
         Put X, Z!, UserProfileRecord2
         Exit For
      End If
   Next
   Close #X
End Sub

' count bytes
Function CountBytes# (Var4$, Ext$)
   Dim ASCIIZ4 As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim hfind As _Offset
   Found# = 0#

   ' reset search parameter
   If Var4$ = "" Then
      Var4$ = _CWD$
   End If
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = "" Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata.dwFileAttributes
               If (Var# And &H10) = &H0 Then
                  VarZ# = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow
                  Found# = Found# + VarZ#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
   CountBytes# = Found#
End Function

' count files
Function CountFiles# (Var4$, Ext$)
   Dim ASCIIZ4 As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim hfind As _Offset
   Found# = 0#

   ' reset search parameter
   If Var4$ = "" Then
      Var4$ = _CWD$
   End If
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = "" Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata.dwFileAttributes
               If (Var# And &H10) = &H0 Then
                  Found# = Found# + 1#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
   CountFiles# = Found#
End Function

' count dirs
Function CountDirs# (Var4$, Ext$)
   Dim ASCIIZ4 As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim hfind As _Offset
   Found# = 0#

   ' reset search parameter
   If Var4$ = "" Then
      Var4$ = _CWD$
   End If
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = "" Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata.dwFileAttributes
               If (Var# And &H10) = &H10 Then
                  Found# = Found# + 1#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
   CountDirs# = Found#
End Function

' count drives
Function CountDriveLetters$
   v$ = Nul
   For c = 1 To 26
      If DRIVEEXISTS(c) = 0 Then
         v$ = v$ + Chr$(c + 64)
      End If
   Next
   CountDriveLetters = v$
End Function

' count drives
Function CountDrives%
   v = 0
   For c = 1 To 26
      If DRIVEEXISTS(c) = 0 Then
         v = v + 1
      End If
   Next
   CountDrives = v
End Function

' simple file edit menu
Sub Menu
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset
   Dim hfind As _Offset

   cx$ = _CWD$
   Do
      Color Yellow
      Print "Main Options for ";
      Color Red
      Print _CWD$
      Color White
      Print "  (A)bout box"
      Print "  (C)ount specs"
      Print "  (D)irectory"
      Print "  (F)iles"
      Print "  (V)olume"
      Print "  (R)eset path"
      Print "  (S)ystem"
      Print "  (W)hatisbox"
      Print "  (Q)uit"
      Color Yellow
      Print "Enter option?";
      Color White
      Do
         Locate , , 1
         x$ = INKEYz$
         If Len(x$) Then
            If x$ = Chr$(13) Then
               ' eat
            Else
               Print x$
               Exit Do
            End If
         End If
      Loop
      If UCase$(x$) = "Q" Then
         Color Plain
         f$ = cx$ + Chr$(0)
         x = SetCurrentDirectoryA(f$)
         Exit Sub
      End If
      Select Case UCase$(x$)
         Case "A"
            Call HelpAbout
         Case "R"
            f$ = cx$ + Chr$(0)
            x = SetCurrentDirectoryA(f$)
         Case "W"
            r = WhatisBox("sqr(2)", "")
         Case "C"
            Color White
            f$ = _CWD$
            Q# = CountBytes#(f$, "*.*")
            f$ = _CWD$
            X# = CountFiles(f$, "*.*")
            f$ = _CWD$
            Y# = CountDirs(f$, "*.*")
            Z = CountDrives
            Z1$ = CountDriveLetters
            Print _CWD$
            Print "Drives:"; Z; "("; Z1$; ")"
            Print "Dirs: "; FormatString$(Y#)
            Print "Files: "; FormatString$(X#)
            Print "Bytes: "; FormatString$(Q#)
            Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
         Case "S"
            Do
               Color Yellow
               Print "System Options for: ";
               Color Red
               Print Left$(_CWD$, 3)
               Color White
               Print "  (C)pu load"
               Print "  (S)ystem RAM"
               Print "  (P)aging RAM"
               Print "  (V)irtual RAM"
               Print "  (Q)uit"
               Color Yellow
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = INKEYz$
                  If Len(x$) Then
                     If x$ = Chr$(13) Then
                        ' eat
                     Else
                        Print x$
                        Exit Do
                     End If
                  End If
               Loop
               If UCase$(x$) = "Q" Then Exit Do
               Select Case UCase$(x$)
                  Case "C"
                     Color Yellow
                     S$ = Str$(Int(GetCPULoad * 10000) / 100) ' 100.00
                     If InStr(S$, ".") Then
                        Q$ = Mid$(S$, InStr(S$, ".") + 1)
                        S$ = Left$(S$, InStr(S$, ".") - 1)
                        Q$ = Left$(Q$, 3)
                        S$ = S$ + "." + Q$
                     Else
                        S$ = S$ + ".0"
                     End If
                     Print "CPU " + S$ + "%" ' 100.00
                     Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                  Case "S"
                     Color Yellow
                     Print "Total Physical Memory: "; FormatString$(CDbl(TotalPhysicalMem))
                     Print "Free Physical Memory: "; FormatString$(CDbl(FreePhysicalMem))
                     Used# = CDbl(TotalPhysicalMem) - CDbl(FreePhysicalMem)
                     Print "Used Physical Memory: "; FormatString$(Used#)
                     Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                  Case "P"
                     Color Yellow
                     Print "Total Paging File: "; FormatString$(CDbl(TotalPagingFile))
                     Print "Free Paging File: "; FormatString$(CDbl(FreePagingFile))
                     Used# = CDbl(TotalPagingFile) - CDbl(FreePagingFile)
                     Print "Used Paging File: "; FormatString$(Used#)
                     Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                  Case "V"
                     Color Yellow
                     Print "Total Virtual Memory: "; FormatString$(CDbl(TotalVirtualMem))
                     Print "Free Virtual Memory: "; FormatString$(CDbl(FreeVirtualMem))
                     Used# = CDbl(TotalVirtualMem) - CDbl(FreeVirtualMem)
                     Print "Used Virtual Memory: "; FormatString$(Used#)
                     Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
               End Select
            Loop
         Case "D"
            Do
               Color Yellow
               Print "Directory Options for: ";
               Color Red
               Print _CWD$
               Color White
               Print "  (A)ttribute override"
               Print "  (C)reate directory"
               Print "  (L)ist directories"
               Print "  (R)emove directory"
               Print "  (S)et current directory"
               Print "  (V)erify duplicates"
               Print "  (X)search directories"
               Print "  (Y)count duplicates"
               Print "  (Z)extended display"
               Print "  (Q)uit"
               Color Yellow
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = INKEYz$
                  If x$ = Chr$(13) Then
                     ' eat
                  Else
                     If Len(x$) Then
                        Print x$
                        Exit Do
                     End If
                  End If
               Loop
               If UCase$(x$) = "Q" Then Exit Do
               Select Case UCase$(x$)
                  Case "Z"
                     Color White
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ = "" Then f$ = _CWD$
                     If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
                     Quit.Searching = 0: Continue.Search = 0: Line.Counter = 0: Line.Counter2 = 0
                     Dirs.Counted = 0
                     Call Recurse_Directories(f$)
                     If Line.Counter Then
                        Call MorePrompt("-more-", " " + Chr$(13), Output.Char$)
                     End If
                     Color Yellow
                     Print "Dirs counted: "; FormatString$(Dirs.Counted)
                  Case "X"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> "" Then
                        Call CallListFiles(f$, 0)
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "A"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> "" Then
                        ASCIIZ = f$ + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           Attribute = finddata.dwFileAttributes
                           x = FindClose(Wfile.Handle)
                           ' check for directory
                           If (Attribute And &H10) = &H10 Then
                              Do
                                 Color Yellow
                                 Print "Attributes:"
                                 Color White
                                 Print "  (1)Read-Only ";
                                 If (Attribute And &H1) = &H1 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (2)Hidden ";
                                 If (Attribute And &H2) = &H2 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (3)System ";
                                 If (Attribute And &H4) = &H4 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (4)Archive ";
                                 If (Attribute And &H20) = &H20 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (Q)uit"
                                 Color Yellow
                                 Print "Enter option?";
                                 Color White
                                 Do
                                    Locate , , 1
                                    x$ = INKEYz$
                                    If Len(x$) Then
                                       Print
                                       Exit Do
                                    End If
                                 Loop
                                 If UCase$(x$) = "Q" Then Exit Do
                                 Select Case x$
                                    Case "1"
                                       Attribute = Attribute Xor &H1
                                    Case "2"
                                       Attribute = Attribute Xor &H2
                                    Case "3"
                                       Attribute = Attribute Xor &H4
                                    Case "4"
                                       Attribute = Attribute Xor &H20
                                 End Select
                              Loop
                              ' change filename attribute
                              x = SetFileAttributes&(ASCIIZ, Attribute)
                           Else
                              Color White
                              Print "Specified filename."
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           End If
                        Else
                           Color White
                           Print "Path not found."
                           Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                        End If
                     End If
                  Case "V"
                     Color White
                     f$ = _SelectFolderDialog$("Enter first directory", _CWD$)
                     If f$ <> "" Then
                        Color White
                        g$ = _SelectFolderDialog$("Enter second directory", _CWD$)
                        If g$ <> "" Then
                           If _DirExists(f$) And _DirExists(g$) Then
                              Color Plain
                              Call VerifyFiles(f$, g$, 0)
                           Else
                              Color White
                              Print "Path not found."
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           End If
                        End If
                     End If
                  Case "Y"
                     Color White
                     f$ = _SelectFolderDialog$("Enter first directory", _CWD$)
                     If f$ <> "" Then
                        Color White
                        g$ = _SelectFolderDialog$("Enter second directory", _CWD$)
                        If g$ <> "" Then
                           If _DirExists(f$) And _DirExists(g$) Then
                              Color Plain
                              Call VerifyFiles(f$, g$, -1)
                              Color White
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           Else
                              Color White
                              Print "Path not found."
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           End If
                        End If
                     End If
                  Case "L"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> "" Then
                        LineCount = 0
                        If Status Then
                           LineBreak = 21
                        Else
                           LineBreak = 22
                        End If
                        Quit = 0
                        ' start directory search
                        ASCIIZ = f$ + "\*.*" + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           Do
                              Attribute = finddata.dwFileAttributes
                              ' check for directory
                              If (Attribute And &H10) = &H10 Then
                                 ' store directory name
                                 Directory$ = finddata.cFileName
                                 Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)
                                 ' check directory name
                                 If Directory$ <> "." And Directory$ <> ".." Then
                                    Color Yellow
                                    Print Directory$
                                    LineCount = LineCount + 1
                                    If LineCount >= LineBreak Then
                                       LineCount = 0
                                       Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                                       If Outpt$ = "n" Then
                                          Exit Do
                                       End If
                                    End If
                                 End If
                              End If
                           Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
                           x = FindClose(Wfile.Handle)
                           If LineCount Then
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           End If
                        Else
                           Color White
                           Print "File not found."
                        End If
                     End If
                  Case "C"
                     Print "Enter directory? ";
                     f$ = LineInput$(CsrLin, Pos(0), 40): Print
                     If f$ <> "" Then
                        x = CreateDirectoryStructure(f$)
                        Color Yellow
                        If x = 0 Then
                           If NetPathError Then
                              Print "Netpath error."
                           Else
                              Print "Error 0x" + Hex$(GetLastError) + " creating directory."
                              Print DisplayWinError$(x)
                           End If
                        Else
                           Print "Directory created."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "R"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> "" Then
                        If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
                        Color Yellow
                        If _DirExists(f$) = 0 Then
                           Print "Directory not found."
                        Else
                           Call Silentdel_Directories(f$)
                           If _DirExists(f$) Then
                              ' remove an empty directory
                              ASCIIZ = f$ + Chr$(0)
                              x = RemoveDirectoryA(ASCIIZ)
                              If x = 0 Then
                                 Print "Error deleting directory."
                                 Call DisplayWinError(r)
                              End If
                           Else
                              Print "Directory removed."
                           End If
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "S"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> "" Then
                        f$ = f$ + Chr$(0)
                        x = SetCurrentDirectoryA(f$)
                        Color Yellow
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " changing directory."
                           Print DisplayWinError$(x)
                        Else
                           Print "Directory changed."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
               End Select
            Loop
         Case "F"
            Do
               Color Yellow
               Print "File Options:"
               Color White
               Print "  (A)ppend file"
               Print "  (B)yte compare"
               Print "  (C)opy file"
               Print "  (D)elete file"
               Print "  (E)ncrypt file"
               Print "  (G)et filesize"
               Print "  (L)ist files"
               Print "  (M)ake file"
               Print "  (R)ename file"
               Print "  (S)et attributes"
               Print "  (T)est file"
               Print "  (U)nencrypt file"
               Print "  (V)erify files"
               Print "  (X)search files"
               Print "  (Z)view file info"
               Print "  (Q)uit"
               Color Yellow
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = INKEYz$
                  If Len(x$) Then
                     If x$ = Chr$(13) Then
                        ' eat
                     Else
                        Print x$
                        Exit Do
                     End If
                  End If
               Loop
               If UCase$(x$) = "Q" Then Exit Do
               Select Case UCase$(x$)
                  Case "Z"
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        Call ViewFileInfo(f$)
                     Else
                        Color White
                        Print "File not found."
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "X"
                     Color White
                     Print "Enter file spec(*.*)? ";
                     f$ = LineInput$(CsrLin, Pos(0), 40): Print
                     Call CallListFiles(f$, -1)
                  Case "B"
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        Filter$ = "All files (*.*)|*.*"
                        Title$ = "QB64Shell Open File" + Chr$(0)
                        g$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                        If g$ <> "" Then
                           If _FileExists(f$) And _FileExists(g$) Then
                              Color Plain
                              Call VerifyFiles2(f$, g$, -1)
                           Else
                              Color White
                              Print "File not found."
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           End If
                        End If
                     Else
                        Color White
                        Print "File not found."
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "V"
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        Filter$ = "All files (*.*)|*.*"
                        Title$ = "QB64Shell Open File" + Chr$(0)
                        g$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                        If g$ <> "" Then
                           If _FileExists(f$) And _FileExists(g$) Then
                              Color Plain
                              Call VerifyFiles2(f$, g$, 0)
                           Else
                              Color White
                              Print "File not found."
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           End If
                        End If
                     Else
                        Color White
                        Print "File not found."
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "G"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        ASCIIZ = f$ + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           File.Size# = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow
                           x = FindClose(Wfile.Handle)
                           X# = GetFileLines#(f$)
                           Print "File: "; f$
                           Print "Lines: "; FormatString$(X#); " ";
                           Print "Bytes: "; FormatString$(File.Size#)
                        Else
                           Color White
                           Print "File not found."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "S"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        ASCIIZ = f$ + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           Attribute = finddata.dwFileAttributes
                           x = FindClose(Wfile.Handle)
                           ' check for directory
                           If (Attribute And &H10) <> &H10 Then
                              Do
                                 Color Yellow
                                 Print "Attributes:"
                                 Color White
                                 Print "  (1)Read-Only ";
                                 If (Attribute And &H1) = &H1 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (2)Hidden ";
                                 If (Attribute And &H2) = &H2 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (3)System ";
                                 If (Attribute And &H4) = &H4 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (4)Archive ";
                                 If (Attribute And &H20) = &H20 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (Q)uit"
                                 Color Yellow
                                 Print "Enter option?";
                                 Color White
                                 Do
                                    Locate , , 1
                                    x$ = INKEYz$
                                    If Len(x$) Then
                                       Print
                                       Exit Do
                                    End If
                                 Loop
                                 If UCase$(x$) = "Q" Then Exit Do
                                 Select Case x$
                                    Case "1"
                                       Attribute = Attribute Xor &H1
                                    Case "2"
                                       Attribute = Attribute Xor &H2
                                    Case "3"
                                       Attribute = Attribute Xor &H4
                                    Case "4"
                                       Attribute = Attribute Xor &H20
                                 End Select
                              Loop
                              ' change filename attribute
                              x = SetFileAttributes&(ASCIIZ, Attribute)
                           Else
                              Color White
                              Print "Specified directory."
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           End If
                        Else
                           Color White
                           Print "File not found."
                           Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                        End If
                     End If
                  Case "L"
                     Print "Enter file spec? ";
                     f$ = LineInput$(CsrLin, Pos(0), 40): Print
                     If f$ <> "" Then
                        LineCount = 0
                        If Status Then
                           LineBreak = 21
                        Else
                           LineBreak = 22
                        End If
                        Quit = 0
                        ' start directory search
                        ASCIIZ = f$ + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           Do
                              Attribute = finddata.dwFileAttributes
                              ' check for directory
                              If (Attribute And &H10) <> &H10 Then
                                 ' store directory name
                                 Directory$ = finddata.cFileName
                                 Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)
                                 ' check directory name
                                 If Directory$ <> "." And Directory$ <> ".." Then
                                    Print Directory$
                                    LineCount = LineCount + 1
                                    If LineCount >= LineBreak Then
                                       LineCount = 0
                                       Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                                       If Outpt$ = "n" Then
                                          Exit Do
                                       End If
                                    End If
                                 End If
                              End If
                           Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
                           x = FindClose(Wfile.Handle)
                           If LineCount Then
                              Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                           End If
                        Else
                           Color White
                           Print "File not found."
                        End If
                     End If
                  Case "T"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        f$ = f$ + Chr$(0)
                        x = FileEncryptionStatusA(f$, f&)

                        'FileEncryptionStatus return variable:

                        '0 = can be encrypted
                        '1 = file is encrypted
                        '2 = file is a system file (cannot be encrypted)
                        '3 = file is root (cannot be encryped)
                        '4 = file is system directory (cannot be encrypted)
                        '5 = encryption status unknown. file may be encrypted
                        '6 = file system does not support file encryption
                        '7 = reserved
                        '8 = file is read-only

                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " accessing file."
                           Print DisplayWinError$(x)
                        End If
                        If x Then
                           Select Case f&
                              Case 0
                                 Print "File can be encrypted."
                              Case 1
                                 Print "File is encrypted."
                              Case 2
                                 Print "File is system."
                              Case 3
                                 Print "File is root."
                              Case 4
                                 Print "File is system directory."
                              Case 5
                                 Print "Encryption status unknown."
                              Case 6
                                 Print "File system does not support encryption."
                              Case 7 ' reserved
                              Case 8
                                 Print "File is read-only."
                           End Select
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "E"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        f$ = f$ + Chr$(0)
                        x = EncryptFile(f$)
                        Color Yellow
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " encrypting file."
                           Print DisplayWinError$(x)
                        Else
                           Print "File encrypted."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "U"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        f$ = f$ + Chr$(0)
                        x = DecryptFile(f$, 0) ' 0=reserved
                        Color Yellow
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " decrypting file."
                           Print DisplayWinError$(x)
                        Else
                           Print "File decrypted."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "D"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        f$ = f$ + Chr$(0)
                        x = DeleteFileA(f$)
                        Color Yellow
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " deleting file."
                           Print DisplayWinError$(x)
                        Else
                           Print "File deleted."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "A"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _SaveFileDialog$(Title$, "", "")

                     If f$ <> "" Then
                        f$ = f$ + Chr$(0)
                        hfind = CreateFileAqb(f$, 4)
                        Color Yellow
                        If hfind Then
                           Print "File accessed for append."
                        Else
                           Print "Error 0x" + Hex$(GetLastError) + " appending file."
                           Print DisplayWinError$(x)
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "M"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _SaveFileDialog$(Title$, "", "")

                     If f$ <> "" Then
                        f$ = f$ + Chr$(0)
                        hfind = CreateFileAqb(f$, 1)
                        Color Yellow
                        If hfind Then
                           Print "File created."
                        Else
                           Print "Error 0x" + Hex$(GetLastError) + " creating file."
                           Print DisplayWinError$(x)
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "R"
                     ' do the open file dialog call
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Open File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        ' do the open file dialog call
                        Filter$ = "All files (*.*)|*.*"
                        Title$ = "QB64Shell Open File" + Chr$(0)
                        g$ = _SaveFileDialog$(Title$, "", "")

                        If g$ <> "" Then
                           f$ = f$ + Chr$(0)
                           g$ = g$ + Chr$(0)
                           x = MoveFile(f$, g$)
                           Color Yellow
                           If x = 0 Then
                              Print "Error 0x" + Hex$(GetLastError) + " renaming filename."
                              Print DisplayWinError$(x)
                           Else
                              Print "Filename renamed."
                           End If
                           Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                        End If
                     End If
                  Case "C"
                     Filter$ = "All files (*.*)|*.*"
                     Title$ = "QB64Shell Source File" + Chr$(0)
                     f$ = _OpenFileDialog$(Title$, StartDir$, Filter$)

                     If f$ <> "" Then
                        ' do the open file dialog call
                        Filter$ = "All files (*.*)|*.*"
                        Title$ = "QB64Shell Destination File" + Chr$(0)
                        g$ = _SaveFileDialog$(Title$, "", "")

                        If g$ <> "" Then
                           f$ = f$ + Chr$(0)
                           g$ = g$ + Chr$(0)
                           x = CopyFile(f$, g$, 0) ' 0=overwrite, -1=don't
                           Color Yellow
                           If x = 0 Then
                              Print "Error 0x" + Hex$(GetLastError) + " copying filename."
                              Print DisplayWinError$(x)
                           Else
                              Print "Filename copied."
                           End If
                           Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                        End If
                     End If
               End Select
            Loop
         Case "V"
            Do
               Color Yellow
               Print "Volume Options for: ";
               Color Red
               c$ = Left$(_CWD$, 1)
               Call Vlabel(c$)
               If RTrim$(c$) = "" Then
                  z$ = DriveType
               Else
                  z$ = Left$(c$, 12)
               End If
               Print Left$(_CWD$, 2) + z$
               Color White
               Print "  (C)hange volume"
               Print "  (D)isplay serial"
               Print "  (G)et system type"
               Print "  (L)ist volume"
               Print "  (R)ead disk space"
               Print "  (V)iew drives"
               Print "  (X)search volume"
               Print "  (Y)randomize volume"
               Print "  (Z)ap all volumes"
               Print "  (Q)uit"
               Color Yellow
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = INKEYz$
                  If Len(x$) Then
                     If x$ = Chr$(13) Then
                        ' eat
                     Else
                        Print x$
                        Exit Do
                     End If
                  End If
               Loop
               If UCase$(x$) = "Q" Then Exit Do
               Color Yellow
               Select Case UCase$(x$)
                  Case "X"
                     Print "Enter drive volume? ";
                     g$ = LineInput$(CsrLin, Pos(0), 40): Print
                     g$ = UCase$(g$)
                     If g$ <> "" Then
                        For f = 1 To 26
                           f$ = UCase$(Chr$(f + 64))
                           v = GetDriveExists(f$)
                           If v Then
                              ' get drive info.
                              Out3$ = ""
                              VarX$ = f$ + ":\" + Chr$(0)
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 ' get volume label.
                                 Out3$ = RTrim$(Vname$)
                                 v = InStr(Out3$, Chr$(0))
                                 If v Then
                                    Out3$ = Left$(Out3$, v - 1)
                                    Call InstrSUB1(Flag, g$, Out3$, 0)
                                    If Flag Then
                                       Print f$; ":";
                                       Print Out3$
                                    End If
                                 End If
                              End If
                           End If
                        Next
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "V"
                     Call ListDrives("") ' list all drives
                     Call MorePrompt("-more-", " " + Chr$(13), Output.Char$)
                  Case "D"
                     Print "Enter drive letter? ";
                     f$ = LineInput$(CsrLin, Pos(0), 40): Print
                     If f$ <> "" Then
                        f$ = UCase$(f$)
                        If f$ >= "A" And f$ <= "Z" Then
                           v = GetDriveExists(f$)
                           If v Then
                              ' get drive info.
                              Out3$ = ""
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              VarX$ = f$ + ":\" + Chr$(0)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 ' get serial number.
                                 Out3$ = Left$(Hex$(serial~&), 4) + "-" + Right$(Hex$(serial~&), 4)
                                 Print f$; ":"; Out3$
                              Else
                                 Print "Media not inserted."
                              End If
                           Else
                              Print "Drive not found."
                           End If
                        Else
                           Print "Invalid drive eltter."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "G"
                     Print "Enter drive letter? ";
                     f$ = LineInput$(CsrLin, Pos(0), 40): Print
                     If f$ <> "" Then
                        f$ = UCase$(f$)
                        If f$ >= "A" And f$ <= "Z" Then
                           v = GetDriveExists(f$)
                           If v Then
                              ' get drive info.
                              Out3$ = ""
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              VarX$ = f$ + ":\" + Chr$(0)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 ' get system type.
                                 Out3$ = RTrim$(Fname$)
                                 Print f$; ":"; Out3$
                              Else
                                 Print "Media not inserted."
                              End If
                           Else
                              Print "Drive not found."
                           End If
                        Else
                           Print "Invalid drive eltter."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "R"
                     Print "Enter drive letter? ";
                     f$ = LineInput$(CsrLin, Pos(0), 40): Print
                     If f$ <> "" Then
                        f$ = UCase$(f$)
                        If f$ >= "A" And f$ <= "Z" Then
                           v = GetDriveExists(f$)
                           If v Then
                              ' get drive info.
                              Out3$ = ""
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              VarX$ = f$ + ":\" + Chr$(0)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 ' get drive space.
                                 r = GetDiskFreeSpaceExA(VarX$, free~&&, total~&&, free2~&&)
                                 If r Then
                                    Print "Total: "; FormatString$(CDbl(total~&&))
                                    Print "Free: "; FormatString$(CDbl(free~&&))
                                    Used# = total~&& - free~&&
                                    Print "Used: "; FormatString$(Used#)
                                 Else
                                    Print "Disk space unavailable."
                                 End If
                              Else
                                 Print "Media not inserted."
                              End If
                           Else
                              Print "Drive not found."
                           End If
                        Else
                           Print "Invalid drive eltter."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "L"
                     Print "Enter drive letter? ";
                     f$ = LineInput$(CsrLin, Pos(0), 40): Print
                     If f$ <> "" Then
                        f$ = UCase$(f$)
                        If f$ >= "A" And f$ <= "Z" Then
                           v = GetDriveExists(f$)
                           If v Then
                              Print f$; ":";
                              ' get drive info.
                              Out3$ = ""
                              VarX$ = f$ + ":\" + Chr$(0)
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 ' get volume label.
                                 Out3$ = RTrim$(Vname$)
                                 v = InStr(Out3$, Chr$(0))
                                 If v Then Out3$ = Left$(Out3$, v - 1)
                              End If
                              If RTrim$(Out3$) = "" Then
                                 Print DriveType
                              Else
                                 Print Out3$
                              End If
                           Else
                              Print "Drive not found."
                           End If
                        Else
                           Print "Invalid drive eltter."
                        End If
                        Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                     End If
                  Case "C"
                     ' only if run as admin
                     If IsUserAnAdmin = 0 Then
                        Print "Only Admin can access drive."
                     Else
                        Print "Enter drive letter? ";
                        f$ = LineInput$(CsrLin, Pos(0), 40): Print
                        If f$ <> "" Then
                           f$ = UCase$(f$)
                           If f$ >= "A" And f$ <= "Z" Then
                              v = GetDriveExists(f$)
                              If v Then
                                 ' get drive info.
                                 VarX$ = f$ + ":\" + Chr$(0)
                                 Vname$ = Space$(MAX_PATH)
                                 Fname$ = Space$(MAX_PATH)
                                 r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                                 If r Then
                                    Print "Enter drive volume? ";
                                    g$ = LineInput$(CsrLin, Pos(0), 40): Print
                                    OK = -1
                                    If g$ = "" Then
                                       v$ = "Are you sure you want to remove volume label(y/n)? "
                                       Call MorePrompt(v$, "yn", Outpt$)
                                       If Outpt$ = "n" Then
                                          OK = 0
                                       End If
                                    End If
                                    If OK Then
                                       ' change volume label
                                       f$ = f$ + ":\" + Chr$(0)
                                       g$ = g$ + Chr$(0)
                                       x = SetVolumeLabelA%(f$, g$)
                                       ' check volume flag
                                       If x = 0 Then
                                          Print "Error 0x" + Hex$(GetLastError) + " naming volume."
                                          Print DisplayWinError(x)
                                       Else
                                          Print "Volume changed."
                                       End If
                                    Else
                                       Print "Volume unchanged."
                                    End If
                                 Else
                                    Print "Media not inserted."
                                 End If
                              Else
                                 Print "Drive not found."
                              End If
                           Else
                              Print "Invalid drive letter."
                           End If
                           Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                        End If
                     End If
                  Case "Z"
                     ' only if run as admin
                     If IsUserAnAdmin = 0 Then
                        Print "Only Admin can access drive."
                     Else
                        v$ = "Are you sure you want to remove all volume labels(y/n)? "
                        Call MorePrompt(v$, "yn", Outpt$)
                        If Outpt$ = "y" Then
                           f = 0
                           For Z = 1 To 26
                              f$ = UCase$(Chr$(Z + 64))
                              v = GetDriveExists(f$)
                              If v Then
                                 ' get drive info.
                                 VarX$ = f$ + ":\" + Chr$(0)
                                 Vname$ = Space$(MAX_PATH)
                                 Fname$ = Space$(MAX_PATH)
                                 r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                                 If r Then
                                    ' change volume label
                                    f$ = f$ + ":\" + Chr$(0)
                                    g$ = "" + Chr$(0)
                                    x = SetVolumeLabelA%(f$, g$)
                                    If x Then
                                       f = f + 1
                                    End If
                                 End If
                              End If
                           Next
                           If f Then
                              Print "Volume labels zapped:"; f
                           Else
                              Print "No volume labels zapped."
                           End If
                           Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                        End If
                     End If
                  Case "Y"
                     ' only if run as admin
                     If IsUserAnAdmin = 0 Then
                        Print "Only Admin can access drive."
                     Else
                        v$ = "Are you sure you want to rename all volume labels(y/n)? "
                        Call MorePrompt(v$, "yn", Outpt$)
                        If Outpt$ = "y" Then
                           v$ = "Rename (D)os/(A)scii? "
                           Call MorePrompt(v$, "da", Outpt$)
                           d = 0
                           If Outpt$ = "a" Then d = -1
                           f = 0
                           For Z = 1 To 26
                              f$ = UCase$(Chr$(Z + 64))
                              v = GetDriveExists(f$)
                              If v Then
                                 ' get drive info.
                                 VarX$ = f$ + ":\" + Chr$(0)
                                 Vname$ = Space$(MAX_PATH)
                                 Fname$ = Space$(MAX_PATH)
                                 r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                                 If r Then
                                    ' change volume label
                                    f$ = f$ + ":\" + Chr$(0)
                                    If d = 0 Then
                                       g$ = GetLabel$ + Chr$(0)
                                    Else
                                       g$ = GetASCIIZLabel$ + Chr$(0)
                                    End If
                                    x = SetVolumeLabelA%(f$, g$)
                                    If x Then
                                       f = f + 1
                                    End If
                                 End If
                              End If
                           Next
                           If f Then
                              Print "Volume labels renamed:"; f
                           Else
                              Print "No volume labels renamed."
                           End If
                           Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                        End If
                     End If
               End Select
            Loop
      End Select
   Loop
End Sub

' type of soundfile extension.
Function VerifyPlay (Inpt$)
   VerifyPlay = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      For V = 1 To MaxSoundFileExtensions
         If Var$ = SoundFileExtensions(V) Then
            VerifyPlay = -1
            Exit Function
         End If
      Next
   End If
End Function

' type of soundfile extension.
Function VerifyPlay2 (Inpt$)
   VerifyPlay2 = 0
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      For V = 1 To MaxSoundFileExtensions
         If Var$ = SoundFileExtensions(V) Then
            VerifyPlay2 = -1
            Exit Function
         End If
      Next
   End If
End Function

' functions of types of file extensions
Function VerifyFile (Inpt$)
   VerifyFile = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "BAT", "SH", "APK", "COM", "EXE", "SYS", "INI", "LOG"
            VerifyFile = -1
      End Select
   End If
End Function

Function VerifyFile2 (Inpt$)
   VerifyFile2 = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "OBJ", "LIB", "DLL", "QLB"
            VerifyFile2 = -1
      End Select
   End If
End Function

Function VerifyFile3 (Inpt$)
   VerifyFile3 = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "C", "H", "BI", "ASM", "INC", "BAS", "SIC"
            VerifyFile3 = -1
         Case "PY", "JAVA", "CPP", "CS", "RB"
            VerifyFile3 = -1
      End Select
   End If
End Function

Function VerifyFile4 (Inpt$)
   VerifyFile4 = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "DOC", "PDF", "TXT", "LST", "RTF", "ODT", "PPT", "PPTX", "XLS", "XLSX", "CSV"
            VerifyFile4 = -1
      End Select
   End If
End Function

Function VerifyFile5 (Inpt$)
   VerifyFile5 = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "ZIP", "RAR", "TAR", "GZ", "7Z"
            VerifyFile5 = -1
      End Select
   End If
End Function

Function VerifyFile6 (Inpt$)
   VerifyFile6 = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "MP4", "AVI", "MKV", "MOV", "WMV", "FLV"
            VerifyFile6 = -1
      End Select
   End If
End Function

Function VerifyFile7 (Inpt$)
   VerifyFile7 = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "JPG", "JPEG", "PNG", "GIF", "BMP", "TIF", "TIFF", "SVG"
            VerifyFile7 = -1
      End Select
   End If
End Function

Function VerifyFile8 (Inpt$)
   VerifyFile8 = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "HTML", "HTM", "CSS", "JS", "PHP", "XML"
            VerifyFile8 = -1
      End Select
   End If
End Function

Function VerifyFile9 (Inpt$)
   VerifyFile9 = 0
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "SQL", "DB", "MDB", "ACCDB"
            VerifyFile9 = -1
      End Select
   End If
End Function

' compare 2 directories.
Sub VerifyFiles (Var1$, Var2$, VarX)
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   Dim Verify1(1) As String
   Dim Verify2(1) As String
   Dim VerifyCount1 As Single
   Dim VerifyCount2 As Single
   VerifyCount1 = 0!
   VerifyCount2 = 0!

   Dim SizeArray1(1) As Double
   Dim SizeArray2(1) As Double

   ' make search path
   Var3$ = Var1$
   If Right$(Var3$, 1) <> "\" Then
      Var3$ = Var3$ + "\"
   End If
   TempPath1$ = Var3$
   Var3$ = Var3$ + "*.*"

   Var4$ = Var2$
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   TempPath2$ = Var4$
   Var4$ = Var4$ + "*.*"
   If VarX Then
      Color White, Black
      Print "Wait.."
   End If

   ' store first path files
   ASCIIZ = Var3$ + Chr$(0)
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      Do
         Attribute = finddata.dwFileAttributes
         ' check for directory
         If (Attribute And &H10) <> &H10 Then
            ' store directory name
            Directory$ = finddata.cFileName
            Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)
            ' check directory name
            If Directory$ <> "." And Directory$ <> ".." Then
               VerifyCount1 = VerifyCount1 + 1!
               ReDim _Preserve Verify1(VerifyCount1) As String
               Verify1(VerifyCount1) = Directory$

               ReDim _Preserve SizeArray1(VerifyCount1) As Double
               SizeArray1(VerifyCount1) = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If

   ' store second path files
   ASCIIZ = Var4$ + Chr$(0)
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      Do
         Attribute = finddata.dwFileAttributes
         ' check for directory
         If (Attribute And &H10) <> &H10 Then
            ' store directory name
            Directory$ = finddata.cFileName
            Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)
            ' check directory name
            If Directory$ <> "." And Directory$ <> ".." Then
               VerifyCount2 = VerifyCount2 + 1!
               ReDim _Preserve Verify2(VerifyCount2) As String
               Verify2(VerifyCount2) = Directory$

               ReDim _Preserve SizeArray2(VerifyCount2) As Double
               SizeArray2(VerifyCount2) = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If

   ' check files found
   If VerifyCount1 = 0! Or VerifyCount2 = 0! Then
      If LCase$(StderrFile$) = "scrn:" Then
         Color White
         Print #StdoutHandle, "No matching files found."
      End If
      Exit Sub
   End If

   ' compare both arrays
   Continuous = 0
   LineCount = 2
   If Status Then
      LineBreak = 21
   Else
      LineBreak = 22
   End If
   Found = 0
   If LCase$(StderrFile$) = "scrn:" Then
      If VarX = 0 Then
         Color White, Black
         Print "Filename1", "Filename2", "   Filesize"
         Print "---------", "---------", "   --------"
      End If
   End If
   MatchingBytes# = 0#
   For Var1! = 1! To VerifyCount1
      For Var2! = 1! To VerifyCount2
         If Verify1(Var1!) = Verify2(Var2!) Then
            If SizeArray1(Var1!) = SizeArray2(Var2!) Then
               VarZ = FileCompare(Var1$, Var2$, Verify1(Var1!), Verify2(Var2!))
               If VarZ = -2 Then Exit Sub ' escape
               If VarZ = -1 Then ' file found
                  MatchingBytes# = MatchingBytes# + SizeArray1(Var1!)
                  Found = Found + 1
                  Color Yellow, Black
                  File1$ = AmbiguateFile$(TempPath1$ + Verify1(Var1!))
                  File2$ = AmbiguateFile$(TempPath2$ + Verify2(Var2!))
                  Call Suffix(SizeArray1(Var1!), S$) ' 1,024.0 KB
                  z$ = Space$(11 - Len(S$)) + S$
                  If VarX = 0 Then
                     Print UCase$(File1$), UCase$(File2$), z$
                  End If
                  LineCount = LineCount + 1
                  If LineCount >= LineBreak Then
                     LineCount = 2
                     If Continuous = 0 Then
                        If VarX = 0 Then
                           If LCase$(StderrFile$) = "scrn:" Then
                              Color White, Black
                              Call MorePrompt("-more(y/n/c)-", "ync " + Chr$(13) + Chr$(27), Outpt$)
                              If Outpt$ = Chr$(27) Then Exit Sub
                              If Outpt$ = "c" Then Continuous = -1
                              If Outpt$ = "n" Then
                                 Exit Sub
                              End If
                           End If
                           If Continuous = 0 Then
                              If LCase$(StderrFile$) = "scrn:" Then
                                 Color White, Black
                                 Print "Filename1", "Filename2", "   Filesize"
                                 Print "---------", "---------", "   --------"
                              End If
                           End If
                        End If
                     End If
                  End If
               End If
            End If
         End If
      Next
   Next
   If LCase$(StderrFile$) = "scrn:" Then
      If Found = 0 Then
         Color Yellow
         Print "No matching files found."
      Else
         Color Yellow
         Print "Matching files:"; Found; "bytes: "; FormatString$(MatchingBytes#)
      End If
      If LineCount Then
         If VarX = 0 Then
            Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
         End If
      End If
   End If
End Sub

' compare 2 files.
Sub VerifyFiles2 (Var1$, Var2$, VarX)
   Dim Byte1 As String * 1
   Dim Byte2 As String * 1
   X = FreeFile
   Open Var1$ For Binary Shared As #X Len = xbuflen
   Y = FreeFile
   Open Var2$ For Binary Shared As #Y Len = xbuflen
   If LOF(X) <> LOF(Y) Then
      Close X, Y
      If LCase$(StderrFile$) = "scrn:" Then
         Print "Files not same size."
         Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
      End If
      Exit Sub
   End If
   If LOF(X) = 0 And LOF(Y) = 0 Then
      Close X, Y
      If LCase$(StderrFile$) = "scrn:" Then
         Print "Files both zero."
         Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
      End If
      Exit Sub
   End If
   Count# = 0#
   Percent = 0
   Last.Percent = 0
   File.Size = LOF(X)
   If LCase$(StderrFile$) = "scrn:" Then
      Print "Verifying files";
   End If
   VarX2 = CsrLin
   Block# = 0#
   Do Until EOF(X)
      GoSub Display.Percent
      Get #X, , xbuffer1
      Get #Y, , xbuffer2
      Block# = Block# + 1#
      If xbuffer1 <> xbuffer2 Then
         Close #X, #Y
         Print #StdoutHandle, ""
         If VarX Then
            GoTo DisplayX
         End If
         Print #StdoutHandle, "Files do not match."
         If LCase$(StderrFile$) = "scrn:" Then
            Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
         End If
         Exit Sub
      End If
      If INKEYz$ = Chr$(27) Then
         Close #X, #Y
         Print #StdoutHandle, ""
         Print #StdoutHandle, "Files matching interrupted."
         If LCase$(StderrFile$) = "scrn:" Then
            Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
         End If
         Exit Sub
      End If
   Loop
   Print #StdoutHandle, ""
   Close #X, #Y
   Print #StdoutHandle, "Files match: " + FormatString$(File.Size) + " bytes checked."
   If LCase$(StderrFile$) = "scrn:" Then
      Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
   End If
   Exit Sub

   DisplayX:
   Close #X, #Y
   X = FreeFile
   Open Var1$ For Binary Shared As #X Len = xbuflen
   Y = FreeFile
   Open Var2$ For Binary Shared As #Y Len = xbuflen

   Print #StdoutHandle, "Offset         Byte Hex    ASCII"
   Print #StdoutHandle, "-------------  ---- -----  -------"

   LineCount = 0
   If Status Then
      LineBreak = 21
   Else
      LineBreak = 22
   End If
   Z# = 0#
   For V# = 1# To Block# - 1#
      Get #X, , xbuffer1
      Get #Y, , xbuffer2
      Z# = Z# + xbuflen
   Next
   Do Until EOF(X)
      Get #X, , xbuffer1
      Get #Y, , xbuffer2
      For C# = 1# To xbuflen
         Z# = Z# + 1#
         Byte1 = Mid$(xbuffer1, C#, 1#)
         Byte2 = Mid$(xbuffer2, C#, 1#)
         If Byte1 <> Byte2 Then
            V1$ = LTrim$(Str$(Z#)): V1$ = V1$ + Space$(15 - Len(V1$))
            V1$ = V1$ + Byte1 + "\" + Byte2 + "  "
            V2$ = Right$("00" + Hex$(Asc(Byte1)), 2) + "\" + Right$("00" + Hex$(Asc(Byte2)), 2)
            V3$ = Right$("000" + LTrim$(Str$(Asc(Byte1))), 3) + "\" + Right$("000" + LTrim$(Str$(Asc(Byte2))), 3)
            VX$ = V1$ + V2$ + "  " + V3$
            Print #StdoutHandle, VX$
            LineCount = LineCount + 1
            If LineCount >= LineBreak Then
               LineCount = 0
               If LCase$(StderrFile$) = "scrn:" Then
                  Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
                  If Outpt$ = "n" Then
                     Exit Do
                  End If
               End If
            End If
         End If
      Next
   Loop
   Close X, Y
   If LineCount Then
      If LCase$(StderrFile$) = "scrn:" Then
         Call MorePrompt("-more-", " " + Chr$(13), Outpt$)
      End If
   End If
   Exit Sub

   ' display percentage scanned in title
   Display.Percent:
   If File.Size > 0 Then
      Count# = Count# + xbuflen
      If Count# > File.Size Then
         Count# = File.Size
      End If
      Percent = (Count# / File.Size) * 100!
      Percent = Int(Percent)
      If Percent <> Last.Percent Then
         Last.Percent = Percent
         P$ = Right$(Str$(Percent + 1000%), 3) + "%"
         If LCase$(StderrFile$) = "scrn:" Then
            Locate VarX2, 1, 1
            Print "Verifying files "; P$;
         End If
         V$ = Program + " - COMPARE - " + Var1$ + " to " + Var2$ + " - " + P$
         _Title V$
      End If
   End If
   Return
End Sub

Function PercentDisplay$ (Var&, File.Size&)
   If File.Size& > 0 Then
      Percent = (Var& / File.Size&) * 100!
      Percent = Int(Percent)
      PercentDisplay = Right$(Str$(Percent + 1000%), 3) + "%"
   End If
End Function

Function FileCompare (Path1$, Path2$, Filename1$, Filename2$)
   FileComp1$ = Path1$
   If Right$(FileComp1$, 1) <> "\" Then
      FileComp1$ = FileComp1$ + "\"
   End If
   FileComp1$ = FileComp1$ + Filename1$

   FileComp2$ = Path2$
   If Right$(FileComp2$, 1) <> "\" Then
      FileComp2$ = FileComp2$ + "\"
   End If
   FileComp2$ = FileComp2$ + Filename2$

   If _FileExists(FileComp1$) = 0 Then
      FileCompare = 0
      Exit Function
   End If

   If _FileExists(FileComp2$) = 0 Then
      FileCompare = 0
      Exit Function
   End If

   Count# = 0#
   Percent = 0
   Last.Percent = 0

   X = FreeFile
   Open FileComp1$ For Binary Shared As #X Len = xbuflen
   Y = FreeFile
   Open FileComp2$ For Binary Shared As #Y Len = xbuflen
   If LOF(X) = 0 And LOF(Y) = 0 Then
      Close #X, #Y
      FileCompare = -1
      Exit Function
   End If
   File.Size = LOF(X)
   Do Until EOF(X)
      GoSub Display.Percent
      Get #X, , xbuffer1
      Get #Y, , xbuffer2
      If xbuffer1 <> xbuffer2 Then
         Close #X, #Y
         FileCompare = 0
         Exit Function
      End If
      If INKEYz$ = Chr$(27) Then
         Close #X, #Y
         FileCompare = -2
         Exit Function
      End If
   Loop
   Close #X, #Y
   FileCompare = -1
   Exit Function

   ' display percentage scanned in title
   Display.Percent:
   If File.Size > 0 Then
      Count# = Count# + xbuflen
      If Count# > File.Size Then
         Count# = File.Size
      End If
      Percent = (Count# / File.Size) * 100!
      Percent = Int(Percent)
      If Percent <> Last.Percent Then
         Last.Percent = Percent
         P$ = Right$(Str$(Percent + 1000%), 3) + "%"
         V$ = Program + " - COMPARE - " + FileComp1$ + " to " + FileComp2$ + " - " + P$
         _Title V$
      End If
   End If
   Return
End Function

' return -1 if drive exists
Function GetDriveExists (V$)
   If UCase$(V$) = "A" Or UCase$(V$) = "B" Then
      DriveType = "[FLOPPY]"
      GetDriveExists = -1
      Exit Function
   End If
   VarX$ = V$ + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = ""
   Select Case VarX
      Case 0
         DriveType = "[UNKNOWN]"
      Case 1
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      GetDriveExists = -1
   Else
      GetDriveExists = 0
   End If
End Function

' display windows error message
Function DisplayWinError$ (x)
   ' define error message value
   v& = GetLastError
   ' call windows error message routine
   x& = FormatMessageA&(&H1200, "", v&, 0, ErrorBuffer$, 260, "")
   If x& Then
      DisplayWinError$ = Left$(ErrorBuffer$, x& - 2)
   Else
      DisplayWinError$ = "Unknown error 0x" + Hex$(v&) + "."
   End If
   x = -1
End Function

Sub HexCalc

   ' Note: In HexCalc the following keys are active:
   '   Ctrl-A - move up, Ctrl-B - move down
   '   Ctrl-C - move left, Ctrl-D - move right
   '   Ctrl-E, Ctrl-F - cycle foreground
   '   Ctrl-J, Ctrl-K - cycle background

   ' coordinate of hexcalc box
   Xcoor = 4
   Ycoor = 6
   If HexCalcXcoor Then Xcoor = HexCalcXcoor
   If HexCalcYcoor Then Ycoor = HexCalcYcoor

   ' adjust xcoor
   If Status Then
      Z = 23
      If Xcoor + 3 > Z Then
         Xcoor = Xcoor - 1
      End If
   End If

   ' coordinate of hexcalc help box
   Xcoor2 = 4
   Ycoor2 = 6
   If HexCalcHelpXcoor Then Xcoor2 = HexCalcHelpXcoor
   If HexCalcHelpYcoor Then Ycoor2 = HexCalcHelpYcoor

   ' adjust xcoor
   If Status Then
      Z = 23
      If Xcoor2 + 4 > Z Then
         Xcoor2 = Xcoor2 - 1
      End If
   End If

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen

   ' reset insert mode.
   Ins = -1

   GoSub MakeBox ' create edit box.

   CalcBox = 1 ' reset to left box.

   Box$ = "0" ' current box
   Box1$ = "0" ' left box string
   Box2$ = "0" ' right box string

   GoSub SelectBox2 ' display box 2.
   GoSub SelectBox1 ' display box 1.

   Do ' calculator loop
      Var$ = INKEYz$ ' get keystroke
      If Len(Var$) Then ' check keystroke
         Select Case Len(Var$)
            Case 1 ' single ascii key
               Select Case Asc(Var$)
                  Case 1 ' control-a (up)
                     If Xcoor > 2 Then
                        Xcoor = Xcoor - 1
                        GoSub ResetBox
                     End If
                  Case 2 ' control-b (down)
                     If Status Then
                        Z = 21
                     Else
                        Z = 22
                     End If
                     If Xcoor < Z Then
                        Xcoor = Xcoor + 1
                        GoSub ResetBox
                     End If
                  Case 3 ' control-c (left)
                     _Delay 1.2 ' delay for break
                     If Control.Break Then
                        Control.Break = 0
                     Else
                        If Ycoor > 1 Then
                           Ycoor = Ycoor - 1
                           GoSub ResetBox
                        End If
                     End If
                  Case 4 ' control-d (right)
                     If Ycoor < 50 Then
                        Ycoor = Ycoor + 1
                        GoSub ResetBox
                     End If
                  Case 5 ' control-e
                     If HexCalcForeground1 = 15 Then
                        HexCalcForeground1 = 0
                     Else
                        HexCalcForeground1 = HexCalcForeground1 + 1
                     End If
                     CalcBoxBorderColor = HexCalcForeground1
                     CalcBoxTitleColor = HexCalcForeground1
                     CalcBoxTextColor = HexCalcForeground1
                     GoSub ResetBox
                  Case 6 ' control-f
                     If HexCalcForeground2 = 15 Then
                        HexCalcForeground2 = 0
                     Else
                        HexCalcForeground2 = HexCalcForeground2 + 1
                     End If
                     GoSub ResetBox
                  Case 10 ' control-j
                     If HexCalcBackground1 = 7 Then
                        HexCalcBackground1 = 0
                     Else
                        HexCalcBackground1 = HexCalcBackground1 + 1
                     End If
                     GoSub ResetBox
                  Case 11 ' control-k
                     If HexCalcBackground2 = 7 Then
                        HexCalcBackground2 = 0
                     Else
                        HexCalcBackground2 = HexCalcBackground2 + 1
                     End If
                     GoSub ResetBox
                  Case 8 ' backspace
                     If Ycoor1 - Column3 > 0 Then
                        If Ins Then
                           Box$ = Left$(Box$, Ycoor1 - Column3 - 1) + Mid$(Box$, Ycoor1 - Column3 + 1)
                           Ycoor1 = Ycoor1 - 1
                           Locate Xcoor1, Ycoor1, 1
                           Var$ = Mid$(Box$, Ycoor1 - Column3 + 1) + " "
                           Color HexCalcForeground2, HexCalcBackground1
                           Print Var$;
                           Locate Xcoor1, Ycoor1, 1
                           GoSub PrintBoxes
                        Else ' move left
                           Ycoor1 = Ycoor1 - 1
                           Locate Xcoor1, Ycoor1, 1
                        End If
                     End If
                  Case 9 ' tab
                     If CalcBox = 1 Then
                        CalcBox = 2
                        GoSub SelectBox2
                        GoSub PrintBoxes
                     End If
                  Case 27 ' escape
                     Exit Do
                  Case 63 ' ?
                     GoSub HelpBox
                     GoSub ResetBox
                  Case Else ' keystroke
                     VarX = 0 ' valid char flag
                     TempX$ = UCase$(Var$)
                     Select Case TempX$ ' validate char
                        Case "0" To "9"
                           VarX = -1
                        Case "A" To "F"
                           If CalcBox = 1 Then
                              VarX = -1
                           End If
                     End Select
                     If VarX Then
                        If Ycoor1 - Column3 + 1 <= LineLength Then
                           ' insert digit
                           If Ins Then
                              Box$ = Left$(Box$, Ycoor1 - Column3) + TempX$ + Mid$(Box$, Ycoor1 - Column3 + 1)
                              Box$ = Left$(Box$, LineLength)
                              Locate Xcoor1, Ycoor1, 1
                              Var$ = Mid$(Box$, Ycoor1 - Column3 + 1)
                              Color HexCalcForeground2, HexCalcBackground1
                              Print Var$;
                              Ycoor1 = Ycoor1 + 1
                              Locate Xcoor1, Ycoor1, 1
                              GoSub PrintBoxes
                           Else ' overstrike char
                              If Ycoor1 - Column3 + 1 > Len(Box$) Then
                                 Box$ = Box$ + TempX$ ' append box
                              Else
                                 Mid$(Box$, Ycoor1 - Column3 + 1, 1) = TempX$ ' replace
                              End If
                              Locate Xcoor1, Ycoor1, 1
                              Color HexCalcForeground2, HexCalcBackground1
                              Print TempX$;
                              Ycoor1 = Ycoor1 + 1
                              Locate Xcoor1, Ycoor1, 1
                              GoSub PrintBoxes
                           End If
                        End If
                     End If
               End Select
            Case 2 ' extended key
               Select Case Asc(Right$(Var$, 1))
                  Case 76, 143 ' keypad-5 center
                     Xcoor = 4
                     Ycoor = 6
                     GoSub ResetBox
                  Case 72, 141 ' up/ctrl-up
                     If Xcoor > 2 Then
                        Xcoor = Xcoor - 1
                        GoSub ResetBox
                     End If
                  Case 80, 145 ' down/ctrl-down
                     If Status Then
                        Z = 21
                     Else
                        Z = 22
                     End If
                     If Xcoor < Z Then
                        Xcoor = Xcoor + 1
                        GoSub ResetBox
                     End If
                  Case 115 ' ctrl-left
                     If Ycoor > 1 Then
                        Ycoor = Ycoor - 1
                        GoSub ResetBox
                     End If
                  Case 116 ' ctrl-right
                     If Ycoor < 50 Then
                        Ycoor = Ycoor + 1
                        GoSub ResetBox
                     End If
                  Case 15 ' shift-tab
                     If CalcBox = 2 Then
                        CalcBox = 1
                        GoSub SelectBox1
                        GoSub PrintBoxes
                     End If
                  Case 71 ' home
                     Ycoor1 = Column3
                  Case 79 ' end
                     Ycoor1 = Len(Box$) + Column3
                  Case 77 ' right
                     If Ycoor1 - Column3 + 1 <= Len(Box$) Then
                        Ycoor1 = Ycoor1 + 1
                     End If
                  Case 75 ' left
                     If Ycoor1 - Column3 > 0 Then
                        Ycoor1 = Ycoor1 - 1
                     End If
                  Case 82 ' insert
                     Ins = Not Ins
                     Color CalcBoxTitleColor, HexCalcBackground2
                     If Ins Then
                        Locate Xcoor, Ycoor + 24, 1
                        Print "<ins>";
                     Else
                        Locate Xcoor, Ycoor + 24, 1
                        Print String$(5, Hline);
                     End If
                     Color HexCalcForeground2, HexCalcBackground1
                  Case 83 ' delete
                     If Ycoor1 - Column3 + 1 <= Len(Box$) Then
                        Box$ = Left$(Box$, Ycoor1 - Column3) + Mid$(Box$, Ycoor1 - Column3 + 2)
                        Locate Xcoor1, Ycoor1, 1
                        Var$ = Mid$(Box$, Ycoor1 - Column3 + 1) + " "
                        Color HexCalcForeground2, HexCalcBackground1
                        Print Var$;
                        Locate Xcoor1, Ycoor1, 1
                        GoSub PrintBoxes
                     End If
                  Case 119 ' control-home
                     Ycoor1 = Column3
                  Case 117 ' control-end
                     Ycoor1 = Len(Box$) + Column3
               End Select
               Locate Xcoor1, Ycoor1, 1
         End Select
      End If
      If Status Then
         Z = 21
      Else
         Z = 22
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor Then
            If MouseY >= Ycoor And MouseY <= Ycoor + 30 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z Then
                           Xcoor = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 50 Then
                           Ycoor = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        GoSub ResetBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor > 2 Then
               Xcoor = Xcoor - 1
               GoSub ResetBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            If Status Then
               Z = 21
            Else
               Z = 22
            End If
            If Xcoor < Z Then
               Xcoor = Xcoor + 1
               GoSub ResetBox
            End If
            _KeyClear
         End If
      End If
   Loop

   ' store coordinates
   HexCalcXcoor = Xcoor
   HexCalcYcoor = Ycoor
   HexCalcHelpXcoor = Xcoor2
   HexCalcHelpYcoor = Ycoor2

   Call RestoreScreen ' restore screen area.
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   Exit Sub

   ' display edit box
   ResetBox:

   ' restore screen area.
   Call RestoreScreen

   ' create edit box.
   GoSub MakeBox
   Xcoor1 = Xcoor + 1
   Ymove = Ycoor1 - Column3

   ' display box area 1
   Color HexCalcForeground2, HexCalcBackground1
   Locate Xcoor1, Ycoor + 3, 1
   Print Space$(8);
   Locate Xcoor1, Ycoor + 3, 1
   If CalcBox = 1 Then
      Print Box$;
   Else
      Print Box1$;
   End If

   ' display box area 2
   Color HexCalcForeground2, HexCalcBackground1
   Locate Xcoor1, Ycoor + 15, 1
   Print Space$(10);
   Locate Xcoor1, Ycoor + 15, 1
   If CalcBox = 2 Then
      Print Box$;
   Else
      Print Box2$;
   End If

   ' reset editing area
   If CalcBox = 1 Then
      Ycoor1 = Ycoor + 3
      Column3 = Ycoor1
      Ycoor1 = Ycoor1 + Ymove
      LineLength = 8
   Else
      Ycoor1 = Ycoor + 15
      Column3 = Ycoor1
      Ycoor1 = Ycoor1 + Ymove
      LineLength = 10
   End If
   Locate Xcoor1, Ycoor1, 1
   Return

   ' create edit box.
   MakeBox:
   ' Y-coordinate of editing boxes.
   Box1 = Ycoor + 3
   Box2 = Ycoor + 15

   ' display editing box.
   Color , HexCalcBackground2

   ' display line 1
   Locate Xcoor, Ycoor, 1
   Color CalcBoxBorderColor
   Print " " + Chr$(ULcorner) + Chr$(Hline);
   Color CalcBoxTitleColor
   Print "<esc>=Quit,?=Help";
   Color CalcBoxBorderColor
   Print String$(4, Hline);
   Color CalcBoxTitleColor
   Print "<ins>";
   Color CalcBoxBorderColor
   Print Chr$(URcorner) + " ";

   ' display line 2
   Locate Xcoor + 1, Ycoor, 1
   Color CalcBoxBorderColor
   Print " " + Chr$(Vline);
   Color CalcBoxTextColor
   Print Space$(9);
   Print "Hex";
   Print Space$(11);
   Print "Dec ";
   Color CalcBoxBorderColor
   Print Chr$(Vline) + " ";

   ' display line 3
   Locate Xcoor + 2, Ycoor, 1
   Color CalcBoxBorderColor
   Print " " + Chr$(LLcorner) + Chr$(Hline);
   Color CalcBoxTitleColor
   Print "<tab>/<shift-tab>=switch";
   Color CalcBoxBorderColor
   Print Chr$(Hline) + Chr$(Hline) + Chr$(LRcorner) + " ";
   Return

   ' move to box 1 (left box).
   SelectBox1:
   Box2$ = Box$ ' store right box.
   Box$ = Box1$ ' reset to left box.

   ' reset editing parameters.
   Xcoor1 = Xcoor + 1
   Ycoor1 = Ycoor + 3
   Column3 = Ycoor1
   LineLength = 8

   ' display left box.
   Color HexCalcForeground2, HexCalcBackground1
   Locate Xcoor1, Ycoor1, 1
   Print Space$(8);
   Locate Xcoor1, Ycoor1, 1
   Print Box$;
   Ycoor1 = Ycoor1 + Len(Box$)
   Locate Xcoor1, Ycoor1, 1
   Return

   ' move to box 2 (right box).
   SelectBox2:
   Box1$ = Box$ ' store left box.
   Box$ = Box2$ ' reset to right box.

   ' reset editing parameters.
   Xcoor1 = Xcoor + 1
   Ycoor1 = Ycoor + 15
   Column3 = Ycoor1
   LineLength = 10

   ' display right box.
   Color HexCalcForeground2, HexCalcBackground1
   Locate Xcoor1, Ycoor1, 1
   Print Space$(10);
   Locate Xcoor1, Ycoor1, 1
   Print Box$;
   Ycoor1 = Ycoor1 + Len(Box$)
   Locate Xcoor1, Ycoor1, 1
   Return

   ' calculates value of current box,
   '  displays result in calculated form in opposite box.
   PrintBoxes:
   If CalcBox = 1 Then ' is in hex box.
      ' strip leading zeroes for signed bit conversion.
      TempBox$ = Box$
      Do
         If Left$(TempBox$, 1) = "0" Then
            TempBox$ = Mid$(TempBox$, 2)
         Else
            Exit Do
         End If
      Loop
      Value# = Val("&H" + TempBox$) ' retreive decimal value.
      If Value# < 0# Then ' check twos-complement from signed value.
         If Len(TempBox$) = 8 Then ' 8000 0000 to FFFF FFFF
            Value# = Value# + MLong
         Else
            If Len(TempBox$) = 4 Then ' 8000 to FFFF
               Value# = Value# + LMaxInt
            End If
         End If
      End If
      ' display decimal value.
      Box2$ = Mid$(Str$(Value#), 2)
      Color HexCalcForeground2, HexCalcBackground1
      Locate Xcoor1, Box2, 1
      Print Space$(10);
      Locate Xcoor1, Box2, 1
      Print Box2$;
   End If
   If CalcBox = 2 Then ' is in decimal box.
      Value# = Val(Box$) ' retreive hex value.
      If Value# >= MLong Then ' check overflow.
         Color White, Black
         Locate Xcoor1, Box1, 1
         Var$ = "overflow"
         Print Var$;
         Box1$ = "0"
      Else
         If Value# > SLong Then ' force to twos-complement.
            Value# = Value# - MLong ' 8000 0000 to FFFF FFFF
         End If
         ' display hex value.
         Box1$ = Hex$(Value#)
         Color HexCalcForeground2, HexCalcBackground1
         Locate Xcoor1, Box1, 1
         Print Space$(8);
         Locate Xcoor1, Box1, 1
         Print Box1$;
      End If
   End If
   Locate Xcoor1, Ycoor1, 1
   Return

   ' create help box.
   HelpBox:
   Do
      ' restore screen area.
      Call RestoreScreen

      ' make help box
      Color HexCalcHelpForeground1, HexCalcHelpBackground2 ' yellow, blue
      Locate Xcoor2, Ycoor2, 1
      Print Chr$(ULcorner) + String$(39, Hline) + Chr$(URcorner);

      Locate Xcoor2 + 1, Ycoor2, 1
      Print Chr$(Vline);

      Locate Xcoor2 + 1, Ycoor2 + 40, 1
      Print Chr$(Vline);

      Locate Xcoor2 + 2, Ycoor2, 1
      Print Chr$(Vline);

      Locate Xcoor2 + 2, Ycoor2 + 40, 1
      Print Chr$(Vline);

      Locate Xcoor2 + 3, Ycoor2, 1
      Print Chr$(Vline);
      Locate Xcoor2 + 3, Ycoor2 + 40, 1
      Print Chr$(Vline);

      Locate Xcoor2 + 4, Ycoor2, 1
      Print Chr$(Vline);
      Locate Xcoor2 + 4, Ycoor2 + 40, 1
      Print Chr$(Vline);

      Locate Xcoor2 + 5, Ycoor2, 1
      Print Chr$(LLcorner) + String$(39, Hline) + Chr$(LRcorner);

      ' make help box title
      Color HexCalcHelpForeground1, HexCalcHelpBackground2 ' yellow, blue
      Locate Xcoor2, Ycoor2 + 10, 1
      Print " Additional Keys ";

      ' make help box contents
      Color HexCalcHelpForeground2, HexCalcHelpBackground1 ' white, black
      Locate Xcoor2 + 1, Ycoor2 + 1, 1
      Print "Ctrl-A = Move Up, Ctrl-B = Move Down   ";
      Locate Xcoor2 + 2, Ycoor2 + 1, 1
      Print "Ctrl-C = Move Left, Ctrl-D = Move Right";

      Locate Xcoor2 + 3, Ycoor2 + 1, 1
      Print "Ctrl-E, Ctrl-F - cycle foreground      ";
      Locate Xcoor2 + 4, Ycoor2 + 1, 1
      Print "Ctrl-J, Ctrl-K - cycle background      ";

      ' make help box title
      Color HexCalcHelpForeground1, HexCalcHelpBackground2 ' yellow, blue
      Locate Xcoor2 + 5, Ycoor2 + 9, 1
      Print "Press <esc> to Exit:";

      ' help box loop
      Do
         X$ = INKEYz$
         If Len(X$) = 2 Then ' extended key
            Select Case Asc(Right$(X$, 1))
               Case 76, 143 ' center
                  Xcoor2 = 4
                  Ycoor2 = 6
                  Exit Do
               Case 75, 115, 155 ' left/ctrl-left/alt-left
                  If Ycoor2 > 1 Then
                     Ycoor2 = Ycoor2 - 1
                     Exit Do
                  End If
               Case 77, 116, 157 ' right/ctrl-right/alt-right
                  If Ycoor2 < 40 Then
                     Ycoor2 = Ycoor2 + 1
                     Exit Do
                  End If
               Case 72, 141, 152 ' up/ctrl-up/alt-up
                  If Xcoor2 > 2 Then
                     Xcoor2 = Xcoor2 - 1
                     Exit Do
                  End If
               Case 80, 145, 160 ' down/ctrl-dn/alt-dn
                  If Status Then
                     Z = 18
                  Else
                     Z = 19
                  End If
                  If Xcoor2 < Z Then
                     Xcoor2 = Xcoor2 + 1
                     Exit Do
                  End If
            End Select
         End If
         If Len(X$) = 1 Then
            Select Case Asc(X$)
               Case 1 ' control-a (up)
                  If Xcoor2 > 2 Then
                     Xcoor2 = Xcoor2 - 1
                     Exit Do
                  End If
               Case 2 ' control-b (down)
                  If Status Then
                     Z = 18
                  Else
                     Z = 19
                  End If
                  If Xcoor2 < Z Then
                     Xcoor2 = Xcoor2 + 1
                     Exit Do
                  End If
               Case 3 ' control-c (left)
                  _Delay 1.2 ' delay for break
                  If Control.Break Then
                     Control.Break = 0
                  Else
                     If Ycoor2 > 1 Then
                        Ycoor2 = Ycoor2 - 1
                        Exit Do
                     End If
                  End If
               Case 4 ' control-d (right)
                  If Ycoor2 < 40 Then
                     Ycoor2 = Ycoor2 + 1
                     Exit Do
                  End If
               Case 5 ' control-e
                  If HexCalcHelpForeground1 = 15 Then
                     HexCalcHelpForeground1 = 0
                  Else
                     HexCalcHelpForeground1 = HexCalcHelpForeground1 + 1
                  End If
                  Exit Do
               Case 6 ' control-f
                  If HexCalcHelpForeground2 = 15 Then
                     HexCalcHelpForeground2 = 0
                  Else
                     HexCalcHelpForeground2 = HexCalcHelpForeground2 + 1
                  End If
                  Exit Do
               Case 10 ' control-j
                  If HexCalcHelpBackground1 = 7 Then
                     HexCalcHelpBackground1 = 0
                  Else
                     HexCalcHelpBackground1 = HexCalcHelpBackground1 + 1
                  End If
                  Exit Do
               Case 11 ' control-k
                  If HexCalcHelpBackground2 = 7 Then
                     HexCalcHelpBackground2 = 0
                  Else
                     HexCalcHelpBackground2 = HexCalcHelpBackground2 + 1
                  End If
                  Exit Do
               Case 27 ' escape
                  Return
            End Select
         End If
         If Status Then
            Z = 18
         Else
            Z = 19
         End If
         MoveBox = 0
         X = MouseDriver
         If MouseButton1 Then
            ' hover over titlebar
            If MouseX = Xcoor2 Then
               If MouseY >= Ycoor2 And MouseY <= Ycoor2 + 40 Then
                  ' store mouse XY during click
                  MouseTempX = MouseX
                  MouseTempY = MouseY
                  Do
                     X = MouseDriver
                     If MouseX Or MouseY Then ' drag
                        ' difference in mouse X
                        If MouseX <> MouseTempX Then
                           If MouseX >= 2 And MouseX <= Z Then
                              Xcoor2 = MouseX
                              MouseTempX = MouseX
                              MoveBox = -1
                           End If
                        End If
                        ' difference in mouse Y
                        If MouseY <> MouseTempY Then
                           MoveY = Ycoor2 + (MouseY - MouseTempY)
                           If MoveY >= 1 And MoveY <= 40 Then
                              Ycoor2 = MoveY
                              MouseTempY = MouseY
                              MoveBox = -1
                           End If
                        End If
                        ' move box
                        If MoveBox Then
                           Exit Do
                        End If
                     End If
                  Loop Until MouseButton1 = 0
                  If MoveBox Then
                     MoveBox = 0
                     Exit Do
                  End If
               End If
            End If
         End If
         If MouseWheel Then
            If MouseWheel = -1 Then
               I$ = Chr$(0) + Chr$(72) ' up
               MousePressed = -1
               MouseWheel = 0
               X$ = ""
               If Xcoor2 > 2 Then
                  Xcoor2 = Xcoor2 - 1
                  Exit Do
               End If
               _KeyClear
            End If
            If MouseWheel = 1 Then
               I$ = Chr$(0) + Chr$(80) ' down
               MousePressed = -1
               MouseWheel = 0
               If Status Then
                  Z = 18
               Else
                  Z = 19
               End If
               If Xcoor2 < Z Then
                  Xcoor2 = Xcoor2 + 1
                  Exit Do
               End If
               _KeyClear
            End If
         End If
      Loop
   Loop
   Return
End Sub

' Displays ASCII character chart. v1.1a. PD 2006.
'  v1.1a modify unprintable char output for QB64.
Sub AsciiChart
   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   Color Plain, Black
   Cls
   Color White, Black
   Print "ASCII Chart for characters 1 to 127:"
   For Char = 1 To 127
      DisplayChar$ = Chr$(Char)
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("00" + Var$, 3) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$;
      Print " ";
      ' check full screen line
      If (Char Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   While INKEYz$ = "": Wend
   x = ClearKeyboard
   Color Plain, Black
   Print
   Cls
   Color White, Black
   Print "ASCII Chart for characters 128 to 255:"
   For Char = 128 To 255
      DisplayChar$ = Chr$(Char)
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("00" + Var$, 3) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$;
      Print " ";
      ' check full screen line
      If ((Char - 7) Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   While INKEYz$ = "": Wend
   x = ClearKeyboard
   Call RestoreScreen2 ' restore screen area.
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   Exit Sub
End Sub

' Displays HEX character chart. v1.1a. PD 2006.
'  v1.1a modify unprintable char output for QB64.
Sub HexChart
   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   Color Plain, Black
   Cls
   Color White, Black
   Print "HEX Chart for characters 1 to 127:"
   For Char = 1 To 127
      DisplayChar$ = Chr$(Char)
      Var$ = Hex$(Char)
      Var1$ = Right$("0" + Var$, 2) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$;
      Print " ";
      ' check full screen line
      If (Char Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   While INKEYz$ = "": Wend
   x = ClearKeyboard
   Color Plain, Black
   Print
   Cls
   Color White, Black
   Print "HEX Chart for characters 128 to 255:"
   For Char = 128 To 255
      DisplayChar$ = Chr$(Char)
      Var$ = Hex$(Char)
      Var1$ = Right$("0" + Var$, 2) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$; " ";
      ' check full screen line
      If ((Char - 7) Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   While INKEYz$ = "": Wend
   x = ClearKeyboard
   Call RestoreScreen2 ' restore screen area.
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   Exit Sub
End Sub

' routine accepts an operation and performs on two values, string or numeric
Sub Arith (Token.Parsed$, Temp#, Temp2#)
   If Last.Token Then
      Select Case Token.Parsed$
         Case "-"
            Temp# = Temp# - Temp2#
         Case "+"
            Temp# = Temp# + Temp2#
         Case "/"
            Temp# = Temp# / Temp2#
         Case "\"
            Temp# = Temp# \ Temp2#
         Case "*"
            Temp# = Temp# * Temp2#
         Case "^"
            Temp# = Temp# ^ Temp2#
         Case "<"
            Temp# = (Temp# < Temp2#)
         Case ">"
            Temp# = (Temp# > Temp2#)
         Case "<<"
            Temp# = Temp# * 2#
         Case ">>"
            Temp# = Temp# \ 2#
         Case "++"
            Temp# = Temp# + 1#
         Case "--"
            Temp# = Temp# - 1#
         Case "+++"
            Temp# = Temp# + 1#
         Case "---"
            Temp# = Temp# - 1#
         Case "++="
            Temp# = Temp# + Temp2#
         Case "--="
            Temp# = Temp# - Temp2#
         Case "**"
            Temp# = Temp# ^ 2#
         Case "//"
            If Temp# < 0# Then
               Error 112
            Else
               Temp# = Sqr(Temp#)
            End If
         Case "="
            Temp# = (Temp# = Temp2#)
         Case "<="
            Temp# = (Temp# <= Temp2#)
         Case ">="
            Temp# = (Temp# >= Temp2#)
         Case "<>"
            Temp# = (Temp# <> Temp2#)
         Case "|"
            Temp# = Temp# Or Temp2#
         Case "&"
            Temp# = Temp# And Temp2#
         Case "%"
            Temp# = Temp# Mod Temp2#
         Case "~"
            Temp# = Temp# Xor Temp2#
         Case "?"
            Temp# = Temp# Imp Temp2#
         Case ":"
            Temp# = Temp# Eqv Temp2#
         Case "#"
            Temp# = Not (Temp# Or Temp2#)
         Case "@"
            Temp# = Not (Temp# Imp Temp2#)
         Case "`"
            Temp# = Not (Temp# And Temp2#)
      End Select
      Exit Sub
   End If
   Select Case Token.Parsed$
      Case "-"
         If Right$(Out3, Len(Out4)) = Out4 Then
            Out3 = Left$(Out3, Len(Out3) - Len(Out4))
         End If
      Case "+"
         Out3 = Out3 + Out4
      Case "/", "\"
         If Len(Out3) > False And Len(Out4) > False Then
            Imbedded = InStr(Out3, Out4)
            While Imbedded
               Out3 = Left$(Out3, Imbedded - 1) + Mid$(Out3, Imbedded + Len(Out4))
               Imbedded = InStr(Out3, Out4)
            Wend
         End If
      Case "<"
         Last.Token = True
         Temp# = Out3 < Out4
      Case ">"
         Last.Token = True
         Temp# = Out3 > Out4
      Case "="
         Last.Token = True
         Temp# = Out3 = Out4
      Case "<="
         Last.Token = True
         Temp# = Out3 <= Out4
      Case ">="
         Last.Token = True
         Temp# = Out3 >= Out4
      Case "<>"
         Last.Token = True
         Temp# = Out3 <> Out4
   End Select
End Sub

Sub Assignment1 (S$, S%)
   If Left$(S$, 2) = "<<" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) * 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = ">>" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) \ 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "--" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) - 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "++" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) + 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "+++" Then
      Assign = True
      Strng = Mid$(S$, 4)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) + 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "---" Then
      Assign = True
      Strng = Mid$(S$, 4)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) - 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "**" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) ^ 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "//" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         If Variables(S%) < 0# Then
            Error 112
         Else
            Variables(S%) = Sqr(Variables(S%))
         End If
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "-=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) - T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "+=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) + T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "/=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) / T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "\=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) \ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "*=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) * T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "^=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) ^ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "++=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) + T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "--=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) - T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "^+=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) ^ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "^-=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) ^ (-T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "%=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Mod T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "|=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Or T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "&=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) And T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "~=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Xor T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "?=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Imp T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = ":=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Eqv T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "#=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Not (Variables(S%) Or T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "@=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Not (Variables(S%) Imp T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "`=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Not (Variables(S%) And T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 1) = "=" Then
      Out2 = Mid$(S$, 2)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = T#
      End If
      Exit Sub
   End If
End Sub

Sub Assignment2 (S$, S1%, S2%)
   If Left$(S$, 2) = "<<" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) * 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = ">>" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) \ 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "--" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) - 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "++" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) + 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "+++" Then
      Assign = True
      Strng = Mid$(S$, 4)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) + 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "---" Then
      Assign = True
      Strng = Mid$(S$, 4)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) - 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "**" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "//" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         If Arrays(S1%, S2%) < 0# Then
            Error 112
         Else
            Arrays(S1%, S2%) = Sqr(Arrays(S1%, S2%))
         End If
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "-=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) - T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "+=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) + T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "/=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) / T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "\=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) \ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "*=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) * T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "^=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "^+=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "++=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) + T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "--=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) - T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "^-=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ (-T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "%=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Mod T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "|=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Or T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "&=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) And T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "~=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Xor T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "?=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Imp T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = ":=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Eqv T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "#=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Not (Arrays(S1%, S2%) Or T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "@=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Not (Arrays(S1%, S2%) Imp T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "`=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Not (Arrays(S1%, S2%) And T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 1) = "=" Then
      Out2 = Mid$(S$, 2)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = T#
      End If
   End If
End Sub

' parses single letter tokens
Sub Parse.Alphabetic1 (Temp#)
   Select Case UCase$(Strng) ' test variable symbol
      Case "A" To "Z"
         Element = Asc(UCase$(Strng)) - 64
         Element.Type$ = Mid$(Out2, Token.Index, 1)
         Select Case Element.Type$
            Case "("
               Call Get.Token
               Call Get.Token
               Call Parse1(Temp#)
               If Strng = ")" Then
                  Subscript = CInt(Temp#)
                  V = UBound(Arrays, 2)
                  If Subscript > V Then
                     ReDim _Preserve Arrays(1024, Subscript) As Double
                  End If
                  Temp# = Arrays(Element, Subscript)
                  Last.Token = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case "["
               Call Get.Token
               Call Get.Token
               Call Parse1(Temp#)
               If Strng = "]" Then
                  Subscript = CInt(Temp#)
                  V = UBound(Arrays, 2)
                  If Subscript > V Then
                     ReDim _Preserve Arrays(1024, Subscript) As Double
                  End If
                  Temp# = Arrays(Element, Subscript)
                  Last.Token = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case "{"
               Call Get.Token
               Call Get.Token
               Call Parse1(Temp#)
               If Strng = "}" Then
                  Subscript = CInt(Temp#)
                  V = UBound(Arrays, 2)
                  If Subscript > V Then
                     ReDim _Preserve Arrays(1024, Subscript) As Double
                  End If
                  Temp# = Arrays(Element, Subscript)
                  Last.Token = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case Else
               Temp# = Variables(Element)
               Last.Token = True
         End Select
      Case Else
         Error 92
   End Select
End Sub

' parses two-letter tokens
Sub Parse.Alphabetic2 (Temp#)
   Select Case UCase$(Strng)
      ' user defined functions
      Case "FN"
         Call ParseFN(Temp#)
      Case "FZ"
         Call ParseFZ(Temp#)
         ' functions w/o parameters
      Case "PI" ' calculate PI
         Temp# = Atn(1#) * 4#
         Last.Token = True
      Case "EX" ' calculate E
         Temp# = Exp(1#)
         Last.Token = True
         ' special case functions
      Case "OR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Or Temp#
         Call Get.Token4
         Last.Token = True
      Case Else
         If Mid$(Strng, 2, 1) = "$" Then
            Select Case Mid$(Out2, Token.Index, 1)
               Case "(", "[", "{"
                  Strng = "<bad string token>"
                  Error 92
            End Select
            Select Case UCase$(Left$(Strng, 1))
               Case "A" To "Z"
                  Element = Asc(UCase$(Left$(Strng, 1))) - 64
                  Out3 = Strngs(Element)
                  Last.Token = False
            End Select
         Else
            If Mid$(Strng, 2, 1) >= "0" And Mid$(Strng, 2, 1) <= "9" Then
               Element.Type$ = Mid$(Out2, Token.Index, 1)
               If Element.Type$ = "(" Then
                  V = GetVariable(Left$(Strng, 2))
                  Call Get.Token3
                  Call Get.Token
                  Call Parse1(Temp#)
                  Call Get.Token4
                  Last.Token = True
                  Element = Temp#
                  Z = UBound(Arrays, 2)
                  If Element > Z Then
                     ReDim _Preserve Arrays(1024, Element) As Double
                  End If
                  Temp# = Arrays(V, Element)
               Else
                  V = GetVariable(Strng)
                  Temp# = Variables(V)
                  Last.Token = True
               End If
            Else
               Error 92
            End If
         End If
   End Select
End Sub

' parses FN(<x>)
Sub ParseFN (Temp#)
   Var$ = Left$(Out2, Token.Index - 3)
   Call Get.Token3
   Call Get.Token
   Call Parse1(Temp4#)
   Call Get.Token4
   Func& = CLng(Temp4#)
   If Func& >= 1 And Func& <= UBound(Definitions, 1) Then
      Var2$ = Mid$(Out2, Token.Index)
      Out2 = Definitions(Func&)
      Out2 = LTrim$(Out2)
      ' test for nul token
      If Out2 = Nul Then
         Strng = "<bad FN token>"
         Error 92
      End If
      ' count recursing calls
      Recurse = Recurse + 1
      If Recurse > Max.Recurse Then
         Strng = "<bad FN recurse>"
         Error 92
      End If
      ' recursively call functions
      Token.Index = 1
      Call Get.Token
      Call Parse1(Temp#)
      ' test huge recursed FN
      If Len(Var$) + Len(Var2$) >= Kilo Then
         Var$ = Nul
         Var2$ = Nul
         Strng = "<bad FN string>"
         Error 92
      End If
      Out2 = Var$ + Var2$
      Token.Index = Len(Var$) + 1
      Exit Sub
   End If
   Strng = "<bad FN range>"
   Error 92
End Sub

' parses FZ(<x>)
Sub ParseFZ (Temp#)
   Call Get.Token3
   Call Get.Token
   Call Parse1(Temp4#)
   Call Get.Token4
   Func& = CLng(Temp4#)
   Temp# = Temp4#
   If Func& >= 1 And Func& <= UBound(Definitions, 1) Then
      Out3 = Definitions(Func&)
      Out3 = LTrim$(Out3)
      Out3 = RTrim$(Out3)
      If Out3 = Nul Then
         Strng = "<bad FZ token>"
         Error 92
      End If
      Last.Token = False
      Exit Sub
   End If
   Strng = "<bad FZ range>"
   Error 92
End Sub

' parses three and greater letter tokens
Sub Parse.Alphabetic3 (Temp#)
   If Len(Strng) = 3 Then
      x$ = Mid$(Strng, 1, 1)
      y$ = Mid$(Strng, 2, 1)
      z$ = Mid$(Strng, 3, 1)
      If LCase$(x$) >= "a" And LCase$(x$) <= "z" Then
         If y$ >= "0" And y$ <= "9" Then
            If z$ = "$" Then
               z$ = Left$(Strng, 2)
               z = GetVariable(z$)
               Out3 = Strngs(z)
               Last.Token = False
               Exit Sub
            End If
         End If
      End If
   End If
   Select Case UCase$(Strng)
      ' color constants

      ' low intensity/background
      Case "BLACK"
         Temp# = 0
         LastToken = True
      Case "BBLUE"
         Temp# = 1
         LastToken = True
      Case "BGREEN"
         Temp# = 2
         LastToken = True
      Case "BCYAN"
         Temp# = 3
         LastToken = True
      Case "BRED"
         Temp# = 4
         LastToken = True
      Case "BMAGENTA"
         Temp# = 5
         LastToken = True
      Case "BYELLOW"
         Temp# = 6
         LastToken = True
      Case "PLAIN"
         Temp# = 7
         LastToken = True

         ' high intensity foreground
      Case "GRAY"
         Temp# = 8
         LastToken = True
      Case "BLUE"
         Temp# = 9
         LastToken = True
      Case "GREEN"
         Temp# = 10
         LastToken = True
      Case "CYAN"
         Temp# = 11
         LastToken = True
      Case "RED"
         Temp# = 12
         LastToken = True
      Case "MAGENTA"
         Temp# = 13
         LastToken = True
      Case "YELLOW"
         Temp# = 14
         LastToken = True
      Case "WHITE"
         Temp# = 15
         LastToken = True

         ' constant functions
      Case "LBOUND"
         Temp# = 1
         Last.Token = True
      Case "UBOUND"
         Temp# = UBound(Arrays, 2)
         Last.Token = True
      Case "QUOTE$"
         Out3 = Quote
         Last.Token = False
      Case "COMMAND$"
         Out3 = Read.Command$
         Last.Token = False
      Case "COMSPEC$"
         Out3 = Environ$("COMSPEC")
         Last.Token = False
      Case "AUTHOR$"
         Out3 = Author
         Last.Token = False
      Case "EMAIL$"
         Out3 = Email
         Last.Token = False
      Case "URL$"
         Out3 = Urls
         Last.Token = False
      Case "OS$"
         Out3 = _OS$
         Last.Token = False
      Case "CWD$"
         Out3 = _CWD$
         Last.Token = False
      Case "STARTDIR$"
         Out3 = _StartDir$
         Last.Token = False
      Case "VERSION$"
         Out3 = Version$
         Last.Token = False
      Case "RELEASE$"
         Out3 = Release$
         Last.Token = False
      Case "PROGRAM$"
         Out3 = Program
         Last.Token = False
      Case "PUBLISH$"
         Out3 = Publish
         Last.Token = False
      Case "BUILD$"
         Out3 = Build$
         Last.Token = False
      Case "FULLVERSION$"
         Out3 = FullVersion$
         Last.Token = False
      Case "COOKIE$"
         Out3 = "Thank you for all the cookies!"
         Last.Token = False
      Case "ERROR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Error CInt(Temp#)
         Call Get.Token4
         Last.Token = True
         ' functions w/o parameters
      Case "FALSE"
         Temp# = FalseD
         Last.Token = True
      Case "TRUE"
         Temp# = TrueD
         Last.Token = True
      Case "TIMER"
         Temp# = Timer
         Last.Token = True
      Case "RND"
         Temp# = Rnd
         Last.Token = True
         ' boolean functions
      Case "AND"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# And Temp#
         Call Get.Token4
         Last.Token = True
      Case "MOD"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Mod Temp#
         Call Get.Token4
         Last.Token = True
      Case "NOR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Not (Number# Or Temp#)
         Call Get.Token4
         Last.Token = True
      Case "NON"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Not (Number# Imp Temp#)
         Call Get.Token4
         Last.Token = True
      Case "XAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Not (Number# And Temp#)
         Call Get.Token4
         Last.Token = True
      Case "XOR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Xor Temp#
         Call Get.Token4
         Last.Token = True
      Case "IMP"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Imp Temp#
         Call Get.Token4
         Last.Token = True
      Case "EQV"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Eqv Temp#
         Call Get.Token4
         Last.Token = True
      Case "NOT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Not Temp#
         Call Get.Token4
         Last.Token = True
         ' third-order boolean
      Case "TAND"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         Call Get.Token4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# And Number2#
                     Last.Token = True
                     Exit Sub
               End Select
         End Select
         Error 5
      Case "TOR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         Call Get.Token4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# Or Number2#
                     Last.Token = True
                     Exit Sub
               End Select
         End Select
         Error 5
      Case "TXOR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         Call Get.Token4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# Xor Number2#
                     Last.Token = True
                     Exit Sub
               End Select
         End Select
         Error 5
         ' date\time functions
      Case "CLOCK"
         Temp# = Timer
         Last.Token = True
      Case "DATE$"
         Out3 = Date$
         Last.Token = False
      Case "TIME$"
         Out3 = Time$
         Last.Token = False
         ' conversion/calculation functions
      Case "BIN$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Nul
         If Temp# >= FalseD Then
            Digits = False
            Do
               If 2 ^ (Digits + 1) > Temp# Then
                  Exit Do
               End If
               Digits = Digits + 1
            Loop
            For Power = Digits To 0 Step -1
               If Temp# - 2 ^ Power >= 0 Then
                  Temp# = Temp# - 2 ^ Power
                  Out3 = Out3 + "1"
               Else
                  Out3 = Out3 + "0"
               End If
            Next
         End If
         Call Get.Token4
         Last.Token = False
      Case "CHR$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Chr$(CInt(Temp#))
         Call Get.Token4
         Last.Token = False
      Case "HEX$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Hex$(Temp#)
         Call Get.Token4
         Last.Token = False
      Case "OCT$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Oct$(Temp#)
         Call Get.Token4
         Last.Token = False
      Case "STR$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Str$(Temp#)
         Call Get.Token4
         Last.Token = False
      Case "LCASE$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = LCase$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "UCASE$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = UCase$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "RTRIM$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = RTrim$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "LTRIM$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = LTrim$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "TRIM$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = LTrim$(RTrim$(Out3))
         Call Get.Token4
         Last.Token = False
      Case "SPACE$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = String$(Temp#, 32)
         Call Get.Token4
         Last.Token = False
      Case "MID$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token
         Call Parse1(Temp#)
         Temp4# = Temp#
         If Strng = "," Then
            Call Get.Token
            Call Parse1(Temp#)
            Length# = Temp#
            Out3 = Mid$(Out3, Temp4#, Length#)
         Else
            Out3 = Mid$(Out3, Temp4#)
         End If
         Call Get.Token4
         Last.Token = False
      Case "REMID$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token
         Call Parse1(Temp#)
         Start# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Length# = Temp#
         Out3 = Left$(Out3, Start# - 1) + Mid$(Out3, Start# + Length#)
         Call Get.Token4
         Last.Token = False
      Case "DEMID$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         String1$ = Out3
         Call Get.Token
         Call Parse1(Temp#)
         If Len(String1$) And Len(Out3) Then
            Imbedded = InStr(String1$, Out3)
            While Imbedded
               String1$ = Left$(String1$, Imbedded - 1) + Mid$(String1$, Imbedded + Len(Out3))
               Imbedded = InStr(String1$, Out3)
            Wend
         End If
         Out3 = String1$
         Call Get.Token4
         Last.Token = False
      Case "REPLACE$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         String1$ = Out3
         Call Get.Token
         Call Parse1(Temp#)
         String2$ = Out3
         Call Get.Token
         Call Parse1(Temp#)
         String3$ = Out3
         If String1$ = Nul Or String2$ = Nul Or String2$ = String3$ Then
            Out3 = String1$
            Exit Sub
         End If
         Temp1 = 1
         Do
            If String1$ = Nul Then
               Exit Do
            End If
            Var1 = InStr(Temp1, String1$, String2$)
            If Var1 = False Then
               Exit Do
            End If
            String1$ = Left$(String1$, Var1 - 1) + String3$ + Mid$(String1$, Var1 + Len(String2$))
            Temp1 = Temp1 + Len(String3$)
         Loop
         Out3 = String1$
         Call Get.Token4
         Last.Token = False
      Case "LEFT$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Left$(Out3, Temp#)
         Call Get.Token4
         Last.Token = False
      Case "RIGHT$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Right$(Out3, Temp#)
         Call Get.Token4
         Last.Token = False
      Case "STRING$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Out3 = String$(Number#, Temp#)
         Else
            Out3 = String$(Number#, Out3)
         End If
         Call Get.Token4
         Last.Token = False
      Case "ABS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Abs(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "ASC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Asc(Out3)
         Call Get.Token4
         Last.Token = True
      Case "EXP"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Exp(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "FBN" ' calculate xth fibonachi value
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Fibo.A# = 1
         Fibo.B# = 1
         If Temp# >= 1 Then
            For Fibo.Number# = 1 To Temp# - 1
               Fibo.Temp# = Fibo.B#
               Fibo.B# = Fibo.A# + Fibo.B#
               Fibo.A# = Fibo.Temp#
            Next
         End If
         Temp# = Fibo.B#
         Call Get.Token4
         Last.Token = True
      Case "FCT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Factorial# = 1
         Factorial.Count# = Int(Temp#)
         If Factorial.Count# >= 1 Then
            For Factorial.Count# = 1 To Temp#
               Factorial# = Factorial# * Factorial.Count#
            Next
         End If
         Temp# = Factorial#
         Call Get.Token4
         Last.Token = True
      Case "FIX"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Fix(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "INSTR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Start# = Temp#
            Call Get.Token
            Call Parse1(Temp#)
            Stored.String$ = Out3
            Call Get.Token
            Call Parse1(Temp#)
         Else
            Start# = 1#
            Stored.String$ = Out3
            Call Get.Token
            Call Parse1(Temp#)
         End If
         Temp# = InStr(Start#, Stored.String$, Out3)
         Call Get.Token4
         Last.Token = True
      Case "INT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Int(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "LEN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Len(Out3)
         Call Get.Token4
         Last.Token = True
      Case "LOG"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "ISEVEN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Temp# Mod 2#) = 0
         Call Get.Token4
         Last.Token = True
      Case "ISODD"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Temp# Mod 2#) = 1
         Call Get.Token4
         Last.Token = True
      Case "ISPRM" ' calculate x is prime
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Prime# = Int(Temp#)
         Prime.Flag = True
         If Prime# > 2# Then
            For Loop.Count# = 2# To Int(Sqr(Prime#))
               If Prime# / Loop.Count# = Int(Prime# / Loop.Count#) Then
                  Prime.Flag = False
                  Exit For
               End If
            Next
         End If
         If Prime.Flag = False Then
            Temp# = FalseD
         Else
            Temp# = TrueD
         End If
         Call Get.Token4
         Last.Token = True
      Case "PRF" ' calculate xth perfect number
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token4
         Last.Token = True
         Perfect# = Int(Temp#)
         Select Case Perfect#
            Case 1#
               X# = 1#
            Case 2#
               X# = 2#
            Case 3#
               X# = 4#
            Case 4#
               X# = 6#
            Case 5#
               X# = 12#
            Case 6#
               X# = 16#
            Case 7#
               X# = 18#
               'CASE 8# ' overflows beyond double precision
               '  X# = 30#
            Case Else
               Error 130
         End Select
         ' equation for perfect number
         Temp# = 2 ^ X# * (2 ^ (X# + 1) - 1)
         Last.Token = True
      Case "PRM" ' calculate xth prime
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Prime.Number# = Int(Temp#)
         Prime# = 1
         If Prime.Number# > FalseD Then
            Prime.Counter# = False
            Do
               Prime# = Prime# + 1
               Prime.Flag = False
               For Factor# = 2# To Int(Sqr(Prime#))
                  If Prime# / Factor# = Int(Prime# / Factor#) Then
                     Prime.Flag = True
                     Exit For
                  End If
               Next
               If Prime.Flag = False Then
                  Prime.Counter# = Prime.Counter# + 1
               End If
               If Prime.Counter# = Prime.Number# Then
                  Exit Do
               End If
            Loop
         End If
         Temp# = Prime#
         Call Get.Token4
         Last.Token = True
      Case "SGN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Sgn(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "SQR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Temp# < 0# Then
            Error 112
         Else
            Temp# = Sqr(Temp#)
         End If
         Call Get.Token4
         Last.Token = True
      Case "CBR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Temp# ^ (1# / 3#)
         Call Get.Token4
         Last.Token = True
      Case "GCM"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         ' find last factor which divides into both numbers
         Factor1# = 1
         Number3# = Number1#
         For Factor2# = 2 To Number1#
            Do
               If Number3# / Factor2# = Number3# \ Factor2# Then
                  If Number2# / Factor2# = Number2# \ Factor2# Then
                     If Factor2# > Factor1# Then
                        Factor1# = Factor2#
                     End If
                  End If
                  Number3# = Number3# / Factor2#
               Else
                  Exit Do
               End If
            Loop
         Next
         Temp# = Factor1#
         Call Get.Token4
         Last.Token = True
      Case "LCD"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         ' find first factor which divides into both numbers
         Factor1# = 0
         For Factor2# = 2 To Number1#
            If Number1# / Factor2# = Number1# \ Factor2# Then
               If Number2# / Factor2# = Number2# \ Factor2# Then
                  Factor1# = Factor2#
                  Exit For
               End If
            End If
         Next
         If Factor1# = 0# Then
            Factor1# = 1#
         End If
         If Factor1# = Number2# Then
            Factor1# = 1#
         End If
         Temp# = Factor1#
         Call Get.Token4
         Last.Token = True
      Case "NTH"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# ^ (1# / Temp#)
         Call Get.Token4
         Last.Token = True
      Case "PWR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# ^ Temp#
         Call Get.Token4
         Last.Token = True
      Case "VAL"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Val(Out3)
         Call Get.Token4
         Last.Token = True

         Rem file functions..

      Case "FILEEXISTS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = _FileExists(Out3)
         Call Get.Token4
         Last.Token = True
      Case "DIREXISTS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = _DirExists(Out3)
         Call Get.Token4
         Last.Token = True
      Case "DRIVEEXISTS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Var$ = Nul
         If Last.Token Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Var$ = Chr$(Var + 64)
            End If
         Else
            Var = Asc(UCase$(Out3))
            If Var >= 65 And Var <= 90 Then
               Var$ = Chr$(Var)
               Var = Var - 64
            End If
         End If
         Temp# = 0#
         If Len(Var$) Then
            Out3 = Var$
            If DRIVEEXISTS(Var) = 0 Then
               Temp# = -1#
            Else
               Error 71
            End If
         Else
            Error 71
         End If
         Call Get.Token4
         Last.Token = True
      Case "DRIVETYPE"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Var$ = Nul
         If Last.Token Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Var$ = Chr$(Var + 64)
            End If
         Else
            Var = Asc(UCase$(Out3))
            If Var >= 65 And Var <= 90 Then
               Var$ = Chr$(Var)
               Var = Var - 64
            End If
         End If
         Out3 = Nul
         If Len(Var$) Then
            If DRIVEEXISTS(Var) = 0 Then
               Out3 = DriveType
            Else
               Error 71
            End If
         Else
            Error 71
         End If
         Call Get.Token4
         Last.Token = False
      Case "AMBIG$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = AmbiguateFile$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "CURDIR$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = _CWD$
         Call Get.Token4
         Last.Token = False
      Case "ENVIRON$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Var = CInt(Temp#)
            Out3 = Environ$(Var)
         Else
            Out3 = Environ$(Out3)
         End If
         Call Get.Token4
         Last.Token = False
      Case "FILES"
         If WhatisError = 0 Then
            Parse.Type = -1
            V$ = "*.*"
            Call CallListFiles(V$, -1)
         End If
         Last.Token = False
      Case "DIRS"
         If WhatisError = 0 Then
            Parse.Type = -1
            V$ = "*.*"
            Call ListFiles(V$, 0)
         End If
         Last.Token = False
      Case "DRIVES"
         If WhatisError = 0 Then
            Parse.Type = -1
            Call ListDrives("")
         End If
         Last.Token = True
      Case "FILEDATE"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call FileDate(Out3)
         Call Get.Token4
         Last.Token = False
      Case "FILETIME"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call FileTime(Out3)
         Call Get.Token4
         Last.Token = False
      Case "FILESIZE"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call GetFileSize(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "FILEATTR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call FileAttr(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "FILEBITS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call FileAttr(Temp#)
         Call Get.Token4
         Out3 = Space$(5)
         If (Temp# And &H20) = &H20 Then
            Mid$(Out3, 1, 1) = "A" ' archive
         End If
         If (Temp# And &H10) = &H10 Then
            Mid$(Out3, 2, 1) = "D" ' directory
         End If
         If (Temp# And &H4) = &H4 Then
            Mid$(Out3, 3, 1) = "S" ' system
         End If
         If (Temp# And &H2) = &H2 Then
            Mid$(Out3, 4, 1) = "H" ' hidden
         End If
         If (Temp# And &H1) = &H1 Then
            Mid$(Out3, 5, 1) = "R" ' read-only
         End If
         Last.Token = False
      Case "VLABEL"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
               Var$ = Out3
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
               Var = Asc(Out3) - 64
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         End If
         Last.Token = False
         If Len(Var$) Then
            Temp# = 0#
            If DRIVEEXISTS(Var) = 0 Then
               Call Vlabel(Out3)
            Else
               Error 71
            End If
         Else
            Error 71
         End If
         Call Get.Token4
      Case "VSERIAL"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
               Var$ = Out3
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
               Var = Asc(Var$) - 64
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         End If
         Last.Token = False
         If Len(Var$) Then
            Temp# = 0#
            If DRIVEEXISTS(Var) = 0 Then
               Call Vserial(Out3)
            Else
               Error 71
            End If
         Else
            Error 71
         End If
         Call Get.Token4
      Case "VTYPE"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
               Var$ = Out3
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
               Var = Asc(Out3) - 64
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         End If
         Last.Token = False
         If Len(Var$) Then
            Temp# = 0#
            If DRIVEEXISTS(Var) = 0 Then
               Call Vtype(Out3)
            Else
               Error 71
            End If
         Else
            Error 71
         End If
         Call Get.Token4
      Case "DRV"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
               Var$ = Out3
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
               Var = Asc(Out3) - 64
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         End If
         If Len(Var$) Then
            Temp# = 0#
            If DRIVEEXISTS(Var) = 0 Then
               Call FreeSpace(Out3)
               Temp# = Int(Val(Out3))
            Else
               Error 71
            End If
         Else
            Error 71
         End If
         Last.Token = True
         Call Get.Token4
      Case "TDRV"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
               Var$ = Out3
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
               Var = Asc(Out3) - 64
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         End If
         If Len(Out3) Then
            Temp# = 0#
            If DRIVEEXISTS(Var) = 0 Then
               Call TotalSpace(Out3)
               Temp# = Int(Val(Out3))
            Else
               Error 71
            End If
         Else
            Error 71
         End If
         Last.Token = True
         Call Get.Token4

         Rem Basic trigonometric functions..

      Case "ATN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "COS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Cos(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "COT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Cos(Temp#) / Sin(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "CSC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = 1# / Sin(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "SEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = 1# / Cos(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "SIN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Sin(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "TAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Tan(Temp#)
         Call Get.Token4
         Last.Token = True

         Rem Remaining nonintrinsic trigonmetric functions..

         'Inverse Cosine
      Case "ARCCOS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(-Temp# / Sqr(-Temp# * Temp# + 1)) + 2 * Atn(1)
         Call Get.Token4
         Last.Token = True
         'Inverse Cosecant
      Case "ARCCOSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(Temp# * Temp# - 1)) + (Sgn(Temp#) - 1) * (2 * Atn(1))
         Call Get.Token4
         Last.Token = True
         'Inverse Cotangent
      Case "ARCCOTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp#) + 2 * Atn(1)
         Call Get.Token4
         Last.Token = True
         'Inverse Secant
      Case "ARCSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(Temp# * Temp# - 1)) + Sgn((Temp#) - 1) * (2 * Atn(1))
         Call Get.Token4
         Last.Token = True
         'Inverse Sine
      Case "ARCSIN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(-Temp# * Temp# + 1))
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Cosine
      Case "HARCCOS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log(Temp# + Sqr(Temp# * Temp# - 1))
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Cosecant
      Case "HARCCOSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log((Sgn(Temp#) * Sqr(Temp# * Temp# + 1) + 1) / Temp#)
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Cotangent
      Case "HARCCOTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log((Temp# + 1) / (Temp# - 1)) / 2
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Secant
      Case "HARCSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log((Sqr(-Temp# * Temp# + 1) + 1) / Temp#)
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Sine
      Case "HARCSIN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log(Temp# + Sqr(Temp# * Temp# + 1))
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Tangent
      Case "HARCTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log((1 + Temp#) / (1 - Temp#)) / 2
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Cosine
      Case "HCOS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) + Exp(-Temp#)) / 2
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Cosecant
      Case "HCOSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = 2 / (Exp(Temp#) - Exp(-Temp#))
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Cotangent
      Case "HCOTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) + Exp(-Temp#)) / (Exp(Temp#) - Exp(-Temp#))
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Secant
      Case "HSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = 2 / (Exp(Temp#) + Exp(-Temp#))
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Sine
      Case "HSIN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) - Exp(-Temp#)) / 2
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Tangent
      Case "HTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) - Exp(-Temp#)) / (Exp(Temp#) + Exp(-Temp#))
         Call Get.Token4
         Last.Token = True
         'Convert Degrees to Radians
      Case "DEGTORAD"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = ((Atn(1) * 4) / 180) * Temp#
         Call Get.Token4
         Last.Token = True
         'Convert Radians to Degrees
      Case "RADTODEG"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (180 / (Atn(1) * 4)) * Temp#
         Call Get.Token4
         Last.Token = True
         ' Hypotenuse
      Case "HYPOT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Sqr(Number# * Number# + Temp# * Temp#)
         Call Get.Token4
         Last.Token = True
      Case Else
         Error 92
   End Select
End Sub

' foreground color
Function GetColor (Var$)
   Temp# = 0#
   ' color constants
   Select Case UCase$(Var$)
      ' high intensity foreground
      Case "BLACK"
         Temp# = -1
      Case "PLAIN"
         Temp# = 7
      Case "GRAY"
         Temp# = 8
      Case "BLUE"
         Temp# = 9
      Case "GREEN"
         Temp# = 10
      Case "CYAN"
         Temp# = 11
      Case "RED"
         Temp# = 12
      Case "MAGENTA"
         Temp# = 13
      Case "YELLOW"
         Temp# = 14
      Case "WHITE"
         Temp# = 15
   End Select
   GetColor = Temp#
End Function

' background color
Function GetColor2 (Var$)
   Temp# = 0#
   ' color constants
   Select Case UCase$(Var$)
      ' low intensity/background
      Case "BBLACK", "BLACK"
         Temp# = -1
      Case "BBLUE", "BLUE"
         Temp# = 1
      Case "BGREEN", "GREEN"
         Temp# = 2
      Case "BCYAN", "CYAN"
         Temp# = 3
      Case "BRED", "RED"
         Temp# = 4
      Case "BMAGENTA", "MAGENTA"
         Temp# = 5
      Case "BYELLOW", "YELLOW"
         Temp# = 6
      Case "BWHITE", "WHITE"
         Temp# = 7
   End Select
   GetColor2 = Temp#
End Function

' return variable of mixed-length string.
Function GetVariable (V$)
   X$ = V$
   If Len(X$) = 1 Then
      X$ = UCase$(X$)
      If X$ >= "A" And X$ <= "Z" Then
         GetVariable = Asc(X$) - 64 ' 1-26
      End If
      Exit Function
   End If
   ' A0-A9, B0-B9, ...
   If Len(X$) = 2 Then
      Y$ = UCase$(Left$(X$, 1))
      Z$ = UCase$(Right$(X$, 1))
      If Y$ >= "A" And Y$ <= "Z" Then
         If Z$ >= "0" And Z$ <= "9" Then
            Y = Asc(Y$) - 64
            Z = Int(Val(Z$)) + 1
            ' a0=26*1+0, a9=26*1+9
            ' b0=26*2+0, b9=26*2+9, ...
            GetVariable = Y * 26 + Z
         End If
      End If
   End If
End Function

' return mixed-length string of variable.
Function GetVariable2$ (V)
   If V >= 1 And V <= 26 Then ' A-Z
      GetVariable2$ = Chr$(V + 64)
      Exit Function
   End If
   X = Int(V / 26) ' A-Z
   Y = V - X * 26 ' 0-9
   X$ = Chr$(X + 64)
   X$ = X$ + LTrim$(Str$(Y - 1))
   GetVariable2$ = X$
End Function

' beginning of the command/equation parser
Sub Enter.Equate
   Strng = Nul
   Var2$ = Out2
   Out2 = LTrim$(Out2)
   If Out2 = Nul Then
      Exit Sub
   End If
   Store.Input$ = Out2
   Assign = False
   GoSub Assignment
   If Assign Then
      Exit Sub
   End If
   Out2 = Store.Input$
   D$ = UCase$(Out2)
   If Left$(D$, 4) = "SWAP" Then
      Call SwapData
      If Assign Then
         Exit Sub
      End If
   End If
   If Left$(D$, 3) = "MID" Then
      GoSub Assign.Mid.String
      If Assign Then
         Exit Sub
      End If
   End If
   If Left$(D$, 4) = "LEFT" Then
      GoSub Assign.Left.String
      If Assign Then
         Exit Sub
      End If
   End If
   If Left$(D$, 5) = "RIGHT" Then
      GoSub Assign.Right.String
      If Assign Then
         Exit Sub
      End If
   End If
   If Left$(D$, 5) = "DEFFN" Then
      GoSub Define.Function
      If Assign Then
         Exit Sub
      End If
   End If
   Out2 = Store.Input$
   Last.Token = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   Token.Index = 1
   Call Get.Token
   Call Parse1(T#)

   ' parse leftover tokens
   While Len(Strng)
      Call Parse1(X#)
      ' toss away any unwanted tokens
      If Last.Token = 3 Then
         Strng = "<extra token>"
         Error 92
      End If
   Wend

   ' display output result
   Last.Token.Value = T#
   If Parse.Type > 0 Then
      If Parse.Type = 1 Then
         Print #StdoutHandle, Var2$ + " Equals: ";
      End If
      If Last.Token = False Then
         Print #StdoutHandle, Out3
      Else
         Print #StdoutHandle, LTrim$(Str$(T#))
      End If
   End If
   Exit Sub

   Assignment:
   Assign = False
   Temp1$ = UCase$(Left$(Out2, 1))
   If Temp1$ = "?" Then ' ?=
      Temp1$ = Mid$(Out2, 2)
      Temp2$ = Left$(Temp1$, 1)
      If Temp2$ = "=" Then
         Temp1$ = Mid$(Temp1$, 2)
         Out2 = Temp1$
         GoSub Assignment
         Call Equate(Temp4#)
         Assign = True
         Exit Sub
      End If
   End If
   If Temp1$ >= "A" And Temp1$ <= "Z" Then
      Variable = Asc(Temp1$) - 64
      Temp1$ = Mid$(Out2, 2)
      Temp2$ = Left$(Temp1$, 1)
      If Temp2$ >= "0" And Temp2$ <= "9" Then
         Temp1$ = LTrim$(Mid$(Temp1$, 2))
         If Len(Temp1$) Then
            Variable = GetVariable(Left$(Out2, 2))
         Else
            Return
         End If
      End If
      Temp1$ = LTrim$(Temp1$)
      Call Assignment1(Temp1$, Variable)
      If Assign Then
         GoSub Assign.End
         Return
      End If
      If Left$(Temp1$, 1) = "$" Then
         Temp1$ = Mid$(Temp1$, 2)
         Temp1$ = LTrim$(Temp1$)
         If Left$(Temp1$, 1) = "(" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "[" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "{" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "=" Then
            Out2 = Mid$(Temp1$, 2)
            Out2 = LTrim$(Out2)
            Token.Index = 1
            Call Get.Token
            Call Parse1(Temp3#)
            If Last.Token = False Then
               Strngs(Variable) = Out3
               Assign = True
               GoSub Assign.End
               Return
            End If
         End If
      End If
      If Left$(Temp1$, 1) = "(" Then
         Out2 = Mid$(Temp1$, 2)
         Out2 = LTrim$(Out2)
         Last.Token = False
         Token.Index = 1
         Call Get.Token
         Call Parse1(Temp3#)
         If Last.Token = True Then
            Element = CInt(Temp3#)
            V = UBound(Arrays, 2)
            If Element > V Then
               ReDim _Preserve Arrays(1024, Element) As Double
            End If
            Temp1$ = Mid$(Out2, Token.Index)
            Temp1$ = LTrim$(Temp1$)
            Call Assignment2(Temp1$, Variable, Element)
            If Assign Then
               GoSub Assign.End
               Return
            End If
         End If
      End If
   End If
   Return

   Assign.Mid.String:
   Out2 = Mid$(Out2, 4)
   If Len(Out2) Then
      Begin = 0: If Left$(Out2, 2) = "$(" Then Begin = -1
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" And Begin Then
         X$ = UCase$(Mid$(Out2, 2, 1))
         If X$ >= "0" And X$ <= "9" Then
            V$ = V$ + X$
         End If
         ' multivar assign
         Variable = GetVariable(V$)
         Begin = Len(V$)
         If Mid$(Out2, Begin + 1, 1) = "$" Then
            Out2 = Mid$(Out2, Begin + 3)
            Last.Token = False
            Token.Index = 1
            Call Get.Token
            Call Parse1(T#)
            Start = CInt(T#)
            If Strng = "," Then
               Call Get.Token
               Call Parse1(T#)
               Length = CInt(T#)
               Out2 = Mid$(Out2, Token.Index)
               Out2 = LTrim$(Out2)
               If Left$(Out2, 1) = "=" Then
                  Out2 = Mid$(Out2, 2)
                  Out2 = LTrim$(Out2)
                  Token.Index = 1
                  Call Get.Token
                  Call Parse1(T#)
                  If Last.Token = False Then
                     Assign = True
                     If Strngs(Variable) = Nul Then
                        If Start = 1 Then
                           If Len(Out3) = Length Then
                              Strngs(Variable) = Out3
                              GoSub Assign.End
                              Return
                           End If
                        End If
                        Strng = "<bad string>"
                        Error 92
                        Return
                     End If
                     Mid$(Strngs(Variable), Start, Length) = Out3
                     GoSub Assign.End
                     Return
                  End If
               End If
            End If
         End If
      End If
   End If
   Return

   Assign.Left.String:
   Out2 = Mid$(Out2, 5)
   If Len(Out2) Then
      Begin = 0: If Left$(Out2, 2) = "$(" Then Begin = -1
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" Then
         X$ = UCase$(Mid$(Out2, 2, 1))
         If X$ >= "0" And X$ <= "9" And Begin Then
            V$ = V$ + X$
         End If
         ' multivar assign
         Variable = GetVariable(V$)
         Begin = Len(V$)
         If Mid$(Out2, Begin + 1, 1) = "$" Then
            Out2 = Mid$(Out2, Begin + 3)
            Last.Token = False
            Token.Index = 1
            Call Get.Token
            Call Parse1(T#)
            Start = CInt(T#)
            Out2 = Mid$(Out2, Token.Index)
            Out2 = LTrim$(Out2)
            If Left$(Out2, 1) = "=" Then
               Assign = True
               Out2 = Mid$(Out2, 2)
               Out2 = LTrim$(Out2)
               Token.Index = 1
               Call Get.Token
               Call Parse1(T#)
               If Last.Token = False Then
                  Assign = True
                  If Strngs(Variable) = Nul Then
                     If Len(Out3) = Start Then
                        Strngs(Variable) = Out3
                        GoSub Assign.End
                        Return
                     End If
                     Strng = "<bad string>"
                     Error 92
                     Return
                  End If
                  Mid$(Strngs(Variable), 1, Start) = Out3
                  GoSub Assign.End
                  Return
               End If
            End If
         End If
      End If
   End If
   Return

   Assign.Right.String:
   Out2 = Mid$(Out2, 6)
   If Len(Out2) Then
      Begin = 0: If Left$(Out2, 2) = "$(" Then Begin = -1
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" And Begin Then
         X$ = UCase$(Mid$(Out2, 2, 1))
         If X$ >= "0" And X$ <= "9" Then
            V$ = V$ + X$
         End If
         ' multivar assign
         Variable = GetVariable(V$)
         Begin = Len(V$)
         If Mid$(Out2, Begin + 1, 1) = "$" Then
            Out2 = Mid$(Out2, Begin + 3)
            Last.Token = False
            Token.Index = 1
            Call Get.Token
            Call Parse1(T#)
            Start = CInt(T#)
            Out2 = Mid$(Out2, Token.Index)
            Out2 = LTrim$(Out2)
            If Left$(Out2, 1) = "=" Then
               Assign = True
               Out2 = Mid$(Out2, 2)
               Out2 = LTrim$(Out2)
               Token.Index = 1
               Call Get.Token
               Call Parse1(T#)
               Length = Len(Strngs(Variable)) - Start + 1
               If Last.Token = False Then
                  Assign = True
                  If Length > False Then
                     Mid$(Strngs(Variable), Length, Start) = Out3
                     GoSub Assign.End
                     Return
                  Else
                     If Strngs(Variable) = Nul Then
                        If Len(Out3) = Start Then
                           Strngs(Variable) = Out3
                           GoSub Assign.End
                           Return
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   Return

   Assign.End:
   If Len(Strng) Then
      Call Parse1(X#)
      Strng = "<extra token>"
      Error 92
   End If
   Return

   Define.Function:
   Out2 = Mid$(Out2, 6)
   Out2 = LTrim$(Out2)
   Token.Index = 1
   Call Get.Token3
   Call Get.Token
   Call Parse1(Temp4#)
   Call Get.Token4
   Func& = CLng(Temp4#)
   If Func& > UBound(Definitions, 1) Then
      ReDim _Preserve Definitions(Func&) As String
   End If
   If Func& >= 1 And Func& <= UBound(Definitions, 1) Then
      Out2 = Mid$(Out2, Token.Index)
      Out2 = LTrim$(Out2)
      If Left$(Out2, 1) = "=" Then
         Out2 = Mid$(Out2, 2)
         Definitions(Func&) = Out2
         Assign = True
         Return
      End If
   End If
   Error 145
End Sub

' returns next token in string form,
' increments pointer to next token,
' determines token type.
Sub Get.Token
   Strng = Nul ' reset token
   Token = False ' reset token type
   ' locate symbols
   Call Get.Token2(Token.Exists)
   If Token.Exists Then
      Exit Sub
   End If
   If Token.Index > Len(Out2) Then
      Strng = Nul
      Token = False
      Token.Index = Token.Index + 1
      Exit Sub
   End If
   ' locate expression symbol
   Token.Element$ = Mid$(Out2, Token.Index, 1)
   If InStr(Token.List, Token.Element$) Then
      Token = 1 ' store token type
      Strng = Token.Element$ ' store token
      Token.Index = Token.Index + 1 ' increment pointer
      Exit Sub
   End If
   ' locate expression is number
   Token.Element$ = Mid$(Out2, Token.Index, 1)
   If Token.Element$ >= "0" And Token.Element$ <= "9" Then
      ' increment token until token is other than number
      Do
         If Len(Token.Element$) = False Then
            Exit Do
         End If
         If InStr(Token.List, Token.Element$) Then
            Exit Do
         End If
         Strng = Strng + Token.Element$
         Token.Index = Token.Index + 1
         Token.Element$ = Mid$(Out2, Token.Index, 1)
      Loop
      Token = 2 ' store token type
      Exit Sub
   End If
   ' locate expression is number beginning with decimal
   Token.Element$ = Mid$(Out2, Token.Index, 1)
   If Token.Element$ = "." Then
      ' increment token until token is other than number
      Do
         If Len(Token.Element$) = False Then
            Exit Do
         End If
         If InStr(Token.List, Token.Element$) Then
            Exit Do
         End If
         Strng = Strng + Token.Element$
         Token.Index = Token.Index + 1
         Token.Element$ = Mid$(Out2, Token.Index, 1)
      Loop
      Token = 2 ' store token type
      Exit Sub
   End If
   ' locate expression is alphabetic
   Token.Element$ = UCase$(Mid$(Out2, Token.Index, 1))
   If Token.Element$ >= "A" And Token.Element$ <= "Z" Then
      ' increment token until token is other than alphabetic
      Do
         If Len(Token.Element$) = False Then
            Exit Do
         End If
         If InStr(Token.List, Token.Element$) Then
            Exit Do
         End If
         Strng = Strng + Token.Element$
         Token.Index = Token.Index + 1
         Token.Element$ = UCase$(Mid$(Out2, Token.Index, 1))
      Loop
      Token = 3 ' store token type
      Exit Sub
   End If
   Token = False
   Strng = Token.Element$
   Token.Index = Token.Index + 1
End Sub

' gets two-symbol tokens,
' increments pointer to next token.
Sub Get.Token2 (Token.Exists)
   Token.Exists = False
   Stored.Token$ = Out2
   ' locate expression symbols
   Next.Token$ = Mid$(Stored.Token$, Token.Index, 2)
   Select Case Next.Token$
      Case "<<"
         Token = 1 ' store token type
         Strng = "<<" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case ">>"
         Token = 1 ' store token type
         Strng = ">>" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "--"
         Token = 1 ' store token type
         Strng = "--" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "++"
         Token = 1 ' store token type
         Strng = "++" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "+++"
         Token = 1 ' store token type
         Strng = "+++" ' store token
         Token.Index = Token.Index + 3 ' increment pointer
         Token.Exists = True
      Case "---"
         Token = 1 ' store token type
         Strng = "---" ' store token
         Token.Index = Token.Index + 3 ' increment pointer
         Token.Exists = True
      Case "**"
         Token = 1 ' store token type
         Strng = "**" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "//"
         Token = 1 ' store token type
         Strng = "//" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case ">=", "=>"
         Token = 1 ' store token type
         Strng = ">=" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "<=", "=<"
         Token = 1 ' store token type
         Strng = "<=" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "<>", "><"
         Token = 1 ' store token type
         Strng = "<>" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
   End Select
End Sub

' verifies next token is opening parenthesis.
Sub Get.Token3
   Strng = Nul
   Token = False
   If Token.Index > Len(Out2) Then
      Strng = "<missing opening parenthesis>"
      Error 92
   End If
   ' locate parenthesis symbol
   Token.Element$ = Mid$(Out2, Token.Index, 1)
   If Token.Element$ = "(" Then
      Token = 1 ' store token type
      Strng = Token.Element$ ' store token
      Token.Index = Token.Index + 1 ' increment pointer
      Exit Sub
   End If
   Strng = "<missing opening parenthesis>"
   Error 92
End Sub

' verifies last token is closing parenthesis.
Sub Get.Token4
   ' locate parenthesis symbol
   If Strng = ")" Then
      Exit Sub
   End If
   Strng = "<missing closing parenthesis>"
   Error 92
End Sub

' process a number
Sub Parse.Numeric (Temp#)
   Select Case Right$(UCase$(Strng), 1) ' compare character after number
      Case "Q" ' perfect number suffix
         For Digit = 1 To Len(Strng) - 1
            OutX$ = UCase$(Mid$(Strng, Digit, 1))
            Select Case OutX$
               Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                  ' nul
               Case Else
                  Error 130
            End Select
         Next
         Temp# = CDbl(Val(Left$(Strng, Len(Strng) - 1)))
         Perfect# = 0#
         Perfect.Number# = Int(Temp#)
         If Abs(Perfect.Number#) > 7# Then
            Error 130
         End If
         If Perfect.Number# > FalseD Then
            Select Case Perfect.Number#
               Case 1#
                  X# = 1#
               Case 2#
                  X# = 2#
               Case 3#
                  X# = 4#
               Case 4#
                  X# = 6#
               Case 5#
                  X# = 12#
               Case 6#
                  X# = 16#
               Case 7#
                  X# = 18#
                  'CASE 8# ' overflows beyond double precision
                  '  X# = 30#
               Case Else
                  Error 130
            End Select
            ' equation for perfect number
            Perfect# = 2 ^ X# * (2 ^ (X# + 1) - 1)
         End If
         Temp# = Perfect#
      Case "P" ' prime number suffix
         For Digit = 1 To Len(Strng) - 1
            OutX$ = UCase$(Mid$(Strng, Digit, 1))
            Select Case OutX$
               Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                  ' nul
               Case Else
                  Error 130
            End Select
         Next
         Temp# = CDbl(Val(Left$(Strng, Len(Strng) - 1)))
         Prime.Number# = Int(Temp#)
         Prime# = 1
         If Prime.Number# > False Then
            Prime.Counter# = False
            Do
               Prime# = Prime# + 1
               Prime.Flag = False
               For Factor# = 2# To Int(Sqr(Prime#))
                  If Prime# / Factor# = Int(Prime# / Factor#) Then
                     Prime.Flag = True
                     Exit For
                  End If
               Next
               If Prime.Flag = False Then
                  Prime.Counter# = Prime.Counter# + 1
               End If
               If Prime.Counter# = Prime.Number# Then
                  Exit Do
               End If
            Loop
         End If
         Temp# = Prime#
      Case "F" ' factorial
         Temp2 = False
         Temp3 = Len(Strng)
         Do
            If UCase$(Mid$(Strng, Temp3, 1)) <> "F" Then
               Exit Do
            End If
            Temp2 = Temp2 + 1
            Temp3 = Temp3 - 1
         Loop
         For Decimal.Digit = 1 To Temp3
            OutX$ = UCase$(Mid$(Strng, Decimal.Digit, 1))
            Select Case OutX$
               Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                  ' nul
               Case Else
                  Error 130
            End Select
         Next
         Temp4# = Val(Left$(Strng, Temp3))
         For Number = 1 To Temp2
            Temp# = 1#
            For Factorial# = 2# To Temp4#
               Temp# = Temp# * Factorial#
            Next
            Temp4# = Temp#
         Next
      Case "H" ' hexidecimal suffix
         Temp# = False
         Hex.Power = False
         For Hex.Digit = Len(Strng) - 1 To 1 Step -1
            OutX$ = UCase$(Mid$(Strng, Hex.Digit, 1))
            Select Case OutX$
               Case "0" To "9", "A" To "F"
                  Hex.Value = Val("&H" + OutX$)
                  Temp# = Temp# + Hex.Value * 16 ^ Hex.Power
                  Hex.Power = Hex.Power + 1
               Case Else
                  Error 130
            End Select
         Next
      Case "O" ' octal suffix
         Temp# = False
         Octal.Power = False
         For Octal.Digit = Len(Strng) - 1 To 1 Step -1
            OutX$ = Mid$(Strng, Octal.Digit, 1)
            If OutX$ >= "0" And OutX$ <= "7" Then
               Octal.Value = Val(OutX$)
               Temp# = Temp# + Octal.Value * 8 ^ Octal.Power
               Octal.Power = Octal.Power + 1
            Else
               Error 130
            End If
         Next
      Case "B" ' binary suffix
         Temp# = False
         Binary.Power = False
         For Binary.Digit = Len(Strng) - 1 To 1 Step -1
            OutX$ = Mid$(Strng, Binary.Digit, 1)
            Select Case OutX$
               Case "0"
                  ' nul
               Case "1"
                  Temp# = Temp# + 2 ^ Binary.Power
               Case Else
                  Error 130
            End Select
            Binary.Power = Binary.Power + 1
         Next
      Case "0" To "9", "D", "E" ' decimal/exponent suffix
         Decimal = False
         Exponent = False
         Number$ = Strng
         Start.Token:
         For Decimal.Digit = 1 To Len(Number$)
            OutX$ = UCase$(Mid$(Number$, Decimal.Digit, 1))
            Select Case OutX$
               Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "+"
                  ' nul
               Case "D", "E"
                  If Exponent Then
                     Error 140
                  End If
                  Exponent = True
                  Exponent$ = UCase$(Right$(Number$, 1))
                  If Exponent$ = "D" Or Exponent$ = "E" Then
                     ' concatenate pre-parsed tokens into exponent
                     Unary$ = Mid$(Out2, Token.Index, 1)
                     If Unary$ = "+" Or Unary$ = "-" Then
                        ' check dual unary error
                        Unary2$ = Mid$(Out2, Token.Index + 1, 1)
                        If Unary2$ = "+" Or Unary2$ = "-" Then
                           Error 140
                           Exit Sub
                        End If
                        ' continue parsing
                        Var$ = Left$(Out2, Token.Index - 1)
                        Call Get.Token
                        Out2 = Var$ + Strng + Mid$(Out2, Token.Index)
                        Call Get.Token
                        If Strng = Nul Then
                           Error 140
                           Exit Sub
                        End If
                        Number$ = Number$ + Unary$ + Strng
                        If Strng = "-" Or Strng = "+" Then
                           Error 140
                           Exit Sub
                        End If
                        If InStr(Strng, ".") Then
                           Error 140
                           Exit Sub
                        End If
                        Do
                           If Left$(Number$, 1) = "-" Then
                              Number$ = Mid$(Number$, 2)
                           Else
                              If Left$(Number$, 1) = "+" Then
                                 Number$ = Mid$(Number$, 2)
                              Else
                                 Exit Do
                              End If
                           End If
                        Loop
                        Decimal = False
                        Exponent = False
                        GoTo Start.Token
                     Else
                        Error 140
                        Exit Sub
                     End If
                  End If
               Case "."
                  If Exponent Then
                     Error 140
                     Exit Sub
                  End If
                  If Decimal Then
                     Error 140
                     Exit Sub
                  End If
                  Decimal = True
               Case Else
                  Error 130
                  Exit Sub
            End Select
         Next
         Temp# = CDbl(Val(Number$))
   End Select
   Call Get.Token
   Last.Token = True
End Sub

' parse string in quotes
Sub Parse.Quoted
   Out3 = Nul
   Do Until Mid$(Out2, Token.Index, 1) = Quote
      Out3 = Out3 + Mid$(Out2, Token.Index, 1)
      Token.Index = Token.Index + 1
      If Token.Index > Len(Out2) Then
         Error 92
         Exit Do
      End If
   Loop
   Call Get.Token
   Call Get.Token
   Last.Token = False
End Sub

Rem entry to expression parser, each following parser is higher precedence,
Rem this routine called by higher precedence routines recursively.

Rem precedence of operators:
Rem   !, +, -  Not, Unary plus, Unary minus
Rem   <<, >>, --, ++, **, //  Dual unary
Rem   ^        Power
Rem   *, /     Multiplication, Division
Rem   \        Integer Division
Rem   %        Modulo
Rem   +, -     Addition, Subtraction
Rem   =, <, >, <>, >=, <=   Relational
Rem   |, &, ~, ?, :, #, @, `  Logical (or, and, xor, imp, eqv, nor, non, xan)

Sub Equate (Temp#)
   Last.Token = False
   Out3 = Nul ' reset string storage
   Out4 = Nul ' reset string concatenate storage
   Temp# = False ' reset result
   Token.Index = 1 ' reset pointer to expression token
   Call Get.Token ' read next token
   Call Parse1(Temp#) ' entry to parse the expression
   ' parse leftover tokens
   While Len(Strng)
      Call Parse1(X#)
      ' toss away any unwanted tokens
      If Last.Token = 3 Then
         Strng = "<extra token>"
         Error 92
      End If
   Wend
End Sub

' logical parser
Sub Parse1 (Temp#)
   Call Parse2(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "|", "&", "~", "?", ":", "#", "@", "`"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse2(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' relational parser
Sub Parse2 (Temp#)
   Call Parse3(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "<", ">", "=", ">=", "<=", "<>"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse3(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' addition/subtraction parser
Sub Parse3 (Temp#)
   Call Parse4(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "+", "-"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse4(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' modulo parser
Sub Parse4 (Temp#)
   Call Parse5(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "%"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse5(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' integer division parser
Sub Parse5 (Temp#)
   Call Parse6(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "\"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse6(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' multiplication/division parser
Sub Parse6 (Temp#)
   Call Parse7(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "*", "/"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse7(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' power parser
Sub Parse7 (Temp#)
   Call Parse7a(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "^"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse7a(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' dual-unary parser
Sub Parse7a (Temp#)
   Call Parse8(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "<<", ">>", "--", "++", "**", "//", "+++", "---"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' not/unary plus/unary negative parser
Sub Parse8 (Temp#)
   Token.Negate$ = Nul ' reset not/unary tokens
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "!", "-", "+", "--", "++", "---", "+++"
            ' Nul
         Case Else
            Exit Do
      End Select
      Call Get.Token ' read next token
      ' store combined not/unary tokens
      Token.Negate$ = Token.Negate$ + Token.Parsed$
      Token.Parsed$ = Strng
   Loop
   Call Parse9(Temp#) ' get next operator precedence
   ' process the combined operators in reverse
   For Token.Type = Len(Token.Negate$) To 1 Step -1
      Select Case Mid$(Token.Negate$, Token.Type, 1)
         Case "+"
            ' nul calculation for unary plus
         Case "-"
            Temp# = -Temp# ' perform negate
         Case "!" ' not
            Temp# = Not Temp# ' perform not calculation
      End Select
   Next
End Sub

' string/numeric expression parser,
' routine returns calculated expression string/value,
' calls Parse1 recursively for values inside parenthesis/functions.
Sub Parse9 (Temp#)
   Select Case Token ' determine token type
      Case 0 ' unknown token
         If Last.Token = 3 Then
            Strng = "<extra token>"
            Error 92
         End If
         If Strng = Nul Then
            Strng = "<missing token>"
         End If
         Error 92
         Last.Token = False
      Case 1 ' token is symbol
         Token.Parsed$ = Strng
         Select Case Token.Parsed$ ' determine token
            Case ",", ";" ' separaters
               Last.Token = 3
            Case Quote ' parse string
               Call Parse.Quoted
               Quotes = True
            Case "(" ' calculate opening parenthesis
               Call Get.Token ' read next token value inside parenthesis
               If Strng = ")" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> ")" Then
                  Do ' calculate value
                     Call Parse1(Temp#) ' call parse entry
                  Loop Until Strng = ")" Or Token = False ' check closing parenthesis
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call Get.Token ' read next token after parenthesis
            Case "["
               Call Get.Token
               If Strng = "]" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> "]" Then
                  Do
                     Call Parse1(Temp#)
                  Loop Until Strng = "]" Or Token = False
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call Get.Token
            Case "{"
               Call Get.Token
               If Strng = "}" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> "}" Then
                  Do
                     Call Parse1(Temp#)
                  Loop Until Strng = "}" Or Token = False
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call Get.Token
            Case ")", "]", "}" ' check token is closing parenthesis
               Strng = "<extra closing token>"
               Error 92
         End Select
      Case 2 ' token is numeric value
         Call Parse.Numeric(Temp#)
      Case 3 ' token type is alphabetic
         Select Case Len(Strng) ' check variable type
            Case 1
               Call Parse.Alphabetic1(Temp#)
            Case 2
               Call Parse.Alphabetic2(Temp#)
            Case Else
               Call Parse.Alphabetic3(Temp#)
         End Select
         Call Get.Token
   End Select
End Sub

' remove all white spaces, skip white spaces in quotes.
Sub Remove.Spaces
   Var$ = Out2
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(Var$) Then
         Exit Do
      End If
      If Mid$(Var$, Temp, 1) = Quote Then
         Do
            Temp = Temp + 1
            If Temp > Len(Var$) Then
               Exit Do
            End If
            If Mid$(Var$, Temp, 1) = Quote Then
               Exit Do
            End If
         Loop
      End If
      For Blanks = 1 To Len(White.Space)
         If Mid$(Var$, Temp, 1) = Mid$(White.Space, Blanks, 1) Then
            Var$ = Left$(Var$, Temp - 1) + Mid$(Var$, Temp + 1)
            Temp = Temp - 1
            Exit For
         End If
      Next
   Loop
   Out2 = Var$
End Sub

Sub MorePrompt (Input.String$, Input.Mask$, Output.String$)
   Color White, Black
   If Input.String$ = "-more-" Then
      Print Input.String$;
   Else
      Print Input.String$ + " ";
   End If
   Input.Char$ = Nul
   Locate , , 1
   Do
      Input.Char$ = INKEYz$
      If Len(Input.Char$) Then
         Input.Char$ = LCase$(Input.Char$)
         If InStr(Input.Mask$, Input.Char$) Then
            If Left$(Input.String$, 5) = "-more" Then
               Print
            Else
               If Input.Char$ = Chr$(13) Then
                  Print
               Else
                  Print Input.Char$
               End If
            End If
            Output.String$ = Input.Char$
            Exit Do
         End If
      End If
   Loop
   x = ClearKeyboard
End Sub

' input:  OutX$ - file to edit
'         VarC  - resume editing
' output: VarZ  - file save success

'Some edit functions:
' ctrl-a insert char
' ctrl-e RepeatFind
' ctrl-f Find
' ctrl-g Goto
' ctrl-k appendfile
' ctrl-l insertfile
' F1 - Help
' F2 - savefile
' F3 - repeatfind

' Alt-S SearchString
' Alt-S SearchByte
' Alt-S SearchReplace
' Alt-A AppendHexByte
' Alt-A AppendAsciiByte
' Alt-J JumpByte
' Alt-J JumpLine
' Alt-D HexScreenDump
' Alt-D HexFileDump
' Alt-P HexScreenPrint
' Alt-P HexFilePrint
' Alt-F CloseFile
' Alt-F ExitFile
' Alt-C AsciiChart
' Alt-C HexChart

Sub ScrnEdit (OutX$, VarZ, VarC)
   Dim ASCIIZ As String * 260

   ' array of file contents
   Static Temp.ArrayS() As String

   ' file handles
   Dim hfind As _Offset
   Dim Tempfile1 As Integer

   ' file declarations
   Static Filename As String
   Static LastSearch As Single
   Static SearchString As String
   Static SearchString2 As String
   Static Line.Number As Long
   Static Max.Lines As Long
   Static Max.File As Long
   Static Search As String
   Static Replace As String

   Dim Store.Line.Number As Long
   Dim Temp1 As Long

   Insert = -1
   If VarC Then
      OutX$ = Filename
   Else
      Filename = OutX$
   End If
   For V = Len(OutX$) To 1 Step -1
      If Mid$(OutX$, V, 1) = "\" Then
         OutX$ = Mid$(OutX$, V + 1)
         Exit For
      End If
   Next
   If Mid$(OutX$, 2, 1) = ":" Then
      OutX$ = Mid$(OutX$, 3)
   End If
   OutX$ = LCase$(OutX$)
   Mid$(OutX$, 1, 1) = UCase$(Mid$(OutX$, 1, 1))
   If VarC = 0 Then
      Max.Lines = False
      Max.File = Kilo
      ReDim Temp.ArrayS(Max.File) As String
      If OutX$ = "" Then
         VarZ = -3
         Exit Sub
      End If
      If ValidFileChar(OutX$) Then
         VarZ = -3
         Exit Sub
      End If
      If _FileExists(Filename) = 0 Then
         ' create file
         f$ = Filename + Chr$(0)
         hfind = CreateFileAqb(f$, 1)
         If hfind = 0 Then
            VarZ = -2
            Exit Sub
         End If
      Else
         Color Plain, Black
         Print "Loading file.."
         Tempfile1 = FreeFile
         Open Filename For Binary As #Tempfile1
         Count# = 0#
         Count2# = 0#
         Percent = 0
         Last.Percent = 0
         File.Size = LOF(Tempfile1)
         Control.Break = False
         If LOF(Tempfile1) > 0 Then
            Do Until EOF(Tempfile1)
               Line Input #Tempfile1, LineX$
               Count# = Count# + Len(LineX$) + 2#
               Max.Lines = Max.Lines + 1
               If Max.Lines >= SLong Then
                  File.Loaded = False
                  VarZ = -5
                  Erase Temp.ArrayS
                  _Title Program
                  Exit Sub
               End If
               If Max.Lines > Max.File Then
                  Max.File = Max.File + 1
                  ReDim _Preserve Temp.ArrayS(Max.File) As String
               End If
               Temp.ArrayS(Max.Lines) = LineX$
               GoSub Display.Percent
               If Control.Break Then
                  Control.Break = False
                  File.Loaded = False
                  VarZ = -4
                  _Title Program
                  Exit Sub
               End If
            Loop
            If Count# < LOF(Tempfile1) Then
               Max.Lines = Max.Lines + 1
               If Max.Lines > Max.File Then
                  Max.File = Max.File + 1
                  ReDim _Preserve Temp.ArrayS(Max.File) As String
               End If
               Temp.ArrayS(Max.Lines) = ""
            End If
         End If
         Close #Tempfile1
      End If
      VarX$ = UCase$(AmbiguateFile$(Filename))
      VarX$ = Program + " - EDIT - " + VarX$
      _Title VarX$
   End If
   UserProfileRecord.Reserved5 = UserProfileRecord.Reserved5 + 1&
   X = WriteUser
   Xcoor = 1
   Ycoor = 1
   Column = 1
   Row = 1
   If Max.Lines = 0 Then
      Line.Number = 0
   Else
      Line.Number = 1
   End If
   File.Loaded = -1
   StoreStatus = Status
   Status = -1
   ReDim _Preserve Temp.ArrayS(Max.File) As String
   GoSub Display.Screen
   Do
      Var# = CDbl(Line.Number)
      If Var# = 0# Then
         Var$ = " 0"
      Else
         Var$ = " " + FormatString$(Var#)
      End If

      V = Column + Ycoor - 1
      If V = 0 Then
         Var2$ = " 0"
      Else
         Var2$ = " " + FormatString$(CDbl(V))
      End If

      Strng = "Row" + Var$ + " Column" + Var2$
      If V > 0 And V <= Len(Temp.ArrayS(Line.Number)) Then
         V2 = Asc(Mid$(Temp.ArrayS(Line.Number), V, 1))
         Strng = Strng + " Ascii" + Str$(V2)

         Select Case V2 ' parse control codes
            Case 0
               Strng = Strng + " (nul)"
            Case 1
               Strng = Strng + " (soh)"
            Case 2
               Strng = Strng + " (stx)"
            Case 3
               Strng = Strng + " (etx)"
            Case 4
               Strng = Strng + " (eot)"
            Case 5
               Strng = Strng + " (enq)"
            Case 6
               Strng = Strng + " (ack)"
            Case 7
               Strng = Strng + " (bel)"
            Case 8
               Strng = Strng + " (bs)"
            Case 9
               Strng = Strng + " (tab)"
            Case 10
               Strng = Strng + " (lf)"
            Case 11
               Strng = Strng + " (vt)"
            Case 12
               Strng = Strng + " (np)"
            Case 13
               Strng = Strng + " (cr)"
            Case 14
               Strng = Strng + " (so)"
            Case 15
               Strng = Strng + " (si)"
            Case 16
               Strng = Strng + " (dle)"
            Case 17
               Strng = Strng + " (dc1)"
            Case 18
               Strng = Strng + " (dc2)"
            Case 19
               Strng = Strng + " (dc3)"
            Case 20
               Strng = Strng + " (dc4)"
            Case 21
               Strng = Strng + " (nak)"
            Case 22
               Strng = Strng + " (syn)"
            Case 23
               Strng = Strng + " (etb)"
            Case 24
               Strng = Strng + " (can)"
            Case 25
               Strng = Strng + " (em)"
            Case 26
               Strng = Strng + " (eof)"
            Case 27
               Strng = Strng + " (esc)"
            Case 28
               Strng = Strng + " (fs)"
            Case 29
               Strng = Strng + " (gs)"
            Case 30
               Strng = Strng + " (rs)"
            Case 31
               Strng = Strng + " (us)"
            Case 32
               Strng = Strng + " (spc)"
            Case 255
               Eat$ = ""
               ' Strng = Strng + " (" + CHR$(255) + ")"
            Case Else
               Strng = Strng + " (" + Chr$(V2) + ")"
         End Select
      End If
      Strng = Left$(Strng, 41)
      Strng = Strng + Space$(41 - Len(Strng))

      Locate 25, 1, 1
      Color White, BBlue
      Print Strng;

      Color White, Black
      Locate Xcoor + 1, Ycoor, 1
      Print "";
      If Insert Then
         Locate , , , 8, 8
      Else
         Locate , , , 0, 8
      End If
      Control.Break = False
      Monitor.Box = False
      Do
         ' check alt key press
         CurrentMenu = False
         Q& = _KeyHit
         If Q& = KEY_LALT& Then
            CurrentMenu = 1
            Call Menu2
            View Print 1 To 25
            GoSub Display.Screen
            If CurrentMenu = 0 Then
               Exit Do
            End If
         End If
         If Q& = KEY_RALT& Then
            CurrentMenu = 1
            Call Menu2
            View Print 1 To 25
            GoSub Display.Screen
            If CurrentMenu = 0 Then
               Exit Do
            End If
         End If

         ' check mouse activity
         Z = MouseDriver
         If MouseButton1 Then
            ' select drop down menu.
            If MouseX = 1 Then
               NewMenuSelection = 0
               Select Case MouseY
                  Case 1 To 3 ' cpu
                     CPUOFF = Not CPUOFF
                     If CPUOFF Then
                        Timer Off
                        _Title Program
                        Call DisplayToolBar
                     Else
                        Timer On
                        Call DisplayToolBar
                     End If
                  Case 74 To 78 ' about
                     Call HelpAbout
                  Case 6 To 9 ' File
                     NewMenuSelection = 1
                  Case 16 To 21 ' Charts
                     NewMenuSelection = 2
                  Case 26 To 29 ' Dump
                     NewMenuSelection = 3
                  Case 36 To 39 ' Edit
                     NewMenuSelection = 4
                  Case 46 To 49 ' Jump
                     NewMenuSelection = 5
                  Case 56 To 60 ' Print
                     NewMenuSelection = 6
                  Case 64 To 69 ' Search
                     NewMenuSelection = 7
               End Select
               If NewMenuSelection Then
                  CurrentMenu = NewMenuSelection
                  NewMenuSelection = 0
                  CurrentMenuSelection = 1
                  Call DropDownMenu(Var)
                  View Print 1 To 25
                  GoSub Display.Screen
                  If CurrentMenu = 0 Then
                     Exit Do
                  End If
               End If
            End If
         End If
         If CurrentMenu Then
            Select Case CurrentMenu
               Case 7 ' search
                  Select Case CurrentMenuSelection
                     Case 1 ' search string
                        GoSub SearchString
                     Case 2 ' search hex bytes
                        GoSub SearchHexString
                     Case 3 ' searchreplace
                        GoSub SearchReplace
                  End Select
               Case 4 ' append
                  Select Case CurrentMenuSelection
                     Case 1 ' append hex bytes
                        GoSub AppendHexBytes
                     Case 2 ' append ascii string
                        GoSub AppendAsciiBytes
                  End Select
               Case 5 ' jump
                  If CurrentMenuSelection = 1 Then ' jump to byte
                     If Max.Lines > 0 Then
                        GoSub Jump.Byte
                        If VarX Then
                           Line.Number = Count!
                           If Line.Number <= 23 Then
                              Xcoor = Line.Number
                           Else
                              Xcoor = 1
                           End If
                           Ycoor = 1
                           Column = 1
                        End If
                     End If
                     Color White, Black
                     GoSub Display.Screen
                  End If
                  If CurrentMenuSelection = 2 Then ' jump to line
                     If Max.Lines > 0 Then
                        GoSub Jump.Line
                        If VarX Then
                           Line.Number = Count!
                           If Line.Number <= 23 Then
                              Xcoor = Line.Number
                           Else
                              Xcoor = 1
                           End If
                           Ycoor = 1
                           Column = 1
                        End If
                     End If
                     Color White, Black
                     GoSub Display.Screen
                  End If
               Case 3
                  If CurrentMenuSelection = 1 Then ' hex screen dump
                     HexDump = -1
                     GoSub Screen.Dump
                  End If
                  If CurrentMenuSelection = 2 Then ' hex file dump
                     HexDump = -1
                     GoSub File.Dump
                  End If
               Case 6
                  If CurrentMenuSelection = 1 Then ' hex screen print
                     HexDump = -2
                     GoSub Screen.Print
                  End If
                  If CurrentMenuSelection = 2 Then ' hex file print
                     HexDump = -2
                     GoSub File.Print
                  End If
               Case 1
                  If CurrentMenuSelection = 2 Then ' close file
                     TempX$ = Chr$(27)
                  End If
                  If CurrentMenuSelection = 6 Then ' exit program
                     TempX$ = Chr$(27)
                  End If
               Case 2 ' chart
                  If CurrentMenuSelection = 1 Then ' ascii chart
                     View Print 2 To 24
                     Call SetKeys
                     Key On
                     Call AsciiChart
                     Key Off
                     Call ClearKeys
                     View Print 1 To 25
                     GoSub Display.Screen
                  End If
                  If CurrentMenuSelection = 2 Then ' hex chart
                     View Print 2 To 24
                     Call SetKeys
                     Key On
                     Call HexChart
                     Key Off
                     Call ClearKeys
                     View Print 1 To 25
                     GoSub Display.Screen
                  End If
            End Select
            Exit Do
         End If

         TempX$ = INKEYx$
         If TempX$ = Chr$(3) Then
            _Delay 1.2
         End If
         If Control.Break Then
            TempX$ = Nul
            Control.Break = False
            GoSub Display.Screen
            Exit Do
         End If
         If TempX$ <> "" Then
            Exit Do
         End If
      Loop
      Select Case Len(TempX$)
         Case 1
            Select Case TempX$
               Case Chr$(1) ' ctrl-a insert char
                  GoSub InsertAscii
               Case Chr$(5) ' ctrl-e RepeatFind
                  GoSub RepeatFind2
               Case Chr$(6) ' ctrl-f Find
                  GoSub Find
               Case Chr$(7) ' ctrl-g Goto
                  If Max.Lines > 0 Then
                     GoSub Jump.Line
                     If VarX Then
                        Line.Number = Count!
                        If Line.Number <= 23 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color White, Black
                  GoSub Display.Screen
               Case Chr$(11) ' ctrl-k append file
                  GoSub AppendFile
               Case Chr$(12) ' ctrl-l insert file
                  GoSub InsertFile
               Case Chr$(13) ' insert line
                  If Max.Lines = 0 Then ' init array
                     Line.Number = 1
                     Temp.ArrayS(1) = ""
                     Max.Lines = 1
                  Else
                     ' enter always extends array
                     If Max.Lines + 1 > Max.File Then
                        Max.File = Max.File + 1
                        ReDim _Preserve Temp.ArrayS(Max.File) As String
                     End If
                     If Max.Lines < Max.File Then
                        ' above
                        If Column + Ycoor - 1 = 1 Then
                           For Temp1 = Max.Lines To Line.Number Step -1
                              Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                           Next
                           Temp.ArrayS(Line.Number) = ""
                           Max.Lines = Max.Lines + 1
                           Line.Number = Line.Number + 1
                           If Xcoor < 23 Then
                              Xcoor = Xcoor + 1
                           End If
                        Else
                           ' below
                           If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then
                              Line.Number = Line.Number + 1 ' below
                              For Temp1 = Max.Lines To Line.Number Step -1
                                 Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                              Next
                              Temp.ArrayS(Line.Number) = ""
                              Max.Lines = Max.Lines + 1
                              If Xcoor < 23 Then
                                 Xcoor = Xcoor + 1
                              End If
                           Else
                              ' split line
                              For Temp1 = Max.Lines To Line.Number + 1 Step -1
                                 Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                              Next
                              T$ = Temp.ArrayS(Line.Number)
                              U$ = Mid$(T$, Column + Ycoor - 1)
                              T$ = Left$(T$, Column + Ycoor - 2)
                              Temp.ArrayS(Line.Number) = T$
                              Line.Number = Line.Number + 1 ' below
                              Temp.ArrayS(Line.Number) = U$
                              Max.Lines = Max.Lines + 1
                              If Xcoor < 23 Then
                                 Xcoor = Xcoor + 1
                              End If
                           End If
                        End If
                     End If
                  End If
                  ' enter always moves to 1,1
                  Column = 1
                  Ycoor = 1
                  GoSub Display.Screen
               Case Chr$(8) ' backspace
                  Q = Column + Ycoor - 1
                  If Line.Number <= 1 And Q <= 1 Then ' no backspace at 1,1
                     Eat$ = ""
                  Else
                     ' remove current line
                     If Temp.ArrayS(Line.Number) = "" Then
                        ' pack array
                        For Temp1 = Line.Number To Max.Lines - 1
                           Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                        Next
                        If Xcoor > 1 Then
                           Xcoor = Xcoor - 1
                        End If
                        Line.Number = Line.Number - 1
                        Max.Lines = Max.Lines - 1
                        ' position at eol
                        End.Line = Len(Temp.ArrayS(Line.Number))
                        If End.Line >= 80 Then
                           Column = End.Line - 78
                           Ycoor = End.Line - Column + 2
                        Else
                           Ycoor = End.Line - Column + 2
                        End If
                        GoSub Display.Screen
                     Else
                        ' concatenate previous line
                        If Column + Ycoor - 1 <= 1 Then
                           If Line.Number > 1 Then
                              If Line.Number <= Max.Lines Then
                                 Var = 0
                                 If Temp.ArrayS(Line.Number - 1) = "" Then
                                    If Ycoor = 1 Then
                                       Var = -1
                                    End If
                                 End If

                                 ' position at eol
                                 If Var = 0 Then
                                    End.Line = Len(Temp.ArrayS(Line.Number - 1))
                                 End If

                                 Temp.ArrayS(Line.Number - 1) = Temp.ArrayS(Line.Number - 1) + Temp.ArrayS(Line.Number)
                                 For Temp1 = Line.Number To Max.Lines - 1
                                    Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                                 Next
                                 If Xcoor > 1 Then
                                    Xcoor = Xcoor - 1
                                 End If
                                 Line.Number = Line.Number - 1
                                 Max.Lines = Max.Lines - 1
                                 Column = 1
                                 Ycoor = 1

                                 ' position at eol
                                 If Var = 0 Then
                                    If End.Line >= 80 Then
                                       Column = End.Line - 78
                                       Ycoor = End.Line - Column + 2
                                    Else
                                       Ycoor = End.Line - Column + 2
                                    End If
                                 End If

                                 GoSub Display.Screen
                              End If
                           End If
                        Else
                           ' backspace 1 character
                           If Column + Ycoor - 2 > False Then
                              T$ = Temp.ArrayS(Line.Number)
                              T$ = Left$(T$, Column + Ycoor - 3) + Mid$(T$, Column + Ycoor - 1)
                              Temp.ArrayS(Line.Number) = T$
                              ' move cursor 1 left
                              If Ycoor > 1 Then
                                 Ycoor = Ycoor - 1
                                 GoSub Display.Screen
                              Else
                                 If Column > 1 Then
                                    Column = Column - 1
                                    GoSub Display.Screen
                                 End If
                              End If
                           End If
                        End If
                     End If
                  End If
               Case Chr$(9) ' tab
                  If Column + Ycoor + (TabStop - 1) <= Len(Temp.ArrayS(Line.Number)) Then
                     If Ycoor + TabStop < 80 Then
                        Ycoor = Ycoor + TabStop
                     Else
                        Column = Column + TabStop
                        GoSub Display.Screen
                     End If
                  Else ' end
                     End.Line = Len(Temp.ArrayS(Line.Number))
                     If End.Line >= 80 Then
                        Column = End.Line - 78
                        Ycoor = End.Line - Column + 2
                        GoSub Display.Screen
                     Else
                        Ycoor = End.Line - Column + 2
                     End If
                  End If
               Case Chr$(27) ' escape, exit editor
                  VarX$ = "File: " + UCase$(AmbiguateFile$(Filename))
                  Quit = QuitBox2(VarX$) ' -1=yes, 1=no, 0=cancel
                  If Quit = -1 Then
                     Yes = -1
                     Exit Do
                  End If
                  If Quit = 1 Then
                     Yes = 0
                     Exit Do
                  End If
               Case Else ' insert character
                  If Max.Lines = 0 Then ' init array
                     Line.Number = 1
                     Temp.ArrayS(1) = TempX$
                     Max.Lines = 1
                     Ycoor = 2
                     Column = 1
                     GoSub Display.Screen
                  Else
                     T$ = Temp.ArrayS(Line.Number)
                     If Insert Then
                        T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
                     Else
                        If Column + Ycoor - 1 > Len(T$) Then
                           T$ = T$ + TempX$
                        Else
                           Mid$(T$, Column + Ycoor - 1, 1) = TempX$
                        End If
                     End If
                     Temp.ArrayS(Line.Number) = T$
                     If Ycoor < 80 Then
                        Ycoor = Ycoor + 1
                     Else
                        Column = Column + 1
                     End If
                     GoSub Display.Screen
                  End If
            End Select
         Case 2
            Temp = Asc(Mid$(TempX$, 2, 1))
            Select Case Temp
               Case 59 ' F1 - Help
                  X = HelpBox
               Case 60 ' F2 - savefile
                  If ErrorBox(" Savefile ", "Save file to disk?") Then
                     GoSub SaveFile
                     X = MessageBox(" Savefile ", "File saved to disk.")
                  End If
               Case 61 ' F3 - repeatfind
                  GoSub RepeatFind
               Case 62 ' F4 - appendfile
                  GoSub AppendFile
               Case 63 ' F5 - insertfile
                  GoSub InsertFile
               Case 15 ' shift-tab
                  If Column + Ycoor - TabStop > False Then
                     If Column + Ycoor - (TabStop - 1) > 1 Then
                        Ycoor = Ycoor - (TabStop - 1)
                     Else
                        If Column > TabStop Then
                           Column = Column - (TabStop - 1)
                           GoSub Display.Screen
                        End If
                     End If
                  Else ' home
                     If Column > 1 Then
                        Column = 1
                        Ycoor = 1
                        GoSub Display.Screen
                     Else
                        Column = 1
                        Ycoor = 1
                     End If
                  End If
               Case 83, 147 ' delete/control-delete
                  If Line.Number > 0 Then
                     ' remove line
                     If Temp.ArrayS(Line.Number) = "" Then
                        If Line.Number = 1 And Max.Lines = 1 Then
                           Line.Number = 0
                           Max.Lines = 0
                           GoSub Display.Screen
                        Else
                           ' pack array
                           For Temp1 = Line.Number To Max.Lines - 1
                              Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                           Next
                           If Line.Number = Max.Lines Then
                              Line.Number = Line.Number - 1
                              If Xcoor > 1 Then
                                 Xcoor = Xcoor - 1
                              End If
                           End If
                           Max.Lines = Max.Lines - 1
                           Column = 1
                           Ycoor = 1
                           GoSub Display.Screen
                        End If
                     Else
                        ' concatenate line
                        If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then
                           If Line.Number + 1 <= Max.Lines Then
                              T$ = Temp.ArrayS(Line.Number)
                              T$ = T$ + Temp.ArrayS(Line.Number + 1)
                              Temp.ArrayS(Line.Number) = T$

                              ' pack array
                              For Temp1 = Line.Number + 1 To Max.Lines - 1
                                 Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                              Next
                              Max.Lines = Max.Lines - 1
                              GoSub Display.Screen
                           End If
                        Else
                           ' delete character
                           T$ = Temp.ArrayS(Line.Number)
                           T$ = Left$(T$, Column + Ycoor - 2) + Mid$(T$, Column + Ycoor)
                           Temp.ArrayS(Line.Number) = T$
                           GoSub Display.Screen
                        End If
                     End If
                  End If
               Case 71 ' home
                  If Column > 1 Then
                     Column = 1
                     Ycoor = 1
                     GoSub Display.Screen
                  Else
                     Column = 1
                     Ycoor = 1
                  End If
               Case 79 ' end
                  End.Line = Len(Temp.ArrayS(Line.Number))
                  If End.Line >= 80 Then
                     Column = End.Line - 78
                     Ycoor = End.Line - Column + 2
                     GoSub Display.Screen
                  Else
                     Ycoor = End.Line - Column + 2
                  End If
               Case 75, 155 ' left/alt-left
                  If Ycoor > 1 Then
                     Ycoor = Ycoor - 1
                  Else
                     If Column > 1 Then
                        Column = Column - 1
                        GoSub Display.Screen
                     End If
                  End If
               Case 77, 157 ' right/alt-right
                  If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                     If Ycoor < 80 Then
                        Ycoor = Ycoor + 1
                     Else
                        Column = Column + 1
                        GoSub Display.Screen
                     End If
                  End If
               Case 72, 141, 152 ' up/ctrl-up/alt-up
                  Var = False
                  If Line.Number > 1 Then
                     Line.Number = Line.Number - 1
                     If Xcoor = 1 Then
                        Var = -1
                     Else
                        Xcoor = Xcoor - 1
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     If Var Then
                        GoSub Display.Screen
                     End If
                  End If
               Case 80, 145, 160 ' down/ctrl-dn/alt-dn
                  Var = False
                  If Line.Number < Max.Lines Then
                     Line.Number = Line.Number + 1
                     If Xcoor >= 23 Then
                        Var = -1
                     Else
                        Xcoor = Xcoor + 1
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     If Var Then
                        GoSub Display.Screen
                     End If
                  End If
               Case 73, 132 ' pageup/ctrl-pageup
                  If Line.Number > 1 Then
                     If Line.Number - 22 > 1 Then
                        Line.Number = Line.Number - 22
                     Else
                        Line.Number = 1
                     End If
                     Xcoor = 1
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     GoSub Display.Screen
                  End If
               Case 81, 118 ' pagedown/ctrl-pagedn
                  If Line.Number < Max.Lines Then
                     If Line.Number + 22 < Max.Lines Then
                        Line.Number = Line.Number + 22
                        Xcoor = 1
                     Else
                        Line.Number = Max.Lines
                        If Max.Lines < 22 Then
                           Xcoor = Max.Lines
                        Else
                           Xcoor = 22
                        End If
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     GoSub Display.Screen
                  End If
               Case 82 ' insert
                  Insert = Not Insert
                  If Insert Then
                     Locate , , , 8, 8
                  Else
                     Locate , , , 0, 8
                  End If
               Case 116 ' control-right
                  If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then ' eol
                     If Line.Number + 1 <= Max.Lines Then
                        Line.Number = Line.Number + 1
                        If Xcoor = 22 Then
                           Var = -1
                        Else
                           Xcoor = Xcoor + 1
                        End If
                        Ycoor = 1
                        Column = 1
                        GoSub Display.Screen
                     End If
                  Else
                     P = 0
                     For Temp2 = Column + Ycoor - 1 To Len(Temp.ArrayS(Line.Number))
                        P = P + 1
                        If Mid$(Temp.ArrayS(Line.Number), Temp2, 1) = " " Then
                           If Mid$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " Then
                              Exit For
                           End If
                        End If
                     Next
                     'shift right
                     For Var3 = 1 To P
                        If Ycoor < 80 Then
                           Ycoor = Ycoor + 1
                        Else
                           Column = Column + 1
                        End If
                     Next
                     GoSub Display.Screen
                  End If
               Case 115 ' control-left
                  If Column + Ycoor - 1 <= 1 Then
                     If Line.Number > 1 Then
                        Line.Number = Line.Number - 1
                        If Xcoor = 1 Then
                           Var = -1
                        Else
                           Xcoor = Xcoor - 1
                        End If
                        End.Line = Len(Temp.ArrayS(Line.Number))
                        If End.Line >= 80 Then
                           Column = End.Line - 78
                           Ycoor = End.Line - Column + 2
                        Else
                           Ycoor = End.Line - Column + 2
                        End If
                        GoSub Display.Screen
                     End If
                  Else
                     P = 0
                     V = 0
                     For Temp2 = Column + Ycoor - 3 To 1 Step -1
                        P = P + 1
                        If Mid$(Temp.ArrayS(Line.Number), Temp2, 1) = " " Then
                           If Mid$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " Then
                              V = -1
                              Exit For
                           End If
                        End If
                     Next
                     If V = 0 Then
                        P = P + 1
                     End If
                     ' shift left
                     For Var3 = 1 To P
                        If Ycoor > 1 Then
                           Ycoor = Ycoor - 1
                        Else
                           If Column > 1 Then
                              Column = Column - 1
                           End If
                        End If
                     Next
                     GoSub Display.Screen
                  End If
               Case 119 ' control-home
                  If Max.Lines > 0 Then
                     Line.Number = 1
                     Xcoor = 1
                     Ycoor = 1
                     Column = 1
                     GoSub Display.Screen
                  End If
               Case 117 ' control-end
                  If Max.Lines > 0 Then
                     Line.Number = Max.Lines
                     If Max.Lines < 22 Then
                        Xcoor = Max.Lines
                     Else
                        Xcoor = 22
                     End If
                     Ycoor = 1
                     Column = 1
                     GoSub Display.Screen
                  End If
            End Select
      End Select
   Loop
   Color White, BBlue
   Locate 25, 1
   VarZ = 0
   If Yes Then
      GoSub SaveFile
      VarZ = -1
   End If
   UserProfileRecord.ASCIIZreserved2 = Filename ' last file edited
   X = WriteUser
   Status = StoreStatus
   If CurrentMenu = 1 And CurrentMenuSelection = 6 Then
      If QuitBox Then
         Call WriteConfig
         Call WriteProfile
         Call PutUserStats(V#)
         Color Plain, Black
         System
      End If
   End If
   Exit Sub

   AppendAsciiBytes:
   VarA$ = AppendBox$(2)
   If Len(VarA$) Then
      ' append always extends array
      If Max.Lines + 1 > Max.File Then
         Max.File = Max.File + 1
         ReDim _Preserve Temp.ArrayS(Max.File) As String
      End If
      ' append line to eof
      Max.Lines = Max.Lines + 1
      Temp.ArrayS(Max.Lines) = VarA$
      ' control-end
      Line.Number = Max.Lines
      If Max.Lines < 22 Then
         Xcoor = Max.Lines
      Else
         Xcoor = 22
      End If
      Ycoor = 1
      Column = 1
      GoSub Display.Screen
   End If
   Return

   AppendHexBytes:
   VarA$ = AppendBox$(1)
   If Len(VarA$) Then
      Call CheckHexBytes(VarA$)
      If ValidByteString = 0 Then
         QZ = MessageBox(" Error ", "Invalid HEX byte string.")
      Else
         VarB$ = ""
         Do
            VarB$ = VarB$ + Chr$(Val("&H" + Left$(VarA$, 2)))
            VarA$ = Mid$(VarA$, 3)
            If VarA$ = "" Then
               Exit Do
            End If
         Loop
         ' append always extends array
         If Max.Lines + 1 > Max.File Then
            Max.File = Max.File + 1
            ReDim _Preserve Temp.ArrayS(Max.File) As String
         End If
         ' append line to eof
         Max.Lines = Max.Lines + 1
         Temp.ArrayS(Max.Lines) = VarB$
         ' control-end
         Line.Number = Max.Lines
         If Max.Lines < 22 Then
            Xcoor = Max.Lines
         Else
            Xcoor = 22
         End If
         Ycoor = 1
         Column = 1
         GoSub Display.Screen
      End If
   End If
   Return

   SearchReplace:
   If Max.Lines > 0 Then
      X = SearchBox2(Search$, Replace$)
      If X = 1 Then ' replace
         ' store current screen
         Store1 = Xcoor
         Store2 = Ycoor
         Store3 = Column
         Store! = Line.Number
         ' start replace
         Count! = 0!
         Count2& = 0&
         If Len(Search$) Then
            For X! = Store! To Max.Lines
               S1 = 1
               Text$ = Temp.ArrayS(X!)
               Do
                  If SensitiveSelect Then
                     P1 = InStr(S1, Text$, Search$)
                  Else
                     P1 = InStr(S1, UCase$(Text$), UCase$(Search$))
                  End If
                  If P1 Then
                     ' jump to line
                     Ycoor = 1
                     Column = 1
                     Line.Number = X!
                     If Line.Number <= 23 Then
                        Xcoor = Line.Number
                     Else
                        Xcoor = 1
                     End If
                     ' display screen
                     Color White, Black
                     GoSub Display.Screen
                     ' move right until search fits
                     ScreenWidth = 80
                     If P1 + Len(Search$) < ScreenWidth Then
                        If Len(Search$) < ScreenWidth Then
                           Locate Xcoor + 1, P1
                           Color Scolor, Scolor2
                           Var1$ = Mid$(Text$, P1, Len(Search$))
                           Print Var1$;
                           Color White, Black
                        End If
                     Else
                        If Len(Search$) < ScreenWidth Then
                           Do
                              If Column + Ycoor + 1 < P1 + Len(Search$) Then
                                 If Ycoor < ScreenWidth Then
                                    Ycoor = Ycoor + 1
                                 Else
                                    Column = Column + 1
                                 End If
                              Else
                                 Exit Do
                              End If
                           Loop
                           ' decrease until display search fits in line
                           Do Until Ycoor + Len(Search$) < ScreenWidth
                              Ycoor = Ycoor - 1
                           Loop
                           ' check display search at end of line
                           If Ycoor + Len(Search$) <= ScreenWidth Then
                              GoSub Display.Screen
                              Locate Xcoor + 1, Ycoor, 1
                              Color Scolor, Scolor2
                              Var1$ = Mid$(Text$, P1, Len(Search$))
                              Print Var1$;
                              Color White, Black
                           End If
                        End If
                     End If
                     ' make box bounce
                     If Xcoor < 10 Then
                        Q = 12
                     Else
                        Q = 2
                     End If
                     ' z=-1 replace, z=1 skip
                     Z = ReplaceBox(Q, X!)
                     If Z = 0 Then ' cancel
                        Exit For
                     End If
                     If Z = -1 Then
                        Text$ = Left$(Text$, P1 - 1) + Replace$ + Mid$(Text$, P1 + Len(Search$))
                        Temp.ArrayS(X!) = Text$
                        Count! = Count! + 1!
                        Count2& = Count2& + Len(Search$)
                     End If
                  Else
                     Exit Do
                  End If
                  S1 = P1 + Len(Replace$)
               Loop
            Next
         End If
         ' restore current screen
         Xcoor = Store1
         Ycoor = Store2
         Column = Store3
         Line.Number = Store!
         Color White, Black
         GoSub Display.Screen
         ' display replacements
         If Count! = 0! Then
            Z = MessageBox(" Search ", "Text not found.")
         Else
            Z = MessageBox(" Replaced ", Str$(Count!) + " strings.|" + Str$(Count2&) + " bytes.")
         End If
      End If
      If X = 2 Then ' replaceall
         Count! = 0!
         Count2& = 0&
         If Len(Search$) Then
            For X! = 1! To Max.Lines
               Text$ = Temp.ArrayS(X!)
               Flag = 0
               S1 = 1
               Do
                  If SensitiveSelect Then
                     P1 = InStr(S1, Text$, Search$)
                  Else
                     P1 = InStr(S1, UCase$(Text$), UCase$(Search$))
                  End If
                  If P1 Then
                     Flag = -1
                     Text$ = Left$(Text$, P1 - 1) + Replace$ + Mid$(Text$, P1 + Len(Search$))
                     Count! = Count! + 1!
                  Else
                     Exit Do
                  End If
                  S1 = P1 + Len(Replace$)
               Loop
               If Flag Then
                  Temp.ArrayS(X!) = Text$
                  Count2& = Count2& + Len(Search$)
               End If
            Next
         End If
         Color White, Black
         GoSub Display.Screen
         If Count! = 0! Then
            Z = MessageBox(" Search ", "Text not found.")
         Else
            Z = MessageBox(" Replaced ", Str$(Count!) + " strings.|" + Str$(Count2&) + " bytes.")
         End If
      End If
   End If
   Return

   SearchHexString:
   If Max.Lines > 0 Then
      X$ = SearchString2$
      X = SearchBox(X$, 1)
      If X Then
         If Len(X$) Then
            Call CheckHexBytes2(X$)
            If ValidByteString = 0 Then
               QZ = MessageBox(" Error ", "Invalid HEX byte string.")
            Else
               SearchString2$ = X$
               Flag = 0
               S! = Line.Number
               For X! = S! To Max.Lines
                  If WildcardSelect Then
                     Call InstrSUB1(Flag, X$, Temp.ArrayS(X!), SensitiveSelect)
                  Else
                     If SensitiveSelect Then
                        S$ = Temp.ArrayS(X!)
                     Else
                        S$ = UCase$(Temp.ArrayS(X!))
                        X$ = UCase$(X$)
                     End If
                     Flag = InStr(S$, X$)
                  End If
                  If Flag Then
                     Line.Number = X!
                     If Line.Number <= 23 Then
                        Xcoor = Line.Number
                     Else
                        Xcoor = 1
                     End If
                     Ycoor = 1
                     Column = 1
                     LastSearch = X!
                     Exit For
                  End If
               Next
               If Flag = 0 Then
                  For X! = 1! To S!
                     If WildcardSelect Then
                        Call InstrSUB1(Flag, X$, Temp.ArrayS(X!), SensitiveSelect)
                     Else
                        If SensitiveSelect Then
                           S$ = Temp.ArrayS(X!)
                        Else
                           S$ = UCase$(Temp.ArrayS(X!))
                           X$ = UCase$(X$)
                        End If
                        Flag = InStr(S$, X$)
                     End If
                     If Flag Then
                        Line.Number = X!
                        If Line.Number <= 23 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                        LastSearch = X!
                        Exit For
                     End If
                  Next
               End If
               If Flag = 0 Then
                  X = MessageBox(" Search ", "Text not found.")
               End If
            End If
            Color White, Black
            GoSub Display.Screen
         End If
      End If
   End If
   Return

   SearchString:
   If Max.Lines > 0 Then
      X$ = SearchString$
      X = SearchBox(X$, 2)
      If X Then
         If Len(X$) Then
            SearchString$ = X$
            Flag = 0
            S! = Line.Number
            For X! = S! To Max.Lines
               If WildcardSelect Then
                  Call InstrSUB1(Flag, X$, Temp.ArrayS(X!), SensitiveSelect)
               Else
                  If SensitiveSelect Then
                     S$ = Temp.ArrayS(X!)
                  Else
                     S$ = UCase$(Temp.ArrayS(X!))
                     X$ = UCase$(X$)
                  End If
                  Flag = InStr(S$, X$)
               End If
               If Flag Then
                  Line.Number = X!
                  If Line.Number <= 23 Then
                     Xcoor = Line.Number
                  Else
                     Xcoor = 1
                  End If
                  Ycoor = 1
                  Column = 1
                  LastSearch = X!
                  Exit For
               End If
            Next
            If Flag = 0 Then
               For X! = 1! To S!
                  If WildcardSelect Then
                     Call InstrSUB1(Flag, X$, Temp.ArrayS(X!), SensitiveSelect)
                  Else
                     If SensitiveSelect Then
                        S$ = Temp.ArrayS(X!)
                     Else
                        S$ = UCase$(Temp.ArrayS(X!))
                        X$ = UCase$(X$)
                     End If
                     Flag = InStr(S$, X$)
                  End If
                  If Flag Then
                     Line.Number = X!
                     If Line.Number <= 23 Then
                        Xcoor = Line.Number
                     Else
                        Xcoor = 1
                     End If
                     Ycoor = 1
                     Column = 1
                     LastSearch = X!
                     Exit For
                  End If
               Next
            End If
            If Flag = 0 Then
               X = MessageBox(" Search ", "Text not found.")
            End If
         End If
      End If
      Color White, Black
      GoSub Display.Screen
   End If
   Return

   Find:
   If Max.Lines > 0 Then
      Color White, BBlue
      Locate 25, 1
      Strng = Space$(41)
      Print Strng;
      Locate 25, 1
      Strng = "Enter search string: "
      Print Strng;
      Color White, Black
      Locate 25, 22
      Print Space$(50);
      X$ = LineInput$(25, 22, 50)
      If Len(X$) Then
         SearchString = X$
         X$ = UCase$(X$)
         Start! = Line.Number
         Flag = 0
         For X! = Start! To Max.Lines
            If InStr(UCase$(Temp.ArrayS(X!)), X$) Then
               Line.Number = X!
               If Line.Number <= 23 Then
                  Xcoor = Line.Number
               Else
                  Xcoor = 1
               End If
               Ycoor = 1
               Column = 1
               LastSearch = X!
               Flag = -1
               Exit For
            End If
         Next
         If Flag = 0 Then
            For X! = 1! To Start!
               If InStr(UCase$(Temp.ArrayS(X!)), X$) Then
                  Line.Number = X!
                  If Line.Number <= 23 Then
                     Xcoor = Line.Number
                  Else
                     Xcoor = 1
                  End If
                  Ycoor = 1
                  Column = 1
                  LastSearch = X!
                  Flag = -1
                  Exit For
               End If
            Next
         End If
      End If
      Color White, Black
      GoSub Display.Screen
   End If
   Return

   InsertAscii:
   ' insert ascii character
   Ascii$ = AsciiBox$
   If Len(Ascii$) Then
      Ascii.Value = Int(Val(Ascii$))
      If Ascii.Value >= 0 And Ascii.Value <= 255 Then
         TempX$ = Chr$(Ascii.Value)
         If Max.Lines = 0 Then ' init array
            Line.Number = 1
            Temp.ArrayS(1) = TempX$
            Max.Lines = 1
            Ycoor = 2
            Column = 1
            GoSub Display.Screen
         Else
            T$ = Temp.ArrayS(Line.Number)
            If Insert Then
               T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
            Else
               If Column + Ycoor - 1 > Len(T$) Then
                  T$ = T$ + TempX$
               Else
                  Mid$(T$, Column + Ycoor - 1, 1) = TempX$
               End If
            End If
            Temp.ArrayS(Line.Number) = T$
            If Ycoor < 80 Then
               Ycoor = Ycoor + 1
            Else
               Column = Column + 1
            End If
            GoSub Display.Screen
         End If
      End If
   End If
   Return

   RepeatFind2:
   If Max.Lines > 0 Then
      X$ = SearchString$
      If Len(X$) Then
         X$ = UCase$(X$)
         Start! = Line.Number + 1!
         Flag = 0
         For X! = Start! To Max.Lines
            If InStr(UCase$(Temp.ArrayS(X!)), X$) Then
               Line.Number = X!
               If Line.Number <= 23 Then
                  Xcoor = Line.Number
               Else
                  Xcoor = 1
               End If
               Ycoor = 1
               Column = 1
               LastSearch = X!
               Flag = -1
               Exit For
            End If
         Next
         If Flag = 0 Then
            For X! = 1! To Start!
               If InStr(UCase$(Temp.ArrayS(X!)), X$) Then
                  Line.Number = X!
                  If Line.Number <= 23 Then
                     Xcoor = Line.Number
                  Else
                     Xcoor = 1
                  End If
                  Ycoor = 1
                  Column = 1
                  LastSearch = X!
                  Flag = -1
                  Exit For
               End If
            Next
         End If
      End If
      Color White, Black
      GoSub Display.Screen
   End If
   Return

   RepeatFind:
   If Max.Lines > 0 Then
      X$ = SearchString$
      X = 0
      If Len(X$) = 0 Then
         X = SearchBox(X$, 2)
         Start! = Line.Number
      Else
         X = -1
         Start! = Line.Number + 1!
      End If
      If X Then
         If Len(X$) Then
            SearchString$ = X$
            Flag = 0
            For X! = Start! To Max.Lines
               If WildcardSelect Then
                  Call InstrSUB1(Flag, X$, Temp.ArrayS(X!), SensitiveSelect)
               Else
                  If SensitiveSelect Then
                     S$ = Temp.ArrayS(X!)
                  Else
                     S$ = UCase$(Temp.ArrayS(X!))
                     X$ = UCase$(X$)
                  End If
                  Flag = InStr(S$, X$)
               End If
               If Flag Then
                  Line.Number = X!
                  If Line.Number <= 23 Then
                     Xcoor = Line.Number
                  Else
                     Xcoor = 1
                  End If
                  Ycoor = 1
                  Column = 1
                  LastSearch = X!
                  Exit For
               End If
            Next
            If Flag = 0 Then
               For X! = 1! To Start!
                  If WildcardSelect Then
                     Call InstrSUB1(Flag, X$, Temp.ArrayS(X!), SensitiveSelect)
                  Else
                     If SensitiveSelect Then
                        S$ = Temp.ArrayS(X!)
                     Else
                        S$ = UCase$(Temp.ArrayS(X!))
                        X$ = UCase$(X$)
                     End If
                     Flag = InStr(S$, X$)
                  End If
                  If Flag Then
                     Line.Number = X!
                     If Line.Number <= 23 Then
                        Xcoor = Line.Number
                     Else
                        Xcoor = 1
                     End If
                     Ycoor = 1
                     Column = 1
                     LastSearch = X!
                     Exit For
                  End If
               Next
            End If
            If Flag = 0 Then
               X = MessageBox(" Search ", "Text not found.")
            End If
         End If
      End If
      Color White, Black
      GoSub Display.Screen
   End If
   Return

   InsertFile:
   Store.Line.Number = Line.Number
   VarA$ = AppendBox$(3)
   VarA$ = LTrim$(RTrim$(VarA$))
   If Left$(VarA$, 1) = Quote And Right$(VarA$, 1) = Quote Then
      VarA$ = Left$(VarA$, Len(VarA$) - 1)
      VarA$ = Mid$(VarA$, 2)
   End If
   If Len(VarA$) Then
      If _FileExists(VarA$) Then
         Xcount1! = 0!
         Zcount1# = 0#
         f = FreeFile
         Open VarA$ For Input As #f
         Do Until EOF(f)
            Line Input #f, VarB$
            ' insert always extends array
            If Max.Lines + 1 > Max.File Then
               Max.File = Max.File + 1
               ReDim _Preserve Temp.ArrayS(Max.File) As String
            End If
            ' insert line to file array
            Max.Lines = Max.Lines + 1
            For Temp1 = Max.Lines - 1 To Line.Number Step -1
               Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
            Next
            Temp.ArrayS(Line.Number) = VarB$
            Line.Number = Line.Number + 1
            Xcount1! = Xcount1! + 1!
            Zcount1# = Zcount1# + CDbl(Len(VarB$))
         Loop
         Close #f
         ' restore screen
         Line.Number = Store.Line.Number
         Ycoor = 1
         Column = 1
         GoSub Display.Screen
         Xcount1$ = Str$(Xcount1!)
         Zcount1$ = Str$(Zcount1#)
         X = MessageBox(" InsertFile ", "Lines inserted:" + Xcount1$ + "|Bytes inserted:" + Zcount1$)
      Else
         X = MessageBox(" InsertFile ", "File not found.")
      End If
   End If
   Return

   AppendFile:
   VarA$ = AppendBox$(3)
   VarA$ = LTrim$(RTrim$(VarA$))
   If Left$(VarA$, 1) = Quote And Right$(VarA$, 1) = Quote Then
      VarA$ = Left$(VarA$, Len(VarA$) - 1)
      VarA$ = Mid$(VarA$, 2)
   End If
   If Len(VarA$) Then
      If _FileExists(VarA$) Then
         Xcount1! = 0!
         Zcount1# = 0#
         f = FreeFile
         Open VarA$ For Input As #f
         Do Until EOF(f)
            Line Input #f, VarB$
            ' append always extends array
            If Max.Lines + 1 > Max.File Then
               Max.File = Max.File + 1
               ReDim _Preserve Temp.ArrayS(Max.File) As String
            End If
            ' append line to eof
            Max.Lines = Max.Lines + 1
            Temp.ArrayS(Max.Lines) = VarB$
            Xcount1! = Xcount1! + 1!
            Zcount1# = Zcount1# + CDbl(Len(VarB$))
         Loop
         Close #f
         ' control-end
         Line.Number = Max.Lines
         If Max.Lines < 22 Then
            Xcoor = Max.Lines
         Else
            Xcoor = 22
         End If
         Ycoor = 1
         Column = 1
         GoSub Display.Screen
         Xcount1$ = Str$(Xcount1!)
         Zcount1$ = Str$(Zcount1#)
         X = MessageBox(" AppendFile ", "Lines appended:" + Xcount1$ + "|Bytes appended:" + Zcount1$)
      Else
         X = MessageBox(" AppendFile ", "File not found.")
      End If
   End If
   Return

   ' write edit array to disk.
   SaveFile:

   ' change filename attribute
   ASCIIZ = Filename$ + Chr$(0)
   AttrX& = GetFileAttributes(ASCIIZ)
   StoreAttr& = AttrX&
   AttrX& = AttrX& And Not &H1 ' remove read-only bit
   X = SetFileAttributes&(ASCIIZ, AttrX&)
   FileSize = 0
   Tempfile1 = FreeFile
   Open Filename For Output As #Tempfile1
   For Count! = 1! To Max.Lines
      Print #Tempfile1, Temp.ArrayS(Count!)
      FileSize = FileSize + Len(Temp.ArrayS(Count!)) + 2
      UserProfileRecord.Reserved7 = UserProfileRecord.Reserved7 + Len(Temp.ArrayS(Count!)) + 2
   Next
   X = WriteUser
   Close #Tempfile1

   ' restore filename attribute
   X = SetFileAttributes&(ASCIIZ, StoreAttr&)
   UserProfileRecord.ASCIIZreserved1 = Filename ' last file saved
   X = WriteUser
   Return

   ' dumps current screen in hex.
   Screen.Dump:
   If Max.Lines = 0 Then
      r = MessageBox(" Dump ", "No text found.")
      Return
   End If

   VarX$ = Dumpfile
   If VarX$ = "" Then
      r = MessageBox(" Dump ", "Error opening file.")
      Return
   End If

   Error.Flag = True
   DataError = False
   X = FreeFile
   Open VarX$ For Append As #X
   Error.Flag = False
   If DataError Then
      r = MessageBox(" Dump ", "Error opening file.")
      Return
   End If
   Count = 0
   Do
      Count = Count + 1
      If Count = 24 Then
         Exit Do
      End If
      If Count + Line.Number - Xcoor > Max.Lines Then
         Exit Do
      End If
   Loop
   Print #X, "Filedump: " + Filename + " lines" + Str$(Count) + "."
   Count = 0
   Do
      Count = Count + 1
      If Count = 24 Then
         Exit Do
      End If
      If Count + Line.Number - Xcoor > Max.Lines Then
         Exit Do
      End If
      Strng = Temp.ArrayS(Count + Line.Number - Xcoor)
      Strng2$ = ""
      For LineQ = 1 To Len(Strng)
         Strng2$ = Strng2$ + Right$("00" + Hex$(Asc(Mid$(Strng, LineQ, 1))), 2) + " "
      Next
      Print #X, Strng2$
   Loop
   Z$ = Deconcatenate$(Dumpfile)
   Close #X
   r = MessageBox(" Dump ", "Screen dumped to file:|" + Z$)
   Return

   ' print current screen in hex.
   Screen.Print:
   If Max.Lines = 0 Then
      r = MessageBox(" Print ", "No text found.")
      Return
   End If

   Strng2$ = ""
   Count = 0
   Do
      Count = Count + 1
      If Count = 24 Then
         Exit Do
      End If
      If Count + Line.Number - Xcoor > Max.Lines Then
         Exit Do
      End If
      Strng = Temp.ArrayS(Count + Line.Number - Xcoor)
      For LineQ = 1 To Len(Strng)
         Strng2$ = Strng2$ + Right$("00" + Hex$(Asc(Mid$(Strng, LineQ, 1))), 2) + " "
         If Len(Strng2$) >= 77 Then
            Exit For
         End If
      Next
      LPrint Strng2$
      Strng2$ = ""
   Loop
   LPrint Chr$(12);
   r = MessageBox(" Print ", "Screen printed.")
   Return

   ' dumps current file in hex.
   File.Dump:
   If Max.Lines = 0 Then
      r = MessageBox(" Dump ", "No text found.")
      Return
   End If

   VarX$ = Dumpfile
   If VarX$ = "" Then
      r = MessageBox(" Dump ", "Error opening file.")
      Return
   End If

   Error.Flag = True
   DataError = False
   X = FreeFile
   Open VarX$ For Append As #X
   Error.Flag = False
   If DataError Then
      r = MessageBox(" Dump ", "Error opening file.")
      Return
   End If
   Print #X, "Filedump: " + Filename + " maxlines" + Str$(Max.Lines) + "."
   For Count& = 1 To Max.Lines
      Strng = Temp.ArrayS(Count&)
      Strng2$ = ""
      For LineQ& = 1 To Len(Strng)
         Strng2$ = Strng2$ + Right$("00" + Hex$(Asc(Mid$(Strng, LineQ&, 1))), 2) + " "
      Next
      Print #X, Strng2$
   Next
   Close #X
   Z$ = Deconcatenate$(Dumpfile)
   r = MessageBox(" Dump ", "File dumped to file:|" + Z$)
   Return

   ' print current file in hex.
   File.Print:
   If Max.Lines = 0 Then
      r = MessageBox(" Print ", "No text found.")
      Return
   End If
   Strng2$ = ""
   For Count& = 1 To Max.Lines
      Strng = Temp.ArrayS(Count&)
      For LineQ& = 1 To Len(Strng)
         Strng2$ = Strng2$ + Right$("00" + Hex$(Asc(Mid$(Strng, LineQ&, 1))), 2) + " "
         If Len(Strng2$) >= 77 Then
            LPrint Strng2$
            Strng2$ = ""
         End If
      Next
   Next
   If Len(Strng2$) Then
      LPrint Strng2$
   End If
   LPrint Chr$(12);
   r = MessageBox(" Print ", "File printed.")
   Return

   ' display current edit screen
   Display.Screen:
   Color White, Black
   Cls
   Call Toolbar
   Locate 2, 1

   ' display edit lines
   Count = 0
   If Max.Lines = 0 Then
      Count = 1
   End If
   If Max.Lines > 0 Then
      Do
         Count = Count + 1
         If Count = 24 Then
            Exit Do
         End If
         If Count + Line.Number - Xcoor > Max.Lines Then
            Exit Do
         End If
         Locate Count + 1, 1
         Strng = Mid$(Temp.ArrayS(Count + Line.Number - Xcoor), Column)
         If Len(Strng) > 80 Then
            Strng = Left$(Strng, 80)
         End If
         Print Strng;
      Loop
   End If

   ' eof marker
   If Count < 24 Then
      Locate Count + 1, 1
      Color Green, Black
      Strng = "<end of file>"
      Print Strng;
   End If

   ' display filename
   Color White, BBlue
   Locate 25, 1
   Strng = Space$(80)
   Print Strng;
   Locate 25, 42
   VarX$ = UCase$(AmbiguateFile$(Filename))
   If Len(VarX$) > 30 Then
      VarX$ = Left$(VarX$, 27) + "..."
   End If
   Strng = "File: " + VarX$
   VarZ$ = " (Press F1 for Help)"
   If Len(Strng) + Len(VarZ$) + 42 < 80 Then
      Print Strng;
      Color Green
      Print VarZ$;
   Else
      Print Strng;
   End If
   Return

   Jump.Line:
   VarX$ = "File: " + UCase$(AmbiguateFile$(Filename))
   Var2$ = "Lines: " + FormatString$(Max.Lines)
   X$ = JumpBox(2, VarX$, Var2$)
   VarX = -1
   If Len(X$) = 0 Then
      VarX = 0
   Else
      If Len(X$) > 7 Then
         VarX = 0
      Else
         VarX = IsNumeric(X$)
      End If
   End If
   Count! = 0!
   If VarX Then
      If Val(X$) > 0 And Val(X$) <= Max.Lines Then
         Count! = Val(X$)
      Else
         VarX = 0
      End If
   End If
   Return

   Jump.Byte:
   ' count bytes in edit array
   X# = 0#
   For X! = 1 To Max.Lines
      X# = X# + Len(Temp.ArrayS(X!))
   Next
   VarX$ = "File: " + UCase$(AmbiguateFile$(Filename))
   Var2$ = "Bytes: " + FormatString$(X#)
   X$ = JumpBox(1, VarX$, Var2$)
   VarX = -1
   If Len(X$) = 0 Then
      VarX = 0
   Else
      If Len(X$) > 15 Then
         VarX = 0
      Else
         VarX = IsNumeric(X$)
      End If
   End If
   T# = 0#
   If VarX Then
      Count# = Val(X$)
      If Count# > 0 And Count# <= X# Then
         For Count! = 1 To Max.Lines
            If T# + Len(Temp.ArrayS(Count!)) >= Count# Then
               Exit For
            End If
            T# = T# + Len(Temp.ArrayS(Count!))
         Next
      Else
         VarX = 0
      End If
   End If
   Return

   ' display percentage scanned in title
   Display.Percent:
   If File.Size > 0 Then
      Count2# = Count2# + Len(LineX$) + 2
      If Count2# > File.Size Then
         Count2# = File.Size
      End If
      Percent = (Count2# / File.Size) * 100!
      Percent = Int(Percent)
      If Percent <> Last.Percent Then
         Last.Percent = Percent
         P$ = Right$(Str$(Percent + 1000%), 3) + "%"
         V$ = Program + " - EDIT - " + P$
         _Title V$
      End If
   End If
   Return
End Sub

Function ValidFileChar (Var$)
   V$ = "\/:*?<>|" + Quote
   ' trim trailing dots and spaces
   Do
      If Right$(Var$, 1) = "." Then
         Var$ = Left$(Var$, Len(Var$) - 1)
      Else
         If Right$(Var$, 1) = " " Then
            Var$ = Left$(Var$, Len(Var$) - 1)
         Else
            Exit Do
         End If
      End If
   Loop
   If Var$ = "" Then
      ValidFileChar = -1
      Exit Function
   End If
   For V = 1 To Len(Var$)
      Z = Asc(Mid$(Var$, V, 1))
      If Z >= 1 And Z <= 31 Then
         ValidFileChar = -1
         Exit Function
      End If
   Next
   For V = 1 To Len(Var$)
      If InStr(V$, Mid$(Var$, V, 1)) Then
         ValidFileChar = -1
         Exit Function
      End If
   Next
   ValidFileChar = 0
End Function

Function ValidFileChar2$ (Var$)
   V$ = "/<>|"
   If Var$ = "" Then
      ValidFileChar2$ = ""
      Exit Function
   End If
   For V = 1 To Len(Var$)
      Z = Asc(Mid$(Var$, V, 1))
      If Z >= 1 And Z <= 31 Then
         ValidFileChar2$ = ""
         Exit Function
      End If
   Next
   For V = 1 To Len(Var$)
      If InStr(V$, Mid$(Var$, V, 1)) Then
         ValidFileChar2$ = ""
         Exit Function
      End If
   Next
   ValidFileChar2$ = Var$
End Function

Function TestFile (Var$)
   ' process error
   DataError = 0
   Error.Flag = -1
   X = FreeFile
   Open Var$ For Random As #X
   Error.Flag = 0
   If DataError Then
      TestFile = 0
      Exit Function
   End If
   Close #X
   TestFile = -1
End Function

Function TestFile2 (Var$)
   ' process error
   DataError = 0
   Error.Flag = -1
   X = FreeFile
   Open Var$ For Input As #X
   Error.Flag = 0
   If DataError Then
      TestFile2 = 0
      Exit Function
   End If
   Close #X
   TestFile2 = -1
End Function

Function JumpBox$ (Var1, Var1$, Var2$)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen3

   ' declare jump box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   If JumpXcoor Then Xcoor3 = JumpXcoor
   If JumpYcoor Then Ycoor3 = JumpYcoor

   XC = Xcoor3 + 4
   YC = Ycoor3 + 8
   LC = 22
   If Var1 = 1 Then
      QZ = 15 ' double
   Else
      QZ = 7 ' single
   End If

   ' draw box
   BoxButton = 1
   GoSub DrawJumpBox

   ' init entry area position.
   Xposition1 = 1
   Xposition2 = 0

   ' display edit entry area.
   Insert = -1
   GoSub DisplayFileLine

   ' wait for keypress or mouse
   _KeyClear
   Control.Break = False
   Monitor.Box = False
   Do
      If Control.Break Or Monitor.Box Then
         Control.Break = False
         Monitor.Box = False
         GoSub ToggleInsert
      End If

      I$ = INKEYz$
      If Len(I$) Then
         Select Case Len(I$)
            Case 1
               Select Case UCase$(I$)
                  Case "O" ' ok
                     BoxButton = 1
                     Exit Do
                  Case "C" ' cancel
                     BoxButton = 2
                     Exit Do
                  Case Chr$(8) ' backspace
                     If Len(X$) Then
                        If Xposition2 > 0 Then
                           If Insert Then ' destructive backspace
                              X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                           End If
                           Xposition2 = Xposition2 - 1
                           If Xposition2 - LC <= Xposition1 Then
                              Xposition1 = Xposition1 - 1
                              If Xposition1 < 1 Then
                                 Xposition1 = 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 2
                     Exit Do
                  Case Chr$(9) ' tab
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawJumpBoxButtons
                     GoSub DisplayFileLine
                  Case Chr$(1) ' ctrl-a
                     BackGround8 = BackGround8 + 1
                     If BackGround8 = 8 Then
                        BackGround8 = 0
                     End If
                     GoSub DrawJumpBox
                  Case Chr$(2) ' ctrl-b
                     BackGround9 = BackGround9 + 1
                     If BackGround9 = 8 Then
                        BackGround9 = 0
                     End If
                     GoSub DrawJumpBox
                  Case Chr$(4) ' ctrl-d
                     JumpBoxBorderColor = JumpBoxBorderColor + 1
                     If JumpBoxBorderColor = 16 Then
                        JumpBoxBorderColor = 0
                     End If
                     GoSub DrawJumpBox
                  Case Chr$(5) ' ctrl-e
                     JumpBoxTitleColor = JumpBoxTitleColor + 1
                     If JumpBoxTitleColor = 16 Then
                        JumpBoxTitleColor = 0
                     End If
                     GoSub DrawJumpBox
                  Case Chr$(6) ' ctrl-f
                     JumpBoxTextColor = JumpBoxTextColor + 1
                     If JumpBoxTextColor = 16 Then
                        JumpBoxTextColor = 0
                     End If
                     GoSub DrawJumpBox
                  Case Chr$(7) ' ctrl-g
                     JumpBoxButton1Color = JumpBoxButton1Color + 1
                     If JumpBoxButton1Color = 16 Then
                        JumpBoxButton1Color = 0
                     End If
                     GoSub DrawJumpBox
                  Case Chr$(11) ' ctrl-k
                     JumpBoxButton2Color = JumpBoxButton2Color + 1
                     If JumpBoxButton2Color = 16 Then
                        JumpBoxButton2Color = 0
                     End If
                     GoSub DrawJumpBox
                  Case Else
                     ' append/insert character into edit area.
                     If I$ >= "0" And I$ <= "9" Then
                        If Insert Then
                           If Len(X$) < QZ Then
                              X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                              Xposition2 = Xposition2 + 1
                              If Xposition2 > LC Then
                                 Xposition1 = Xposition1 + 1
                              End If
                           End If
                        Else
                           If Xposition2 + 1 > Len(X$) Then
                              If Len(X$) < QZ Then
                                 X$ = X$ + I$ ' append
                                 Xposition2 = Xposition2 + 1
                                 If Xposition2 > LC Then
                                    Xposition1 = Xposition1 + 1
                                 End If
                              End If
                           Else ' insert
                              Mid$(X$, Xposition2 + 1, 1) = I$
                              Xposition2 = Xposition2 + 1
                           End If
                        End If
                        GoSub DisplayFileLine
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(I$, 1))
                  Case 82 ' Insert
                     Insert = Not Insert
                     If Insert Then
                        Locate , , 1, 8, 8 ' line cursor
                     Else
                        Locate , , 1, 0, 8 ' block cursor
                     End If
                  Case 83 ' Delete
                     If Len(X$) > 0 Then
                        X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                        GoSub DisplayFileLine
                     End If
                  Case 71 ' Home
                     If Xposition2 > 0 Then
                        Xposition1 = 1
                        Xposition2 = 0
                        GoSub DisplayFileLine
                     End If
                  Case 79 ' End
                     If Xposition2 < Len(X$) Then
                        Xposition2 = Len(X$)
                        Xposition1 = Xposition2 - LC + 1
                        If Xposition1 < 1 Then
                           Xposition1 = 1
                        End If
                        GoSub DisplayFileLine
                     End If
                  Case 75 ' Left
                     If Len(X$) Then
                        If Xposition2 > 0 Then
                           Xposition2 = Xposition2 - 1
                           If Xposition2 - LC <= Xposition1 Then
                              Xposition1 = Xposition1 - 1
                              If Xposition1 < 1 Then
                                 Xposition1 = 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case 77 ' Right
                     If Len(X$) Then
                        If Xposition2 < Len(X$) Then
                           Xposition2 = Xposition2 + 1
                           If Xposition2 > Xposition1 + LC - 1 Then
                              Xposition1 = Xposition1 + 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 15 ' shift-tab
                     If BoxButton = 2 Then
                        BoxButton = 1
                     Else
                        BoxButton = 2
                     End If
                     GoSub DrawJumpBoxButtons
                     GoSub DisplayFileLine
                  Case 76, 143 ' keypad-5 center
                     I$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen3
                     GoSub DrawJumpBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     I$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     I$ = ""
                     If Xcoor3 < 17 Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     I$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     I$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     I$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen3
                           GoSub DrawJumpBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     I$ = ""
                     If Xcoor3 < 13 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     Else
                        If Xcoor3 < 17 Then
                           Xcoor3 = 17
                           Call RestoreScreen3
                           GoSub DrawJumpBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     I$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen3
                           GoSub DrawJumpBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     I$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen3
                           GoSub DrawJumpBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= 17 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen3
                        GoSub DrawJumpBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 6 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
                  BoxButton = 2
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 6 Then
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
               If BoxButton = 2 Then
                  BoxButton = 1
                  GoSub DrawJumpBoxButtons
                  GoSub DisplayFileLine
               End If
            End If
            If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
               If BoxButton = 1 Then
                  BoxButton = 2
                  GoSub DrawJumpBoxButtons
                  GoSub DisplayFileLine
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen3
               GoSub DrawJumpBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 < 17 Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen3
               GoSub DrawJumpBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates
   JumpXcoor = Xcoor3
   JumpYcoor = Ycoor3

   ' restore screen area.
   Call RestoreScreen3
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then
      JumpBox = X$
   Else
      JumpBox = ""
   End If
   Locate , , 1, 8, 8
   _KeyClear
   Exit Function

   ' draw box
   DrawJumpBox:
   Color JumpBoxBorderColor, BackGround8
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);
   Color JumpBoxTitleColor
   Locate Xcoor3, Ycoor3 + 12, 0
   Print " Jump ";

   ' display jump text
   Color JumpBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 1, 0
   Print Var1$;
   Locate Xcoor3 + 2, Ycoor3 + 1, 0
   Print Var2$;
   Locate Xcoor3 + 3, Ycoor3 + 1, 0
   If Var1 = 1 Then
      Print "Enter byte in line to jump to:";
   Else
      Print "Enter line to jump to:";
   End If
   Locate Xcoor3 + 4, Ycoor3 + 1, 0
   Print "Entry: ";
   GoSub DrawJumpBoxButtons
   XC = Xcoor3 + 4
   YC = Ycoor3 + 8
   GoSub DisplayFileLine
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawJumpBoxButtons:
   If BoxButton = 1 Then
      Locate Xcoor3 + 6, Ycoor3 + 2, 0
      Color JumpBoxButton1Color, BackGround9
      Print "<OK>";
      Locate Xcoor3 + 6, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 6, Ycoor3 + 8, 0
      Color JumpBoxButton2Color, BackGround9
      Print "<Cancel>";
      Locate Xcoor3 + 6, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   Else
      Locate Xcoor3 + 6, Ycoor3 + 2, 0
      Color JumpBoxButton2Color, BackGround9
      Print "<OK>";
      Locate Xcoor3 + 6, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 6, Ycoor3 + 8, 0
      Color JumpBoxButton1Color, BackGround9
      Print "<Cancel>";
      Locate Xcoor3 + 6, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   End If
   Color Plain, Black
   Return

   ' display current entry area.
   DisplayFileLine:
   Locate XC, YC, 1
   Print Space$(LC);

   ' display edit line and position cursor.
   Locate XC, YC, 1
   If Len(X$) Then
      Color White
      If MaskInput Then
         LV = Len(Mid$(X$, Xposition1, LC))
         Print String$(LV, MaskChar$);
      Else
         Print Mid$(X$, Xposition1, LC);
      End If
   End If
   Locate XC, YC + Xposition2 - Xposition1 + 1, 1
   Color Plain, Black
   Return

   ToggleInsert:
   If Insert Then
      Locate , , 1, 8, 8 ' line cursor
   Else
      Locate , , 1, 0, 8 ' block cursor
   End If
   Return
End Function

Rem Append bytes:
Rem   Var1 = 1 - Hex
Rem   Var1 = 2 - Ascii
Rem   Var1 = 3 - Scrnedit
Function AppendBox$ (Var1)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   If Var1 = 3 Then
      Call SaveScreen2
   Else
      Call SaveScreen3
   End If

   ' declare append box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   If AppendXcoor Then Xcoor3 = AppendXcoor
   If AppendYcoor Then Ycoor3 = AppendYcoor

   XC = Xcoor3 + 4
   YC = Ycoor3 + 8
   LC = 22

   ' draw box
   BoxButton = 1
   GoSub DrawAppendBox

   ' init entry area position.
   Xposition1 = 1
   Xposition2 = 0

   ' display edit entry area.
   Insert = -1
   GoSub DisplayFileLine

   ' wait for keypress or mouse
   _KeyClear
   Control.Break = False
   Monitor.Box = False
   Do
      If Control.Break Or Monitor.Box Then
         Control.Break = False
         Monitor.Box = False
         GoSub ToggleInsert
      End If

      I$ = INKEYz$
      If Len(I$) Then
         Select Case Len(I$)
            Case 1
               Select Case UCase$(I$)
                  Case Chr$(8) ' backspace
                     If BoxButton = 1 Then
                        If Len(X$) Then
                           If Xposition2 > 0 Then
                              If Insert Then ' destructive backspace
                                 X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                              End If
                              Xposition2 = Xposition2 - 1
                              If Xposition2 - LC <= Xposition1 Then
                                 Xposition1 = Xposition1 - 1
                                 If Xposition1 < 1 Then
                                    Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case Chr$(13)
                     If BoxButton = 3 Then
                        BoxButton = 0
                     Else
                        BoxButton = -1
                     End If
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 0
                     Exit Do
                  Case Chr$(9) ' tab
                     BoxButton = BoxButton + 1
                     If BoxButton = 4 Then
                        BoxButton = 1
                     End If
                     If BoxButton = 1 Then
                        GoSub DrawAppendBoxButtons
                        GoSub DisplayFileLine
                     Else
                        GoSub DrawAppendBoxButtons
                     End If
                  Case Chr$(1) ' ctrl-a
                     BackGround12 = BackGround12 + 1
                     If BackGround12 = 8 Then
                        BackGround12 = 0
                     End If
                     GoSub DrawAppendBox
                  Case Chr$(2) ' ctrl-b
                     BackGround13 = BackGround13 + 1
                     If BackGround13 = 8 Then
                        BackGround13 = 0
                     End If
                     GoSub DrawAppendBox
                  Case Chr$(4) ' ctrl-d
                     AppendBoxBorderColor = AppendBoxBorderColor + 1
                     If AppendBoxBorderColor = 16 Then
                        AppendBoxBorderColor = 0
                     End If
                     GoSub DrawAppendBox
                  Case Chr$(5) ' ctrl-e
                     AppendBoxTitleColor = AppendBoxTitleColor + 1
                     If AppendBoxTitleColor = 16 Then
                        AppendBoxTitleColor = 0
                     End If
                     GoSub DrawAppendBox
                  Case Chr$(6) ' ctrl-f
                     AppendBoxTextColor = AppendBoxTextColor + 1
                     If AppendBoxTextColor = 16 Then
                        AppendBoxTextColor = 0
                     End If
                     GoSub DrawAppendBox
                  Case Chr$(7) ' ctrl-g
                     AppendBoxButton1Color = AppendBoxButton1Color + 1
                     If AppendBoxButton1Color = 16 Then
                        AppendBoxButton1Color = 0
                     End If
                     GoSub DrawAppendBox
                  Case Chr$(11) ' ctrl-k
                     AppendBoxButton2Color = AppendBoxButton2Color + 1
                     If AppendBoxButton2Color = 16 Then
                        AppendBoxButton2Color = 0
                     End If
                     GoSub DrawAppendBox
                  Case Else
                     If BoxButton = 2 Or BoxButton = 3 Then
                        If UCase$(I$) = "O" Then
                           BoxButton = -1
                           Exit Do
                        End If
                        If UCase$(I$) = "C" Then
                           BoxButton = 0
                           Exit Do
                        End If
                     End If
                     If BoxButton = 1 Then
                        ' append/insert character into edit area.
                        OK = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           If Var1 = 1 Then
                              OK = 0 ' disallow control charcters
                           End If
                        End If
                        If OK Then
                           If Insert Then
                              X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                              Xposition2 = Xposition2 + 1
                              If Xposition2 > LC Then
                                 Xposition1 = Xposition1 + 1
                              End If
                           Else
                              If Xposition2 + 1 > Len(X$) Then
                                 X$ = X$ + I$ ' append
                                 Xposition2 = Xposition2 + 1
                                 If Xposition2 > LC Then
                                    Xposition1 = Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X$, Xposition2 + 1, 1) = I$
                                 Xposition2 = Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(I$, 1))
                  Case 82 ' Insert
                     If BoxButton = 1 Then
                        Insert = Not Insert
                        If Insert Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                  Case 83 ' Delete
                     If Len(X$) > 0 Then
                        If BoxButton = 1 Then
                           X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 71 ' Home
                     If BoxButton = 1 Then
                        If Xposition2 > 0 Then
                           Xposition1 = 1
                           Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 79 ' End
                     If BoxButton = 1 Then
                        If Xposition2 < Len(X$) Then
                           Xposition2 = Len(X$)
                           Xposition1 = Xposition2 - LC + 1
                           If Xposition1 < 1 Then
                              Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 75 ' Left
                     If BoxButton = 1 Then
                        If Len(X$) Then
                           If Xposition2 > 0 Then
                              Xposition2 = Xposition2 - 1
                              If Xposition2 - LC <= Xposition1 Then
                                 Xposition1 = Xposition1 - 1
                                 If Xposition1 < 1 Then
                                    Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                  Case 77 ' Right
                     If BoxButton = 1 Then
                        If Len(X$) Then
                           If Xposition2 < Len(X$) Then
                              Xposition2 = Xposition2 + 1
                              If Xposition2 > Xposition1 + LC - 1 Then
                                 Xposition1 = Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case 15 ' shift-tab
                     BoxButton = BoxButton - 1
                     If BoxButton = 0 Then
                        BoxButton = 3
                     End If
                     If BoxButton = 1 Then
                        GoSub DrawAppendBoxButtons
                        GoSub DisplayFileLine
                     Else
                        GoSub DrawAppendBoxButtons
                     End If
                  Case 76, 143 ' keypad-5 center
                     I$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen3
                     GoSub DrawAppendBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     I$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawAppendBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     I$ = ""
                     If Xcoor3 < 17 Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawAppendBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     I$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawAppendBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     I$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawAppendBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     I$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawAppendBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen3
                           GoSub DrawAppendBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     I$ = ""
                     If Xcoor3 < 13 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawAppendBox
                     Else
                        If Xcoor3 < 17 Then
                           Xcoor3 = 17
                           Call RestoreScreen3
                           GoSub DrawAppendBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     I$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawAppendBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen3
                           GoSub DrawAppendBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     I$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawAppendBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen3
                           GoSub DrawAppendBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= 17 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        If Var1 = 3 Then
                           Call RestoreScreen2
                        Else
                           Call RestoreScreen3
                        End If
                        GoSub DrawAppendBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = XC Then
               ' entry area
               If MouseY >= YC And MouseY <= YC + LC Then
                  BoxButton = 1
                  GoSub DrawAppendBox
               End If
            End If
            If MouseX = Xcoor3 + 6 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = -1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
                  BoxButton = 0
                  Exit Do
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen3
               GoSub DrawAppendBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 < 17 Then
               Xcoor3 = Xcoor3 + 1
               If Var1 = 3 Then
                  Call RestoreScreen2
               Else
                  Call RestoreScreen3
               End If
               GoSub DrawAppendBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates
   AppendXcoor = Xcoor3
   AppendYcoor = Ycoor3

   ' restore screen area.
   If Var1 = 3 Then
      Call RestoreScreen2
   Else
      Call RestoreScreen3
   End If
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton Then
      AppendBox = X$
   Else
      AppendBox = ""
   End If
   Locate , , 1, 8, 8
   _KeyClear
   Exit Function

   ' draw box
   DrawAppendBox:
   Color AppendBoxBorderColor, BackGround12
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);
   Color AppendBoxTitleColor
   Locate Xcoor3, Ycoor3 + 11, 0
   Print " Append ";

   ' display append text
   Color AppendBoxTextColor
   Locate Xcoor3 + 2, Ycoor3 + 1, 0
   If Var1 = 1 Then
      Print "Enter HEX bytes";
   Else
      If Var1 = 2 Then
         Print "Enter ASCII string:";
      Else
         Print "Enter filename:";
      End If
   End If
   Locate Xcoor3 + 3, Ycoor3 + 1, 0
   If Var1 = 1 Then
      Print "  (space separated):";
   End If

   Locate Xcoor3 + 4, Ycoor3 + 1, 0
   Print "Entry: ";
   GoSub DrawAppendBoxButtons
   Locate , , , 8, 8
   XC = Xcoor3 + 4
   YC = Ycoor3 + 8
   GoSub DisplayFileLine
   Return

   ' display buttuns
   DrawAppendBoxButtons:
   If BoxButton = 2 Then
      Locate Xcoor3 + 6, Ycoor3 + 2, 0
      Color AppendBoxButton1Color, BackGround13
      Print "<OK>";
      Locate Xcoor3 + 6, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 6, Ycoor3 + 8, 0
      Color AppendBoxButton2Color, BackGround13
      Print "<Cancel>";
      Locate Xcoor3 + 6, Ycoor3 + 9, 0
      Color Magenta
      Print "C";

      Locate Xcoor3 + 6, Ycoor3 + 2, 1, 8, 8 ' line cursor
   Else
      If BoxButton = 3 Then
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color AppendBoxButton2Color, BackGround13
         Print "<OK>";
         Locate Xcoor3 + 6, Ycoor3 + 3, 0
         Color Magenta
         Print "O";

         Locate Xcoor3 + 6, Ycoor3 + 8, 0
         Color AppendBoxButton1Color, BackGround13
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 9, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 8, 1, 8, 8 ' line cursor
      Else
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color AppendBoxButton2Color, BackGround13
         Print "<OK>";
         Locate Xcoor3 + 6, Ycoor3 + 3, 0
         Color Magenta
         Print "O";

         Locate Xcoor3 + 6, Ycoor3 + 8, 0
         Color AppendBoxButton2Color, BackGround13
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 9, 0
         Color Magenta
         Print "C";
      End If
   End If
   Color Plain, Black
   Return

   ' display current entry area.
   DisplayFileLine:
   Locate XC, YC, 1
   Print Space$(LC);

   ' display edit line and position cursor.
   Locate XC, YC, 1
   If Len(X$) Then
      Color White
      If MaskInput Then
         LV = Len(Mid$(X$, Xposition1, LC))
         Print String$(LV, MaskChar$);
      Else
         Print Mid$(X$, Xposition1, LC);
      End If
   End If
   Locate XC, YC + Xposition2 - Xposition1 + 1, 1
   Color Plain, Black
   If Insert Then
      Locate , , 1, 8, 8 ' line cursor
   Else
      Locate , , 1, 0, 8 ' block cursor
   End If
   Return

   ToggleInsert:
   If Insert Then
      Locate , , 1, 8, 8 ' line cursor
   Else
      Locate , , 1, 0, 8 ' block cursor
   End If
   Return
End Function

Function FilenameBox$ (Var1)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   ' declare append box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   If FilenameXcoor Then Xcoor3 = FilenameXcoor
   If FilenameYcoor Then Ycoor3 = FilenameYcoor

   ' adjust xcoor
   If Status Then
      Z = 23
      If Xcoor3 + 7 > Z Then
         Xcoor3 = Xcoor3 - 1
      End If
   End If

   XC = Xcoor3 + 4
   YC = Ycoor3 + 8
   LC = 22

   ' draw box
   BoxButton = 1
   GoSub DrawFilenameBox

   ' init entry area position.
   Xposition1 = 1
   Xposition2 = 0

   ' display edit entry area.
   Insert = -1
   GoSub DisplayFileLine

   ' wait for keypress or mouse
   _KeyClear
   Control.Break = False
   Monitor.Box = False
   Do
      If Control.Break Or Monitor.Box Then
         Control.Break = False
         Monitor.Box = False
         GoSub ToggleInsert
      End If

      I$ = INKEYz$
      If Len(I$) Then
         Select Case Len(I$)
            Case 1
               Select Case UCase$(I$)
                  Case Chr$(8) ' backspace
                     If BoxButton = 1 Then
                        If Len(X$) Then
                           If Xposition2 > 0 Then
                              If Insert Then ' destructive backspace
                                 X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                              End If
                              Xposition2 = Xposition2 - 1
                              If Xposition2 - LC <= Xposition1 Then
                                 Xposition1 = Xposition1 - 1
                                 If Xposition1 < 1 Then
                                    Xposition1 = 1
                                 End If
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case Chr$(13)
                     If BoxButton = 3 Then
                        BoxButton = 0
                     Else
                        BoxButton = -1
                     End If
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 0
                     Exit Do
                  Case Chr$(9) ' tab
                     BoxButton = BoxButton + 1
                     If BoxButton = 4 Then
                        BoxButton = 1
                     End If
                     If BoxButton = 1 Then
                        GoSub DrawFilenameBoxButtons
                        GoSub DisplayFileLine
                     Else
                        GoSub DrawFilenameBoxButtons
                     End If
                  Case Chr$(1) ' ctrl-a
                     BackGround14 = BackGround14 + 1
                     If BackGround14 = 8 Then
                        BackGround14 = 0
                     End If
                     GoSub DrawFilenameBox
                  Case Chr$(2) ' ctrl-b
                     BackGround15 = BackGround15 + 1
                     If BackGround15 = 8 Then
                        BackGround15 = 0
                     End If
                     GoSub DrawFilenameBox
                  Case Chr$(4) ' ctrl-d
                     FilenameBoxBorderColor = FilenameBoxBorderColor + 1
                     If FilenameBoxBorderColor = 16 Then
                        FilenameBoxBorderColor = 0
                     End If
                     GoSub DrawFilenameBox
                  Case Chr$(5) ' ctrl-e
                     FilenameBoxTitleColor = FilenameBoxTitleColor + 1
                     If FilenameBoxTitleColor = 16 Then
                        FilenameBoxTitleColor = 0
                     End If
                     GoSub DrawFilenameBox
                  Case Chr$(6) ' ctrl-f
                     FilenameBoxTextColor = FilenameBoxTextColor + 1
                     If FilenameBoxTextColor = 16 Then
                        FilenameBoxTextColor = 0
                     End If
                     GoSub DrawFilenameBox
                  Case Chr$(7) ' ctrl-g
                     FilenameBoxButton1Color = FilenameBoxButton1Color + 1
                     If FilenameBoxButton1Color = 16 Then
                        FilenameBoxButton1Color = 0
                     End If
                     GoSub DrawFilenameBox
                  Case Chr$(11) ' ctrl-k
                     FilenameBoxButton2Color = FilenameBoxButton2Color + 1
                     If FilenameBoxButton2Color = 16 Then
                        FilenameBoxButton2Color = 0
                     End If
                     GoSub DrawFilenameBox
                  Case Else
                     If BoxButton = 2 Or BoxButton = 3 Then
                        If UCase$(I$) = "O" Then
                           BoxButton = -1
                           Exit Do
                        End If
                        If UCase$(I$) = "C" Then
                           BoxButton = 0
                           Exit Do
                        End If
                     End If
                     If BoxButton = 1 Then
                        ' append/insert character into edit area.
                        OK = -1
                        If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                           If Var1 = 1 Then
                              OK = 0 ' disallow control charcters
                           End If
                        End If
                        If OK Then
                           If Insert Then
                              X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                              Xposition2 = Xposition2 + 1
                              If Xposition2 > LC Then
                                 Xposition1 = Xposition1 + 1
                              End If
                           Else
                              If Xposition2 + 1 > Len(X$) Then
                                 X$ = X$ + I$ ' append
                                 Xposition2 = Xposition2 + 1
                                 If Xposition2 > LC Then
                                    Xposition1 = Xposition1 + 1
                                 End If
                              Else ' insert
                                 Mid$(X$, Xposition2 + 1, 1) = I$
                                 Xposition2 = Xposition2 + 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(I$, 1))
                  Case 82 ' Insert
                     If BoxButton = 1 Then
                        Insert = Not Insert
                        If Insert Then
                           Locate , , 1, 8, 8 ' line cursor
                        Else
                           Locate , , 1, 0, 8 ' block cursor
                        End If
                     End If
                  Case 83 ' Delete
                     If Len(X$) > 0 Then
                        If BoxButton = 1 Then
                           X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 71 ' Home
                     If BoxButton = 1 Then
                        If Xposition2 > 0 Then
                           Xposition1 = 1
                           Xposition2 = 0
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 79 ' End
                     If BoxButton = 1 Then
                        If Xposition2 < Len(X$) Then
                           Xposition2 = Len(X$)
                           Xposition1 = Xposition2 - LC + 1
                           If Xposition1 < 1 Then
                              Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 75 ' Left
                     If BoxButton = 1 Then
                        If Len(X$) Then
                           If Xposition2 > 0 Then
                              Xposition2 = Xposition2 - 1
                              If Xposition2 - LC <= Xposition1 Then
                                 Xposition1 = Xposition1 - 1
                                 If Xposition1 < 1 Then
                                    Xposition1 = 1
                                 End If
                                 GoSub DisplayFileLine
                              End If
                           End If
                        End If
                     End If
                  Case 77 ' Right
                     If BoxButton = 1 Then
                        If Len(X$) Then
                           If Xposition2 < Len(X$) Then
                              Xposition2 = Xposition2 + 1
                              If Xposition2 > Xposition1 + LC - 1 Then
                                 Xposition1 = Xposition1 + 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case 15 ' shift-tab
                     BoxButton = BoxButton - 1
                     If BoxButton = 0 Then
                        BoxButton = 3
                     End If
                     If BoxButton = 1 Then
                        GoSub DrawFilenameBoxButtons
                        GoSub DisplayFileLine
                     Else
                        GoSub DrawFilenameBoxButtons
                     End If
                  Case 76, 143 ' keypad-5 center
                     I$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen2
                     GoSub DrawFilenameBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     I$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     I$ = ""
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     I$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     I$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     I$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen2
                           GoSub DrawFilenameBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     I$ = ""
                     If Status Then
                        Z = 23
                     Else
                        Z = 24
                     End If
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           Call RestoreScreen2
                           GoSub DrawFilenameBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     I$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen2
                           GoSub DrawFilenameBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     I$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen2
                           GoSub DrawFilenameBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      If Status Then
         Z = 23
      Else
         Z = 24
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen2
                        GoSub DrawFilenameBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = XC Then
               ' entry area
               If MouseY >= YC And MouseY <= YC + LC Then
                  BoxButton = 1
                  GoSub DrawFilenameBox
               End If
            End If
            If MouseX = Xcoor3 + 6 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = -1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
                  BoxButton = 0
                  Exit Do
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen2
               GoSub DrawFilenameBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Status Then
               Z = 23
            Else
               Z = 24
            End If
            If Xcoor3 + 7 < Z Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen2
               GoSub DrawFilenameBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates
   FilenameXcoor = Xcoor3
   FilenameYcoor = Ycoor3

   ' restore screen area.
   Call RestoreScreen2
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton Then
      FilenameBox = X$
   Else
      FilenameBox = ""
   End If
   Locate , , 1, 8, 8
   _KeyClear
   Exit Function

   ' draw box
   DrawFilenameBox:
   Color FilenameBoxBorderColor, BackGround14
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);
   Color FilenameBoxTitleColor
   Locate Xcoor3, Ycoor3 + 10, 0
   Print " Filename ";

   ' display append text
   Color FilenameBoxTextColor
   Locate Xcoor3 + 2, Ycoor3 + 1, 0
   If Var1 = 1 Then
      Print "Enter HEX bytes";
   Else
      If Var1 = 2 Then
         Print "Enter ASCII string:";
      Else
         Print "Enter filename:";
      End If
   End If
   Locate Xcoor3 + 3, Ycoor3 + 1, 0
   If Var1 = 1 Then
      Print "  (space separated):";
   End If

   Locate Xcoor3 + 4, Ycoor3 + 1, 0
   Print "Entry: ";
   GoSub DrawFilenameBoxButtons
   Locate , , , 8, 8
   XC = Xcoor3 + 4
   YC = Ycoor3 + 8
   GoSub DisplayFileLine
   Return

   ' display buttuns
   DrawFilenameBoxButtons:
   If BoxButton = 2 Then
      Locate Xcoor3 + 6, Ycoor3 + 2, 0
      Color FilenameBoxButton1Color, BackGround15
      Print "<OK>";
      Locate Xcoor3 + 6, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 6, Ycoor3 + 8, 0
      Color FilenameBoxButton2Color, BackGround15
      Print "<Cancel>";
      Locate Xcoor3 + 6, Ycoor3 + 9, 0
      Color Magenta
      Print "C";

      Locate Xcoor3 + 6, Ycoor3 + 2, 1, 8, 8 ' line cursor
   Else
      If BoxButton = 3 Then
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color FilenameBoxButton2Color, BackGround15
         Print "<OK>";
         Locate Xcoor3 + 6, Ycoor3 + 3, 0
         Color Magenta
         Print "O";

         Locate Xcoor3 + 6, Ycoor3 + 8, 0
         Color FilenameBoxButton1Color, BackGround15
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 9, 0
         Color Magenta
         Print "C";

         Locate Xcoor3 + 6, Ycoor3 + 8, 1, 8, 8 ' line cursor
      Else
         Locate Xcoor3 + 6, Ycoor3 + 2, 0
         Color FilenameBoxButton2Color, BackGround15
         Print "<OK>";
         Locate Xcoor3 + 6, Ycoor3 + 3, 0
         Color Magenta
         Print "O";

         Locate Xcoor3 + 6, Ycoor3 + 8, 0
         Color FilenameBoxButton2Color, BackGround15
         Print "<Cancel>";
         Locate Xcoor3 + 6, Ycoor3 + 9, 0
         Color Magenta
         Print "C";
      End If
   End If
   Color Plain, Black
   Return

   ' display current entry area.
   DisplayFileLine:
   Locate XC, YC, 1
   Print Space$(LC);

   ' display edit line and position cursor.
   Locate XC, YC, 1
   If Len(X$) Then
      Color White
      If MaskInput Then
         LV = Len(Mid$(X$, Xposition1, LC))
         Print String$(LV, MaskChar$);
      Else
         Print Mid$(X$, Xposition1, LC);
      End If
   End If
   Locate XC, YC + Xposition2 - Xposition1 + 1, 1
   Color Plain, Black
   If Insert Then
      Locate , , 1, 8, 8 ' line cursor
   Else
      Locate , , 1, 0, 8 ' block cursor
   End If
   Return

   ToggleInsert:
   If Insert Then
      Locate , , 1, 8, 8 ' line cursor
   Else
      Locate , , 1, 0, 8 ' block cursor
   End If
   Return
End Function

Function AsciiBox$
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen3

   ' declare ascii box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10
   If AsciiXcoor Then Xcoor3 = AsciiXcoor
   If AsciiYcoor Then Ycoor3 = AsciiYcoor

   XC = Xcoor3 + 4
   YC = Ycoor3 + 8
   LC = 22

   ' draw box
   BoxButton = 1
   GoSub DrawAsciiBox

   ' init entry area position.
   Xposition1 = 1
   Xposition2 = 0

   ' display edit entry area.
   Insert = -1
   GoSub DisplayFileLine

   ' wait for keypress or mouse
   _KeyClear
   Control.Break = False
   Monitor.Box = False
   Do
      If Control.Break Or Monitor.Box Then
         Control.Break = False
         Monitor.Box = False
         GoSub ToggleInsert
      End If

      I$ = INKEYz$
      If Len(I$) Then
         Select Case Len(I$)
            Case 1
               Select Case UCase$(I$)
                  Case "O" ' ok
                     BoxButton = 1
                     Exit Do
                  Case "C" ' cancel
                     BoxButton = 2
                     Exit Do
                  Case Chr$(8) ' backspace
                     If Len(X$) Then
                        If Xposition2 > 0 Then
                           If Insert Then ' destructive backspace
                              X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                           End If
                           Xposition2 = Xposition2 - 1
                           If Xposition2 - LC <= Xposition1 Then
                              Xposition1 = Xposition1 - 1
                              If Xposition1 < 1 Then
                                 Xposition1 = 1
                              End If
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 2
                     Exit Do
                  Case Chr$(9) ' tab
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawAsciiBoxButtons
                     GoSub DisplayFileLine
                  Case Chr$(1) ' ctrl-a
                     BackGround10 = BackGround10 + 1
                     If BackGround10 = 8 Then
                        BackGround10 = 0
                     End If
                     GoSub DrawAsciiBox
                  Case Chr$(2) ' ctrl-b
                     Background11 = Background11 + 1
                     If Background11 = 8 Then
                        Background11 = 0
                     End If
                     GoSub DrawAsciiBox
                  Case Chr$(4) ' ctrl-d
                     AsciiBoxBorderColor = AsciiBoxBorderColor + 1
                     If AsciiBoxBorderColor = 16 Then
                        AsciiBoxBorderColor = 0
                     End If
                     GoSub DrawAsciiBox
                  Case Chr$(5) ' ctrl-e
                     AsciiBoxTitleColor = AsciiBoxTitleColor + 1
                     If AsciiBoxTitleColor = 16 Then
                        AsciiBoxTitleColor = 0
                     End If
                     GoSub DrawAsciiBox
                  Case Chr$(6) ' ctrl-f
                     AsciiBoxTextColor = AsciiBoxTextColor + 1
                     If AsciiBoxTextColor = 16 Then
                        AsciiBoxTextColor = 0
                     End If
                     GoSub DrawAsciiBox
                  Case Chr$(7) ' ctrl-g
                     AsciiBoxButton1Color = AsciiBoxButton1Color + 1
                     If AsciiBoxButton1Color = 16 Then
                        AsciiBoxButton1Color = 0
                     End If
                     GoSub DrawAsciiBox
                  Case Chr$(11) ' ctrl-k
                     AsciiBoxButton2Color = AsciiBoxButton2Color + 1
                     If AsciiBoxButton2Color = 16 Then
                        AsciiBoxButton2Color = 0
                     End If
                     GoSub DrawAsciiBox
                  Case Else
                     ' append/insert character into edit area.
                     If I$ >= "0" And I$ <= "9" Then
                        If Insert Then
                           If Len(X$) < 3 Then
                              X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                              Xposition2 = Xposition2 + 1
                              If Xposition2 > LC Then
                                 Xposition1 = Xposition1 + 1
                              End If
                           End If
                        Else
                           If Xposition2 + 1 > Len(X$) Then
                              If Len(X$) < 3 Then
                                 X$ = X$ + I$ ' append
                                 Xposition2 = Xposition2 + 1
                                 If Xposition2 > LC Then
                                    Xposition1 = Xposition1 + 1
                                 End If
                              End If
                           Else ' insert
                              Mid$(X$, Xposition2 + 1, 1) = I$
                              Xposition2 = Xposition2 + 1
                           End If
                        End If
                        GoSub DisplayFileLine
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(I$, 1))
                  Case 82 ' Insert
                     Insert = Not Insert
                     If Insert Then
                        Locate , , 1, 8, 8 ' line cursor
                     Else
                        Locate , , 1, 0, 8 ' block cursor
                     End If
                  Case 83 ' Delete
                     If Len(X$) > 0 Then
                        X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                        GoSub DisplayFileLine
                     End If
                  Case 71 ' Home
                     If Xposition2 > 0 Then
                        Xposition1 = 1
                        Xposition2 = 0
                        GoSub DisplayFileLine
                     End If
                  Case 79 ' End
                     If Xposition2 < Len(X$) Then
                        Xposition2 = Len(X$)
                        Xposition1 = Xposition2 - LC + 1
                        If Xposition1 < 1 Then
                           Xposition1 = 1
                        End If
                        GoSub DisplayFileLine
                     End If
                  Case 75 ' Left
                     If Len(X$) Then
                        If Xposition2 > 0 Then
                           Xposition2 = Xposition2 - 1
                           If Xposition2 - LC <= Xposition1 Then
                              Xposition1 = Xposition1 - 1
                              If Xposition1 < 1 Then
                                 Xposition1 = 1
                              End If
                              GoSub DisplayFileLine
                           End If
                        End If
                     End If
                  Case 77 ' Right
                     If Len(X$) Then
                        If Xposition2 < Len(X$) Then
                           Xposition2 = Xposition2 + 1
                           If Xposition2 > Xposition1 + LC - 1 Then
                              Xposition1 = Xposition1 + 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  Case 15 ' shift-tab
                     If BoxButton = 2 Then
                        BoxButton = 1
                     Else
                        BoxButton = 2
                     End If
                     GoSub DrawAsciiBoxButtons
                     GoSub DisplayFileLine
                  Case 76, 143 ' keypad-5 center
                     I$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen3
                     GoSub DrawAsciiBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     I$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     I$ = ""
                     If Xcoor3 < 17 Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     I$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     I$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     I$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen3
                           GoSub DrawAsciiBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     I$ = ""
                     If Xcoor3 < 13 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     Else
                        If Xcoor3 < 17 Then
                           Xcoor3 = 17
                           Call RestoreScreen3
                           GoSub DrawAsciiBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     I$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen3
                           GoSub DrawAsciiBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     I$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen3
                           GoSub DrawAsciiBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= 17 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen3
                        GoSub DrawAsciiBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 6 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
                  BoxButton = 2
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 6 Then
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
               If BoxButton = 2 Then
                  BoxButton = 1
                  GoSub DrawAsciiBoxButtons
                  GoSub DisplayFileLine
               End If
            End If
            If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
               If BoxButton = 1 Then
                  BoxButton = 2
                  GoSub DrawAsciiBoxButtons
                  GoSub DisplayFileLine
               End If
            End If
         End If
      End If
      If MouseWheel Then
         If MouseWheel = -1 Then
            I$ = Chr$(0) + Chr$(72) ' up
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 > 2 Then
               Xcoor3 = Xcoor3 - 1
               Call RestoreScreen3
               GoSub DrawAsciiBox
            End If
            _KeyClear
         End If
         If MouseWheel = 1 Then
            I$ = Chr$(0) + Chr$(80) ' down
            MousePressed = -1
            MouseWheel = 0
            X$ = ""
            If Xcoor3 < 17 Then
               Xcoor3 = Xcoor3 + 1
               Call RestoreScreen3
               GoSub DrawAsciiBox
            End If
            _KeyClear
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' store box coordinates
   AsciiXcoor = Xcoor3
   AsciiYcoor = Ycoor3

   ' restore screen area.
   Call RestoreScreen3
   Color Plain, Black
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then
      AsciiBox = X$
   Else
      AsciiBox = ""
   End If
   Locate , , 1, 8, 8
   _KeyClear
   Exit Function

   ' draw box
   DrawAsciiBox:
   Color AsciiBoxBorderColor, BackGround10
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);
   Color AsciiBoxTitleColor
   Locate Xcoor3, Ycoor3 + 12, 0
   Print " ASCII ";

   ' display ascii text
   Color AsciiBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 1, 0
   Print "ASCII code entry box"
   Locate Xcoor3 + 3, Ycoor3 + 1, 0
   Print "Enter 3-digit ASCII code: "
   Locate Xcoor3 + 4, Ycoor3 + 1, 0
   Print "Entry: ";
   GoSub DrawAsciiBoxButtons
   Locate , , , 8, 8
   XC = Xcoor3 + 4
   YC = Ycoor3 + 8
   GoSub DisplayFileLine
   Return

   ' display buttuns
   DrawAsciiBoxButtons:
   If BoxButton = 1 Then
      Locate Xcoor3 + 6, Ycoor3 + 2, 0
      Color AsciiBoxButton1Color, Background11
      Print "<OK>";
      Locate Xcoor3 + 6, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 6, Ycoor3 + 8, 0
      Color AsciiBoxButton2Color, Background11
      Print "<Cancel>";
      Locate Xcoor3 + 6, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   Else
      Locate Xcoor3 + 6, Ycoor3 + 2, 0
      Color AsciiBoxButton2Color, Background11
      Print "<OK>";
      Locate Xcoor3 + 6, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 6, Ycoor3 + 8, 0
      Color AsciiBoxButton1Color, Background11
      Print "<Cancel>";
      Locate Xcoor3 + 6, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   End If
   Color Plain, Black
   Return

   ' display current entry area.
   DisplayFileLine:
   Locate XC, YC, 1
   Print Space$(LC);

   ' display edit line and position cursor.
   Locate XC, YC, 1
   If Len(X$) Then
      Color White
      If MaskInput Then
         LV = Len(Mid$(X$, Xposition1, LC))
         Print String$(LV, MaskChar$);
      Else
         Print Mid$(X$, Xposition1, LC);
      End If
   End If
   Locate XC, YC + Xposition2 - Xposition1 + 1, 1
   Color Plain, Black
   Return

   ToggleInsert:
   If Insert Then
      Locate , , 1, 8, 8 ' line cursor
   Else
      Locate , , 1, 0, 8 ' block cursor
   End If
   Return
End Function

' move to drive
Sub SwitchDrive (Var$)
   Dim ASCIIZ As String * 260
   Var1$ = UCase$(Left$(Var$, 1))
   Var2$ = Var$
   Var3$ = Mid$(Var$, 3)

   If Var1$ >= "A" And Var1$ <= "Z" Then
      ' check drive
      V = Asc(Var1$) - 64
      If DRIVEEXISTS(V) Then
         Call DisplayError("Drive exists error accessing drive " + Chr$(V + 64) + ":")
         Exit Sub
      End If
      If MEDIAEXISTS(V) = 0 Then
         Call DisplayError("Media exists error accessing drive " + Chr$(V + 64) + ":")
         Exit Sub
      End If

      ' make drive/path
      If Len(Var3$) Then
         ASCIIZ = Var2$ + Chr$(0)
         x = SetCurrentDirectoryA(ASCIIZ)
         If x = 0 Then
            Call DisplayWinError(x)
         Else
            DriveTable(V) = _CWD$
         End If
         Exit Sub
      End If

      ' make directory name
      Var2$ = RTrim$(DriveTable(V))
      If Len(Var2$) Then
         If Right$(Var2$, 1) = "\" Then
            ASCIIZ = Var2$ + Chr$(0)
         Else
            ASCIIZ = Var2$ + "\" + Chr$(0)
         End If
      Else
         ASCIIZ = Var1$ + ":\" + Chr$(0)
      End If
      x = SetCurrentDirectoryA(ASCIIZ)
      ' check error flag
      If x = 0 Then
         Call DisplayWinError(x)
      Else
         DriveTable(V) = _CWD$
      End If
      Exit Sub
   End If
   Call DisplayError("Drive letter error accessing drive.")
End Sub

' move to netpath
Sub SwitchNetpath (Var$)
   Dim ASCIIZ As String * 260
   ASCIIZ = Var$ + Chr$(0)
   x = SetCurrentDirectoryA(ASCIIZ)
   ' check error flag
   If x = 0 Then
      Call DisplayWinError(x)
      Exit Sub
   End If
   ' store netpath
   For V = 1 To NetPathCount
      If UCase$(_CWD$) = UCase$(RTrim$(NetPathTable(V))) Then
         Exit Sub
      End If
   Next
   NetPathCount = NetPathCount + 1
   ReDim _Preserve NetPathTable(NetPathCount) As String
   NetPathTable(NetPathCount) = _CWD$
End Sub

Sub NewDir (ErrFlag)
   Dim ASCIIZ As String * 260

   ' get current drive
   Current.Drive = Left$(_CWD$, 1)

   ' check command line
   Last.Switch = 0
   Switch.Exist = 0
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   If Command.Line = "/?" Then
      GoSub Boot.Usage
      Exit Sub
   End If

   ' get switches from command line
   Continuous.Display = ParseLine("/C")
   Display.Drive = ParseLine("/D")
   Display.Path = ParseLine("/V")
   Display.Errors = ParseLine("/Z")

   ' recheck command line
   If InStr(Command.Line, "/") Then
      GoTo Boot.Error
   End If
   Command.Line = RTrim$(Command.Line)
   If Switch.Exist Then
      If Len(Command.Line) > Last.Switch Then
         GoTo Boot.Error
      End If
   End If

   ' display header
   Header.Flag = False
   GoSub Header

   ' remove blanks from command line
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   Command.Line.Redirect$ = Command.Line
   StdinCount = 1
   Do
      ' get standard input
      Standard.Input$ = ""
      If Stdin Then
         If StdinLines > 0 Then ' nul:
            Do Until StdinCount > StdinLines
               Standard.Input$ = StdinArray(StdinCount)
               Standard.Input$ = RTrim$(LTrim$(Standard.Input$))
               If Standard.Input$ <> "" Then
                  Exit Do
               End If
               StdinCount = StdinCount + 1
            Loop
            If StdinCount > StdinLines Then
               Exit Do
            End If
         End If
      End If

      ' store entire command
      Command.Line = Command.Line.Redirect$

      ' filename processing loop
      Do

         ' store redirected input
         Standard.Input$ = RTrim$(Standard.Input$)
         Standard.Input$ = LTrim$(Standard.Input$)
         If Left$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Mid$(Standard.Input$, 2)
         End If
         If Right$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Left$(Standard.Input$, Len(Standard.Input$) - 1)
         End If

         ' store entire command
         If Left$(Command.Line, 1) = Quote Then
            Imbedded = InStr(2, Command.Line, Quote)
            If Imbedded Then
               Command.Work = Standard.Input$ + Mid$(Command.Line, 2, Imbedded - 2)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         Else
            Imbedded = InStr(Command.Line, " ")
            If Imbedded Then
               Command.Work = Standard.Input$ + Left$(Command.Line, Imbedded - 1)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         End If
         Command.Line = LTrim$(Command.Line)
         Command.Line = RTrim$(Command.Line)

         ' store current drive
         If Mid$(Command.Work, 2, 1) = ":" Then
            Drive.Search = UCase$(Left$(Command.Work, 1))
            Mid$(Command.Work, 1, 1) = UCase$(Mid$(Command.Work, 1, 1))
         Else
            Drive.Search = Current.Drive
         End If

         ' display current path
         If Command.Work = Nul Then
            Color Yellow, Black
            Print #StdoutHandle, _CWD$
            Exit Sub
         End If

         ' replace ...
         Do
            VarX = InStr(Command.Work, "...")
            If VarX Then
               Command.Work = Left$(Command.Work, VarX - 1) + "..\.." + Mid$(Command.Work, VarX + 3)
            Else
               Exit Do
            End If
         Loop

         ' check netpath
         Flag = -1
         If Left$(Command.Work, 2) <> "\\" Then
            ' check drive
            If Mid$(Command.Work, 2, 1) = ":" Then
               V = Asc(UCase$(Left$(Drive.Search, 1))) - 64
               If DRIVEEXISTS(V) Then
                  ' make directory name
                  ASCIIZ = Drive.Search + ":\" + Chr$(0)
                  x = SetCurrentDirectoryA(ASCIIZ)
                  Call DisplayWinError(x)
                  Flag = 0
               Else
                  If MEDIAEXISTS(V) = 0 Then
                     ' display any errors
                     Call DisplayError("Error accessing drive " + Chr$(V + 64) + ":")
                     Flag = 0
                  End If
               End If
            End If
         End If
         If Flag Then
            ' make directory name
            ASCIIZ = Command.Work + Chr$(0)
            x = SetCurrentDirectoryA(ASCIIZ)

            ' check error flag
            If x = 0 Then
               Call DisplayWinError(x)
            Else
               ' store path in table
               PathTable(1) = _CWD$

               ' store path in netpath table
               Var$ = _CWD$
               If Left$(Var$, 2) = "\\" Then
                  Flag = 0
                  For V = 1 To NetPathCount
                     If UCase$(_CWD$) = UCase$(RTrim$(NetPathTable(V))) Then
                        Flag = -1
                        Exit For
                     End If
                  Next
                  If Flag = 0 Then
                     NetPathCount = NetPathCount + 1
                     ReDim _Preserve NetPathTable(NetPathCount) As String
                     NetPathTable(NetPathCount) = _CWD$
                  End If
               Else
                  ' store path in drive table
                  V = Asc(UCase$(Drive.Search)) - 64
                  If V >= 1 And V <= 26 Then
                     DriveTable(V) = _CWD$
                  End If
               End If

               ' store drive letter
               Outpt$ = Nul
               If Display.Drive = False Then
                  If Left$(_CWD$, 2) <> "\\" Then
                     Outpt$ = Drive.Search$ + ":"
                  End If
               End If

               ' store pathname
               If Display.Path = False Then
                  If Left$(_CWD$, 2) = "\\" Then
                     Outpt$ = _CWD$
                  Else
                     Outpt$ = Outpt$ + Mid$(_CWD$, 3)
                  End If
               End If

               ' reset file menu box
               If Left$(_CWD$, 2) = "\\" Then
                  NetPath2$ = _CWD$
               Else
                  NetPath2$ = ""
                  OldDrive$ = Drive.Search
               End If
               OldDirectory$ = ""
               FileSpec1$ = "*.*"

               ' display default drive/netpath
               If Len(Outpt$) Then
                  Color Yellow, Black
                  Call AddStdout2(Outpt$)
               End If
            End If
         End If

         ' check search filename
         If Command.Line = Nul Then
            Exit Do
         End If
      Loop

      ' check stdin
      StdinCount = StdinCount + 1
      If StdinCount > StdinLines Then
         Exit Do
      End If
   Loop
   Exit Sub

   ' display program usage
   Boot.Usage:
   ' make header
   Color White, Black
   Print "CHDIR"
   Print "   Directory change utility; "
   Color Yellow, Black
   Print "Usage:"
   Print "   CHDIR [d:][path] [/cdvz]"
   Print "Where:"
   Print "   /c  continuous display"
   Print "   /d  don't display drive letter"
   Print "   /v  don't display pathname"
   Print "   /z  suppress error messages"
   Color Plain, Black
   Return

   Boot.Error:
   Color White, Black
   Print "Command line error. Type CHDIR /? for help."
   Color Plain, Black
   ErrFlag = -1
   Exit Sub

   ' make header
   Header:
   If Header.Flag Then
      Return
   End If
   Header.Flag = True
   If Continuous.Display = False Then
      Color White, Black
      Print "Directory change utility; "
   End If
   Return
End Sub

' command line switch position function.
Function LastSwitch (Var)
   If Last.Switch = 0 Then
      Last.Switch = Var - 1
      Switch.Exist = -1
   Else
      If Var < Last.Switch Then
         Last.Switch = Var - 1
         Switch.Exist = -1
      End If
   End If
   LastSwitch = -1
End Function

' command line parser
Function ParseLine (X$)
   Imbedded = InStr(Command.Line, LCase$(X$))
   If Imbedded Then
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
      Last.Switch = Imbedded - 1
      Switch.Exist = -1
      ParseLine = True
   Else
      Imbedded = InStr(Command.Line, UCase$(X$))
      If Imbedded Then
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
         Last.Switch = Imbedded - 1
         Switch.Exist = -1
         ParseLine = True
      Else
         ParseLine = False
      End If
   End If
End Function

' command line stripper
Function ParseLineX (X$) ' X$ should equal /
   Do
      Imbedded = InStr(Command.Line, X$)
      If Imbedded Then
         V$ = Mid$(Command.Line, Imbedded + 1, 1)
         If Len(V$) Then
            Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
         Else
            Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
         End If
      Else
         Exit Do
      End If
   Loop
   ParseLineX = True
End Function

' displays carry flag error
Sub DisplayError (Temp$)
   Var$ = Temp$
   ' check display errors flag
   If Display.Errors = False Then
      ' display error
      If LCase$(StderrFile$) = "scrn:" Then
         Color Red, Black
         Print #StderrHandle, Var$
      Else
         Print #StderrHandle, Date$ + " " + Time$ + " " + Var$
      End If
   End If
End Sub

' displays windows error
Sub DisplayWinError (x)
   ' define error message value
   v& = GetLastError
   ' check display errors flag
   If Display.Errors = False Then
      ' call windows error message routine
      x& = FormatMessageA&(&H1200, "", v&, 0, ErrorBuffer$, 260, "")
      ' display error
      If x& Then
         Var$ = Left$(ErrorBuffer$, x& - 2)
      Else
         Var$ = "Unknown error 0x" + Hex$(v&) + "."
      End If
      ' display error
      If LCase$(StderrFile$) = "scrn:" Then
         Color Red, Black
         Print #StderrHandle, Var$
      Else
         Print #StderrHandle, Date$ + " " + Time$ + " " + Var$
      End If
   End If
   x = -1
End Sub

' test volume media inserted.
Function MEDIAEXISTS (V)
   ' check drive exists.
   If DRIVEEXISTS(V) Then
      MEDIAEXISTS = False
      Exit Function
   End If

   ' get drive info.
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      MEDIAEXISTS = True
   Else
      MEDIAEXISTS = False
   End If
End Function

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = Nul
   Select Case VarX
      Case 0
         DriveType = "[UNKNOWN]"
      Case 1
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      DRIVEEXISTS = False
   Else
      DRIVEEXISTS = True
   End If
End Function

Function IsSymbol (x$)
   SymbolList$ = " ~`@#$%^&*()_-+=|\}]{[':;?/>.<," + Quote
   If InStr(SymbolList$, x$) Then
      IsSymbol = -1
   Else
      IsSymbol = 0
   End If
End Function

Function IsAlphaNum (x$)
   z$ = LCase$(x$)
   If z$ >= "0" And z$ <= "9" Then
      IsAlphaNum = -1
   End If
   If z$ >= "a" And z$ <= "z" Then
      IsAlphaNum = -1
   End If
End Function

Function IsNumeric (x$)
   For V = 1 To Len(x$)
      If Mid$(x$, V, 1) >= "0" And Mid$(x$, V, 1) <= "9" Then
         Eat$ = Nul
      Else
         IsNumeric = 0
         Exit Function
      End If
   Next
   IsNumeric = -1
End Function

Function IsSingle (x$)
   For V = 1 To Len(x$)
      If Mid$(x$, V, 1) >= "0" And Mid$(x$, V, 1) <= "9" Then
         Eat$ = Nul
      Else
         If Mid$(x$, V, 1) = "." Then
            If Dot Then
               IsSingle = 0
               Exit Function
            Else
               Dot = -1
            End If
         Else
            IsSingle = 0
            Exit Function
         End If
      End If
   Next
   IsSingle = -1
End Function

Rem check hex byte string.
Rem   input: ByteString$ is space-separated hex byte pair string.
Rem   returns: ValidByteString equals true if string is valid,
Rem     ByteString$ is concatenated hex byte string.
Sub CheckHexBytes (ByteString$)
   ByteString$ = LTrim$(ByteString$)
   ByteString$ = RTrim$(ByteString$)
   If Len(ByteString$) = False Then
      ValidByteString = False
      Exit Sub
   End If
   ValidByteString = True
   For StringPosition = 1 To Len(ByteString$)
      Byte$ = Mid$(ByteString$, StringPosition, 1)
      If (StringPosition Mod 3) = False Then
         If Byte$ <> " " Then
            ValidByteString = False
            Exit Sub
         End If
      Else
         Select Case Byte$
            Case "0" To "9", "A" To "F", "a" To "f"
               Mid$(ByteString$, StringPosition, 1) = UCase$(Byte$)
            Case Else
               ValidByteString = False
               Exit Sub
         End Select
      End If
   Next
   Var1$ = ByteString$
   Do
      Parse = InStr(Var1$, " ")
      If Parse Then
         Var1$ = Left$(Var1$, Parse - 1) + Mid$(Var1$, Parse + 1)
      Else
         Exit Do
      End If
   Loop
   ByteString$ = Var1$
End Sub

Rem check hex byte string.
Rem   input:
Rem     ByteString$ is space-separated hex byte pair string w/ wildcards.
Rem   returns: ValidByteString equals true if string is valid,
Rem     ByteString$ is concatenated hex byte string converted to ASCII.
Sub CheckHexBytes2 (ByteString$)
   ByteString$ = LTrim$(ByteString$)
   ByteString$ = RTrim$(ByteString$)
   If Len(ByteString$) = False Then
      ValidByteString = False
      Exit Sub
   End If
   ValidByteString = True
   For StringPosition = 1 To Len(ByteString$)
      Byte$ = Mid$(ByteString$, StringPosition, 1)
      If (StringPosition Mod 3) = False Then
         If Byte$ <> " " Then
            ValidByteString = False
            Exit Sub
         End If
      Else
         Select Case Byte$
            Case "0" To "9", "A" To "F", "a" To "f", "?", "*"
               Mid$(ByteString$, StringPosition, 1) = UCase$(Byte$)
            Case Else
               ValidByteString = False
               Exit Sub
         End Select
      End If
   Next
   ' remove spaces.
   Var1$ = ByteString$
   Do
      Parse = InStr(Var1$, " ")
      If Parse Then
         Var1$ = Left$(Var1$, Parse - 1) + Mid$(Var1$, Parse + 1)
      Else
         Exit Do
      End If
   Loop
   ' check wildcards
   For Parse = 1 To Len(Var1$) Step 2
      If Mid$(Var1$, Parse, 1) = "?" Or Mid$(Var1$, Parse + 1, 1) = "?" Then
         If Mid$(Var1$, Parse, 2) = "??" Then
            ' nul
         Else
            ValidByteString = False
            Exit Sub
         End If
      End If
      If Mid$(Var1$, Parse, 1) = "*" Or Mid$(Var1$, Parse + 1, 1) = "*" Then
         If Mid$(Var1$, Parse, 2) = "**" Then
            ' nul
         Else
            ValidByteString = False
            Exit Sub
         End If
      End If
   Next
   ' convert hex to ascii
   VarB$ = ""
   Do
      VarA$ = Left$(Var1$, 2)
      If VarA$ = "??" Then
         VarB$ = VarB$ + "?"
      Else
         If VarA$ = "**" Then
            VarB$ = VarB$ + "*"
         Else
            VarB$ = VarB$ + Chr$(Val("&H" + VarA$))
         End If
      End If
      Var1$ = Mid$(Var1$, 3)
      If Var1$ = "" Then
         Exit Do
      End If
   Loop
   ByteString$ = VarB$
End Sub

' function to match case-sensitive substring with ?, * characters in substring
'  input: VarQ = -1 for case-sensitive
'    Var1$ is search string
'    Var2$ is string being searched
'  output: Var = -1 search string matched
Sub InstrSUB1 (Var, Var1$, Var2$, VarQ)

   ' store case-sensitive string match variables
   If VarQ Then
      S2$ = Var1$
      S3$ = Var2$
   Else
      S2$ = LCase$(Var1$)
      S3$ = LCase$(Var2$)
   End If

   ' check default instr
   If InStr(S2$, "*") = 0 Then
      If InStr(S2$, "?") = 0 Then
         Var = InStr(S3$, S2$)
         Exit Sub
      End If
   End If

   Var = -1 ' assume match

   ' asterick always matches
   If Var1$ = "*" Then
      Exit Sub
   End If

   ' see if S2$ matches in S3$ with substrings
   For S3 = 1 To Len(S3$)
      S1$ = Mid$(S3$, S3)
      P1 = 1 ' pointer to S1$
      P2 = 1 ' pointer to S2$
      Do
         ' check match
         If P2 > Len(S2$) Then
            Exit Sub
         End If

         ' check character in S2$ at P2
         V$ = Mid$(S2$, P2, 1)
         Select Case V$
            Case "*" ' global character
               ' scan to next char
               If P2 > Len(S2$) Then
                  Exit Do
               End If
               S4$ = Mid$(S2$, P2 + 1, 1)
               Select Case S4$
                  Case "*", "?"
                     P2 = P2 + 1
                  Case Else
                     Do
                        If Mid$(S1$, P1, 1) = S4$ Then
                           Exit Do
                        End If
                        If P1 >= Len(S1$) Then
                           Exit Do
                        End If
                        P1 = P1 + 1
                     Loop
                     P2 = P2 + 1
               End Select
            Case "?" ' wildcard character
               P1 = P1 + 1
               P2 = P2 + 1
            Case Else ' ascii character
               If Mid$(S1$, P1, 1) <> V$ Then ' no match
                  Exit Do
               End If
               P1 = P1 + 1
               P2 = P2 + 1
         End Select
      Loop
   Next
   Var = 0 ' no match
End Sub

Sub Capitalize (Var3$)
   Var3$ = RTrim$(LTrim$(Var3$))
   If Var3$ = Nul Then
      Exit Sub
   End If
   Mid$(Var3$, 1, 1) = UCase$(Mid$(Var3$, 1, 1))
   Var = InStr(Var3$, " ")
   If Var < Len(Var3$) Then
      Do While Var
         Mid$(Var3$, Var + 1, 1) = UCase$(Mid$(Var3$, Var + 1, 1))
         Var = InStr(Var + 1, Var3$, " ")
      Loop
   End If
End Sub

Sub MakDir (ErrFlag)
   Dim ASCIIZ As String * 260
   Dim hfind As _Offset

   ' get current drive
   Current.Drive = UCase$(Left$(_CWD$, 1))

   ' check command line
   Last.Switch = 0
   Switch.Exist = 0
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   If Command.Line = "/?" Then
      GoSub Boot.Usage
      Exit Sub
   End If

   ' get switches from command line
   Continuous.Display = ParseLine("/C")
   Display.Drive = ParseLine("/D")
   Display.Path = ParseLine("/V")
   Display.Errors = ParseLine("/Z")

   ' recheck command line
   If InStr(Command.Line, "/") Then
      GoTo Boot.Error
   End If
   Command.Line = RTrim$(Command.Line)
   If Switch.Exist Then
      If Len(Command.Line) > Last.Switch Then
         GoTo Boot.Error
      End If
   End If

   ' display header
   Header.Flag = False
   GoSub Header

   ' remove blanks from command line
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   Command.Line.Redirect$ = Command.Line
   StdinCount = 1
   Do
      ' get standard input
      Standard.Input$ = ""
      If Stdin Then
         If StdinLines > 0 Then ' nul:
            Do Until StdinCount > StdinLines
               Standard.Input$ = StdinArray(StdinCount)
               Standard.Input$ = RTrim$(LTrim$(Standard.Input$))
               If Standard.Input$ <> "" Then
                  Exit Do
               End If
               StdinCount = StdinCount + 1
            Loop
            If StdinCount > StdinLines Then
               Exit Do
            End If
         End If
      End If

      ' store entire command
      Command.Line = Command.Line.Redirect$

      ' filename processing loop
      Do

         ' store redirected input
         Standard.Input$ = RTrim$(Standard.Input$)
         Standard.Input$ = LTrim$(Standard.Input$)
         If Left$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Mid$(Standard.Input$, 2)
         End If
         If Right$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Left$(Standard.Input$, Len(Standard.Input$) - 1)
         End If

         ' store entire command
         If Left$(Command.Line, 1) = Quote Then
            Imbedded = InStr(2, Command.Line, Quote)
            If Imbedded Then
               Command.Work = Standard.Input$ + Mid$(Command.Line, 2, Imbedded - 2)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         Else
            Imbedded = InStr(Command.Line, " ")
            If Imbedded Then
               Command.Work = Standard.Input$ + Left$(Command.Line, Imbedded - 1)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         End If
         Command.Line = LTrim$(Command.Line)
         Command.Line = RTrim$(Command.Line)

         ' store current drive
         If Mid$(Command.Work, 2, 1) = ":" Then
            Drive.Search = UCase$(Left$(Command.Work, 1))
         Else
            Drive.Search = Current.Drive
         End If

         Command.Work = LTrim$(Command.Work)
         Command.Work = RTrim$(Command.Work)

         ' check drive
         Flag = -1
         If Left$(_CWD$, 2) <> "\\" Then
            V = Asc(UCase$(Left$(Drive.Search, 1))) - 64
            If MEDIAEXISTS(V) = 0 Then
               ' display any errors
               Call DisplayError("Error accessing drive " + Chr$(V + 64) + ":")
               Flag = 0
            End If
         End If

         ' replace ...
         Do
            VarX = InStr(Command.Work, "...")
            If VarX Then
               Command.Work = Left$(Command.Work, VarX - 1) + "..\.." + Mid$(Command.Work, VarX + 3)
            Else
               Exit Do
            End If
         Loop

         ' check directory exists
         ASCIIZ = Command.Work + Chr$(0)
         hfind = CreateFileAqb(Command.Work, 6)
         If hfind Then
            ' display any errors
            Call DisplayError("Directory exists.")
            Flag = 0
         End If
         If Command.Work = "" Then
            Flag = False
         End If
         If Flag Then
            ' make directory name
            f$ = Command.Work
            x = CreateDirectoryStructure(f$)
            If x = 0 Then
               If NetPathError Then
                  Call DisplayError("Netpath error making directory.")
               Else
                  Call DisplayError("Error 0x" + Hex$(GetLastError) + " making directory.")
                  Call DisplayWinError(x)
               End If
            Else
               ' store drive letter
               Outpt$ = Nul
               If Display.Drive = False Then
                  If Left$(_CWD$, 2) <> "\\" Then
                     Outpt$ = Drive.Search + ":"
                  End If
               End If

               ' store pathname
               If Display.Path = False Then
                  If Left$(DirFilename$, 2) = "\\" Then
                     Outpt$ = DirFilename$
                  Else
                     If Mid$(DirFilename$, 2, 1) = ":" Then
                        Outpt$ = Outpt$ + Mid$(DirFilename$, 3)
                     Else
                        Outpt$ = DirFilename$
                     End If
                  End If
               End If

               ' display drive/netpath
               If Len(Outpt$) Then
                  Color Yellow, Black
                  Call AddStdout2(Outpt$)
               End If
            End If
         End If

         ' check search filename
         If Command.Line = Nul Then
            Exit Do
         End If
      Loop

      ' check stdin
      StdinCount = StdinCount + 1
      If StdinCount > StdinLines Then
         Exit Do
      End If
   Loop
   Exit Sub

   ' display program usage
   Boot.Usage:
   ' make header
   Color White, Black
   Print "MKDIR"
   Print "   Directory create utility; "
   Color Yellow, Black
   Print "Usage:"
   Print "   MKDIR [d:][path] [/cdvz]"
   Print "Where:"
   Print "   /c  continuous display"
   Print "   /d  don't display drive letter"
   Print "   /v  don't display pathname"
   Print "   /z  suppress error messages"
   Color Plain, Black
   Return

   Boot.Error:
   Color White, Black
   Print "Command line error. Type MKDIR /? for help."
   Color Plain, Black
   ErrFlag = -1
   Exit Sub

   ' make header
   Header:
   If Header.Flag Then
      Return
   End If
   Header.Flag = True
   If Continuous.Display = False Then
      Color White, Black
      Print "Directory create utility; "
   End If
   Return
End Sub

' gets default directory
Function DirFilename$
   ' fully qualified path
   If Mid$(Command.Work, 2, 1) = ":" Then
      DirFilename$ = Command.Work
      Exit Function
   End If
   ' fully qualified netpath
   If Left$(Command.Work, 2) = "\\" Then
      DirFilename$ = Command.Work
      Exit Function
   End If
   ' fully qualified root path
   If Left$(Command.Work, 1) = "\" Then
      Var$ = Drive.Search + ":"
      DirFilename$ = Var$ + Command.Work
      Exit Function
   End If
   ' get current directory
   Drive$ = Drive.Search + ":"
   If Left$(_CWD$, 2) = "\\" Then
      Directory.Search$ = _CWD$
   Else ' path\filename
      If Drive.Search = Current.Drive Then
         Directory.Search$ = _CWD$
      Else
         Original$ = _CWD$
         x = SetCurrentDirectoryA(Drive$ + Chr$(0))
         Directory.Search$ = _CWD$
         x = SetCurrentDirectoryA(Original$ + Chr$(0))
      End If
   End If
   ' store default directory
   Filename.Search$ = Command.Work
   If Right$(Directory.Search$, 1) = "\" Then
      Directory.Search$ = Directory.Search$ + Filename.Search$
   Else
      Directory.Search$ = Directory.Search$ + "\" + Filename.Search$
   End If
   DirFilename$ = Directory.Search$
End Function

' routine to create directory structure
Function CreateDirectoryStructure (NewDirectory$)
   ' construct path
   NewDirectory$ = RTrim$(NewDirectory$)
   Next.Dest.Net$ = ""
   NetPathError = 0
   If Left$(NewDirectory$, 2) = "\\" Then ' \\serve\share\
      V = InStr(3, NewDirectory$, "\")
      If V Then
         V = InStr(V + 1, NewDirectory$, "\")
         If V Then
            Next.Dest.Net$ = Left$(NewDirectory$, V - 1)
            NewDirectory$ = Mid$(NewDirectory$, V + 1)
         End If
      End If
      If Next.Dest.Net$ = "" Then
         NetPathError = -1
         CreateDirectory = 0
         Exit Function
         NewDirectory$ = "\"
         Drive.Create$ = Current.Drive
      End If
   Else
      If Mid$(NewDirectory$, 2, 1) = ":" Then ' c:\tempx
         Drive.Create$ = Left$(NewDirectory$, 1)
         NewDirectory$ = Mid$(NewDirectory$, 3)
      Else
         If Left$(NewDirectory$, 1) = "\" Then ' \tempx
            Drive.Create$ = Left$(_CWD$, 1)
         Else
            If Left$(_CWD$, 2) = "\\" Then ' \\tempx
               Next.Dest.Net$ = _CWD$
            Else
               Drive.Create$ = Left$(_CWD$, 1) ' c:tempx
            End If
         End If
      End If
   End If
   If Right$(NewDirectory$, 1) <> "\" Then
      NewDirectory$ = NewDirectory$ + "\"
   End If

   ' create path
   x = 0
   Next.Dir = InStr(NewDirectory$, "\")
   Do
      If Next.Dir = False Then
         Exit Do
      End If

      ' parse path left to right
      SubDir$ = Left$(NewDirectory$, Next.Dir - 1) ' \tempx\t1\t2\t3\
      Next.Dir = InStr(Next.Dir + 1, NewDirectory$, "\")

      ' make directory name
      If Len(SubDir$) Then
         ' create directory
         If Len(Next.Dest.Net$) Then
            F$ = Next.Dest.Net$ + "\" + SubDir$
         Else
            F$ = Drive.Create$ + ":" + SubDir$
         End If

         ' check directory
         If _DirExists(F$) = 0 Then
            F$ = F$ + Chr$(0)
            x = CreateDirectoryA(F$, 0)

            ' check error
            If x = 0 Then
               If GetLastError& = &HB7 Then ' ignore already exists
                  ' nul
               Else
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
   If x Then
      UserProfileRecord.Reserved3 = UserProfileRecord.Reserved3 + 1!
      x = WriteUser
   End If
   CreateDirectoryStructure = x
End Function

Sub DelDir (ErrFlag)
   Dim ASCIIZ As String * 260
   Dim hfind As _Offset

   ' get current drive
   Current.Drive = Left$(_CWD$, 1)

   ' check command line
   Last.Switch = 0
   Switch.Exist = 0
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   If Command.Line = "/?" Then
      GoSub Boot.Usage
      Exit Sub
   End If

   ' reset counters
   Dirs.Counted = False

   ' store command line
   Command.Line = RTrim$(Command.Line)

   ' get switches from command line
   Continuous.Display = ParseLine("/C")
   Display.Drive = ParseLine("/D")
   Prompt.Delete = ParseLine("/P")
   Display.Path = ParseLine("/V")
   Display.Errors = ParseLine("/Z")

   ' recheck command line
   If InStr(Command.Line, "/") Then
      GoTo Boot.Error
   End If
   Command.Line = RTrim$(Command.Line)
   If Switch.Exist Then
      If Len(Command.Line) > Last.Switch Then
         GoTo Boot.Error
      End If
   End If

   ' display header
   Header.Flag = False
   GoSub Header

   ' remove blanks from command line
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   Command.Line.Redirect$ = Command.Line
   StdinCount = 1
   Do
      ' get standard input
      Standard.Input$ = ""
      If Stdin Then
         If StdinLines > 0 Then ' nul:
            Do Until StdinCount > StdinLines
               Standard.Input$ = StdinArray(StdinCount)
               Standard.Input$ = RTrim$(LTrim$(Standard.Input$))
               If Standard.Input$ <> "" Then
                  Exit Do
               End If
               StdinCount = StdinCount + 1
            Loop
            If StdinCount > StdinLines Then
               Exit Do
            End If
         End If
      End If

      ' store entire command
      Command.Line = Command.Line.Redirect$

      ' filename processing loop
      Do
         ' store redirected input
         Standard.Input$ = RTrim$(Standard.Input$)
         Standard.Input$ = LTrim$(Standard.Input$)
         If Left$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Mid$(Standard.Input$, 2)
         End If
         If Right$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Left$(Standard.Input$, Len(Standard.Input$) - 1)
         End If

         ' store entire command
         If Left$(Command.Line, 1) = Quote Then
            Imbedded = InStr(2, Command.Line, Quote)
            If Imbedded Then
               Command.Work = Standard.Input$ + Mid$(Command.Line, 2, Imbedded - 2)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         Else
            Imbedded = InStr(Command.Line, " ")
            If Imbedded Then
               Command.Work = Standard.Input$ + Left$(Command.Line, Imbedded - 1)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         End If
         Command.Line = LTrim$(Command.Line)
         Command.Line = RTrim$(Command.Line)

         ' store current drive
         If Mid$(Command.Work, 2, 1) = ":" Then
            Drive.Search = UCase$(Left$(Command.Work, 1))
         Else
            Drive.Search = Current.Drive
         End If

         ' check drive
         Flag = -1
         If Left$(_CWD$, 2) <> "\\" Then
            V = Asc(UCase$(Left$(Drive.Search, 1))) - 64
            If MEDIAEXISTS(V) = 0 Then
               ' display any errors
               Call DisplayError("Error accessing drive " + Chr$(V + 64) + ":")
               Flag = 0
            End If
         End If
         If Flag Then
            ' replace ...
            Do
               VarX = InStr(Command.Work, "...")
               If VarX Then
                  Command.Work = Left$(Command.Work, VarX - 1) + "..\.." + Mid$(Command.Work, VarX + 3)
               Else
                  Exit Do
               End If
            Loop

            ' check directory exists
            ASCIIZ = Command.Work + Chr$(0)
            hfind = CreateFileAqb(Command.Work, 6)
            If hfind Then
               ' reset delete flag
               Delete.File = True

               ' check delete flag
               If Prompt.Delete = 0 Then
                  Prompt2$ = "Delete directory " + DirFilename$ + "(y/n/q/c)?"
                  Call MorePrompt(Prompt2$, "ynqc", Outpt$)
                  Select Case Outpt$
                     Case "c"
                        Prompt.Delete = True
                     Case "n"
                        Delete.File = False
                     Case "q"
                        Delete.File = False
                        Quit.Searching = True
                  End Select
               End If

               ' check delete flag
               If Delete.File Then

                  ' delete directory.
                  G$ = Command.Work
                  If Right$(G$, 1) <> "\" Then G$ = G$ + "\"
                  Call Silentdel_Directories(G$)

                  ' check error flag
                  If _DirExists(G$) Then
                     ' remove an empty directory
                     ASCIIZ = G$ + Chr$(0)
                     x = RemoveDirectoryA(ASCIIZ)
                     If x = 0 Then
                        Call DisplayError("Error deleting directory.")
                        Call DisplayWinError(r)
                     End If
                  Else
                     ' display drive letter
                     Outpt$ = Nul
                     If Display.Drive = False Then
                        If Left$(_CWD$, 2) <> "\\" Then
                           Outpt$ = Drive.Search + ":"
                        End If
                     End If

                     ' store pathname
                     If Display.Path = False Then
                        If Left$(DirFilename$, 2) = "\\" Then
                           Outpt$ = DirFilename$
                        Else
                           If Mid$(DirFilename$, 2, 1) = ":" Then
                              Outpt$ = Outpt$ + Mid$(DirFilename$, 3)
                           Else
                              Outpt$ = DirFilename$
                           End If
                        End If
                     End If

                     ' display drive/netpath
                     If Len(Outpt$) Then
                        Color Yellow, Black
                        Call AddStdout2(Outpt$)
                     End If

                     ' count directories deleted
                     Dirs.Counted = Dirs.Counted + 1
                  End If
               End If
            Else
               Call DisplayWinError(x)
            End If
         End If

         ' check search filename
         If Command.Line = Nul Then
            Exit Do
         End If
         If Quit.Searching Then
            Exit Do
         End If
      Loop

      ' check stdin
      StdinCount = StdinCount + 1
      If StdinCount > StdinLines Then
         Exit Do
      End If
      If Quit.Searching Then
         Exit Do
      End If
   Loop

   ' display counters
   If Continuous.Display = False Then
      Color Yellow, Black
      Total$ = FormatString$(Dirs.Counted)
      Print "Directories counted: "; Total$
   End If
   Color Plain, Black
   Exit Sub

   ' display program usage
   Boot.Usage:
   ' make header
   Color White, Black
   Print "RMDIR"
   Print "   Directory delete utility; "
   Color Yellow, Black
   Print "Usage:"
   Print "   RMDIR [d:][path] [/cdpvz]"
   Print "Where:"
   Print "   /c  continuous display"
   Print "   /d  don't display drive letter"
   Print "   /p  don't prompt before delete"
   Print "   /v  don't display pathname"
   Print "   /z  suppress error messages"
   Color Plain, Black
   Return

   Boot.Error:
   Color White, Black
   Print "Command line error. Type RMDIR /? for help."
   Color Plain, Black
   ErrFlag = -1
   Exit Sub

   ' make header
   Header:
   If Header.Flag Then
      Return
   End If
   Header.Flag = True
   If Continuous.Display = False Then
      Color White, Black
      Print "Directory delete utility; "
   End If
   Return
End Sub

Sub MakeFile (ErrFlag)
   Dim ASCIIZ As String * 260
   Dim hfind As _Offset

   ' get current drive
   Current.Drive = Left$(_CWD$, 1)

   ' check command line
   Last.Switch = 0
   Switch.Exist = 0
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   If Command.Line = "/?" Then
      GoSub Boot.Usage
      Exit Sub
   End If

   ' get switches from command line
   Continuous.Display = ParseLine("/C")
   Display.Drive = ParseLine("/D")
   Display.Path = ParseLine("/V")
   Display.Errors = ParseLine("/Z")

   ' recheck command line
   If InStr(Command.Line, "/") Then
      GoTo Boot.Error
   End If
   Command.Line = RTrim$(Command.Line)
   If Switch.Exist Then
      If Len(Command.Line) > Last.Switch Then
         GoTo Boot.Error
      End If
   End If

   ' display header
   Header.Flag = False
   GoSub Header

   ' remove blanks from command line
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   Command.Line.Redirect$ = Command.Line
   StdinCount = 1
   Do
      ' get standard input
      Standard.Input$ = ""
      If Stdin Then
         If StdinLines > 0 Then ' nul:
            Do Until StdinCount > StdinLines
               Standard.Input$ = StdinArray(StdinCount)
               Standard.Input$ = RTrim$(LTrim$(Standard.Input$))
               If Standard.Input$ <> "" Then
                  Exit Do
               End If
               StdinCount = StdinCount + 1
            Loop
            If StdinCount > StdinLines Then
               Exit Do
            End If
         End If
      End If

      ' store entire command
      Command.Line = Command.Line.Redirect$

      ' filename processing loop
      Do

         ' store redirected input
         Standard.Input$ = RTrim$(Standard.Input$)
         Standard.Input$ = LTrim$(Standard.Input$)
         If Left$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Mid$(Standard.Input$, 2)
         End If
         If Right$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Left$(Standard.Input$, Len(Standard.Input$) - 1)
         End If

         ' store entire command
         If Left$(Command.Line, 1) = Quote Then
            Imbedded = InStr(2, Command.Line, Quote)
            If Imbedded Then
               Command.Work = Standard.Input$ + Mid$(Command.Line, 2, Imbedded - 2)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         Else
            Imbedded = InStr(Command.Line, " ")
            If Imbedded Then
               Command.Work = Standard.Input$ + Left$(Command.Line, Imbedded - 1)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         End If
         Command.Line = LTrim$(Command.Line)
         Command.Line = RTrim$(Command.Line)

         ' store current drive
         If Mid$(Command.Work, 2, 1) = ":" Then
            Drive.Search = UCase$(Left$(Command.Work, 1))
         Else
            Drive.Search = Current.Drive
         End If

         ' check drive
         Flag = -1
         If Left$(_CWD$, 2) <> "\\" Then
            V = Asc(UCase$(Left$(Drive.Search, 1))) - 64
            If MEDIAEXISTS(V) = 0 Then
               ' display any errors
               Call DisplayError("Error accessing drive " + Chr$(V + 64) + ":")
               Flag = 0
            End If
         End If
         If Flag Then
            ' make filename
            ASCIIZ = Command.Work + Chr$(0)
            hfind = CreateFileAqb(Command.Work, 1)
            If hfind Then
               ' store drive letter
               Outpt$ = Nul
               If Display.Drive = False Then
                  If Left$(_CWD$, 2) <> "\\" Then
                     Outpt$ = Drive.Search + ":"
                  End If
               End If

               ' store pathname
               If Display.Path = False Then
                  If Left$(DirFilename$, 2) = "\\" Then
                     Outpt$ = DirFilename$
                  Else
                     If Mid$(DirFilename$, 2, 1) = ":" Then
                        Outpt$ = Outpt$ + Mid$(DirFilename$, 3)
                     Else
                        Outpt$ = DirFilename$
                     End If
                  End If
               End If

               ' display drive/netpath
               If Len(Outpt$) Then
                  Color Yellow, Black
                  Call AddStdout2(Outpt$)
               End If
            Else
               Call DisplayError("Error 0x" + Hex$(GetLastError) + " creating file.")
               Call DisplayWinError(x)
            End If
         End If

         ' check search filename
         If Command.Line = Nul Then
            Exit Do
         End If
      Loop

      ' check stdin
      StdinCount = StdinCount + 1
      If StdinCount > StdinLines Then
         Exit Do
      End If
   Loop
   Exit Sub

   ' display program usage
   Boot.Usage:
   ' make header
   Color White, Black
   Print "MKFILE"
   Print "   File create utility; "
   Color Yellow, Black
   Print "Usage:"
   Print "   MKFILE [d:][path] [/cdvz]"
   Print "Where:"
   Print "   /c  continuous display"
   Print "   /d  don't display drive letter"
   Print "   /v  don't display filename"
   Print "   /z  suppress error messages"
   Color Plain, Black
   Return

   Boot.Error:
   Color White, Black
   Print "Command line error. Type MKFILE /? for help."
   Color Plain, Black
   ErrFlag = -1
   Exit Sub

   ' make header
   Header:
   If Header.Flag Then
      Return
   End If
   Header.Flag = True
   If Continuous.Display = False Then
      Color White, Black
      Print "File create utility; "
   End If
   Return
End Sub

Sub Whereis (ErrFlag, VarQ)
   ' check command line
   Last.Switch = 0
   Switch.Exist = 0
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   If Command.Line = "/?" Then
      GoSub Boot.Usage
      Exit Sub
   End If

   ' get current drive
   Current.Drive = Left$(_CWD$, 1)
   Current.Directory = _CWD$
   If Right$(Current.Directory, 1) <> "\" Then
      Current.Directory = Current.Directory + "\"
   End If

   ' get exclude switch
   Exclude.List = Nul
   Imbedded = InStr(Command.Line, "/(")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Exclude.List = Nul
      Next.Bracket = InStr(Imbedded + 2, Command.Line, ")")
      If Next.Bracket Then
         Exclude.List = Mid$(Command.Line, Imbedded + 2, Next.Bracket - Imbedded - 2)
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Next.Bracket + 1)
      End If
      If Exclude.List = Nul Then
         GoTo Boot.Error
      End If
   End If
   Command.Line = RTrim$(Command.Line)

   ' get dos command
   DOS.Command = Nul
   Imbedded = InStr(Command.Line, "/[")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      DOS.Command = Nul
      Next.Bracket = InStr(Imbedded + 2, Command.Line, "]")
      If Next.Bracket Then
         DOS.Command = Mid$(Command.Line, Imbedded + 2, Next.Bracket - Imbedded - 2)
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Next.Bracket + 1)
      End If
      If DOS.Command = Nul Then
         GoTo Boot.Error
      End If
   End If
   Command.Line = RTrim$(Command.Line)

   ' edit special DOS command parameters
   Imbedded = InStr(DOS.Command, "//1")
   While Imbedded
      DOS.Command = Left$(DOS.Command, Imbedded - 1) + ">" + Mid$(DOS.Command, Imbedded + 3)
      Imbedded = InStr(DOS.Command, "//1")
   Wend
   Imbedded = InStr(DOS.Command, "//2")
   While Imbedded
      DOS.Command = Left$(DOS.Command, Imbedded - 1) + "<" + Mid$(DOS.Command, Imbedded + 3)
      Imbedded = InStr(DOS.Command, "//2")
   Wend
   Imbedded = InStr(DOS.Command, "//3")
   While Imbedded
      DOS.Command = Left$(DOS.Command, Imbedded - 1) + "|" + Mid$(DOS.Command, Imbedded + 3)
      Imbedded = InStr(DOS.Command, "//3")
   Wend
   Imbedded = InStr(DOS.Command, "//4")
   While Imbedded
      DOS.Command = Left$(DOS.Command, Imbedded - 1) + "%" + Mid$(DOS.Command, Imbedded + 3)
      Imbedded = InStr(DOS.Command, "//4")
   Wend
   Imbedded = InStr(DOS.Command, "//5")
   While Imbedded
      DOS.Command = Left$(DOS.Command, Imbedded - 1) + "]" + Mid$(DOS.Command, Imbedded + 3)
      Imbedded = InStr(DOS.Command, "//5")
   Wend

   ' check command line switches
   No.Display.Archive = ParseLine("//A")
   No.Display.Hidden = ParseLine("//H")
   No.Display.Directory = ParseLine("//I")
   No.Display.Readonly = ParseLine("//O")
   No.Display.System = ParseLine("//S")
   No.Display.Any = ParseLine("//X")
   No.Display.Compress = ParseLine("//M1")
   No.Display.Encrypt = ParseLine("//M2")

   Display.Archive = ParseLine("/A")
   Display.Hidden = ParseLine("/H")
   Display.Directory = ParseLine("/I")
   Display.Readonly = ParseLine("/O")
   Display.System = ParseLine("/S")
   Display.Any = ParseLine("/X")
   Display.Compress = ParseLine("/M1")
   Display.Encrypt = ParseLine("/M2")

   No.Display.Drive = ParseLine("/B")
   Continuous.Display = ParseLine("/C")
   Short.Display = ParseLine("/E")
   Display.Search = ParseLine("/G")
   Skip.Current = ParseLine("/J")
   Short.Filenames = ParseLine("/K")
   Double.Line = ParseLine("/L")
   Disable.Cmd = ParseLine("/P")
   Display.Dirs.Counted = ParseLine("/Q")
   Recurse.Directories = ParseLine("/R")
   Remove.Slash = ParseLine("/U")
   Display.Volume = ParseLine("/V")
   Wide.Display = ParseLine("/W")
   Display.Lowercase = ParseLine("/Y")
   Display.Only.Errors = ParseLine("/Z1")
   Display.Errors = ParseLine("/Z")
   Enable.Redirect = ParseLine("/@")
   Ignore.Prompts = ParseLine("/#")

   ' check wide display
   If Wide.Display Then
      Double.Line = False
      Short.Display = True
      Short.Filenames = True
      Wide.List = 0
   End If

   ' override dir search
   If VarQ Then
      Display.Search = -1
      Recurse.Directories = -1
   End If

   ' set attribute display variable
   Display.Attribute = False
   If Display.Archive Or No.Display.Archive Then
      Display.Attribute = True
   End If
   If Display.Hidden Or No.Display.Hidden Then
      Display.Attribute = True
   End If
   If Display.Readonly Or No.Display.Readonly Then
      Display.Attribute = True
   End If
   If Display.System Or No.Display.System Then
      Display.Attribute = True
   End If
   If Display.Any Or No.Display.Any Then
      Display.Attribute = True
   End If
   If Display.Directory Or No.Display.Directory Then
      Display.Attribute = True
   End If
   If Display.Compress Or No.Display.Compress Then
      Display.Attribute = True
   End If
   If Display.Encrypt Or No.Display.Encrypt Then
      Display.Attribute = True
   End If

   ' reset file counter variable
   Dirs.Counted = FalseD
   Dirs.Displayed = FalseD
   Files.Counted = FalseD
   More.Display = False
   
   ' get date\time from command line
   Search.From.Date = False
   Search.To.Date = False
   Search.From.Time = False
   Search.To.Time = False
   Imbedded = InStr(UCase$(Command.Line), "/D")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      D$ = Mid$(Command.Line, Imbedded + 2, 21)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 23)
      If Len(D$) <> 21 Then
         GoTo Boot.Error
      End If
      If Mid$(D$, 11, 1) <> "-" Then
         GoTo Boot.Error
      End If
      S$ = Left$(D$, 10)
      D1! = Int(Val(Mid$(S$, 1, 2)))
      D2! = Int(Val(Mid$(S$, 4, 2)))
      D3! = Int(Val(Mid$(S$, 7, 4)))
      Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
      S$ = Right$(D$, 10)
      D1! = Int(Val(Mid$(S$, 1, 2)))
      D2! = Int(Val(Mid$(S$, 4, 2)))
      D3! = Int(Val(Mid$(S$, 7, 4)))
      Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
      If Search.From.Date < False Or Search.To.Date < False Then
         GoTo Boot.Error
      End If
   End If
   Imbedded = InStr(UCase$(Command.Line), "/T")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      T$ = Mid$(Command.Line, Imbedded + 2, 17)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 19)
      If Len(T$) <> 17 Then
         GoTo Boot.Error
      End If
      If Mid$(T$, 9, 1) <> "-" Then
         GoTo Boot.Error
      End If
      S$ = Left$(T$, 8)
      T1! = Int(Val(Mid$(S$, 1, 2)))
      T2! = Int(Val(Mid$(S$, 4, 2)))
      T3! = Int(Val(Mid$(S$, 7, 2)))
      Search.From.Time = T1! * 2048 + T2! * 32 + T3!
      S$ = Right$(T$, 8)
      T1! = Int(Val(Mid$(S$, 1, 2)))
      T2! = Int(Val(Mid$(S$, 4, 2)))
      T3! = Int(Val(Mid$(S$, 7, 2)))
      Search.To.Time = T1! * 2048 + T2! * 32 + T3!
      If Search.From.Time < False Or Search.To.Time < False Then
         GoTo Boot.Error
      End If
   End If

   ' get file size from command line
   Search.File.Size = False
   Search.Size.From = FalseD
   Search.Size.To = FalseD
   Imbedded = InStr(UCase$(Command.Line), "/F")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Search.File.Size = True
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
      GoSub Get.Numeric
      Search.Size.From = Var#
      If Mid$(Command.Line, Imbedded, 1) <> "-" Then
         GoTo Boot.Error
      End If
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
      GoSub Get.Numeric
      Search.Size.To = Var#
      Search.Size.From = Search.Size.From * Kilo
      Search.Size.To = Search.Size.To * Kilo
   End If

   ' get extended date\time switches
   Creation.Time = ParseLine("/1")
   Access.Time = ParseLine("/2")
   Modified.Time = ParseLine("/3")
   If Creation.Time = False Then
      If Access.Time = False Then
         If Modified.Time = False Then
            Modified.Time = True
         End If
      End If
   End If

   ' get nested switch from command line
   Imbedded = InStr(UCase$(Command.Line), "/N")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
      GoSub Get.Numeric
      Nested.Recurse = CInt(Var#)
   End If

   ' recheck command line
   If InStr(Command.Line, "/") Then
      GoTo Boot.Error
   End If
   Command.Line = RTrim$(Command.Line)
   If Switch.Exist Then
      If Len(Command.Line) > Last.Switch Then
         GoTo Boot.Error
      End If
   End If

   ' reset work variables
   Files.Counter = False
   Nested.Levels = False
   Quit.Searching = False
   Total.Bytes = False
   Files.Counted = False
   Volumes.Counted = False

   ' display header
   Header.Flag = False
   GoSub Header

   ' remove blanks from command line
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   Command.Line.Redirect$ = Command.Line
   StdinCount = 1
   Do
      ' get standard input
      Standard.Input$ = ""
      If Stdin Then
         If StdinLines > 0 Then ' nul:
            Do Until StdinCount > StdinLines
               Standard.Input$ = StdinArray(StdinCount)
               Standard.Input$ = RTrim$(LTrim$(Standard.Input$))
               If Standard.Input$ <> "" Then
                  Exit Do
               End If
               StdinCount = StdinCount + 1
            Loop
            If StdinCount > StdinLines Then
               Exit Do
            End If
         End If
      End If

      ' store entire command
      Command.Line = Command.Line.Redirect$

      ' filename processing loop
      Do
         ' store redirected input
         Standard.Input$ = RTrim$(Standard.Input$)
         Standard.Input$ = LTrim$(Standard.Input$)
         If Left$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Mid$(Standard.Input$, 2)
         End If
         If Right$(Standard.Input$, 1) = Quote Then
            Standard.Input$ = Left$(Standard.Input$, Len(Standard.Input$) - 1)
         End If

         ' store entire command
         If Left$(Command.Line, 1) = Quote Then
            Imbedded = InStr(2, Command.Line, Quote)
            If Imbedded Then
               Command.Work = Standard.Input$ + Mid$(Command.Line, 2, Imbedded - 2)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         Else
            Imbedded = InStr(Command.Line, " ")
            If Imbedded Then
               Command.Work = Standard.Input$ + Left$(Command.Line, Imbedded - 1)
               Command.Line = Mid$(Command.Line, Imbedded + 1)
            Else
               Command.Work = Standard.Input$ + Command.Line
               Command.Line = Nul
            End If
         End If
         Command.Line = LTrim$(Command.Line)
         Command.Line = RTrim$(Command.Line)

         ' locate filelist character
         Flag = False
         Command.Out$ = Command.Work
         Command.Out2$ = Nul
         If Mid$(Command.Out$, 2, 1) = ":" Then
            Command.Out2$ = Left$(Command.Out$, 2)
            Command.Out$ = Mid$(Command.Out$, 3)
         End If
         If Left$(Command.Out$, 1) = "@" Then
            Flag = True
            Command.Out$ = Mid$(Command.Out$, 2)
         Else
            For Var = Len(Command.Out$) To 1 Step -1
               If Mid$(Command.Out$, Var, 1) = "\" Then
                  Char$ = Mid$(Command.Out$, Var + 1)
                  If Left$(Char$, 1) = "@" Then
                     Flag = True
                     Command.Out$ = Left$(Command.Out$, Var) + Mid$(Char$, 2)
                  End If
                  Exit For
               End If
            Next
         End If
         If Len(Command.Out2$) Then
            Command.Out$ = Command.Out2$ + Command.Out$
         End If

         ' process work filename
         If Flag And Enable.Redirect Then

            ' concatenate work filename
            Var$ = Command.Work ' command line filename
            For Var = Len(Var$) To 1 Step -1
               If Mid$(Var$, Var, 1) = "\" Then
                  Var$ = Mid$(Var$, Var + 1)
                  Exit For
               End If
            Next
            If Mid$(Var$, 2, 1) = ":" Then
               Var$ = Mid$(Var$, 3)
            End If
            Filename2$ = Var$
            Var$ = Mid$(Var$, 2)
            Var2$ = Command.Out$
            For Var = Len(Var2$) To 1 Step -1
               If Mid$(Var2$, Var, 1) = "\" Then
                  Var2$ = Left$(Var2$, Var)
                  Var$ = Var2$ + Var$
                  Exit For
               End If
            Next

            ' check excluded file
            If Len(Exclude.List) Then
               Filename1$ = UCase$(RTrim$(Exclude.List))
               Filename2$ = UCase$(RTrim$(Filename2$))
               Call CheckExcluded(Filename1$, Filename2$)
               If Exclude.File Then
                  Max.DirRecurse = 0
                  Call Whereis_ProcessCommand
                  GoTo Next.Filename
               End If
            End If

            ' prompt for filelist
            If Ignore.Prompts = False Then

               ' prompt to use filelist
               Prompt2$ = "Use " + Quote + LCase$(Var$) + Quote + " as filelist(y/n/q/c)?"
               Call MorePrompt(Prompt2$, "ynqc", Outpt$)
               Select Case Outpt$
                  Case "c"
                     Ignore.Prompts = True
                  Case "q"
                     Quit.Searching = True
                     GoTo Next.Filename
                  Case "n"
                     Max.DirRecurse = 0
                     Call Whereis_ProcessCommand
                     GoTo Next.Filename
               End Select
            End If

            ' open work filename
            DataError = False
            Error.Flag = True
            V = FreeFile
            Open Command.Out$ For Input Shared As #V
            Error.Flag = False

            ' check error flag
            If DataError Then
               Call DisplayError("Error opening filelist.")
            Else
               ' process input filenames
               Max.DirRecurse = 0
               Do Until EOF(V)
                  ' get next filename
                  Line Input #V, Command.Work

                  ' process search filename
                  Command.Work = RTrim$(Command.Work)
                  If Len(Command.Work) Then
                     Call Whereis_ProcessCommand
                     ' check recurse error
                     If Max.DirRecurse >= RecurseLevel Then
                        Exit Do
                     End If
                  End If
               Loop
               Close #V
            End If
         Else
            ' process remaining filenames
            Max.DirRecurse = 0
            Call Whereis_ProcessCommand
         End If

         ' continue label
         Next.Filename:

         ' check search filename
         If Command.Line = Nul Then
            Exit Do
         End If

         ' check quit searching
         If Quit.Searching Then
            Exit Do
         End If
      Loop

      ' check stdin
      StdinCount = StdinCount + 1
      If StdinCount > StdinLines Then
         Exit Do
      End If

      ' check quit searching
      If Quit.Searching Then
         Exit Do
      End If
   Loop

   ' display end program
   If Wide.List Then
      Wide.List = False
      Print
   End If
   If Continuous.Display = False Then
      Color Yellow, Black
      If Display.Volume Then
         Total$ = FormatString$(CDbl(Volumes.Counted))
         Print "Volumes counted: "; Total$
      Else
         If Display.Dirs.Counted = False Then
            Total$ = FormatString$(Dirs.Counted)
            Print "Directories counted: "; Total$
         Else
            Total$ = FormatString$(Dirs.Displayed)
            Print "Directories displayed: "; Total$
         End If
         Total$ = FormatString$(Files.Counted)
         Print "Files counted: "; Total$
         If Double.Line Then
            Total$ = FormatString$(Total.Bytes)
            Print "Bytes counted: "; Total$
         End If
      End If
   End If

   ' reset color
   Color Plain, Black
   Exit Sub

   ' make header
   Header:
   If Header.Flag Then
      Return
   End If
   Header.Flag = True
   If Continuous.Display = False Then
      Color White, Black
      Print "File search utility;"
   End If
   Return

   ' display program usage
   Boot.Usage:
   Display.Page = 1
   Do
      Select Case Display.Page
         Case 1
            GoSub Display.Page.One
         Case 2
            GoSub Display.Page.Two
      End Select
      Prompt2$ = "Press 1, 2, or q to quit:"
      Call MorePrompt(Prompt2$, "12q", Outpt$)
      Select Case Outpt$
         Case "1"
            Display.Page = 1
         Case "2"
            Display.Page = 2
         Case "q"
            Color Plain, Black
            Return
      End Select
   Loop
   Color Plain, Black
   Print "Exiting to prompt:"
   Exit Sub

   Display.Page.One:
   GoSub Display.Header
   Print "  /b  suppress drive letter      /c  continuous display"
   Print "  /e  short filename display     /g  display search directories"
   Print "  /j  skip current directory     /k  use 8.3 short filenames"
   Print "  /l  double line display        /nxxx  nested directories"
   Print "  /q  directory count override   /r  recurse directories"
   Print "  /u  remove trailing slash      /v  display volume label"
   Print "  /w  wide file list             /y  display lowercase"
   Print "  /z  no error messages          /z1 display only errors"
   Print "display ranges:"
   Print "  /1  creation, /2  last access, /3  modify time"
   Print "  /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
   Print "  /t  is range of file times in form hh:mm:ss-hh:mm:ss"
   Print "  /f  is range of file sizes in form xxx-xxx in kilobytes"
   Return

   Display.Page.Two:
   GoSub Display.Header
   Print "  filelist switches:"
   Print "    /@  enable filelists   /#  ignore filelist prompts"
   Print "  exclude file list switch:"
   Print "    /(<filename.ext>)"
   Print "      excludes files containing ? and * characters."
   Print "  display file attributes: / prefix for files with, // prefix for files without"
   Print "    a  archive, h  hidden, i  directory, o  read-only, s  system"
   Print "    m1  compressed,  m2  encrypted, x  none"
   Print "  DOS command: /[<command>]"
   Print "    with command replacement parameters: (use /p for /c override);"
   Print "      %1 = d:, %2 = d:\, %3 = d:\pathname, %4 = d:\pathname\"
   Print "      %5 = d:\pathname\filename.ext, %6 = \pathname, %7 = \pathname\"
   Print "      %8 = \pathname\filename.ext, %9 = filename.ext, %a = filename"
   Print "      %b = .ext, %c = ext, //1 = >, //2 = <, //3 = |, //4 = %, //5 = ]"
   Return

   Display.Header:
   Color White, Black
   Print "DIR"
   Print "  File search utility;"
   Color Yellow, Black
   Print "Usage:"
   Print "  DIR [@][d:\path\filename.ext][//ahimosx][/bcdefgjklnpqrtuvwyz@#][/123]"
   Print "Where:"
   Return

   Get.Numeric:
   Var# = False
   Do
      Temp$ = Mid$(Command.Line, Imbedded, 1)
      If Temp$ >= "0" And Temp$ <= "9" Then
         Var# = Var# * 10 + Val(Temp$)
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
      Else
         Exit Do
      End If
   Loop
   Return

   Boot.Error:
   Color White, Black
   Print "Command line error. Type DIR /? for help."
   Color Plain, Black
   ErrFlag = -1
End Sub

Rem constructs and checks filelist filename exists.
Rem   returns ambiguated filename.
Function FILELISTEXISTS$ (Var$)
   ' construct filelist filename.
   VarX$ = Var$
   V = InStr(VarX$, "@")
   If V = 0 Then
      FILELISTEXISTS$ = Nul
      Exit Function
   End If
   For V = Len(VarX$) To 1 Step -1
      If Mid$(VarX$, V, 1) = "@" Then
         Exit For
      End If
   Next
   If V = 1 Then ' @filelist.txt
      VarX$ = Mid$(VarX$, V + 1)
   Else
      If V > 1 Then
         If Mid$(VarX$, V - 1, 1) = "\" Then ' \dos\@filelist.txt
            VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 1)
         Else
            If Mid$(VarX$, V - 1, 1) = ":" Then ' c:@filelist.txt
               VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 1)
            End If
         End If
      End If
   End If
   ' check filelist filename exists.
   If InStr(V, VarX$, "\") Then ' c:\@path\filename.ext
      FILELISTEXISTS$ = Nul
   Else
      If _FileExists(VarX$) = 0 Then
         FILELISTEXISTS$ = Nul
      Else
         FILELISTEXISTS$ = VarX$
      End If
   End If
End Function

Sub Whereis_ProcessCommand
   ' check recurse error
   If Max.DirRecurse >= RecurseLevel Then
      Exit Sub
   End If

   ' store current drive
   If Mid$(Command.Work, 2, 1) = ":" Then
      Drive.Search = Left$(Command.Work, 1)
      Command.Work = Mid$(Command.Work, 3)
   Else
      Drive.Search = Current.Drive
   End If
   Drive.Search = UCase$(Drive.Search)

   ' store current directory
   Directory.Search$ = ""
   Imbedded1 = InStr(Command.Work, "\")
   Imbedded2 = Imbedded1
   While Imbedded1
      Imbedded2 = Imbedded1
      Imbedded1 = InStr(Imbedded1 + 1, Command.Work, "\")
   Wend
   If Imbedded2 Then
      Directory.Search$ = Left$(Command.Work, Imbedded2)
      Command.Work = Mid$(Command.Work, Imbedded2 + 1)
   End If
   If Directory.Search$ = "" Then
      If Left$(Current.Directory, 2) = "\\" Then
         Directory.Search$ = Current.Directory
      Else
         If Drive.Search = Current.Drive Then
            Directory.Search$ = Mid$(Current.Directory, 3)
         Else
            Directory.Search$ = "\"
         End If
      End If
   End If
   If Right$(Directory.Search$, 1) <> "\" Then
      Directory.Search$ = Directory.Search$ + "\"
   End If
   
   ' get filename spec
   Filename.Search$ = RTrim$(Command.Work)
   V = InStr(Filename.Search$, Chr$(0))
   If V Then
      Filename.Search$ = Left$(Filename.Search$, V - 1)
   End If
   If Filename.Search$ = Nul Then
      Filename.Search$ = "*.*"
   End If
   Command.Work = Nul
   
   ' display search filename
   If Continuous.Display = False Then
      Color Yellow, Black
      If Left$(Directory.Search$, 2) = "\\" Then
         Print "Searching: " + Directory.Search$ + Filename.Search$
      Else
         If Display.Volume Then
            Print "Searching: " + Drive.Search + ":"
         Else
            If Left$(Directory.Search$, 1) = "@" Then
               Print "Searching: " + Directory.Search$ + Filename.Search$
            Else
               Print "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
            End If
         End If
      End If
      Files.Counter = Files.Counter + 1
   End If

   ' call routine to search for files
   If Display.Volume Then
      Call Whereis_DisplayVolume(Drive.Search)
   Else
      If Left$(Directory.Search$, 2) = "\\" Then
         Call Whereis_Directories(Directory.Search$, Filename.Search$)
      Else
         V = Asc(UCase$(Left$(Drive.Search$, 1))) - 64
         If MEDIAEXISTS(V) Then
            Call Whereis_Directories(Directory.Search$, Filename.Search$)
         End If
      End If
   End If
End Sub

' subroutine to access directories
Sub Whereis_Directories (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' check to quit
   If Quit.Searching Then
      Exit Sub
   End If

   ' check recurse error
   If Max.DirRecurse >= RecurseLevel Then
      Exit Sub
   End If

   ' display directories searched
   If Display.Search Then
      ' check skip directory
      Flag = True
      If Skip.Current Then
         If First.Directory = False Then
            First.Directory = True
            Flag = False
         End If
      End If
      If Flag Then
         ' count only directories displayed
         Dirs.Displayed = Dirs.Displayed + 1#
         ' store directory
         Filename$ = Directory.Search$
         If Filename$ <> "" Then
            If Remove.Slash Then
               Filename$ = Left$(Filename$, Len(Filename$) - 1)
            End If
         End If
         ' store drive letter
         If No.Display.Drive = False Then
            If Left$(Filename$, 2) <> "\\" Then
               Filename$ = Drive.Search + ":" + Filename$
            End If
         End If
         ' store directory
         Outpt$ = RTrim$(Filename$)
         Length = Len(Outpt$)
         If Length Then
            ' display directory
            Color Yellow, Black
            Print Outpt$
            ' check paginate
            Files.Counter = Files.Counter + Int(Length / 80) + 1
            Call PagePrompt(Files.Counter, FlagX)
            If FlagX Then
               Files.Counter = 0
            End If
            If Quit.Searching Then
               Exit Sub
            End If
         End If
      End If
   End If

   ' store directory asciiz
   If Left$(Directory.Search$, 2) <> "\\" Then
      If Left$(Directory.Search$, 1) = "@" Then
         ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)
      Else
         ASCIIZ = Drive.Search + ":" + Directory.Search$ + "*.*" + Chr$(0)
      End If
   Else
      ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)
   End If

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search directory names
      Call Whereis_Filenames(Directory.Search$, Filename.Search$)

      ' check to recurse directories
      If Recurse.Directories Then

         ' recurse directories
         Do
            ' check to quit
            If Quit.Searching Then
               Exit Do
            End If

            ' check max recurse levevl
            If Max.DirRecurse >= RecurseLevel Then
               Exit Do
            End If

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            If (Attribute And &H10) = &H10 Then

               ' store directory name
               Directory$ = finddata.cFileName
               Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

               ' check directory name
               If Directory$ <> "." And Directory$ <> ".." Then

                  ' check unicode
                  If InStr(Directory$, "?") Then
                     Directory$ = finddata.cAlternateFileName
                     V = InStr(Directory$, Chr$(0))
                     If V Then Directory$ = Left$(Directory$, V - 1)
                  End If

                  ' make next search directory
                  Next.Directory$ = Directory.Search$ + Directory$ + "\"

                  ' check recursion levels
                  Recursion% = True
                  If Nested.Recurse > False Then
                     Nested.Levels = Nested.Levels + 1
                     If Nested.Levels >= Nested.Recurse Then
                        Recursion% = False
                     End If
                  End If

                  ' recursively search subdirectories
                  If Recursion% Then
                     Dirs.Counted = Dirs.Counted + 1#
                     Call Whereis_Directories(Next.Directory$, Filename.Search$)
                  End If
                  If Nested.Recurse > False Then
                     Nested.Levels = Nested.Levels - 1
                  End If
               End If
            End If
         Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      End If
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to access filenames in directory
Sub Whereis_Filenames (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' check to quit
   If Quit.Searching Then
      Exit Sub
   End If

   ' check recurse error
   If Max.DirRecurse >= RecurseLevel Then
      Exit Sub
   End If

   ' make filename
   Var1$ = Directory.Search$
   If Left$(Var1$, 2) <> "\\" Then
      If Left$(Var1$, 1) = "\" Then
         Var1$ = Drive.Search + ":" + Var1$
      End If
   End If
   Var2$ = Filename.Search$
   If Left$(Var2$, 1) = "@" And Enable.Redirect Then
      Var2$ = Mid$(Var2$, 2)
   End If

   Var1$ = RTrim$(Var1$)
   Var2$ = RTrim$(Var2$)

   ASCIIZ = Var1$ + Var2$ + Chr$(0)
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search filenames
      Do
         ' check to quit
         If Quit.Searching Then
            Exit Do
         End If

         ' store file data
         finddatatemp = finddata

         ' check directory attribute
         Attribute = finddata.dwFileAttributes

         ' store filename
         Filename$ = finddata.cFileName
         Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

         ' check unicode
         If InStr(Filename$, "?") And CurrentCommand < CommandCount Then
            Filename$ = finddata.cAlternateFileName
            V = InStr(Filename$, Chr$(0))
            If V Then Filename$ = Left$(Filename$, V - 1)
         End If

         ' store short filename
         Short.Directory$ = finddata.cAlternateFileName
         V = InStr(Short.Directory$, Chr$(0))
         If V Then Short.Directory$ = Left$(Short.Directory$, V - 1)
         If Short.Directory$ = Nul Then
            Short.Directory$ = finddata.cFileName
            V = InStr(Short.Directory$, Chr$(0))
            If V Then Short.Directory$ = Left$(Short.Directory$, V - 1)
         End If

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then

            ' check for directory
            If (Attribute And &H10) = &H10 Then
               ' increment directories actually searched
               Dirs.Counted = Dirs.Counted + 1#
            End If

            ' store file size
            File.Size = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

            ' recursively call filelists
            If Left$(Filename.Search$, 1) = "@" And Enable.Redirect Then
               Filelist.Filename$ = Directory.Search$ + Filename$

               ' check recursion level
               Max.DirRecurse = Max.DirRecurse + 1
               If Max.DirRecurse >= RecurseLevel Then
                  Call DisplayError("Recursive filelist error level" + Str$(RecurseLevel) + ".")
                  Flag = False
                  Exit Do
               End If

               ' reset prompt flag
               Flag = True

               ' concatenate work filename
               Var$ = Filename$ ' command line filename
               For Var = Len(Var$) To 1 Step -1
                  If Mid$(Var$, Var, 1) = "\" Then
                     Var$ = Mid$(Var$, Var + 1)
                     Exit For
                  End If
               Next
               If Mid$(Var$, 2, 1) = ":" Then
                  Var$ = Mid$(Var$, 3)
               End If
               Filename2$ = Var$
               Var2$ = Filelist.Filename$
               For Var = Len(Var2$) To 1 Step -1
                  If Mid$(Var2$, Var, 1) = "\" Then
                     Var2$ = Left$(Var2$, Var)
                     Var$ = Var2$ + Var$
                     Exit For
                  End If
               Next

               ' check excluded file
               If Len(Exclude.List) Then
                  Filename1$ = UCase$(RTrim$(Exclude.List))
                  Filename2$ = UCase$(RTrim$(Filename2$))
                  Call CheckExcluded(Filename1$, Filename2$)
                  If Exclude.File Then
                     Flag = False
                  End If
               End If

               ' prompt for filelist
               If Ignore.Prompts = False Then

                  ' prompt to use filelist
                  If Flag Then
                     Prompt2$ = "Use " + Quote + LCase$(Var$) + Quote + " as filelist(y/n/q)?"
                     Call MorePrompt(Prompt2$, "ynq", Outpt$)
                     Select Case Outpt$
                        Case "q"
                           Quit.Searching = True
                           Flag = False
                        Case "n"
                           Flag = False
                     End Select
                  End If
               End If

               ' open work filename
               If Flag Then
                  V = FreeFile
                  DataError = False
                  Error.Flag = True
                  Open Filelist.Filename$ For Input Shared As #V
                  Error.Flag = False

                  ' check error flag
                  If DataError Then
                     Call DisplayError("Error opening filelist.")
                  Else
                     ' process input filenames
                     Do Until EOF(V)
                        Line Input #V, Next.Filename$
                        Next.Filename$ = RTrim$(Next.Filename$)
                        If Len(Next.Filename$) Then
                           ' process search filename
                           Command.Work = Next.Filename$
                           Call Whereis_ProcessCommand
                           ' check recurse error
                           If Max.DirRecurse >= RecurseLevel Then
                              Exit Do
                           End If
                        End If
                     Loop
                     Close #V
                  End If
               End If
            Else
               ' display filename info
               Call Whereis_DisplayFiles(Directory.Search$, Filename$)
            End If
         End If

         ' check to quit
         If Quit.Searching Then
            Exit Do
         End If

         ' check max recurse levevl
         If Max.DirRecurse >= RecurseLevel Then
            Exit Do
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to display volume information
Sub Whereis_DisplayVolume (Var$)
   ' check drive exists
   D = Asc(Var$) - 64
   If DRIVEEXISTS(D) Then
      Exit Sub
   End If

   ' increment volume counter
   Volumes.Counted = Volumes.Counted + 1

   ' get drive info.
   VarX$ = Var$ + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)

   ' display volume information
   Outpt$ = Var$ + ":"
   If CurrentCommand = CommandCount Then
      Color Yellow, Black
      Print #StdoutHandle, Outpt$;
   End If
   If R = 0 Then
      If CurrentCommand = CommandCount Then
         Print #StdoutHandle, DriveType;
      Else
         Outpt$ = Outpt$ + DriveType
      End If
      If Double.Line Then
         If CurrentCommand = CommandCount Then
            Color Red, Black
            Print #StdoutHandle, " (????-????)";
            Color White, Black
            Print #StdoutHandle, " [????]";
         Else
            Outpt$ = Outpt$ + " (????-????) [????]"
         End If
      End If
      If CurrentCommand = CommandCount Then
         Print #StdoutHandle, ""
      Else
         Call AddStdout2(Outpt$)
      End If
      Exit Sub
   End If

   ' volume label
   Outpt2$ = RTrim$(Vname$)
   v = InStr(Outpt2$, Chr$(0))
   If v Then Outpt2$ = Left$(Outpt2$, v - 1)
   If Outpt2$ = "" Then Outpt2$ = "<none>"

   Outpt$ = Outpt$ + Outpt2$
   If CurrentCommand = CommandCount Then
      Print #StdoutHandle, Outpt2$;
   End If
   If Double.Line = False Then
      If CurrentCommand = CommandCount Then
         Print #StdoutHandle, ""
      Else
         Call AddStdout2(Outpt$)
      End If
      Exit Sub
   End If

   ' display volume serial number
   Color Red, Black
   Outpt2$ = " (" + Left$(Hex$(serial~&), 4) + "-" + Right$(Hex$(serial~&), 4) + ")"
   Outpt$ = Outpt$ + Outpt2$
   If CurrentCommand = CommandCount Then
      Print #StdoutHandle, Outpt2$;
   End If

   ' display volume system type.
   Color White, Black
   Var2$ = RTrim$(Fname$)
   v = InStr(Var2$, Chr$(0))
   If v Then Var2$ = Left$(Var2$, v - 1)
   Outpt2$ = " [" + Var2$ + "]"
   Outpt$ = Outpt$ + Outpt2$
   If CurrentCommand = CommandCount Then
      Print #StdoutHandle, Outpt2$
   Else
      Call AddStdout2(Outpt$)
   End If
End Sub

' subroutine to display a filename
Sub Whereis_DisplayFiles (Search.Directory$, Search.Filename$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long

   ' get file attributes
   Attribute = finddatatemp.dwFileAttributes

   ' make filename
   File.List$ = Search.Directory$ + Short.Directory$
   If Left$(File.List$, 2) <> "\\" Then
      File.List$ = Drive.Search$ + ":" + File.List$
   End If

   ' check file attribute
   If Display.Attribute Then

      ' check for readonly file
      If Display.Readonly Then
         If (Attribute And &H1) <> &H1 Then
            Exit Sub
         End If
      End If
      If No.Display.Readonly Then
         If (Attribute And &H1) = &H1 Then
            Exit Sub
         End If
      End If

      ' check for hidden file
      If Display.Hidden Then
         If (Attribute And &H2) <> &H2 Then
            Exit Sub
         End If
      End If
      If No.Display.Hidden Then
         If (Attribute And &H2) = &H2 Then
            Exit Sub
         End If
      End If

      ' check for system file
      If Display.System Then
         If (Attribute And &H4) <> &H4 Then
            Exit Sub
         End If
      End If
      If No.Display.System Then
         If (Attribute And &H4) = &H4 Then
            Exit Sub
         End If
      End If

      ' check for directory file
      If Display.Directory Then
         If (Attribute And &H10) <> &H10 Then
            Exit Sub
         End If
      End If
      If No.Display.Directory Then
         If (Attribute And &H10) = &H10 Then
            Exit Sub
         End If
      End If

      ' check for archive file
      If Display.Archive Then
         If (Attribute And &H20) <> &H20 Then
            Exit Sub
         End If
      End If
      If No.Display.Archive Then
         If (Attribute And &H20) = &H20 Then
            Exit Sub
         End If
      End If

      ' check for compressed file
      If Display.Compress Then
         If (Attribute And &H800) <> &H800 Then
            Exit Sub
         End If
      End If
      If No.Display.Compress Then
         If (Attribute And &H800) = &H800 Then
            Exit Sub
         End If
      End If

      ' check for encrypted file
      If Display.Encrypt Then
         If (Attribute And &H4000) <> &H4000 Then
            Exit Sub
         End If
      End If
      If No.Display.Encrypt Then
         If (Attribute And &H4000) = &H4000 Then
            Exit Sub
         End If
      End If

      ' check for no attributes
      If Display.Any Then
         If (Attribute And &H1) = &H1 Then
            Exit Sub
         End If
         If (Attribute And &H2) = &H2 Then
            Exit Sub
         End If
         If (Attribute And &H4) = &H4 Then
            Exit Sub
         End If
         If (Attribute And &H10) = &H10 Then
            Exit Sub
         End If
         If (Attribute And &H20) = &H20 Then
            Exit Sub
         End If
         If (Attribute And &H800) = &H800 Then
            Exit Sub
         End If
         If (Attribute And &H4000) = &H4000 Then
            Exit Sub
         End If
      End If
      If No.Display.Any Then
         If (Attribute And &H1) = &H0 Then
            If (Attribute And &H2) = &H0 Then
               If (Attribute And &H4) = &H0 Then
                  If (Attribute And &H10) = &H0 Then
                     If (Attribute And &H20) = &H0 Then
                        If (Attribute And &H800) = &H0 Then
                           If (Attribute And &H4000) = &H0 Then
                              Exit Sub
                           End If
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If

   ' check file size
   If Search.File.Size Then
      If Search.Size.From = FalseD And Search.Size.To = FalseD Then
         If File.Size <> FalseD Then
            Exit Sub
         End If
      Else
         If Search.Size.From > FalseD Or Search.Size.To > FalseD Then
            If Search.Size.From > FalseD Then
               If Search.Size.To = FalseD Then
                  If File.Size < Search.Size.From Then
                     Exit Sub
                  End If
               End If
            End If
            If Search.Size.From = FalseD Then
               If Search.Size.To > FalseD Then
                  If File.Size > Search.Size.To Then
                     Exit Sub
                  End If
               End If
            End If
            If Search.Size.From <= Search.Size.To Then
               If File.Size < Search.Size.From Or File.Size > Search.Size.To Then
                  Exit Sub
               End If
            End If
            If Search.Size.From > Search.Size.To Then
               If File.Size < Search.Size.From And File.Size > Search.Size.To Then
                  Exit Sub
               End If
            End If
         End If
      End If
   End If

   ' store file date and time
   If Creation.Time Then
      x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
      GoSub Convert.Date
      GoSub Convert.Time
   Else
      If Access.Time Then
         x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
         GoSub Convert.Date
         GoSub Convert.Time
      Else
         If Modified.Time Then
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
            GoSub Convert.Date
            GoSub Convert.Time
         End If
      End If
   End If

   ' check date\time range
   If Search.From.Date Or Search.To.Date Then
      If File.Work.Date < Search.From.Date Then
         Exit Sub
      End If
      If File.Work.Date > Search.To.Date Then
         Exit Sub
      End If
   End If
   If Search.From.Time Or Search.To.Time Then
      If File.Work.Time < Search.From.Time Then
         Exit Sub
      End If
      If File.Work.Time > Search.To.Time Then
         Exit Sub
      End If
   End If

   ' make filename
   File.List$ = Search.Filename$
   Display.Filename$ = Search.Filename$
   If Short.Filenames Then
      Display.Filename$ = Short.Directory$
   End If
   If Short.Display Then
      File.List$ = Display.Filename$
   Else
      File.List$ = Search.Directory$ + Display.Filename$
   End If
   If No.Display.Drive = False Then
      If Left$(File.List$, 2) <> "\\" Then
         File.List$ = Drive.Search + ":" + File.List$
      End If
   End If
   If Left$(Search.Directory$, 2) = "\\" Then
      If Mid$(File.List$, 2, 1) = ":" Then
         File.List$ = Mid$(File.List$, 3)
      End If
   End If
   If (Attribute And &H10) = &H10 Then
      If Display.Only.Errors = False Then
         If Remove.Slash = False Then
            File.List$ = File.List$ + "\"
         End If
      End If
   End If

   ' check excluded file
   If Len(Exclude.List) Then
      Filename1$ = UCase$(RTrim$(Exclude.List))
      Filename2$ = UCase$(RTrim$(Search.Filename$))
      Call CheckExcluded(Filename1$, Filename2$)
      If Exclude.File Then
         Exit Sub
      End If
   End If

   ' check for directory bit
   If (Attribute And &H10) <> &H10 Then
      ' increment files counted
      Files.Counted = Files.Counted + 1#
      Total.Bytes = Total.Bytes + File.Size
   End If

   ' display directory/filename
   If Display.Search = False Then
      ' check for directory bit
      If (Attribute And &H10) = &H10 Then
         Dirs.Displayed = Dirs.Displayed + 1#
      End If

      ' format filename
      If Display.Lowercase Then
         Outpt$ = LCase$(File.List$)
      Else
         If Short.Filenames Then
            Outpt$ = UCase$(File.List$)
         Else
            Outpt$ = RTrim$(File.List$)
         End If
      End If

      ' display output filename
      If CurrentCommand < CommandCount Then
         Call AddStdout2(Outpt$)
         Exit Sub ' exit after redirect to stream
      End If

      ' display wide format
      If Wide.Display Then
         If Len(Outpt$) > 15 Then
            Outpt$ = Left$(Outpt$, 14) + "~"
         End If
         Outpt$ = Left$(Outpt$, 15)
         Outpt$ = Outpt$ + Space$(16 - Len(Outpt$))
         Color Yellow, Black
         Print #StdoutHandle, Outpt$;
         Wide.List = Wide.List + 1
         If Wide.List = 5 Then
            Wide.List = False
            Print #StdoutHandle, ""
            Files.Counter = Files.Counter + 1
         End If
      Else
         ' display filename
         If Len(Outpt$) Then
            Color Yellow, Black
            Print #StdoutHandle, Outpt$
            Length = Len(Outpt$)
            Files.Counter = Files.Counter + Int(Length / 80) + 1
         End If
      End If

      ' exit redirect to handle
      If LCase$(StdoutFile$) <> "scrn:" Then
         Exit Sub
      End If

      ' check paginate
      Call PagePrompt(Files.Counter, FlagX)
      If FlagX Then
         Files.Counter = 0
      End If

      ' check quit searching
      If Quit.Searching Then
         Exit Sub
      End If

      ' check max recurse levevl
      If Max.DirRecurse >= RecurseLevel Then
         Exit Sub
      End If

      ' reset line length
      Length = False

      ' check extended display info
      If Double.Line Then
         ' reset display flag
         Var = False

         ' display file date\time
         Color Green, Black
         If Creation.Time Then
            GoSub Make.Date1
            GoSub Convert.Date
            GoSub Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + Len(Outpt$)
            Print Outpt$;
            Var = True
         End If
         If Access.Time Then
            If Creation.Time Then
               Outpt$ = "\"
               Length = Length + Len(Outpt$)
               Color White, Black
               Print Outpt$;
               Color Green, Black
            End If
            GoSub Make.Date2
            GoSub Convert.Date
            GoSub Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + Len(Outpt$)
            Print Outpt$;
            Var = True
         End If
         If Modified.Time Then
            If Creation.Time Or Access.Time Then
               Outpt$ = "\"
               Length = Length + Len(Outpt$)
               Color White, Black
               Print Outpt$;
               Color Green, Black
            End If
            GoSub Make.Date3
            GoSub Convert.Date
            GoSub Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + Len(Outpt$)
            Print Outpt$;
            Var = True
         End If
         If Var Then ' check flag
            Outpt$ = " "
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         ' check for directory bit
         If (Attribute And &H10) = &H10 Then
            Size$ = "<dir>"
         Else
            Size$ = FormatString$(File.Size)
         End If

         ' display file size
         Color Red, Black
         Outpt$ = Size$
         Length = Length + Len(Outpt$)
         Print Outpt$;
         Color White, Black

         ' check for directory file
         If (Attribute And &H10) = &H10 Then
            Outpt$ = " Directory"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         ' check for read-only file
         If (Attribute And 1) = 1 Then
            Outpt$ = " Read-only"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         ' check for hidden file
         If (Attribute And 2) = 2 Then
            Outpt$ = " Hidden"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         ' check for system file
         If (Attribute And 4) = 4 Then
            Outpt$ = " System"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         ' check for archive file
         If (Attribute And &H20) = &H20 Then
            Outpt$ = " Archive"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         ' check for compressed
         If (Attribute And &H800) = &H800 Then
            Outpt$ = " Compressed"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         ' check for encryption
         If (Attribute And &H4000) = &H4000 Then
            Outpt$ = " Encrypted"
            Length = Length + Len(Outpt$)
            Print Outpt$;
         End If

         Print

         ' increment counter for extra line
         Files.Counter = Files.Counter + Int(Length / 80) + 1
      End If

      ' check paginate
      Call PagePrompt(Files.Counter, FlagX)
      If FlagX Then
         Files.Counter = 0
      End If

      ' check quit searching
      If Quit.Searching Then
         Exit Sub
      End If

      ' check max recurse levevl
      If Max.DirRecurse >= RecurseLevel Then
         Exit Sub
      End If
   End If

   ' check to run DOS command
   If Len(DOS.Command) Then
      Call ExecuteCommand(Search.Directory$ + Display.Filename$)
   End If
   Exit Sub

   Make.Date1:
   x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
   Return

   Make.Date2:
   x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
   Return

   Make.Date3:
   x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
   Return

   Convert.Date:
   YearTemp! = SysTime.wYear
   MonthTemp! = SysTime.wMonth
   DayTemp! = SysTime.wDay
   File.Date$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
   File.Date$ = File.Date$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
   File.Date$ = File.Date$ + LTrim$(Str$(SysTime.wYear))
   File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
   Return

   Convert.Time:
   HourTemp! = SysTime.wHour
   MinuteTemp! = SysTime.wMinute
   SecondsTemp! = SysTime.wSecond
   File.Time$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
   File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
   Return
End Sub

' check to paginate
Sub PagePrompt (Var, Flag)
   Flag = False
   If LCase$(StdoutFile$) <> "scrn:" Then
      Flag = True
      Exit Sub
   End If
   If Status Then
      Z = 21
   Else
      Z = 22
   End If
   If Var >= Z Then
      Flag = True
      If Continuous.Display = False Then
         If More.Display = False Then
            Prompt2$ = "More(y/n/c)?"
            Call MorePrompt(Prompt2$, "ync" + Chr$(13), Outpt$)
            Select Case Outpt$
               Case "c"
                  More.Display = True
               Case "n"
                  Quit.Searching = True
            End Select
         End If
      End If
   End If
End Sub

' subroutine to shell to dos
Sub ShellSub (x$)
   z$ = Mid$(x$, 6) ' shell
   If LTrim$(RTrim$(z$)) = "/?" Then
      Call DisplayHelp("shell")
      Exit Sub
   End If
   _Title Program + " - SHELL"
   If UCase$(x$) = "SHELL" Then ' nul parameter.
      Start.Shell:
      Comspec$ = Environ$("COMSPEC")
      If Len(Comspec$) Then
         Shell Comspec$
      Else
         Shell "CMD"
      End If
      _Title Program
      Exit Sub
   End If
   z$ = STRIM$(z$)
   If Right$(z$, 1) = Quote And Left$(z$, 1) = Quote Then
      z$ = Left$(z$, Len(z$) - 1)
      z$ = Mid$(z$, 2)
   End If
   z$ = STRIM$(z$)
   If z$ = Nul Then GoTo Start.Shell
   If Node Then
      BatchFile$ = "QBSHELL" + LTrim$(Str$(Node)) + ".BAT"
   Else
      BatchFile$ = "QBSHELL.BAT"
   End If
   DOScommand$ = z$
   X = FreeFile
   Open BatchFile$ For Output As #X
   Print #X, "@ECHO OFF"
   Print #X, DOScommand$
   Print #X, "PAUSE"
   Print #X, "EXIT"
   Close #X
   Shell BatchFile$
   f$ = BatchFile$ + Chr$(0)
   X = DeleteFileA(f$)
   _Title Program
End Sub

' subroutine to execute DOS command
Sub ExecuteCommand (DOS.Filename$)
   ' make replacement parameters
   DOS.Pathname$ = DOS.Filename$
   Imbedded1 = InStr(DOS.Pathname$, "\")
   Imbedded2 = False
   While Imbedded1
      Imbedded2 = Imbedded1
      Imbedded1 = InStr(Imbedded1 + 1, DOS.Pathname$, "\")
   Wend
   Filename$ = Mid$(DOS.Pathname$, Imbedded2 + 1)
   If Imbedded2 Then
      DOS.Pathname$ = Left$(DOS.Pathname$, Imbedded2 - 1)
   Else
      DOS.Pathname$ = Nul
   End If
   Extension$ = Nul
   Imbedded = InStr(Filename$, ".")
   If Imbedded Then
      Extension$ = Mid$(Filename$, Imbedded + 1)
      Filename$ = Left$(Filename$, Imbedded - 1)
   End If

   ' store replacement parameters
   If Left$(DOS.Filename$, 2) = "\\" Then
      Parameters(1) = "\\"
      Parameters(2) = "\\"
      Parameters(3) = DOS.Pathname$
      Parameters(4) = DOS.Pathname$ + "\"
      Parameters(5) = DOS.Filename$
   Else
      Parameters(1) = Drive.Search + ":"
      Parameters(2) = Drive.Search + ":\"
      Parameters(3) = Drive.Search + ":" + DOS.Pathname$
      Parameters(4) = Drive.Search + ":" + DOS.Pathname$ + "\"
      Parameters(5) = Drive.Search + ":" + DOS.Filename$
   End If
   Parameters(6) = DOS.Pathname$
   Parameters(7) = DOS.Pathname$ + "\"
   Parameters(8) = DOS.Filename$
   Parameters(9) = Filename$ + "." + Extension$
   Parameters(10) = Filename$
   Parameters(11) = "." + Extension$
   Parameters(12) = Extension$

   ' create DOS command
   Execute.Command$ = DOS.Command

   ' replace parameters
   Count = 1
   Do
      If Count >= Len(Execute.Command$) Then
         Exit Do
      End If
      Imbed$ = Mid$(Execute.Command$, Count, 1)
      If Imbed$ = "%" Then
         Imbed2$ = Mid$(Execute.Command$, Count + 1, 1)
         Select Case UCase$(Imbed2$)
            Case "1" To "9", "A" To "C"
               Count2 = Val("&H" + Imbed2$)
               Execute.Command$ = Left$(Execute.Command$, Count - 1) + RTrim$(Parameters(Count2)) + Mid$(Execute.Command$, Count + 2)
               Count = Count + Len(RTrim$(Parameters(Count2)))
            Case Else
               Count = Count + 1
         End Select
      Else
         Count = Count + 1
      End If
   Loop

   ' start DOS command shell
   If Len(Execute.Command$) Then
      ' check display counter
      If Wide.List Then
         Wide.List = False
         Print
      End If

      ' read command path from environment
      Comspec$ = Environ$("COMSPEC")
      If Len(Comspec$) Then
         ' call shell routine
         If Disable.Cmd Then
            Shell.Command$ = Comspec$ + " /C " + Execute.Command$
         Else
            Shell.Command$ = Comspec$ + " /K " + Execute.Command$
         End If
         Shell Shell.Command$
      End If
   End If
End Sub

' routine compares occurrence of filename1$ in filename2$
' with pattern matching.
Sub CheckExcluded (Filename1$, Filename2$)
   Exclude.File = True ' assume mask matches filename2.
   Length1 = 1
   Length2 = 1
   Do
      ' global replacement.
      If Mid$(Filename1$, Length1, 1) = "*" Then
         Do
            Length1 = Length1 + 1
            If Length1 > Len(Filename1$) Then
               Exit Sub
            End If
            ' global replacement followed by exclusion character.
            ' searches remaining string until exclusion character found or not.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               Do
                  If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                     Length2 = Length2 + 1
                  Else
                     Exclude.File = False
                     Exit Sub
                  End If
                  If Length2 > Len(Filename2$) Then
                     Exit Sub
                  End If
               Loop
            End If
            ' global replacement followed by ? or another *
            ' skips to next character.
            If Mid$(Filename1$, Length1, 1) <> "*" Then
               If Mid$(Filename1$, Length1, 1) <> "?" Then
                  Exit Do
               End If
            End If
         Loop
         ' global replacement.
         ' searches for next matching character.
         Do
            If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
               Exit Do
            Else
               Length2 = Length2 + 1
            End If
            If Length2 > Len(Filename2$) Then
               Exit Do
            End If
         Loop
      Else
         ' character replacement.
         ' matches any next character.
         If Mid$(Filename1$, Length1, 1) = "?" Then
            Length1 = Length1 + 1
            Length2 = Length2 + 1
         Else
            ' exclusion character.
            ' checks next character unmatched.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Exclude.File = False
                  Exit Do
               End If
            Else
               ' matches next character.
               If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Exclude.File = False
                  Exit Do
               End If
               ' check string lengths.
               If Length1 > Len(Filename1$) Then
                  If Length2 <= Len(Filename2$) Then
                     Exclude.File = False
                  End If
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
End Sub

Sub Zsort (ErrFlag)
   ' check command line
   StdoutLines = 0
   Last.Switch = 0
   Switch.Exist = 0
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   If Command.Line = "/?" Then
      GoTo Boot.Usage
   End If

   ' check command line switches
   Continuous.Display = ParseLine("/C")
   Ignore.Case = ParseLine("/I")
   Reverse.Sort = ParseLine("/R")
   Strip.Blanks = ParseLine("/T")
   Strip.Drives = ParseLine("/D")

   ' get sort column
   Sort.Column = 1
   Imbedded = InStr(UCase$(Command.Line), "/N")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Imbedded2 = Imbedded + 2
      Do
         Switch$ = Mid$(Command.Line, Imbedded2, 1)
         If Switch$ >= "0" And Switch$ <= "9" Then
            Column$ = Column$ + Switch$
         Else
            Exit Do
         End If
         Imbedded2 = Imbedded2 + 1
      Loop
      If Column$ = Nul Then
         GoTo Boot.Error
      End If
      Sort.Column = Int(Val(Column$))
      If Sort.Column = False Then
         GoTo Boot.Error
      End If
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded2)
   End If

   ' recheck command line
   If InStr(Command.Line, "/") Then
      GoTo Boot.Error
   End If
   Command.Line = RTrim$(Command.Line)
   If Switch.Exist Then
      If Len(Command.Line) > Last.Switch Then
         GoTo Boot.Error
      End If
   End If

   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)

   If Stdin Then
      Call SortStdin
   End If
   If Command.Line = "" Then
      Exit Sub
   End If

   ' filename processing loop
   Do
      ' store entire command
      If Left$(Command.Line, 1) = Quote Then
         Imbedded = InStr(2, Command.Line, Quote)
         If Imbedded Then
            Command.Work = Mid$(Command.Line, 2, Imbedded - 2)
            Command.Line = Mid$(Command.Line, Imbedded + 1)
         Else
            Command.Work = Command.Line
            Command.Line = Nul
         End If
      Else
         Imbedded = InStr(Command.Line, " ")
         If Imbedded Then
            Command.Work = Left$(Command.Line, Imbedded - 1)
            Command.Line = Mid$(Command.Line, Imbedded + 1)
         Else
            Command.Work = Command.Line
            Command.Line = Nul
         End If
      End If
      Command.Line = LTrim$(Command.Line)
      Command.Line = RTrim$(Command.Line)

      ' sort parsed command line
      Call SortFiles

      ' check search filename
      If Command.Line = "" Then
         Exit Do
      End If

      ' check quit searching
      If Quit.Searching Then
         Exit Do
      End If
   Loop
   Exit Sub

   Boot.Usage:
   ' make header
   Color White, Black
   Print "SORT"
   Print "   Sort utility; "
   Color Yellow, Black
   Print "Usage:"
   Print "   SORT [\path\][filename] [/cdinrt]"
   Print "Where:"
   Print "   [\path\][filename] are the filename(s) to sort."
   Print "Switches:"
   Print "   /c  continuous list"
   Print "   /d  strip drive letters"
   Print "   /i  ignore case"
   Print "   /n###  sort at column"
   Print "   /r  reverse order"
   Print "   /t  strip blank lines"
   Color Plain, Black
   Exit Sub

   Boot.Error:
   Color White, Black
   Print "Command line error. Type SORT /? for help."
   Color Plain, Black
   ErrFlag = -1
End Sub

Sub SortStdin
   ' remove blank lines
   Num = StdinLines
   Dim Temp.Array(Num) As String
   NextNum = 0
   If Strip.Blanks Then
      Num = StdinLines
      For ArrayNum = 1 To Num
         Temp.Array(ArrayNum) = StdinArray(ArrayNum)
      Next
      For ArrayNum = 1 To Num
         Line1$ = RTrim$(Temp.Array(ArrayNum))
         If Len(Line1$) Then
            NextNum = NextNum + 1
            StdinArray(NextNum) = Line1$
         End If
      Next
      StdinLines = NextNum
   End If

   ' remove drive letters
   Num = StdinLines
   NextNum = 0
   If Strip.Drives Then
      Num = StdinLines
      For ArrayNum = 1 To Num
         Temp.Array(ArrayNum) = StdinArray(ArrayNum)
      Next
      For ArrayNum = 1 To Num
         Line1$ = RTrim$(Temp.Array(ArrayNum))
         If StripDrive(Line1$) = 0 Then
            NextNum = NextNum + 1
            StdinArray(NextNum) = Line1$
         End If
      Next
      StdinLines = NextNum
   End If

   ' shell sort
   Sort.Swaps = False
   Num = StdinLines
   Span = Int(Num / 2)
   Do While Span > False
      For Start = Span To Num - 1
         For Element = (Start - Span + 1) To 1 Step -Span
            Sort.Column1$ = RTrim$(Mid$(StdinArray(Element), Sort.Column))
            Sort.Column2$ = RTrim$(Mid$(StdinArray(Element + Span), Sort.Column))
            If Ignore.Case Then
               Sort.Column1$ = UCase$(Sort.Column1$)
               Sort.Column2$ = UCase$(Sort.Column2$)
            End If
            If Reverse.Sort Then
               If Sort.Column2$ = "" Then
                  Exit For
               Else
                  If Sort.Column2$ <= Sort.Column1$ Then
                     Exit For
                  End If
               End If
            Else
               If Sort.Column1$ = "" Then
                  Exit For
               Else
                  If Sort.Column1$ <= Sort.Column2$ Then
                     Exit For
                  End If
               End If
            End If
            Swap StdinArray(Element), StdinArray(Element + Span)
            Sort.Swaps = Sort.Swaps + 1
         Next
      Next
      Span = Int(Span / 2)
   Loop

   ' output array
   StdoutLines = 0
   For Array.Line# = 1 To StdinLines
      X$ = RTrim$(StdinArray(Array.Line#))
      SetOutpt = -1
      If Strip.Blanks Then
         If X$ = "" Then
            SetOutpt = 0
         End If
      End If
      If Strip.Drives Then
         If StripDrive(X$) Then
            SetOutpt = 0
         End If
      End If
      If SetOutpt Then
         Call AddStdout(X$)
      End If
   Next
   Exit Sub

   ' display counters
   If Continuous.Display = False Then
      Color Yellow, Black
      Print "Lines counted"; StdinLines
      Print "Sort swaps made"; Sort.Swaps
      Prompt2$ = "Press <enter> to return to QB64shell:"
      Call MorePrompt(Prompt2$, Chr$(13), Outpt$)
   End If
   Color Plain, Black
End Sub

Function GetFileLines# (Var$)
   Count# = 0#
   If _FileExists(Var$) Then
      X = FreeFile
      Open Var$ For Binary Shared As #X Len = xbuflen
      If LOF(X) > 0 Then
         Do Until EOF(X)
            ' get file buffer
            Get X, , xbuffer
            ' count linefeeds in file
            For L = 1 To xbuflen
               If Mid$(xbuffer, L, 1) = Chr$(10) Then
                  Count# = Count# + 1#
               End If
            Next
         Loop
      End If
      Close #X
   End If
   GetFileLines# = Count#
End Function

Function GetFileBytes# (Var$)
   Count# = 0#
   If _FileExists(Var$) Then
      X = FreeFile
      Open Var$ For Binary Shared As #X Len = xbuflen
      Count# = LOF(X)
      Close #X
   End If
   GetFileBytes# = Count#
End Function

Function GetFileBits# (Var$)
   Count# = 0#
   If _FileExists(Var$) Then
      X = FreeFile
      Open Var$ For Binary Shared As #X Len = xbuflen
      Count# = LOF(X)
      Close #X
   End If
   GetFileBits# = Count# * 8#
End Function

Function GetFileBitsHex# (Var$)
   Count# = 0#
   If _FileExists(Var$) Then
      X = FreeFile
      Open Var$ For Binary Shared As #X Len = xbuflen
      Count# = LOF(X)
      Close #X
   End If
   GetFileBitsHex# = Count# * 16#
End Function

Sub SortFiles
   ' declare subroutine variables
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' redimension sort array
   ReDim Sort.Array(1) As String

   Dim hfind As _Offset

   ' make filename
   Filename1$ = Command.Work
   ASCIIZ = Filename1$ + Chr$(0)

   ' check filename
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      r = FindClose(Wfile.Handle)
   Else
      Exit Sub
   End If

   ' test file open
   f$ = Filename1$ + Chr$(0)
   hfind = CreateFileAqb(f$, 4)
   If hfind = 0 Then
      Exit Sub
   End If

   ' check file exists
   If _FileExists(Filename1$) = 0 Then
      Exit Sub
   End If

   ' reset count variables
   Lines.Counted = 0
   Max.Sort.Lines = 1

   ' read array from file
   X = FreeFile
   Open Filename1$ For Binary As #X
   Count# = 0#
   If LOF(X) > 0 Then
      Do Until EOF(X)
         Line Input #X, line1$
         SetOutput = -1
         If Strip.Blanks And RTrim$(line1$) = "" Then
            SetOutpt = 0
         End If
         If Strip.Drives And StripDrive(RTrim$(line1$)) Then
            SetOutpt = 0
         End If
         If SetOutpt Then
            Count# = Count# + Len(line1$) + 2#
            Lines.Counted = Lines.Counted + 1
            If Lines.Counted > Max.Sort.Lines Then
               Max.Sort.Lines = Max.Sort.Lines + 1
               ReDim _Preserve Sort.Array(Max.Sort.Lines) As String
            End If
            Sort.Array(Lines.Counted) = line1$
         End If
      Loop
      If Count# < LOF(X) Then
         If Strip.Blanks = 0 Then
            Lines.Counted = Lines.Counted + 1
            If Lines.Counted > Max.Sort.Lines Then
               Max.Sort.Lines = Max.Sort.Lines + 1
               ReDim _Preserve Sort.Array(Max.Sort.Lines) As String
            End If
            Sort.Array(Lines.Counted) = ""
         End If
      End If
   End If
   Close #X

   ' shell sort
   Sort.Swaps = False
   Num = Lines.Counted
   Span = Int(Num / 2)
   Do While Span > False
      For Start = Span To Num - 1
         For Element = (Start - Span + 1) To 1 Step -Span
            Sort.Column1$ = RTrim$(Mid$(Sort.Array(Element), Sort.Column))
            Sort.Column2$ = RTrim$(Mid$(Sort.Array(Element + Span), Sort.Column))
            If Ignore.Case Then
               Sort.Column1$ = UCase$(Sort.Column1$)
               Sort.Column2$ = UCase$(Sort.Column2$)
            End If
            If Reverse.Sort Then
               If Sort.Column2$ = "" Then
                  Exit For
               Else
                  If Sort.Column2$ <= Sort.Column1$ Then
                     Exit For
                  End If
               End If
            Else
               If Sort.Column1$ = "" Then
                  Exit For
               Else
                  If Sort.Column1$ <= Sort.Column2$ Then
                     Exit For
                  End If
               End If
            End If
            Swap Sort.Array(Element), Sort.Array(Element + Span)
            Sort.Swaps = Sort.Swaps + 1
         Next
      Next
      Span = Int(Span / 2)
   Loop

   ' output array
   For Array.Line# = 1 To Lines.Counted
      X$ = RTrim$(Sort.Array(Array.Line#))
      Call AddStdout(X$)
   Next

   ' display counters
   If Continuous.Display = False Then
      Color Yellow, Black
      Print "Lines counted"; Lines.Counted
      Print "Sort swaps made"; Sort.Swaps
      Prompt2$ = "Press <enter> to return to QB64shell:"
      Call MorePrompt(Prompt2$, Chr$(13), Outpt$)
   End If
   Color Plain, Black
End Sub

Sub TypeY (ErrFlag)
   ' check command line
   Last.Switch = 0
   Switch.Exist = 0
   StdoutLines = 0
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   If Command.Line = "/?" Then
      GoTo Boot.Usage
   End If

   ' get current drive
   Current.Drive$ = Left$(_CWD$, 1)
   Current.Directory = _CWD$

   ' get switches from command line
   No.Display.Archive = ParseLine("//A")
   No.Display.Hidden = ParseLine("//H")
   No.Display.Readonly = ParseLine("//O")
   No.Display.System = ParseLine("//S")
   No.Display.Any = ParseLine("//X")
   No.Display.Compress = ParseLine("//M1")
   No.Display.Encrypt = ParseLine("//M2")

   Display.Archive = ParseLine("/A")
   Display.Hidden = ParseLine("/H")
   Display.Readonly = ParseLine("/O")
   Display.System = ParseLine("/S")
   Display.Any = ParseLine("/X")
   Display.Compress = ParseLine("/M1")
   Display.Encrypt = ParseLine("/M2")

   Continuous.Display = ParseLine("/C")
   Prompt.More = ParseLine("/P")
   Recurse.Directories = ParseLine("/R")
   Display.Errors = ParseLine("/Z")
   Strip.Blanks = ParseLine("/I")
   Strip.Drives = ParseLine("/U")

   ' get date\time from command line
   Search.From.Date = False
   Search.To.Date = False
   Search.From.Time = False
   Search.To.Time = False
   Imbedded = InStr(UCase$(Command.Line), "/D")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      D$ = Mid$(Command.Line, Imbedded + 2, 21)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 23)
      If Len(D$) <> 21 Then
         GoTo Boot.Error
      End If
      If Mid$(D$, 11, 1) <> "-" Then
         GoTo Boot.Error
      End If
      S$ = Left$(D$, 10)
      D1! = Int(Val(Mid$(S$, 1, 2)))
      D2! = Int(Val(Mid$(S$, 4, 2)))
      D3! = Int(Val(Mid$(S$, 7, 4)))
      Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
      S$ = Right$(D$, 10)
      D1! = Int(Val(Mid$(S$, 1, 2)))
      D2! = Int(Val(Mid$(S$, 4, 2)))
      D3! = Int(Val(Mid$(S$, 7, 4)))
      Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
      If Search.From.Date < False Or Search.To.Date < False Then
         GoTo Boot.Error
      End If
   End If
   Imbedded = InStr(UCase$(Command.Line), "/T")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      T$ = Mid$(Command.Line, Imbedded + 2, 17)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 19)
      If Len(T$) <> 17 Then
         GoTo Boot.Error
      End If
      If Mid$(T$, 9, 1) <> "-" Then
         GoTo Boot.Error
      End If
      S$ = Left$(T$, 8)
      T1! = Int(Val(Mid$(S$, 1, 2)))
      T2! = Int(Val(Mid$(S$, 4, 2)))
      T3! = Int(Val(Mid$(S$, 7, 2)))
      Search.From.Time = T1! * 2048 + T2! * 32 + Int(T3! / 2)
      S$ = Right$(T$, 8)
      T1! = Int(Val(Mid$(S$, 1, 2)))
      T2! = Int(Val(Mid$(S$, 4, 2)))
      T3! = Int(Val(Mid$(S$, 7, 2)))
      Search.To.Time = T1! * 2048 + T2! * 32 + Int(T3! / 2)
      If Search.From.Time < False Or Search.To.Time < False Then
         GoTo Boot.Error
      End If
   End If

   ' get display column
   Sort.Column = 1
   Imbedded = InStr(UCase$(Command.Line), "/N")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Imbedded2 = Imbedded + 2
      Do
         Switch$ = Mid$(Command.Line, Imbedded2, 1)
         If Switch$ >= "0" And Switch$ <= "9" Then
            Column$ = Column$ + Switch$
         Else
            Exit Do
         End If
         Imbedded2 = Imbedded2 + 1
      Loop
      If Column$ = Nul Then
         GoTo Boot.Error
      End If
      Sort.Column = Int(Val(Column$))
      If Sort.Column = False Then
         GoTo Boot.Error
      End If
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded2)
   End If

   ' recheck command line
   If InStr(Command.Line, "/") Then
      GoTo Boot.Error
   End If
   Command.Line = RTrim$(Command.Line)
   If Switch.Exist Then
      If Len(Command.Line) > Last.Switch Then
         GoTo Boot.Error
      End If
   End If

   ' initialize work variables
   Bytes.Counted = False
   Lines.Counted = False
   More.Display = False
   Quit.Searching = False

   ' remove blanks from command line
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)

   ' store entire command
   Command.Work = Command.Line

   ' display header
   Header.Flag = False
   GoSub Header
   If Stdin Then
      Call TypeStdin
   End If
   If Command.Line = "" Then
      Exit Sub
   End If

   ' filename processing loop
   Do
      ' store entire command
      If Left$(Command.Line, 1) = Quote Then
         Imbedded = InStr(2, Command.Line, Quote)
         If Imbedded Then
            Command.Work = Mid$(Command.Line, 2, Imbedded - 2)
            Command.Line = Mid$(Command.Line, Imbedded + 1)
         Else
            Command.Work = Command.Line
            Command.Line = Nul
         End If
      Else
         Imbedded = InStr(Command.Line, " ")
         If Imbedded Then
            Command.Work = Left$(Command.Line, Imbedded - 1)
            Command.Line = Mid$(Command.Line, Imbedded + 1)
         Else
            Command.Work = Command.Line
            Command.Line = Nul
         End If
      End If
      Command.Line = LTrim$(Command.Line)
      Command.Line = RTrim$(Command.Line)

      ' store current drive
      If Mid$(Command.Work, 2, 1) = ":" Then
         Drive.Search = Left$(Command.Work, 1)
         Command.Work = Mid$(Command.Work, 3)
      Else
         Drive.Search = Current.Drive$
      End If
      Drive.Search = UCase$(Drive.Search)

      ' store current directory
      Directory.Search$ = ""
      Imbedded1 = InStr(Command.Work, "\")
      Imbedded2 = Imbedded1
      While Imbedded1
         Imbedded2 = Imbedded1
         Imbedded1 = InStr(Imbedded1 + 1, Command.Work, "\")
      Wend
      If Imbedded2 Then
         Directory.Search$ = Left$(Command.Work, Imbedded2)
         Command.Work = Mid$(Command.Work, Imbedded2 + 1)
      End If
      If Directory.Search$ = "" Then
         If Left$(Current.Directory, 2) = "\\" Then
            Directory.Search$ = Current.Directory
         Else
            If Drive.Search$ = Current.Drive$ Then
               Directory.Search$ = Mid$(Current.Directory, 3)
            Else
               Directory.Search$ = "\"
            End If
         End If
      End If
      If Right$(Directory.Search$, 1) <> "\" Then
         Directory.Search$ = Directory.Search$ + "\"
      End If
   
      ' get filename spec
      Filename.Search$ = Command.Work
      If Filename.Search$ = Nul Then
         Filename.Search$ = "*.*"
      End If
      Command.Work = Nul

      ' display search filename
      If Continuous.Display = False Then
         Color Yellow, Black
         If Left$(Directory.Search$, 2) = "\\" Then
            Print "Searching: " + Directory.Search$ + Filename.Search$
         Else
            Print "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
         End If
      End If

      ' call routine to search for files
      If Left$(Directory.Search$, 2) = "\\" Then
         Call TypeY_Directories(Directory.Search$, Filename.Search$)
      Else
         V = Asc(UCase$(Left$(Drive.Search$, 1))) - 64
         If MEDIAEXISTS(V) Then
            Call TypeY_Directories(Directory.Search$, Filename.Search$)
         End If
      End If

      ' check search filename
      If Command.Line = Nul Then
         Exit Do
      End If

      ' check quit searching
      If Quit.Searching Then
         Exit Do
      End If
   Loop

   ' display end program
   If Continuous.Display = False Then
      Prompt2$ = "Press <enter> to return to QB64shell:"
      Call MorePrompt(Prompt2$, Chr$(13), Outpt$)
   End If
   Color Plain, Black
   Exit Sub

   ' display program usage
   Boot.Usage:
   ' make header
   Color White, Black
   Print "TYPE"
   Print "   File display utility; "
   Color Yellow, Black
   Print "Usage:"
   Print "   TYPE [d:\path\filename.ext][//ahmosx][/cdfinprtuz][/123]"
   Print "Where:"
   Print "   /c  continuous display   /i  strip blanks"
   Print "   /p  prompt for more      /nxxx  column display"
   Print "   /r  recurse directories  /u  strip drives"
   Print "   /z  suppress error messages"
   Print "   display ranges: (/1  creation, /2  last access  /3  modify time)"
   Print "     /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
   Print "     /t  is range of file times in form hh:mm:ss-hh:mm:ss"
   Print "     /f  is range of file sizes in form xxx-xxx in kilobytes"
   Print "   type files with attributes"
   Print "     / prefix for files with, // prefix for files without,"
   Print "       a  archive, h  hidden, o  read-only, s  system, x  none"
   Print "       m1  compressed, m2  encrypted"
   Color Plain, Black
   Exit Sub

   Boot.Error:
   Color White, Black
   Print "Command line error. Type TYPE /? for help."
   Color Plain, Black
   ErrFlag = -1
   Exit Sub

   ' make header
   Header:
   If Header.Flag Then
      Return
   End If
   Header.Flag = True
   If Continuous.Display = False Then
      Color White, Black
      Print "File content display utility; "
   End If
   Return
End Sub

' subroutine to access directories
Sub TypeY_Directories (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make directory filename
   ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search directory names
      Call TypeY_Filenames(Directory.Search$, Filename.Search$)

      ' check to recurse directories
      If Recurse.Directories Then

         ' recurse directories
         Do
            ' check to quit
            If Quit.Deleting Then
               Exit Do
            End If

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            If (Attribute And &H10) = &H10 Then

               ' store directory name
               Directory$ = finddata.cFileName
               Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

               ' check directory name
               If Directory$ <> "." And Directory$ <> ".." Then

                  ' check unicode
                  If InStr(Directory$, "?") Then
                     Directory$ = finddata.cAlternateFileName
                     V = InStr(Directory$, Chr$(0))
                     If V Then Directory$ = Left$(Directory$, V - 1)
                  End If

                  ' make next search directory
                  Next.Directory$ = Directory.Search$ + Directory$ + "\"

                  ' recursively search subdirectories
                  Call TypeY_Directories(Next.Directory$, Filename.Search$)
               End If
            End If
         Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      End If
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to access filenames in directory
Sub TypeY_Filenames (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make filename
   ASCIIZ = Directory.Search$ + Filename.Search$ + Chr$(0)

   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' check directory attribute
      Attribute = finddata.dwFileAttributes

      ' check for directory
      If (Attribute And &H10) = &H10 Then
         ' increment directories actually searched
         Dirs.Counted = Dirs.Counted + 1#
      End If

      ' recurse filename
      Do
         ' store filename
         Filename$ = finddata.cFileName
         Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

         ' check unicode
         If InStr(Filename$, "?") And CurrentCommand < CommandCount Then
            Filename$ = finddata.cAlternateFileName
            V = InStr(Filename$, Chr$(0))
            If V Then Filename$ = Left$(Filename$, V - 1)
         End If

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then

            ' store file data
            finddatatemp = finddata

            ' store file size
            File.Size = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            If (Attribute And &H10) <> &H10 Then
               Call TypeY_DisplayFiles(Directory.Search$, Filename$)
            End If
         End If

         ' check to quit
         If Quit.Deleting Then
            Exit Do
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to count and display filenames
Sub TypeY_DisplayFiles (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long

   ' check directory attribute
   Attribute = finddatatemp.dwFileAttributes

   ' check for readonly file
   If (Attribute And &H1) = &H1 Then
      If No.Display.Readonly Then
         Exit Sub
      End If
   Else
      If Display.Readonly Then
         Exit Sub
      End If
   End If

   ' check for hidden file
   If (Attribute And &H2) = &H2 Then
      If No.Display.Hidden Then
         Exit Sub
      End If
   Else
      If Display.Hidden Then
         Exit Sub
      End If
   End If

   ' check for system file
   If (Attribute And &H4) = &H4 Then
      If No.Display.System Then
         Exit Sub
      End If
   Else
      If Display.System Then
         Exit Sub
      End If
   End If

   ' check for archive file
   If (Attribute And &H20) = &H20 Then
      If No.Display.Archive Then
         Exit Sub
      End If
   Else
      If Display.Archive Then
         Exit Sub
      End If
   End If

   ' check for compressed file
   If (Attribute And &H800) = &H800 Then
      If No.Display.Compress Then
         Exit Sub
      End If
   Else
      If Display.Compress Then
         Exit Sub
      End If
   End If

   ' check for encrypted file
   If (Attribute And &H4000) = &H4000 Then
      If No.Display.Encrypt Then
         Exit Sub
      End If
   Else
      If Display.Encrypt Then
         Exit Sub
      End If
   End If

   ' check all attributes
   If Display.Any Then
      If (Attribute And &H1) = &H1 Then
         Exit Sub
      End If
      If (Attribute And &H2) = &H2 Then
         Exit Sub
      End If
      If (Attribute And &H4) = &H4 Then
         Exit Sub
      End If
      If (Attribute And &H20) = &H20 Then
         Exit Sub
      End If
      If (Attribute And &H800) = &H800 Then
         Exit Sub
      End If
      If (Attribute And &H4000) = &H4000 Then
         Exit Sub
      End If
   End If
   If No.Display.Any Then
      If (Attribute And &H1) = False Then
         If (Attribute And &H2) = False Then
            If (Attribute And &H4) = False Then
               If (Attribute And &H20) = False Then
                  If (Attribute And &H800) = False Then
                     If (Attribute And &H4000) = False Then
                        Exit Sub
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If

   ' check file size
   If Search.File.Size Then
      If Search.Size.From = FalseD And Search.Size.To = FalseD Then
         If File.Size <> FalseD Then
            Exit Sub
         End If
      Else
         If Search.Size.From > FalseD Or Search.Size.To > FalseD Then
            If Search.Size.From > FalseD Then
               If Search.Size.To = FalseD Then
                  If File.Size < Search.Size.From Then
                     Exit Sub
                  End If
               End If
            End If
            If Search.Size.From = FalseD Then
               If Search.Size.To > FalseD Then
                  If File.Size > Search.Size.To Then
                     Exit Sub
                  End If
               End If
            End If
            If Search.Size.From <= Search.Size.To Then
               If File.Size < Search.Size.From Or File.Size > Search.Size.To Then
                  Exit Sub
               End If
            End If
            If Search.Size.From > Search.Size.To Then
               If File.Size < Search.Size.From And File.Size > Search.Size.To Then
                  Exit Sub
               End If
            End If
         End If
      End If
   End If

   ' store file date and time
   If Creation.Time Then
      x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
      GoSub Convert.Date
      GoSub Convert.Time
   Else
      If Access.Time Then
         x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
         GoSub Convert.Date
         GoSub Convert.Time
      Else
         If Modified.Time Then
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
            GoSub Convert.Date
            GoSub Convert.Time
         End If
      End If
   End If

   ' check date\time range
   If Search.From.Date Or Search.To.Date Then
      If File.Work.Date < Search.From.Date Then
         Exit Sub
      End If
      If File.Work.Date > Search.To.Date Then
         Exit Sub
      End If
   End If
   If Search.From.Time Or Search.To.Time Then
      If File.Work.Time < Search.From.Time Then
         Exit Sub
      End If
      If File.Work.Time > Search.To.Time Then
         Exit Sub
      End If
   End If

   ' make directory filename
   If Display.Filenames Then
      Filename$ = Directory.Search$ + Filename.Search$
      If Prepend.Drive Then
         If Left$(Filename$, 2) <> "\\" Then
            Filename$ = Drive.Search + ":" + Filename$
         End If
      End If
      Color Yellow, Black
      Print Filename$
   End If

   ' update bytes counted
   Bytes.Counted = Bytes.Counted + File.Size

   ' update files counter
   Files.Counted = Files.Counted + 1#

   ' send contents of file to screen
   Call TypeY_DisplayFileLines(Directory.Search$, Filename.Search$)
   Exit Sub

   Convert.Date:
   YearTemp! = SysTime.wYear
   MonthTemp! = SysTime.wMonth
   DayTemp! = SysTime.wDay
   File.Date$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
   File.Date$ = File.Date$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
   File.Date$ = File.Date$ + LTrim$(Str$(SysTime.wYear))
   File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
   Return

   Convert.Time:
   HourTemp! = SysTime.wHour
   MinuteTemp! = SysTime.wMinute
   SecondsTemp! = SysTime.wSecond
   File.Time$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
   File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
   Return
End Sub

' subroutine to display lines in a filename
Sub TypeY_DisplayFileLines (Directory.Search$, Filename.Search$)
   ' make filename
   Filename.Count$ = Directory.Search$ + Filename.Search$
   If ValidFileChar(Filename.Search$) Then
      Short.Filename$ = finddatatemp.cAlternateFileName
      V = InStr(Short.Filename$, Chr$(0))
      If V Then Short.Filename$ = Left$(Short.Filename$, V - 1)
      Filename.Count$ = Directory.Search$ + Short.Filename$
      If ValidFileChar(Short.Filename$) Then
         Exit Sub
      End If
   End If
   If _FileExists(Filename.Count$) Then
      X = FreeFile
      Open Filename.Count$ For Binary Shared As #X
      Count# = 0#
      If LOF(X) > 0 Then
         Do Until EOF(X)
            Color Plain, Black
            Line Input #X, X$
            Count# = Count# + Len(X$) + 2#
            X$ = Mid$(X$, Sort.Column)
            Call AddStdout(X$)
         Loop
      End If
      If Count# < LOF(X) Then
         Call AddStdout("")
      End If
      Close #X
   End If
End Sub

' subroutine to display lines in standard input
Sub TypeStdin
   Color Plain, Black
   For StdinCount = 1 To StdinLines
      X$ = Mid$(StdinArray(StdinCount), Sort.Column)
      Call AddStdout(X$)
   Next
   Exit Sub
   ' display end program
   If Continuous.Display = False Then
      Prompt2$ = "Press <enter> to return to QB64shell:"
      Call MorePrompt(Prompt2$, Chr$(13), Outpt$)
   End If
   Color Plain, Black
End Sub

Sub AddStdout (X$)
   If Strip.Blanks Then
      If RTrim$(X$) = "" Then
         Exit Sub
      End If
   End If
   If Strip.Drives Then
      If StripDrive(RTrim$(X$)) Then
         Exit Sub
      End If
   End If
   If CurrentCommand < CommandCount Then
      StdoutLines = StdoutLines + 1
      If StdoutLines > StdoutMax Then
         StdoutMax = StdoutLines
         ReDim _Preserve StdoutArray(StdoutMax) As String
      End If
      StdoutArray(StdoutLines) = X$
   Else
      If LCase$(StdoutFile$) = "scrn:" Then
         Print X$
      Else
         Print #StdoutHandle, X$
      End If
   End If
End Sub

Sub AddStdout2 (X$)
   If CurrentCommand < CommandCount Then
      StdoutLines = StdoutLines + 1
      If StdoutLines > StdoutMax Then
         StdoutMax = StdoutLines
         ReDim _Preserve StdoutArray(StdoutMax) As String
      End If
      StdoutArray(StdoutLines) = X$
      Exit Sub
   End If
   Print #StdoutHandle, X$
End Sub

Sub AddStdout3 (X$)
   If CurrentCommand < CommandCount Then
      StdoutLines = StdoutLines + 1
      If StdoutLines > StdoutMax Then
         StdoutMax = StdoutLines
         ReDim _Preserve StdoutArray(StdoutMax) As String
      End If
      StdoutArray(StdoutLines) = X$
   End If
   Print X$
   Print #StdoutHandle, X$
End Sub

Rem file: Copyit.bas - Public Domain QB64 Utility v9.0a r4.0a 2017.

Sub Copyit (ErrFlag)
   _Title "COPYIT"

   ' get command line
   Last.Switch = 0
   Switch.Exist = 0
   Command.Line = COMMAND2$
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   If Command.Line = Nul Then
      Color Yellow, Black
      Print "Type COPY /? for help. Or edit " + CopyitConfig$ + " file."
      Color Plain, Black
      Exit Sub
   End If

   ' read command line switches
   Call ReadSwitches(VarX)
   If VarX > 0 Then
      ErrFlag = -1
      Color Plain, Black
      Exit Sub
   End If

   ' store skip file list
   Skip.Filenames(1) = "WIN386.SWP"
   Skip.Filenames(2) = "PAGEFILE.SYS"
   Skip.Filenames(3) = "HIBERFIL.SYS"
   Skip.Filenames(4) = "SWAPFILE.SYS"

   ' read current drive
   Current.Drive = Left$(_CWD$, 1)
   Current.Directory = _CWD$
   If Right$(Current.Directory, 1) <> "\" Then
      Current.Directory = Current.Directory + "\"
   End If

   ' store default directory
   If Left$(_CWD$, 2) = "\\" Then
      Default.Dir = _CWD$
   Else
      Default.Dir = Mid$(_CWD$, 3)
   End If

   ' store default server name
   Default.Net = Nul
   Var$ = Environ$("COMPUTERNAME")
   If Len(Var$) Then
      Default.Net = "\\" + Var$
   End If

   ' reset number of destination filenames
   If Number.Dest.Files = False Then
      Number.Dest.Files = 1
      Destinate.Filename(1) = Nul
   End If

   ' reset number of destination directories
   If Number.Dest.Dirs = False Or Zero.Dirs Then
      Zero.Dirs = True
      Number.Dest.Dirs = 1
      If Number.Dest.Nets = False Then
         Destinate.Directory(1) = Default.Dir
      Else
         Destinate.Directory(1) = "\"
      End If
   End If

   ' reset and check netpaths
   If Zero.Nets Then
      Var2$ = RTrim$(Default.Net)
      If Len(Var2$) Then
         Var2$ = Var2$ + LCase$(Current.Drive) + "\"
         Number.Dest.Nets = 1
         Destinate.Netpaths(1) = Var2$
      End If
   End If
   If Number.Dest.Nets = False Then
      Number.Dest.Nets = 1
      Destinate.Netpaths(1) = Nul
   End If
   For Count0 = 1 To Number.Dest.Nets
      Next.Dest.Net$ = Destinate.Netpaths(Count0)
      Next.Dest.Net$ = RTrim$(Next.Dest.Net$)
      If Next.Dest.Net$ <> Nul Then
         ' check netpath
         If Right$(Next.Dest.Net$, 1) = "\" Then
            Next.Dest.Net$ = Left$(Next.Dest.Net$, Len(Next.Dest.Net$) - 1)
         End If
         If Left$(Next.Dest.Net$, 2) <> "\\" Then
            Next.Dest.Net$ = "\" + Next.Dest.Net$
         End If
         If Left$(Next.Dest.Net$, 2) <> "\\" Then
            Next.Dest.Net$ = "\" + Next.Dest.Net$
         End If
         Destinate.Netpaths(Count0) = Next.Dest.Net$
      End If
   Next

   ' check /d omitted or specified w/o parameters
   If Zero.Dirs Then
      ' compare /g\\serv\c\ to default.net
      If Number.Dest.Nets = 1 Then
         Var1$ = RTrim$(Destinate.Netpaths(1))
         If Len(Var1$) Then
            Var1$ = UCase$(Var1$) + "\"
            Var2$ = RTrim$(Default.Net)
            If Len(Var2$) Then
               Var2$ = UCase$(Var2$) + Current.Drive + "\"
               If Var1$ = Var2$ Then
                  Destinate.Directory(1) = Default.Dir
               End If
            End If
         End If
      End If
   End If

   ' store time copying began
   Start.Time = Timer

   ' remove blanks from command line
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)
   Command.Line.Redirect$ = Command.Line
   StdinCount = 1
   Do
      ' get standard input
      Standard.Input$ = ""
      If Stdin Then
         If StdinLines > 0 Then ' nul:
            Do Until StdinCount > StdinLines
               Standard.Input$ = StdinArray(StdinCount)
               Standard.Input$ = RTrim$(LTrim$(Standard.Input$))
               If Standard.Input$ <> "" Then
                  Exit Do
               End If
               StdinCount = StdinCount + 1
            Loop
            If StdinCount > StdinLines Then
               Exit Do
            End If
         End If
      End If

      ' store entire command
      Command.Line = Command.Line.Redirect$

      ' search filespecs
      Do

         ' store input filename
         Stored.Command.Line$ = Command.Line

         ' create filenames
         Call Copyit_MakeFilename

         ' locate filelist character
         Command.Out$ = Command.Work

         ' check filelist character
         Flag = FilelistIS(Command.Out$)
         If Flag And Enable.Redirect Then

            ' reset recurse counter
            Max.CopyRecurse = 0

            ' process work filename containing filelist
            Call Copyit_ProcessFilelist(Command.Out$, -1)

            ' check overwrite flag
            If Quit.Searching Then
               Error.Level = 1
               GoTo End.Copy
            End If
         Else

            ' process filename
            Call Copyit_ProcessCommand(Quit)

            ' check overwrite flag
            If Quit Or Quit.Searching Then
               Error.Level = 1
               GoTo End.Copy
            End If
         End If

         ' check command line
         If Command.Line = Nul Then
            Exit Do
         End If

         ' check quit searching
         If Quit.Searching Then
            Exit Do
         End If
      Loop

      ' check stdin
      StdinCount = StdinCount + 1
      If StdinCount > StdinLines Then
         Exit Do
      End If

      ' check quit searching
      If Quit.Searching Then
         Exit Do
      End If
   Loop

   ' program end label
   End.Copy:

   ' check append files
   If Append.Files Then
      Call Copyit_CloseFile(-1)
   End If

   ' calculate time elapsed during file copying
   Stop.Time = Timer
   Time.Elapsed = Stop.Time - Start.Time

   ' check timing past midnight
   If Time.Elapsed < SFalse Then
      Time.Elapsed = Time.Elapsed + 86400! ' add one day of seconds
   End If

   ' display end program
   If Wide.List Then
      Wide.List = False
      Print
   End If
   If Continuous.Display = False Then
      If Continuous.Display2 = False Then
         Color Yellow, Black
         Print "Directories copied: ";
         Print FormatString$(Dirs.Counted)
         If Dirs.Created > 0 Then
            Print "Directories created: ";
            Print FormatString$(Dirs.Created)
         End If
         If Double.Line >= 4 Then
            Print "Directories deleted: ";
            Print FormatString$(Total.Deleted)
         End If
         Print "Files copied: ";
         Print FormatString$(Files.Counted)
         If Double.Line >= 4 Then
            Print "Bytes counted: ";
            Print FormatString$(Bytes.Copied)
            Print "Bytes copied: ";
            Print FormatString$(Total.Bytes)
            If Deleted.Files > 0# Then
               Print "Files deleted: ";
               Print FormatString$(Deleted.Files)
            End If
         End If
      End If

      ' check to display time/rate
      If Rate.Mode Then
         ' display transfer time
         Call Time.Display1

         ' display transfer rate
         Call Time.Display2
      End If

      ' prompt to exit Copyit
      Prompt2$ = "Press <enter> to return to QB64shell:"
      Call MorePrompt2(Prompt2$, Chr$(13), Outpt$, Chr$(13))
   End If

   ' reset color
   Color Plain, Black
   Exit Sub

   ' make header
   Header:
   If Header.Flag Then
      Return
   End If
   Header.Flag = True
   If Continuous.Display = False Then
      Color White, Black
      Print "COPY " + CopyitVersion$ + " " + CopyitRelease$ + ": File copy utility; "
   End If
   Return
End Sub

' clear display progress
Sub Copyit_ClearDisplay (Var)
   ' break wide list
   If Var = 0 Then
      If Wide.List Then
         Wide.List = False
         Print
      End If
   End If
   _ControlChr On
   ' clear dots
   For Count = 1 To Dot.Count
      Print Chr$(29); " "; Chr$(29);
   Next
   ' clear percent display
   If Percent.Display Then
      If Percent.Flag Then
         For Imbedded = 1 To 4
            Print Chr$(29); " "; Chr$(29);
         Next
      End If
   End If
   ' clear progress bar
   If Progress.Bar Then
      For Imbedded = 1 To Current.Progress
         Print Chr$(29); " "; Chr$(29);
      Next
   End If
   _ControlChr Off
   Dot.Count = False
   Dot.Total = False
   Count.Forward = True
   Current.Progress = False
End Sub

' process filelist recursively
Sub Copyit_ProcessFilelist (Command.Out$, PromptFlag)
   Dim ASCIIZ As String * 260
   Dim hfind As _Offset

   ' check recurse error
   If Max.CopyRecurse >= RecurseLevel Then
      Exit Sub
   End If

   ' process work filename
   Var$ = Nul
   If Command.Out$ <> Nul Then
      If _FileExists(Command.Out$) Then
         Var$ = Command.Out$
      End If
   End If

   ' check filelist exists
   If Var$ <> Nul Then

      ' concatenate work filename
      Var$ = Command.Work ' command line filename
      For Var = Len(Var$) To 1 Step -1
         If Mid$(Var$, Var, 1) = "\" Then
            Var$ = Mid$(Var$, Var + 1)
            Exit For
         End If
      Next
      If Mid$(Var$, 2, 1) = ":" Then
         Var$ = Mid$(Var$, 3)
      End If
      Filename2$ = Var$
      Var$ = Mid$(Var$, 2)
      Var2$ = Command.Out$
      For Var = Len(Var2$) To 1 Step -1
         If Mid$(Var2$, Var, 1) = "\" Then
            Var2$ = Left$(Var2$, Var)
            Var$ = Var2$ + Var$
            Exit For
         End If
      Next

      ' check filename
      Call Copyit_CheckFile(Filename2$, True)
      If Check.Flag = False Then
         Var$ = Nul
      End If

      ' prompt for filelist
      If Disable.Prompts = False Then
         If Var$ <> Nul Then
            If PromptFlag Then
               ' prompt to use filelist
               Prompt2$ = "Use " + Quote + LCase$(Var$) + Quote + " as filelist(y)es,(n)o,(q)uit?"
               Call MorePrompt2(Prompt2$, "ynq", Outpt$, "y")
               Select Case Outpt$
                  Case "q"
                     Quit.Searching = True
                     Exit Sub
                  Case "n"
                     Var$ = Nul
                     Exit Sub
               End Select
            End If
         End If
      End If
   End If

   ' check filelist exists
   If Var$ = Nul Then

      ' restore original command line
      Command.Line = Stored.Command.Line$

      ' create filenames
      Call Copyit_MakeFilename

      ' continue processing filename
      Exit Sub
   End If

   ' open filename list
   x = 0
   ASCIIZ = Command.Out$ + Chr$(0)
   hfind = CreateFileAqb(Command.Out$, 3)
   If hfind = 0 Then
      ' display filename error
      Call Copyit_DisplayError("Error" + Str$(GetLastError&) + " opening listfile.")
      Exit Sub
   End If

   V = FreeFile
   DataError = False
   Error.Flag = True
   Open Command.Out$ For Input Shared As #V
   Error.Flag = False

   ' check error flag
   If DataError Then
      ' display filename error
      Call Copyit_DisplayError("Error" + Str$(DataError) + " opening listfile.")
      Exit Sub
   End If

   ' check recursion level
   Max.CopyRecurse = Max.CopyRecurse + 1
   If Max.CopyRecurse >= RecurseLevel Then
      Call Copyit_DisplayError("Recursive filelist error level" + Str$(RecurseLevel) + ".")
      Exit Sub
   End If

   ' process input filenames
   Do Until EOF(V)

      ' read next filename from input file
      Line Input #V, Command.Work
      Command.Work = RTrim$(Command.Work)

      ' check input
      If Len(Command.Work) Then

         ' locate filelist character
         Var2$ = Command.Work
         Flag = FilelistIS(Var2$)
         If Flag Then
            ' recursively call filelist
            Call Copyit_ProcessFilelist(Var2$, 0)
         Else
            ' process filename
            Call Copyit_ProcessCommand(Quit)
         End If

         ' check overwrite flag
         If Quit Or Quit.Searching Then
            Error.Level = 1
            Exit Do
         End If
      End If
   Loop
   Close #V

   ' check recursion level
   Max.CopyRecurse = Max.CopyRecurse - 1
End Sub

' return -1 for filelist character
Function FilelistIS (Command.Out$)
   Flag = False
   Command.Out2$ = Nul
   If Mid$(Command.Out$, 2, 1) = ":" Then
      Command.Out2$ = Left$(Command.Out$, 2)
      Command.Out$ = Mid$(Command.Out$, 3)
   End If
   If Left$(Command.Out$, 1) = "@" Then
      Flag = True
      Command.Out$ = Mid$(Command.Out$, 2)
   Else
      For Var = Len(Command.Out$) To 1 Step -1
         If Mid$(Command.Out$, Var, 1) = "\" Then
            Char$ = Mid$(Command.Out$, Var + 1)
            If Left$(Char$, 1) = "@" Then
               Flag = True
               Command.Out$ = Left$(Command.Out$, Var) + Mid$(Char$, 2)
            End If
            Exit For
         End If
      Next
   End If
   If Len(Command.Out2$) Then
      Command.Out$ = Command.Out2$ + Command.Out$
   End If
   FilelistIS = Flag
End Function

' routine to copy a filename
Sub Copyit_Files (Next.Dest.Net$, Source.Directory$, Source.Filename$)
   ' declare subroutine variables
   Dim ASCIIZ As String * 260
   Dim ASCIIZwrite As String * 260
   Dim Handle As Integer
   Dim Number.Bytes As Integer
   Dim Sum.Bytes As Double
   Dim Sum.Bytes2 As Double

   ' make filename
   Temp.Net$ = RTrim$(Source.Net)
   If Temp.Net$ = Nul Then
      ASCIIZ = Source.Directory$ + Source.Filename$ + Chr$(0)
   Else
      If Left$(Directory.Search$, 1) = "\" Then
         ASCIIZ = Temp.Net$ + Source.Directory$ + Source.Filename$ + Chr$(0)
      Else
         ASCIIZ = Temp.Net$ + "\" + Source.Directory$ + Source.Filename$ + Chr$(0)
      End If
   End If

   ' read file attributes
   Attribute = GetFileAttributes(ASCIIZ)

   ' check directory
   If (Attribute And &H10) = &H10 Then
      Exit Sub
   End If

   ' store file attribute
   Source.Attribute = Attribute

   ' check file attribute
   If Display.Attribute Then

      ' check for readonly file
      If Display.Readonly = True Then
         If (Attribute And 1) <> 1 Then
            Exit Sub
         End If
      End If
      If No.Display.Readonly = True Then
         If (Attribute And 1) = 1 Then
            Exit Sub
         End If
      End If

      ' check for hidden file
      If Display.Hidden = True Then
         If (Attribute And 2) <> 2 Then
            Exit Sub
         End If
      End If
      If No.Display.Hidden = True Then
         If (Attribute And 2) = 2 Then
            Exit Sub
         End If
      End If

      ' check for system file
      If Display.System = True Then
         If (Attribute And 4) <> 4 Then
            Exit Sub
         End If
      End If
      If No.Display.System = True Then
         If (Attribute And 4) = 4 Then
            Exit Sub
         End If
      End If

      ' check for archive file
      If Display.Archive = True Then
         If (Attribute And &H20) <> &H20 Then
            Exit Sub
         End If
      End If
      If No.Display.Archive = True Then
         If (Attribute And &H20) = &H20 Then
            Exit Sub
         End If
      End If

      ' check for compressed file
      If Display.Compressed = True Then
         If (Attribute And &H800) <> &H800 Then
            Exit Sub
         End If
      End If
      If No.Display.Compressed = True Then
         If (Attribute And &H800) = &H800 Then
            Exit Sub
         End If
      End If

      ' check for encrypted file
      If Display.Encrypted = True Then
         If (Attribute And &H4000) <> &H4000 Then
            Exit Sub
         End If
      End If
      If No.Display.Encrypted = True Then
         If (Attribute And &H4000) = &H4000 Then
            Exit Sub
         End If
      End If

      ' check for no attributes
      If Display.Any = True Then
         If (Attribute And 1) = 1 Then
            Exit Sub
         End If
         If (Attribute And 2) = 2 Then
            Exit Sub
         End If
         If (Attribute And 4) = 4 Then
            Exit Sub
         End If
         If (Attribute And &H20) = &H20 Then
            Exit Sub
         End If
      End If
      If No.Display.Any = True Then
         If (Attribute And 1) = False Then
            If (Attribute And 2) = False Then
               If (Attribute And 4) = False Then
                  If (Attribute And &H20) = False Then
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
   End If

   ' reset destination file attribute
   If Set.Dest.Readonly Then
      Attribute = Attribute Or 1
   End If
   If Set.Dest.Hidden Then
      Attribute = Attribute Or 2
   End If
   If Set.Dest.System Then
      Attribute = Attribute Or 4
   End If
   If Set.Dest.Archive Then
      Attribute = Attribute Or &H20
   End If
   If Set.Dest.Any Then
      Attribute = Attribute Or &H27
   End If
   If Clear.Dest.Readonly Then
      Attribute = Attribute And Not 1
   End If
   If Clear.Dest.Hidden Then
      Attribute = Attribute And Not 2
   End If
   If Clear.Dest.System Then
      Attribute = Attribute And Not 4
   End If
   If Clear.Dest.Archive Then
      Attribute = Attribute And Not &H20
   End If
   If Clear.Dest.Any Then
      Attribute = Attribute And Not &H27
   End If

   ' reset source file attribute
   If Set.Source.Readonly Then
      Source.Attribute = Source.Attribute Or 1
   End If
   If Set.Source.Hidden Then
      Source.Attribute = Source.Attribute Or 2
   End If
   If Set.Source.System Then
      Source.Attribute = Source.Attribute Or 4
   End If
   If Set.Source.Archive Then
      Source.Attribute = Source.Attribute Or &H20
   End If
   If Set.Source.Any Then
      Source.Attribute = Source.Attribute Or &H27
   End If
   If Clear.Source.Readonly Then
      Source.Attribute = Source.Attribute And Not 1
   End If
   If Clear.Source.Hidden Then
      Source.Attribute = Source.Attribute And Not 2
   End If
   If Clear.Source.System Then
      Source.Attribute = Source.Attribute And Not 4
   End If
   If Clear.Source.Archive Then
      Source.Attribute = Source.Attribute And Not &H20
   End If
   If Clear.Source.Any Then
      Source.Attribute = Source.Attribute And Not &H27
   End If

   ' check file size range
   Call Copyit_CheckSizeRange

   ' check return flag
   If Range.Flag Then
      Exit Sub
   End If

   ' store file date and time
   x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
   GoSub Convert.Date
   Synch.Work.Create.Date = Work.Date.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
   GoSub Convert.Date
   Synch.Work.Access.Date = Work.Date.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
   GoSub Convert.Date
   Synch.Work.Modify.Date = Work.Date.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
   GoSub Convert.Time
   Synch.Work.Create.Time = Work.Time.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
   GoSub Convert.Time
   Synch.Work.Access.Time = Work.Time.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
   GoSub Convert.Time
   Synch.Work.Modify.Time = Work.Time.Temp!

   ' check date/time range
   Call Copyit_CheckDateRange

   ' check return flag
   If Range.Flag Then
      Exit Sub
   End If

   ' construct extended date/time string
   FileInfo$ = Nul
   If Double.Line >= 1 Then
      ' make file info
      FileInfo$ = Copyit_MakeDate(1)
      FileInfo$ = FileInfo$ + "\" + Copyit_MakeDate(2)
      FileInfo$ = FileInfo$ + "\" + Copyit_MakeDate(3)
   End If

   ' store filename being copying
   Copy.File$ = Source.Directory$ + Source.Filename$
   If Append.Files Then
      Copy.Dest$ = Dest.Dir
   Else
      If Copy.Directory = False Then
         Copy.Dest$ = Dest.Dir + Source.Filename$
      Else
         Copy.Dest$ = Copy.Target + Source.Filename$
      End If
      If Next.Dest.Net$ = Nul Then
         ASCIIZwrite = Copy.Dest$ + Chr$(0)
      Else
         If Left$(Copy.Dest$, 1) = "\" Then
            ASCIIZwrite = Next.Dest.Net$ + Copy.Dest$ + Chr$(0)
         Else
            ASCIIZwrite = Next.Dest.Net$ + "\" + Copy.Dest$ + Chr$(0)
         End If
      End If
   End If

   ' check filename
   Filename2$ = Source.Filename$
   Call Copyit_CheckFile(Filename2$, False)
   If Check.Flag = False Then
      Exit Sub
   End If

   ' make target directory only if files exist
   If Skip.Directory Then
      Call Copyit_CreateDirectory(Next.Dest.Net$)
   End If

   ' check if appending files
   If Append.Files Then
      ' store output file info
      If Next.Dest.Net$ = Nul Then
         ASCIIZfile = Dest.Dir + Chr$(0)
      Else
         If Left$(Dest.Dir, 1) = "\" Then
            ASCIIZfile = Next.Dest.Net$ + Dest.Dir + Chr$(0)
         Else
            ASCIIZfile = Next.Dest.Net$ + "\" + Dest.Dir + Chr$(0)
         End If
      End If

      ' check if files similar
      Call Copyit_ReadFileSynch

      ' check files
      Call Copyit_CheckSynched
      If Synched.Flag Then
         Exit Sub
      End If
   Else
      ' store output file info
      ASCIIZfile = ASCIIZwrite

      ' check if files similar
      Call Copyit_ReadFileSynch

      ' check files
      Call Copyit_CheckSynched
      If Synched.Flag Then
         Exit Sub
      End If
   End If

   ' verify/display filename
   Call Copyit_CheckFileExists(Next.Dest.Net$, Copy.Dest$, Response)
   If Response = False And Skip.All Then
      Eat$ = Nul
   Else
      Call Copyit_FilenameCopying(Next.Dest.Net$, Copy.File$, Copy.Dest$)
   End If

   ' check copying flag
   If Filename.Exists Then
      Exit Sub
   End If

   ' get filename date/time
   ASCIIZcopy = ASCIIZ
   Call Copyit_ExtendedFile(1)

   ' reset flag error
   Handle = 0

   ' open file for input
   Open.Filename$ = ASCIIZ
   V = InStr(Open.Filename$, Chr$(0))
   If V Then
      Open.Filename$ = Left$(Open.Filename$, V - 1)
   End If
   Handle = FreeFile

   DataError = False
   Error.Flag = True
   Open Open.Filename$ For Binary Shared As #Handle
   Error.Flag = False

   ' check error flag
   If DataError Then
      Handle = 0
   End If

   ' check open file error
   If Handle = 0 Then
      ' display any error
      If Debug.Mode Then
         If DataError <> 70 Then ' ignore share violation
            Call Copyit_DisplayError("Error" + Str$(DataError) + " opening input filename.")
         End If
      End If
      Exit Sub
   End If

   ' set seek position to start of file
   SeekPosition# = 1#

   ' check byte position override
   If Byte.Switch Then
      ' offset from specified byte position
      SeekPosition# = Byte.Override
   End If

   ' check byte position override
   If Resume.File Then
      ' offset from dest. filesize position
      SeekPosition# = Dest.File.Size
   End If

   ' seek position in input file
   Seek Handle, SeekPosition#

   ' reset delete file flag
   Copy.Error = False

   ' check if appending files
   If Append.Files Then
      ' store output file info
      If Next.Dest.Net$ = Nul Then
         ASCIIZfile = Dest.Dir + Chr$(0)
      Else
         If Left$(Dest.Dir, 1) = "\" Then
            ASCIIZfile = Next.Dest.Net$ + Dest.Dir + Chr$(0)
         Else
            ASCIIZfile = Next.Dest.Net$ + "\" + Dest.Dir + Chr$(0)
         End If
      End If
      File.Attribute = Attribute

      ' check to overwrite
      If Overwrite.Prompt = False Then
         Copy.File$ = Directory.Search$ + RTrim$(Filename.Search)
         Copy.Dest$ = Dest.Dir
         Call Copyit_PromptOverwrite(Next.Dest.Net$, Copy.File$, Copy.Dest$, Response)
         If Response = False Then
            GoTo End.Copy.File1
         End If
      End If

      ' open output file
      Call Copyit_OpenFile(OpenError)

      ' check error opening output file
      If OpenError Then
         Exit Sub
      End If
   Else
      ' store output file info
      ASCIIZfile = ASCIIZwrite
      File.Attribute = Attribute

      ' check to overwrite
      If Overwrite.Prompt = False Then
         Call Copyit_PromptOverwrite(Next.Dest.Net$, Copy.File$, Copy.Dest$, Response)
         If Response = False Then
            GoTo End.Copy.File1
         End If
      End If

      ' open output file
      Call Copyit_OpenFile(OpenError)

      ' check error opening output file
      If OpenError Then
         GoTo End.Copy.File1
      End If
   End If

   ' reset error flag
   Error.Type = False
   Percent.Flag = False
   Current.Progress = False

   ' copy file
   Count.Forward = True
   Dot.Count = False
   Dot.Total = False

   ' file input loop
   Do
      ' reset and store error flag
      DataError = False
      Error.Flag = True

      ' read from file
      Number.Bytes = buflen
      position# = Loc(Handle)
      Get Handle, , fbuffer

      ' restore and check error flag
      Error.Flag = False
      If DataError Then
         Error.Type = DataError
         Exit Do
      End If

      ' store buffer and length of buffer
      BufferOut$ = Nul
      If position# + buflen > LOF(Handle) Then
         Number.Bytes = LOF(Handle) - position#
      End If
      If Number.Bytes > 0 Then
         BufferOut$ = Left$(fbuffer, Number.Bytes)
      End If

      ' show disk activity
      If Continuous.Display = False And Dot.Mode = False Then
         Dot.Total = Dot.Total + 1 ' count buflen blocks
         If Dot.Total >= 256 Then ' could be increased
            Dot.Total = 0
            If Count.Forward Then
               Print ".";
               Dot.Count = Dot.Count + 1
               If Dot.Count = 16 Then
                  Count.Forward = False
               End If
            Else
               _ControlChr On
               Print Chr$(29); " "; Chr$(29);
               _ControlChr Off
               Dot.Count = Dot.Count - 1
               If Dot.Count = False Then
                  Count.Forward = True
               End If
            End If
         End If
      End If

      ' add total bytes counted
      Sum.Bytes2 = Sum.Bytes2 + Number.Bytes

      ' check total filesize to copy
      If File.Size > 0# Then

         ' check to display percent copied
         P$ = Nul
         Percent = (Sum.Bytes2 / File.Size) * 100!
         Percent = Int(Percent)
         If Percent = 0 Then
            If Percent.Flag = 0 Then
               P$ = "000%"
               If Percent.Display Then
                  Print P$;
                  Percent.Flag = True
               End If
            End If
         Else
            If Percent <> Last.Percent Then
               Last.Percent = Percent
               P$ = Right$(Str$(Percent + 1000%), 3) + "%"
               If Percent.Display Then
                  If Percent.Flag Then
                     _ControlChr On
                     For Imbedded = 1 To 4
                        Print Chr$(29); " "; Chr$(29);
                     Next
                     _ControlChr Off
                  End If
                  Print P$;
                  Percent.Flag = True
               End If
            End If
         End If

         ' display percent copied on title
         If Len(P$) Then
            If P$ <> Title.Percent Then
               Title.Percent = P$
               _Title Title.Header + " " + P$
            End If
         End If

         ' check to display progress bar
         If Progress.Bar Then
            Percent = (Sum.Bytes2 / File.Size) * 100#
            Percent = Int(Percent / 10)
            Do While Percent > Current.Progress
               If Current.Progress >= 10 Then
                  Exit Do
               End If
               Print ProgressChar;
               Current.Progress = Current.Progress + 1
            Loop
         End If
      End If

      ' check binary copy
      If Copy.Ascii = False Then
         Ascii.Exit = False
      Else
         If InStr(BufferOut$, Chr$(26)) Then ' eof char
            BufferOut$ = Left$(BufferOut$, InStr(BufferOut$, Chr$(26)))
            Number.Bytes = Len(BufferOut$)
            Ascii.Exit = True
         End If
      End If

      ' check number of bytes to copy
      If Number.Bytes > False Then

         ' check ascii filters
         For Count = 1 To Ascii.Filters
            Ascii.From = Convert.Ascii(Count, 1)
            Ascii.To = Convert.Ascii(Count, 2)
            Next.Imbedded = 1
            Do
               Imbedded = InStr(Next.Imbedded, BufferOut$, Chr$(Ascii.From))
               If Imbedded Then
                  Next.Imbedded = Imbedded + 1
                  Mid$(BufferOut$, Imbedded, 1) = Chr$(Ascii.To)
               Else
                  Exit Do
               End If
               If Next.Imbedded >= Number.Bytes Then
                  Exit Do
               End If
            Loop
         Next
      End If

      ' check number of bytes to copy
      If Number.Bytes > False Then

         ' check ascii strips
         For Count = 1 To Ascii.Strips
            ' check entire buffer is stripped
            If Left$(BufferOut$, Number.Bytes) = String$(Number.Bytes, Chr$(Strip.Ascii(Count))) Then
               Number.Bytes = 0
               Exit For
            End If

            ' check strip values
            Do
               Imbedded = InStr(BufferOut$, Chr$(Strip.Ascii(Count)))
               If Imbedded > False And Imbedded <= Number.Bytes Then
                  BufferOut$ = Left$(BufferOut$, Imbedded - 1) + Mid$(BufferOut$, Imbedded + 1)
                  Number.Bytes = Number.Bytes - 1
               Else
                  Exit Do
               End If
            Loop
         Next
      End If

      ' check number of bytes to copy
      If Number.Bytes > False Then
         ' reset and store error flag
         DataError = False
         Error.Flag = True

         ' append to file
         Put Append.Handle, , BufferOut$

         ' restore and check error flag
         Error.Flag = False
         If DataError Then
            Error.Type = DataError
            Exit Do
         End If

         ' increment bytes copied
         Sum.Bytes = Sum.Bytes + Number.Bytes

         ' check binary copy
         If Ascii.Exit Then
            Exit Do
         End If
      End If

      ' check for more input
      If EOF(Handle) Then
         Exit Do
      End If
   Loop

   ' clear display progress
   Call Copyit_ClearDisplay(-1)

   ' update counter
   Files.Counted = Files.Counted + 1#

   ' check copying file error
   If DataError Then
      If Wide.List Then
         Wide.List = False
         Print
      End If
      Copy.Error = True
      If Display.Errors = False Then
         Color Red, Black
         If Error.Type = 61 Then ' disk full
            Disk.Full = True
            Quit.Searching = True
         End If
         Call DisplayCriticalError(Error.Type)
      End If
   End If

   ' close output file
   Call Copyit_CloseFile(0)

   ' pcocess end of input file parsing
   End.Copy.File1:
   ' close input file
   If Handle Then
      Close #Handle
   End If

   ' display any errors
   If Debug.Mode Then
      If CloseError > False Then
         Call Copyit_DisplayError("Error closing input filename.")
      End If
   End If

   ' check disk full flag
   If Disk.Full Then
      ' delete destination file
      If Append.Dest = False Then
         Call Copyit_DeleteDestFile(False, Next.Dest.Net$, Source.Filename$)
      End If
      Exit Sub
   End If

   ' check copy error flag
   If Copy.Error Then
      ' delete destination file
      If Append.Dest = False Then
         Call Copyit_DeleteDestFile(True, Next.Dest.Net$, Source.Filename$)
      End If
      Exit Sub
   End If

   ' check to change source attribute
   Reset.Source = False
   If RTrim$(Source.Net) <> Nul Then
      Reset.Source = True
   End If
   If Set.Source.Attribute Or Reset.Source Then
      ' reset source attribute
      x = SetFileAttributes&(ASCIIZ, Source.Attribute)
   End If

   ' store total bytes copied
   If OpenError = 0 Then
      Total.Bytes2 = Total.Bytes2 + File.Size
   End If

   ' store actual bytes copied
   If OpenError = 0 Then
      Total.Bytes = Total.Bytes + Sum.Bytes
   End If

   ' store virtual bytes copied
   If Resume.File Then
      Var# = File.Size - Dest.File.Size
   Else
      If Byte.Switch Then
         Var# = File.Size - Byte.Override
      Else
         Var# = File.Size
      End If
   End If
   If Var# < 0# Then
      Var# = 0#
   End If
   If OpenError = 0 Then
      Bytes.Copied = Bytes.Copied + Var#
   End If

   ' check display type
   Var = False
   If Double.Line >= 1 Then
      ' display file date/time
      Color Green, Black
      Print FileInfo$ + " ";
      Var = True
   End If

   ' check display type
   If Double.Line >= 2 Then
      ' display file size
      Color Red, Black
      Print FormatString$(File.Size);
      Var = True
   End If

   ' check display type
   If Double.Line >= 3 Then
      ' check for archive file
      Color White, Black
      If (Attribute And &H20) = &H20 Then
         Print " Archive";
      End If

      ' check for read-only file
      If (Attribute And 1) = 1 Then
         Print " Read-only";
      End If

      ' check for hidden file
      If (Attribute And 2) = 2 Then
         Print " Hidden";
      End If

      ' check for system file
      If (Attribute And 4) = 4 Then
         Print " System";
      End If

      ' check for compressed file
      If (Attribute And &H800) = &H800 Then
         Print " Compressed";
      End If

      ' check for encrypted file
      If (Attribute And &H4000) = &H4000 Then
         Print " Encrypted";
      End If
      Var = True
   End If
   If Var Then
      Wide.List = False
      Print
   End If

   If UserProfileRecord.Reserved1 < MaxInt Then
      UserProfileRecord.Reserved1 = UserProfileRecord.Reserved1 + 1%
   End If
   UserProfileRecord.Reserved8 = UserProfileRecord.Reserved8 + Total.Bytes
   x = WriteUser

   ' check to delete source file
   If Delete.Copied Then
      Call Copyit_DeleteSourceFile(Source.Directory$, Source.Filename$)
   End If
   Exit Sub

   Convert.Date:
   YearTemp! = SysTime.wYear
   MonthTemp! = SysTime.wMonth
   DayTemp! = SysTime.wDay
   Work.Date.Temp! = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
   Return

   Convert.Time:
   HourTemp! = SysTime.wHour
   MinuteTemp! = SysTime.wMinute
   SecondsTemp! = SysTime.wSecond
   Work.Time.Temp! = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
   Return
End Sub

' display error trap message.
Sub DisplayCriticalError (Var)
   Select Case Var
      Case 6
         Print #StderrHandle, "Overflow";
      Case 9
         Print #StderrHandle, "Subscript out of range";
      Case 14
         Print #StderrHandle, "Out of string space";
      Case 24
         Print #StderrHandle, "Device timeout";
      Case 25
         Print #StderrHandle, "Device fault";
      Case 27
         Print #StderrHandle, "Out of paper";
      Case 52
         Print #StderrHandle, "Bad file name or number";
      Case 53
         Print #StderrHandle, "File not found";
      Case 54
         Print #StderrHandle, "Bad file mode";
      Case 55
         Print #StderrHandle, "File already open";
      Case 57
         Print #StderrHandle, "Device I/O error";
      Case 58
         Print #StderrHandle, "File already exists";
      Case 59
         Print #StderrHandle, "Bad record length";
      Case 61
         Print #StderrHandle, "Disk full";
      Case 62
         Print #StderrHandle, "Input past eof";
      Case 63
         Print #StderrHandle, "Bad record length";
      Case 64
         Print #StderrHandle, "Bad file name";
      Case 67
         Print #StderrHandle, "Not enough file handles";
      Case 68
         Print #StderrHandle, "Device unavailable";
      Case 70
         Print #StderrHandle, "Permission denied";
      Case 71
         Print #StderrHandle, "Disk not ready";
      Case 72
         Print #StderrHandle, "Disk-media error";
      Case 75
         Print #StderrHandle, "Path/File access error";
      Case 76
         Print #StderrHandle, "Pathname not found";
      Case 81
         Print #StderrHandle, "Invalid name";
      Case 90
         Print #StderrHandle, "Too many processes";
      Case Else
         Print #StderrHandle, "Untrapped error" + Str$(Var);
   End Select
   Print #StderrHandle, " copying files."
End Sub

' routine to access directories
Sub Copyit_Directories (Next.Dest.Net$, Directory.Search$, Directory.Target$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ.Sub As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' declare wide functions
   Dim finddataw As WIN32_FIND_DATAW ' the windows filename structure
   Dim Wfile.HandleW As _Unsigned _Offset ' windows file handle for FindFile

   ' make directory filename
   Temp.Net$ = RTrim$(Source.Net)
   If Temp.Net$ = Nul Then
      ASCIIZ.Sub = Directory.Search$ + "*.*" + Chr$(0)
      Source.Search$ = Directory.Search$
   Else
      If Left$(Directory.Search$, 1) = "\" Then
         ASCIIZ.Sub = Temp.Net$ + Directory.Search$ + "*.*" + Chr$(0)
         Source.Search$ = Temp.Net$ + Directory.Search$
      Else
         ASCIIZ.Sub = Temp.Net$ + "\" + Directory.Search$ + "*.*" + Chr$(0)
         Source.Search$ = Temp.Net$ + "\" + Directory.Search$
      End If
   End If
   If Right$(Source.Search$, 1) = "\" Then
      Source.Search$ = Left$(Source.Search$, Len(Source.Search$) - 1)
   End If

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ.Sub), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' store s