Rem QB64SHELL.INC - command line prompt shell windows include program for QB64

' detect operating system
$If WIN = 0 Then
   COLOR 15, 0
   CLS
   PRINT "Sorry, this program only works in Windows.."
   END
$End If

Rem version information variables.
$VersionInfo:CompanyName='eoredson'
$VersionInfo:FileDescription='The QB64 IDE Shell'
$VersionInfo:InternalName='qb64shell.bas'
$VersionInfo:LegalCopyright='PD'
$VersionInfo:LegalTrademarks='PD'
$VersionInfo:OriginalFilename='qb64shell.exe'
$VersionInfo:ProductName='QB64SHELL'
$VersionInfo:Comments='QB64SHELL is a modern extended IDE shell interface.'

$VersionInfo:FILEVERSION#=1,1,2,2025
$VersionInfo:PRODUCTVERSION#=1,1,2,2025

Rem _openclient variables.
Dim Shared clientdetect As Integer
Dim Shared clienthandle As Long

Rem file: What64 include file - Public Domain QB64 Utility. v1.0a.

Rem type: Recursive Descent Expression Parser.

' constant declarations
Const FalseD = 0#
Const TrueD = -1#
Const False = 0
Const True = -1

Const Nul = ""

Const LFalse = 0&
Const SFalse = 0!
Const DFalse = 0#

Const Max.Arrays = 128 ' can be changed
Const Max.History = 10 ' can be changed
Const Max.Recurse = 16 ' can be changed
Const Max.FNs = 26 ' can be changed

Rem define color values

' low intensity/background
Const Black = 0
Const BBlue = 1
Const BGreen = 2
Const BCyan = 3
Const BRed = 4
Const BMagenta = 5
Const BYellow = 6
Const Plain = 7

' high intensity foreground
Const Gray = 8
Const Blue = 9
Const Green = 10
Const Cyan = 11
Const Red = 12
Const Magenta = 13
Const Yellow = 14
Const White = 15

' scrnedit search color
Const Scolor = Red ' foreground
Const Scolor2 = BBlue ' background

' global variables
Dim Shared Assign As Integer
Dim Shared DataError As Integer
Dim Shared Hidden As Integer
Dim Shared Last.Token As Integer
Dim Shared Last.Token.Value As Double
Dim Shared Parse.Type As Integer
Dim Shared Out2 As String
Dim Shared Out3 As String
Dim Shared Out4 As String
Dim Shared ParseCalls As Integer
Dim Shared Recurse As Integer
Dim Shared Strng As String
Dim Shared TeeCalls As Integer
Dim Shared Token As Integer
Dim Shared Token.Index As Integer
Dim Shared Token.List As String
Dim Shared White.Space As String
Dim Shared WhatisError As Integer
Dim Shared RestartWhatisBox As Integer

' data areas
Dim Shared Arrays(0 To 26, 1) As Double ' variable arrays A() to Z()
Dim Shared Definitions(1) As String ' DEF FN functions
Dim Shared Strngs(1) As String ' string variables A$ to Z$
Dim Shared Variables(1) As Double ' variables A to Z

' multi-dimensional command history arrays
Dim Shared HistoryCount2(1) As Integer
Dim Shared History2(1 To 3, 1) As String * 256
Dim Shared EndOfHistoryFlag(0 To 6) As Integer

' multi-dimensional command history variable
Dim Shared Temp0 As Integer

Rem file: Newdir.bas - QB64 Utility v1.0a PD 2016.

' initialize drive variables
Dim Shared DriveList(26) As String
Dim Shared Drive.Search As String * 1
Dim Shared Current.Drive As String * 1

' declare work variables
Dim Shared Continuous.Display As Integer
Dim Shared Display.Errors As Integer
Dim Shared Prompt.Delete As Integer
Dim Shared Quit.Searching As Integer
Dim Shared Dirs.Counted As Double

' declare command line work variables
Dim Shared Command.Line As String
Dim Shared Command.Work As String
Dim Shared Last.Switch As Integer
Dim Shared Switch.Exist As Integer
Dim Shared Display.Drive As Integer
Dim Shared Display.Path As Integer

Dim Shared COMMAND2 As String

Dim Shared ErrorBuffer As String * 260

Rem file: Whereis.bas - QB64 Utility v1.0a PD 2016.

' define filelist constant
Const RecurseLevel = 8

' declare work variables
Dim Shared Files.Counter As Integer
Dim Shared Double.Line As Integer
Dim Shared Files.Counted As Double
Dim Shared More.Display As Integer
Dim Shared Display.Dirs.Counted As Integer
Dim Shared Dirs.Displayed As Double
Dim Shared Length As Integer
Dim Shared Whatis.Length As Integer
Dim Shared Volumes.Counted As Integer
Dim Shared Exclude.File As Integer

' declare search work variables
Dim Shared Search.From.Date As Single
Dim Shared Search.To.Date As Single
Dim Shared Search.From.Time As Single
Dim Shared Search.To.Time As Single
Dim Shared File.Size As Double
Dim Shared Recurse.Directories As Integer
Dim Shared Display.Hidden As Integer
Dim Shared Display.System As Integer
Dim Shared Display.Readonly As Integer
Dim Shared Display.Archive As Integer
Dim Shared Display.Attribute As Integer
Dim Shared Display.Search As Integer
Dim Shared Display.Volume As Integer
Dim Shared Display.Any As Integer
Dim Shared No.Display.Archive As Integer
Dim Shared No.Display.Readonly As Integer
Dim Shared No.Display.System As Integer
Dim Shared No.Display.Hidden As Integer
Dim Shared No.Display.Any As Integer
Dim Shared No.Display.Directory As Integer
Dim Shared No.Display.Drive As Integer

Dim Shared Display.Encrypt As Integer
Dim Shared No.Display.Encrypt As Integer

Dim Shared Display.Compress As Integer
Dim Shared No.Display.Compress As Integer

Dim Shared Display.Directory As Integer
Dim Shared Short.Display As Integer
Dim Shared Wide.Display As Integer
Dim Shared Wide.List As Integer
Dim Shared Remove.Slash As Integer
Dim Shared Skip.Current As Integer
Dim Shared First.Directory As Integer
Dim Shared Max.DirRecurse As Integer
Dim Shared Display.Only.Errors As Integer
Dim Shared Short.Directory As String
Dim Shared Current.Directory As String
Dim Shared Standard.Input As String

' declare file date\time and filesize work variables
Dim Shared File.Work.Date As Single
Dim Shared File.Work.Time As Single
Dim Shared Total.Bytes As Double
Dim Shared Parameters(1) As String * 348
Dim Shared Search.Size.From As Double
Dim Shared Search.Size.To As Double
Dim Shared Search.File.Size
Dim Shared Display.Lowercase As Integer
Dim Shared Creation.Time As Integer
Dim Shared Short.Filenames As Integer
Dim Shared Access.Time As Integer
Dim Shared Modified.Time As Integer

' declare nest recursion variables
Dim Shared Nested.Recurse As Integer
Dim Shared Nested.Levels As Integer

' declare filelist variables
Dim Shared Enable.Redirect As Integer
Dim Shared Ignore.Prompts As Integer

' declare dos command work variables
Dim Shared DOS.Command As String
Dim Shared Exclude.List As String
Dim Shared Disable.Cmd As Integer

' declare error trap variables
Dim Shared Error.Flag As Integer

' dimension arrays
ReDim Parameters(1 To 12) As String * 348

' declare scrneedit variables
Dim Shared File.Loaded As Integer, EditFlag As Integer

Rem Zsort

' declare work variables
Dim Shared Reverse.Sort As Integer
Dim Shared Sort.Column As Integer
Dim Shared Lines.Counted As Double
Dim Shared Max.Sort.Lines As Double
Dim Shared Ignore.Case As Integer
Dim Shared Strip.Blanks As Integer
Dim Shared Strip.Drives As Integer
Dim Shared Sort.Swaps As Double
Dim Shared Control.Break As Integer
Dim Shared Monitor.Box As Integer

' declare sort variables
Dim Shared Num As Double
Dim Shared Span As Double
Dim Shared Start As Double
Dim Shared Element As Double

' declare sort array
Dim Shared Sort.Array(1) As String

Rem TypeY

' declare work variables
Dim Shared Advance.Line As Integer
Dim Shared Dot.Count As Integer
Dim Shared Count.Forward As Integer
Dim Shared Prepend.Drive As Integer
Dim Shared Display.Errors2 As Integer

' declare count variables
Dim Shared Count.Deleted As Integer
Dim Shared Count.Dirs As Integer
Dim Shared Count.Files As Integer
Dim Shared Count.Bytes As Integer
Dim Shared Bytes.Counted As Double
Dim Shared Count.Lines As Integer
Dim Shared Display.Filenames As Integer
Dim Shared Total.Lines As Double

Rem Copyit

' define version value
Const CopyitVersion$ = "v9.0a"
Const CopyitRelease$ = "r5.0a"

' declare filename buffer
Const buflen = 4096 ' can be changed
Dim Shared fbuffer As String * buflen

' declare filename strings
Dim Shared ASCIIZcopy As String * 260
Dim Shared ASCIIZfile As String * 260

' declare filename variables
Dim Shared Filename.Search As String
Dim Shared Number.Excluded As Integer
Dim Shared Max.Excluded As Integer

' declare flag variables
Dim Shared Check.Flag As Integer
Dim Shared Pattern.Flag As Integer
Dim Shared Exclude.Flag As Integer
Dim Shared Synched.Flag As Integer
Dim Shared Range.Flag As Integer
Dim Shared Size.Flag As Integer

' declare filename arrays
Dim Shared Excluded.Files(1) As String * 128
Dim Shared Skip.Filenames(1) As String * 12

' declare ascii arrays
Dim Shared Convert.Ascii(10, 1) As Integer
Dim Shared Strip.Ascii(1) As Integer

' declare command line work variables
Dim Shared Disk.Full As Integer
Dim Shared Error.Level As Integer
Dim Shared Imbedded As Integer

' declare some constants
$If VERSION < 4.0.0 Then
   Dim Shared Quote As String * 1
   Quote = Chr$(34)
   Dim Shared TabS As String * 1
   TabS = Chr$(9)
   Dim Shared ProgressChar As String * 1
   ProgressChar = "#"
$End If
$If VERSION >= 4.0.0 Then
   Const Quote = Chr$(34)
   Const TabS = Chr$(9)
   Const ProgressChar = "#"
$End If
Const Quote2 = "'"
Const TabStop = 8

' declare work variables
Dim Shared Continue.Search As Integer
Dim Shared Continue.Searching As Integer
Dim Shared Continuous.Display2 As Integer
Dim Shared Continuous.Display3 As Integer
Dim Shared Dot.Total As Integer
Dim Shared Dirs.Created As Double
Dim Shared Total.Deleted As Double
Dim Shared Skip.All As Integer

' declare file synchronize work variables
Dim Shared Synch.Files As Integer
Dim Shared Synch.Files1 As Integer
Dim Shared Synch.Files2 As Integer
Dim Shared Synch.Files3 As Integer
Dim Shared Synch.Files4 As Integer
Dim Shared Synch.Files5 As Integer
Dim Shared Synch.Files6 As Integer
Dim Shared Synch.Files7 As Integer
Dim Shared Synch.Files8 As Integer
Dim Shared Synch.Files9 As Integer
Dim Shared Synch.FilesA As Integer
Dim Shared Synch.FilesB As Integer
Dim Shared Synch.FilesC As Integer
Dim Shared Synch.Type1 As Integer
Dim Shared Synch.Type2 As Integer
Dim Shared Synch.Type3 As Integer

' declare search work variables
Dim Shared Search.Date As Integer
Dim Shared Search.Time As Integer

' declare pattern search work variables
Dim Shared Pattern.Filename As String
Dim Shared Pattern.Match As Integer
Dim Shared Pattern.Search.Date As Integer
Dim Shared Pattern.Search.From.Date As String
Dim Shared Pattern.Search.To.Date As String
Dim Shared Pattern.Search As Integer

' declare attribute search variables
Dim Shared File.Attribute As _Unsigned Long

' declare destination attribute work variables
Dim Shared Dir.Attribute As _Unsigned Long
Dim Shared Set.Dest.Archive As Integer
Dim Shared Set.Dest.Readonly As Integer
Dim Shared Set.Dest.System As Integer
Dim Shared Set.Dest.Hidden As Integer
Dim Shared Set.Dest.Any As Integer
Dim Shared Clear.Dest.Archive As Integer
Dim Shared Clear.Dest.Readonly As Integer
Dim Shared Clear.Dest.System As Integer
Dim Shared Clear.Dest.Hidden As Integer
Dim Shared Clear.Dest.Any As Integer

' declare source attribute work variables
Dim Shared Source.Attribute As _Unsigned Long
Dim Shared Set.Source.Archive As Integer
Dim Shared Set.Source.Readonly As Integer
Dim Shared Set.Source.System As Integer
Dim Shared Set.Source.Hidden As Integer
Dim Shared Set.Source.Any As Integer
Dim Shared Clear.Source.Archive As Integer
Dim Shared Clear.Source.Readonly As Integer
Dim Shared Clear.Source.System As Integer
Dim Shared Clear.Source.Hidden As Integer
Dim Shared Clear.Source.Any As Integer
Dim Shared Set.Source.Attribute As Integer
Dim Shared Display.Compressed As Integer
Dim Shared Display.Encrypted As Integer
Dim Shared No.Display.Compressed As Integer
Dim Shared No.Display.Encrypted As Integer

' declare work variables
Dim Shared Overwrite.Prompt As Integer
Dim Shared Debug.ModeX As Integer
Dim Shared Dont.Overwrite As Integer
Dim Shared Debug.Mode As Integer
Dim Shared Dot.Mode As Integer
Dim Shared Rate.Mode As Integer
Dim Shared Start.Time As Single
Dim Shared Stop.Time As Single
Dim Shared Time.Elapsed As Single
Dim Shared Percent.Display As Integer
Dim Shared Percent As Integer
Dim Shared Percent.Flag As Integer
Dim Shared Progress.Bar As Integer
Dim Shared Current.Progress As Integer
Dim Shared Last.Percent As Integer
Dim Shared Display.Header As Integer
Dim Shared Title.Percent As String

' declare copy work variables
Dim Shared Copy.Ascii As Integer
Dim Shared Ascii.Strips As Integer
Dim Shared Ascii.Filters As Integer
Dim Shared Max.Filters As Integer
Dim Shared Max.Strips As Integer
Dim Shared Directory.Exists As Integer
Dim Shared Filename.Exists As Integer
Dim Shared Dir.Copy.Name As String * 260
Dim Shared Dir.Copy.Target As String * 260
Dim Shared Force.LowerCase As Integer

' declare bytes copied variables
Dim Shared Bytes.Copied As Double
Dim Shared Total.Bytes2 As Double

' declare file date/time override work varibles
Dim Shared Override.Create.Date As Integer
Dim Shared Override.Access.Date As Integer
Dim Shared Override.Modify.Date As Integer

Dim Shared Override.Date.Month As Integer
Dim Shared Override.Date.Day As Integer
Dim Shared Override.Date.Year As Integer
Dim Shared Override.Date As Integer

Dim Shared Override.Time.Hour As Integer
Dim Shared Override.Time.Minute As Integer
Dim Shared Override.Time.Second As Integer
Dim Shared Override.Time As Integer

Dim Shared Directory.Path As String

Dim Shared Extended.Time As Integer

' declare copy date/time range work variables
Dim Shared Compare.Create.Date As Integer
Dim Shared Compare.Access.Date As Integer
Dim Shared Compare.Modify.Date As Integer

' declare synchronize date/time work variables
Dim Shared Synch.File.Create.Date As Single
Dim Shared Synch.File.Access.Date As Single
Dim Shared Synch.File.Modify.Date As Single
Dim Shared Synch.File.Create.Time As Single
Dim Shared Synch.File.Access.Time As Single
Dim Shared Synch.File.Modify.Time As Single

' declare synchronize date/time work variables
Dim Shared Synch.Work.Create.Date As Single
Dim Shared Synch.Work.Access.Date As Single
Dim Shared Synch.Work.Modify.Date As Single
Dim Shared Synch.Work.Create.Time As Single
Dim Shared Synch.Work.Access.Time As Single
Dim Shared Synch.Work.Modify.Time As Single

' declare filesize work variables
Dim Shared Copy.Zero As Integer
Dim Shared Dest.File.Size As Double

' declare destination work variables
Dim Shared Ambiguate.Display As Integer
Dim Shared Append.Handle As Integer
Dim Shared Copy.Directory As Integer
Dim Shared Copy.Target As String
Dim Shared Default.Dest As String
Dim Shared Default.Dir As String
Dim Shared Dest.Dir As String
Dim Shared Dest.File As String
Dim Shared Display.Wide As Integer
Dim Shared Short.Display2 As Integer
Dim Shared Short.Display3 As Integer
Dim Shared Short.Display4 As Integer
Dim Shared Start.Dir As String
Dim Shared Start.Directory As String
Dim Shared Title.Header As String
Dim Shared Skip.Directory As Integer

' declare append variables
Dim Shared Append.Dest As Integer
Dim Shared Append.Files As Integer
Dim Shared Byte.Switch As Integer
Dim Shared Byte.Override As Double
Dim Shared Resume.File As Integer
Dim Shared Line.Override As Double
Dim Shared Line.Counter As Integer
Dim Shared Line.Counter2 As Integer

' declare destination work arrays
Dim Shared Destinate.Directory(1) As String * 260
Dim Shared Destinate.Filename(1) As String * 260
Dim Shared Destinate.Netpaths(1) As String * 260

' declare destination work variables
Dim Shared Max.Dest.Dirs As Integer
Dim Shared Max.Dest.Files As Integer
Dim Shared Max.Dest.Nets As Integer
Dim Shared Number.Dest.Dirs As Integer
Dim Shared Number.Dest.Files As Integer
Dim Shared Number.Dest.Nets As Integer
Dim Shared Default.Net As String * 64
Dim Shared Source.Net As String * 64
Dim Shared Zero.Dirs As Integer
Dim Shared Zero.Nets As Integer

' declare nest recursion variables
Dim Shared Recursion As Integer
Dim Shared Zero.Nest As Integer
Dim Shared Recurse.Error As Integer
Dim Shared Max.CopyRecurse As Integer

' declare delete copied files variables
Dim Shared Continue.Deleting As Integer
Dim Shared Continue.Subdelete As Integer
Dim Shared Delete.Copied As Integer
Dim Shared Delete.Directory As Integer
Dim Shared Prompt.Delete1 As Integer
Dim Shared Prompt.Delete2 As Integer
Dim Shared Deleted.Dirs As Double
Dim Shared Deleted.Files As Double

' declare DOS command work variables
Dim Shared DOS.Command(1) As String * 128
Dim Shared Max.Commands As Integer
Dim Shared Number.Commands As Integer

' declare ignore switches
Dim Shared Ignore.Config As Integer
Dim Shared Ignore.Skip As Integer

' declare filelist variables
Dim Shared Disable.Prompts As Integer

' declare floppy copy variables (unused).
Dim Shared Temp.Drive.Dir As String * 260

' declare debug switches
Dim Shared DebugDelay As Single

' declare dos command work variables
ReDim DOS.Command(1 To 10) As String * 128
ReDim Parameters(1 To 12) As String * 348

' declare filename arrays
ReDim Skip.Filenames(1 To 10) As String * 12
ReDim Excluded.Files(1 To 10) As String * 128

' declare work arrays
ReDim Convert.Ascii(1 To 10, 1 To 2) As Integer
ReDim Strip.Ascii(1 To 10) As Integer

' declare destination work arrays
ReDim Destinate.Directory(1 To 10) As String * 260
ReDim Destinate.Filename(1 To 10) As String * 260
ReDim Destinate.Netpaths(1 To 10) As String * 260

' declare unicode variables
Dim Shared FileIsUnicode As Integer
Dim Shared UnicodeShort As String
Dim Shared UnicodeLong As String

Dim Shared DirIsUnicode As Integer
Dim Shared DirUnicodeShort As String
Dim Shared DirUnicodeLong As String

Rem Nameit

' declare work variables
Dim Shared Lower.Case As Integer
Dim Shared New.Name As Integer
Dim Shared Sensitive As Integer
Dim Shared Dir.Search As Integer
Dim Shared Output.Line As String
Dim Shared List.Only.Source As Integer
Dim Shared List.Only.Dest As Integer
Dim Shared List.Only.Not As Integer
Dim Shared List.Only.Short As Integer
Dim Shared Short.Filename As String

Rem Stree

' declare work variables
Dim Shared Search.Archive As Integer
Dim Shared Search.Hidden As Integer
Dim Shared Search.Readonly As Integer
Dim Shared Search.System As Integer
Dim Shared Search.Compressed As Integer
Dim Shared Search.Encrypted As Integer

Dim Shared Attribute As _Unsigned Long
Dim Shared Extended.List As Integer
Dim Shared Directories.Counted As Single
Dim Shared Display.Lines As Integer
Dim Shared Display.Length As Integer
Dim Shared Truncate.Slash As Integer
Dim Shared Strip.Drive As Integer
Dim Shared Append.Slash As Integer
Dim Shared Wide.Display2 As Integer
Dim Shared NetPathError As Integer
Dim Shared AutoConfirm As Integer

Rem Findy

' declare work variables
Dim Shared Reverse.Search As Integer
Dim Shared Search.Column As Integer
Dim Shared List.Lines As Integer
Dim Shared Line.Number As Integer
Dim Shared Boolean.Search As Integer
Dim Shared WildCard.Search As Integer

' declare command line work variables
Dim Shared Search.String As String
Dim Shared Input.Line As String

Rem Delete

' declare work variables
Dim Shared Files.Deleted As Double
Dim Shared Continuous.Delete As Integer

' declare recurse work variables
Dim Shared Quit.Deleting As Integer

' declare delete work variables
Dim Shared Delete.Hidden As Integer
Dim Shared Delete.System As Integer
Dim Shared Delete.Readonly As Integer
Dim Shared Delete.Archive As Integer
Dim Shared Delete.Any As Integer
Dim Shared Delete.Compress As Integer
Dim Shared Delete.Encrypt As Integer

Dim Shared Dont.Delete.Hidden As Integer
Dim Shared Dont.Delete.System As Integer
Dim Shared Dont.Delete.Readonly As Integer
Dim Shared Dont.Delete.Archive As Integer
Dim Shared Dont.Delete.Any As Integer
Dim Shared Dont.Delete.Compress As Integer
Dim Shared Dont.Delete.Encrypt As Integer

Dim Shared Delete.File As Integer

Rem Treedel

' declare work variables
Dim Shared Add.Slash As Integer

' declare attribute variables
Dim Shared No.Touch.Archive As Integer
Dim Shared No.Touch.Hidden As Integer
Dim Shared No.Touch.Readonly As Integer
Dim Shared No.Touch.System As Integer
Dim Shared No.Touch.Any As Integer
Dim Shared Touch.Any As Integer
Dim Shared Touch.Archive As Integer
Dim Shared Touch.Hidden As Integer
Dim Shared Touch.Readonly As Integer
Dim Shared Touch.System As Integer
Dim Shared Search.Compress As Integer
Dim Shared Search.Encrypt As Integer

Dim Shared No.Touch.Encrypt As Integer
Dim Shared Touch.Encrypt As Integer
Dim Shared No.Touch.Compress As Integer
Dim Shared Touch.Compress As Integer

Rem Drives

' declare work variables
Dim Shared Default.Drive As Integer
Dim Shared Drives.Count As Integer
Dim Shared Last.Drive As Integer
Dim Shared Display.Current As Integer
Dim Shared Skip.Drives(1) As Integer
Dim Shared Display.Colon As Integer

Rem Listvols

' declare work variables
Dim Shared Drive.Number As Integer
Dim Shared Display.Drive.Letter As Integer
Dim Shared Display.Serial As Integer
Dim Shared Display.FatType As Integer

Rem Encrypt

' declare attribute variables
Dim Shared Set.Archive As Integer
Dim Shared Set.Hidden As Integer
Dim Shared Set.Readonly As Integer
Dim Shared Set.System As Integer
Dim Shared Clear.Archive As Integer
Dim Shared Clear.Hidden As Integer
Dim Shared Clear.Readonly As Integer
Dim Shared Clear.System As Integer

' initialize drive work variables
Dim Shared Crypted.Count As Double
Dim Shared Crypted.Count2 As Double
Dim Shared Encrypt.Call As Integer

Rem Dirattr

' declare work variables
Dim Shared List.Readonly As Integer
Dim Shared List.System As Integer
Dim Shared List.Directory As Integer
Dim Shared List.Compressed As Integer
Dim Shared List.Encrypted As Integer
Dim Shared List.Lowercase As Integer
Dim Shared List.Filename As Integer

Dim Shared No.List.Archive As Integer
Dim Shared No.List.Hidden As Integer
Dim Shared No.List.Readonly As Integer
Dim Shared No.List.System As Integer
Dim Shared No.List.Directory As Integer
Dim Shared No.List.Compressed As Integer
Dim Shared No.List.Encrypted As Integer

' declare search work variables
Dim Shared Display.Descrip As Integer
Dim Shared Short.Attr As Integer
Dim Shared Short.File As Integer

' initialize drive work variables
Dim Shared Errors.Counted As Double

Rem Setattr

' declare attribute variables
Dim Shared Set.Directory As Integer
Dim Shared Only.Set.Directory As Integer

Rem Touch

' declare search work variables
Dim Shared Prompt.Files As Integer

' declare date\time work variables
Dim Shared HourTemp As Integer
Dim Shared MinuteTemp As Integer
Dim Shared SecondTemp As Integer
Dim Shared MonthTemp As Integer
Dim Shared DayTemp As Integer
Dim Shared YearTemp As Integer

Rem Xcount

Const Kilo = 1024
Const Mega = 1048576
Const Giga = 1073741824

Const LMaxInt = 65536
Const MaxInt = 32767
Const SMaxInt = 16384

Const MLong = 4294967296
Const SLong = 2147483647

' declare filename buffer
Const xbuflen = 32767 ' can be changed
Dim Shared xbuffer As String * xbuflen

Dim Shared xbuffer1 As String * xbuflen
Dim Shared xbuffer2 As String * xbuflen

Rem QB64shell

' declare library constants.
Const MAX_PATH = 260
Const MAX_PATH2 = 520
Const INVALID_HANDLE_VALUE = -1
Const ERROR_FILE_NOT_FOUND = 2
Const ERROR_NO_MORE_FILES = &H12

' declare library structures.
Type FILETIME
   dwLowDateTime As _Unsigned Long
   dwHighDateTime As _Unsigned Long
End Type

Type SYSTEMTIME
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Type WIN32_FIND_DATAA
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path
   cAlternateFileName As String * 14
End Type

' windows structure for a wide FindFile
Type WIN32_FIND_DATAW
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path2
   cAlternateFileName As String * 28
End Type

' declare admin access library.
Declare Dynamic Library "Shell32"
   Function IsUserAnAdmin& ()
   Sub ShellExecute Alias "ShellExecuteA" (ByVal hwnd As _Offset, lpOperation As String, lpFile As String, lpParameters As String, ByVal lpDirectory As _Offset, ByVal nShowCmd As Long)
End Declare

' declare external libraries.
Declare Dynamic Library "kernel32"
   Function FindFirstFileA~%& (ByVal lpFileName~%&, ByVal lpFindFileData~%&)
   Function FindNextFileA& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindFirstFileW~%& (lpwszFileName$, ByVal lpFindFileData~%&)
   Function FindNextFileW& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindClose& (ByVal hFindFile~%&)

   Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, ByVal nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, ByVal nFileSystemNameSize&)
   Function GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
   Function GetDiskFreeSpaceExA& (filename$, free As _Unsigned _Integer64, total As _Unsigned _Integer64, free2 As _Unsigned _Integer64)
   Function SetVolumeLabelA% (d$, f$)

   Function GetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function SetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function FileTimeToSystemTime& (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
   Function SystemTimeToFileTime& (lpSystemTime As SYSTEMTIME, lpFileTime As FILETIME)
   Function GetLocalTime& (lpSystemTime As SYSTEMTIME)
   Function SetLocalTime& (lpSystemTime As SYSTEMTIME)
   Function GetSystemTime& (lpSystemTime As SYSTEMTIME)
   Function SetSystemTime& (lpSystemTime As SYSTEMTIME)

   Function DeleteFileA% (F$)
   Function RemoveDirectoryA% (F$)
   Function CreateDirectoryA% (F$, ByVal X&&)
   Function SetCurrentDirectoryA% (f$)
   Function CloseHandle& (ByVal hfile As _Offset)
   Function GetLastError& ()
   Function FormatMessageA& (ByVal f As Long, f$, ByVal e As Long, ByVal d As Long, g$, ByVal s As Long, h$)

   Function MultiByteToWideChar& (ByVal codePage~&, ByVal dwFlags~&, lpszMbstring$, ByVal byteCount&, lpwszWcstring$, ByVal wideCount&)
   Function WideCharToMultiByte& (ByVal codePage~&, ByVal dwFlags~&, lpWideString$, ByVal ccWideChar%, lpMultiByte$, ByVal multibyte%, ByVal defaultchar&, ByVal usedchar&)
   Function MoveFileW (f$, g$)
End Declare

Declare Library
   Function CreateFileA%& (filename$, ByVal access&, ByVal sharing&, ByVal sec_attr%&, ByVal create&, ByVal flags&, ByVal template%&)
   Function GetFileAttributes& (f$)
   Function SetFileAttributes& (f$, ByVal a&)
   Function GetDriveType& (d$)
   Function GetShortPathName& (InP$, OutP$, ByVal length&)
   Function GetModuleFileNameA (ByVal Module As Long, FileName As String, ByVal nSize As Long)
   Function MoveFile (f$, g$)
   Function CopyFile (f$, g$, ByVal f%)
   Function EncryptFile (f$)
   Function DecryptFile (f$, ByVal f&)
   Function EncryptFileA (f$)
   Function DecryptFileA (f$, ByVal f&)
End Declare

Declare Dynamic Library "advapi32"
   Function FileEncryptionStatusA% (f$, f&)
End Declare

Declare Dynamic Library "user32"
   Function SendMessageA%& (ByVal hWnd%&, ByVal Msg~&, ByVal wParam~%&, ByVal lParam%&)
   Function GetDesktopWindow%& ()
End Declare

Declare Dynamic Library "urlmon"
   Function URLDownloadToFileA% (ByVal pCaller As Long, szURL As String, szFileName As String, ByVal dwReserved As Long, ByVal lpfnCB As Long)
End Declare

' declare library variables.
Dim Shared CreateDate As FILETIME
Dim Shared AccessDate As FILETIME
Dim Shared ModifyDate As FILETIME

Dim Shared SourceCreateDate As FILETIME
Dim Shared SourceAccessDate As FILETIME
Dim Shared SourceModifyDate As FILETIME

Dim Shared SysTime As SYSTEMTIME
Dim Shared DriveType As String
Dim Shared DateTimeType As Integer
Dim Shared finddatatemp As WIN32_FIND_DATAA

' define version constants
Const Version$ = "v.0002"
Const Release$ = "r.102"
Const Build$ = "08-15-2025.01"
Const FullVersion$ = Version$ + " " + Release$ + " build " + Build$

' declare prompt
Dim Shared Prompt As String
Dim Shared Status As Integer
Dim Shared Debug As Integer

' declare prompt colors
Dim Shared PromptForeground As Integer
Dim Shared PromptBackground As Integer

' history array dimension
Const MaxHistory = 10

' config filename
Const ConfigFilename$ = "qb64shell.cfg"
Dim Shared StartDir As String

' declare drive path table
Dim Shared DriveTable(1) As String

' pushd path table variables
Dim Shared NetPathTable(1) As String
Dim Shared PathTable(1) As String
Dim Shared NetPathCount As Single
Dim Shared PathCount As Single, PathMax As Single

' file menu editor config filename
Const MenuConfigFilename$ = "filemenu.cfg"

' copyit error log filename
Const ErrorLogFile$ = "copyerr.log"
Const CriticalErrorLogFile$ = "shellerr.log"

' copyit config filename
Const CopyitConfig$ = "COPYIT.CFG"

' declare external library
Declare Library "mem"
   Function MemInUsePercent~&&
   Function TotalPhysicalMem~&&
   Function FreePhysicalMem~&&
   Function TotalPagingFile~&&
   Function FreePagingFile~&&
   Function TotalVirtualMem~&&
   Function FreeVirtualMem~&&
   Function FreeExtendedMem~&&
   Function GetCPULoad#
End Declare

' declare screen settings
Dim Shared SOFF As Integer, KEYOFF As Integer, CPUOFF As Integer
Dim Shared WindowX As Long, WindowY As Long, CPUMON As Integer

' declare memory monitor settings
Dim Shared MONITORON As Integer, MonitorLimit As Double
Dim Shared MonitorCount As Single, MonitorTimer As Single
Dim Shared MonitorSuffix As Integer
Dim Shared DisplaySelect As Integer

' declare function keys
Dim Shared FunctionKeys(12) As String

' declare standard filenames
Dim Shared StdinFile As String
Dim Shared Stdin As Integer
Dim Shared StdinHandle As Long

Dim Shared StdoutFile As String
Dim Shared Stdout As Integer
Dim Shared StdoutHandle As Long

Dim Shared StderrFile As String
Dim Shared Stderr As Integer
Dim Shared StderrHandle As Long

Dim Shared StdinCount As Long
Dim Shared StdinLines As Long
Dim Shared StdinMax As Long

Dim Shared StdoutCount As Long
Dim Shared StdoutLines As Long
Dim Shared StdoutMax As Long

' declare standard i/o arrays
Dim Shared StdinArray(1) As String
Dim Shared StdoutArray(1) As String

' program variables
ReDim Arrays(0 To 1024, 0 To Max.Arrays) As Double
ReDim Definitions(0 To Max.FNs) As String
ReDim Strngs(0 To 1024) As String
ReDim Variables(0 To 1024) As Double

' initialize multi-dimensional command history arrays
ReDim History2(1 To 3, 1 To MaxHistory) As String * 256
ReDim HistoryCount2(1 To 3) As Integer

' declare simple command set array
Const MaxSimple = 47
Dim Shared SimpleCommands(1 To MaxSimple) As String
Dim Shared SimpleCommandsN(1 To MaxSimple) As Integer

' declare complex command set array
Const MaxComplex = 35
Dim Shared ComplexCommands(1 To MaxComplex) As String
Dim Shared CommandList(1) As String
Dim Shared CommandCount As Integer
Dim Shared CurrentCommand As Integer

' declare arrays for screen store/restore
Dim Shared TempArrayY(1 To 2000) As Integer
Dim Shared TempArrayZ(1 To 2000) As Integer
Dim Shared TempArrayY2(1 To 2000) As Integer
Dim Shared TempArrayZ2(1 To 2000) As Integer

' declare menu area storage arrays.
Dim Shared Area1(24, 44) As Integer, Area2(24, 44) As Integer

' declare menu variables for DropDownMenu.
Dim Shared CurrentMenu As Integer, CurrentMenuSelection As Integer

' declare all common mouse variables.
Dim Shared MouseX As Integer, MouseY As Integer
Dim Shared MouseButton1 As Integer, MouseButton2 As Integer
Dim Shared MouseButton3 As Integer, MouseWheel As Integer
Const ClickCount = 10 ' double click loop counter
Const ClickDelay = .1 ' double click loop delay

' declare shift key constants
Const KEY_RSHIFT& = 100303
Const KEY_LSHIFT& = 100304

Const KEY_RCTRL& = 100305
Const KEY_LCTRL& = 100306

Const KEY_RALT& = 100307
Const KEY_LALT& = 100308

Rem Variables for file menu box.

' declare ascii character variables.
Dim Shared Hline As Integer, Vline As Integer
Dim Shared ULcorner As Integer, URcorner As Integer
Dim Shared LLcorner As Integer, LRcorner As Integer

' declare some filenames.
Dim Shared Filename As String, Dumpfile As String, Excludefile As String
Dim Shared Music.Filename As String

' declare files/dirs maximum variables.
Dim Shared SortMax As Single, SortMax2 As Single
Dim Shared SeekPosition As Double, SeekPosition2 As Double

' declare file search position variables.
Dim Shared StoreSearchMulti As Integer

' declare all long filename common variables.
Dim Shared TempASCIIZ As String * 260
Dim Shared FileSize As Double, FileSizeType As Integer
Dim Shared QuietSwitch As Integer
Dim Shared Node As Integer

' declare all common mouse variables.
Dim Shared WheelReverse As Integer

' declare filename variables for file menu box.
Dim Shared Ambiguate As Integer, AmbiguateSwitch As Integer

' declare Alt-n keys array.
Dim Shared Keys(1 To 26) As Integer

' declare menu screen location offsets for file menu box.
Dim Shared Xcoor As Integer, Ycoor As Integer

' declare temp file share variables.
Dim Shared Share.Count As Integer ' count violations

' temp directory
Dim Shared DRX As String

' menu file box parameters
Dim Shared NetPath2 As String
Dim Shared OldDrive As String, OldDirectory As String
Dim Shared FileSpec1 As String

' declare color variables.
Dim Shared BackGround As Integer, BackGround2 As Integer
Dim Shared BackGround3 As Integer, BackGround4 As Integer
Dim Shared BackGround5 As Integer, BackGround6 As Integer
Dim Shared BackGround7 As Integer, BackGround8 As Integer
Dim Shared BackGround9 As Integer, BackGround10 As Integer
Dim Shared Background11 As Integer, BackGround12 As Integer
Dim Shared BackGround13 As Integer, BackGround14 As Integer
Dim Shared BackGround15 As Integer

' declare quit box colors
Const QuitBoxText$ = "Quit. Are you sure?"
Const QuitBoxText2$ = "Save file?"
Dim Shared QuitBoxBorderColor As Integer
Dim Shared QuitBoxTitleColor As Integer
Dim Shared QuitBoxTextColor As Integer
Dim Shared QuitBoxButton1Color As Integer
Dim Shared QuitBoxButton2Color As Integer

' declare quit box coordinates
Dim Shared QuitXcoor As Integer, QuitYcoor As Integer
Dim Shared QuitXcoor2 As Integer, QuitYcoor2 As Integer

' declare append box colors
Dim Shared AppendBoxBorderColor As Integer
Dim Shared AppendBoxTitleColor As Integer
Dim Shared AppendBoxTextColor As Integer
Dim Shared AppendBoxButton1Color As Integer
Dim Shared AppendBoxButton2Color As Integer

' declare append box coordinates
Dim Shared AppendXcoor As Integer, AppendYcoor As Integer

' declare filename box colors
Dim Shared FilenameBoxBorderColor As Integer
Dim Shared FilenameBoxTitleColor As Integer
Dim Shared FilenameBoxTextColor As Integer
Dim Shared FilenameBoxButton1Color As Integer
Dim Shared FilenameBoxButton2Color As Integer

' declare filename box coordinates
Dim Shared FilenameXcoor As Integer, FilenameYcoor As Integer

' declare jump box colors
Dim Shared JumpBoxBorderColor As Integer
Dim Shared JumpBoxTitleColor As Integer
Dim Shared JumpBoxTextColor As Integer
Dim Shared JumpBoxButton1Color As Integer
Dim Shared JumpBoxButton2Color As Integer

' declare jump box coordinates
Dim Shared JumpXcoor As Integer, JumpYcoor As Integer

' declare search box colors
Dim Shared SearchBoxBorderColor As Integer
Dim Shared SearchBoxTitleColor As Integer
Dim Shared SearchBoxTextColor As Integer
Dim Shared SearchBoxButton1Color As Integer
Dim Shared SearchBoxButton2Color As Integer
Dim Shared SearchBoxBackGround As Integer
Dim Shared SearchBoxButtonBackGround As Integer

' declare search box coordinates
Dim Shared SearchXcoor As Integer, SearchYcoor As Integer

' declare search box flags
Dim Shared WildcardSelect As Integer, SensitiveSelect As Integer

' declare hexcalc box colors
Dim Shared HexCalcBackground1 As Integer, HexCalcBackground2 As Integer
Dim Shared HexCalcForeground1 As Integer, HexCalcForeground2 As Integer

' declare hexcalc helpbox colors
Dim Shared HexCalcHelpBackground1 As Integer, HexCalcHelpBackground2 As Integer
Dim Shared HexCalcHelpForeground1 As Integer, HexCalcHelpForeground2 As Integer

' declare hexcalc box coordinates
Dim Shared HexCalcXcoor As Integer, HexCalcYcoor As Integer

' declare hexcalc help box coordinates
Dim Shared HexCalcHelpXcoor As Integer, HexCalcHelpYcoor As Integer

' declare ascii box colors
Dim Shared AsciiBoxBorderColor As Integer
Dim Shared AsciiBoxTitleColor As Integer
Dim Shared AsciiBoxTextColor As Integer
Dim Shared AsciiBoxButton1Color As Integer
Dim Shared AsciiBoxButton2Color As Integer

' declare ascii box coordinates
Dim Shared AsciiXcoor As Integer, AsciiYcoor As Integer

' declare help about box colors
Dim Shared AboutBoxBorderColor As Integer
Dim Shared AboutBoxTitleColor As Integer
Dim Shared AboutBoxTextColor As Integer

' declare about box coordinates
Dim Shared AboutXcoor As Integer, AboutYcoor As Integer

' declare file menu box colors
Dim Shared FileBoxBorderColor As Integer
Dim Shared FileBoxTitleColor As Integer
Dim Shared FileBoxTextColor As Integer

' declare hex calc box colors
Dim Shared CalcBoxBorderColor As Integer
Dim Shared CalcBoxTitleColor As Integer
Dim Shared CalcBoxTextColor As Integer

' declare network path variables.
Dim Shared DefaultNetPath As String * 260

' declare default printer port variable.
Dim Shared PrinterPort As String

' declare author constants.
Const Author = "Erik Jon Oredson"
Const Email = "eoredson@gmail.com"
Const Program = "QB64shell"
Const Publish = "06/25/2025"
Const Urls = "www.applewoodbbs.linkpc.net"
Const UrlEmc3 = "http://applewoodbbs.linkpc.net/files/ifdc/oredson/emc3.zip"
Const Emc3Filename = "emc3.zip"

' declare maximum files/processes.
Const MaxViolations = 1024 ' maximum share violations

' declare maximum files/dirs values for file menu box.
Const MaxPrecision = 1048576! ' maximum files/dirs
Const MaxPrecision1 = 1024! ' maximum kilos of files/dirs
Const MaxPrecision2 = 1! ' maximum megs of files/dirs

' declare fullscreen mode
Dim Shared Fullscreen As Integer

' declare screen saver variables
Dim Shared ScreenSaverActive As Integer
Dim Shared ScreenSaverTimer As Single
Dim Shared ScreenSaverResolution As Single
Dim Shared KeyPressed As Integer
Dim Shared MousePressed As Integer

Const wm_syscommand = &H112&
Const sc_screensave = &HF140&

Rem User Profiles Variables

Type UserProfileType
   Username As String * 20
   Password As String * 8
   ScreenSaver As Integer
   ScreenTimer As Single

   LastDateOn As String * 19 ' 01/01/1980 HH:MM:SS
   CreationDate As String * 19

   TimesLoggedOn As Double

   ASCIIZreserved1 As String * 260
   ASCIIZreserved2 As String * 260

   DOSreserved1 As String * 12
   DOSreserved2 As String * 12

   TimesDeleted As Integer
   TimesUndeleted As Integer

   MonitorOn As Integer
   MonitorTimer As Single
   MonitorLimit As Double

   Reserved1 As Integer
   Reserved2 As Integer
   Reserved3 As Single
   Reserved4 As Single
   Reserved5 As Long
   Reserved6 As Long
   Reserved7 As Double
   Reserved8 As Double

   Deleted As Integer
End Type

Dim Shared UserProfileRecord As UserProfileType
Dim Shared UserProfileRecord2 As UserProfileType
Dim Shared UserProfileRecord3 As UserProfileType

Dim Shared ProfilesActive As Integer
Dim Shared Username As String, Password As String
Dim Shared UsernameTemp As String

Const ProfileFilename$ = "profiles.dat"
Const ProfileBackupFilename$ = "profiles.bak"
Dim Shared MaskInput As Integer
Const MaskChar$ = "*"
Const MaxTries = 3
Const Primekey = 23
Const LockProfiles = 0 ' set to -1 to restrict profiles editing to SYSOP only

Rem value of file played
Dim Shared SoundEffect As Integer
Dim Shared SoundHandle As Long
Dim Shared SoundVolume As Single
Const SoundFile = "THX_Sound_Effect.mp3"

Rem dialog box variable declare statements.

'Declare Dynamic Library "comdlg32" ' Library declarations using _OFFSET types
'   Function GetOpenFileNameA&& (DIALOGPARAMS As FILEDIALOGTYPE) ' The Open file dialog
'   Function GetSaveFileNameA&& (DIALOGPARAMS As FILEDIALOGTYPE) ' The Save file dialog
'End Declare

Declare Library
   Function FindWindow~&& (ByVal ClassName As _Offset, WindowName$) ' To get hWnd handle
End Declare

Dim Shared hWnd As _Integer64

$If 64BIT Then
   hWnd = _WINDOWHANDLE ' FindWindow(0, "Open and Save Dialog" + CHR$(0)) 'get window handle using _TITLE string
$Else
   hWnd&& = FindWindow(0, "Qb64Shell" + Chr$(0)) 'get window handle using _TITLE string
$End If

Dim Shared Title As String * 260

Const TitleBarIcon$ = "qb64shell.bmp"
Const TitleBarIcon2$ = "qb64shell.ico"

' declare all alarm arrays
Const MaxAlarms = 9 ' can be changed
Dim Shared AlarmFlags(1 To MaxAlarms) As Integer
Dim Shared AlarmStart(1 To MaxAlarms) As Single
Dim Shared AlarmTime(1 To MaxAlarms) As Single
Dim Shared AlarmType(1 To MaxAlarms) As Integer
Dim Shared AlarmBeep(1 To MaxAlarms) As Integer
Dim Shared AlarmColor(1 To MaxAlarms) As Integer
Dim Shared AlarmMusic(1 To MaxAlarms) As Integer
Dim Shared t8 As Integer, AlarmTrapColor As Integer
Const AlarmDelay = .2!

' sound settings
Const Freq = 900
Const Duration = 6
Dim Shared MakeBeep As Integer
Const Melody = "o3 L8 E D+ E D+ E o2 B o3 D C L2 o2 A"

' set soundfile extensions
Const MaxSoundFileExtensions = 32
Dim Shared SoundFileExtensions(1 To MaxSoundFileExtensions) As String

' set soundfile extensions
Const MaxSoundFontExtensions = 8
Dim Shared SoundFontExtensions(1 To MaxSoundFontExtensions) As String

' set keymapper arrays
Dim Shared KeyMap(3, 0 To 255) As Integer ' ascii
Dim Shared KeyMapExtended(3, 0 To 255) As Integer ' extended ascii
