REM Indent.bas v64.0a r8.0a - Symbolic Instruction Code Kit; indent module.

' get standard include declarations
REM $INCLUDE: 'SIC16.INC'

' declare global error routine
ON ERROR GOTO Error.Routine

COLOR White, Black
PRINT "Indent v" + Version + " r" + Release + ":"

' adjust array size
Max.Lines = 4096
100
PRINT "Array size is:"; Max.Lines
PRINT "Increase array size(y/n)?";
DO
    X$ = INKEY$
    IF UCASE$(X$) = "N" THEN PRINT : EXIT DO
    IF UCASE$(X$) = "Y" THEN
       PRINT
       PRINT "Enter value(4096-32766)";
       INPUT X
       IF X >= 4096 AND X <= 32766 THEN Max.Lines = X
       EXIT DO
    END IF
LOOP

' program code
REDIM Program(1 TO Max.Lines) AS STRING

' initialize variables
White.Space = CHR$(32) + CHR$(9)

' run program from command line
Filename = COMMAND$
IF LEN(Filename) = False THEN
   PRINT "Enter .sic filename";
   INPUT Filename
END IF
IF Filename = Nul THEN
   GOTO Boot.Usage
END IF
CALL New.Program
CALL Read.Program
CALL Indent.Program
Error.Resume:
COLOR Plain, Black
WHILE INKEY$ <> Nul
WEND
PRINT "Exiting to system.."
END

Boot.Usage:
COLOR White, Black
PRINT "Indent v" + Version + " r" + Release + "; Usage:"
COLOR Yellow, Black
PRINT "Indent <program name>"
PRINT "   Indents program specified on command line."
COLOR Plain, Black
END

' standard error trap for all Sic functions.
Error.Routine:
IF POS(0) > 1 THEN
   PRINT
END IF
COLOR White, Black
PRINT "Indent utility error";
SELECT CASE ERR
   CASE 9 ' subscript out of range
      PRINT
      PRINT "Array size error."
      Max.Lines = 4096
      RESUME 100
   CASE 52, 53
      PRINT ": File not found."
   CASE 70
      PRINT ": File is read-only."
   CASE ELSE
      PRINT ERR
END SELECT
RESUME Error.Resume

' declares indent structure types
IndentDATA:
' 1=indent right
DATA "SELECTIF CASE",1
DATA "DO WHILE",1
DATA "DO",1
DATA "IF",1
DATA "SELECT CASE",1
DATA "DO UNTIL",1
DATA "FORIF",1
DATA "FOR",1
DATA "WHILE",1
DATA "LOOPIF",1
' -1=indent left
DATA "ENDIF",-1
DATA "END IF",-1
DATA "NEXTIF",-1
DATA "NEXT",-1
DATA "LOOP UNTIL",-1
DATA "LOOP WHILE",-1
DATA "END SELECT",-1
DATA "WEND",-1
DATA "END LOOPIF",-1
DATA "LOOP",-1
DATA "END SELECTIF",-1
' -2=indent left, then right
DATA "ELSE",-2
DATA "CASE",-2
DATA "EOF",0

REM $DYNAMIC
' gets last line in program
SUB Count.Lines (Temp1%)
   Temp1% = False
   FOR Temp2% = Max.Lines TO 1 STEP -1
      Temp1$ = Program(Temp2%)
      Temp1$ = STRIM$(Temp1$)
      IF LEN(Temp1$) THEN
         EXIT FOR
      END IF
   NEXT
   Temp1% = Temp2%
END SUB

' indents current program
SUB Indent.Program
   COLOR Yellow, Black
   PRINT "Enter number of spaces to indent";
   INPUT Increment
   Increment = INT(Increment)
   IF Increment <= 0 THEN
      EXIT SUB
   END IF
   Indent = False
   CALL Count.Lines(Last.Line)
   MX = LEN(STR$(Last.Line))
   FOR Program.Line = 1 TO Last.Line
      Number$ = SPACE$(MX - LEN(MID$(STR$(Program.Line), 2)))
      Out2 = Program(Program.Line)
      Out2 = STRIM$(Out2)
      IF LEN(Out2) THEN
         Temp1$ = STRIM$(Out2)
         Temp1$ = UCASE$(Temp1$)
         Temp1$ = TTRIM$(Temp1$, False)
         Next.Indent = False
         RESTORE IndentDATA
         DO
            READ Keyword$, KeyIndent
            IF Keyword$ = "EOF" THEN
               EXIT DO
            END IF
            IF LEFT$(Temp1$, LEN(Keyword$)) = Keyword$ THEN
               Next.Indent = KeyIndent
               EXIT DO
            END IF
         LOOP
         SELECT CASE Next.Indent
            CASE 1 ' right
               Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
               Indent = Indent + 1
            CASE -1 ' left
               Indent = Indent - 1
               IF Indent < False THEN
                  PRINT "Indent error: Line:"; Program.Line
                  EXIT SUB
               END IF
               Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
            CASE -2 ' left/right
               Indent = Indent - 1
               IF Indent < False THEN
                  PRINT "Indent error: Line:"; Program.Line
                  EXIT SUB
               END IF
               Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
               Indent = Indent + 1
            CASE ELSE
               Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
         END SELECT
         Out2 = Number$ + Out2
         Program(Program.Line) = Out2
      END IF
   NEXT
   IF Indent <> False THEN
      PRINT "Indent error: Line:"; Program.Line
   ELSE
      CALL Store.Program
      PRINT "Program indented."
   END IF
END SUB

' remove current .sic program from memory
SUB New.Program
   ' erase/redimension program code array
   ERASE Program
   REDIM Program(1 TO Max.Lines) AS STRING
END SUB

' loads a program from disk
SUB Read.Program
   CLOSE
   OPEN Filename FOR INPUT AS #1
   DO WHILE NOT EOF(1)
      LINE INPUT #1, Out2
      Out2 = STRIM$(Out2)
      FOR Blanks = 1 TO LEN(White.Space)
         Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
         IF Imbedded THEN
            Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
            IF Line.Number > False AND Line.Number <= Max.Lines THEN
               Program(Line.Number) = MID$(Out2, Imbedded)
               EXIT FOR
            END IF
         END IF
      NEXT
   LOOP
   CLOSE
END SUB

' writes out the current .sic program to file
SUB Store.Program
   CLOSE
   OPEN Filename FOR OUTPUT AS #1
   CALL Count.Lines(Last.Line)
   FOR Line.Number = 1 TO Last.Line
      ProgramLine$ = Program(Line.Number)
      IF STRIM$(ProgramLine$) <> Nul THEN
         IF INSTR(White.Space, LEFT$(ProgramLine$, 1)) THEN
            PRINT #1, MID$(STR$(Line.Number), 2) + ProgramLine$
         ELSE
            PRINT #1, MID$(STR$(Line.Number), 2) + " " + ProgramLine$
         END IF
      END IF
   NEXT
   CLOSE
END SUB

' strips leading/trailing white spaces from string
FUNCTION STRIM$ (Var$)
   XVar$ = Var$
   DO
      Blanks = 0
      FOR Count = 1 TO LEN(White.Space)
         IF LEFT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
            XVar$ = MID$(XVar$, 2)
            Blanks = -1
         END IF
      NEXT
      IF Blanks = 0 THEN
         EXIT DO
      END IF
   LOOP
   DO
      Blanks = 0
      FOR Count = 1 TO LEN(White.Space)
         IF RIGHT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
            XVar$ = LEFT$(XVar$, LEN(XVar$) - 1)
            Blanks = -1
         END IF
      NEXT
      IF Blanks = 0 THEN
         EXIT DO
      END IF
   LOOP
   STRIM$ = XVar$
END FUNCTION

' replaces white spaces with blanks
' var = -1 skip blanks in quotes
FUNCTION TTRIM$ (Var$, Var)
   VarX$ = Var$
   Temp = False
   DO
      Temp = Temp + 1
      IF Temp > LEN(VarX$) THEN
         EXIT DO
      END IF
      IF Var THEN
         IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
            DO
               Temp = Temp + 1
               IF Temp > LEN(VarX$) THEN
                  EXIT DO
               END IF
               IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                  EXIT DO
               END IF
            LOOP
         END IF
      END IF
      FOR Blanks = 1 TO LEN(White.Space)
         IF MID$(VarX$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
            MID$(VarX$, Temp, 1) = " "
         END IF
      NEXT
   LOOP
   Temp = False
   DO
      Temp = Temp + 1
      IF Temp > LEN(VarX$) THEN
         EXIT DO
      END IF
      IF Var THEN
         IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
            DO
               Temp = Temp + 1
               IF Temp > LEN(VarX$) THEN
                  EXIT DO
               END IF
               IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                  EXIT DO
               END IF
            LOOP
         END IF
      END IF
      IF MID$(VarX$, Temp, 2) = "  " THEN
         VarX$ = LEFT$(VarX$, Temp) + MID$(VarX$, Temp + 2)
         Temp = Temp - 1
      END IF
   LOOP
   TTRIM$ = VarX$
END FUNCTION

