Rem SICHelp.bas v64.0a r7.9a - Symbolic Instruction Code Kit; help module.
Rem Backwards compatible with QB 1.1, 4.5, 7.1, and VBdos.

DefInt A-Z
Rem $DYNAMIC

DECLARE SUB DisplayStatusLine ()
DECLARE SUB ListHelp ()
DECLARE SUB ListHelpFile ()
DECLARE SUB ListHelpFile2 ()
DECLARE SUB MorePrompt1 (I$, M$, O$)
DECLARE SUB KeyPrompt ()
DECLARE SUB Save.Screen (var)
DECLARE FUNCTION XTRIM$ (var$, var)
DECLARE FUNCTION clock$ ()

' setup screen
Common Shared Filename As String
Common Shared TempX2 As Integer
Common Shared Temp.Array1() As Integer
Common Shared Temp.Array2() As Integer
Common Shared DisplayTimer As Single
Common Shared Max.Row As Integer
Common Shared Max.Line As Integer

' color constants
Const Black = 0
Const Blue = 1
Const Plain = 7
Const Green = 10
Const Cyan = 11
Const Red = 12
Const Magenta = 13
Const Yellow = 14
Const White = 15

' declare global error routine
On Error GoTo ErrorRoutine

Rem setup for QB64:
QB64 = 0
If QB64 Then
   '_ScreenMove _Middle
   'Max.Line = _Width
   'Max.Row = _Height
Else
   Max.Line = 80
   Max.Row = 25
End If

' setup menu screen.
Width Max.Line, Max.Row
Call Save.Screen(0)
Color Black
Cls
Locate Max.Row - 1, 1, 1
Call DisplayStatusLine

' start help menu loop.
StartLoop:
Call ListHelp

' exit to dos
ErrorResume:
Color Plain, Black
While InKey$ <> ""
Wend

Locate Max.Row, 1, 0
Color White, Black
Print Space$(Max.Line);
Color 7
Cls
Call Save.Screen(-1)
'Locate Max.Row,1,1
If TempX2 = 0 Then TempX2 = 1
Locate TempX2, 1, 1
Print
Color White, Black
Locate Max.Row - 1, 1, 1
Print "Exiting to system.."
Color Plain, Black
End

' standard error trap for all Sic functions.
ErrorRoutine:
If Pos(0) > 1 Then
   Print
End If
Color Red, Black
Print "Help utility error"; Err
If Err = 53 Then
   Print "File "; Filename; " not found."
   Color White, Black
   Resume StartLoop
End If
Color White, Black
Print "Press key to exit:"
Resume ErrorResume

' Def FNclock$=Format$(Now,"ddd dd mmm yyyy\, hh:mma/p")
Function clock$
   ' mm-dd-yyyy hh:mm:ss
   M = Val(Left$(Date$, 2))
   D = Val(Mid$(Date$, 4, 2))
   Y = Val(Right$(Date$, 4))

   If M < 3 Then M = M + 12: Y = Y - 1
   W = ((13 * M + 3) \ 5 + D + Y + Y \ 4 - Y \ 100 + Y \ 400 + 1) Mod 7
   Var$ = Mid$("SunMonTueWedThuFriSat", W * 3 + 1, 3)
   Var$ = Var$ + " " + Mid$(Date$, 4, 2) ' dd

   T = (Val(Mid$(Date$, 1, 2)) - 1) * 3 + 1 ' mmm
   Var$ = Var$ + " " + Mid$("JanFebMarAprMayJunJulAugSepOctNovDec", T, 3)

   Var$ = Var$ + " " + Mid$(Date$, 7, 4) ' yyyy

   T = Val(Left$(Time$, 2))
   If T > 11 Then T = T - 12
   If T = 0 Then T = 12
   Var$ = Var$ + ", " + Right$("00" + LTrim$(Str$(T)), 2) ' hh
   Var$ = Var$ + ":" + Mid$(Time$, 4, 2) ' mm

   T = Val(Left$(Time$, 2))
   If T < 12 Then
      Var$ = Var$ + "a"
   Else
      Var$ = Var$ + "p"
   End If
   clock$ = Var$
End Function

Sub DisplayStatusLine
   X = CsrLin: Y = Pos(0)
   Locate Max.Row, 1, 0
   Color White, Blue
   Print Space$(Max.Line);
   Locate Max.Row, 1, 0
   Print "SIC Help Menu "; Date$; " "; Time$; " v64.0a r7.9a";
   Color White, Black
   Locate X, Y, 1
End Sub

' prompts for a keystroke
Sub KeyPrompt
   If DisplayTimer = 0! Then DisplayTimer = Timer
   Color White, Black
   Locate , , 1
   Print "Press any key to continue:";
   InputChar$ = ""
   Do
      InputChar$ = InKey$
      Elapsed! = Timer - DisplayTimer
      If Elapsed! < 0! Then Elapsed! = Elapsed! + 86400!
      If Elapsed! >= 1! Then
         DisplayTimer = Timer
         Call DisplayStatusLine
      End If
      If Len(InputChar$) Then
         Exit Do
      End If
   Loop
   Print
End Sub

' display help menu
Sub ListHelp
   Do
      Color White, Black
      Print "Help utility SIC v64.0a r7.9a list:"
      Color Yellow, Black
      Print "[1]command list"
      Print "[2]general documentation"
      Print "[3]formatting information"
      Print "[4]screen mode tables"
      Print "[5]error code values"
      Print "[6]syntax documentation"
      Print "[7]boolean syntax/charts"
      Print "[8]troolean syntax/charts"
      Print "[9]disclaimer notice"
      Print "[A]shareware information"
      Print "[B]version list"
      Print "[C]short command list"
      Call MorePrompt1("Enter(1-C, Q to quit)?", "123456789abcq" + Chr$(13), OutputChar$)
      If OutputChar$ = Chr$(13) Then OutputChar$ = "q"
      Select Case OutputChar$
         Case "1"
            Filename = "menu4.doc"
            Call ListHelpFile2
         Case "2"
            Filename = "sic64.doc"
            Call ListHelpFile
         Case "3"
            Filename = "sicform.doc"
            Call ListHelpFile
         Case "4"
            Filename = "sicscrn.doc"
            Call ListHelpFile
         Case "5"
            Filename = "error.doc"
            Call ListHelpFile
         Case "6"
            Filename = "syntax.doc"
            Call ListHelpFile
         Case "7"
            Filename = "boolean.doc"
            Call ListHelpFile
         Case "8"
            Filename = "troolean.doc"
            Call ListHelpFile
         Case "9"
            Filename = "disclaim.doc"
            Call ListHelpFile
         Case "a"
            Filename = "disclam2.doc"
            Call ListHelpFile
         Case "b"
            Filename = "version.lst"
            Call ListHelpFile
         Case "c"
            Filename = "menu5.doc"
            Call ListHelpFile
         Case "q"
            Exit Do
      End Select
   Loop
End Sub

' displays a help file
Sub ListHelpFile
   Close
   Open Filename$ For Binary As #1
   X# = LOF(1)
   Close
   If X# = 0# Then
      Print "Helpfile " + Chr$(34) + Filename + Chr$(34) + " not found."
      Call MorePrompt1("More(y/n)?", "yn" + Chr$(13), OutputChar$)
      Exit Sub
   End If
   Close
   Open Filename$ For Input As #1
   Continuous = 0
   LineCount = 0
   Do While Not EOF(1)
      Color Yellow, Black
      Line Input #1, InputLine$
      Print InputLine$
      If Continuous = 0 Then
         LineCount = LineCount + 1
         If LineCount >= Max.Row - 2 Then
            LineCount = 0
            Call MorePrompt1("More(y/n/c)?", "ync" + Chr$(13), OutputChar$)
            Select Case OutputChar$
               Case "n"
                  Exit Do
               Case "c"
                  Continuous = -1
            End Select
         End If
      End If
   Loop
   Call KeyPrompt
End Sub

' displays a custom help file
Sub ListHelpFile2
   Close
   Open Filename$ For Binary As #1
   X# = LOF(1)
   Close
   If X# = 0# Then
      Print "Helpfile " + Chr$(34) + Filename + Chr$(34) + " not found."
      Call MorePrompt1("More(y/n)?", "yn" + Chr$(13), OutputChar$)
      Exit Sub
   End If
   Close
   FileNumber = 1
   Open Filename$ For Input As #FileNumber
   Continuous = 0
   LineCount = 0
   Do While Not EOF(FileNumber)
      Color Yellow, Black
      Line Input #FileNumber, InputLine$
      GoSub ConvertColor
      If VarX Then
         GoTo NextHelpLine
      End If
      If Left$(LTrim$(InputLine$), 1) = ";" Then
         GoTo NextHelpLine
      End If
      If LCase$(InputLine$) = "<more>" Then
         If LineCount > 0 Then
            LineCount = 23
            GoSub DisplayMore
         End If
         GoTo NextHelpLine
      End If
      Do
         V = InStr(LCase$(InputLine$), "quote")
         If V Then
            InputLine$ = Left$(InputLine$, V - 1) + Chr$(34) + Mid$(InputLine$, V + 5)
         Else
            Exit Do
         End If
      Loop
      Do
         V = InStr(LCase$(InputLine$), "<date>")
         If V Then
            InputLine$ = Left$(InputLine$, V - 1) + Date$ + Mid$(InputLine$, V + 6)
         Else
            Exit Do
         End If
      Loop
      Do
         V = InStr(LCase$(InputLine$), "<time>")
         If V Then
            InputLine$ = Left$(InputLine$, V - 1) + Time$ + Mid$(InputLine$, V + 6)
         Else
            Exit Do
         End If
      Loop
      Do
         V = InStr(LCase$(InputLine$), "<clock>")
         If V Then
            InputLine$ = Left$(InputLine$, V - 1) + clock$ + Mid$(InputLine$, V + 7)
         Else
            Exit Do
         End If
      Loop
      Do
         V = InStr(LCase$(InputLine$), "date$")
         If V Then
            InputLine$ = Left$(InputLine$, V - 1) + Date$ + Mid$(InputLine$, V + 5)
         Else
            Exit Do
         End If
      Loop
      Do
         V = InStr(LCase$(InputLine$), "time$")
         If V Then
            InputLine$ = Left$(InputLine$, V - 1) + Time$ + Mid$(InputLine$, V + 5)
         Else
            Exit Do
         End If
      Loop
      Print InputLine$
      If Continuous = 0 Then
         LineCount = LineCount + 1
         GoSub DisplayMore
      End If
      NextHelpLine:
   Loop
   Call KeyPrompt
   Close #FileNumber
   FileNumber = 0
   Exit Sub

   DisplayMore:
   If LineCount >= Max.Row - 2 Then
      LineCount = 0
      Call MorePrompt1("More(y/n/c)?", "ync" + Chr$(13), OutputChar$)
      Select Case LCase$(OutputChar$)
         Case "n"
            Call KeyPrompt
            Close #FileNumber
            FileNumber = 0
            Exit Sub
         Case "c"
            Continuous = -1
      End Select
   End If
   Return

   ConvertColor:
   VarX = 0
   VarX$ = LCase$(InputLine$)
   VarX$ = XTRIM$(VarX$, 0)
   Select Case VarX$
      Case "<color=gray>", "<color=8>"
         Color Gray
         VarX = -1
      Case "<color=blue>", "<color=9>"
         Color Blue
         VarX = -1
      Case "<color=green>", "<color=10>"
         Color Green
         VarX = -1
      Case "<color=cyan>", "<color=11>"
         Color Cyan
         VarX = -1
      Case "<color=red>", "<color=12>"
         Color Red
         VarX = -1
      Case "<color=magenta>", "<color=13>"
         Color Magenta
         VarX = -1
      Case "<color=yellow>", "<color=14>"
         Color Yellow
         VarX = -1
      Case "<color=white>", "<color=15>"
         Color White
         VarX = -1
   End Select
   Return
End Sub

' prompts for multiple input characters
Sub MorePrompt1 (InputString$, InputMask$, OutputString$)
   If DisplayTimer = 0! Then DisplayTimer = Timer
   Color White, Black
   Print InputString$; " ";
   InputChar$ = ""
   Do
      Locate , , 1
      InputChar$ = InKey$
      Elapsed! = Timer - DisplayTimer
      If Elapsed! < 0! Then Elapsed! = Elapsed! + 86400!
      If Elapsed! >= 1! Then
         DisplayTimer = Timer
         Call DisplayStatusLine
      End If
      If Len(InputChar$) Then
         InputChar$ = LCase$(InputChar$)
         If InStr(InputMask$, InputChar$) Then
            If InputChar$ = Chr$(13) Then
               Print
            Else
               Print InputChar$
            End If
            OutputString$ = InputChar$
            Exit Do
         End If
      End If
   Loop
End Sub

Sub Save.Screen (Var)
   If Var = 0 Then
      VarX3 = (Max.Row - 1) * Max.Line + Max.Line
      ReDim Temp.Array1(VarX3) As Integer
      ReDim Temp.Array2(VarX3) As Integer
      For Var1 = 1 To Max.Row
         For Var2 = 1 To Max.Line
            TempZ1 = Screen(Var1, Var2)
            TempZ2 = Screen(Var1, Var2, 1)
            VarX2 = (Var1 - 1) * Max.Line + Var2
            Temp.Array1(VarX2) = TempZ1
            Temp.Array2(VarX2) = TempZ2
         Next
      Next
   Else
      Cls
      For VarQ = Max.Row To 1 Step -1
         For VarQ2 = 1 To Max.Line
            VarX2 = (VarQ - 1) * Max.Line + VarQ2
            If Temp.Array1(VarX2) <> 32 Then
               GoTo Next.Line
            End If
         Next
      Next
      Next.Line:
      TempX2 = VarQ
      For Var1 = 1 To VarQ ' Max.Row
         For Var2 = 1 To Max.Line
            VarX2 = (Var1 - 1) * Max.Line + Var2
            VarB = Int(Temp.Array2(VarX2) / 16)
            VarF = Temp.Array2(VarX2) Mod 16
            TempZ1 = Temp.Array1(VarX2)
            Locate Var1, Var2, 0
            Color VarF, VarB
            Print Chr$(TempZ1);
         Next
      Next
   End If
End Sub

' replaces white spaces with nul,
' var = true; skip spaces in quotes
Function XTRIM$ (var$, var)
   WhiteSpace$ = Chr$(32) + Chr$(9) ' can be changed
   VarX$ = var$
   Temp = 0
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If var Then
         If Mid$(VarX$, Temp, 1) = Chr$(34) Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Chr$(34) Then
                  Exit Do
               End If
            Loop
         End If
      End If
      For Blanks = 1 To Len(WhiteSpace$)
         If Mid$(VarX$, Temp, 1) = Mid$(WhiteSpace$, Blanks, 1) Then
            VarX$ = Left$(VarX$, Temp - 1) + Mid$(VarX$, Temp + 1)
            Temp = Temp - 1
            Exit For
         End If
      Next
   Loop
   XTRIM$ = VarX$
End Function

