Rem Renumber.bas v64.0a r8.6a - Symbolic Instruction Code Kit; renumber module.

' get standard include declarations
Rem $Include: 'SIC16.INC'

' declare global error routine
On Error GoTo Error.Routine

Color White, Black
Print "Renumber v" + Version + " r" + Release + ":"

' adjust array size
Max.Lines = 4096
100
Print "Array size is:"; Max.Lines
Print "Increase array size(y/n)?";
Do
   X$ = InKey$
   If UCase$(X$) = "N" Then Print: Exit Do
   If UCase$(X$) = "Y" Then
      Print
      Print "Enter value(4096-32766)";
      Input X
      If X >= 4096 And X <= 32766 Then Max.Lines = X
      Exit Do
   End If
Loop

' program code
ReDim Program(1 To Max.Lines) As String

' initialize variables
White.Space = Chr$(32) + Chr$(9)

' run program from command line
Filename = Command$
If Len(Filename) = False Then
   Print "Enter .sic filename";
   Input Filename
End If
If Filename = Nul Then
   GoTo Boot.Usage
End If
Call New.Program
Call Read.Program
Prepare.Filename = Filename
Call Renumber.Program
Error.Resume:
Color Plain, Black
While InKey$ <> Nul
Wend
Print "Exiting to system.."
End

Boot.Usage:
Color White, Black
Print "Renumber v" + Version + " r" + Release + "; Usage:"
Color Yellow, Black
Print "Renumber <program name>"
Print "   Renumbers program specified on command line."
Color Plain, Black
End

' standard error trap for all Sic functions.
Error.Routine:
If Pos(0) > 1 Then
   Print
End If
Color White, Black
Print "Renumber utility error";
Select Case Err
   Case 9 ' subscript out of range
      Print
      Print "Array size error."
      Max.Lines = 4096
      Resume 100
   Case 52, 53
      Print ": File not found. Line:"; Erl: Print "Filename: "; Filename
   Case 70
      Print ": File is read-only."
   Case Else
      Print Err
End Select
Resume Error.Resume

Rem $Dynamic
' gets last line in program
Sub Count.Lines (Temp1%)
   Temp1% = False
   For Temp2% = Max.Lines To 1 Step -1
      Temp1$ = Program(Temp2%)
      Temp1$ = STRIM$(Temp1$)
      If Len(Temp1$) Then
         Exit For
      End If
   Next
   Temp1% = Temp2%
End Sub

' remove current .sic program from memory
Sub New.Program
   ' erase/redimension program code array
   Erase Program
   ReDim Program(1 To Max.Lines) As String
End Sub

' loads a program from disk
Sub Read.Program
   Close
   1000
   Open Filename For Input As #1
   Do While Not EOF(1)
      Line Input #1, Out2
      Out2 = STRIM$(Out2)
      For Blanks = 1 To Len(White.Space)
         Imbedded = InStr(Out2, Mid$(White.Space, Blanks, 1))
         If Imbedded Then
            Line.Number = Int(Val(Left$(Out2, Imbedded - 1)) + .5)
            If Line.Number > False And Line.Number <= Max.Lines Then
               Program(Line.Number) = Mid$(Out2, Imbedded)
               Exit For
            End If
         End If
      Next
   Loop
   Close
End Sub

' renumbers current .sic program
Sub Renumber.Program
   Color Yellow, Black
   Print "Starting line number";
   Input Start.Line
   Print "Increment value";
   Input Increment
   Start.Line = Int(Start.Line)
   If Start.Line <= False Then
      Print "Bad start line value."
      Exit Sub
   End If
   If Start.Line > Max.Lines Then
      Print "Bad start line value."
      Exit Sub
   End If
   Increment = Int(Increment)
   If Increment <= False Then
      Print "Bad increment value."
      Exit Sub
   End If
   If Increment > Int(Max.Lines / 2) Then
      Print "Bad increment value."
      Exit Sub
   End If
   Call Count.Lines(Last.Line)
   ReDim Renumber.List(1 To Max.Lines) As Integer
   New.Line.Number = Start.Line
   For Line.Number = 1 To Last.Line
      ProgramLine$ = Program(Line.Number)
      If STRIM$(ProgramLine$) <> Nul Then
         If New.Line.Number > Max.Lines Then
            Color White, Black
            Print "Renumber list exceeds"; Str$(Max.Lines); " lines."
            Erase Renumber.List
            Exit Sub
         End If
         Renumber.List(New.Line.Number) = Line.Number
         New.Line.Number = New.Line.Number + Increment
      End If
   Next
   Print "Renumbering program.."
   For Line.Number = 1 To Last.Line
      New.Program.Line$ = Program(Line.Number)
      Old.Program.Line$ = Program(Line.Number)
      Old.Program.Line$ = STRIM$(Old.Program.Line$)
      Old.Program.Line$ = TTRIM$(Old.Program.Line$, True)
      If Old.Program.Line$ <> Nul Then
         Line.Renumbered = True
         If UCase$(Left$(Old.Program.Line$, 7)) = "RESTORE" Then
            V$ = RTrim$(Mid$(Old.Program.Line$, 8))
            If Len(V$) Then
               If Int(Val(V$) + .5) > 0 Then
                  Line.Renumbered = False
                  Imbedded = InStr(UCase$(New.Program.Line$), "RESTORE") + 7
                  GoSub Next.Space
                  Number$ = Mid$(Old.Program.Line$, 8)
                  Number$ = STRIM$(Number$)
                  Old.Line.Number = Int(Val(Number$) + .5)
                  If Old.Line.Number > False And Old.Line.Number <= Max.Lines Then
                     For New.Line.Number = 1 To Max.Lines
                        If Renumber.List(New.Line.Number) = Old.Line.Number Then
                           Program(Line.Number) = Next.Program.Line$ + LTrim$(Str$(New.Line.Number))
                           Line.Renumbered = True
                           Exit For
                        End If
                     Next
                  End If
               End If
            End If
         End If
         If UCase$(Left$(Old.Program.Line$, 4)) = "GOTO" Then
            Line.Renumbered = False
            Imbedded = InStr(UCase$(New.Program.Line$), "GOTO") + 4
            GoSub Next.Space
            Number$ = Mid$(Old.Program.Line$, 5)
            Number$ = STRIM$(Number$)
            Old.Line.Number = Int(Val(Number$) + .5)
            If Old.Line.Number > False And Old.Line.Number <= Max.Lines Then
               For New.Line.Number = 1 To Max.Lines
                  If Renumber.List(New.Line.Number) = Old.Line.Number Then
                     Program(Line.Number) = Next.Program.Line$ + LTrim$(Str$(New.Line.Number))
                     Line.Renumbered = True
                     Exit For
                  End If
               Next
            End If
         End If
         If UCase$(Left$(Old.Program.Line$, 13)) = "ON ERROR GOTO" Then
            Line.Renumbered = False
            Imbedded = InStr(UCase$(New.Program.Line$), "GOTO") + 4
            GoSub Next.Space
            Number$ = Mid$(Old.Program.Line$, 14)
            Number$ = STRIM$(Number$)
            Old.Line.Number = Int(Val(Number$) + .5)
            If Old.Line.Number > False And Old.Line.Number <= Max.Lines Then
               For New.Line.Number = 1 To Max.Lines
                  If Renumber.List(New.Line.Number) = Old.Line.Number Then
                     Program(Line.Number) = Next.Program.Line$ + LTrim$(Str$(New.Line.Number))
                     Line.Renumbered = True
                     Exit For
                  End If
               Next
            End If
         End If
         If UCase$(Left$(Old.Program.Line$, 6)) = "RESUME" Then
            If UCase$(Left$(Old.Program.Line$, 15)) <> "RESUME PREVIOUS" Then
               If UCase$(Left$(Old.Program.Line$, 11)) <> "RESUME SAME" Then
                  If UCase$(Left$(Old.Program.Line$, 11)) <> "RESUME NEXT" Then
                     Line.Renumbered = False
                     Imbedded = InStr(UCase$(New.Program.Line$), "RESUME") + 6
                     GoSub Next.Space
                     Number$ = Mid$(Old.Program.Line$, 7)
                     Number$ = STRIM$(Number$)
                     Old.Line.Number = Int(Val(Number$) + .5)
                     If Old.Line.Number > False And Old.Line.Number <= Max.Lines Then
                        For New.Line.Number = 1 To Max.Lines
                           If Renumber.List(New.Line.Number) = Old.Line.Number Then
                              Program(Line.Number) = Next.Program.Line$ + LTrim$(Str$(New.Line.Number))
                              Line.Renumbered = True
                              Exit For
                           End If
                        Next
                     End If
                  End If
               End If
            End If
         End If
         If UCase$(Left$(Old.Program.Line$, 5)) = "GOSUB" Then
            Line.Renumbered = False
            Imbedded = InStr(UCase$(New.Program.Line$), "GOSUB") + 5
            GoSub Next.Space
            Number$ = Mid$(Old.Program.Line$, 6)
            Number$ = STRIM$(Number$)
            Old.Line.Number = Int(Val(Number$) + .5)
            If Old.Line.Number > False And Old.Line.Number <= Max.Lines Then
               For New.Line.Number = 1 To Max.Lines
                  If Renumber.List(New.Line.Number) = Old.Line.Number Then
                     Program(Line.Number) = Next.Program.Line$ + LTrim$(Str$(New.Line.Number))
                     Line.Renumbered = True
                     Exit For
                  End If
               Next
            End If
         End If
         If UCase$(Left$(Old.Program.Line$, 2)) = "ON" Then
            If UCase$(Left$(Old.Program.Line$, 8)) <> "ON ERROR" Then
               Line.Renumbered = False
               If InStr(UCase$(Old.Program.Line$), "GOTO") Then
                  Imbedded = InStr(UCase$(New.Program.Line$), "GOTO") + 4
                  Old.Number1$ = LTrim$(Mid$(New.Program.Line$, Imbedded))
                  GoSub Next.Space
                  New.Program.Line1$ = Next.Program.Line$
                  Imbedded2 = InStr(UCase$(Old.Program.Line$), "GOTO")
                  Old.Number2$ = Mid$(Old.Program.Line$, Imbedded2 + 4)
                  Do
                     Imbedded1 = InStr(Old.Number1$, ",")
                     If Imbedded1 Then
                        New.Number1$ = Left$(Old.Number1$, Imbedded1 - 1)
                        Old.Number1$ = Mid$(Old.Number1$, Imbedded1 + 1)
                     Else
                        New.Number1$ = Old.Number1$
                        Old.Number1$ = Nul
                     End If
                     If InStr(White.Space, Mid$(New.Number1$, 1, 1)) Then
                        Imbedded = 1
                        New.Program.Line$ = New.Number1$
                        GoSub Next.Space
                        New.Number1$ = Next.Program.Line$
                     Else
                        New.Number1$ = Nul
                     End If
                     Imbedded2 = InStr(Old.Number2$, ",")
                     If Imbedded2 Then
                        New.Number2$ = Left$(Old.Number2$, Imbedded2 - 1)
                        Old.Number2$ = Mid$(Old.Number2$, Imbedded2 + 1)
                     Else
                        New.Number2$ = Old.Number2$
                        Old.Number2$ = Nul
                     End If
                     Line.Renumbered = False
                     Old.Line.Number = Int(Val(New.Number2$) + .5)
                     If Old.Line.Number > False And Old.Line.Number <= Max.Lines Then
                        For New.Line.Number = 1 To Max.Lines
                           If Renumber.List(New.Line.Number) = Old.Line.Number Then
                              New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTrim$(Str$(New.Line.Number)) + ","
                              Line.Renumbered = True
                              Exit For
                           End If
                        Next
                     End If
                     If Old.Number2$ = Nul Then
                        Exit Do
                     End If
                     If Line.Renumbered = False Then
                        Exit Do
                     End If
                  Loop
                  If Right$(New.Program.Line1$, 1) = "," Then
                     New.Program.Line1$ = Left$(New.Program.Line1$, Len(New.Program.Line1$) - 1)
                  End If
                  Program(Line.Number) = New.Program.Line1$
               Else
                  If InStr(UCase$(Old.Program.Line$), "GOSUB") Then
                     Imbedded = InStr(UCase$(New.Program.Line$), "GOSUB") + 5
                     Old.Number1$ = LTrim$(Mid$(New.Program.Line$, Imbedded))
                     GoSub Next.Space
                     New.Program.Line1$ = Next.Program.Line$
                     Imbedded2 = InStr(UCase$(Old.Program.Line$), "GOSUB")
                     Old.Number2$ = Mid$(Old.Program.Line$, Imbedded2 + 5)
                     Do
                        Imbedded1 = InStr(Old.Number1$, ",")
                        If Imbedded1 Then
                           New.Number1$ = Left$(Old.Number1$, Imbedded1 - 1)
                           Old.Number1$ = Mid$(Old.Number1$, Imbedded1 + 1)
                        Else
                           New.Number1$ = Old.Number1$
                           Old.Number1$ = Nul
                        End If
                        If InStr(White.Space, Mid$(New.Number1$, 1, 1)) Then
                           Imbedded = 1
                           New.Program.Line$ = New.Number1$
                           GoSub Next.Space
                           New.Number1$ = Next.Program.Line$
                        Else
                           New.Number1$ = Nul
                        End If
                        Imbedded2 = InStr(Old.Number2$, ",")
                        If Imbedded2 Then
                           New.Number2$ = Left$(Old.Number2$, Imbedded2 - 1)
                           Old.Number2$ = Mid$(Old.Number2$, Imbedded2 + 1)
                        Else
                           New.Number2$ = Old.Number2$
                           Old.Number2$ = Nul
                        End If
                        Line.Renumbered = False
                        Old.Line.Number = Int(Val(New.Number2$) + .5)
                        If Old.Line.Number > False And Old.Line.Number <= Max.Lines Then
                           For New.Line.Number = 1 To Max.Lines
                              If Renumber.List(New.Line.Number) = Old.Line.Number Then
                                 New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTrim$(Str$(New.Line.Number)) + ","
                                 Line.Renumbered = True
                                 Exit For
                              End If
                           Next
                        End If
                        If Old.Number2$ = Nul Then
                           Exit Do
                        End If
                        If Line.Renumbered = False Then
                           Exit Do
                        End If
                     Loop
                     If Right$(New.Program.Line1$, 1) = "," Then
                        New.Program.Line1$ = Left$(New.Program.Line1$, Len(New.Program.Line1$) - 1)
                     End If
                     Program(Line.Number) = New.Program.Line1$
                  End If
               End If
            End If
         End If
         If Line.Renumbered = False Then
            Color White, Black
            Print "Error renumbering program: line"; Line.Number
            Exit Sub
         End If
      End If
   Next
   Print "Resequencing line numbers.."
   Temp.Filename$ = TempName$
   Filename = Temp.Filename$ + ".sc1"
   Call Store.Program
   Call New.Program
   Close
   2000
   Open Filename For Input As #1
   While Not EOF(1)
      Line Input #1, New.Program.Line$
      For Blanks = 1 To Len(White.Space)
         Imbedded = InStr(New.Program.Line$, Mid$(White.Space, Blanks, 1))
         If Imbedded Then
            Exit For
         End If
      Next
      Old.Line.Number = Int(Val(Left$(New.Program.Line$, Imbedded - 1)) + .5)
      For New.Program.Line = 1 To Max.Lines
         If Renumber.List(New.Program.Line) = Old.Line.Number Then
            Program(New.Program.Line) = Mid$(New.Program.Line$, Imbedded)
            Exit For
         End If
      Next
   Wend
   Close
   Kill Filename
   Filename = Prepare.Filename
   Call Store.Program
   Color Yellow, Black
   Print "Program renumbered."
   Exit Sub
   ' locates string with following white spaces
   Next.Space:
   Next.Program.Line$ = New.Program.Line$
   Do
      If Imbedded >= Len(Next.Program.Line$) Then
         Exit Do
      End If
      If InStr(White.Space, Mid$(Next.Program.Line$, Imbedded + 1, 1)) Then
         Imbedded = Imbedded + 1
      Else
         Exit Do
      End If
   Loop
   Next.Program.Line$ = Left$(Next.Program.Line$, Imbedded)
   Return
End Sub

' writes out the current .sic program to file
Sub Store.Program
   Close
   Open Filename For Output As #1
   Call Count.Lines(Last.Line)
   'Print "Write"; Last.Line; "lines. Filename: "; Filename

   For Line.Number = 1 To Last.Line
      ProgramLine$ = Program(Line.Number)
      If STRIM$(ProgramLine$) <> Nul Then
         If InStr(White.Space, Left$(ProgramLine$, 1)) Then
            'PRINT MID$(STR$(Line.Number), 2) + ProgramLine$
            Print #1, Mid$(Str$(Line.Number), 2) + ProgramLine$
         Else
            'PRINT MID$(STR$(Line.Number), 2) + " " + ProgramLine$
            Print #1, Mid$(Str$(Line.Number), 2) + " " + ProgramLine$
         End If
      End If
   Next
   Close
End Sub

' strips leading/trailing white spaces from string
Function STRIM$ (Var$)
   XVar$ = Var$
   Do
      Blanks = 0
      For Count = 1 To Len(White.Space)
         If Left$(XVar$, 1) = Mid$(White.Space, Count, 1) Then
            XVar$ = Mid$(XVar$, 2)
            Blanks = -1
         End If
      Next
      If Blanks = 0 Then
         Exit Do
      End If
   Loop
   Do
      Blanks = 0
      For Count = 1 To Len(White.Space)
         If Right$(XVar$, 1) = Mid$(White.Space, Count, 1) Then
            XVar$ = Left$(XVar$, Len(XVar$) - 1)
            Blanks = -1
         End If
      Next
      If Blanks = 0 Then
         Exit Do
      End If
   Loop
   STRIM$ = XVar$
End Function

' returns a randomized temporary filename.
' could be constructed from Date/Time.
Function TempName$
   Var$ = Nul
   For Temp = 1 To 8
      Var$ = Var$ + LTrim$(Str$(Int(Rnd * 9 + 1)))
   Next
   TempName$ = Var$
End Function

' replaces white spaces with blanks
' var = -1 skip blanks in quotes
Function TTRIM$ (Var$, Var)
   VarX$ = Var$
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Chr$(34) Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Chr$(34) Then
                  Exit Do
               End If
            Loop
         End If
      End If
      For Blanks = 1 To Len(White.Space)
         If Mid$(VarX$, Temp, 1) = Mid$(White.Space, Blanks, 1) Then
            Mid$(VarX$, Temp, 1) = " "
         End If
      Next
   Loop
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Chr$(34) Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Chr$(34) Then
                  Exit Do
               End If
            Loop
         End If
      End If
      If Mid$(VarX$, Temp, 2) = "  " Then
         VarX$ = Left$(VarX$, Temp) + Mid$(VarX$, Temp + 2)
         Temp = Temp - 1
      End If
   Loop
   TTRIM$ = VarX$
End Function

