Rem file: Whatis - Public Domain QB64 Utility. v1.2a.

Rem type: Recursive Descent Expression Parser.

Rem update v1.1a: 04/08/2025:
Rem   adds custom getCommand$ function.
Rem   modifies true/false constants.
Rem   extends array subscript for A(n) to any value.
Rem update v1.2a: 05/05/2025:
Rem   fixes shell to DOS.

' set startup declarations
DefInt A-Z
Rem $Dynamic
_Title "WHATIS"
_ScreenMove _Middle

' boolean constant declaration
$If VERSION >= 4.0.0 Then
   Const False = _FALSE
   Const True = _TRUE
   Const Quote = Chr$(34)
$Else
   Const False = 0
   Const True = Not False
   Dim Shared Quote As String * 1
   Quote = Chr$(34)
$End If

' nul constant declaration
Const Nul = ""

' maximum declarations
'  which can be changed
Const Max.Arrays = 128
Const Max.History = 10
Const Max.Recurse = 16
Const Max.FNs = 26
Const Max.FNlength = 1024

' define color values
Const Black = 0
Const Plain = 7
Const Gray = 8
Const Blue = 9
Const Green = 10
Const Cyan = 11
Const Red = 12
Const Magenta = 13
Const Yellow = 14
Const White = 15

' global variables
Dim Shared Assign As Integer
Dim Shared DataError As Integer
Dim Shared Last.Token As Integer
Dim Shared Out2 As String
Dim Shared Out3 As String
Dim Shared Out4 As String
Dim Shared Recurse As Integer
Dim Shared Strng As String
Dim Shared Token As Integer
Dim Shared Token.Index As Integer
Dim Shared Token.List As String
Dim Shared White.Space As String

' data areas
Dim Shared Arrays(0 To 26, 1) As Double ' variable arrays A() to Z()
Dim Shared Definitions(1) As String ' DEF FN functions
Dim Shared Strngs(1) As String ' string variables A$ to Z$
Dim Shared Variables(1) As Double ' variables A to Z

' multi-dimensional command history arrays
Dim Shared History.Count2(1) As Integer
Dim Shared History2(1 To 3, 1) As String * 256

' multi-dimensional command history variable
Dim Shared Temp0 As Integer

' subroutine declarations
DECLARE SUB Arith (T$, T1#, T2#)
DECLARE SUB Assignment1 (T$, T%)
DECLARE SUB Assignment2 (T$, T1%, T2%)
DECLARE SUB Enter.Equate ()
DECLARE SUB Equate (T#)
DECLARE SUB Get.Token ()
DECLARE SUB Get.Token2 (V%)
DECLARE SUB Get.Token3 ()
DECLARE SUB Get.Token4 ()
DECLARE SUB Parse.Alphabetic1 (T#)
DECLARE SUB Parse.Alphabetic2 (T#)
DECLARE SUB Parse.Alphabetic3 (T#)
DECLARE SUB Parse.Numeric (T#)
DECLARE SUB Parse.Quoted ()
DECLARE SUB Parse1 (T#)
DECLARE SUB Parse2 (T#)
DECLARE SUB Parse3 (T#)
DECLARE SUB Parse4 (T#)
DECLARE SUB Parse5 (T#)
DECLARE SUB Parse6 (T#)
DECLARE SUB Parse7 (T#)
DECLARE SUB Parse8 (T#)
DECLARE SUB Parse9 (T#)
DECLARE SUB Remove.Spaces ()

' function declarations
DECLARE FUNCTION KeyboardLine$()

' program variables
ReDim Arrays(0 To 26, 0 To Max.Arrays) As Double
ReDim Definitions(0 To Max.FNs) As String
ReDim Strngs(0 To 26) As String
ReDim Variables(0 To 26) As Double

' initialize multi-dimensional command history arrays
ReDim History2(1 To 3, 1 To Max.History) As String * 256
ReDim History.Count2(1 To 3) As Integer

' reset multi-dimensional command history arrays
For VarQ1 = 1 To 3
   History.Count2(VarQ1) = 0
   For VarQ2 = 1 To Max.History
      History2(VarQ1, VarQ2) = Nul
   Next
Next

' declare global error routine
On Error GoTo Error.Routine

' initialize some variables
Token.List = " -+*/\^()[]{}<>=|&!%~?:#@`;," + Chr$(34) ' cannot be changed
White.Space = Chr$(32) + Chr$(9) ' can be changed

' read command line
Command.Line$ = Read.Command$
Command.Line$ = LTrim$(Command.Line$)
Command.Line$ = RTrim$(Command.Line$)
If Len(Command.Line$) Then
   Out2 = Command.Line$
   Call Remove.Spaces
   Print Out2; " Equals: ";
   Recurse = 0
   Call Enter.Equate
   Error.Resume1:
   Color Plain, Black
   End
End If

' reset error flow
DataError = True


' display header
Color White, Black
Print "Whatis v1.2a: Expression parser;"
Print "Enter 'quit' to return to system."

Error.Resume2:

' keyboard input loop
StartLoop:
Do
   Color Yellow, Black
   Locate , 1, 1
   Print ">";
   Locate , , 1
   ' get input line
   Temp0 = 3
   Out2 = KeyboardLine$
   Print
   ' parse input line
   Call Remove.Spaces
   If Left$(UCase$(Out2), 5) = "SHELL" Then
      'Call ShellSub(Out2)
      Call ShellProgram
      GoTo StartLoop
   End If
   If UCase$(Out2) = "QUIT" Then
      Exit Do
   End If
   ' calculate line
   Recurse = 0
   Call Enter.Equate
Loop

' end program
Color White, Black
Print "Press <enter> to return to DOS:";
Do
   _Limit 50
   Input.Char$ = InKey$
   If Input.Char$ = Chr$(13) Then
      Exit Do
   End If
Loop
Print

' end program label
End.Whatis:

' stop program
Color Plain, Black
End

' main error routine
Error.Routine:
If DataError = False Then
   Print
End If
Error.Mode = Err
Color Red
Select Case Error.Mode
   ' standard errors.
   Case 7
      Print "Out of memory."
   Case 9
      Print "Subscript out of range."
   Case 14
      Print "Out of string space."
   Case 53
      Print "File not found."
   Case 57
      Print "Media error."
   Case 61
      Print "Disk full."
   Case 70
      Print "Permission denied."
   Case 71
      Print "Disk not ready."
      ' extended errors.
   Case 5
      Print "Error #001: Illegal function call."
   Case 6
      Print "Error #002: Overflow."
   Case 9
      Print "Error #003: Subscript out of range."
   Case 11
      Print "Error #004: Division by zero."
   Case 92
      Print "Error #005: Whatis: "; Strng
   Case 130
      Print "Error #006: Bad numeric specifier."
   Case 140
      Print "Error #007: Bad exponent specifier."
   Case 145
      Print "Error #008: Bad DEFFN declaration."
   Case 110
      Print "Error #009: Bad swap declaration."
   Case 120
      Print "Error #010: Negative square root."
   Case Else
      Print "Critical error: " + Quote + LTrim$(Str$(Error.Mode)) + Quote + " in Whatis."
      '    PRINT "Error #000: Error"; Error.Mode
End Select
Error.Exit1:
Color White
If DataError = False Then
   Resume Error.Resume1
Else
   Resume Error.Resume2
End If
End

' routine accepts an operation and performs on two values, string or numeric
Sub Arith (Token.Parsed$, Temp#, Temp2#)
   If Last.Token Then
      Select Case Token.Parsed$
         Case "-"
            Temp# = Temp# - Temp2#
         Case "+"
            Temp# = Temp# + Temp2#
         Case "/"
            Temp# = Temp# / Temp2#
         Case "\"
            Temp# = Temp# \ Temp2#
         Case "*"
            Temp# = Temp# * Temp2#
         Case "^"
            Temp# = Temp# ^ Temp2#
         Case "<"
            Temp# = (Temp# < Temp2#)
         Case ">"
            Temp# = (Temp# > Temp2#)
         Case "<<"
            Temp# = Temp# * 2#
         Case ">>"
            Temp# = Temp# \ 2#
         Case "++"
            Temp# = Temp# + 1#
         Case "--"
            Temp# = Temp# - 1#
         Case "**"
            Temp# = Temp# ^ 2#
         Case "//"
            If Temp# < 0# Then
               Error 120
            Else
               Temp# = Sqr(Temp#)
            End If
         Case "="
            Temp# = (Temp# = Temp2#)
         Case "<="
            Temp# = (Temp# <= Temp2#)
         Case ">="
            Temp# = (Temp# >= Temp2#)
         Case "<>"
            Temp# = (Temp# <> Temp2#)
         Case "|"
            Temp# = Temp# Or Temp2#
         Case "&"
            Temp# = Temp# And Temp2#
         Case "%"
            Temp# = Temp# Mod Temp2#
         Case "~"
            Temp# = Temp# Xor Temp2#
         Case "?"
            Temp# = Temp# Imp Temp2#
         Case ":"
            Temp# = Temp# Eqv Temp2#
         Case "#"
            Temp# = Not (Temp# Or Temp2#)
         Case "@"
            Temp# = Not (Temp# Imp Temp2#)
         Case "`"
            Temp# = Not (Temp# And Temp2#)
      End Select
      Exit Sub
   End If
   Select Case Token.Parsed$
      Case "-"
         If Right$(Out3, Len(Out4)) = Out4 Then
            Out3 = Left$(Out3, Len(Out3) - Len(Out4))
         End If
      Case "+"
         Out3 = Out3 + Out4
      Case "/", "\"
         If Len(Out3) > False And Len(Out4) > False Then
            Imbedded = InStr(Out3, Out4)
            While Imbedded
               Out3 = Left$(Out3, Imbedded - 1) + Mid$(Out3, Imbedded + Len(Out4))
               Imbedded = InStr(Out3, Out4)
            Wend
         End If
      Case "<"
         Last.Token = True
         Temp# = Out3 < Out4
      Case ">"
         Last.Token = True
         Temp# = Out3 > Out4
      Case "="
         Last.Token = True
         Temp# = Out3 = Out4
      Case "<="
         Last.Token = True
         Temp# = Out3 <= Out4
      Case ">="
         Last.Token = True
         Temp# = Out3 >= Out4
      Case "<>"
         Last.Token = True
         Temp# = Out3 <> Out4
   End Select
End Sub

Sub Assignment1 (S$, S%)
   If Left$(S$, 2) = "<<" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) * 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = ">>" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) \ 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "--" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) - 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "++" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) + 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "**" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Variables(S%) = Variables(S%) ^ 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "//" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         If Variables(S%) < 0# Then
            Error 120
         Else
            Variables(S%) = Sqr(Variables(S%))
         End If
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "-=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) - T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "+=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) + T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "/=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) / T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "\=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) \ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "*=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) * T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "^=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) ^ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "^-=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) ^ (-T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "^+=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) ^ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "%=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Mod T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "|=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Or T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "&=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) And T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "~=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Xor T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "?=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Imp T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = ":=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Variables(S%) Eqv T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "#=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Not (Variables(S%) Or T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "@=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Not (Variables(S%) Imp T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "`=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = Not (Variables(S%) And T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 1) = "=" Then
      Out2 = Mid$(S$, 2)
      Out2 = LTrim$(Out2)
      Call Equate(T#)
      If Last.Token = True Then
         Assign = True
         Variables(S%) = T#
      End If
      Exit Sub
   End If
End Sub

Sub Assignment2 (S$, S1%, S2%)
   If Left$(S$, 2) = "<<" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) * 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = ">>" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) \ 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "--" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) - 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "++" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) + 1#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "**" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ 2#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "//" Then
      Assign = True
      Strng = Mid$(S$, 3)
      If Strng = Nul Then
         If Arrays(S1%, S2%) < 0# Then
            Error 120
         Else
            Arrays(S1%, S2%) = Sqr(Arrays(S1%, S2%))
         End If
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "-=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) - T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "+=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) + T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "/=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) / T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "\=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) \ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "*=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) * T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "^=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "^-=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ (-T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 3) = "^+=" Then
      Out2 = Mid$(S$, 4)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "%=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Mod T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "|=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Or T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "&=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) And T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "~=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Xor T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "?=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Imp T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = ":=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Arrays(S1%, S2%) Eqv T#
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "#=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Not (Arrays(S1%, S2%) Or T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "@=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Not (Arrays(S1%, S2%) Imp T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 2) = "`=" Then
      Out2 = Mid$(S$, 3)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = Not (Arrays(S1%, S2%) And T#)
      End If
      Exit Sub
   End If
   If Left$(S$, 1) = "=" Then
      Out2 = Mid$(S$, 2)
      Out2 = LTrim$(Out2)
      Token.Index = 1
      Call Get.Token
      Call Parse1(T#)
      If Last.Token = True Then
         Assign = True
         Arrays(S1%, S2%) = T#
      End If
   End If
End Sub

' parses single letter tokens
Sub Parse.Alphabetic1 (Temp#)
   Select Case UCase$(Strng) ' test variable symbol
      Case "A" To "Z"
         Element = Asc(UCase$(Strng)) - 64
         Element.Type$ = Mid$(Out2, Token.Index, 1)
         Select Case Element.Type$
            Case "("
               Call Get.Token
               Call Get.Token
               Call Parse1(Temp#)
               If Strng = ")" Then
                  Temp# = Arrays(Element, CInt(Temp#))
                  Last.Token = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case "["
               Call Get.Token
               Call Get.Token
               Call Parse1(Temp#)
               If Strng = "]" Then
                  Temp# = Arrays(Element, CInt(Temp#))
                  Last.Token = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case "{"
               Call Get.Token
               Call Get.Token
               Call Parse1(Temp#)
               If Strng = "}" Then
                  Temp# = Arrays(Element, CInt(Temp#))
                  Last.Token = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case Else
               Temp# = Variables(Element)
               Last.Token = True
         End Select
      Case Else
         Error 92
   End Select
End Sub

' parses two-letter tokens
Sub Parse.Alphabetic2 (Temp#)
   Select Case UCase$(Strng)
      ' user defined functions
      Case "FN"
         Call ParseFN(Temp#)
      Case "FZ"
         Call ParseFZ(Temp#)
         ' functions w/o parameters
      Case "PI" ' calculate PI
         Temp# = Atn(1#) * 4#
         Last.Token = True
      Case "EX" ' calculate E
         Temp# = Exp(1#)
         Last.Token = True
         ' special case functions
      Case "OR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Or Temp#
         Call Get.Token4
         Last.Token = True
      Case Else
         If Mid$(Strng, 2, 1) = "$" Then
            Select Case Mid$(Out2, Token.Index, 1)
               Case "(", "[", "{"
                  Strng = "<bad string token>"
                  Error 92
            End Select
            Select Case UCase$(Left$(Strng, 1))
               Case "A" To "Z"
                  Element = Asc(UCase$(Left$(Strng, 1))) - 64
                  Out3 = Strngs(Element)
                  Last.Token = False
            End Select
         Else
            Error 92
         End If
   End Select
End Sub

' parses FN(<x>)
Sub ParseFN (Temp#)
   Var$ = Left$(Out2, Token.Index - 3)
   Call Get.Token3
   Call Get.Token
   Call Parse1(Temp4#)
   Call Get.Token4
   Func% = CInt(Temp4#)
   If Func% >= 1 And Func% <= Max.FNs Then
      Var2$ = Mid$(Out2, Token.Index)
      Out2 = Definitions(Func%)
      Out2 = LTrim$(Out2)
      ' test for nul token
      If Out2 = Nul Then
         Strng = "<bad FN token>"
         Error 92
      End If
      ' count recursing calls
      Recurse = Recurse + 1
      If Recurse > Max.Recurse Then
         Strng = "<bad FN recurse>"
         Error 92
      End If
      ' recursively call functions
      Token.Index = 1
      Call Get.Token
      Call Parse1(Temp#)
      ' test huge recursed FN
      If Len(Var$) + Len(Var2$) >= Max.FNlength Then
         Var$ = Nul
         Var2$ = Nul
         Strng = "<bad FN string>"
         Error 92
      End If
      Out2 = Var$ + Var2$
      Token.Index = Len(Var$) + 1
      Exit Sub
   End If
   Strng = "<bad FN range>"
   Error 92
End Sub

' parses FZ(<x>)
Sub ParseFZ (Temp#)
   Call Get.Token3
   Call Get.Token
   Call Parse1(Temp#)
   Call Get.Token4
   Func% = CInt(Temp#)
   If Func% >= 1 And Func% <= Max.FNs Then
      Out3 = Definitions(Func%)
      Out3 = LTrim$(Out3)
      Out3 = RTrim$(Out3)
      If Out3 = Nul Then
         Strng = "<bad FZ token>"
         Error 92
      End If
      Last.Token = False
      Exit Sub
   End If
   Strng = "<bad FZ range>"
   Error 92
End Sub

' parses three and greater letter tokens
Sub Parse.Alphabetic3 (Temp#)
   Select Case UCase$(Strng)
      ' constant functions
      Case "LBOUND"
         Temp# = 1
         Last.Token = True
      Case "UBOUND"
         Temp# = UBound(Arrays, 2)
         Last.Token = True
      Case "QUOTE$"
         Out3 = Quote
         Last.Token = False
      Case "COMSPEC$"
         Out3 = Environ$("COMSPEC")
         Last.Token = False
      Case "COMMAND$"
         Out3 = Read.Command$
         Last.Token = False
      Case "AUTHOR$"
         Out3 = "Erik Jon Oredson"
         Last.Token = False
      Case "EMAIL$"
         Out3 = "eoredson@gmail.com"
         Last.Token = False
      Case "URL$"
         Out3 = "http://www.applewoodbbs.linkpc.net/files"
         Last.Token = False
      Case "VERSION$"
         Out3 = "1.1a"
         Last.Token = False
      Case "RELEASE$"
         Out3 = "1.0.2"
         Last.Token = False
      Case "PROGRAM$"
         Out3 = "whatis"
         Last.Token = False
      Case "PUBLISH$"
         Out3 = "05/08/2025"
         Last.Token = False
      Case "COOKIE$"
         Out3 = "Thank you for all the cookies!"
         Last.Token = False
      Case "ERROR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Error CInt(Temp#)
         Call Get.Token4
         Last.Token = True
         ' functions w/o parameters
      Case "FALSE"
         Temp# = False
         Last.Token = True
      Case "TRUE"
         Temp# = True
         Last.Token = True
      Case "TIMER"
         Temp# = Timer
         Last.Token = True
      Case "RND"
         Temp# = Rnd
         Last.Token = True
         ' boolean functions
      Case "AND"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# And Temp#
         Call Get.Token4
         Last.Token = True
      Case "MOD"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Mod Temp#
         Call Get.Token4
         Last.Token = True
      Case "NOR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Not (Number# Or Temp#)
         Call Get.Token4
         Last.Token = True
      Case "NON"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Not (Number# Imp Temp#)
         Call Get.Token4
         Last.Token = True
      Case "XAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Not (Number# And Temp#)
         Call Get.Token4
         Last.Token = True
      Case "XOR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Xor Temp#
         Call Get.Token4
         Last.Token = True
      Case "IMP"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Imp Temp#
         Call Get.Token4
         Last.Token = True
      Case "EQV"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# Eqv Temp#
         Call Get.Token4
         Last.Token = True
      Case "NOT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Not Temp#
         Call Get.Token4
         Last.Token = True
         ' third-order boolean
      Case "TAND"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         Call Get.Token4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# And Number2#
                     Last.Token = True
                     Exit Sub
               End Select
         End Select
         Error 5
      Case "TOR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         Call Get.Token4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# Or Number2#
                     Last.Token = True
                     Exit Sub
               End Select
         End Select
         Error 5
      Case "TXOR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         Call Get.Token4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# Xor Number2#
                     Last.Token = True
                     Exit Sub
               End Select
         End Select
         Error 5
         ' date\time functions
      Case "CLOCK"
         Temp# = Timer
         Last.Token = True
      Case "DATE$"
         Out3 = Date$
         Last.Token = False
      Case "TIME$"
         Out3 = Time$
         Last.Token = False
         ' conversion/calculation functions
      Case "BIN$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Nul
         If Temp# >= False Then
            Digits = False
            Do
               If 2 ^ (Digits + 1) > Temp# Then
                  Exit Do
               End If
               Digits = Digits + 1
            Loop
            For Power = Digits To 0 Step -1
               If Temp# - 2 ^ Power >= 0 Then
                  Temp# = Temp# - 2 ^ Power
                  Out3 = Out3 + "1"
               Else
                  Out3 = Out3 + "0"
               End If
            Next
         End If
         Call Get.Token4
         Last.Token = False
      Case "CHR$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Chr$(CInt(Temp#))
         Call Get.Token4
         Last.Token = False
      Case "HEX$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Hex$(Temp#)
         Call Get.Token4
         Last.Token = False
      Case "OCT$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Oct$(Temp#)
         Call Get.Token4
         Last.Token = False
      Case "STR$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Str$(Temp#)
         Call Get.Token4
         Last.Token = False
      Case "LCASE$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = LCase$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "UCASE$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = UCase$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "RTRIM$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = RTrim$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "LTRIM$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = LTrim$(Out3)
         Call Get.Token4
         Last.Token = False
      Case "TRIM$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = LTrim$(RTrim$(Out3))
         Call Get.Token4
         Last.Token = False
      Case "SPACE$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = String$(Temp#, 32)
         Call Get.Token4
         Last.Token = False
      Case "MID$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token
         Call Parse1(Temp#)
         Temp4# = Temp#
         If Strng = "," Then
            Call Get.Token
            Call Parse1(Temp#)
            Length# = Temp#
            Out3 = Mid$(Out3, Temp4#, Length#)
         Else
            Out3 = Mid$(Out3, Temp4#)
         End If
         Call Get.Token4
         Last.Token = False
      Case "REMID$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token
         Call Parse1(Temp#)
         Start# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Length# = Temp#
         Out3 = Left$(Out3, Start# - 1) + Mid$(Out3, Start# + Length#)
         Call Get.Token4
         Last.Token = False
      Case "DEMID$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         String1$ = Out3
         Call Get.Token
         Call Parse1(Temp#)
         If Len(String1$) And Len(Out3) Then
            Imbedded = InStr(String1$, Out3)
            While Imbedded
               String1$ = Left$(String1$, Imbedded - 1) + Mid$(String1$, Imbedded + Len(Out3))
               Imbedded = InStr(String1$, Out3)
            Wend
         End If
         Out3 = String1$
         Call Get.Token4
         Last.Token = False
      Case "REPLACE$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         String1$ = Out3
         Call Get.Token
         Call Parse1(Temp#)
         String2$ = Out3
         Call Get.Token
         Call Parse1(Temp#)
         String3$ = Out3
         If String1$ = Nul Or String2$ = Nul Or String2$ = String3$ Then
            Out3 = String1$
            Exit Sub
         End If
         Temp1 = 1
         Do
            If String1$ = Nul Then
               Exit Do
            End If
            Var1 = InStr(Temp1, String1$, String2$)
            If Var1 = False Then
               Exit Do
            End If
            String1$ = Left$(String1$, Var1 - 1) + String3$ + Mid$(String1$, Var1 + Len(String2$))
            Temp1 = Temp1 + Len(String3$)
         Loop
         Out3 = String1$
         Call Get.Token4
         Last.Token = False
      Case "LEFT$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Left$(Out3, Temp#)
         Call Get.Token4
         Last.Token = False
      Case "RIGHT$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token
         Call Parse1(Temp#)
         Out3 = Right$(Out3, Temp#)
         Call Get.Token4
         Last.Token = False
      Case "STRING$"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Out3 = String$(Number#, Temp#)
         Else
            Out3 = String$(Number#, Out3)
         End If
         Call Get.Token4
         Last.Token = False
      Case "ABS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Abs(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "ASC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Asc(Out3)
         Call Get.Token4
         Last.Token = True
      Case "EXP"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Exp(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "FBN" ' calculate xth fibonachi value
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Fibo.A# = 1
         Fibo.B# = 1
         If Temp# >= 1 Then
            For Fibo.Number# = 1 To Temp# - 1
               Fibo.Temp# = Fibo.B#
               Fibo.B# = Fibo.A# + Fibo.B#
               Fibo.A# = Fibo.Temp#
            Next
         End If
         Temp# = Fibo.B#
         Call Get.Token4
         Last.Token = True
      Case "FCT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Factorial# = 1
         Factorial.Count# = Int(Temp#)
         If Factorial.Count# >= 1 Then
            For Factorial.Count# = 1 To Temp#
               Factorial# = Factorial# * Factorial.Count#
            Next
         End If
         Temp# = Factorial#
         Call Get.Token4
         Last.Token = True
      Case "FIX"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Fix(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "INSTR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Last.Token Then
            Start# = Temp#
            Call Get.Token
            Call Parse1(Temp#)
            Stored.String$ = Out3
            Call Get.Token
            Call Parse1(Temp#)
         Else
            Start# = 1#
            Stored.String$ = Out3
            Call Get.Token
            Call Parse1(Temp#)
         End If
         Temp# = InStr(Start#, Stored.String$, Out3)
         Call Get.Token4
         Last.Token = True
      Case "INT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Int(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "LEN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Len(Out3)
         Call Get.Token4
         Last.Token = True
      Case "LOG"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "ISEVEN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Temp# Mod 2#) = 0
         Call Get.Token4
         Last.Token = True
      Case "ISODD"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Temp# Mod 2#) = 1
         Call Get.Token4
         Last.Token = True
      Case "ISPRM" ' calculate x is prime
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Prime# = Int(Temp#)
         Prime.Flag = True
         If Prime# > 2# Then
            For Loop.Count# = 2# To Int(Sqr(Prime#))
               If Prime# / Loop.Count# = Int(Prime# / Loop.Count#) Then
                  Prime.Flag = False
                  Exit For
               End If
            Next
         End If
         If Prime.Flag = False Then
            Temp# = False
         Else
            Temp# = True
         End If
         Call Get.Token4
         Last.Token = True
      Case "PRF" ' calculate xth perfect number
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Call Get.Token4
         Last.Token = True
         Perfect# = Int(Temp#)
         Select Case Perfect#
            Case 1#
               X# = 1#
            Case 2#
               X# = 2#
            Case 3#
               X# = 4#
            Case 4#
               X# = 6#
            Case 5#
               X# = 12#
            Case 6#
               X# = 16#
            Case 7#
               X# = 18#
               'CASE 8# ' overflows beyond double precision
               '  X# = 30#
            Case Else
               Error 130
         End Select
         ' equation for perfect number
         Temp# = 2 ^ X# * (2 ^ (X# + 1) - 1)
         Last.Token = True
      Case "PRM" ' calculate xth prime
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Prime.Number# = Int(Temp#)
         Prime# = 1
         If Prime.Number# > False Then
            Prime.Counter# = False
            Do
               Prime# = Prime# + 1
               Prime.Flag = False
               For Factor# = 2# To Int(Sqr(Prime#))
                  If Prime# / Factor# = Int(Prime# / Factor#) Then
                     Prime.Flag = True
                     Exit For
                  End If
               Next
               If Prime.Flag = False Then
                  Prime.Counter# = Prime.Counter# + 1
               End If
               If Prime.Counter# = Prime.Number# Then
                  Exit Do
               End If
            Loop
         End If
         Temp# = Prime#
         Call Get.Token4
         Last.Token = True
      Case "SGN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Sgn(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "SQR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         If Temp# < 0# Then
            Error 120
         Else
            Temp# = Sqr(Temp#)
         End If
         Call Get.Token4
         Last.Token = True
      Case "CBR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Temp# ^ (1# / 3#)
         Call Get.Token4
         Last.Token = True
      Case "GCM"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         ' find last factor which divides into both numbers
         Factor1# = 1
         Number3# = Number1#
         For Factor2# = 2 To Number1#
            Do
               If Number3# / Factor2# = Number3# \ Factor2# Then
                  If Number2# / Factor2# = Number2# \ Factor2# Then
                     If Factor2# > Factor1# Then
                        Factor1# = Factor2#
                     End If
                  End If
                  Number3# = Number3# / Factor2#
               Else
                  Exit Do
               End If
            Loop
         Next
         Temp# = Factor1#
         Call Get.Token4
         Last.Token = True
      Case "LCD"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number1# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Number2# = Temp#
         ' find first factor which divides into both numbers
         Factor1# = 0
         For Factor2# = 2 To Number1#
            If Number1# / Factor2# = Number1# \ Factor2# Then
               If Number2# / Factor2# = Number2# \ Factor2# Then
                  Factor1# = Factor2#
                  Exit For
               End If
            End If
         Next
         If Factor1# = 0# Then
            Factor1# = 1#
         End If
         If Factor1# = Number2# Then
            Factor1# = 1#
         End If
         Temp# = Factor1#
         Call Get.Token4
         Last.Token = True
      Case "NTH"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# ^ (1# / Temp#)
         Call Get.Token4
         Last.Token = True
      Case "PWR"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Number# ^ Temp#
         Call Get.Token4
         Last.Token = True
      Case "VAL"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Val(Out3)
         Call Get.Token4
         Last.Token = True

         Rem Basic trigonometric functions..

      Case "ATN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "COS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Cos(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "COT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Cos(Temp#) / Sin(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "CSC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = 1# / Sin(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "SEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = 1# / Cos(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "SIN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Sin(Temp#)
         Call Get.Token4
         Last.Token = True
      Case "TAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Tan(Temp#)
         Call Get.Token4
         Last.Token = True

         Rem Remaining nonintrinsic trigonmetric functions..

         'Inverse Cosine
      Case "ARCCOS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(-Temp# / Sqr(-Temp# * Temp# + 1)) + 2 * Atn(1)
         Call Get.Token4
         Last.Token = True
         'Inverse Cosecant
      Case "ARCCOSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(Temp# * Temp# - 1)) + (Sgn(Temp#) - 1) * (2 * Atn(1))
         Call Get.Token4
         Last.Token = True
         'Inverse Cotangent
      Case "ARCCOTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp#) + 2 * Atn(1)
         Call Get.Token4
         Last.Token = True
         'Inverse Secant
      Case "ARCSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(Temp# * Temp# - 1)) + Sgn((Temp#) - 1) * (2 * Atn(1))
         Call Get.Token4
         Last.Token = True
         'Inverse Sine
      Case "ARCSIN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(-Temp# * Temp# + 1))
         Call Get.Token4
         Last.Token = True
         'Convert Degrees to Radians
      Case "DEGTORAD"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = ((Atn(1) * 4) / 180) * Temp#
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Cosine
      Case "HARCCOS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log(Temp# + Sqr(Temp# * Temp# - 1))
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Cosecant
      Case "HARCCOSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log((Sgn(Temp#) * Sqr(Temp# * Temp# + 1) + 1) / Temp#)
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Cotangent
      Case "HARCCOTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log((Temp# + 1) / (Temp# - 1)) / 2
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Secant
      Case "HARCSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log((Sqr(-Temp# * Temp# + 1) + 1) / Temp#)
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Sine
      Case "HARCSIN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log(Temp# + Sqr(Temp# * Temp# + 1))
         Call Get.Token4
         Last.Token = True
         'Inverse Hyperbolic Tangent
      Case "HARCTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Log((1 + Temp#) / (1 - Temp#)) / 2
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Cosine
      Case "HCOS"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) + Exp(-Temp#)) / 2
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Cosecant
      Case "HCOSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = 2 / (Exp(Temp#) - Exp(-Temp#))
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Cotangent
      Case "HCOTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) + Exp(-Temp#)) / (Exp(Temp#) - Exp(-Temp#))
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Secant
      Case "HSEC"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = 2 / (Exp(Temp#) + Exp(-Temp#))
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Sine
      Case "HSIN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) - Exp(-Temp#)) / 2
         Call Get.Token4
         Last.Token = True
         'Hyperbolic Tangent
      Case "HTAN"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) - Exp(-Temp#)) / (Exp(Temp#) + Exp(-Temp#))
         Call Get.Token4
         Last.Token = True
         'Convert Radians to Degrees
      Case "RADTODEG"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = (180 / (Atn(1) * 4)) * Temp#
         Call Get.Token4
         Last.Token = True
         ' Hypotenuse
      Case "HYPOT"
         Call Get.Token3
         Call Get.Token
         Call Parse1(Temp#)
         Number# = Temp#
         Call Get.Token
         Call Parse1(Temp#)
         Temp# = Sqr(Number# * Number# + Temp# * Temp#)
         Call Get.Token4
         Last.Token = True
      Case Else
         Error 92
   End Select
End Sub

' uses direct keyboard input to get an input line
'   and edit multi-dimensional command history arrays with line-wrapping,
'     where Temp0 (history array type) equals:
'       1=<n/a>
'       2=<n/a>
'       3=whatis prompt

Function KeyboardLine$
   Const TabStop = 8
   History.Count2(Temp0) = 0 ' reset
   Var$ = Nul
   Do
      _Limit 50
      Var2$ = InKey$ ' get character
      Select Case Len(Var2$)
         Case 0
            Eat$ = Nul
         Case 1
            Select Case Var2$
               Case Chr$(9) ' tab
                  If Len(Var$) + TabStop <= 256 Then
                     For VarX = 1 To TabStop
                        Print " ";
                        Locate , , 1
                        Var$ = Var$ + " "
                     Next
                  End If
               Case Chr$(13) ' return
                  GoSub Enter.History
                  Exit Do
               Case Chr$(8) ' backspace
                  If Len(Var$) > 0 Then
                     Var$ = Left$(Var$, Len(Var$) - 1)
                     GoSub Back.Space
                  End If
               Case Chr$(27) ' escape
                  GoSub Erase.Line
               Case Else ' store input
                  If Len(Var$) < 256 Then
                     Print Var2$;
                     Locate , , Visible
                     Var$ = Var$ + Var2$
                  End If
            End Select
         Case 2
            Select Case Asc(Right$(Var2$, 1))
               Case 77 ' right
                  GoSub Get.Count
                  If Var1 > 0 Then
                     Select Case History.Count2(Temp0)
                        Case 0
                           GoSub Erase.Line
                           History.Count2(Temp0) = Var1
                           Var$ = RTrim$(History2(Temp0, Var1))
                           Print Var$;
                        Case 1 To Max.History - 1
                           If History.Count2(Temp0) + 1 <= Var1 Then
                              GoSub Erase.Line
                              History.Count2(Temp0) = History.Count2(Temp0) + 1
                              Var$ = RTrim$(History2(Temp0, History.Count2(Temp0)))
                              Print Var$;
                           Else
                              If History.Count2(Temp0) = Var1 Then
                                 GoSub Erase.Line
                                 Var$ = RTrim$(History2(Temp0, Var1))
                                 Print Var$;
                              End If
                           End If
                        Case Max.History
                           GoSub Erase.Line
                           Var$ = RTrim$(History2(Temp0, Max.History))
                           Print Var$;
                     End Select
                  End If
               Case 75 ' left
                  GoSub Get.Count
                  If Var1 > 0 Then
                     Select Case History.Count2(Temp0)
                        Case 0
                           GoSub Erase.Line
                           History.Count2(Temp0) = Var1
                           Var$ = RTrim$(History2(Temp0, Var1))
                           Print Var$;
                        Case 1
                           GoSub Erase.Line
                           Var$ = RTrim$(History2(Temp0, 1))
                           Print Var$;
                        Case Else
                           If History.Count2(Temp0) - 1 > 0 Then
                              GoSub Erase.Line
                              History.Count2(Temp0) = History.Count2(Temp0) - 1
                              Var$ = RTrim$(History2(Temp0, History.Count2(Temp0)))
                              Print Var$;
                           End If
                     End Select
                  End If
               Case 71 ' home
                  GoSub Get.Count
                  If Var1 > 0 Then
                     GoSub Erase.Line
                     History.Count2(Temp0) = 1
                     Var$ = RTrim$(History2(Temp0, 1))
                     Print Var$;
                  End If
               Case 79 ' end
                  GoSub Get.Count
                  If Var1 > 0 Then
                     GoSub Erase.Line
                     History.Count2(Temp0) = Var1
                     Var$ = RTrim$(History2(Temp0, Var1))
                     Print Var$;
                  End If
            End Select
      End Select
      Locate , , 1
   Loop

   ' return input line
   KeyboardLine$ = Var$
   Exit Function

   Enter.History:
   If Len(Var$) Then
      GoSub Get.Count
      ' init
      If Var1 = 0 Then
         History.Count2(Temp0) = 1
         History2(Temp0, 1) = Var$
      Else
         ' add history
         If History.Count2(Temp0) = 0 Then
            If Var1 < Max.History Then
               History.Count2(Temp0) = Var1 + 1
               History2(Temp0, Var1 + 1) = Var$
            Else
               For Var = 1 To Max.History - 1
                  History2(Temp0, Var) = History2(Temp0, Var + 1)
               Next
               History.Count2(Temp0) = Max.History
               History2(Temp0, Max.History) = Var$
            End If
         Else
            ' pack history
            If Var1 = Max.History Then
               For Var = History.Count2(Temp0) To Max.History - 1
                  History2(Temp0, Var) = History2(Temp0, Var + 1)
               Next
               History.Count2(Temp0) = Max.History
               History2(Temp0, Max.History) = Var$
            Else
               For Var = History.Count2(Temp0) To Var1 - 1
                  History2(Temp0, Var) = History2(Temp0, Var + 1)
               Next
               History2(Temp0, Var1) = Var$
            End If
         End If
      End If
   End If
   Return

   Erase.Line:
   For VarX = 1 To Len(Var$)
      GoSub Back.Space
   Next
   Var$ = Nul
   Return

   Back.Space:
   If Pos(0) > 1 Then ' check cursor location
      Locate CsrLin, Pos(0) - 1, 0
      Print " ";
      Locate CsrLin, Pos(0) - 1, 1
   Else ' line-wrap
      Locate CsrLin - 1, 80, 0
      Print " ";
      Locate CsrLin - 1, 80, 1
   End If
   Return

   Get.Count:
   Var1 = 0
   For Var2 = Max.History To 1 Step -1
      If RTrim$(History2(Temp0, Var2)) <> Nul Then
         Var1 = Var2
         Exit For
      End If
   Next
   Return
End Function

' beginning of the command/equation parser
Sub Enter.Equate
   Strng = Nul
   Out2 = LTrim$(Out2)
   If Out2 = Nul Then
      Exit Sub
   End If
   Store.Input$ = Out2
   Assign = False
   GoSub Assignment
   If Assign Then
      Exit Sub
   End If
   Out2 = Store.Input$
   D$ = UCase$(Out2)
   If Left$(D$, 4) = "SWAP" Then
      Call SwapData
      If Assign Then
         Exit Sub
      End If
   End If
   If Left$(D$, 3) = "MID" Then
      GoSub Assign.Mid.String
      If Assign Then
         Exit Sub
      End If
   End If
   If Left$(D$, 4) = "LEFT" Then
      GoSub Assign.Left.String
      If Assign Then
         Exit Sub
      End If
   End If
   If Left$(D$, 5) = "RIGHT" Then
      GoSub Assign.Right.String
      If Assign Then
         Exit Sub
      End If
   End If
   If Left$(D$, 5) = "DEFFN" Then
      GoSub Define.Function
      If Assign Then
         Exit Sub
      End If
   End If
   Out2 = Store.Input$
   Last.Token = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   Token.Index = 1
   Call Get.Token
   Call Parse1(T#)

   ' parse leftover tokens
   While Len(Strng)
      Call Parse1(X#)
      ' toss away any unwanted tokens
      If Last.Token = 3 Then
         Strng = "<extra token>"
         Error 92
      End If
   Wend

   ' display output result
   If Last.Token = False Then
      Print Out3
   Else
      Print LTrim$(Str$(T#))
   End If
   Exit Sub

   Assignment:
   Assign = False
   Temp1$ = UCase$(Left$(Out2, 1))
   If Temp1$ = "?" Then
      Temp1$ = Mid$(Out2, 2)
      Temp2$ = Left$(Temp1$, 1)
      If Temp2$ = "=" Then
         Temp1$ = Mid$(Temp1$, 2)
         Out2 = Temp1$
         Call Equate(Temp4#)
         Assign = True
         Exit Sub
      End If
   End If
   If Temp1$ >= "A" And Temp1$ <= "Z" Then
      Variable = Asc(Temp1$) - 64
      Temp1$ = Mid$(Out2, 2)
      Temp1$ = LTrim$(Temp1$)
      Call Assignment1(Temp1$, Variable)
      If Assign Then
         GoSub Assign.End
         Return
      End If
      If Left$(Temp1$, 1) = "$" Then
         Temp1$ = Mid$(Temp1$, 2)
         Temp1$ = LTrim$(Temp1$)
         If Left$(Temp1$, 1) = "(" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "[" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "{" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "=" Then
            Out2 = Mid$(Temp1$, 2)
            Out2 = LTrim$(Out2)
            Token.Index = 1
            Call Get.Token
            Call Parse1(Temp3#)
            If Last.Token = False Then
               Strngs(Variable) = Out3
               Assign = True
               GoSub Assign.End
               Return
            End If
         End If
      End If
      If Left$(Temp1$, 1) = "(" Then
         Out2 = Mid$(Temp1$, 2)
         Out2 = LTrim$(Out2)
         Last.Token = False
         Token.Index = 1
         Call Get.Token
         Call Parse1(Temp3#)
         If Last.Token = True Then
            Element = CInt(Temp3#)
            Temp1$ = Mid$(Out2, Token.Index)
            Temp1$ = LTrim$(Temp1$)
            V = UBound(Arrays, 2)
            If Element > V Then
               ReDim _Preserve Arrays(26, Element) As Double
            End If
            Call Assignment2(Temp1$, Variable, Element)
            If Assign Then
               GoSub Assign.End
               Return
            End If
         End If
      End If
   End If
   Return

   Assign.Mid.String:
   Out2 = Mid$(Out2, 4)
   If Len(Out2) Then
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" Then
         Variable = Asc(V$) - 64
         If Mid$(Out2, 2, 1) = "$" Then
            Out2 = Mid$(Out2, 4)
            Last.Token = False
            Token.Index = 1
            Call Get.Token
            Call Parse1(T#)
            Start = CInt(T#)
            If Strng = "," Then
               Call Get.Token
               Call Parse1(T#)
               Length = CInt(T#)
               Out2 = Mid$(Out2, Token.Index)
               Out2 = LTrim$(Out2)
               If Left$(Out2, 1) = "=" Then
                  Out2 = Mid$(Out2, 2)
                  Out2 = LTrim$(Out2)
                  Token.Index = 1
                  Call Get.Token
                  Call Parse1(T#)
                  If Last.Token = False Then
                     Assign = True
                     If Strngs(Variable) = Nul Then
                        If Start = 1 Then
                           If Len(Out3) = Length Then
                              Strngs(Variable) = Out3
                              GoSub Assign.End
                              Return
                           End If
                        End If
                        Strng = "<bad string>"
                        Error 92
                        Return
                     End If
                     Mid$(Strngs(Variable), Start, Length) = Out3
                     GoSub Assign.End
                     Return
                  End If
               End If
            End If
         End If
      End If
   End If
   Return

   Assign.Left.String:
   Out2 = Mid$(Out2, 5)
   If Len(Out2) Then
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" Then
         Variable = Asc(V$) - 64
         If Mid$(Out2, 2, 1) = "$" Then
            Out2 = Mid$(Out2, 4)
            Last.Token = False
            Token.Index = 1
            Call Get.Token
            Call Parse1(T#)
            Start = CInt(T#)
            Out2 = Mid$(Out2, Token.Index)
            Out2 = LTrim$(Out2)
            If Left$(Out2, 1) = "=" Then
               Assign = True
               Out2 = Mid$(Out2, 2)
               Out2 = LTrim$(Out2)
               Token.Index = 1
               Call Get.Token
               Call Parse1(T#)
               If Last.Token = False Then
                  Assign = True
                  If Strngs(Variable) = Nul Then
                     If Len(Out3) = Start Then
                        Strngs(Variable) = Out3
                        GoSub Assign.End
                        Return
                     End If
                     Strng = "<bad string>"
                     Error 92
                     Return
                  End If
                  Mid$(Strngs(Variable), 1, Start) = Out3
                  GoSub Assign.End
                  Return
               End If
            End If
         End If
      End If
   End If
   Return

   Assign.Right.String:
   Out2 = Mid$(Out2, 6)
   If Len(Out2) Then
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" Then
         Variable = Asc(V$) - 64
         If Mid$(Out2, 2, 1) = "$" Then
            Out2 = Mid$(Out2, 4)
            Last.Token = False
            Token.Index = 1
            Call Get.Token
            Call Parse1(T#)
            Start = CInt(T#)
            Out2 = Mid$(Out2, Token.Index)
            Out2 = LTrim$(Out2)
            If Left$(Out2, 1) = "=" Then
               Assign = True
               Out2 = Mid$(Out2, 2)
               Out2 = LTrim$(Out2)
               Token.Index = 1
               Call Get.Token
               Call Parse1(T#)
               Length = Len(Strngs(Variable)) - Start + 1
               If Last.Token = False Then
                  Assign = True
                  If Length > False Then
                     Mid$(Strngs(Variable), Length, Start) = Out3
                     GoSub Assign.End
                     Return
                  Else
                     If Strngs(Variable) = Nul Then
                        If Len(Out3) = Start Then
                           Strngs(Variable) = Out3
                           GoSub Assign.End
                           Return
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   Return

   Assign.End:
   If Len(Strng) Then
      Call Parse1(X#)
      Strng = "<extra token>"
      Error 92
   End If
   Return

   Define.Function:
   Out2 = Mid$(Out2, 6)
   Out2 = LTrim$(Out2)
   Token.Index = 1
   Call Get.Token3
   Call Get.Token
   Call Parse1(Temp4#)
   Call Get.Token4
   Func% = CInt(Temp4#)
   If Func% >= 1 And Func% <= Max.FNs Then
      Out2 = Mid$(Out2, Token.Index)
      Out2 = LTrim$(Out2)
      If Left$(Out2, 1) = "=" Then
         Out2 = Mid$(Out2, 2)
         Definitions(Func%) = Out2
         Assign = True
         Return
      End If
   End If
   Error 145
End Sub

' returns next token in string form,
' increments pointer to next token,
' determines token type.
Sub Get.Token
   Strng = Nul ' reset token
   Token = False ' reset token type
   ' locate symbols
   Call Get.Token2(Token.Exists)
   If Token.Exists Then
      Exit Sub
   End If
   If Token.Index > Len(Out2) Then
      Strng = Nul
      Token = False
      Token.Index = Token.Index + 1
      Exit Sub
   End If
   ' locate expression symbol
   Token.Element$ = Mid$(Out2, Token.Index, 1)
   If InStr(Token.List, Token.Element$) Then
      Token = 1 ' store token type
      Strng = Token.Element$ ' store token
      Token.Index = Token.Index + 1 ' increment pointer
      Exit Sub
   End If
   ' locate expression is number
   Token.Element$ = Mid$(Out2, Token.Index, 1)
   If Token.Element$ >= "0" And Token.Element$ <= "9" Then
      ' increment token until token is other than number
      Do
         If Len(Token.Element$) = False Then
            Exit Do
         End If
         If InStr(Token.List, Token.Element$) Then
            Exit Do
         End If
         Strng = Strng + Token.Element$
         Token.Index = Token.Index + 1
         Token.Element$ = Mid$(Out2, Token.Index, 1)
      Loop
      Token = 2 ' store token type
      Exit Sub
   End If
   ' locate expression is number beginning with decimal
   Token.Element$ = Mid$(Out2, Token.Index, 1)
   If Token.Element$ = "." Then
      ' increment token until token is other than number
      Do
         If Len(Token.Element$) = False Then
            Exit Do
         End If
         If InStr(Token.List, Token.Element$) Then
            Exit Do
         End If
         Strng = Strng + Token.Element$
         Token.Index = Token.Index + 1
         Token.Element$ = Mid$(Out2, Token.Index, 1)
      Loop
      Token = 2 ' store token type
      Exit Sub
   End If
   ' locate expression is alphabetic
   Token.Element$ = UCase$(Mid$(Out2, Token.Index, 1))
   If Token.Element$ >= "A" And Token.Element$ <= "Z" Then
      ' increment token until token is other than alphabetic
      Do
         If Len(Token.Element$) = False Then
            Exit Do
         End If
         If InStr(Token.List, Token.Element$) Then
            Exit Do
         End If
         Strng = Strng + Token.Element$
         Token.Index = Token.Index + 1
         Token.Element$ = UCase$(Mid$(Out2, Token.Index, 1))
      Loop
      Token = 3 ' store token type
      Exit Sub
   End If
   Token = False
   Strng = Token.Element$
   Token.Index = Token.Index + 1
End Sub

' gets two-symbol tokens,
' increments pointer to next token.
Sub Get.Token2 (Token.Exists)
   Token.Exists = False
   Stored.Token$ = Out2
   ' locate expression symbols
   Next.Token$ = Mid$(Stored.Token$, Token.Index, 2)
   Select Case Next.Token$
      Case "<<"
         Token = 1 ' store token type
         Strng = "<<" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case ">>"
         Token = 1 ' store token type
         Strng = ">>" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "--"
         Token = 1 ' store token type
         Strng = "--" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "++"
         Token = 1 ' store token type
         Strng = "++" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "**"
         Token = 1 ' store token type
         Strng = "**" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "//"
         Token = 1 ' store token type
         Strng = "//" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case ">=", "=>"
         Token = 1 ' store token type
         Strng = ">=" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "<=", "=<"
         Token = 1 ' store token type
         Strng = "<=" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
      Case "<>", "><"
         Token = 1 ' store token type
         Strng = "<>" ' store token
         Token.Index = Token.Index + 2 ' increment pointer
         Token.Exists = True
   End Select
End Sub

' verifies next token is opening parenthesis.
Sub Get.Token3
   Strng = Nul
   Token = False
   If Token.Index > Len(Out2) Then
      Strng = "<missing opening parenthesis>"
      Error 92
   End If
   ' locate parenthesis symbol
   Token.Element$ = Mid$(Out2, Token.Index, 1)
   If Token.Element$ = "(" Then
      Token = 1 ' store token type
      Strng = Token.Element$ ' store token
      Token.Index = Token.Index + 1 ' increment pointer
      Exit Sub
   End If
   Strng = "<missing opening parenthesis>"
   Error 92
End Sub

' verifies last token is closing parenthesis.
Sub Get.Token4
   ' locate parenthesis symbol
   If Strng = ")" Then
      Exit Sub
   End If
   Strng = "<missing closing parenthesis>"
   Error 92
End Sub

' process a number
Sub Parse.Numeric (Temp#)
   Select Case Right$(UCase$(Strng), 1) ' compare character after number
      Case "Q" ' perfect number suffix
         For Digit = 1 To Len(Strng) - 1
            OutX$ = UCase$(Mid$(Strng, Digit, 1))
            Select Case OutX$
               Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                  ' nul
               Case Else
                  Error 130
            End Select
         Next
         Temp# = CDbl(Val(Left$(Strng, Len(Strng) - 1)))
         Perfect# = 0#
         Perfect.Number# = Int(Temp#)
         If Abs(Perfect.Number#) > 7# Then
            Error 130
         End If
         If Perfect.Number# > False Then
            Select Case Perfect.Number#
               Case 1#
                  X# = 1#
               Case 2#
                  X# = 2#
               Case 3#
                  X# = 4#
               Case 4#
                  X# = 6#
               Case 5#
                  X# = 12#
               Case 6#
                  X# = 16#
               Case 7#
                  X# = 18#
                  'CASE 8# ' overflows beyond double precision
                  '  X# = 30#
               Case Else
                  Error 130
            End Select
            ' equation for perfect number
            Perfect# = 2 ^ X# * (2 ^ (X# + 1) - 1)
         End If
         Temp# = Perfect#
      Case "P" ' prime number suffix
         For Digit = 1 To Len(Strng) - 1
            OutX$ = UCase$(Mid$(Strng, Digit, 1))
            Select Case OutX$
               Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                  ' nul
               Case Else
                  Error 130
            End Select
         Next
         Temp# = CDbl(Val(Left$(Strng, Len(Strng) - 1)))
         Prime.Number# = Int(Temp#)
         Prime# = 1
         If Prime.Number# > False Then
            Prime.Counter# = False
            Do
               Prime# = Prime# + 1
               Prime.Flag = False
               For Factor# = 2# To Int(Sqr(Prime#))
                  If Prime# / Factor# = Int(Prime# / Factor#) Then
                     Prime.Flag = True
                     Exit For
                  End If
               Next
               If Prime.Flag = False Then
                  Prime.Counter# = Prime.Counter# + 1
               End If
               If Prime.Counter# = Prime.Number# Then
                  Exit Do
               End If
            Loop
         End If
         Temp# = Prime#
      Case "F" ' factorial
         Temp2 = False
         Temp3 = Len(Strng)
         Do
            If UCase$(Mid$(Strng, Temp3, 1)) <> "F" Then
               Exit Do
            End If
            Temp2 = Temp2 + 1
            Temp3 = Temp3 - 1
         Loop
         For Decimal.Digit = 1 To Temp3
            OutX$ = UCase$(Mid$(Strng, Decimal.Digit, 1))
            Select Case OutX$
               Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                  ' nul
               Case Else
                  Error 130
            End Select
         Next
         Temp4# = Val(Left$(Strng, Temp3))
         For Number = 1 To Temp2
            Temp# = 1#
            For Factorial# = 2# To Temp4#
               Temp# = Temp# * Factorial#
            Next
            Temp4# = Temp#
         Next
      Case "H" ' hexidecimal suffix
         Temp# = False
         Hex.Power = False
         For Hex.Digit = Len(Strng) - 1 To 1 Step -1
            OutX$ = UCase$(Mid$(Strng, Hex.Digit, 1))
            Select Case OutX$
               Case "0" To "9", "A" To "F"
                  Hex.Value = Val("&H" + OutX$)
                  Temp# = Temp# + Hex.Value * 16 ^ Hex.Power
                  Hex.Power = Hex.Power + 1
               Case Else
                  Error 130
            End Select
         Next
      Case "O" ' octal suffix
         Temp# = False
         Octal.Power = False
         For Octal.Digit = Len(Strng) - 1 To 1 Step -1
            OutX$ = Mid$(Strng, Octal.Digit, 1)
            If OutX$ >= "0" And OutX$ <= "7" Then
               Octal.Value = Val(OutX$)
               Temp# = Temp# + Octal.Value * 8 ^ Octal.Power
               Octal.Power = Octal.Power + 1
            Else
               Error 130
            End If
         Next
      Case "B" ' binary suffix
         Temp# = False
         Binary.Power = False
         For Binary.Digit = Len(Strng) - 1 To 1 Step -1
            OutX$ = Mid$(Strng, Binary.Digit, 1)
            Select Case OutX$
               Case "0"
                  ' nul
               Case "1"
                  Temp# = Temp# + 2 ^ Binary.Power
               Case Else
                  Error 130
            End Select
            Binary.Power = Binary.Power + 1
         Next
      Case "0" To "9", "D", "E" ' decimal/exponent suffix
         Decimal = False
         Exponent = False
         Number$ = Strng
         Start.Token:
         For Decimal.Digit = 1 To Len(Number$)
            OutX$ = UCase$(Mid$(Number$, Decimal.Digit, 1))
            Select Case OutX$
               Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "+"
                  ' nul
               Case "D", "E"
                  If Exponent Then
                     Error 140
                  End If
                  Exponent = True
                  Exponent$ = UCase$(Right$(Number$, 1))
                  If Exponent$ = "D" Or Exponent$ = "E" Then
                     ' concatenate pre-parsed tokens into exponent
                     Unary$ = Mid$(Out2, Token.Index, 1)
                     If Unary$ = "+" Or Unary$ = "-" Then
                        Var$ = Left$(Out2, Token.Index - 1)
                        Call Get.Token
                        Out2 = Var$ + Strng + Mid$(Out2, Token.Index)
                        Call Get.Token
                        If Strng = Nul Then
                           Error 140
                        End If
                        Number$ = Number$ + Unary$ + Strng
                        If Strng = "-" Or Strng = "+" Then
                           Error 140
                        End If
                        If InStr(Strng, ".") Then
                           Error 140
                        End If
                        Do
                           If Left$(Number$, 1) = "-" Then
                              Number$ = Mid$(Number$, 2)
                           Else
                              If Left$(Number$, 1) = "+" Then
                                 Number$ = Mid$(Number$, 2)
                              Else
                                 Exit Do
                              End If
                           End If
                        Loop
                        Decimal = False
                        Exponent = False
                        GoTo Start.Token
                     Else
                        Error 140
                     End If
                  End If
               Case "."
                  If Exponent Then
                     Error 140
                  End If
                  If Decimal Then
                     Error 140
                  End If
                  Decimal = True
               Case Else
                  Error 130
            End Select
         Next
         Temp# = CDbl(Val(Number$))
      Case Else
         Error 130
   End Select
   Call Get.Token
   Last.Token = True
End Sub

' parse string in quotes
Sub Parse.Quoted
   Out3 = Nul
   Do Until Mid$(Out2, Token.Index, 1) = Chr$(34)
      Out3 = Out3 + Mid$(Out2, Token.Index, 1)
      Token.Index = Token.Index + 1
      If Token.Index > Len(Out2) Then
         Error 92
         Exit Do
      End If
   Loop
   Call Get.Token
   Call Get.Token
   Last.Token = False
End Sub

Rem entry to expression parser, each following parser is higher precedence,
Rem this routine called by higher precedence routines recursively.

Rem precedence of operators:
Rem   !, +, -  Not, Unary plus, Unary minus
Rem   <<, >>, --, ++, **, //  Dual unary
Rem   ^        Power
Rem   *, /     Multiplication, Division
Rem   \        Integer Division
Rem   %        Modulo
Rem   +, -     Addition, Subtraction
Rem   =, <, >, <>, >=, <=   Relational
Rem   |, &, ~, ?, :, #, @, `  Logical (or, and, xor, imp, eqv, nor, non, xan)

Sub Equate (Temp#)
   Last.Token = False
   Out3 = Nul ' reset string storage
   Out4 = Nul ' reset string concatenate storage
   Temp# = False ' reset result
   Token.Index = 1 ' reset pointer to expression token
   Call Get.Token ' read next token
   Call Parse1(Temp#) ' entry to parse the expression
   ' parse leftover tokens
   While Len(Strng)
      Call Parse1(X#)
      ' toss away any unwanted tokens
      If Last.Token = 3 Then
         Strng = "<extra token>"
         Error 92
      End If
   Wend
End Sub

' logical parser
Sub Parse1 (Temp#)
   Call Parse2(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "|", "&", "~", "?", ":", "#", "@", "`"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse2(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' relational parser
Sub Parse2 (Temp#)
   Call Parse3(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "<", ">", "=", ">=", "<=", "<>"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse3(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' addition/subtraction parser
Sub Parse3 (Temp#)
   Call Parse4(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "+", "-"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse4(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' modulo parser
Sub Parse4 (Temp#)
   Call Parse5(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "%"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse5(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' integer division parser
Sub Parse5 (Temp#)
   Call Parse6(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "\"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse6(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' multiplication/division parser
Sub Parse6 (Temp#)
   Call Parse7(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "*", "/"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse7(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' power parser
Sub Parse7 (Temp#)
   Call Parse7a(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "^"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      Call Parse7a(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' dual-unary parser
Sub Parse7a (Temp#)
   Call Parse8(Temp#) ' get next operator precedence
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "<<", ">>", "--", "++", "**", "//"
            ' Nul
         Case Else
            Exit Do
      End Select
      Token.Stored$ = Out3 ' store current token
      Call Get.Token ' read next token
      '    CALL Parse8(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = Token.Stored$ ' restore previous string
      Call Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
      Token.Parsed$ = Strng ' store next token
   Loop
End Sub

' not/unary plus/unary negative parser
Sub Parse8 (Temp#)
   Token.Negate$ = Nul ' reset not/unary tokens
   Token.Parsed$ = Strng ' store token
   ' process token
   Do
      Select Case Token.Parsed$
         Case "!", "-", "+", "--", "++"
            ' Nul
         Case Else
            Exit Do
      End Select
      Call Get.Token ' read next token
      ' store combined not/unary tokens
      Token.Negate$ = Token.Negate$ + Token.Parsed$
      Token.Parsed$ = Strng
   Loop
   Call Parse9(Temp#) ' get next operator precedence
   ' process the combined operators in reverse
   For Token.Type = Len(Token.Negate$) To 1 Step -1
      Select Case Mid$(Token.Negate$, Token.Type, 1)
         Case "+"
            ' nul calculation for unary plus
         Case "-"
            Temp# = -Temp# ' perform negate
         Case "!" ' not
            Temp# = Not Temp# ' perform not calculation
      End Select
   Next
End Sub

' string/numeric expression parser,
' routine returns calculated expression string/value,
' calls Parse1 recursively for values inside parenthesis/functions.
Sub Parse9 (Temp#)
   Select Case Token ' determine token type
      Case 0 ' unknown token
         If Last.Token = 3 Then
            Strng = "<extra token>"
            Error 92
         End If
         If Strng = Nul Then
            Strng = "<missing token>"
         End If
         Error 92
         Last.Token = False
      Case 1 ' token is symbol
         Token.Parsed$ = Strng
         Select Case Token.Parsed$ ' determine token
            Case ",", ";" ' separaters
               Last.Token = 3
            Case Chr$(34) ' parse string
               Call Parse.Quoted
               Quotes = True
            Case "(" ' calculate opening parenthesis
               Call Get.Token ' read next token value inside parenthesis
               If Strng = ")" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> ")" Then
                  Do ' calculate value
                     Call Parse1(Temp#) ' call parse entry
                  Loop Until Strng = ")" Or Token = False ' check closing parenthesis
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call Get.Token ' read next token after parenthesis
            Case "["
               Call Get.Token
               If Strng = "]" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> "]" Then
                  Do
                     Call Parse1(Temp#)
                  Loop Until Strng = "]" Or Token = False
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call Get.Token
            Case "{"
               Call Get.Token
               If Strng = "}" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> "}" Then
                  Do
                     Call Parse1(Temp#)
                  Loop Until Strng = "}" Or Token = False
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call Get.Token
            Case ")", "]", "}" ' check token is closing parenthesis
               Strng = "<extra closing token>"
               Error 92
         End Select
      Case 2 ' token is numeric value
         Call Parse.Numeric(Temp#)
      Case 3 ' token type is alphabetic
         Select Case Len(Strng) ' check variable type
            Case 1
               Call Parse.Alphabetic1(Temp#)
            Case 2
               Call Parse.Alphabetic2(Temp#)
            Case Else
               Call Parse.Alphabetic3(Temp#)
         End Select
         Call Get.Token
   End Select
End Sub

' remove all white spaces, skip white spaces in quotes.
Sub Remove.Spaces
   Var$ = Out2
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(Var$) Then
         Exit Do
      End If
      If Mid$(Var$, Temp, 1) = Chr$(34) Then
         Do
            Temp = Temp + 1
            If Temp > Len(Var$) Then
               Exit Do
            End If
            If Mid$(Var$, Temp, 1) = Chr$(34) Then
               Exit Do
            End If
         Loop
      End If
      For Blanks = 1 To Len(White.Space)
         If Mid$(Var$, Temp, 1) = Mid$(White.Space, Blanks, 1) Then
            Var$ = Left$(Var$, Temp - 1) + Mid$(Var$, Temp + 1)
            Temp = Temp - 1
            Exit For
         End If
      Next
   Loop
   Out2 = Var$
End Sub

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function

' replaces white spaces with spaces,
' var = true; skip spaces in quotes
Function TTRIM$ (Var$, Var)
   VarX$ = Var$
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Quote Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Quote Then
                  Exit Do
               End If
            Loop
         End If
      End If
      For Blanks = 1 To Len(White.Space)
         If Mid$(VarX$, Temp, 1) = Mid$(White.Space, Blanks, 1) Then
            Mid$(VarX$, Temp, 1) = " "
         End If
      Next
   Loop
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Quote Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Quote Then
                  Exit Do
               End If
            Loop
         End If
      End If
      If Mid$(VarX$, Temp, 2) = "  " Then
         VarX$ = Left$(VarX$, Temp) + Mid$(VarX$, Temp + 2)
         Temp = Temp - 1
      End If
   Loop
   TTRIM$ = VarX$
End Function

' strips leading/trailing white spaces from string
Function STRIM$ (Var$)
   VarX$ = Var$
   Do
      Blanks = False
      For Count = 1 To Len(White.Space)
         If Left$(VarX$, 1) = Mid$(White.Space, Count, 1) Then
            VarX$ = Mid$(VarX$, 2)
            Blanks = True
         End If
      Next
      If Blanks = False Then
         Exit Do
      End If
   Loop
   Do
      Blanks = False
      For Count = 1 To Len(White.Space)
         If Right$(VarX$, 1) = Mid$(White.Space, Count, 1) Then
            VarX$ = Left$(VarX$, Len(VarX$) - 1)
            Blanks = True
         End If
      Next
      If Blanks = False Then
         Exit Do
      End If
   Loop
   STRIM$ = VarX$
End Function

' replaces white spaces with nul,
' var = true; skip spaces in quotes
Function XTRIM$ (Var$, Var)
   VarX$ = Var$
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Quote Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Quote Then
                  Exit Do
               End If
            Loop
         End If
      End If
      For Blanks = 1 To Len(White.Space)
         If Mid$(VarX$, Temp, 1) = Mid$(White.Space, Blanks, 1) Then
            VarX$ = Left$(VarX$, Temp - 1) + Mid$(VarX$, Temp + 1)
            Temp = Temp - 1
            Exit For
         End If
      Next
   Loop
   XTRIM$ = VarX$
End Function

Rem improved 04/10/2025
Sub SwapData
   Assign = 0
   Temp1$ = Mid$(Out2, 5)
   Temp1$ = STRIM$(Temp1$)
   Temp2$ = UCase$(Left$(Temp1$, 1))
   If Temp2$ >= "A" And Temp2$ <= "Z" Then
      Variable1 = Asc(Temp2$) - 64
      Temp1$ = Mid$(Temp1$, 2)
      Temp1$ = STRIM$(Temp1$)
      If Left$(Temp1$, 1) = "," Or Left$(Temp1$, 1) = ";" Then
         Temp1$ = Mid$(Temp1$, 2)
         Temp1$ = STRIM$(Temp1$)
         Temp2$ = UCase$(Left$(Temp1$, 1))
         If Temp2$ >= "A" And Temp2$ <= "Z" Then
            Variable2 = Asc(Temp2$) - 64
            Temp1$ = Mid$(Temp1$, 2)
            Temp1$ = STRIM$(Temp1$)
            If Temp1$ = Nul Then
               Swap Variables(Variable1), Variables(Variable2)
               Assign = -1
               Exit Sub
            Else
               If Left$(Temp1$, 1) = "(" Or Left$(Temp1$, 1) = "[" Or Left$(Temp1$, 1) = "{" Then
                  TokenLeft$ = Left$(Temp1$, 1)
                  Out2 = Mid$(Temp1$, 2)
                  Out2 = STRIM$(Out2)
                  Last.Token = False
                  Token.Index = 1
                  Call Get.Token
                  Call Parse1(Temp3#)
                  OK = 0
                  If TokenLeft$ = "(" Then
                     If Strng = ")" Then
                        OK = -1
                     End If
                  End If
                  If TokenLeft$ = "[" Then
                     If Strng = "]" Then
                        OK = -1
                     End If
                  End If
                  If TokenLeft$ = "{" Then
                     If Strng = "}" Then
                        OK = -1
                     End If
                  End If
                  If OK = 0 Then
                     Error 110
                     Exit Sub
                  End If
                  Element = CInt(Temp3#)
                  V = UBound(Arrays, 2)
                  If Element > V Then
                     ReDim _Preserve Arrays(26, Element) As Double
                  End If
                  If Element > False Then
                     Swap Variables(Variable1), Arrays(Variable2, Element)
                     Assign = -1
                     Exit Sub
                  End If
               End If
            End If
         End If
      Else
         If Left$(Temp1$, 1) = "(" Or Left$(Temp1$, 1) = "[" Or Left$(Temp1$, 1) = "{" Then
            TokenLeft$ = Left$(Temp1$, 1)
            Out2 = Mid$(Temp1$, 2)
            Out2 = STRIM$(Out2)
            Last.Token = False
            Token.Index = 1
            Call Get.Token
            Call Parse1(Temp3#)
            OK = 0
            If TokenLeft$ = "(" Then
               If Strng = ")" Then
                  OK = -1
               End If
            End If
            If TokenLeft$ = "[" Then
               If Strng = "]" Then
                  OK = -1
               End If
            End If
            If TokenLeft$ = "{" Then
               If Strng = "}" Then
                  OK = -1
               End If
            End If
            If OK = 0 Then
               Error 110
               Exit Sub
            End If
            Element1 = CInt(Temp3#)
            Temp1$ = Mid$(Out2, Token.Index)
            Temp1$ = STRIM$(Temp1$)
            If Left$(Temp1$, 1) = "," Or Left$(Temp1$, 1) = ";" Then
               Out2 = Mid$(Temp1$, 2)
               Out2 = UCase$(Out2)
               Temp1$ = Mid$(Temp1$, 2)
               Temp1$ = STRIM$(Temp1$)
               Temp2$ = UCase$(Left$(Temp1$, 1))
               If Temp2$ >= "A" And Temp2$ <= "Z" Then
                  Variable2 = Asc(Temp2$) - 64
                  Temp1$ = Mid$(Temp1$, 2)
                  Temp1$ = STRIM$(Temp1$)
                  If Temp1$ = Nul Then
                     V = UBound(Arrays, 2)
                     If Element1 > V Then
                        ReDim _Preserve Arrays(26, Element1) As Double
                     End If
                     If Element1 > False Then
                        Swap Arrays(Variable1, Element1), Variables(Variable2)
                        Assign = -1
                        Exit Sub
                     End If
                  Else
                     If Left$(Temp1$, 1) = "(" Or Left$(Temp1$, 1) = "[" Or Left$(Temp1$, 1) = "{" Then
                        TokenLeft$ = Left$(Temp1$, 1)
                        Out2 = Mid$(Temp1$, 2)
                        Out2 = STRIM$(Out2)
                        Last.Token = False
                        Token.Index = 1
                        Call Get.Token
                        Call Parse1(Temp3#)
                        OK = 0
                        If TokenLeft$ = "(" Then
                           If Strng = ")" Then
                              OK = -1
                           End If
                        End If
                        If TokenLeft$ = "[" Then
                           If Strng = "]" Then
                              OK = -1
                           End If
                        End If
                        If TokenLeft$ = "{" Then
                           If Strng = "}" Then
                              OK = -1
                           End If
                        End If
                        If OK = 0 Then
                           Error 110
                           Exit Sub
                        End If
                        Element2 = CInt(Temp3#)
                        V = UBound(Arrays, 2)
                        If Element1 > V Then
                           ReDim _Preserve Arrays(26, Element1) As Double
                        End If
                        V = UBound(Arrays, 2)
                        If Element2 > V Then
                           ReDim _Preserve Arrays(26, Element2) As Double
                        End If
                        If Element1 > False Then
                           If Element2 > False Then
                              Swap Arrays(Variable1, Element1), Arrays(Variable2, Element2)
                              Assign = -1
                              Exit Sub
                           End If
                        End If
                     End If
                  End If
               End If
            End If
         Else
            If Left$(Temp1$, 1) = "$" Then
               Temp1$ = Mid$(Temp1$, 2)
               Temp1$ = STRIM$(Temp1$)
               If Left$(Temp1$, 1) = "," Or Left$(Temp1$, 1) = ";" Then
                  Temp1$ = Mid$(Temp1$, 2)
                  Temp1$ = STRIM$(Temp1$)
                  Temp2$ = UCase$(Left$(Temp1$, 1))
                  If Temp2$ >= "A" And Temp2$ <= "Z" Then
                     Variable2 = Asc(Temp2$) - 64
                     Temp1$ = Mid$(Temp1$, 2)
                     Temp1$ = STRIM$(Temp1$)
                     If Temp1$ = "$" Then
                        Swap Strngs$(Variable1), Strngs$(Variable2)
                        Assign = -1
                        Exit Sub
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   Error 110
End Sub

Sub ShellSub (x$)
   If UCase$(x$) = "SHELL" Then
      Comspec$ = Environ$("COMSPEC")
      If Len(Comspec$) Then
         Shell Comspec$
      Else
         Shell "CMD"
      End If
   Else
      X = FreeFile
      Open "WHATIS.BAT" For Output As #X
      Print #X, "@ECHO OFF"
      Print #X, Mid$(x$, 6)
      Print #X, "PAUSE"
      Print #X, "EXIT"
      Close #X
      Shell "WHATIS.BAT"
   End If
End Sub

Sub ShellProgram
   Out2 = Mid$(Out2, 6)
   Out2 = STRIM$(Out2)
   Token.Index = 1
   DOSCommand$ = Nul
   If Len(Out2) Then
      Call Get.Token
      Call Parse1(Temp3#)
      If Last.Token = False Then
         DOSCommand$ = Out3
      End If
   End If
   If DOSCommand$ = Nul Then
      Color Plain, Black
      Print "Type 'EXIT' to return."
      Comspec$ = Environ$("COMSPEC")
      If Len(Comspec$) Then
         Shell Comspec$
      Else
         Shell "CMD"
      End If
      Exit Sub
   End If
   FX$ = "WHATIS.BAT"
   X = FreeFile
   Open FX$ For Output As #X
   Print #X, "@ECHO OFF"
   Print #X, DOSCommand$
   Print #X, "PAUSE"
   Print #X, "EXIT"
   Close #X
   Shell FX$
End Sub


