//---------------------------------------------------------------------------//
//                                                                           //
//                                 SIG.CPP                                   //
//                                 -------                                   //
//                                                                           //
//  Author        :  John Eady                                               //
//  Installation  :  Arrow Consulting Services                               //
//  Date Written  :  1993-03-16                                              //
//  Environment   :  DOS                                                     //
//  Status        :  Freeware                                                //
//                                                                           //
// This program is to be used in conjunction with OLX to simplify appending  //
// a signature file to the end of your messages and replies.                 //
//                                                                           //
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
//                                                                           //
// USE: - Copy SIG.EXE into your OLX directory                               //
//                                                                           //
//      - Create a signature file called "SIG.OLX" and copy it into your     //
//        OLX directory                                                      //
//                                                                           //
//      - Go into OLX and modify (ALT-N) the name of the editor that you     //
//        are using to place SIG before the editor name.                     //
//                                                                           //
//             i.e.   before :      "Q"                                      //
//                    after  :      "SIG Q"                                  //
//                                                                           //
//                    before :      "C:\SPFPC\SPFPC REPLY.MSG"               //
//                    after  :      "SIG C:\SPFPC\SPFPC REPLY.MSG"           //
//                                                                           //
//                    etc...                                                 //
//                                                                           //
//      - Thats it!                                                          //
//                                                                           //
//      - Each time you enter a message in OLX, the text within SIG.OLX      //
//        will automatically be appended to the end of your message.         //
//                                                                           //
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
//                                                                           //
// If you have any comments and or suggestions, please feel free to contact  //
// me via the following methods:                                             //
//                                                                           //
// BBS      : Canada Remote Systems @ 1-416-629-7044                         //
//                                                                           //
// USENET   : john.eady@canrem.com                                           //
//                                                                           //
// NETWORKS : I usually hang out on most of the C/C++ conferences on         //
//            USENET/NANET/ILINK, etc...                                     //
//                                                                           //
// POSTAL   : John Eady              <---------- Slow, but at least          //
//            6 Dubarry avenue                   they are reliable.          //
//            West Hill, Ontario                                             //
//            M1E 3G8                                                        //
//                                                                           //
//---------------------------------------------------------------------------//

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <process.h>

//---------------------------------------------------------------------------//
//          G L O B A L   V A R I A B L E   D E F I N I T I O N S            //
//---------------------------------------------------------------------------//

char path_to_files[80];

//---------------------------------------------------------------------------//
//                 F U N C T I O N   P R O T O T Y P E S                     //
//---------------------------------------------------------------------------//

void add_signature();
void determine_reply_filename(char *);
void determine_path(char *);

//---------------------------------------------------------------------------//
//                                                                           //
//                                  main                                     //
//                                                                           //
// - insure that enough arguments were passed                                //
// - execute the users editor with passed arguments                          //
// - append signature file                                                   //
// - return to caller (usually OLX)                                          //
//                                                                           //
//---------------------------------------------------------------------------//

main(int argc ,char *argv[])
{

/////////////////////////////////////////////
// insure that the editor name was entered //
/////////////////////////////////////////////

if (argc < 2)
   {
   printf("\nSIG V1.1 - Signature file append for OLX and OLX-TD");
   printf("\n\nBy John Eady - Arrow Consulting Services");
   printf("\n\nReleased to public domain on 1993-03-16\n");
   exit(1);
   }

/////////////////////////////////////////////////////
// figure out what directory SIG is being run from //
/////////////////////////////////////////////////////

strcpy(path_to_files,argv[0]);
determine_path(path_to_files);

////////////////////////////////////////
// set archive bit off for reply file //
////////////////////////////////////////

char reply_file_name[80];
determine_reply_filename(reply_file_name);
_chmod(reply_file_name,1,FA_NORMAL);

////////////////////////
// execute the editor //
////////////////////////

if (spawnlp(P_WAIT, argv[1], argv[0], argv[2], argv[3], argv[4], NULL))
   {
   exit(1);
   }

/////////////////////
// append sig file //
/////////////////////

add_signature();

///////////////////
// return to OLX //
///////////////////

exit(0);

}

//---------------------------------------------------------------------------//
//                                                                           //
//                            add_signature                                  //
//                                                                           //
// - determine reply file name                                               //
// - open the reply file for append                                          //
// - open the signature file                                                 //
// - read signature file, and append to reply file                           //
// - close all files                                                         //
//                                                                           //
// - NOTE: If the file ARCHIVE bit is not on, then the reply file is not     //
//         modified. This is to insure that if the user backs out of         //
//         entering a message, SIG will not blindly add the sig file.        //
//                                                                           //
//---------------------------------------------------------------------------//
void add_signature()
{

FILE *sig_file;
FILE *reply_file;

char message_line[256];
char reply_file_name[80];

/////////////////////////////////////////////////
// determine reply file to append signature to //
/////////////////////////////////////////////////

determine_reply_filename(reply_file_name);

////////////////////////////////////////////////////
// if the archive bit is set, do not add sig file //
////////////////////////////////////////////////////

int attrib = _chmod(reply_file_name,0);

if (attrib == -1) return;

if (!(attrib & FA_ARCH)) return;

//////////////////////////////////////
// open the message file for append //
//////////////////////////////////////

reply_file = fopen(reply_file_name, "at");
if (reply_file == NULL)
   {
   printf("error in opening reply file\n");
   exit(1);
   }

/////////////////////////////
// open the signature file //
/////////////////////////////

char sig_file_name[80];
strcpy(sig_file_name,path_to_files);
strncat(sig_file_name,"sig.olx",7);

sig_file = fopen(sig_file_name, "rt");
if (sig_file == NULL)
   {
   printf("error in opening signature file\n");
   exit(1);
   }

///////////////////////////////////////////////////////
// read signature records and append to message file //
///////////////////////////////////////////////////////

while (fgets(message_line,256,sig_file) != NULL)
   {
   fputs(message_line,reply_file);
   }

//////////////////////////////
// close the signature file //
//////////////////////////////

if ((fclose(sig_file)) != 0)
   {
   printf("error in closing signature file\n");
   exit(1);
   }

////////////////////////////
// close the message file //
////////////////////////////

if ((fclose(reply_file)) != 0)
   {
   printf("error in closing reply file\n");
   exit(1);
   }

}

//---------------------------------------------------------------------------//
//                                                                           //
//                     determine_reply_filename                              //
//                                                                           //
// - search OLX's config.olx file to determine name of reply file            //
//                                                                           //
//---------------------------------------------------------------------------//
void determine_reply_filename(char reply_file_name[])
{

char config_record[80];

FILE *config_file;

//////////////////////////
// open the config file //
//////////////////////////

char config_file_name[80];
strcpy(config_file_name,path_to_files);
strncat(config_file_name,"config.olx",10);

config_file = fopen(config_file_name, "rt");
if (config_file == NULL)
   {
   printf("error in opening config.olx\n");
   exit(1);
   }

///////////////////////////////////////////////////
// read config file until REPLYFILE record found //
///////////////////////////////////////////////////

while (fgets(config_record,256,config_file) != NULL)
   {
   if (strncmpi(config_record,"REPLYFILE",9) == 0)
      {
      strcpy(reply_file_name,&config_record[15]);
      for(int x = 0;x<80;x++)
         {
         if (reply_file_name[x] == '\n')
            {
            reply_file_name[x] = '\0';
            break;
            }
         }

      break;
      }
   }

///////////////////////////
// close the config file //
///////////////////////////

if ((fclose(config_file)) != 0)
   {
   printf("error in closing config file\n");
   exit(1);
   }

}

//---------------------------------------------------------------------------//
//                                                                           //
//                             determine_path                                //
//                                                                           //
// - determine where SIG was executed from                                   //
// - this path then points to where the signaure file (SIG.OLX), and where   //
//   OLX's config file is located.                                           //
//                                                                           //
//---------------------------------------------------------------------------//
void determine_path(char execution_path[])
{

int x;

for (x = 0;execution_path[x] != '\0';x++);

for(;execution_path[x] != '\\';x--);

execution_path[++x] = '\0';

}

