        %
        %  Note: All our custom menus are set for NOVICE help level only.
        %  Callers may still use the "canned" Hotflash , regular or expert
        %  menus, we didn't want to force anyone to put up wih extra
        %  graphics . Likewise we use keys to display two types of
        %  ANSI graphics, /lessansi menus look much like the canned
        %  NOVICE HELP LEVEL menus and the /moreansi is full blown
        %  ansi graphics . As you can see, we added two commands to
        %  each menu that will toggle Rip Graphics on our off by
        %  hitting the < (RIPoff) or > (Ripon). Whenever a caller
        %  turns off RIPscrip, he will then default back to the
        %  ansi he chose previously
        %

Menu MAIN

	% This option defines what the name of the menu will look like
	% on-screen, to the user.  This doesn't necessarily have to be
	% the same name as you specified above.

	Title           MAIN

	% This option is used to specify a "type" for each menu.  These
	% menu types cause Maximus to display certain information before
	% the "Select:" prompt, such as the message area banner, the
	% information screen for the C)hange menu, and so on.  The
	% following MenuHeaders are supported by Maximus:
	%
	%       MenuHeader Message:   Displays a "Msg.area xx .. Description"
	%                             status line before each prompt.
	%
	%       MenuHeader File:      Displays a "File area yy .. Description"
	%                             status line before each prompt.
	%
	%       MenuHeader Change:    Displays the user's current settings,
	%                             which is usually what you'd find at
	%                             the C)hange Setup menu.

	SilentMenuHeader      None

	% This next option defines a customized *.BBS file to display
	% _instead_ of the canned, Max-generated menu.  The file you
	% specify will be shown to callers who enter this menu whenever
	% the menu options would normally be displayed.  If no
	% file is given, Max will generate the menu on its own.
	%
	% This file can contain any of the special MECCA tokens that
	% you can use in a normal .MEC file.
	%
	% If you specify a MenuFile, it will be enabled for all help
	% levels by default.  However, if you wish to enable the
	% menu for certain help levels only (such as NOVICE and
	% REGULAR), simply add the names of the levels after the
	% filename.  For example, "MenuFile Misc\MenuMain Novice"
	% would show the MenuFle to novice callers only, and
	% the Max-generated menu would be shown to everyone else.
	% See the Max TechRef manual for more information on this
	% option.
	%
	% Maximus can also display a HeaderFile for each menu.
	% Please see the TechRef Manual for more information.

       MenuFile        Misc\Main.bbs         Novice

	% If you are using the customized .BBS MenuFile, then you must
	% tell Maximus how many lines on your screen that your custom
	% file takes.  If this value is not specified, or if it is incorrect,
	% then you will have problems with messages being scrolled off the
	% top of your screen because of your customized menufile.

       MenuLength      24

	% This option is also only applicable if you're using a custom
	% *.BBS menufile.  As expected, if a user presses a key in the
	% middle of the menu with HOTFLASH turned on, the menu will abort
	% 0it's display, and jump to the option selected.  However, if
	% your *.BBS file has a coloured background, this operation may
	% cause the background to bleed into the rest of the screen.  The
	% solution is to specify an AVATAR colour number here, which will
	% be displayed BEFORE printing the key the user selected.  Normally,
	% this colour should have the background set to black, or whatever
	% colour your screen normally is.  An index of the AVATAR colour
	% codes (and their corresponding colours) can be found in the
	% MAX_REF.PRN manual.

       MenuColour      15

	% This section of the control file defines the available
	% commands for this menu.

	% The name of the COMMAND to perform is in the left column.
	% This tells Maximus what it should do when this option is
	% selected.  Examples of commands are "Goodbye",
	% "Display_File" and "Msg_Browse".
	%
	% Following the command is an optional argument; some
	% commands need arguments, but others don't.  If the argument
	% contains any spaces (such as would a DOS command line),
	% then make sure to replace them with underscores, which will
	% get translated back into spaces when the menu is read back
	% in.  The only common commands which use arguments are
	% Display_File, Display_Menu and Area_Change.
	%
	% After the argument is that command's access level.  This
	% access level consists of a privilege level and an optional
	% set of keys.  A user will only be able to select that
	% option if his/her priv level is equal to or higher than the
	% specified level.  In addition, if you wish to restrict a
	% command to users which carry certain keys, simply place a
	% slash and a list of key numbers/letters after the privilege
	% level.  For example, to restrict a command so that only
	% Normal-level users with keys 1 and C can access a command,
	% use a priv level of "Normal/1C".
	%
	% Following the priv level is the command description.  This
	% description will be used when creating NOVICE-level menus,
	% and the first letter of that command will be used as the
	% selection character, so make sure that each command has a
	% unique first character.



	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

 NoDsp  Display_File    Misc\resetrip           twit "m"
	Display_Menu    Message                 Twit "Message Areas"

        %
        %                 ** RIP NOTE **
        %
        % The following mecca file, RESETRIP.BBS is used to reset the
        % test window on the caller's terminal to 80 X 24. Although
        % this is also done by the button commands in our Ripscrip
        % menus- it is still needed for those callers that are not
        % using a mouse. We also added the RIP to reset the
        % command at several places including LOGO.BBS (using black on black)
        % because we found that QMPRO defaults to the smaller text
        % and the caller can't change it.


 NoDsp  Display_File    Misc\resetrip           twit "f"


	Display_Menu    File                    TWIT "File Areas"
 NoDsp  Display_File    Misc\resetrip           twit "c"
 	Display_Menu    Change                disgrace "Change Setup"

	% The above three options tell Maximus to chain to a different
	% *.Mnu file, whose name is specified as an argument.  Please
	% make sure NOT to include a path before the name of your menu,
	% since Maximus will add that according to the currently-defined
	% menu path.
 NoDsp  Display_File    Misc\resetrip           twit "g"
 NoDsp  Display_File       Misc\goodbye            twit "G"
	Goodbye                                    Twit "Goodbye (log off)"
 NoDsp  Display_File    Misc\resetrip           twit "s"
	Statistics                             disgrace "Statistics"
 NoDsp  Press_Enter                            disgrace  "s"
 NoDsp  Display_File    Misc\resetrip           twit "u"
 	Userlist                               twit "UserList"
 NoDsp  Press_Enter                            twit "U"
 NoDsp  Display_File    Misc\resetrip           twit "v"
	Version                                TWIT "Version of BBS"
 NoDsp  Press_Enter                            twit "V"
 NoDsp  Display_File    Misc\resetrip          twit "t"
 ReRead Xtern_Run C:\Max\Maxibank.exe       disgrace "T=Time-Bank"
 NoDsp  Display_File    Misc\resetrip          twit "5"
 	Display_File    Misc\grafwall          twit "5=Graffiti-Wall"
 NoDsp  Display_File    Misc\resetrip          twit "Y"
	Display_File    Misc\YellReq        disgrace "Yell-for-SysOp"
  NoDsp Yell                                disgrace "Y"
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"

	% The above options are fairly generic, and basically do what
	% they appear to do.

	% When selected, this option displays a *.BBS file to the user.
	% You can have as many of these custom files as you wish.
 NoDsp  Display_File    Misc\resetrip          twit "b"


	Display_File    Misc\Bulletin          TWIT "Bulletins"
 NoDsp  Display_File    Misc\resetrip          twit "8"
	Display_File    Misc\Dorinfo           TWIT "8=Ansi-Viewing-Door"
 NoDsp  Xtern_Dos     outside\pictdor          TWIT "8"
	Display_Menu    DoorA            twit "1=Door-Games_(A-G)"
        Display_Menu    DoorH              Twit "2=Door-Games_(H-N)"
 NoDsp  Display_File    Misc\resetrip          twit "6"
	Display_File    Misc\Dorinfo           disgrace "6=Local-BBS-LIST"
 NoDsp  Xtern_Dos       BBS\B.BAT              disgrace "6"
 NoDsp  Display_File    Misc\resetrip          twit "0"

        %
        %           ** Rip NOTE **
        %
        % The mecca file  PREHSCOPE.BBS contains a RIPscrip
        % of an example of animation with Ripscrip, we use it
        % prior to starting our batch file to run our Horoscope
        % door. In addition to displaying the animation it also sets
        % a border of stars about 1/2 inch down each side of the screen
        % the door then displays in the ansi size 91X25, making it almost
        % the same as regular ansi terminals but allows a little extra
        % Ripscrip for buttons etc.
        %

        Display_File    Misc\prehscop          twit "0=Horoscope"
 NoDsp  Display_File    Misc\Dorinfo         twit "0Horoscope"
 NoDsp  Xtern_Dos     outside\hscope.bat     twit "0"

        % QKLGF.BBS is nothing more than a [hangup] command

	Display_File    Misc\qklgf             twit "Quick-Log-off"
 NoDsp  Display_File    Misc\resetrip          twit "r"
        Display_File    Misc\Register          twit "Register"
	% These commands display the off-line reader and SysOp menus.
 NoDsp  Display_File    Misc\resetrip          twit "o"
	Display_Menu    Reader                 disgrace "Off-line-reader"
 NoDsp  Display_File    Misc\resetrip          twit "#"
	Display_Menu    Sysop                     Sysop "#Sysop-menu"
 NoDsp  Display_File    Misc\resetrip          twit "7"

        % 1File is a mecca file  menu that does contain Rip
        % graphics also, it is a small menu to allow callers
        % to access NODEDOOR, then view or download the list
        % that nodedoor produces

	Display_Menu    1FILE                     twit "7=BBS-Search"
 NoDsp  Display_File    Misc\resetrip          twit "9"
        Display_Menu    Door2                        twit "9=Evaluation Games"
        Display_Menu    Dooro                    disgrace "3=Door-Games_(O-S)"
        Display_Menu    Doort                    disgrace "4=Door-Games_(T-Z)"
	% The next commands are only of use to multi-line systems.
	% PLEASE SEE THE DOCUMENTATION BEFORE ENABLING THESE
	% COMMANDS!

%       Who_Is_On                              Disgrace "Who is On"
%       Display_Menu    Chat                   Disgrace "/Chat Menu"

	% The following is the help file for the main menu.  Unless you
	% specify a help file, such as done below, users will NOT be able
	% to press `?' for help.

 NoDsp  Display_File    Misc\resetrip          twit "h"
	Display_File    hlp\Main              twit "Help"
 NoDsp  Display_File    Misc\resetrip          twit "<"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    Misc\resetrip          twit ">"
 NoDsp  Display_File    misc\ripon            twit ">"
End Menu

Menu MESSAGE

        % ** RIP NOTE **
        % Ripscrip message areas may be nice, but they are not
        % practical, we added two other message menus by blocking
        % our message menu and copying it to another area, and
        % making the commands NoDSP. We then added a command to
        % go to the "Full" Text message menu, which is the "canned"
        % message menu, which works better.
        %
        %
	Title    MiniMessage  Hit @ for quick log off

	% To turn off the "Msg.area xxx ... asdf" display, but to still
	% have Max believe that this is a message menu, use
	% "SilentMenuHeader Message" instead of the line below.

	SilentMenuHeader      Message

	% To display a custom file instead of the canned Max menu, use
	% this:

       MenuFile        Misc\msgarea

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------
 NoDsp  Display_Menu      Micro_Message        twit "#=Micro_Message Menu"
 NoDsp  Display_File      Misc\resetrip        twit "!"
 NoDsp  Chg_Alias                              disgrace "!-Change-Alias "
 NoDsp  Display_File      Misc\resetrip        twit "b"
 NoDsp 	Msg_Browse                             disgrace "Browse messages"
 NoDsp  Display_File      Misc\resetrip        twit "c"
 NoDsp 	Msg_Change                             Normal "Change current msg"
 NoDsp  Display_File      Misc\resetrip        twit "="
 NoDsp 	Read_Nonstop                           twit "=ReadNonStop"
 NoDsp  Press_Enter                            twit "="
 NoDsp  Display_File      Misc\resetrip        twit "-"
 NoDsp 	Read_Original                          twit "-ReadOriginal"
 NoDsp  Press_Enter                            twit "-"
 NoDsp  Display_File      Misc\resetrip        twit "+"
 NoDsp 	Read_Reply                             twit "+ReadReply"
 NoDsp  Press_Enter                            twit "+"
 NoDsp  Display_File      Misc\resetrip        twit "*"
 NoDsp 	Msg_Current                            twit "*ReadCurrent"
 NoDsp  Press_Enter                            twit "*"
 NoDsp  Display_File      Misc\resetrip        twit "l"
  NoDsp 	Msg_List                               twit "List (brief)"
 NoDsp  Display_File      Misc\resetrip        twit "t"
 NoDsp 	Msg_Tag                                twit "Tag areas"
  NoDsp  Display_File      Misc\resetrip        twit "j"
 NoDsp 	Display_Menu    File                   Twit "Jump-to-file-areas"
  NoDsp  Display_File      Misc\resetrip        twit "d"
 NoDsp 	Display_Menu    DoorA                  twit "Door Games"
  NoDsp  Display_File      Misc\resetrip        twit "g"
  NoDsp  Display_File       Misc\goodbye            twit "G"
 NoDsp 	Goodbye                                Twit "Goodbye (log off)"
 NoDsp  Display_File      Misc\resetrip        twit "k"
 NoDsp 	Msg_Kill                               disgrace "Kill (delete) msg"
 NoDsp  Display_File      Misc\resetrip        twit "u"
 NoDsp 	Msg_Upload                             disgrace "Upload a message"
 NoDsp  Display_File      Misc\resetrip        twit "h"
 NoDsp 	Msg_Hurl                                  Sysop "Hurl (move)"
 NoDsp  Display_File      Misc\resetrip        twit "x"
 NoDsp 	Xport                                     Sysop "Xport to disk"
 NoDsp  Display_File      Misc\resetrip        twit "~"
 NoDsp 	Msg_Edit_User                             Sysop "~Edit user"
  NoDsp  Display_File      Misc\resetrip        twit "["
  NoDsp Area_Change     Message                twit "[" "["
  NoDsp  Display_File      Misc\resetrip        twit "]"
  NoDsp Area_Change     Message                twit "]" "]"
 NoDsp  Display_File      Misc\resetrip        twit "a"
	Area_Change     Message                twit "Area change"
 NoDsp  Display_File      Misc\resetrip        twit "n"
	Read_Next                              twit "Next message"
 NoDsp  Display_File      Misc\resetrip        twit "p"
	Read_Previous                          twit "Previous message"
 NoDsp  Display_File      Misc\resetrip        twit "e"
	Enter_Message                          disgrace  "Enter message"
 NoDsp  Display_File      Misc\resetrip        twit "r"
	Msg_Reply                              disgrace "Reply to a message"
 NoDsp  Display_File      Misc\resetrip        twit "m"
	Display_Menu    Main                   Twit "Main menu"
  NoDsp Display_File      Misc\resetrip        twit "|"
        %
        %  ** RIP Note ***
        %  We did not use the RESETRIP.BBS file here because doing so
        %  would prevent callers from entering more than one number
        %  to select a particular message, thus they could only pick
        %  the first 9 message numbers.
        %
        %  We created a third message menu we call the Micro message
        %  menu which cuts down the size of the text to 91 X 25 so
        %  a Rip caller still has a few menu options that can be mouse
        %  activated withour resorting to the small 91 X 43 Text window
        %

  NoDsp Same_Direction                         twit "|"
 NoDsp  Press_Enter                            twit "|"
  NoDsp Read_Individual                        twit "0"
 NoDsp  Press_Enter                            twit "0"
  NoDsp Read_Individual                        twit "1"
 NoDsp  Press_Enter                            twit "1"
  NoDsp Read_Individual                        twit "2"
 NoDsp  Press_Enter                            twit "2"
  NoDsp Read_Individual                        twit "3"
 NoDsp  Press_Enter                            twit "3"
  NoDsp Read_Individual                        twit "4"
 NoDsp  Press_Enter                            twit "4"
  NoDsp Read_Individual                        twit "5"
 NoDsp  Press_Enter                            twit "5"
  NoDsp Read_Individual                        twit "6"
 NoDsp  Press_Enter                            twit "6"
  NoDsp Read_Individual                        twit "7"
 NoDsp  Press_Enter                            twit "7"
  NoDsp Read_Individual                        twit "8"
 NoDsp  Press_Enter                            twit "8"
  NoDsp Read_Individual                        twit "9"
 NoDsp  Press_Enter                            twit "9"
        Display_Menu FullMessage               twit "Full Message Menu"
 NoDsp  Display_File      Misc\resetrip        twit "k"
	Msg_Kill                               disgrace "Kill (delete) msg"
 NoDsp  Display_File      Misc\resetrip        twit "@"
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"
 NoDsp  Display_File      Misc\resetrip        twit "<"

        % *** Rip Note ***
        %
        %  The mecca file, RIPOFF.BBS is a small mecca file that
        %  removes the P key. Our callers need three keys to
        %  actually see rip graphics, they need the RI keys in order
        %  to get the option to toggle Rip Graphics on and off,
        %  we did it this way so callers not interested in Rip Graphics
        %  would not have to be bothered by the question
        %  " Do you want Rip Graphics ? ", every time they log on
        %  (we do have the RI keys set for all guests)
        %
   NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File      Misc\resetrip        twit ">"

        %  The mecca file, RIPON.BBS is a small file that will
        %  give callers the "P" key  IF THEY HAVE THE " RI " key,
        %  the file will bypass all others.
        %
    NoDsp  Display_File    misc\ripon            twit ">"
  Local Display_File    Hlp\Msg                twit "?help"
 Matrix Display_File    Hlp\Mail               twit "?help"
   Echo Display_File    Hlp\Echo               twit "?help"

End Menu

Menu Micro_MESSAGE

        % *** RIP ***
        %
        % This menu was created entirely for the Ripscrip callers
        % that want to actually read and write messages, and do not
        % like the small 91X43 text, we set the text window to
        % 91X25 and added a few mouse buttons to activate a few
        % of the basic commands. This menu still contains most
        % of the full menu options, it does not display them.
        % Becasue it is possible for non-RIPscrip callers to activate
        % this menu, we also added an ansi menu that looks simliar to
        % the "REGULAR" help level menus.
        %
        % NOTE: because of the different languages, we had to add
        % the mecca command [Iflang]X [goto German] etc. and
        % also display a RIPscrip file that uses a J instead of a Y
        % for yes ( like wise for Spanish we used a S instead of a Y )
        %

	Title  MicroMessage  # = Go To Mini Message      @ = Logoff

	% To turn off the "Msg.area xxx ... asdf" display, but to still
	% have Max believe that this is a message menu, use
	% "SilentMenuHeader Message" instead of the line below.

	SilentMenuHeader      Message

	% To display a custom file instead of the canned Max menu, use
	% this:

       MenuFile        Misc\micromsg

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

 NoDsp  Display_Menu      Message               twit "# Mini Message Menu"
 NoDsp  Chg_Alias                              disgrace "!-Change-Alias "
 NoDsp 	Msg_Browse                             disgrace "Browse messages"
 NoDsp 	Msg_Change                             Normal "Change current msg"
 NoDsp 	Read_Nonstop                           twit "=ReadNonStop"
 NoDsp  Press_Enter                            twit "="
 NoDsp 	Read_Original                          twit "-ReadOriginal"
 NoDsp  Press_Enter                            twit "-"
 NoDsp 	Read_Reply                             twit "+ReadReply"
 NoDsp  Press_Enter                            twit "+"
 NoDsp 	Msg_Current                            twit "*ReadCurrent"
 NoDsp  Press_Enter                            twit "*"
  NoDsp 	Msg_List                               twit "List (brief)"
 NoDsp 	Msg_Tag                                twit "Tag areas"
  NoDsp Display_File    Misc\Bell              twit "J"
 NoDsp 	Display_Menu    File                   Twit "Jump-to-file-areas"
  NoDsp Display_File    Misc\Bell              twit  "D"
 NoDsp 	Display_Menu    DoorA                  twit "Door Games"
  NoDsp  Display_File       Misc\goodbye            twit "G"
 NoDsp 	Goodbye                                Twit "Goodbye (log off)"
 NoDsp 	Msg_Kill                               disgrace "Kill (delete) msg"
 NoDsp 	Msg_Upload                             disgrace "Upload a message"
 NoDsp 	Msg_Hurl                                  Sysop "Hurl (move)"
 NoDsp 	Xport                                     Sysop "Xport to disk"
 NoDsp 	Msg_Edit_User                             Sysop "~Edit user"
  NoDsp Area_Change     Message                twit "[" "["
  NoDsp Area_Change     Message                twit "]" "]"
 NoDsp Area_Change     Message                twit "Area change"
 NoDsp	Read_Next                              twit "Next message"
 NoDsp	Read_Previous                          twit "Previous message"
 NoDsp	Enter_Message                          disgrace  "Enter message"
 NoDsp	Msg_Reply                              disgrace "Reply to a message"
 NoDsp	Display_Menu    Main                   Twit "Main menu"
  NoDsp Same_Direction                         twit "|"
 NoDsp  Press_Enter                            twit "|"
  NoDsp Read_Individual                        twit "0"
 NoDsp  Press_Enter                            twit "0"
  NoDsp Read_Individual                        twit "1"
 NoDsp  Press_Enter                            twit "1"
  NoDsp Read_Individual                        twit "2"
 NoDsp  Press_Enter                            twit "2"
  NoDsp Read_Individual                        twit "3"
 NoDsp  Press_Enter                            twit "3"
  NoDsp Read_Individual                        twit "4"
 NoDsp  Press_Enter                            twit "4"
  NoDsp Read_Individual                        twit "5"
 NoDsp  Press_Enter                            twit "5"
  NoDsp Read_Individual                        twit "6"
 NoDsp  Press_Enter                            twit "6"
  NoDsp Read_Individual                        twit "7"
 NoDsp  Press_Enter                            twit "7"
  NoDsp Read_Individual                        twit "8"
 NoDsp  Press_Enter                            twit "8"
  NoDsp Read_Individual                        twit "9"
 NoDsp  Press_Enter                            twit "9"
 NoDsp  Display_File   Misc\resetrip           twit "f"
 NoDsp  Display_Menu FullMessage               twit "Full Message Menu"
 NoDsp	Msg_Kill                               disgrace "Kill (delete) msg"
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"
 NoDsp  Display_File      Misc\resetrip        twit "<"
   NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File      Misc\resetrip        twit ">"
    NoDsp  Display_File    misc\ripon            twit ">"
  Local Display_File    Hlp\Msg                twit "?help"
 Matrix Display_File    Hlp\Mail               twit "?help"
   Echo Display_File    Hlp\Echo               twit "?help"
End Menu

Menu fullMESSAGE
	Title           MESSAGE

	% To turn off the "Msg.area xxx ... asdf" display, but to still
	% have Max believe that this is a message menu, use
	% "SilentMenuHeader Message" instead of the line below.

	MenuHeader      Message

	% To display a custom file instead of the canned Max menu, use
	% this:

%       MenuFile        Misc\MenuMsg

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

	Area_Change     Message                twit "Area change"
  NoDsp Area_Change     Message                twit "[" "["
  NoDsp Area_Change     Message                twit "]" "]"
	Chg_Alias                              disgrace "!-Change-Alias "
	Read_Next                              twit "Next message"
	Read_Previous                          twit "Previous message"
	Enter_Message                          disgrace "Enter message"
	Msg_Reply                              disgrace "Reply to a message"
	Msg_Browse                             disgrace "Browse messages"
	Msg_Change                             Normal "Change current msg"
	Read_Nonstop                           twit "=ReadNonStop"
	Read_Original                          twit "-ReadOriginal"
	Read_Reply                             twit "+ReadReply"
	Msg_Current                            twit "*ReadCurrent"
	Msg_List                               twit "List (brief)"
	Msg_Tag                                twit "Tag areas"
	Display_Menu    Main                   Twit "Main menu"
  NoDsp Display_File    Misc\Bell              twit "J"
 	Display_Menu    File                   Twit "Jump-to-file-areas"
	Display_Menu    DoorA                  twit "Door Games"
  NoDsp  Display_File       Misc\goodbye            twit "G"
	Goodbye                                Twit "Goodbye (log off)"
	Msg_Kill                               disgrace "Kill (delete) msg"
	Msg_Upload                             disgrace "Upload a message"
	Forward                                disgrace "Forward (copy)"
	Msg_Hurl                                  Sysop "Hurl (move)"
	Xport                                     Sysop "Xport to disk"
	Msg_Edit_User                             Sysop "~Edit user"
  NoDsp Same_Direction                         twit "|"
  NoDsp Read_Individual                        twit "0"
  NoDsp Read_Individual                        twit "1"
  NoDsp Read_Individual                        twit "2"
  NoDsp Read_Individual                        twit "3"
  NoDsp Read_Individual                        twit "4"
  NoDsp Read_Individual                        twit "5"
  NoDsp Read_Individual                        twit "6"
  NoDsp Read_Individual                        twit "7"
  NoDsp Read_Individual                        twit "8"
  NoDsp Read_Individual                        twit "9"
  Local Display_File    Hlp\Msg                twit "?help"
 Matrix Display_File    Hlp\Mail               twit "?help"
   Echo Display_File    Hlp\Echo               twit "?help"
	Display_File    Misc\qklgf             twit "@-Quick Log off"
        Display_File    Misc\dorinfo           twit "$-Remindme"
  NoDsp Xtern_Dos       outside\remind.bat     twit "$"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    misc\ripon            twit ">"

End Menu

Menu FILE
	Title           FILE

	% To turn off the "File area xxx ... asdf" display, but to still
	% have Max believe that this is a file menu, use
	% "SilentMenuHeader File" instead of the line below.

	SilentMenuHeader      File

	% To display a custom file instead of the canned Max menu, use
	% this:

       MenuFile        Misc\FILE   NOVICE
       Menucolour       15
	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

	Area_Change     File               TWIT "Area change"
  NoDsp Area_Change     File               twit "[" "["
  NoDsp Area_Change     File               twit "]" "]"
 NoDsp  Display_File      Misc\resetrip        twit "l"
	Locate                             twit "Locate a file"
  NoDsp Press_Enter                        twit "L"

 NoDsp  Display_File      Misc\resetrip        twit "f"
	File_Titles                        TWIT "File titles"
  NoDsp Press_Enter                        Twit "F"

 NoDsp  Display_File      Misc\resetrip        twit "v"
	Type                               twit "View text file"
  NoDsp Press_Enter                        twit "V"

 NoDsp  Display_File      Misc\resetrip        twit "d"
	Download                           disgrace "Download (receive)"
  NoDsp Press_Enter                        disgrace "d"

 NoDsp  Display_File      Misc\resetrip        twit "u"
	Upload                             Normal     "Upload (send)"

 NoDsp  Display_File      Misc\resetrip        twit "s"
        Display_File    Misc\Rombrain      twit       "Simtel"

 NoDsp  Display_File      Misc\resetrip        twit "c"
	Contents                           twit "Contents (archive)"
  NoDsp Press_Enter                        twit "c"

 NoDsp  Display_File      Misc\resetrip        twit "t"
	File_Tag                           disgrace "Tag (queue) files"
  NoDsp Press_Enter                        disgrace "t"

 NoDsp  Display_File      Misc\resetrip        twit "n"
	NewFiles                                  twit "New files scan"
  NoDsp Press_Enter                               twit "N"

 NoDsp  Display_File      Misc\resetrip        twit "r"
        Raw                                       Sysop "Raw directory"
  NoDsp Press_Enter                               Sysop "R"

 NoDsp  Display_File      Misc\resetrip        twit "k"
        File_Kill                                 Sysop "Kill file"

 NoDsp  Display_File      Misc\resetrip        twit "h"
        File_Hurl                                 Sysop "Hurl (move)"

 NoDsp  Display_File      Misc\resetrip        twit "o"
        Override_Path                             Sysop "Override path"
	Display_Menu    Main                   twit "Main menu"
	Display_Menu    Message                 TWIT "Jump to msg. areas"
  NoDsp  Display_File       Misc\goodbye1            twit "G"
	Goodbye                                    Twit "Goodbye (log off)"
	Display_File    Hlp\FileHelp         twit "?=help"
	Display_File    Misc\qklgf           TWIT "@=Quick Log off"

 NoDsp  Display_File      Misc\resetrip        twit "p"
        Display_File    Misc\Rombrain      Normal   "Pc-Sig"
       Display_Menu     DoorA                twit "#=games"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    misc\ripon            twit ">"

End Menu

Menu CHANGE
	Title           CHANGE
	MenuHeader      Change

%       MenuFile        Misc\MenuChg

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

	Chg_Alias                              twit "Alias"
	Chg_Phone                              disgrace "#Telephone no."
	Chg_City                               disgrace "City"
	Chg_Password                           disgrace "Password"
	Chg_Help                               twit "Help level"
	Chg_Nulls                              twit "Nulls"
	Chg_Width                              twit "Width"
	Chg_Length                             twit "Length"
	Chg_Tabs                               twit "Tabs"
	Chg_Video                              twit "Video mode"
	Chg_Editor                             twit "FullScrnEdit"
	Chg_Clear                              twit "Screen clear"
	Chg_IBM                                twit "IBM characters"
	Chg_Hotkeys                            twit "!Hotkeys"
	Chg_Language                           twit "{Language"
	Chg_Userlist                           disgrace "%ShowInUserlist"
	Chg_Protocol                           twit "$Protocol default"
	Chg_Archiver                           disgrace "&Archiver default"
	Chg_FSR                                twit "^FullScrnRead"
	Chg_More                               twit "*More Prompt"
	Display_Menu    Main                       Twit "Main Menu"
  NoDsp Display_Menu    Main                       Twit "Q"
  NoDsp Display_Menu    Main                       Twit "|"
	Display_File    Hlp\Change             twit "?help"
	Display_File    Misc\qklgf             twit "@ Quick Log off"
        Display_File    Misc\rem               disgrace "Remind-Me-Auto"
        Display_File    Misc\ansi              twit "+=Ansi_Music"
	Display_File    Misc\tkey2             disgrace "=Menu_Type"

        %
        %  *** RIP NOTE ***
        %
        %  The mecca file RICHOICE.BBS is a small menu that allows
        %  callers to toggle the RI keys on and off, they need
        %  the RI keys in order to be able to toggle the "P"
        %  key on and off, callers need all 3 keys RIP to get
        %  Rip graphics.  RIPOFF.BBS, and RIPON.BBS toggle the "P" key
        %

        Display_File    Misc\richoice          disgrace "Graphics"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    Misc\ripon            twit ">"
	%
End Menu

Menu EDIT
	Title           EDIT

%       MenuFile        Misc\MenuEdit

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

	Edit_Save                             twit  "Save Message"
	Edit_Abort                            twit  "Abort Message"
	Edit_List                             twit  "List Message"
	Edit_Edit                             twit  "Edit Line"
	Edit_Insert                           twit  "Insert Line"
	Edit_Delete                           twit  "Delete Line"
	Edit_Quote                            twit  "Quote message"
	Edit_Continue                         twit  "Continue"
	Edit_To                               twit  "To"
	Edit_Subj                             twit  "JsubJect"
	Edit_From                                 Sysop "From"
	Edit_Handling                             Sysop "Handling"
	Read_DiskFile                             Sysop "Read from disk"
	Display_File    Hlp\Editor            twit  "?help"
	%
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"
         NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    misc\ripon            twit ">"

End Menu


Menu CHAT
	Title           CHAT

	MenuHeader      Chat
%       MenuFile        Misc\MenuChat

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

	Chat_CB                                Disgrace "CB Chat"
	Chat_Page                              Disgrace "Page User"
	Chat_Pvt                               Disgrace "Answer Page"
	Chat_Toggle                            Disgrace "Toggle Status"
	Display_Menu    MAIN                   Disgrace "Main Menu"
 NoDsp  Display_File       Misc\goodbye            twit "G"
	Goodbye                                Disgrace "Goodbye (log off)"
	Display_File    Misc\ChatHelp          Disgrace "?help"
End Menu


Menu READER
	Title           READER
%	HeaderFile      Misc\OLR_Hdr
        MenuFile        Misc\offline

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

 NoDsp  Display_File    Misc\resetrip          twit     "T"
  	Msg_Tag                                disgrace "Tag area"
 NoDsp  Display_File    Misc\resetrip          twit     "D"
	Msg_Browse                             disgrace "Download new msgs" "tnp"
 NoDsp  Display_File    Misc\resetrip          twit     "u"
	Msg_Upload_QWK                         disgrace "Upload replies"
 NoDsp  Display_File    Misc\resetrip          twit     "p"
	Chg_Protocol                           disgrace "Protocol default"
 NoDsp  Display_File    Misc\resetrip          twit     "a"
	Chg_Archiver                           disgrace "Archiver default"
 NoDsp  Display_File    Misc\resetrip          twit     "m"
  NoDsp Display_File    Misc\bell	           disgrace "M"
	Display_Menu    Main                       disgrace "Main menu"
 NoDsp  Display_File    Misc\resetrip          twit     "g"
 NoDsp  Display_File       Misc\goodbye            twit "G"
	Goodbye                                    disgrace "Goodbye (log off)"
 NoDsp  Display_File    Misc\resetrip          twit     "?"
	Display_File    Hlp\OLR                disgrace "?help"
 NoDsp  Display_File    Misc\resetrip          twit     "|"
  NoDsp Display_Menu    Main                       disgrace "|"
 NoDsp  Display_File    Misc\resetrip          twit     "@"
	Display_File    Misc\qklgf             disgrace "@=Quick-Log-off"
 NoDsp  Display_File    Misc\resetrip          twit     "<"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    Misc\resetrip          twit ">"
 NoDsp  Display_File    misc\ripon            twit ">"
End Menu


Menu SYSOP
	Title           SYSOP

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------

	% This command invokes the internal Maximus user editor.

 User_Editor                                Sysop "Editor "

	% This tells Maximus that you want to execute an external
	% program (in this case, COMMAND.COM) when the `O' menu option
	% is selected.  Other options are available, such as `Xtern_Dos'
	% (which can run .BAT or .CMD files) and `Xtern_Erlvl'
	% (which completely unloads Maximus from memory).
	%
	% Also, when specifying the command/errorlevel to execute,
	% don't forget to use underscores instead of spaces!
	%
	% Examples:
	%
	%   Xtern_Run   C:\Max\Bonk_/XN       Sysop "Nodelist editor"
	%   Xtern_Dos   D:\Path\Runme.Bat      Twit "Run XYZ program"
	%   Xtern_Erlvl 45_Ongame.Bat      twit "On-line Games"

	% If you're running 4DOS, replace the following
	% "Command.Com" with "4Dos.Com".

%UsrRemote Xtern_Run     Command.Com_>com%P_<com%P   Sysop "OS Shell"
        Xtern_Run     Command.Com                 Sysop "OS Shell"
        Display_File    Comment.txt                 sysop "Comments"
        Display_Menu    Main                        Sysop "Main menu"
  NoDsp Display_Menu    Main                        Sysop "Q"
  NoDsp Display_Menu    Main                        Sysop "|"
 	Display_File    Misc\Dorinfo           Sysop "717 BBS LIST"
 NoDsp  Xtern_Dos       BBS\B1.BAT             sysop "7"
	Xtern_Dos       D:\hsenv\exec                Sysop "Headstart"
        Xtern_Dos       E:\Pctools\pctools           sysop "Pctools"
        Xtern_Dos       D:\hsenv\sted                Sysop "Sted Editor"
  NoDsp Display_File    Misc\qklgf             sysop "@-Quick Log off"

End Menu

Menu 1file
      	Title          Search & Automatically Create your own BBS List

	% To turn off the "File area xxx ... asdf" display, but to still
	% have Max believe that this is a file menu, use
	% "SilentMenuHeader File" instead of the line below.

	SilentMenuHeader  File

	% To display a custom file instead of the canned Max menu, use
	% this:

       MenuFile        Misc\search

	% Name of cmd    Optional arguments      Priv.   Command as it
	% to execute     for cmd, if any         Level   appears to user
	% ------------  --------------------- --------- -----------------


	Display_File    Misc\Dorinfo            TWIT "Search for a BBS"
 NoDsp  Xtern_Dos     outside\nodedoor.bat      twit "S"
 NoDsp  Display_File    Nodedoor\color.bbs      twit "V"
        Display_File    Nodedoor\nodedoor.ls1   twit "View Your List"
 NoDsp  Press_Enter                             twit "V"

      Display_File     misc\protocol  Twit "Download BBS List"
NoDsp Area_Change         File           twit "d" "1;|"
NoDsp Download                        Twit "Download BBS List" "MYBBSLST.TXT;|"

	Display_Menu    Main               twit "Main menu"
 NoDsp  Display_File       Misc\goodbye            twit "#"
	Goodbye                            Twit "Goodbye (log off)"
	Display_File    Misc\qklgf         twit "@ Quick Log off"
         NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    misc\ripon            twit ">"

End Menu

Menu DoorA
	Title           Door
	MenuHeader      none
	MenuFile        misc\doorA.bbs Novice
	MenuColour      15

        Display_File   Misc\dorinfo          disgrace "Q=Door_Mania"
 NoDsp  Display_File    Misc\resetrip          twit "q"
  NoDsp xtern_Dos      outside\mania.bat  disgrace "q"
 NoDsp  Display_File    Misc\resetrip          twit "a"
	  Display_File   misc\dorinfo        disgrace "A=Global-Wars"
  NoDsp Xtern_Dos        outside\War.bat     disgrace "A"
 NoDsp  Display_File    Misc\resetrip          twit "f"
        Display_File     Misc\Dorinfo        disgrace "F=Golf"
  NoDsp Xtern_Dos        outside\golf.bat    disgrace "F"
 NoDsp  Display_File    Misc\resetrip          twit "e"
	Display_File     misc\dorinfo        disgrace "E=Arena-Warrior"
  NoDsp Xtern_Dos        outside\arena.bat   disgrace "E"
 NoDsp  Display_File    Misc\resetrip          twit "g"
	Display_File     misc\dorinfo        disgrace "G=Kannons&Katapults"
  NoDsp Xtern_Dos        outside\knk.bat     disgrace "G"
 NoDsp  Display_File    Misc\resetrip          twit "m"
	Display_File     misc\dorinfo        disgrace  "M=Motor-City-Drags"
  NoDsp Xtern_Dos        outside\playrace.bat disgrace "M"
 NoDsp  Display_File    Misc\resetrip          twit "c"
	Display_File     misc\dorinfo         disgrace "C=Greedy"
  NoDsp Xtern_Dos        outside\greedy.bat   disgrace "C"
 NoDsp  Display_File    Misc\resetrip          twit "b"
	Display_File     misc\dorinfo         disgrace "B=Black-Jack"
  NoDsp Xtern_Dos        outside\black.bat    disgrace "B"
 NoDsp  Display_File    Misc\resetrip          twit "n"
	Display_File     misc\dorinfo         disgrace "N=Card-Guppies"
  NoDsp Xtern_Dos        outside\guppies.bat  disgrace "N"
 NoDsp  Display_File    Misc\resetrip          twit "i"
	Display_File     misc\dorinfo         disgrace "I=King-of-The-Board"
  NoDsp Xtern_Dos        qdoor\go.bat         disgrace "I"
 NoDsp  Display_File    Misc\resetrip          twit "j"
	Display_File     misc\dorinfo         disgrace "J=BBS-Bowling"
  NoDsp Xtern_Dos        outside\bowling.bat  disgrace "J"
 NoDsp  Display_File    Misc\resetrip          twit "d"
	Display_File     misc\dorinfo         disgrace "D=Motor-City-Bowling"
  NoDsp Xtern_Dos        outside\mcbowl.bat   disgrace "D"
 NoDsp  Display_File    Misc\resetrip          twit "k"
        Display_File   misc\dorinfo        disgrace "k=Blocks-door_(Tetris)"
  Nodsp Display_File   Misc\check12        disgrace "k"
 NoDsp  Display_File    Misc\resetrip          twit "h"
        Display_File   misc\dorinfo        disgrace "H=Electric Avenue"
  NoDsp Xtern_Dos      outside\EA.BAT      disgrace "H"
 NoDsp  Display_File    Misc\resetrip          twit "l"
        Display_File   Misc\dorinfo          disgrace "L=Battle_Grid"
  NoDsp Xtern_dos      outside\bgrid.bat     disgrace "L"
        Display_File   Misc\dorinfo          disgrace "O=Barren_Realms"
  NoDsp Display_File    Misc\resetrip          twit "o"
  NoDsp Xtern_Dos      outside\bre           disgrace "o"
        Display_File   Misc\dorinfo          twit "P=Double_Solitaire"
  NoDsp Display_File    Misc\resetrip          twit "p"
  NoDsp Xtern_Dos      outside\dblsol.bat           twit "p"
	Display_Menu     Main                 twit "1=quit"
        Display_Menu    DoorA                  twit "2=Games_A-G"
        Display_Menu     Doorh                 twit "3=Doors_H-N"
        Display_Menu     dooro                twit "4=Doors_O-S"
	Display_Menu     doort                twit "5=Doors_T-Z"
 NoDsp  Display_File    Misc\resetrip          twit "6"
        Display_Menu     Door2                twit "6=Evaluation_Games"
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"
 NoDsp  Display_File    Misc\resetrip          twit "<"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    Misc\resetrip          twit ">"
 NoDsp  Display_File    misc\ripon            twit ">"

End Menu



Menu DoorH
	Title           Door
	MenuHeader      none
	MenuFile        misc\DoorH.bbs Novice
	MenuColour      15

 NoDsp  Display_File    Misc\resetrip          twit "b"
	Display_File     misc\dorinfo        disgrace "B=Land-of-Barons"
  NoDsp Xtern_Dos        outside\Bar.bat     disgrace "B"
 NoDsp  Display_File    Misc\resetrip          twit "c"
	Display_File     misc\dorinfo         disgrace "C=Melee"
  NoDsp Xtern_ERLVL 65_C:\MAX\outside\warrior.bat  disgrace "C Melee"
 NoDsp  Display_File    Misc\resetrip          twit "d"
	Display_File     misc\dorinfo         disgrace "D=Hangman"
  NoDsp Xtern_Dos        outside\hangman.bat  disgrace "D"
 NoDsp  Display_File    Misc\resetrip          twit "e"
	Display_File     misc\dorinfo         disgrace "E=Mine-Field"
  NoDsp Xtern_Dos        outside\mine.bat     disgrace "E"
 NoDsp  Display_File    Misc\resetrip          twit "f"
	Display_File     misc\dorinfo         disgrace "F=Match-maker"
  NoDsp Xtern_Dos        outside\mmaker.bat   disgrace "F"
 NoDsp  Display_File    Misc\resetrip          twit "a"
        Display_File     Misc\dorinfo         disgrace "A=Match-15"
  NoDsp Xtern_Dos        outside\15.bat       disgrace "A"
 NoDsp  Display_File    Misc\resetrip          twit "g"
        Display_File   Misc\dldoor         disgrace "G=Modem Drags"
 NoDsp  Display_File    Misc\resetrip          twit "i"
        Display_File     misc\dorinfo         disgrace "I=Noose"
  NoDsp Xtern_Dos        outside\noose.bat    disgrace "I"
 NoDsp  Display_File    Misc\resetrip          twit "h"
	Display_File     misc\dorinfo         disgrace "H=Name-that-Tune"
  NoDsp Display_File     Misc\cls             disgrace "H"
  NoDsp Xtern_Dos        outside\songs        disgrace "H"
   	Display_Menu     Main                 twit "1=quit"
        Display_Menu    DoorA                  twit "2=Games_A-G"
        Display_Menu     Doorh                 twit "3=Doors_H-N"
        Display_Menu     dooro                twit "4=Doors_O-S"
	Display_Menu     doort                twit "5=Doors_T-Z"
 NoDsp  Display_File    Misc\resetrip          twit "6"
        Display_Menu     Door2                twit "6=Evaluation_Games"
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"
 NoDsp  Display_File    Misc\resetrip          twit "<"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    Misc\resetrip          twit ">"
 NoDsp  Display_File    misc\ripon            twit ">"

End Menu

Menu DoorO
	Title           Door
	MenuHeader      none
	MenuFile        misc\Dooro.bbs Novice
	MenuColour      15

 NoDsp  Display_File    Misc\resetrip          twit "j"
	Display_File     Misc\dorinfo         disgrace "J=Sinbaud"
  NoDsp Xtern_Dos        outside\Sin.bat      disgrace "J"
 NoDsp  Display_File    Misc\resetrip          twit "i"
	Display_File     misc\dorinfo         disgrace "I=Super-Slots"
  NoDsp Xtern_Dos        outside\slot         disgrace "I"
 NoDsp  Display_File    Misc\resetrip          twit "f"
	Display_File     misc\dorinfo         disgrace "F=Sub-Attack"
  NoDsp Xtern_Dos        outside\sud.bat      disgrace "F"
 NoDsp  Display_File    Misc\resetrip          twit "k"
	Display_File     misc\doorsys         disgrace "K=Robo-Wars"
  NoDsp Xtern_Dos        outside\robo.bat     disgrace "K"
 NoDsp  Display_File    Misc\resetrip          twit "c"
	Display_File     misc\callinfo        disgrace "C=Sinkem"
  NoDsp Xtern_Dos        outside\sinkem.bat   disgrace "C"
 NoDsp  Display_File    Misc\resetrip          twit "e"
	Display_File     misc\dorinfo         disgrace "E=SharpShooter"
  NoDsp Xtern_Dos        outside\sharp.bat    disgrace "E"
 NoDsp  Display_File    Misc\resetrip          twit "d"
	Display_File     misc\callinfo        disgrace "D=Orion-Outreach"
  NoDsp Xtern_Dos        outside\runorion.bat disgrace "D"
 NoDsp  Display_File    Misc\resetrip          twit "g"
	Display_File     misc\dorinfo         disgrace "G=Solitaire"
  NoDsp Xtern_Dos        outside\sol.bat      disgrace "G"
 NoDsp  Display_File    Misc\resetrip          twit "b"
        Display_File     misc\dorinfo         disgrace "B=Survivor_(Tank Combat)"
  NoDsp Xtern_Dos        outside\survivor.bat disgrace "B"
 NoDsp  Display_File    Misc\resetrip          twit "h"
        Display_File    Misc\dorinfo           disgrace "H-Remindme"
  NoDsp Xtern_Dos       outside\remind.bat     disgrace "H"
  NoDsp Display_File    Misc\rem               disgrace "H"
 NoDsp  Display_File    Misc\resetrip          twit "l"
        Display_File   Misc\dorinfo          disgrace "L=ProChess"
  NoDsp Xtern_Dos      outside\prochess.bat  disgrace "L"
 NoDsp  Display_File    Misc\resetrip          twit "a"
        Display_File   Misc\dorinfo          disgrace "A=Baseball"
  NoDsp xtern_dos      outside\baseball.bat  disgrace "A"
        Display_File   Misc\dorinfo          disgrace "M=Steel_and_Ice"
  NoDsp  Display_File    Misc\resetrip          twit "m"
  NoDsp xtern_dos      outside\S&I.bat       disgrace "m"
   	Display_Menu     Main                 twit "1=quit"
        Display_Menu    DoorA                  twit "2=Games_A-G"
        Display_Menu     Doorh                 twit "3=Doors_H-N"
        Display_Menu     dooro                twit "4=Doors_O-S"
	Display_Menu     doort                twit "5=Doors_T-Z"
 NoDsp  Display_File    Misc\resetrip          twit "6"
        Display_Menu     Door2                twit "6=Evaluation_Games"
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"
 NoDsp  Display_File    Misc\resetrip          twit "<"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    Misc\resetrip          twit ">"
 NoDsp  Display_File    misc\ripon            twit ">"

End Menu


Menu DoorT
	Title           Door
	MenuHeader      none
	MenuFile        misc\doort.bbs Novice
	MenuColour      15

 NoDsp  Display_File    Misc\resetrip          twit "a"
	Display_File     misc\dorinfo        disgrace "A=The-Pit"
  Nodsp Xtern_Dos        outside\Pit.bat     disgrace "A"
 NoDsp  Display_File    Misc\resetrip          twit "b"
	Display_File     misc\dorinfo        disgrace "B=Trade-Wars"
  NoDsp Xtern_Dos        outside\tw.bat      disgrace "B"
 NoDsp  Display_File    Misc\resetrip          twit "e"
	Display_File     misc\dorinfo         disgrace "E=Trivia"
  NoDsp Xtern_Dos        outside\mctrivia.bat disgrace "E"
 NoDsp  Display_File    Misc\resetrip          twit "f"
	Display_File     misc\dorinfo         disgrace "F=THinker"
  NoDsp Xtern_Dos        outside\thinker.bat  disgrace "F"
 NoDsp  Display_File    Misc\resetrip          twit "d"
        Display_File     Misc\dorinfo         disgrace "D=Video-Poker"
  NoDsp Xtern_Dos        outside\videop.bat   disgrace "D"
 NoDsp  Display_File    Misc\resetrip          twit "c"
        Display_File     Misc\dorinfo         disgrace "C=Word-Scramble"
  NoDsp Xtern_Dos        outside\word.bat     disgrace "C"
 NoDsp  Display_File    Misc\resetrip          twit "g"
        Display_File     Misc\dorinfo         disgrace "G=Tut's-Revenge"
  NoDsp Xtern_Dos        outside\tut.bat      disgrace "G"
 NoDsp  Display_File    Misc\resetrip          twit "h"
        Display_File     Misc\dorinfo         disgrace "H=Yahtzee"
  NoDsp Xtern_Dos        outside\yahtzee.bat  disgrace "H"
 NoDsp  Display_File    Misc\resetrip          twit "i"
        Display_File   misc\dorinfo        disgrace "I=WarWorld"
  NoDsp Xtern_Dos      qdoor\WW.bat        disgrace "I"
   	Display_Menu     Main                 twit "1=quit"
        Display_Menu    DoorA                  twit "2=Games_A-G"
        Display_Menu     Doorh                 twit "3=Doors_H-N"
        Display_Menu     dooro                twit "4=Doors_O-S"
	Display_Menu     doort                twit "5=Doors_T-Z"
 NoDsp  Display_File    Misc\resetrip          twit "6"
        Display_Menu     Door2                twit "6=Evaluation_Games"
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"
 NoDsp  Display_File    Misc\resetrip          twit "<"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    Misc\resetrip          twit ">"
  NoDsp  Display_File    misc\ripon            twit ">"


End Menu



Menu Door2
	Title           More Games
	MenuHeader      none
	MenuColour      15
        MenuFile        misc\Eval.bbs


        Display_File   Misc\dorinfo          disgrace "B=Knights Move"
  NoDsp  Display_File    Misc\resetrip          twit "b"
  NoDsp Xtern_Dos      outside\knghtsmv.bat  disgrace "B"
        Display_File   Misc\dorinfo          disgrace "A=Yankee_Trader"
 NoDsp  Display_File    Misc\resetrip          twit "a"
  NoDsp xtern_dos      outside\yt            disgrace "a"
        Display_File   Misc\dorinfo          disgrace "C=Murder Motel"
NoDsp  Display_File    Misc\resetrip          twit "c"
  NoDsp xtern_Dos      outside\murder.bat    disgrace "C"
        Display_File   Misc\dorinfo          twit "E=Ripversi"
  NoDsp Display_File    Misc\resetrip          twit "E"
  NoDsp Xtern_Dos      qdoor\ripversi.bat           twit "E"
        Display_File   Misc\dorinfo          twit "F=Ripsweep"
  NoDsp Display_File    Misc\resetrip          twit "F"
  NoDsp Xtern_Dos      qdoor\ripsweep.bat           twit "F"
        Display_File   Misc\dorinfo          twit "G=RIP_Puzzle"
  NoDsp Display_File    Misc\resetrip          twit "G"
  NoDsp Xtern_Dos      qdoor\ripuz.bat           twit "G"
   	Display_Menu     Main                 twit "1=quit"
        Display_Menu    DoorA                  twit "2=Games_A-G"
        Display_Menu     Doorh                 twit "3=Doors_H-N"
        Display_Menu     dooro                twit "4=Doors_O-S"
	Display_Menu     doort                twit "5=Doors_T-Z"
 NoDsp  Display_File    Misc\resetrip          twit "6"
        Display_Menu     Door2                twit "6=Evaluation_Games"
  NoDsp Display_File    Misc\qklgf             twit "@-Quick Log off"
 NoDsp  Display_File    Misc\resetrip          twit "<"
 NoDsp  Display_File    misc\ripoff           twit "<"
 NoDsp  Display_File    Misc\resetrip          twit ">"
  NoDsp  Display_File    misc\ripon            twit ">"
End Menu



