PROGRAM Find_Drive;
USES DOS, CRT;

VAR
  Found, Snd                                :BOOLEAN;
  Code, X, Y                                :INTEGER;
  Drive, S                                  :STRING;
  Time2Hour, Time2Minute, Time2Second       :INTEGER;
  Hour, Minute, Second, Sec100              :WORD;


{
Variable Descriptions 
    Name         Type       Use

Global Variables:
    Found        Boolean    Has drive been found or not.
    Snd          Boolean    Will sound be played or not.
    Code         Integer    Return error Code when converting command line.
                            time to an integer.
    x            Integer    Screen Location.
    y            Integer    Screen Location.
    Drive        String     Drive to locate (Network or Floppy).
    s            String     Temporary variable for Sound parameter.
    Time2Hour    Integer    Hour to quit checking.
    Time2Minute  Integer    Minute to quit checking.
    Time2Second  Integer    Second to quit checking.
    Hour         Word       System hour.
    Minute       Word       System minute.
    Second       Word       System second.
    Sec100       Word       System 100th's of a second.

Is_It_There Function:
    Drive        Sting      Passed parameter - Drive to locate
    Info         SearchRec  System Variable

PlaySound Procedure:
    N,M          Integer    Loop Counters


}



{Play a quick tune so that the user knows the status of the drive}
PROCEDURE PlaySound;
VAR
 N, M    :INTEGER;

BEGIN
  IF Found=TRUE THEN
  BEGIN
    FOR M:=1 TO 3 DO
    FOR N:=( (M*4) DIV 2) TO (M*4) DO
    BEGIN
      SOUND(N*300);
      DELAY(50);
    END;
    NOSOUND;
  END
  ELSE
  BEGIN
    SOUND(100);
    DELAY(300);
    NOSOUND;
    DELAY(300);
    SOUND(100);
    DELAY(300);
    NOSOUND;
  END;
END;



{Check to see if something exists on the target drive}
{Return True if something exists}
FUNCTION Is_It_There(VAR Drive   :STRING) : BOOLEAN;

VAR
  Info      :SearchRec;

BEGIN
  FINDFIRST(Drive+'*.*',$3F,Info);
  IF DosError = 0 THEN
    Is_It_There:=True
  ELSE
    Is_It_There:=False;
END;



{********Main Line*******}
BEGIN
  IF ( (ParamCount=0) OR (LENGTH(ParamStr(1)) > 2) ) THEN
  BEGIN            {Instructions to user}
    CLRSCR;
    WRITE('Usage: ');
    HIGHVIDEO;
    WRITELN('FINDDRV <d:> [Time] [Sound]              (C) 1993 by Strike Development');
    normvideo;
    WRITELN('Where  <d:>    is drive to find/wait for.');
    WRITELN('       [Time]  is the amount of time to wait in Seconds.');
    WRITELN('                 - Default time is immediate.');
    WRITELN('                 - 0 waits for a key to be pressed.');
    WRITELN('       [Sound] S,s will cause FINDDRV to play a tone based on');
    WRITELN('               if the drive is found or not.');
    WRITELN;
    WRITELN('FINDDRV will return a DOS ERRORLEVEL of 100 if no drive is found,');
    WRITELN('        or an error occurs.');
    WRITELN;
    WRITELN('Error: Drive not specified.');
    HALT(100);
  END;

  {Initialize the variables}
  Time2Second:=1;
  Time2Minute:=0;
  Time2Hour:=0;

  {Get Command line variables}
  Drive:=COPY(ParamStr(1),1,2);
  Drive[1]:=UPCASE(Drive[1]);
  IF Length(Drive)=1 THEN
    Drive:=Drive+':';

  IF ParamCount > 1 THEN  {If a second parameter is passed, override default}
    VAL(ParamStr(2),Time2Second,Code);
  IF Code <> 0 THEN       {Bad time passed}
  BEGIN
    WRITELN('FINDDRV Error: Invalid time specified');
    HALT(100);
  END;

  IF ParamCount > 2 THEN {Get the Sound parameter}
    S := ParamStr(3);
    S[1] := UPCASE(S[1]);
    Snd := S='S';

  {Get the system time and compute the waiting time}
  GETTIME(Hour,Minute,Second,Sec100);
  IF Time2Second = 0 THEN
    Time2Second:=61
  ELSE
  BEGIN
    Time2Second := Second + Time2Second;

    {Seconds boundry check}
    WHILE Time2Second > 59 DO
    BEGIN
      Time2Second := Time2Second - 59;
      Time2Minute := Time2Minute + 1;
    END;

    {Minutes boundry check}
    Time2Minute:=Time2Minute+Minute;
    WHILE Time2Minute > 59 DO
    BEGIN
      Time2Minute:= Time2Minute - 59;
      Time2Hour:= Time2Hour + 1;
    END;

    {Hours boundry check}
    Time2Hour:=Time2Hour+Hour;
    IF Time2Hour > 24 THEN
      Time2Hour:= Time2Hour - 24;
  END;

  {Remember current screen position}
  X:=WHEREX;
  Y:=WHEREY;

  WRITE('Searching for Drive ',Drive);
  REPEAT
    Found := Is_It_There(Drive);
    GETTIME(Hour,Minute,Second,Sec100);
  UNTIL ( (Found) or
          (Keypressed) or
          (Hour >= Time2Hour) and (Minute >= Time2Minute) and (Second >= Time2Second) ) ;

  GOTOXY(X,Y);
  IF Found THEN
  BEGIN
    WRITELN('Drive ',Drive,' found!            ');
    IF Snd THEN PlaySound;
  END
  ELSE
  BEGIN
    WRITELN('Drive ',Drive,' was not found!    ');
    IF Snd THEN PlaySound;
    HALT(100);
  END
END.