/***********************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedcopy.c_v   1.4   26 Mar 1992 10:28:30   fhdodj  $
*
*$config$="/K! /L/* /R* /Mgedcopy.c"
*!global paths!
*   gedcom\library\gedcopy.c
*   gedcom\all\gedcopy.c
*!end!
*
*   FILE NAME: GEDCOPY.C
*
*   DESCRIPTION:
*       This file contains functions for copying records or parts of records.
*
*   ROUTINES:
*
*
*$Log:   J:/gedcom/gedlib/vcs/gedcopy.c_v  $
 *
 *    Rev 1.4   26 Mar 1992 10:28:30   fhdodj
 * Made a macro that does most of the ged_clone_node function to speed up 
 * ged_copy_node.
 * 
 *    Rev 1.3   21 Oct 1991 13:11:32   fhdodj
 * Changed char to byte.
 * 
 *    Rev 1.2   28 Jun 1991 11:41:56   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.1   04 Feb 1991 08:50:12   odj
 * Fixed bug in ged_make_path() so it now returns NULL when we run out of memory
 * instead of returning partial trees.
 * 
 *    Rev 1.0   20 Dec 1990 08:58:40   odj
 * Initial revision.
***********************************************************************/

#include "gedcom.h"
//NODE * copy_clean_tree(NODE *);
//NODE * clean_up_tree(NODE *, NODE *());

/********************************************************************
*!name!
*    GED_CLONE_NODE()
*!1!
*
*        NAME: GED_CLONE_NODE
*
*        DESCRIPTION:
*            Macro used by ged_clone_node, and ged_copy_node.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
#define GED_CLONE_NODE(newLine, child, sibling, newNode)                \
        /*!end!*/                                                       \
        /* allocate memory for the node from the current pool      */   \
        if (newNode = (NODE *) (*(pool->ged_alloc_pool))                \
                           ((unsigned long)pool->nodeSize))             \
            {                                                           \
            /* fill the node, and make all connections between nodes */ \
            newNode->line = newLine;                                    \
            newNode->length = strlen(newLine);                          \
            newNode->child = child;                                     \
            newNode->sibling = sibling;                                 \
            while (child)                                               \
                {                                                       \
                child->parent = newNode;                                \
                child = child->sibling;                                 \
                }                                                       \
	    newNode->parent = NULL;                                     \
	    }

/********************************************************************
*!name!
*    ged_clone_node()
*!1!
*
*        NAME: ged_clone_node
*
*        DESCRIPTION:
*            Given the contents, child and sibling of the node, this
*            function allocates memory for a new node and connects
*            it to the tree. Does not make a copy of line, but uses
*            the one passed to it.
*
*        WARNING!!! Any changes made to the line will not only affect
*        this node, but all other nodes pointing to it. If you are
*        not sure if it might be used somewhere else, use copyNode
*        instead.
*
*        RETURN VALUE:
*            Returns the new node, or NULL if error.
*
*        CALLS: ged_alloc_pool, ged_get_pool
*
*        CALLED BY: ged_clone_tree, ged_duplicate_tree, ged_copy_node
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_clone_node(line, child, sibling)
    byte *line;
    register NODE *child;
    NODE *sibling;
    {                        /*!end!*/
    POOL *pool;
    register NODE *newNode;

        if (!(pool = ged_get_pool()))
            return(NULL);
        GED_CLONE_NODE(line, child, sibling, newNode)
        return(newNode);
    }
/**/
/********************************************************************
*!name!
*    ged_clone_tree()
*!1!
*
*        NAME: ged_clone_tree
*
*        DESCRIPTION:
*            makes a copy of the input tree without making a copy of
*            the contents.
*
*        RETURN VALUE:
*            The root node of the new tree, or NULL if error.
*
*        WARNING!!! Any changes made to the line will not only affect
*        the nodes in the new tree, but all other nodes pointing to
*        it. If you are not sure if it might be used somewhere else,
*        use copyTree instead.
*
*        CALLS: ged_clone_node, ged_duplicate_tree
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_clone_tree(tree)
    NODE *tree;
    {                        /*!end!*/

        return(ged_duplicate_tree(tree, ged_clone_node));
    }

/**/
/********************************************************************
*!name!
*    ged_copy_node()
*!1!
*
*        NAME: ged_copy_node
*
*        DESCRIPTION:
*            Given the contents, child and sibling of the node, this
*            function allocates the memory for a new node and
*            connects it in the tree. Makes a seperate copy of line
*            for use in the node.
*
*        RETURN VALUE:
*            Returns the new node, or NULL if error.
*
*        CALLS: ged_alloc_pool, ged_get_pool, ged_clone_node
*
*        CALLED BY: ged_copy_tree, ged_duplicate_tree
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_copy_node(line, child, sibling)
    byte *line;
    NODE *child;
    NODE *sibling;
    {                        /*!end!*/
    POOL *pool;
    byte *newLine;
    register NODE *newNode;
    int lineLen = strlen(line);

        if (!(pool = ged_get_pool()))
            return(NULL);
        if (!(newLine = (byte *)(*(pool->ged_alloc_pool))
                                ((unsigned long)lineLen+1)))
	    return(NULL);        /* couldn't allocate the memory   */
        memcpy(newLine, line, lineLen);
        newLine[lineLen] = '\0';
        GED_CLONE_NODE(newLine, child, sibling, newNode)
        return(newNode);
    }

/********************************************************************
*!name!
*    ged_copy_tree()
*!1!
*
*        NAME: ged_copy_tree
*
*        DESCRIPTION:
*            makes a copy of the input tree.
*
*        RETURN VALUE:
*            The root node of the new tree, or NULL if error.
*
*        CALLS: ged_duplicate_tree, ged_copy_node
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_copy_tree(tree)
    NODE *tree;
    {                        /*!end!*/

	return(ged_duplicate_tree(tree, ged_copy_node));
    }

/**/
/********************************************************************
*!name!
*    ged_duplicate_tree()
*!1!
*
*        NAME: ged_duplicate_tree
*
*        DESCRIPTION:
*            makes a duplicate of the input tree with the input
*            function.
*
*        RETURN VALUE:
*            The root node of the new tree, or NULL if error.
*
*        CALLS: input function funPtr, ged_connect_sibling,
*               ged_connect_child
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_duplicate_tree(tree, funPtr)
    register NODE *tree;
#ifdef NON_ANSI
    NODE *(*funPtr)();
#else
    NODE *(*funPtr)(byte *, NODE *, NODE *);
#endif
    {                        /*!end!*/
    register NODE *node = NULL;
    NODE *root    = tree,
         *dupRoot = NULL;

        if (tree)
            dupRoot = node = (*funPtr)(tree->line, NULL, NULL);
        if (!node)
            return(NULL);
        while (tree)
            {
            while (tree->child)
		{
                tree = tree->child;
                node = ged_connect_child(node,
                                        (*funPtr)(tree->line, NULL, NULL), -1);
                node = ged_get_last_sibling(node);
                if (!node)
                    return(NULL);
		}
            while (!tree->sibling && (tree != root))
                {
                node = node->parent;
                tree = tree->parent;
                }
            if (tree == root)
                tree = NULL;
            if (tree)
                tree = tree->sibling;
            if (tree)
		{
                node = ged_connect_sibling(node,
                                           (*funPtr)(tree->line, NULL, NULL),
                                           -1);
                node = ged_get_last_sibling(node);
                if (!node)
                    return(NULL);
		}
            }
        return(dupRoot);
    }
/**/
/********************************************************************
*!name!
*    ged_make_path()
*!1!
*
*        NAME: ged_make_path
*
*        DESCRIPTION:
*            Given an null terminated input string containing tags
*            separated by white space, a path will be returned
*            consisting of the tags.
*
*        RETURN VALUE:
*            Returns the node which is the root of the new path,
*            or NULL if memory was not available, or invalid input
*            was given.
*
*        CALLS: ged_copy_node, ged_connect_child
*
*        CALLED BY: ged_ask_string
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
********************************************************************/
NODE * ged_make_path(path)
    register byte *path;
    {                        /*!end!*/
    NODE *root,
         *node,
         *temp_node;

        if (!path)
           return(NULL);
        node = root = ged_copy_node(path, NULL, NULL);
        if (!node)        /*  We are out of memory, so return NULL */
            return(NULL);
        ged_set_value(node, "");
        while(*path)
	   {
           while (!isspace(*path) && (*path != '\0'))
               path++;
           while (isspace(*path))
	       path++;
           if (*path)
               {
	       temp_node = ged_copy_node(path, NULL, NULL);
               if (!temp_node)    /*  We are out of memory, so return NULL */
                   return(NULL);  
               node = ged_connect_child(node, temp_node, -1);
	       ged_set_value(node, "");
	       }
	    }
	return(root);
    }
/********************************************************
 *  NAME: clean_up_tree
 *       this routine is like duplicate_tree except it
 *       checks the line for + or - directives and ignores
 *       those nodes.
 *
 **********************************************************/
NODE * clean_up_tree(tree, funPtr)
    register NODE *tree;
    NODE *(*funPtr)(byte *, NODE *, NODE *);
    {                        /*!end!*/
    register NODE *node = NULL;
    NODE *root    = tree,
	 *firstChild,
	 *dupRoot = NULL;
    int needChild = 0;
	if (tree)
	    dupRoot = node = (*funPtr)(tree->line, NULL, NULL);
	if (!node)
	    return(NULL);
	while (tree)
	    {
	    while (tree->child)
		{
		firstChild = tree->child;
		tree = tree->child;
		if ((*(tree->line) != '-') && (*(tree->line) != '+'))
		   {
		   node = ged_connect_child(node,
					(*funPtr)(tree->line, NULL, NULL), -1);
		   if (!node)
		       return(NULL);
		   node = ged_get_last_sibling(node);
		   firstChild - tree->child;
		   }
		else
		   if (tree == firstChild)
		       needChild = 1;
		}
	    while (!tree->sibling && (tree != root))
		{
		if ((*(tree->line) != '-') && (*(tree->line) != '+'))
		   {
		   node = node->parent;
		   }
		   tree = tree->parent;
		   needChild = 0;
		}
	    if (tree == root)
		tree = NULL;
	    if (tree)
		tree = tree->sibling;
	    if (tree && (*(tree->line) != '-') && (*(tree->line) != '+'))
		{
		if (!needChild)
		   {
		   node = ged_connect_sibling(node,
					   (*funPtr)(tree->line, NULL, NULL),
					   -1);
		   if (!node)
		       return(NULL);
		   node = ged_get_last_sibling(node);
		   }
		else
		   {
		   needChild = 0;
		   node = ged_connect_child(node,
					(*funPtr)(tree->line, NULL, NULL), -1);
		   if (!node)
		       return(NULL);
		   node = ged_get_last_sibling(node);
		   }
		}
	    }
	return(dupRoot);
    }
/**/
/*****************************************************
 * Name:  copy_clean_tree
 *        calls cleans_tree
 *
 *******************************************************/
NODE * copy_clean_tree(tree)
    NODE *tree;
    {                        /*!end!*/

	return(clean_up_tree(tree, ged_copy_node));
    }

/**/

