/****************************************************************************
 * 
 *      Copyright (c) 1991  Corporation of the President of 
 *                          the CHURCH of JESUS CHRIST of LATTER-DAY SAINTS.
 * 
 *      All rights reserved.  Unauthorized reproduction of this software is
 *      prohibited and is in violaton of United States copyright laws.
 * 
 ****************************************************************************/
/****************************************************************************
 *
 * FILE: GEDHSTAT.H
 *
 * MODIFICATION HISTORY:
 * ----------------------------------------------------------------------
 * |  Date           | Who | Comments
 * ----------------------------------------------------------------------
 * | 09/12/91 09:58am| LAM | Code only used for internal hash functions moved here
 * ----------------------------------------------------------------------
 ****************************************************************************/


#ifdef CYBER
#include "fcntl_h"
#include <sys.types_h>
#include <sys.stat_h>
#define O_BINARY 0
#else

#include "fcntl.h"
#include "io.h"
#include <sys\types.h>
#include <sys\stat.h>
#endif

/* Used by gedhash_create_xref() to store the seek pos. & ext of a gedcom record */

typedef struct  
        {
        long seek_position;
  int ged_ext; /* If gedcom file extention is ".GED" this is -1. If ".G00" this is 0, etc. */
        } SEEK;

typedef enum RCRDTYPE /* The record type of a disk-based hash table record */
        {
        EOLIST, GARBAGE, EOBLOCK,MATCHED, UNMATCHED
        } READSTATUS;   /* Record types.  Must remain in this order. */


/* Uses GED_ALLOC_POOL and updates htab->memoryLeft.
   Parameter: HASH_TAB htab, unsigned long size */
#define ALLOCMEM(htab, size) GED_ALLOC_POOL(size); htab->memoryLeft -= size
/* Returns size of header on disk--based hash table */
#define HEADER_SIZ (15 + sizeof(HASH_TAB) )

#ifdef NON_ANSI
long filelength( int handle );
#endif
void           gedh_dCopy(KVDISK *kv, char *key, KSIZ keyLen, char *val, LEN valLen);
int            gedh_delete_disk(HASH_TAB *htab, char * key, KSIZ keyLen);
static void    gedh_diskSetup(HASH_TAB *htab);
void *         gedh_dlookup(HASH_TAB *htab, void *key, KSIZ keyLen, void *val, LEN *valLen, int *status);
void           gedh_floppy_prompt(HASH_TAB *htab, int ged_ext);           
static void    gedh_getRecordType(void);
HSIZ            gedh_hash(char *key, KSIZ keyLen, HSIZ h);
int            gedh_insertDisk(HASH_TAB *htab, char *key, KSIZ keyLen, char *val, LEN valLen);
static int     gedh_insertMem(HASH_TAB *htab, char *key, KSIZ keyLen, char *val, LEN valLen); 
int            gedh_iterate_disk(HASH_TAB *htab, char *key, KSIZ *keyLen, char *val, LEN *valLen);
void           gedh_kvCopy(KVPAIR *kv, char *key, KSIZ keyLen, char *val, LEN valLen);         
void           gedh_kvGet(KVDISK *kv, char **dkey, char **dval);                                  
KVDISK  *      gedh_kvnext(KVDISK *kv);                                                       
long           gedh_ptrHash(HASH_TAB *htab, char *key); /* GEDCOM file */                      
static NODE    *gedh_recordSeek(NODE *, char *, HASH_TAB *, FILE *);                           
       int     gedh_save_htab_struct(HASH_TAB *htab);                                      
static void    gedh_strCopy(char *, char *, LEN); /* I use this because the 3rd parameter must be LEN */  
void           gedh_write_block(void);
