/****************************************************************************
 * 
 *      Copyright (c) 1991  Corporation of the President of 
 *                          the CHURCH of JESUS CHRIST of LATTER-DAY SAINTS.
 * 
 *      All rights reserved.  Unauthorized reproduction of this software is
 *      prohibited and is in violaton of United States copyright laws.
 * 
 ****************************************************************************/
/****************************************************************************
 *
 * FILE: GEDPROC.H
 *
 * MODIFICATION HISTORY:
 * ----------------------------------------------------------------------
 * |  Date           | Who | Comments
 * ----------------------------------------------------------------------
 * | Dec 90          | LAM | Code Written by Larry A. Maddocks           
 * ----------------------------------------------------------------------
 ****************************************************************************/

#if !defined(TLIMIT)
#define TLIMIT (unsigned long) 20000
#endif
#define GLIMIT (unsigned long)5000
#if !defined(GLIMIT)
#define GLIMIT (unsigned long) 2500
#endif
#define FUNC_NAME_SIZ 30
#define MAX_FNCS 30
#define DFLT_ERR 99 /* the default value for the status parameter in ged_error*/

#if !defined(BYTE)
#define BYTE
typedef unsigned char byte;
#endif

#ifdef CYBER
#if !defined(NON_ANSI)
#define NON_ANSI
#endif

#endif

#ifdef NON_ANSI
#if !defined(CDECL)
#define CDECL
#endif
void ged_set_error_handler();
NODE    *ged_load_grammar();
NODE    *huntForTags();
NODE    *huntForMoreTags();
NODE    *read_tree();
int     ged_traverse();
int     ged_traverse_grammar();
int     traverse_solo();
int     ged_process();
int     ged_error();
int ged_define_semantic();
int get_func();
int preOrPostProcess();

#else

#define CDECL cdecl
int     ged_define_semantic(byte *funcName, int(*funcPointer)(NODE *, byte *));
int     get_func(char *);
NODE  * ged_load_grammar(FILE *);
int     ged_process(FILE *fg, FILE *ft);
void    ged_set_error_handler(int (*error_handler)(int, NODE *));
int     ged_traverse(NODE *, NODE *);
int     ged_traverse_grammar(NODE *, NODE *);
NODE    *huntForMoreTags(NODE *, NODE *);
NODE    *huntForTags(NODE *, NODE *);
POOL *  ged_open_pool(unsigned size, unsigned nodesize);
int     preOrPostProcess(NODE *, NODE *, char);
NODE    *read_tree(FILE *, short *, unsigned long, int, byte *, int);
int     traverse_solo(NODE *);

#endif
