/******************************************************************************
*$Header:   J:/gedcom/gedlib/vcs/gedrfn.c_v   1.4   21 Oct 1991 11:22:58   fhdodj  $
*   FILE NAME: .C
*
*$config$="/K! /L/* /R* /Mgedrfn.c"
*!global paths!
*   gedcom\library\gedrfn.c
*   gedcom\all\gedrfn.c
*!end!
*
*
*   DESCRIPTION:
*       This file contains functions for converting longs to base30 and back.
*
*   ROUTINES:
*      byte *ged_long_to_base30(long, byte [], int)
*      long  ged_base30_to_long(byte [])
*
*
*$Log:   J:/gedcom/gedlib/vcs/gedrfn.c_v  $
 * 
 *    Rev 1.4   21 Oct 1991 11:22:58   fhdodj
 * Changed char to byte.
 * 
 *    Rev 1.3   28 Jun 1991 15:00:32   fhdkrf
 * Added keywords for PolyDoc
 * 
 *    Rev 1.2   17 Jun 1991 16:42:24   odj
 * moved ged_strupr and ged_strrev to file ged_misc.  Otherwise, minor
 * formatting changes.
 * 
 *    Rev 1.1   28 Mar 1991 11:14:42   odj
 * functions strupr and strrev dont exist on the CYBER, so I added ged_strupr
 * and ged_strrev.  Need to put #define NON_ANSI around these.
 *
 *    Rev 1.0   27 Mar 1991 17:56:02   odj
 * Initial revision.
******************************************************************************/

#include "gedcom.h"

#define TRUE 1

/******************************************************************************
*!name!
*    ged_long_to_base30()
*!1!
*
*   NAME
*       ged_long_to_base30
*
*   DESCRIPTION
*       The ged_long_to_base30 function converts the long N to the base 30 number.
*
*   CALLS: !/see()!
*
*!0!
*SYNOPSIS:
*
*!-1!
******************************************************************************/
byte *ged_long_to_base30(conv, num, include_dash)
    long conv;          /* the long to convert to an base30 number. */
    byte num[];         /* the string containing the generated base30 number */
    int include_dash;   /* TRUE=put dash in base30 number, FALSE=don't. */
    {			/*!end!*/
    long check, digit, lconv, numdigits, place, temprfn;
    static byte base30[] =
        {
        '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
        'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Z'
        };


        temprfn = lconv = conv;
        for (numdigits=1; (temprfn /= 30) > 0; ++numdigits)
            ;
        ++numdigits;
        place = check = 0;
        do
            {
            digit = lconv % 30L;
            num[place++] = base30[digit];
            check += ((numdigits-place) * digit);
            }
        while ((lconv /= 30L) > 0);

        num[place] = '\0';
#ifdef NON_ANSI
        ged_strrev(num);
#else
        strrev(num);
#endif
        num[place++] = base30[check % 29];
        num[place] = '\0';
        if (include_dash == TRUE)
            {
            for (place=strlen(num); place > 3; --place)
                num[place+1] = num[place];
            num[place+1] = '-';
            }
        return(num);
    }

/**/
/******************************************************************************
*
*   NAME
*       ged_base30_to_long
*
*   DESCRIPTION
*       The ged_base30_to_long function converts the base 30 Numver to base 10
*       and returns the converted value.  If an error occurred, -1 is for an
*       invalid digit in the number, -2 is returned for an invalid check
*       digit, -3 is returned for a numver that is too low.
*
******************************************************************************/
long ged_base30_to_long(num)
    byte num[]; /* the string containing the number to convert. */
    {
    int x, y;
    long check, digit, conv, place;
    byte tempnum[20];
    static byte base30[] =
        {
        '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
        'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Z'
        };

        strcpy(tempnum, num);
#ifdef NON_ANSI
        ged_strupr(tempnum);
#else
        strupr(tempnum);
#endif
        for (x=0, y=0; tempnum[x] != '\0'; ++x)
            {
            if (tempnum[x] != '-')
                tempnum[y++] = tempnum[x];
            }
        tempnum[y] = '\0';
        check = conv = 0L;
        for (place=1L; place <= (long)(strlen(tempnum) - 1L); ++place)
            {
            for (digit=0; digit < 30; ++digit)
                {
                if (tempnum[place-1] == base30[digit])
                    break;
                }
            if (digit == 30)
                return(-1);
            conv = (conv * 30) + digit;
            check = check + (place * digit);
        }

        if (tempnum[strlen(tempnum)-1] != base30[check % 29L])
            return(-2);
        else
            return(conv);
    }
