/****************************************************************************
 *      (c) 1991    Corporation of the President of the Church of Jesus Christ
 *      Copyright   of Latter-day Saints.
 *      All rights reserved.  Unauthorized reproduction of this software is
 *      prohibited and is in violaton of United States copyright laws.
 ****************************************************************************/

/*****************************************************************************
*
*   FILE NAME:          GEDUTIL.C
*
*   DESCRIPTION:  Utilities for the GEDCOM library
*
*****************************************************************************/

#include "gedcom.h"
#include "gedutil.h"

/****************************************************************************
 *
 * NAME: ged_open_pool
 *
 * DESCRIPTION: Opens a pool and prints an error message if unsuccessfull.
 *              Returns pointer to pool.
 *
 * PARAMETERS:
 *
 * size:  input: Size of pool to be created
 *
 * nodesize: input: Size of node, or 0 if not using nodes in this pool.
 *
 ****************************************************************************/
POOL *ged_open_pool( size, nodesize)
  unsigned size;
  unsigned nodesize;
  {
  POOL *pool  = ged_create_pool(size, nodesize);

  if (!pool)
    ged_error(2, (NODE *)NULL); /* Could not create a memory pool. */
  return pool;
  }

/****************************************************************************
 * NAME: read_tree
 * DESCRIPTION:  Reads in a tree from a GEDCOM file. Returns the pointer to
 *               tree.  If failed, sends an error message and exits.
 *               uses global read_partial switch to determine whether to
 *               read partial tree for the UDE records.
 * CALLS:        ged_read_tree, GED_ALLOC_POOL
 * CALLED BY:    ged_load_grammar
 ***************************************************************************/
NODE * read_tree(fg, status, limit, endLevel, endTag, partial)
  FILE *fg;
  short *status;
  unsigned long limit;
  int endLevel;
  byte *endTag;
  int partial;
  {
  char *dataBuf;
  NODE *node;

  if (partial > 0)
 {
  if ((!(dataBuf = GED_ALLOC_POOL(limit)))
    || ((node = (NODE *)ged_read_partial_tree(fg, dataBuf, limit, status, endLevel, endTag))==(NODE *)NULL)
    || (*status == REC_TOO_LONG))
    {
    ged_error(304, (NODE *)NULL);
    return((NODE *)NULL);
    }
 }
 else
 {
  if ((!(dataBuf = GED_ALLOC_POOL(limit)))
    || ((node = ged_read_tree(fg, dataBuf, limit, status))==(NODE *)NULL)
    || (*status == REC_TOO_LONG))
    {
    ged_error(304, (NODE *)NULL);
    return((NODE *)NULL);
    }
  }
  return(node);
  } /* End read tree */

