/********************************************************************/
/*                                                                  */
/* Kortspill fr OS/2                                               */
/*                                                                  */
/* Norsk Installasjon, Version 1.5                                  */
/*                                                                  */
/* Copyright 1994 (C) by Felix Maschek, Hamburg                     */
/*                                                                  */
/* EMail: CompuServe 100120,1370                                    */
/*                   OS2SHARE                                       */
/*                                                                  */
/********************************************************************/

'@Echo Off'

/* load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisation */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installasjon av CARDS 1.5...'
Say ''


/* Check... */

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: CARDS.EXE ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( "PICTURES.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: PICTURES.DLL ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( "CARDSNOR.HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: CARDSNOR.HLP ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( "CARDSNOR.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: CARDSNOR.DLL ikke funnet!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */
 
Say 'Vennligst skriv in hvor du nsker CARDS installert'
Say '  Enter gir: C:\CARDS: '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* create target-path. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEIL: Klarer ikke  opprette ' Directory '.'
    Signal DONE
    End
  End
Say '';

/* Create desktop object */

Folder = '<WP_DESKTOP>'

/* Install */

Say 'Kopierer CARDS til ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "PICTURES.DLL" Directory"\PICTURES.DLL" '1>NUL'
Copy "CARDSGER.HLP" Directory"\CARDSGER.HLP" '1>NUL'
Copy "CARDSGER.DLL" Directory"\CARDSGER.DLL" '1>NUL'
Copy "CARDSENG.HLP" Directory"\CARDSENG.HLP" '1>NUL'
Copy "CARDSENG.DLL" Directory"\CARDSENG.DLL" '1>NUL'
Copy "CARDSNOR.HLP" Directory"\CARDSNOR.HLP" '1>NUL'
Copy "CARDSNOR.DLL" Directory"\CARDSNOR.DLL" '1>NUL'
Copy "CARDSSWE.HLP" Directory"\CARDSSWE.HLP" '1>NUL'
Copy "CARDSSWE.DLL" Directory"\CARDSSWE.DLL" '1>NUL'

Say 'Oppretter ikon p arbeidsomrdet...'
Type = 'WPProgram'
Title = 'Kortspill'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;PARAMETERS=CARDSNOR;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Ikon opprettet! Klar til bruk.'
Else             
  Say 'FEIL: Klarte ikke  opprette ikon!'

Signal DONE

FAILURE:
Say 'En feil oppstod under kjring av REXX.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxerror.'
Signal DONE

DONE:
Exit
