/********************************************************************/
/*                                                                  */
/* Kortspel fr OS/2                                                */
/*                                                                  */
/* Svensk Installation, Version 1.5                                 */
/*                                                                  */
/* Copyright 1994 (C) by Felix Maschek, Hamburg                     */
/*                                                                  */
/* EMail: CompuServe 100120,1370                                    */
/*                   OS2SHARE                                       */
/*                                                                  */
/********************************************************************/

'@Echo Off'

/* ladda REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initiering */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation av CARDS 1.5...'
Say ''


/* Kontrollera... */

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEL: CARDS.EXE finns inte!'
  Signal DONE
  End

Result = SysFileTree( "PICTURES.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEL: PICTURES.DLL finns inte!'
  Signal DONE
  End

Result = SysFileTree( "CARDSSWE.HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEL: CARDSSWE.HLP finns inte!'
  Signal DONE
  End

Result = SysFileTree( "CARDSSWE.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEL: CARDSSWE.DLL finns inte!'
  Signal DONE
  End

/* Frga efter mlbibliotek. */

Say 'Ange fullstndig skvg fr CARDS'
Say '  Standard: C:\CARDS: '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* Skapa mlbibliotek. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEL: Kan inte skapa skvgen.'
    Signal DONE
    End
  End
Say '';

/* Skapa objekt p skrivbordet */

Folder = '<WP_DESKTOP>'

/* Installera */

Say 'Kopierar CARDS till ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "PICTURES.DLL" Directory"\PICTURES.DLL" '1>NUL'
Copy "CARDSGER.HLP" Directory"\CARDSGER.HLP" '1>NUL'
Copy "CARDSGER.DLL" Directory"\CARDSGER.DLL" '1>NUL'
Copy "CARDSENG.HLP" Directory"\CARDSENG.HLP" '1>NUL'
Copy "CARDSENG.DLL" Directory"\CARDSENG.DLL" '1>NUL'
Copy "CARDSNOR.HLP" Directory"\CARDSNOR.HLP" '1>NUL'
Copy "CARDSNOR.DLL" Directory"\CARDSNOR.DLL" '1>NUL'
Copy "CARDSSWE.HLP" Directory"\CARDSSWE.HLP" '1>NUL'
Copy "CARDSSWE.DLL" Directory"\CARDSSWE.DLL" '1>NUL'

Say 'Skapar objekt p skrivbordet...'
Type = 'WPProgram'
Title = 'Kortspel'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;PARAMETERS=CARDSSWE;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objektet har skapats!  Klart.'
Else
  Say 'FEL: Kan inte skapa objekt p skrivbordet!'

Signal DONE

FAILURE:
Say 'Fel i exekvering av REXX.'
Signal DONE

HALT:
Say 'REXX-Stopp.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxfel.'
Signal DONE

DONE:
Exit
