/***************************************************************************\
          (c) 1993, Simple Software, Inc., All rights reserved

	MFCWIDG.H
	
	Class declarations for WinWidgets MFC wrapper classes.

\***************************************************************************/

#ifndef _MFCWIDG_H
#define _MFCWIDG_H
                     
    
#ifdef _MFCWINT    
#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions (including VB)
#include <afxdb.h>          // MFC database classes
#endif
       
#include <widgets.h>

#define _WRAPNAME(name) C##name 
#define _WRAP_INLINE inline
#define _WRAP_SM(msg, wParam, lParam) ::SendMessage(m_hWnd,msg,wParam,lParam) 

#ifdef _AFX
#define HWindow this->GetSafeHwnd()
#endif

      

//CHButt

class  CHButt : public CWnd
{
	DECLARE_DYNAMIC(CHButt)

// Constructors
public:
	CHButt(void) ;
	BOOL Create(LPCSTR lpszCaption, const RECT& rect, 
							CWnd* pParentWnd, UINT nID, 
							DWORD dwStyle=(WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_PUSHBUTTON))   ;

// Attributes -- Message Interface             
	int GetPAlign(void)  ;
	CGdiObject *GetPic(int iIndex=0)  ;
	CBrush * GetBkgndBrush(void) ;
	int GetCount(void) ;
	CFont *GetFont(void) ;
	COLORREF GetMaskColor (void) ;
	int GetRAlign(void) ;
	HANDLE GetSound(void) ;
	int GetState(void) ;
	int GetStateCount(void) ;
	int GetTAlign(void) ;
	int GetText(LPSTR lpBuf, int iMaxBytes=-1) ;
	COLORREF GetTextColor(void) ;
	CPalette *GetPalette(void);
	BOOL IsPressed(void) ;
	void Press(BOOL bPress) ;
	void SetPAlign(int iAlign) ;
	CGdiObject *SetPic (CGdiObject *pPic, WORD wType, int iIndex=0) ;
	CBrush *SetBkgndBrush(CBrush *pBkgnd) ;
	CFont *SetFont(CFont *pFont, BOOL bRedraw=TRUE) ;
	void SetMaskColor (COLORREF clrMask) ;
	void SetRAlign(int iAlign) ;
	HANDLE SetSound(HANDLE hSnd) ;
	int	SetState(int iState, BOOL bRedraw = TRUE) ;
	void SetTAlign(int iAlign) ;
	void SetText(LPSTR lpszText) ;
	void SetTextColor(COLORREF clrText) ;
                           
  BOOL Attach(HWND hParent, int nID) ; 
	BOOL Attach(HWND hWnd) ;
  BOOL AttachToVBX(HWND hParent, int nID) ; 
	BOOL AttachToVBX(HWND hWnd) ; 
	HWND Detach(void); 
	HWND GetSafeHwnd(void);
  

// Implementation
public:
	virtual _export ~CHButt() ;
protected:                         
	virtual WNDPROC* GetSuperWndProcAddr();
	virtual BOOL OnChildNotify(UINT, WPARAM, LPARAM, LRESULT*);
	
private:
	BOOL m_bVBX;
};   


//Derived button classes

class  CHBCheck : public CHButt
{ 
	DECLARE_DYNAMIC(CHBCheck) 
	
public:
	CHBCheck(void) ;
	virtual _export ~CHBCheck() ;
	BOOL Create(LPCSTR lpszCaption, const RECT& rect, 
							CWnd* pParentWnd, UINT nID, 
							DWORD dwStyle=(WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_CHECKBOX))   ;	  
	
	int GetData(LPVOID lpData);
	int GetDataSize(void);
	int SetData(LPVOID lpBuf);
	int SetDataLink(BOOL bUseIndex, LPVOID lpBuf=NULL);

};  
     
     
class  CHB3State : public CHBCheck
{ 
	DECLARE_DYNAMIC(CHB3State) 
	
public:
	CHB3State(void) ;
	virtual _export ~CHB3State() ;
	BOOL Create(LPCSTR lpszCaption, const RECT& rect, 
							CWnd* pParentWnd, UINT nID, 
							DWORD dwStyle=(WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_3STATE))   ;	  
	
}; 
      
      
class  CHBDefault : public CHButt
{ 
	DECLARE_DYNAMIC(CHBDefault) 
	
public:
	CHBDefault(void) ;
	virtual _export ~CHBDefault() ;
	BOOL Create(LPCSTR lpszCaption, const RECT& rect, 
							CWnd* pParentWnd, UINT nID, 
							DWORD dwStyle=(WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_DEFPUSHBUTTON))   ;	  
	
};  


class  CHBRadio : public CHBCheck
{ 
	DECLARE_DYNAMIC(CHBRadio) 
	
public:
	CHBRadio(void) ;
	virtual _export ~CHBRadio() ;
	BOOL Create(LPCSTR lpszCaption, const RECT& rect, 
							CWnd* pParentWnd, UINT nID, 
							DWORD dwStyle=(WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_RADIOBUTTON))   ;
							
	BOOL IsLastInGroup(void);								  
	
}; 


      
 
//CHComb

class  CHComb : public CWnd
{
	DECLARE_DYNAMIC(CHComb)

// Constructors
public:
	CHComb(void) ;
	BOOL Create(LPCSTR lpszCaption, DWORD dwStyle,
				const RECT& rect, CWnd* pParentWnd, UINT nID)   ;
	virtual void Initialize();

// Attributes -- Message/Method Interface             
	int AddItem(LPVOID lpData)   ;
	int AddItemEx(LPVOID lpData, LPVOID lpCode)   ;
	int AddItems(int iCount, LPVOID lpData)   ;
	int AddItemsEx(int iCount, LPVOID lpData, LPVOID lpCode)   ;
	int DeleteItem(int iIndex)   ;
	BOOL DeleteItems(WORD wSearch, int iCount, LPVOID lpInfo)   ; 
	BOOL EmptyList(void)   ;
	int FindCode(int iStart, LPVOID lpCode)   ;
	int FindData(int iStart, LPVOID lpData)   ;
	BOOL GetCode(int iIndex, LPVOID lpCode)   ;
	BOOL GetData(int iIndex, LPVOID lpData)   ;
	int GetItems(int iCount, WORD wReturn, LPVOID lpReturn, WORD wSearch, LPVOID lpInfo)   ;
	int InsertItem(int iPos, LPVOID lpData)   ;
	int InsertItemEx(int iPos, LPVOID lpData, LPVOID lpCode)   ;
	int InsertItems(int iPos, int iCount, LPVOID lpData)   ;
	int InsertItemsEx(int iPos, int iCount, LPVOID lpData, LPVOID lpCode)   ;
	BOOL IsSelected(int iIndex)   ;
	BOOL SelectCode(LPVOID lpCode)   ;
	BOOL SelectData(LPVOID lpData)   ;
	BOOL SelectItems(WORD wAction, WORD wSearch, int iCount, LPVOID lpInfo)   ;
	BOOL SetCode(int iIndex, LPVOID lpCode)   ;
	BOOL SetCodeLink(LPVOID lpCode, BOOL bSelect = TRUE)   ;
	BOOL SetDataLink(LPVOID lpData, BOOL bSelect = TRUE)   ;


	/*
		HComb Message Wrappers
	*/
	
	CBrush *GetBkgndBrush(void)   ;
	BOOL HasChanged(void)   ;
	CFont *GetFont(void)   ;
	void GetFormat(LPSTR lpFormat, int iMaxLen=-1)   ;
	CBrush *GetHiliteBrush(void)   ;
	CBrush *SetBkgndBrush(CBrush *pBknd, BOOL bRedraw=TRUE)   ;
	BOOL SetChanged(BOOL bChanged)   ;
	CFont *SetFont(CFont *pFont, BOOL bRedraw=TRUE)   ;
	int SetFormat(LPSTR lpFormat, BOOL bRedraw=TRUE)   ;
	CBrush *SetHiliteBrush(CBrush *pBrush, BOOL bRedraw=TRUE)   ;
	int SetTabStops(int iNum, LPINT lpTStops)   ;  
	int GetDropHeight(void);
	BOOL SetDropHeight(int iNewHeight);    
	void SetTextColor(COLORREF crNew, BOOL bNeg=FALSE); 
	COLORREF GetTextColor(BOOL bNeg=FALSE);

	int GetEditData(LPVOID lpData, int iMaxLen=-1)   ;
	int SetEditData(LPVOID lpData)   ;
	LONG GetEditSel(void)   ;
	void SetEditSel(int iAnchor, int iExtent)   ;
	int GetEditText(LPSTR lpText, int iMaxLen=-1)   ;
	int GetEditTextLen(void)   ;
	void SetMaxTextLen(int iLen)   ;
	void SetOverwrite(BOOL bOverwrite)   ;
  void Update(BOOL bUpdateData)   ;  
  int GetEditScrollPos(void);
	int SetEditScrollPos(int iScroll, BOOL bRedraw);

	int FindString(int iStart, LPSTR lpString); 	
 	int SelectString(int iStart, LPSTR lpString);

	char GetCodeClass(void)   ;
	LPVOID GetCodeLink(void)   ;
	int GetCodeSize(int iIndex=-1)   ;
	int GetCodeType(void)   ; 
	int GetCount(void);
	BOOL GetCurCode(LPVOID lpBuf)   ;
	BOOL GetCurData(LPVOID lpBuf)   ;
	char GetDataClass(void)   ;
	LPVOID GetDataLink(void)   ;
	int GetDataSize(int iIndex=-1)   ;
	int GetDataType(void)   ;
	int GetText(LPSTR lpBuf, int iIndex)   ;
	int GetTextLen(int iIndex)   ;
	int SetCurSel(int iIndex)   ;
	int GetCurSel(void)   ;
	void SetScrollPos(int iPos)   ;
  
	           
                                                                  

// Implementation
public:     
	BOOL Attach(HWND hParent, int nID) ;  
	BOOL Attach(HWND hWnd) ;
  BOOL AttachToVBX(HWND hParent, int nID) ; 
	BOOL AttachToVBX(HWND hWnd) ;
	HWND Detach(void);
	HWND GetSafeHwnd(void);
	virtual _export ~CHComb() ;
protected:                         
	virtual WNDPROC* GetSuperWndProcAddr();
	virtual BOOL OnChildNotify(UINT, WPARAM, LPARAM, LRESULT*); 
	
private:
	BOOL m_bVBX;
	                     
};        


//CHEdit_SS

class  CHEdit_SS : public CWnd
{
	DECLARE_DYNAMIC(CHEdit_SS)

// Constructors
public:
	CHEdit_SS(void) ;
	BOOL Create(LPCSTR lpszCaption, DWORD dwStyle,
				const RECT& rect, CWnd* pParentWnd, UINT nID)   ;

// Attributes -- Message Interface             
	void Clear();
	void Undo();
	void Paste();
	void Copy();
	void Cut();
	CBrush *GetBkgndBrush(void);
	BOOL  HasChanged(void);
	LONG  GetData(LPVOID lpData, int iMaxBytes=-1);
	char  GetDataClass(void);
	LONG  GetDataSize(void);
	char  GetDataType(void);
	LONG  GetFormat(LPSTR lpszFormat, int iMaxBytes=-1);
	void  GetFormatRect(LPRECT lpFormatRect);
	CBrush *GetHiliteBrush(void);
	LONG  GetScrollPos(void);
	LONG  GetSel(void); 
	void  GetSelText(LPSTR lpSelText, int iMaxBytes=-1);
	void  ReplaceSel(LPSTR lpStr);
	LONG  GetState(void);
	LONG  GetText(LPSTR lpBuf, int iMaxBytes=-1); 
	BOOL  SetText(LPSTR lpBuf);
	LONG  GetTextLen(void);
	VALIDATEPROC  GetValidate(void);
	CBrush *SetBkgndBrush(CBrush *pBkgnd);
	void  SetChanged(BOOL bChanged);
	LONG  SetData(LPVOID lpBuf);
	LONG  SetDataLink(LPVOID lpBuf, BOOL bSetData = TRUE);
	CFont *SetFont(CFont *pFont, BOOL bRedraw=TRUE);
	LONG  SetFormat(LPSTR lpString, BOOL bRedraw=TRUE);
	void  SetFormatRect(BOOL bRedraw, LPRECT lpFormatRect);
	CBrush *SetHiliteBrush(CBrush *pHilite);
	LONG  SetScrollPos(int iNumChars, BOOL bRedraw=TRUE);
	void  SetSel(int iAnchor, int iExtent);
	void  SetMaxTextLen(int iMaxLen);
	void  SetPasswordChar(char c);
	void  SetOverwriteMode(BOOL bMode=TRUE);
	void  SetValidate(VALIDATEPROC lpfnValidate);
	void  Update(BOOL bParseText=FALSE, BOOL bUpdateText=TRUE);
	int Validate(void);
	CFont *GetFont(void);
	BOOL  GetOverwriteMode(void);
	char  GetPasswordChar(void);
	int   GetMaxTextLen(void);
  COLORREF GetTextColor(BOOL bNeg = FALSE);
	BOOL  SetState(LONG lStateFlag, BOOL bValue);
	BOOL  SetTextColor(COLORREF cr, BOOL bNeg = FALSE);
	BOOL  IsQuiet(void);
	BOOL  BeQuiet(BOOL bQuiet);
	
	BOOL Attach(HWND hParent, int nID) ; 
	BOOL Attach(HWND hWnd) ;
  BOOL AttachToVBX(HWND hParent, int nID) ; 
	BOOL AttachToVBX(HWND hWnd) ;
	HWND Detach(void);
	HWND GetSafeHwnd(void);


// Implementation
public:
	virtual _export ~CHEdit_SS() ;
protected:                         
	virtual WNDPROC* GetSuperWndProcAddr();
	virtual BOOL OnChildNotify(UINT, WPARAM, LPARAM, LRESULT*);
	
private:
	BOOL m_bVBX; 
	
DECLARE_MESSAGE_MAP()	
}; 

 
 
//CHGrid

class  CHGrid : public CWnd
{
	DECLARE_DYNCREATE(CHGrid)

// Constructors
public:
	CHGrid(void) ;
	BOOL Create(LPCSTR lpszCaption, DWORD dwStyle,
				const RECT& rect, CWnd* pParentWnd, UINT nID)   ;

// Attributes -- Message Interface             
/*
		HGrid Method Wrappers
	*/
	HFLD FieldCreate(LPSTR lpName, WORD wState, int iWidth, int iHeight, char cDataClass,
									 char cDataType, char cCodeClass, char cCodeType,int iSize, char cCtlType,
									 DWORD lCtlStyle, LPCSTR lpFormat);
	BOOL GetCellData(int iField, int iRec, LPVOID lpData);
	WORD GetCellText(int iField, int iRec, LPSTR lpText, WORD wMax);
	BOOL SetCellData(int iField, int iRec, LPVOID lpData);
	BOOL SetCellString(int iField, int iRec, LPSTR lpData);
	BOOL SetCurSel(int iField, int iRec);
  BOOL InvalidateRange(int iFld1, int iRec1, int iFld2, int iRec2);
	BOOL InvalidateCell (int iFld, int iRec);
  LPSTR OffsetPtr (int iFld, LPVOID lpRec);	 	 


	/*
		HGrid Message Wrappers
	*/
	LONG GetBaseRec(void);
	void SetBaseRec(LONG lBaseRec);
	int GetBtnHeight(void);
	void SetBtnHeight(int iHeight, BOOL bRedraw=TRUE);
	int GetBtnWidth(void);
	void SetBtnWidth(int iWidth, BOOL bRedraw=TRUE);
	LONG GetFirstRec(void);
	LONG SetFirstRec(LONG lRecIndex);	
	WORD GetFirstCol(void);
	void SetFirstCol(int iColIndex);
	int GetColCount(void);
	int GetRowCount(void);
	CBrush *GetBkgndBrush(void);
	CBrush *SetBkgndBrush(CBrush *pBrush, BOOL bRedraw=TRUE);
	CFont *GetFont(void);
	CFont *SetFont(CFont *pFont, BOOL bRedraw=TRUE);
	int GetFrozenCols(void);
	void SetFrozenCols(int iFrznCols);
	int GetRowHeight(void);
	void SetRowHeight(int iHeight, BOOL bRedraw=TRUE);
	LONG GetSelAnchor(LPCELL lpCell=NULL);
	void SetSelAnchor(int iCol, int iRow);
	LONG GetSelExtent(LPCELL lpCell=NULL);
	void SetSelExtent(BOOL bExtend, int iCol, int iRow);
	LONG GetState(void); 
	LONG GetStyle(void);
	void SetStyle(BOOL bValue, LONG lFlag);
	void SetState(BOOL bValue, WORD wFlag);
	LONG GetMarker(void);
	void SetMarker(int iColIndex, int iRowIndex);
	void GetTitle(int iCount, LPSTR lpsTitle);
	void SetTitle(int iCount, LPSTR lpsTitle);
	void Update(BOOL bErase);
	BOOL IsQuiet(void);
	void BeQuiet(BOOL bValue); 
	void GetColMap(int FAR *lpMap);
	void SetColMap(int FAR *lpMap);  
	int GetHScrollPos(void);
	int GetVScrollPos(void);
	int SetHScrollPos(int iPos);
	int SetVScrollPos(int iPos);
	int GetHScrollRange();
	int GetVScrollRange();
	

	//Record Buffering
	BUFFERPROC GetBufferProc(void);
	BUFFERPROC SetBufferProc(BUFFERPROC lpfnBufProc);
	int GetBufferSize(void);
	int SetBufferSize(int iSize);
	LONG GetMaxRec(void);
	LONG SetMaxRec(LONG lMax);
	//Field Management
	void AddFld(HFLD& Fld);
	void DeleteFld(int iColIndex);
	int FindFld(LPSTR lpszFldName);
	void InsertFld(int wBeforeFld, HFLD& Fld);
	void MoveCol(int wOldIndex, int wNewIndex);
	//Record Management
	int AddRec(LPVOID lpRecStruct=NULL);
	BOOL DeleteRec(int iRecIndex);
	BOOL GetCurRec(LPVOID lpRecStruct);
	LPVOID GetRecLink(void);
	int InsertRec(int iRecIndex, LPVOID lpRecStruct=NULL);
	int MoveRow(int iOldIndex, int iNewIndex);
	void ResetContent(BOOL bRedraw = TRUE);
	void SetRecLink(LPVOID lpRecStruct);
	int GetRecSize(void);
	//Field Messages                 
	CWnd *GetHCtl(int iColIndex);
	void FreeHCtl(int iColIndex, CWnd *pCtl);
	LONG GetCtlStyle(int iColIndex);
	WORD GetCtlType(int iColIndex);
	char GetCodeClass(int iColIndex);
	char GetCodeType(int iColIndex);
	char GetDataClass(int iColIndex);
	char GetDataType(int iColIndex);
	int GetDataSize(int iColIndex);
	void GetFormat(int iColIndex, LPSTR lpszFormat);
	int GetFormatLen(int iColIndex);
	void SetFormat(int iColIndex, LPSTR lpszFormat);
	int GetDropHeight(int iColIndex);
	void SetDropHeight(int iColIndex, int iNewHeight);
	void GetName(int iColIndex, LPSTR lpszName);
	int GetNameLen(int iColIndex);
	void SetName(int iColIndex, LPSTR lpszName);
	int GetColWidth(int iColIndex);
	void SetColWidth(int iColIndex, int iNewWidth);
	WORD GetFieldState(int iColIndex);
	WORD SetFieldState(int iColIndex, WORD wFlag, BOOL bValue);
	int GetOffset(int iFldIndex);
	
	//Record Messages
	BOOL GetData(int iRecIndex, LPVOID lpRecStruct);
	BOOL SetData(int iRecIndex, LPVOID lpRecStruct);
	WORD GetRecState(int iRecIndex);
	void SetRecState(int iRecIndex, WORD wFlag, BOOL bValue);

	//Whole Rows
	int GetSelCount(void);
	int GetSelRows(int iBufSize, int FAR *lpBuffer);
	BOOL IsSelected(int iRow);
	BOOL SelectRow(int iRow);
	
	//Index Conversions
	int ColToFld(int c);			
	int FldToCol(int f);
	LONG RowToRec(int row);
	int RecToRow(LONG rec);	
	                                                             

// Implementation
public:
	_export ~CHGrid() ;
	BOOL Attach(HWND hParent, int nID) ; 
	BOOL Attach(HWND hWnd) ;
  BOOL AttachToVBX(HWND hParent, int nID) ; 
	BOOL AttachToVBX(HWND hWnd) ;
	HWND Detach(void);
	HWND GetSafeHwnd(void);
	virtual void Initialize(void); //Called from Create.  Override to perform grid-specific initialization.
	
protected:                         
	 WNDPROC* GetSuperWndProcAddr();
	 BOOL OnChildNotify(UINT, WPARAM, LPARAM, LRESULT*);
	
private:
	BOOL m_bVBX;
};   

                                         
/////////////////////////////////////////////////////////////////////////////
// CHGridView 

#define ID_INTGRID 101 

class CHGridView : public CView
{
	DECLARE_DYNCREATE(CHGridView)
protected:
	CHGridView();			// protected constructor used by dynamic creation 

// Attributes
public:
	 BOOL Create( LPCSTR lpszClassName, LPCSTR lpszWindowName, DWORD dwStyle, 
	 						const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);

// Operations
public:
BOOL DestroyWindow();
CObject *GetGrid();          
                                                                                                   
virtual LPSTR OnPrepareGridName(void);  //Called from Create.  Override to return name of GRS resource. 
virtual DWORD OnPrepareGridStyle(void); //Called from Create.  Override to return grid style.  
virtual void  OnInitializeGrid(); //Called after grid is created.  Override to perform grid-specific initialization.
 
private: 
                      	

// Implementation
protected:
	CHGrid  *m_pGrid; 
	virtual ~CHGridView();
	virtual	void OnDraw(CDC* pDC);        

	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDestroy(void);   
	afx_msg void OnSetFocus(CWnd *);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	
	//Override to process grid notifications
	virtual	afx_msg void grid_OnBottom();
	virtual afx_msg void grid_OnDestoy();	
	virtual afx_msg void grid_OnDblClk();
	virtual afx_msg void grid_OnErrSpace();
	virtual afx_msg void grid_OnKillFocus();
	virtual afx_msg void grid_OnRecChanged();
	virtual afx_msg void grid_OnRecDelete();
	virtual afx_msg void grid_OnRecNew();
	virtual afx_msg void grid_OnRecSwitch();
	virtual afx_msg void grid_OnTop();			
	virtual afx_msg void grid_OnSelChange();	
	virtual afx_msg void grid_OnSelChanging();	
	virtual afx_msg void grid_OnSelExtending();	
	virtual afx_msg void grid_OnSetFocus();
	virtual afx_msg void grid_OnColMoved();
	virtual afx_msg void grid_OnHScroll();
	virtual afx_msg void grid_OnVScroll();
	virtual afx_msg void grid_OnHScrollRange();
	virtual afx_msg void grid_OnVScrollRange();
		


	
protected:
	//{{AFX_MSG(CHGridView)
		
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#define ALLOCPTR    GALLOCPTR
#define LOCKPTR     GLOCKPTR
#define UNLOCKPTR   GUNLOCKPTR
#define FREEPTR     GFREEPTR

                                                   
#define GMEM_FLAGS (GPTR)

 
#define GALLOC( s)            GlobalAlloc (GMEM_FLAGS, s)
#define GFREE( h)             GlobalFree (h)
#define GLOCK( h)             (LPVOID)GlobalLock (h)
#define GUNLOCK( h)           GlobalUnlock (h)
#define GSIZE( h)             GlobalSize (h)
#define GREALLOC( h,s)        GlobalReAlloc (h, s, GPTR)


#ifdef 	_WIN32
#define GHANDLE( p)           GlobalHandle (p)
#define GALLOCPTR( s)         GALLOC (s)
#define GUNLOCKPTR( p)        (p)
#define GFREEPTR( p)          GFREE (p)
#define GREALLOCPTR( p,s)     GREALLOC (p, s)
#define GPTRSIZE( p)          GSIZE (p)
#else//!_WIN32
#define GHANDLE( p)           (HANDLE)LOWORD (GlobalHandle (SELECTOROF (p)))
#define GALLOCPTR( s)         GLOCK (GALLOC (s))
#define GUNLOCKPTR( p)        GUNLOCK (GHANDLE (p))
#define GFREEPTR( p)          (GUNLOCKPTR (p), GLOCK (GFREE (GHANDLE (p))))
#define GREALLOCPTR( p,s)     (GUNLOCKPTR (p), GLOCK (GREALLOC (GHANDLE (p), s)))
#define GPTRSIZE( p)          GSIZE (GHANDLE (p))
#endif//_WIN32

                                                                                           

class CHGridBuffer : public CObject
{
	DECLARE_DYNAMIC(CHGridBuffer)
	
	friend class CBufferManager;
	
protected:
	CHGridBuffer();
	~CHGridBuffer();
	CHGrid *m_pGrid;
	
public:      
	BOOL AttachBuffer(CHGrid *pGrid);

	//Override the following buffer functions
	virtual BOOL OnRetrieve(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnUpdate(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnInsert(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnDelete(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnChange(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnValidate(int iColIndex, int iRowIndex, LPVOID lpCellData);
	virtual BOOL OnAdd(long lRecNum, LPVOID lpRecData);
	
private:  
	

}; 

typedef struct tagBufferStruct
{
	HWND hWnd;
	CHGridBuffer  *pBuff;  
	struct tagBufferStruct _far *pNext;          
} BUFFERSTRUCT, _far *LPBUFFERSTRUCT; 


  
/* CBufferManager

A single instance of CBufferManager is accessed CHGridBuffer objects
to manage the seting and freeing of callback procedures.  Applications should
not create additional instances of this class.*/ 

class CBufferManager : public CObject
{
public:
	CBufferManager();
	~CBufferManager();
	
public:
	BOOL RegisterBuffer(CHGridBuffer *pBuffer);
	BOOL UnregisterBuffer(CHGridBuffer *pBuffer);
	static BOOL FAR PASCAL __export MainBufferProc(HWND hGrid, WORD wAction, LONG lRecNum, LPVOID lpRecData);
	
private:
	static LPBUFFERSTRUCT m_pBuffList;
	static BUFFERPROC m_lpfnBuffProc;    
	static CHGridBuffer *GetBuffer(HWND hWnd);
	static HWND  GetWindow(CHGridBuffer *pBuffObj);        
	BOOL	RemoveLink(CHGridBuffer *pBuff);
	BOOL	Append(HWND hWnd, CHGridBuffer *pBuff);
	BOOL	DestroyList(LPBUFFERSTRUCT pList);
	
};         



extern CBufferManager BuffMan; 
  


//CHList

class  CHList : public CWnd
{
	DECLARE_DYNAMIC(CHList)

// Constructors
public:
	CHList(void) ;
	BOOL Create(LPCSTR lpszCaption, DWORD dwStyle,
				const RECT& rect, CWnd* pParentWnd, UINT nID)   ;
	virtual void Initialize();

// Attributes -- Message/Method Interface             
	
  int AddItem(LPVOID lpData);
	int AddItemEx(LPVOID lpData, LPVOID lpCode);
	int AddItems(int iCount, LPVOID lpData);
	int AddItemsEx(int iCount, LPVOID lpData, LPVOID lpCode);
	BOOL DeleteItem(int iIndex);
	int DeleteItems(WORD wSearch, int iCount, LPVOID lpInfo);
	BOOL EmptyList(void);
	int FindCode(int iStart, LPVOID lpCode);
	int FindData(int iStart, LPVOID lpData);
	BOOL GetCode(int iIndex, LPVOID lpCode);
	BOOL GetData(int iIndex, LPVOID lpData);
	int GetItems(int iCount, WORD wReturn, LPVOID lpReturn, WORD wSearch, LPVOID lpInfo);
	int InsertItem(int iPos, LPVOID lpData);
	int InsertItemEx(int iPos, LPVOID lpData, LPVOID lpCode);
	int InsertItems(int iPos, int iCount, LPVOID lpData);
	int InsertItemsEx(int iPos, int iCount, LPVOID lpData, LPVOID lpCode);
	BOOL IsSelected(int iIndex);
	BOOL SelectCode(LPVOID lpCode, WORD wAction);
	BOOL SelectData(LPVOID lpData, WORD wAction);
	BOOL SelectItem(int iIndex, WORD wAction);
	BOOL SelectItems(WORD wAction, WORD wSearch, int iCount, LPVOID lpInfo);
	BOOL SetCode(int iIndex, LPVOID lpCode);
	BOOL SetCodeLink(LPVOID lpCode, BOOL bSelect=TRUE);
	BOOL SetDataLink(LPVOID lpData, BOOL bSelect=TRUE);
	BOOL MarkItems(WORD wSearch, int iCount, LPVOID lpInfo);


	/*
		HList Message Wrappers
	*/
	CBrush *GetBkgndBrush(void);
	char GetCodeClass(void);
	LPVOID GetCodeLink(void);
	int GetCodeSize(int iIndex=-1);
	int GetCodeType(void);
	BOOL GetCurCode(LPVOID lpBuf, WORD wSize=-1);
	BOOL GetCurData(LPVOID lpBuf, WORD wSize=-1);
  WORD GetCurSel(void);
	char GetDataClass(void);
	LPVOID GetDataLink(void);
	int GetDataSize(int iIndex=-1);
	int GetDataType(void);
	CFont *GetFont(void);
	void GetFormat(LPSTR lpBuf, int iMaxLen=-1);
	int GetHExtent(void);
	CBrush *GetHiliteBrush(void);
	BOOL GetItemRect(int iIndex, LPRECT lpR);
	int GetScrollPos(void);
	BOOL GetSel(int iIndex);
	int GetSelCount(void);
	int GetSelItems(LPINT lpBuf, int iMaxItems);
	LONG GetState(void);
	int GetText(LPSTR lpBuf, int iIndex);
	int GetTextLen(int iIndex);
	COLORREF GetTextColor(BOOL bNeg=FALSE);
	void SetTextColor(COLORREF crNew, BOOL bNeg=FALSE);
	LONG GetStyle(void);
	void SelectRange(int iAction, int iStart, int iEnd);
	CBrush *SetBkgndBrush(CBrush *pBknd, BOOL bRedraw=TRUE); 
	CBrush *SetHiliteBrush(CBrush *pBrush, BOOL bRedraw=TRUE)   ;
	BOOL SetColumnWidth(int iWidth);
	int SetCurSel(int iIndex);
	CFont *SetFont(CFont *pFont, BOOL bRedraw=TRUE);
	int SetFormat(LPSTR lpszFormat, BOOL bRedraw=TRUE);
	void SetScrollPos(int iPos);
	BOOL SetSel(int iAction, int iIndex);
	LONG SetState(WORD wFlag, BOOL bSetting);
	BOOL SetTabStops(int iNum, LPINT lpStops);
	int FindString(int iStart, LPSTR lpString);
	int SelectString(int iStart, LPSTR lpString);
	int GetTopIndex(void);
	int SetTopIndex(int iTop);
	int Scroll(int iAmount);
	BOOL SetRedraw(BOOL bRedraw, BOOL bRedrawNow);
	BOOL HasChanged(void);
	BOOL SetChanged(BOOL bChanged);
	void BeQuiet(BOOL bQuiet);
	BOOL IsQuiet(void);
	BOOL Update(void);  
	           


// Implementation
public:     
	BOOL Attach(HWND hParent, int nID) ;  
	BOOL Attach(HWND hWnd) ;
  BOOL AttachToVBX(HWND hParent, int nID) ; 
	BOOL AttachToVBX(HWND hWnd) ;
	HWND Detach(void);
	HWND GetSafeHwnd(void);
	virtual _export ~CHList() ;
protected:                         
	virtual WNDPROC* GetSuperWndProcAddr();
	virtual BOOL OnChildNotify(UINT, WPARAM, LPARAM, LRESULT*); 
	
private:
	BOOL m_bVBX;
	                     
};        

 
//CHStat

class  CHStat : public CWnd
{
	DECLARE_DYNAMIC(CHStat)

// Constructors
public:
	CHStat(void) ;
	BOOL Create(LPCSTR lpszCaption, DWORD dwStyle,
				const RECT& rect, CWnd* pParentWnd, UINT nID)   ;

// Attributes -- Message/Method Interface             
	
  int GetAlign(void);
	COLORREF GetBkgndColor(void);
	COLORREF GetFrgndColor(void);
	CGdiObject *GetPic(void);     
	CPalette *GetPalette(void);
	int GetText(LPSTR lpBuf, int iMaxLen=-1);
	int GetType(void);
	void SetAlign(int iCode);
	void SetBkgndColor(COLORREF cr, BOOL bRedraw);
	void SetFrgndColor(COLORREF cr, BOOL bRedraw);
	CGdiObject *SetPic(CGdiObject *Image, WORD wType, BOOL bRedraw=TRUE);
	void SetText(LPSTR lpszText);
	void SetType(int iType, BOOL bRedraw); 
	           


// Implementation
public:     
	BOOL Attach(HWND hParent, int nID) ; 
	BOOL Attach(HWND hWnd) ;
  BOOL AttachToVBX(HWND hParent, int nID) ; 
	BOOL AttachToVBX(HWND hWnd) ;
	HWND Detach(void);
	HWND GetSafeHwnd(void);
	virtual _export ~CHStat() ;
protected:                         
	virtual WNDPROC* GetSuperWndProcAddr();
	virtual BOOL OnChildNotify(UINT, WPARAM, LPARAM, LRESULT*); 
	
private:
	BOOL m_bVBX;
	                     
};   
 

//CHTool
class  CHTool : public CDialog
{      

	DECLARE_DYNAMIC(CHTool)
public: 
	CHTool(void) ;
	~CHTool(void) ; 
	BOOL Create(LPCSTR lpTemplate, CWnd* pParent, CWnd* pNotify=NULL, 
    DWORD dwStyle=HTS_TOP, UINT nID=-1, UINT iX=0, UINT iY=0); 
	
	HBRUSH GetBrush(void);
	int GetCaption(LPSTR lpBuf, int iMaxLen=-1);
	HWND GetNotify(void);
	HBRUSH SetBrush(HBRUSH hBkgnd);
	void SetCaption(LPSTR lpszCaption);
	HWND SetNotify(HWND hNotify);
	void Update();
	 
protected: 
  WNDPROC* CHTool::GetSuperWndProcAddr();
    

}; 

#ifndef _RECSETBUFFERDEFS
#define _RECSETBUFFERDEFS

// ADDITIONAL TYPES FOR CFieldInfo.nDataType
#define SS_AFX_RFX_CURRENCY					20
#define SS_AFX_RFX_ODBCDATE					21
#define SS_AFX_RFX_ODBCTIME					22
#define SS_AFX_RFX_ODBCTIMESTAMP		23

#endif // _RECSETBUFFERDEFS
                
class CHRecsetBuffer : public CHGridBuffer
{         

	DECLARE_DYNAMIC(CHRecsetBuffer)

// MEMBER VARIABLES
public:                                 
	CRecordset*		m_pSet;					              // POINTER TO RECORDSET
	LONG 					m_lCursorPos;                 // CURSOR POSITION
 	CObList				m_listColumnInfo;							// COLUMN (FIELD) INFO LINKED LIST

public:
	CHRecsetBuffer();
	~CHRecsetBuffer();                                            
	
	BOOL			AttachRecordSet(CRecordset* pSet, CHGrid* pGrid);  
	BOOL 			AddFieldsFromColumnInfo(void);	
               
	// THE Buffer MEMBER FUNCTIONS
	virtual BOOL OnRetrieve(LONG lRecNum, LPVOID lpRecData); 
	virtual BOOL OnUpdate(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnDelete(LONG lRecNum, LPVOID lpRecData); 
	virtual BOOL OnInsert(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnChange(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnAdd(LONG lRecNum, LPVOID lpRecData);
	virtual BOOL OnValidate(int iColIndex, int iRowIndex, LPVOID lpCellData);

	BOOL 			GetColumnInfo(void);
	CObList* 	GetColumnList(void); 
	        
	int 			GotoRecord(long lRecNum);    
	void			SetGridFieldDataToNull(LPWORD lpRecWord, int nField);
 	BOOL 			CopyRecSetToStruct(LPVOID lpRec);
 	void			SetRecSetFieldDataToNull(void* pv);
	BOOL 			CopyStructToRecSet(LPVOID lpRec, BOOL bNew = FALSE);
	BOOL 			SkipRecord(BOOL = TRUE);
	void			GotoFirst(void);
	void 			ReAlignCursorPos(void);
}; 


#ifdef _MFCWINT

#ifdef _HB
#include "thbmsg.cpp"
#endif

#ifdef _HC
#include "thcmsg.cpp"
#endif 

#ifdef _HE
#include "themsg.cpp"
#endif

#ifdef _HG
#include "thgmsg.cpp"
#endif  

#ifdef _HL
#include "thlmsg.cpp"
#endif

#ifdef _HS
#include "thsmsg.cpp"
#endif    

#ifdef _HT
#include "thtmsg.cpp"
#endif

#else  
//Include inline functions  
#include "thbmsg.cpp"
#include "thcmsg.cpp"  
#include "themsg.cpp"
#include "thgmsg.cpp"  
#include "thlmsg.cpp" 
#include "thtmsg.cpp"
#include "thsmsg.cpp"
#endif 

#endif //_MFCWIDG_H
