/***************************************************************************\
          (c) 1993, Simple Software, Inc., All rights reserved

	THBMSG.CPP

HButt Message interface code

\***************************************************************************/



/*
Message Interface
*/

_WRAP_INLINE  int _WRAPNAME(HButt)::GetPAlign(void) 
  {
	return (int)_WRAP_SM(HBM_GETPALIGN, 0, 0L);
  }


_WRAP_INLINE  int _WRAPNAME(HButt)::GetCount(void) 
  {
	return (int)_WRAP_SM(HBM_GETCOUNT, 0, 0L);
  }


_WRAP_INLINE  COLORREF _WRAPNAME(HButt)::GetMaskColor (void) 
  {
	return (COLORREF)_WRAP_SM(HBM_GETMASKCOLOR, 0, 0L);
  }

_WRAP_INLINE  int _WRAPNAME(HButt)::GetRAlign(void) 
  {
	return (int)_WRAP_SM(HBM_GETRALIGN, 0, 0L);
  }

_WRAP_INLINE  HANDLE _WRAPNAME(HButt)::GetSound(void) 
  {
	return (HANDLE)_WRAP_SM(HBM_GETSOUND, 0, 0L);
  }

_WRAP_INLINE  int _WRAPNAME(HButt)::GetState(void) 
  {
	return (int)_WRAP_SM(HBM_GETSTATE, 0, 0L);
  }

_WRAP_INLINE  int _WRAPNAME(HButt)::GetStateCount(void) 
  {
	return (int)_WRAP_SM(HBM_GETSTATECOUNT, 0, 0L);
  }

_WRAP_INLINE  int _WRAPNAME(HButt)::GetTAlign(void) 
  {
	return (int)_WRAP_SM(HBM_GETTALIGN, 0, 0L);
  }

_WRAP_INLINE  int _WRAPNAME(HButt)::GetText(LPSTR lpBuf, int iMaxBytes) 
  {
	return (int)_WRAP_SM(HBM_GETTEXT, iMaxBytes, (LONG)lpBuf);
  }

_WRAP_INLINE  COLORREF _WRAPNAME(HButt)::GetTextColor(void) 
  {
	return (COLORREF)_WRAP_SM(HBM_GETTEXTCOLOR, 0, 0L);
  }

_WRAP_INLINE  BOOL _WRAPNAME(HButt)::IsPressed(void) 
  {
	return (BOOL)_WRAP_SM(HBM_ISPRESSED, 0, 0L);
  }

_WRAP_INLINE  void _WRAPNAME(HButt)::Press(BOOL bPress) 
  {
	_WRAP_SM(HBM_PRESS, (WPARAM)bPress, 0L);
  }

_WRAP_INLINE  void _WRAPNAME(HButt)::SetPAlign(int iAlign) 
  {
	_WRAP_SM(HBM_SETPALIGN, iAlign, 0L);  
  }                                    
  
#ifdef _OWLWRAP  

_WRAP_INLINE  HPALETTE _WRAPNAME(HButt)::GetPalette(void) 
  {
	return (HPALETTE)_WRAP_SM(HBM_GETPALETTE, 0, 0L);
  }  

_WRAP_INLINE  HANDLE _WRAPNAME(HButt)::GetPic(int iIndex) 
  {
	return (HANDLE)_WRAP_SM(HBM_GETPIC, iIndex, 0L);
  }

_WRAP_INLINE  HBRUSH _WRAPNAME(HButt)::GetBkgndBrush(void) 
  {
	return (HBRUSH)_WRAP_SM(HBM_GETBKGNDBRUSH, 0, 0L);
  }

_WRAP_INLINE  HFONT _WRAPNAME(HButt)::GetFont(void) 
  {
	return (HFONT)_WRAP_SM(HBM_GETFONT, 0, 0L);
  }

_WRAP_INLINE  HANDLE _WRAPNAME(HButt)::SetPic (HANDLE hBM, WORD wType, int iIndex) 
  {
	return (HANDLE)_WRAP_SM(HBM_SETPIC, iIndex, MAKELONG(hBM, wType));
  }

_WRAP_INLINE  HBRUSH _WRAPNAME(HButt)::SetBkgndBrush(HBRUSH hBkgnd) 
  {
	return (HBRUSH)_WRAP_SM(HBM_SETBKGNDBRUSH, (WORD)hBkgnd, 0L);
  }

_WRAP_INLINE  HFONT _WRAPNAME(HButt)::SetFont(HFONT hFont, BOOL bRedraw) 
  {
	return (HFONT)_WRAP_SM(HBM_SETFONT, (WORD)hFont, bRedraw);
  }                            
  
#elif _MFCWRAP  

_WRAP_INLINE  CPalette *_WRAPNAME(HButt)::GetPalette(void) 
  {
	return CPalette::FromHandle((HPALETTE)_WRAP_SM(HBM_GETPALETTE, 0, 0L));
  }  

_WRAP_INLINE  CGdiObject *_WRAPNAME(HButt)::GetPic(int iIndex) 
  {
	return CGdiObject::FromHandle((HANDLE)_WRAP_SM(HBM_GETPIC, iIndex, 0L));
  }

_WRAP_INLINE  CBrush *_WRAPNAME(HButt)::GetBkgndBrush(void) 
  {
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HBM_GETBKGNDBRUSH, 0, 0L));
  }

_WRAP_INLINE  CFont *_WRAPNAME(HButt)::GetFont(void) 
  {
	return CFont::FromHandle((HFONT)_WRAP_SM(HBM_GETFONT, 0, 0L));
  }

_WRAP_INLINE  CGdiObject *_WRAPNAME(HButt)::SetPic (CGdiObject *pBM, WORD wType, int iIndex) 
  {
	return CGdiObject::FromHandle((HANDLE)_WRAP_SM(HBM_SETPIC, iIndex, MAKELONG((WORD)pBM->GetSafeHandle(), wType)));
  }

_WRAP_INLINE  CBrush *_WRAPNAME(HButt)::SetBkgndBrush(CBrush *pBkgnd) 
  {
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HBM_SETBKGNDBRUSH, (WPARAM) pBkgnd->GetSafeHandle(), 0L));
  }

_WRAP_INLINE  CFont *_WRAPNAME(HButt)::SetFont(CFont *pFont, BOOL bRedraw) 
  {
	return CFont::FromHandle((HFONT)_WRAP_SM(HBM_SETFONT, (WPARAM)pFont->GetSafeHandle(), bRedraw));
  }                  

#endif

_WRAP_INLINE  void _WRAPNAME(HButt)::SetMaskColor (COLORREF clrMask) 
  {
	_WRAP_SM(HBM_SETMASKCOLOR, 0, clrMask);
  }

_WRAP_INLINE  void _WRAPNAME(HButt)::SetRAlign(int iAlign) 
  {
	_WRAP_SM(HBM_SETRALIGN, iAlign, 0L);
  }

_WRAP_INLINE  HANDLE _WRAPNAME(HButt)::SetSound(HANDLE hSnd) 
  {
	return (HANDLE)_WRAP_SM(HBM_SETSOUND, (WORD)hSnd, 0L);
  }

_WRAP_INLINE  int	_WRAPNAME(HButt)::SetState(int iState, BOOL bRedraw) 
  {
	return (int)_WRAP_SM(HBM_SETSTATE, (WORD)iState, (LPARAM)bRedraw);
  }

_WRAP_INLINE  void _WRAPNAME(HButt)::SetTAlign(int iAlign) 
  {
	_WRAP_SM(HBM_SETTALIGN, iAlign, 0L);
  }

_WRAP_INLINE  void _WRAPNAME(HButt)::SetText(LPSTR lpszText) 
  {
	_WRAP_SM(HBM_SETTEXT, 0, (LONG)lpszText);
  }

_WRAP_INLINE  void _WRAPNAME(HButt)::SetTextColor(COLORREF clrText) 
  {
	_WRAP_SM(HBM_SETTEXTCOLOR, 0, clrText);
  }

_WRAP_INLINE  int _WRAPNAME(HBCheck)::GetData(LPVOID lpData) 
  {
	return (int)_WRAP_SM(HBM_GETDATA, 0, (LONG)lpData);
  }

_WRAP_INLINE  int _WRAPNAME(HBCheck)::GetDataSize(void) 
  {
	return (int)_WRAP_SM(HBM_GETDATASIZE, 0, 0L);
  }

_WRAP_INLINE  int _WRAPNAME(HBCheck)::SetData(LPVOID lpBuf) 
  {
	return (int)_WRAP_SM(HBM_SETDATA, 0, (LONG)lpBuf);
  }

_WRAP_INLINE  int _WRAPNAME(HBCheck)::SetDataLink(BOOL bUseIndex, LPVOID lpBuf) 
  {
	return (int)_WRAP_SM(HBM_SETDATALINK, (WORD)bUseIndex, (LONG)lpBuf);
	}

_WRAP_INLINE  BOOL _WRAPNAME(HBRadio)::IsLastInGroup(void) 
	{
	return (BOOL)_WRAP_SM(HBM_ISLASTINGROUP, 0, 0L);
  }   




