/*  Development Environment:
	BC++ 3.1, DOS 5.0, Novell Netware 3.11,
	Novell Netware Client API 1.0e

	Thomas H. Smith / Weirton Steel Corp. [70674,3300]

	This program demonstrates resetting the path for a drive
	allocated through the NWSetDriveBase function.  The code within
	the accompanying and NET_ENV.CPP was generally made by
	Peter Thomas [75716,2377] in the GBL_ENV.C program of GBLENV.ARC
	'BCPPDOS'  The GBL_ENV.C is a translation of SETPATH.PAS by
	David Dubois [71401,747].

	The assembly code within the Mstr_FindEnvironment() function
	within NET_ENV.CPP is from RESETMAP.C by Vitek Boruvka, found
	in NOVLIB.

	Place your server name in the 'server[] = "" ' variable.

	Program is written with presumption that SYS:PUBLIC exists.
	To be run after user is logged in.
*/
#include <stdlib.h>
#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>


#include <nwcalls.h>

#include <netenv.h>

void main()
{
	NWCONN_HANDLE	connHandle;
	NWDIR_HANDLE	dirHandle = 0;
	NWCCODE			ccode;

	char	server[] 		= "FSMS02";
	char	nw_pathsys[] 	= "SYS:";
	char	nw_Hdir[] 		= "PUBLIC";

	char far 	*Env;
	unsigned  	EnvSize;
	int         iPathLen;
	char far 	*szStationPath;
	char far 	*szNetPath;



	ccode = NWCallsInit( NULL, NULL);
	if(ccode)
		exit(1);

	ccode = NWGetConnectionHandle( server, 0, &connHandle, NULL );
	if(ccode){
		printf( "Could not get Connection Handle. Error: %X\n", ccode);
		exit(1);
		}

/* Make drive H: */
	ccode = NWSetDriveBase( 8, connHandle, dirHandle, (char *) nw_pathsys,
		0);
	if(ccode){
		printf("Unable to map %s : error %X", nw_pathsys, ccode);
		exit(0);
	}
	else
		if( setdisk( 7 ) != -1 )	// set current disk to drive H
			chdir( nw_Hdir );       // change directory to "PUBLIC"


/* Set Path - put drive H: at beginning of path */

	/* Get Current path */
	Mstr_FindEnvironment( &Env, &EnvSize );

	iPathLen = strlen( Mstr_getenv(Env, "PATH=") );

	/* Save current path as environment variable "WS_PATH" ,
		allocate memory for local variable */
	if ((szStationPath = (char *) malloc(128)) == NULL)
	{
		printf("Not enough memory to allocate szStationPath buffer\n");
		exit(1);  /* terminate program if out of memory */
	}
	else
		strset(szStationPath, '0');
	/*  Prepare and assign workstation path environment variable */
	strcpy( szStationPath, "WS_PATH=");

	strcat( szStationPath, (Mstr_getenv(Env, "PATH=") + 5) );
	/*  Remember - Path is still at workstation setting at this point */

	/* Allocate memory for string variable to be placed PATH */
	if ( (szNetPath = (char *) malloc(128) ) == NULL)
	{
		printf("Not enough memory to allocate szStationPath buffer\n");
		exit(1);  /* terminate program if out of memory */
	}
	else
		_fstrset(szNetPath, '0');

	strcpy( szNetPath, "PATH=H:.;" );
	strncat( szNetPath, (Mstr_getenv(Env, "PATH=")+5), iPathLen - 5);
	strcat( szNetPath, "\0" );

	/*  Remove current path */
	Mstr_delenv( Env, EnvSize, "PATH=");

	/* Place new PATH in environment */
	Mstr_putenv( Env, EnvSize, (char far *) szNetPath );

	/*  Place WS_PATH in environment */
	Mstr_putenv( Env, EnvSize, (char far *) szStationPath );

	/*  Let go of allocated memory */
	free( szStationPath );
	free( szNetPath );

	/* Give note to user */
	printf("\n\tCheck the mapping then type \"set\" at the DOS prompt and\
			\t   look at both the PATH and WS_PATH setting.\n");

//

}
