/********************************************************************/
/*                                                                  */
/* Kartenspiele fr OS/2                                            */
/*                                                                  */
/* Deutsche Installation, Version 1.03                              */
/*                                                                  */
/* Copyright 1994 (C) by Felix Maschek, Hamburg                     */
/*                                                                  */
/* EMail: CompuServe 100120,1370                                    */
/*                   OS2SHARE                                       */
/*                                                                  */
/********************************************************************/

'@Echo Off'

/* REXXUTIL laden */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisieren */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation von CARDS 1.03...'
Say ''


/* Nachprfen, ob bestimmte Bestandteile vorhanden sind. */

Language = 'DEUTSCH'

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: CARDS.EXE nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( "PICTURES.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: PICTURES.DLL nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( Language".HL_", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: 'Language'.HL_ nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( Language".DL_", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: 'Language'.DL_ nicht gefunden!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */
 
Say 'Bitte geben Sie den vollen Verzeichnisnamen ein, wohin'
Say '  CARDS installiert werden soll (Standard: C:\CARDS): '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* Zielverzeichnis, falls ntig, anlegen. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEHLER: Kann das Zielverzeichnis nicht anlegen.'
    Signal DONE
    End
  End
Say '';


Folder = '<WP_DESKTOP>'

/* Installation durchfhren. */

Say 'Kopiere CARDS nach ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "PICTURES.DLL" Directory"\PICTURES.DLL" '1>NUL'
Copy Language".HL_" Directory"\CARDS.HLP" '1>NUL'
Copy Language".DL_" Directory"\CARDSLAN.DLL" '1>NUL'

Say 'Erzeuge Programmobjekt...'
Type = 'WPProgram'
Title = 'Kartenspiele'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Objekt erzeugt!  Fertig.'
Else             
  Say 'FEHLER: Nicht erzeugt!'

Signal DONE

FAILURE:
Say 'Fehler in der REXX-Ausfhrung.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxfehler.'
Signal DONE

DONE:
Exit
