/********************************************************************/
/*                                                                  */
/* Cardgames for OS/2                                               */
/*                                                                  */
/* English Installation, Version 1.03                               */
/*                                                                  */
/* Copyright 1994 (C) by Felix Maschek, Hamburg                     */
/*                                                                  */
/* EMail: CompuServe 100120,1370                                    */
/*                   OS2SHARE                                       */
/*                                                                  */
/********************************************************************/

'@Echo Off'

/* load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisation */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation of CARDS 1.03...'
Say ''


/* Check... */

Language = 'ENGLISH'

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDS.EXE not found!'
  Signal DONE
  End

Result = SysFileTree( "PICTURES.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: PICTURES.DLL not found!'
  Signal DONE
  End

Result = SysFileTree( Language".HL_", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: 'Language'.HL_ not found!'
  Signal DONE
  End

Result = SysFileTree( Language".DL_", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: 'Language'.DL_ not found!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */
 
Say 'Please enter the full target path for CARDS'
Say '  Default: C:\CARDS: '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* create target-path. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Can''t create target path.'
    Signal DONE
    End
  End
Say '';

/* Create desktop object */

Folder = '<WP_DESKTOP>'

/* Install */

Say 'Copying CARDS to ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "PICTURES.DLL" Directory"\PICTURES.DLL" '1>NUL'
Copy Language".HL_" Directory"\CARDS.HLP" '1>NUL'
Copy Language".DL_" Directory"\CARDSLAN.DLL" '1>NUL'

Say 'Creating desktop object...'
Type = 'WPProgram'
Title = 'Cardgames'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Desktop object was created!  Ready.'
Else             
  Say 'ERROR: Can''t create desktop object!'

Signal DONE

FAILURE:
Say 'Error while processing REXX.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxerror.'
Signal DONE

DONE:
Exit
