/* NORSK.CMD: Installasjon av CARDS.EXE p norsk. */
'@Echo Off'

/* load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisation */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installasjon av CARDS 1.03...'
Say ''


/* Check... */

Language = 'NORSK'

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: CARDS.EXE ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( "PICTURES.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: PICTURES.DLL ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( Language".HL_", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: 'Language'.HL_ ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( Language".DL_", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: 'Language'.DL_ ikke funnet!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */
 
Say 'Vennligst skriv in hvor du nsker CARDS installert'
Say '  Enter gir: C:\CARDS: '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* create target-path. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEIL: Klarer ikke  opprette ' Directory '.'
    Signal DONE
    End
  End
Say '';

/* Create desktop object */

Folder = '<WP_DESKTOP>'

/* Install */

Say 'Kopierer CARDS til ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "PICTURES.DLL" Directory"\PICTURES.DLL" '1>NUL'
Copy Language".HL_" Directory"\CARDS.HLP" '1>NUL'
Copy Language".DL_" Directory"\CARDSLAN.DLL" '1>NUL'

Say 'Oppretter ikon p arbeidsomrdet...'
Type = 'WPProgram'
Title = 'Kortspill'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Ikon opprettet! Klar til bruk.'
Else             
  Say 'FEIL: Klarte ikke  opprette ikon!'

Signal DONE

FAILURE:
Say 'En feil oppstod under kjring av REXX.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxerror.'
Signal DONE

DONE:
Exit
