/* system-dependent definitions for shellutils programs.
   Copyright (C) 89, 91, 92, 93, 1994 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <sys/types.h>
#include <sys/stat.h>

#ifndef S_ISREG			/* Doesn't have POSIX.1 stat stuff. */
#define mode_t unsigned short
#endif

#ifdef	STAT_MACROS_BROKEN
#ifdef S_ISBLK
#undef S_ISBLK
#endif
#ifdef S_ISCHR
#undef S_ISCHR
#endif
#ifdef S_ISDIR
#undef S_ISDIR
#endif
#ifdef S_ISFIFO
#undef S_ISFIFO
#endif
#ifdef S_ISLNK
#undef S_ISLNK
#endif
#ifdef S_ISMPB
#undef S_ISMPB
#endif
#ifdef S_ISMPC
#undef S_ISMPC
#endif
#ifdef S_ISNWK
#undef S_ISNWK
#endif
#ifdef S_ISREG
#undef S_ISREG
#endif
#ifdef S_ISSOCK
#undef S_ISSOCK
#endif
#endif	/* STAT_MACROS_BROKEN.  */

#ifndef S_IFMT
#define S_IFMT 0170000
#endif
#if !defined(S_ISBLK) && defined(S_IFBLK)
#define	S_ISBLK(m) (((m) & S_IFMT) == S_IFBLK)
#endif
#if !defined(S_ISCHR) && defined(S_IFCHR)
#define	S_ISCHR(m) (((m) & S_IFMT) == S_IFCHR)
#endif
#if !defined(S_ISDIR) && defined(S_IFDIR)
#define	S_ISDIR(m) (((m) & S_IFMT) == S_IFDIR)
#endif
#if !defined(S_ISREG) && defined(S_IFREG)
#define	S_ISREG(m) (((m) & S_IFMT) == S_IFREG)
#endif
#if !defined(S_ISFIFO) && defined(S_IFIFO)
#define	S_ISFIFO(m) (((m) & S_IFMT) == S_IFIFO)
#endif
#if !defined(S_ISLNK) && defined(S_IFLNK)
#define	S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)
#endif
#if !defined(S_ISSOCK) && defined(S_IFSOCK)
#define	S_ISSOCK(m) (((m) & S_IFMT) == S_IFSOCK)
#endif
#if !defined(S_ISMPB) && defined(S_IFMPB) /* V7 */
#define S_ISMPB(m) (((m) & S_IFMT) == S_IFMPB)
#define S_ISMPC(m) (((m) & S_IFMT) == S_IFMPC)
#endif
#if !defined(S_ISNWK) && defined(S_IFNWK) /* HP/UX */
#define S_ISNWK(m) (((m) & S_IFMT) == S_IFNWK)
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef OS2

#include <process.h>
#include <stdlib.h>
#include <pwd.h>

#ifdef NICE
#define execvp(n, a)        {int rc = spawnvp(P_WAIT, n, a); if (rc != -1) exit(rc);}
#else
#define execvp(n, a)        spawnvp(P_OVERLAY, n, a)
#endif

#define PATH_MAX            260
#define NAME_MAX            256
#define NGROUPS_MAX         1

#define getgid()            0
#define getuid()            0
#define getegid()           0
#define geteuid()           0
#define getpwnam(x)         (dummy_pw.pw_name = getlogin(), &dummy_pw)
#define getpwuid(x)         (dummy_pw.pw_name = getlogin(), &dummy_pw)
#define getgrgid(x)         (&dummy_gr)
#define getgroups(n,p)      (*p = 0, 1)
#define getugroups(n,p,u)   (*p = 0, 1)
#define getlogin()          (getenv("LOGNAME") ? getenv("LOGNAME") : "root")

struct group {
  char *gr_name;
  gid_t gr_uid;
};

static struct group dummy_gr = {"root", 0};
static struct passwd dummy_pw = {"root", 0, 0};

#define ttyname(arg)        (isatty(0) ? "con" : NULL)

#define main os2main

#else /* not OS2 */

#ifndef _POSIX_VERSION
char *getlogin ();
char *ttyname ();
off_t lseek ();
uid_t geteuid ();
#endif /* _POSIX_VERSION */

#endif /* OS2 */

#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
#include <string.h>
#ifndef index
#define index strchr
#endif
#ifndef rindex
#define rindex strrchr
#endif
#ifndef bcopy
#define bcopy(from, to, len) memcpy ((to), (from), (len))
#endif
#ifndef bzero
#define bzero(s, n) memset ((s), 0, (n))
#endif
#else
#include <strings.h>
#endif

#include <errno.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#else
char *getenv ();
double atof ();
long atol ();
extern int errno;
#endif

#if defined(HAVE_FCNTL_H) || defined(_POSIX_VERSION)
#include <fcntl.h>
#else
#include <sys/file.h>
#endif

#ifndef F_OK
#define F_OK 0
#define X_OK 1
#define W_OK 2
#define R_OK 4
#endif

#ifndef S_ISLNK
#define lstat stat
#endif

#include "version.h"
#define print_version(x) \
  fprintf(stderr, "\nGNU %s, %s\n\n", x, version_string + 4)
