#    Copyright (C) 1989, 1990, 1991, 1992, 1993 Aladdin Enterprises.  All rights reserved.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# makefile for Ghostscript, MS-DOS or OS/2 GCC/EMX platform.
# Uses Borland (MSDOS) MAKER or 
# Uses IBM NMAKE.EXE Version 2.000.000 Mar 27 1992

# ------------------------------- Options ------------------------------- #

###### This section is the only part of the file you should need to edit.

# ------ Generic options ------ #

# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with ;.
# Use / to indicate directories, not a single \.

GS_LIB_DEFAULT=c:/gs;c:/gs/fonts

# Define the name of the Ghostscript initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# Setting DEBUG=1 includes debugging features (-Z switch) in the code.
# Code runs substantially slower even if no debugging switches are set,
# and also takes about another 25K of memory.

DEBUG=0

# Setting NOPRIVATE=1 makes private (static) procedures and variables public,
# so they are visible to the debugger and profiler.
# No execution time or space penalty, just larger .OBJ and .EXE files.

NOPRIVATE=0

# Define the name of the executable file.

GS=gsos2

# ------ Platform-specific options ------ #

# If you don't have an assembler, set USE_ASM=0.  Otherwise, set USE_ASM=1,
# and set ASM to the name of the assembler you are using.  This can be
# a full path name if you want.  Normally it will be masm or tasm.

USE_ASM=0
ASM= 

# Define the drive, directory, and compiler name for the EMX files.
# COMP is the compiler name (gcc)
# COMPDIR contains the compiler and linker (normally \emx\bin).
# EMXPATH contains the path to the EMX directory (normally c:/emx)
# INCDIR contains the include files (normally /emx/include).
# LIBDIR contains the library files (normally /emx/lib).
# Note that these prefixes are always followed by a \,
#   so if you want to use the current directory, use an explicit '.'.

COMP=gcc
COMPBASE=e:\emx
EMXPATH=e:/emx
COMPDIR=$(COMPBASE)\bin
INCDIR=$(EMXPATH)/include
LIBDIR=$(EMXPATH)/lib

# Choose platform-specific options.

# Define the processor (CPU) type.  Options are 86, 186, 286, 386, or 486.
# (The 8086 and 8088 both correspond to processor type 86.)
# 286 and up do not use protected mode.  Higher numbers produce
# code that may be significantly smaller and faster, but the executable
# will bail out with an error message on lower-numbered processor types.

# EMX requires 386 or higher
CPU_TYPE=386

# Define the math coprocessor (FPU) type.
# Options are -1 (optimize for no FPU), 0 (optimize for FPU present,
# but do not require a FPU), 87, 287, or 387.
# If the CPU type is 486, the FPU type is irrelevant, since the 80486
# CPU includes the equivalent of an 80387 on-chip.
# An xx87 option means that the executable will run only if a FPU
# of that type (or higher) is available: this is NOT currently checked
# at runtime.

FPU_TYPE=0

# ---------------------------- End of options ---------------------------- #

# Swapping `make' out of memory makes linking much faster.
# only used by Borland MAKER.EXE

#.swap

# Define the platform name.

PLATFORM=os2_

# Define the name of the makefile -- used in dependencies.

MAKEFILE=os2.mak

# Define the ANSI-to-K&R dependency.

AK=

#Compiler Optimiser option
CO=-O

# Make sure we get the right default target for make.

dosdefault: default gspmdrv.exe

# Define a rule for invoking just the preprocessor.

.c.i:
	$(COMPDIR)\cpp $(CCFLAGS) $<

# Define the extensions for the object and executable files.

OBJ=o
XE=.exe

# Define the current directory prefix, shell quote string, and shell name.

EXP=
QQ="
SH=
SHP=

# Define the generic compilation flags.

!if $(CPU_TYPE) >= 486
ASMCPU=/DFOR80386 /DFOR80486
PLATOPT=-DFOR80386 -DFOR80486
!else
!if $(CPU_TYPE) >= 386
ASMCPU=/DFOR80386
PLATOPT=-DFOR80386
!endif
!endif

!if $(CPU_TYPE) == 486 || $(FPU_TYPE) > 0
ASMFPU=/DFORFPU
!else
ASMFPU=
!endif

!if $(USE_ASM)
INTASM=iutilasm.$(OBJ)
PCFBASM=gdevegaa.$(OBJ)
!else
INTASM=
PCFBASM=
!endif

# Define the generic compilation rules.

ASMFLAGS=$(ASMCPU) $(ASMFPU) $(ASMDEBUG)

.asm.o:
	$(ASM) $(ASMFLAGS) $<;

# -------------------------- Auxiliary programs --------------------------- #

CCAUX=$(COMPDIR)\$(COMP) -O

echogs$(XE): echogs.c
	$(CCAUX) -o echogs echogs.c
	$(COMPDIR)\emxbind $(EMXPATH)/bin/emx.exe echogs echogs.exe
	del echogs

genarch$(XE): genarch.c
	$(CCAUX) -o genarch genarch.c
	$(COMPDIR)\emxbind $(EMXPATH)/bin/emx.exe genarch genarch.exe
	del genarch

genconf$(XE): genconf.c
	$(CCAUX) -o genconf genconf.c
	$(COMPDIR)\emxbind $(EMXPATH)/bin/emx.exe genconf genconf.exe
	del genconf

# ---------------------- MS-DOS I/O debugging option ---------------------- #

dosio_=zdosio.$(OBJ)
dosio.dev: $(dosio_)
	$(SHP)gssetmod dosio $(dosio_)
	$(SHP)gsaddmod dosio -oper zdosio

zdosio.$(OBJ): zdosio.c $(OP) $(store_h)

# ----------------------------- Assembly code ----------------------------- #

iutilasm.$(OBJ): iutilasm.asm
#################  END

# Define the compilation flags.

!if $(NOPRIVATE)
CP=-DNOPRIVATE
!else
CP=
!endif

!if $(DEBUG)
CD=-DDEBUG
!else
CD=
!endif

GENOPT=$(CP) $(CD)

CCFLAGS0=$(GENOPT) $(PLATOPT)
CCFLAGS=$(CCFLAGS0) 
CC=$(COMPDIR)\$(COMP) $(CCFLAGS0)
CCC=$(CC) -c
CCD=$(CC) -O -c
CCCF=$(COMPDIR)\$(COMP) -O $(CCFLAGS0) -c
CCINT=$(CC) -c

.c.o:
#	$(CCC) { $<}
	$(CCC) $<

# ------ Devices and features ------ #

# Choose the language feature(s) to include.  See gs.mak for details.
# Even though code overlays are available, we don't include most of the
# optional features, because they cost a significant amount of non-code space.

FEATURE_DEVS=filter.dev dps.dev level2.dev

# Choose the device(s) to include.  See devs.mak for details.

DEVICE_DEVS=os2pm.dev
DEVICE_DEVS2=deskjet.dev djet500.dev laserjet.dev ljetplus.dev ljet2p.dev ljet3.dev ljet4.dev
DEVICE_DEVS3=cdeskjet.dev cdjcolor.dev cdjmono.dev cdj550.dev paintjet.dev pjetxl.dev
DEVICE_DEVS4=epson.dev eps9high.dev ibmpro.dev escp2.dev bj10e.dev bj200.dev
DEVICE_DEVS5=bmpmono.dev bmp16.dev bmp256.dev bmp16m.dev
DEVICE_DEVS6=gifmono.dev gif8.dev pcxmono.dev pcx16.dev pcx256.dev
DEVICE_DEVS7=pbm.dev pbmraw.dev pgm.dev pgmraw.dev ppm.dev ppmraw.dev
DEVICE_DEVS8=tiffg3.dev
!include "gs.mak"
!include "devs.mak"

# -------------------------------- Library -------------------------------- #

# The GCC/EMX platform

os2__=gp_nofb.$(OBJ) gp_os2.$(OBJ)
os2_.dev: $(os2__)
	$(SHP)gssetmod os2_ $(os2__)

gp_os2.$(OBJ): gp_os2.c $(dos__h) $(string__h) $(gx_h) $(gp_h)

# ----------------------------- Main program ------------------------------ #

BEGINFILES=
CCBEGIN=$(CCC) *.c

# Get around the fact that the DOS shell has a rather small limit on
# the length of a command line.  (sigh)

LIBDOS=$(LIBGS)

# Interpreter main program

GS_ALL=gs.$(OBJ) $(INT) $(INTASM) gsmain.$(OBJ)\
  $(LIBDOS) emx.tr $(GS).res

$(GS)$(XE): $(GS_ALL) $(ALL_DEVS)
	$(COMPDIR)\gcc -o $(GS) @emx.tr $(INTASM) @gsos2.tr -lm
	$(COMPDIR)\emxbind -r$*.res $(EMXPATH)/bin/emx.exe $(GS) $(GS)$(XE)
	del $(GS)

$(GS).res: $(GS).rc gsos2.ico
	rc -i $(COMPBASE)\include -r $*.rc

# PM driver program

gspmdrv.o: gspmdrv.c gspmdrv.h
	gcc -g -c -O $*.c

gspmdrv.res: gspmdrv.rc gspmdrv.h gspmdrv.ico
	rc -i $(COMPBASE)\include -r $*.rc

gspmdrv.exe: gspmdrv.o gspmdrv.res gspmdrv.def
	gcc -g -o $* $*.o
	emxbind -p -r$*.res -d$*.def $(COMPDIR)\emxl.exe $* $*.exe
	del $*

# make zip file
zip:
	zip -@ gsos2a.zip < manifest.os2 
