/*****************************************************************
 * Osundel Install Program                                       *
 * Version 1.0                                                   *
******************************************************************/

/* Register with REXX API extensions. */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initializers                 */

iFound = 0;

/* Get command line parameters. */

Parse Arg InstallDir

if InstallDir = "" then do
   r=Instructions();
   exit;
   end;

else do

   Call SysFileTree InstallDir , "Cfiles" , "SD"
   do i = 1 to Cfiles.0
      if pos( translate(InstallDir) , translate(Cfiles.i) ) > 0 then do
         iFound = 1;
         i = Cfiles.0
         end;
      end;
   end;

/* If the directory pointed to was not found, then create it   */

if iFound = 0 then do
   r = Call SysMkDir( InstallDir );
   r = delword(r,1,1);
   if( r <> 0 ) then do
      say;
      say 'An error occured creating the specified directory rc = 'r;
      'helpmsg 'r;
      say 'Osundel installation aborting due to error in pathname';
      r=Instructions();
      exit;
      end;
   end;

/* Copy files. */

Call SysCls

Say
Say 'Installing Osundel Version 1.0'

'copy osundel.exe ' || InstallDir
'copy osundel.hlp ' || InstallDir
'copy osundel.ico ' || InstallDir
'copy file.lst ' || InstallDir
'copy install.cmd ' || InstallDir
'copy fileid.diz ' || InstallDir


Say;
Say 'Creating Osundel Desktop objects.';
Say;

r = Call SysCreateObject("WPFolder","Osundel","<WP_DESKTOP>","OBJECTID=<OSUFOLDER>","update")
                     
if (r <> 0 ) then do

      r = Call SysCreateObject("WPProgram","Osundel 1.0","<OSUFOLDER>",,
               "EXENAME="||InstallDir||"\OSUNDEL.EXE;STARTUPDIR="||InstallDir,"replace" );

   end;

else do
   say;
   say   'An error occured during the creation of the Osundel Folder ';
   say   'and program objects.';
   end;

Say 'Osundel has been installed!'

Exit

/* Instructions on installation procedure */

Instructions:
      Say
      Say
      Say '     Osundel Installation Instructions: '
      Say
      Say
      Say 'Directions:    To install Osundel, you must choose a target'
      Say '               directory on your hard drive.'
      Say
      Say
      Say 'Example:       INSTALL C:\OSUNDEL'
      Say

Return 0;
