'*****************************************************************************
'*MAPPING.BAS -- Example of mapping an area for a game by Professor X-Man    *
'*(Eric Blanding) of ProXman Software, the gaming division of NubianWare     *
'*Productions.  This code is STRICTLY Public Domain, and you may do anything *
'*you wish with it.  I only ask that you please make no modifications without*
'*prior consent from me (areas where i can be reached are in the DOC).  Also,*
'*I ask that if you wish to distribute the ZIp file you obtained, distribute *
'*it in it's ORIGINAL form!  Other than that, have fun!                      *
'*****************************************************************************
'                        DECLARES FOR SUBS/FUNCTIONS
'=============================================================================
DECLARE SUB ClearPort (MapArray%())
DECLARE SUB DropInvItem (InventArray%(), MapArray%(), X%, Y%, Item2Drop$)
DECLARE SUB GetItem (MapArray%(), InventArray%(), XLoc%, YLoc%)
DECLARE SUB LoadBarrierData (BarrierArray%())
DECLARE SUB MovePlayer (MapArray%(), BoundArray%(), KeyPressed%, CurrentXLoc%, CurrentYLoc%, item%)
DECLARE SUB SetGameFlags (FlagArray%())
DECLARE SUB ShowInv (InventArray%())
DECLARE SUB ShowMove (MapArray%(), KeyPress%, X%, Y%)
DECLARE FUNCTION InKeyCode% ()
DECLARE FUNCTION Object% (MapArray%(), X%, Y%)
DECLARE FUNCTION PlayerStart% (MapArray%(), PlayerChar%, CurXLoc%, CurYLoc%)
DECLARE FUNCTION CheckFlags% (FlagArray%())
DECLARE FUNCTION InvCheck% (InventoryArray%())

'***************************************************************************
'                         SET PROGRAM DEFAULTS
'===========================================================================
DEFINT A-Z        '<--Makes sure that any variable not explictly ending with a
                  '   % in the program, gets treated like an integer anyway.

OPTION BASE 1     '<--Makes sure that when an array is declared, it won't
                  '   automatically use 0 as it's lowest subscript.
                  '   Instead, it'll start with 1. This is so we don't have
                  '   to have DIM Mine(1 TO 20) instead of using DIM Mine(20).

'***************************************************************************
'                 ARRAY DEFINITIONS AND DESCRIPTIONS                  
'===========================================================================
REDIM HouseMap(10, 10) AS INTEGER      '<---This array holds our MAP

REDIM inventory(5) AS INTEGER   '<-----This array tracks the inventory status
REDIM BarDat(2) AS INTEGER      '<-----This array holds data which can define
                                '      optional barricades in your game,
                                '      besides the four standard walls of our
                                '      sample "map."
REDIM GameFlags(6) AS INTEGER   '<-----This array holds all our BOOLEAN flags
                                '      which is used to detect whether or not
                                '      the user has completed all the needed
                                '      tasks before the game will allow you
                                '      to continue and finish the game.

'****************************************************************************
'                     READING THE MAP INTO THE ARRAY
'============================================================================
'  This FOR..NEXT loop will READ the map (below this loop) into the array
'named HouseMap%().  First of all, ya'll probably wondering why the heck I'm
'storing the image of a map as a bunch of INTEGERS, instead of STRING
'characters.  Sure. I could have done that, and it would have worked fine.
'But I'm wary of running out of string space whether I'm in the IDE or running
'a compiled program. Plus, I've found out that INTEGER operations run a lot
'faster than STRING operations.
'
'  Enuff of that, right now, you wanna know what I'm doing.  What's going on
'is that... Wait a sec. Is that FOR loop backwards? Should it be:
'                   FOR X% = 1 to 10
'                     FOR Y% = 1 to 10
'and not the other way around?  That's correct my friend. In other situations,
'this X before Y syntax would probably be easier for you to understand how
'that particular program manipulated it's arrays.  But since we're dealing
'with PLOTTING, we need to move our linear way of thinking into something more
'abstract.  To make this simpler to understand, I set this up so that it
'works like the graphics functions in QBasic/QuickBASIC/PDS/VBDOS, which
'all work as Y%, X% not X%, Y% (For those who already know about this, ya'll
'can move on to "THE INNER WERKINGS").
'
'
'            BRIEF STUFF ON BASIC'S GRAPHIC COORDINATE SYSTEM
'            ------------------------------------------------
'
'   We all know when in SCREEN 0 (or any other mode%) and using the infamous
'LOCATE X%, Y% statement, we automatically assume that:
'
'                       X% = a row; Y% = a column
'Illustrated like so:
'
'X% = 5, Y% = 9
'123456789 <--Nine columns of "-" (so Y% = 9)
'--------- ]
'--------- 
'--------- <Five rows of "---------" (so X% = 5)
'--------- 
'--------- ]
'
'   Now, when dealing with GRAPHICs, it's reversed; It's now Y%, X%, not
'X%, Y% (you'll find out in a moment). You must no longer think in
'Rows and Columns (if you do, you'll easily get confused!).  Instead, you
'must think like yer in a math class, studying graphs; the X-Axis and the
'Y-Axis.  Looky here.  Remember this?:
'
'                                 
'                              3  Y          <--Y, in the graphics sense,
'                              2                would now be your "ROWS" (3
'                              1                are shown here).
'                                 
'                                  1234567  X <--X, in the graphix sense,
'                                                would now be your "COLUMNS"
'                                                (7 are shown here).
'
'         Can't you see?  Before, X and Y were Rows and Columns respectively.
'Now (if you STILL wanna think like ROWS and COLS), it's Y and X.  If yer
'still stumped, just consult the section on GRAPHICS in your BASIC manual.
'In any case, the MAP system used here uses the above format for plotting
'the player's movements and such.  After all, all we're doing in this program
'is plotting a point on a graph. That's it. Nothing fancy, just good old
'fashioned graphing.  Besides, I think it's easier to understand this way.
'(That and also the fact I had a heck of a time trying to get the !@#!ing
'program to work with loading the MAP with FOR X% = 1 to n:FOR Y% = 1 to n not
'the other way around!) ENUFF OF THIS GRAPHING CRAP! (Hope I didn't lose
'ya there...)
'
'
'                             THE INNER WERKINGS
'                             ------------------
'
'   This is what you've been waiting for; what the heck is going on in this
'dang loop.  What it's doing is:
'
'   1) Reading in a character from the DATA table
'   2) If it runs across a NUL (the empty spaces in the DATA table), then
'      assign a space (" ") in it's place, since I can't assign a NUL in
'      the array.
'   3) If we've reached the last... er.. COLUMN (X% value) in the DATA table,
'      then only grab that one character, before it hits the single
'      quotes ('). This is because DATA treats whatever is after that last
'      comma as one big piece of data (this includes REMs (')!). If that
'      LEFT$(S$,1) crap wasn't there, the comments to the right would
'      be grabbed in the array as well (If you wanna see it, comment out
'      the line with IF X% = UBOUND()... and put a watch on HouseMap(X%,Y%)).
'
'   4) We take the ASCII code of the character and put it into the array.
'      In memory, we have the EXACT copy of the map as shown, but instead
'      of the actual characters, we have a bunch of ASCII codes in it's place.
'      Cool eh?  ;)
'
'============================================================================
'                   ***!!!WARNING ABOUT DATA STATEMENTS!!!***
'                         -----------------------------
'
'   DATA statements are good for testing out simple theories such as this
'program example, but it's REALLY NOT a good idea to use em in compiled
'programs. Not only do they take up valuable DGROUP space, but they are
'visible in your EXE when looked at thru a "file browser" (HEX editor).
'And if u like to use ASCII characters lower than 3 ("" = 1, "" = 2),
'yer gonna have a problem.  When I first compiled this DEMO (with the DATAs)
'I used "" as the player character instead of "#", and "" as the other
''PEOPLE' represented insted of "" and "".  For some reason, the EXE can't
'read those ASC 2 and 1 characters from DATA statements.  At any rate, I
'advise you all to NOT use the approach presented here.  Instead, load the
'map stuff in from a file.  I'll leave THAT part up to you.
'============================================================================
'
FOR Y% = LBOUND(HouseMap, 2) TO UBOUND(HouseMap, 2)
  FOR X% = LBOUND(HouseMap) TO UBOUND(HouseMap)
     READ DataStuff$                          'Read in char from position X%
                                              'in DATA statement.

     IF DataStuff$ = "" THEN DataStuff$ = " " 'If it runs across a NUL, then
                                              'assign a SPACE to the variable.

     'If we hit the last position in the DATA statement line, only take the
     'first character it comes to, and drop the rest ("The rest," in this
     'case, being the comments (').
     '
     IF X% = UBOUND(HouseMap) THEN DataStuff$ = LEFT$(DataStuff$, 1)

       HouseMap(X%, Y%) = ASC(DataStuff$)  'Get the ASCII Val of the char
                                           'and put it's INTEGER notation
                                           'into the HouseMap array.
  NEXT X%
NEXT Y%

'This is the map that we're reading into the array.
'
'    <----Xaxis/Col---->
'    1 2 3 4 5 6 7 8 9 10
DATA ,,,,,,,,, '1  /\
DATA , , , , ,, , ,, '2   |   
DATA , ,, , ,, , , , '3   |  
DATA , , , , ,, , , , '4   |     
DATA , , ,, ,\, ,*, , '5   Yaxis/Row
DATA ,,,,,,,\,, '6   |     ĴMAP KEY SYMBOLSĿ
DATA , , , , ,, , ,!, '7   |      = a guy        \ = door   = a girl 
DATA ,$, , , ,\, ,+, , '8   |      = staircase    * = ring             
DATA , , ,$, ,, ,#, , '9   |     ! = timber boot  + = sword            
DATA ,,,,,,,,, '10 \/     $ = money bag    # = YOU! (The Player)
                         '          

'****************************************************************************
'                          CONSTANT DEFINTIONS
'============================================================================
'This CONSTants are used only within this portion of the program.  They have
'nothing to do with the SUBS.  However, they DO work within other SUB/FUNCS
'etc, but I prefer to have everything self-contained within a SUB.  For
'example, you'll see plenty of these same CONSTs in other SUBs and have the
'comment "Local use only" by it, to indicate that the SUB's CONSTs will only
'be used locally within it's own procedure.  This is my attempt to try to
'make the procedures self-regulating; not being dependant on what's been
'declared in the main module (this portion of the program which does NOT
'have a SUB/FUNCTION header on it).  Altho, you could make an include file
'and throw all those CONSTs in em, but for clarity, I threw all the CONSTs,
'DECLAREs, and variable definitions in the main.
'
'--------------------------GENERAL DEFINITIONS-----------------------------
CONST TRUE = -1, FALSE = NOT TRUE   '<--BOOLEANs. Self explanitory.
CONST NOTEMPTY = -1, FULL = -2      '<--These are to detect the state of the
                                    '   player's inventory: Is it FULL, or
                                    '   NOTEMPTY?
CONST BLANK = 32                    '<--Defined as a space (" ").  This is
                                    '   used to denote an empty floor in the
                                    '   map (go back and look at those BLANK
                                    '   spots!).

'-----------------KEYBOARD COMMAND DEFINITIONS-----------------------------
'These CONSTs are just ASCII keycode values for the given keys: UP, DOWN,
'LEFT, RIGHT, and the letters (lower case values, NOT upper case!): G, D, U,
'T and S.  The FUNCTION InkeyCode% will automatically sense these values from
'the keyboard.
CONST UP = 18432, DOWN = 20480, LEFT = 19200, RIGHT = 19712
CONST G = 103, D = 100, U = 117, T = 116, S = 115

'------------------ASCII CODES OF INVENTORY ITEMS USED IN GAME-------------
CONST BOOT = 33      '<--An item in the game, denoted by a "!" on the map.
CONST STAIRS = 240   '<--The goal in the game, denoted by a "" on the map.
CONST MONEY = 36     '<--An item in the game, denoted by a "$" on the map.
CONST PERSON1 = 6    '<--A guy in the game, denoted by a "" on the map.
CONST PERSON2 = 3    '<--A girl in the game, denoted by a "" on the map.
CONST DOOR = 92      '<--An object in the game, denoted by a "\" on the map.
CONST SWORD = 43     '<--An item in the game, denoted by a "+" on the map.
CONST RING = 42      '<--An item in the game, denoted by a "*" on the map.
CONST PLAYERDEF = 35 '<--The player's character, denoted by a "#" on the map.
                     '   In other programs that you may create, this can be
                     '   ANY character you want.  It's DEFINED as ASCII code
                     '   35, hence the name PLAYERDEF.  Change as u see fit.

'***************************************************************************
'                          INVENTORY ITEM NAMES
'===========================================================================
'As the title above implies.  Just names of the items in the inventory.
'
Boots$ = "Timberland Boots"     'These variaibles are used
StairCase$ = "Staircase"        'for descriptive purposes during
MoneyBag$ = "Money Bag"         'game play.  We'll see how these come
P1$ = "Michael Jordan"          'into play later.
P2$ = "Halle Berry"
ADoor$ = "Door"
ASword$ = "Sword"
ARing$ = "Ring"

'****************************************************************************
'                              INITIALIZATION
'============================================================================
'The following procedures set the game flag status and load programmer
'definiable barrier data.
'
CALL SetGameFlags(GameFlags())  'Set all flags to FALSE
CALL LoadBarrierData(BarDat())  'Setup the barrier data table

'****************************************************************************
'                          USER INTERFACE SETUP
'============================================================================
'This part just sets up the statusbar and prints the inventory box.
'
CLS                                                    'Take a LONG guess! ;)
StatusBar$ = "(G)et  (D)rop  (U)se  (T)alk  (H)elp  (S)how Map            Direction: "
COLOR 15: LOCATE 18, 1: PRINT STRING$(80, 196);        'Print screen divider

LOCATE 1, 50: PRINT "ĴInventoryĿ"    'Print the inventory
              FOR Row% = 2 TO 6                        'container for names
LOCATE Row%, 50: PRINT "                           " 'and stuff.
              NEXT Row%
LOCATE 7, 50: PRINT ""

LOCATE 17, 1: COLOR 12: PRINT "Press (ESC) to end this demo!" 'Exit message
COLOR 0, 2: LOCATE 25, 1: PRINT STRING$(80, 32);  'Print blank status bar
LOCATE 25, 1: PRINT StatusBar$;                   'Prints User Menu

'----------------------PRINT PLAYER'S OBJECTIVE-------------------------
'
VIEW PRINT 19 TO 25   'Reset text viewport
COLOR 12, 0           'RED on BLACK background
PRINT "You are on the bottom floor of a smelly old, nasty, slimy, funky old house!"
PRINT "Your goal: To get all the items, talk to the two people who are in the"
PRINT "house, and run upstairs! Hope ya make it! >:)"
COLOR 28, 0: PRINT "                            Hit A Key to begin!"
DO: LOOP WHILE INKEY$ = ""  'Wait until keypress
CLS 2                       'Clear the current viewport
VIEW PRINT 1 TO 25          'reset to default viewport
COLOR 0, 2: LOCATE 25, 1: PRINT STRING$(80, 32);  'Print blank status bar
LOCATE 25, 1: PRINT StatusBar$;                   'Prints User Menu

'**************************************************************************
'                        PLAYER'S POSITION CHECK
'==========================================================================

Found% = PlayerStart(HouseMap(), PLAYERDEF, X%, Y%) 'Find out where the
                                                    'user starts in the
                                                    'array. In this case,
                                                    'it's (8,9) (Refer to
                                                    'the DATA statements
                                                    'for details).


IF Found% THEN  'If the player's position has been found, continue with
                'program execution.

'**************************************************************************
'                          MAIN PROGRAM LOOP
'==========================================================================
DO
  COLOR 15, 0
  LOCATE 24, 62: PRINT "X=" + LTRIM$(STR$(X%)) + " "; 'Print the current pos
                 PRINT "Y=" + LTRIM$(STR$(Y%)) + " "; 'of the player's char
                 PRINT "ITEM=" + LTRIM$((STR$(item%))) + "  "; 'in the array.

  'IF the user sets the SHOWMAP flag to TRUE, THEN display the array's
  'contents (the map) on screen.
  '
  IF SHOWMAP = TRUE THEN CALL ShowMove(HouseMap(), KeyPress%, X%, Y%)
  IF SHOWMAP = FALSE THEN CALL ClearPort(HouseMap())  'Clears map display
                                                      'area.

KeyPress% = InKeyCode%      'Get ASCII keycode value from user's keypress

'--------------------------PLAYER'S DIRECTION-------------------------------
  SELECT CASE KeyPress% '(*KeyPress*)
   CASE UP                                             'They choose UP?
    COLOR 15, 0: LOCATE 19, 1: PRINT STRING$(220, 32); 'Clear dialogue area
    COLOR 15, 2: LOCATE 25, 73: PRINT "NORTH";         'Show current direction
    'Update the player's move. If the user is over something of value, the
    'parameter Item% will return a value (ZERO otherwise).  Item% will be
    'used thruout the rest of this program to detect what kind of ITEM it
    'may be (Item% is the ASCII code value of a character in the HouseMap()
    'array).
    '
    CALL MovePlayer(HouseMap(), BarDat(), KeyPress%, X%, Y%, item%)

   CASE DOWN  'The same comments for CASE UP apply for the rest of the CASES.
    COLOR 15, 0: LOCATE 19, 1: PRINT STRING$(220, 32);
    COLOR 15, 2: LOCATE 25, 73: PRINT "SOUTH";
    CALL MovePlayer(HouseMap(), BarDat(), KeyPress%, X%, Y%, item%)
            
   CASE LEFT
    COLOR 15, 0: LOCATE 19, 1: PRINT STRING$(220, 32);
    COLOR 15, 2: LOCATE 25, 73: PRINT "WEST ";
    CALL MovePlayer(HouseMap(), BarDat(), KeyPress%, X%, Y%, item%)

   CASE RIGHT
    COLOR 15, 0: LOCATE 19, 1: PRINT STRING$(220, 32);
    COLOR 15, 2: LOCATE 25, 73: PRINT "EAST ";
    CALL MovePlayer(HouseMap(), BarDat(), KeyPress%, X%, Y%, item%)

'-----------------------PLAYER'S MENU CHOICES----------------------------------
   CASE G              'When the user presses lower case 'G' (GET)...
    SELECT CASE item%    'Detect what Item was picked up.
     CASE SWORD:           'If it's a SWORD (ASC 43)...
       LOCATE 20, 1: PRINT STRING$(160, 32);         'Erase dialog area
       LOCATE 20, 1: PRINT "Yes! You now have: ";    'Tell user what they
       COLOR 10: PRINT "The Sword!"                  'picked up.
       CALL GetItem(HouseMap(), inventory(), X%, Y%) 'Update the inventory
       GameFlags(1) = TRUE                           'Set one of the FALSEs
                                                     'in the GameFalg array
                                                     'to TRUE, cause we did
                                                     'something that was
                                                     'required to be able to
                                                     'win.
     CASE RING:            'If it's a RING (ASC 42)...
       LOCATE 20, 1: PRINT STRING$(160, 32);         'Same comments as CASE
       LOCATE 20, 1: PRINT "Yes! You now have: ";    'SWORD.
       COLOR 10: PRINT "The Invisibility ring!"
       CALL GetItem(HouseMap(), inventory(), X%, Y%)
       GameFlags(2) = TRUE

     CASE BOOT:            'If the user picked up a BOOT (ASC 33)...
       LOCATE 20, 1: PRINT STRING$(160, 32);         'Same comments as CASE
       LOCATE 20, 1: PRINT "Yes! You now have: ";    'SWORD.
       COLOR 10: PRINT "A PHAT pair of Timberland Boots!"
       CALL GetItem(HouseMap(), inventory(), X%, Y%)
       GameFlags(3) = TRUE

     CASE MONEY:           'If the user picked up some MONEY (ASC 36)...
       LOCATE 20, 1: PRINT STRING$(160, 32);         'Same comments as CASE
       LOCATE 20, 1: PRINT "Yes! You now have: ";    'SWORD.
       COLOR 10: PRINT "A Bag fulla ca$h!"
       CALL GetItem(HouseMap(), inventory(), X%, Y%)
       GameFlags(4) = TRUE
    END SELECT
    CALL ShowInv(inventory())  'Show the new inventory on the screen

   CASE D     'When the user presses lower case 'D' (DROP)...
     'IF the inventory is NOT EMPTY or IF the inventory is FULL THEN
     'tell the user what number of the item they wish to drop from the
     'inventory.
     '
     IF InvCheck%(inventory()) = NOTEMPTY OR InvCheck%(inventory()) = FULL THEN
      LOCATE 19, 1: PRINT "Choose the number of the item you want to drop from the inventory!"; : COLOR 12
      DO
       Item2Drop$ = INPUT$(1)   'Get the number of the item

       'Drop the item from the inventory.
       CALL DropInvItem(inventory(), HouseMap(), X%, Y%, Item2Drop$)
      LOOP UNTIL Item2Drop$ <> ""
     END IF

   CASE T     'When the user presses lower case 'T' (TALK)...
    SELECT CASE item%   'Check what person they are on.
     CASE PERSON1:         'If PERSON1 (ASC 6)...
       LOCATE 19, 1: PRINT STRING$(79, 32);   'Clear Dialog and print
                                              'message.
       PRINT "Micheal Jordan says that you should eat more wheaties. ";
       PRINT "You can find an ecomony sized box upstairs."
       GameFlags(5) = TRUE                    'Update GameFlag array.

     CASE PERSON2:        'If PERSON2 (ASC 3)....
       LOCATE 19, 1: PRINT STRING$(79, 32);    'Clear dialog and print
                                               'message
       PRINT "Halle Berry says that you couldn't 'Hit it' if you had a bat.";
       GameFlags(6) = TRUE                     'Update GameFlag Array.
    END SELECT
      
   CASE S     'When the user presses lower case 'S' (SHOW MAP)...
    SELECT CASE SHOWMAP              'BOOLEAN variable "SHOWMAP"
     CASE TRUE: SHOWMAP = NOT TRUE   'IF SHOWMAP = TURE then show the map!
     CASE FALSE: SHOWMAP = NOT FALSE 'If it's FALSE then DON'T show it!
    END SELECT

   CASE U     'When the user presses lower case 'U' (USE)...
    SELECT CASE item%  'Check what item they're over.
     CASE STAIRS                       'IF they are over the STAIRS (ASC 240)...
      IF CheckFlags(GameFlags()) THEN  'AND all the GameFlags return TRUE
                                       'Show the winning message and end.
       COLOR 26: LOCATE 20, 1: PRINT "YES! YOU'VE WON! YOU GOT UP THE STAIRS!"
       COLOR 15: PRINT "This conlcudes the map example. Hidey-ho!": END
      ELSE                             'IF CheckFlags() returns a FALSE
                                       'Tell user they haven't finished all
                                       'that was required yet.
       LOCATE 20, 1: COLOR 12: PRINT "You haven't done all that's required yet!"
      END IF
     CASE ELSE:   'If user is over anything else...
       LOCATE 20, 1: PRINT STRING$(220, 32); 'Clear dialgue area and tell
                                             'user that they can't use
                                             'anything else cause this is
                                             'just a sample game.
       LOCATE 20, 1: COLOR 2: PRINT "Use What? This is just a sample game. There's no functionality!"
    END SELECT
  END SELECT  '(*KeyPress*)

'------------------------ITEM DESCRIPTIONS------------------------------------
'This routine tells you what item you are on by looking at the current state
'of the Item% Parameter in the CALL MovePlayer() SUB.
'
  SELECT CASE item%
    CASE SWORD   'If ITEM% value is (=) to the CONST SWORD value...
         COLOR 15, 0: LOCATE 19, 1                 'Tell user they are in
         PRINT "You see a sword in front of you."; 'front of a sword.

    CASE BOOT    'If ITEM% value is (=) to the CONST BOOT value...
         COLOR 15, 0: LOCATE 19, 1                 'Tell user there are boots
                                                   'in front of them.
         PRINT "There are a pair of Timberland Boots here!"

    CASE RING    'Same concept as above applies to the rest of this routine.
         COLOR 15, 0: LOCATE 19, 1
         PRINT "There's a PHAT ring here!"

    CASE DOOR
         COLOR 15, 0: LOCATE 19, 1
         PRINT "You are at a door."

    CASE MONEY
         COLOR 15, 0: LOCATE 19, 1
         PRINT "There's a huge bag o' cash!"

    CASE PERSON2
         COLOR 15, 0: LOCATE 19, 1
         PRINT "You just ran into " + P2$; "! I wouldn't hurt her if I was you!"

    CASE PERSON1
         COLOR 15, 0: LOCATE 19, 1
         PRINT "You just ran into " + P1$ + "!!"

    CASE STAIRS
         COLOR 14, 0: LOCATE 19, 1
         PRINT "You're at the stairs!"

    CASE 0: COLOR 15, 0: LOCATE 19, 1: PRINT STRING$(79, 32);
            'If ITEM% returns a ZERO value, then just clear the dialog area
            '(Print blank lines).

  END SELECT

'****************************************************************************

LOOP UNTIL KeyPress% = 27  '<---ESC key
'This concludes the main program loop. So you see, even a simple little
'text game can be a bit involved.


ELSE  'If the Player's Character canNOT be found in the HouseMap() array
      'THEN tell the user that something is wrong, and end the program.
  CLS
  PRINT "The Player's position in the map array has NOT been found. Please see"
  PRINT "what the heck is goin on here. Okay? Thanks a bunch! -Computer Ghost"
  END
END IF

                              '(*THE END*)

DEFSNG A-Z
FUNCTION CheckFlags% (FlagArray%())
'This sub routine Checks to see if any BOOLEANS in the FlagArray% are FALSE.
'If any ARE FALSE, then it sets the function's value to FALSE, indicating that
'the user has not completed all the goals required of the the game/program.
'However, if the array contains all TRUEs, then the function's
'value is set to TRUE, and the game/program can trigger the ending sequence
'or whatever you decide to do.
'
'Parameters:
'-----------
'
'FlagArray%() -- The array containing nothing but boolean values which
'                indicated whether a user has completed a certain goal or
'                passed certain reqiurements.
'
'***********************************************************************
CONST TRUE = -1, FALSE = NOT TRUE   'Local to this function ONLY

'This FOR..NEXT loop goes from the lowest subscript of the FlagArray%()
'to the highest subscript of the FlagArray%(), checking to see if just
'ONE is false.  If one IS false, the loop will stop.
'
FOR X% = LBOUND(FlagArray%) TO UBOUND(FlagArray%)
    IF FlagArray%(X%) = FALSE THEN        'If we find a FALSE in there...
        CheckFlags = FALSE                'Return the value FALSE (0)
        EXIT FUNCTION                     'and exit this sucker!
    ELSE                                  'However...
        CheckFlags = TRUE                 'If no FALSEs were found, return
    END IF                                'the value TRUE (-1).
NEXT X%



END FUNCTION

SUB ClearPort (MapArray%())
'This SUB clears the area where the map is displayed.  This SUB is NOT
'essential for all programs, and is used just for this example program.
'Don't try to tailor this to your needs, as it'll be useless. But I'll tell
'you what it does anyway.

'This loop prints nothing but blank spaces in place of the map dimensions on
'the screen.  It has no effect on the array itself.
'
FOR X% = LBOUND(MapArray%) TO UBOUND(MapArray%)
  FOR Y% = LBOUND(MapArray%, 2) TO UBOUND(MapArray%, 2)
       LOCATE Y%, X%: PRINT CHR$(32);
       LOCATE Y%, X%: PRINT CHR$(32);
  NEXT
NEXT

END SUB

SUB DropInvItem (InventArray%(), MapArray%(), X%, Y%, Item2Drop$)
'This SUB removes an inventory item from the inventory array, removes it's
'name from the inventory list, and redisplays the dropped item on the screen
'where the user is currently located.  Altho this is no a generic SUB, I
'will tell you what's goin on anyway; maybe you can tailor this to your needs.
'
'Parameters:
'-----------
'
'InventArray%() -- The Inventory Array that's going to be changed.
'
'MapArray%()    -- You should know what this is by now...
'
'X%, Y%         -- Where you are in the MapArray%()
'
'Item2Drop$     -- The available inventory choices you can make. This
'                  also corresponds to the number of available subscripts
'                  in your InventArray%() array (In this case, five (5)).
'                  To make this more generic, what you can do is count how
'                  many subscripts are in the InventArray%(), and save it in
'                  a string variable, which can then replace the "12345" you
'                  see below. It was not done here cause this code will be
'                  changed later on.
'***********************************************************************


IF INSTR("12345", Item2Drop$) THEN              'If the user chose 1234 or 5...
 MapArray%(X%, Y%) = InventArray%(VAL(Item2Drop$)) 'Transfer the ASCII Val
                                                   'of the item in the
                                                   'InventArray%() back
                                                   'into the MapArray%()
                                                   'at YOUR current location.
                                                   'When the screen gets
                                                   'updated again, the item
                                                   'will be displayed at the
                                                   'point where you last
                                                   'stood.


 InventArray%(VAL(Item2Drop$)) = 0    'Reset that point in the InventArray%()
                                      'with a value of ZERO (0) to indicate
                                      'that nothing is there. Example:
                                      'User wants to get rid of a knife that's
                                      'located in InventArray%(2).  The ASCII
                                      'code for the kinife is 196.  This value
                                      'is replaced by a 0.  0, in the case of
                                      'this program example, means that the
                                      'user has an empty slot in their invent-
                                      'ory.
                                     
 CALL ShowInv(InventArray%())         'Redisplay the inventory, minus the
                                      'name of the item the user decided to
                                      'drop.
END IF

END SUB

SUB GetItem (MapArray%(), InventArray%(), XLoc%, YLoc%)
'This SUB gets an item defined in the MapArray%() and places it in the
'Inventory list array.
'
'Parameters:
'-----------
'
'MapArray%()    -- You should be familiar with what this is by now.
'
'InventArray%() -- The Inventory array that will contain all possible items
'                  you can obtain from the MapArray%() (Since we used ASCII
'                  values of certain characters in the MapArray%() to denote
'                  items (look at the DATA statements again!), these values
'                  will indicate exactly what item was picked up on the
'                  "map."
'
'XLoc%          -- Your Current X-Axis Location on the map.
'
'YLoc%          -- Your Current Y-Axis location on the map.
'
'**************************************************************************
CONST BLANK = 32                                    'Local to this SUB only


'This loop searches for an available slot in the InventArray%() (An available
'slot is indicated by a 0 value). If it finds an empty slot (a ZERO (0)),
'then it places the ASCII value of the item from the MapArray%() into the
'inventory at whatever Index% had the ZERO (0). This way, the inventory
'regulates itself, rather than you regulating the inventory.  Since this
'sample game has the same number of items as that of the inventory array
'subscripts, there is no checking to see if the inventory is "full." If you
'wish, you CAN do this by converting this into a function.  If there is space
'in your inventory, it'll return TRUE, and place the item somewhere in the
'inventory array.  If there isn't any room, then it'll return FALSE, and you
'can tell the user that the inventory is full and they need to drop some
'items or whatever.  Anything's possible.
'
FOR I% = LBOUND(InventArray%) TO UBOUND(InventArray%)
   IF InventArray%(I%) = 0 THEN                 'If we've found an empty slot
                                                'in our inventory...
     InventArray%(I%) = MapArray%(XLoc%, YLoc%) 'Put the item we've discovered
     EXIT FOR                                   'at (XLoc%, YLoc%) in the
                                                'MapArray%() into our invent-
                                                'ory, then exit the loop. We
                                                'don't want to fill up EVERY
                                                'empty slot with one item
                                                'do we?
   END IF
NEXT I%

MapArray%(XLoc%, YLoc%) = BLANK            'After we pick up our item
                                           'from the map, we denote it's
                                           'non-existance by replacing the
                                           'item with a BLANK (ASCII 32).
                                           'On the screen it will show
                                           'nothing but a blank space.
                                           'Please note that WE have the item
                                           'now, but it's just not on the
                                           '"floor" of the map anymore.
                                           'Get it?


END SUB

FUNCTION InKeyCode% STATIC
'This FUNCTION converts the string values that's usually returned by INKEY$
'into ASCII keyCode values.  Instead of string checking, we use integers
'instead. You can use this any ANY program! More efficent speedwise!
'Think of this as the INTEGER version of INKEY$.
'
'************************************************************************

InKeyCode = CVI(INKEY$ + STRING$(2, 0))


END FUNCTION

FUNCTION InvCheck% (InventoryArray%())
'   This FUNCTION checks to see if the inventory has ANY items in it at all.
'If it doesn't find an empty slot (designated by a ZERO (0) value in the
'array), then it increments a counter that counts how many items it runs into
'and sets the FUNCTION's value to NOTEMPTY.
'
'   This Function returns one (1) custom value, which is CONST FULL = -2.
'If you plan to use this function in an IF..THEN test condition, you must
'EXPLICITLY Check for the values 0, -1, and -2, and not just test for a non-
'zero like: IF InvCheck(ArrayName%()) THEN...  Is this clear? Good!
'
'Parameters:
'-----------
'
'InventoryArray%() -- The array that contains the contents of the user's
'                     inventory. The contents will NOT be changed.
'
'***************************************************************************
CONST EMPTY = 0                                'Local to this FUNCTION ONLY!
CONST NOTEMPTY = -1                            'Local to this FUNCTION ONLY!
CONST FULL = -2                                'Local to... You get the idea!
'---------------------------------------------------------------------------
'This LOOP cycles thru all the items in the inventory, from the first
'subscript to the last.
'
FOR X% = LBOUND(InventoryArray%) TO UBOUND(InventoryArray%)
  IF InventoryArray%(X%) <> EMPTY THEN  'If X% slot in the array is NOT EMPTY
                                        'then...
     ItemCount% = ItemCount% + 1        'Count that item and other items it
                                        'may run into...
     InvCheck = NOTEMPTY                'and tell the user that it's
                                        'NOTEMPTY.
  END IF
NEXT X%


'If The number of Items matches the highest subscript value of the inventory
'array, then tell the user that the inventory is FULL! However, in this
'example, the number of items available or the same number of slots available
'in our inventory.  For your game, you can have the user selectively drop or
'add items, when they can no longer "carry any more."
'
IF ItemCount% = UBOUND(InventoryArray%) THEN InvCheck = FULL

IF ItemCount% = 0 THEN InvCheck = EMPTY  'If ItemCounter value hasn't changed
                                         'from ZERO (0), then obviously
                                         'the Inventory is EMPTY, cause there
                                         'were no items in the array to COUNT!

END FUNCTION

SUB LoadBarrierData (BarrierArray%())
'SUB This SUB loads up the "barrier" data for the map. If the player runs
'into one the ASCII values listed, then he or she will not be able to
'move beyond it.
'
'Parameters:
'-----------
'
'BarrierArray%() -- The array that contains items or objects in the Map
'                   table array that the user cannot move over or pass thru.
'
'***************************************************************************

BarrierArray%(1) = 179 ' -- defined as a wall in the HouseMap() array
BarrierArray%(2) = 196 ' -- defined as another wall in the HouseMap() array

END SUB

SUB MovePlayer (MapArray%(), BoundArray%(), KeyPressed%, CurrentXLoc%, CurrentYLoc%, item%)
'This sub moves the player around the 2-D array map.  It's important to
'know that this sub MUST be called continuously, throughout the program!
'
'Parameters:
'-----------
'
'MapArray%()  - The map that's being passed to this procedure. In this example,
'               it's passing "HouseMap()". It's to be sure that this routine
'               is generic as possible, so anyone could use it, without
'               requiring nothing more than the .BI file for this program.
'
'KeyPressed%  - The ASCII key value of whatever key was pressed. If this
'               routine is to be used, it's imperative that you use the
'               K% = InkeyCode% function in your program.  I use it cause it's
'               faster than handling that CHR$(0) + CHR$(56) stuff. A LIB
'               of all these routines will be available at some point.
'
'CurrentXLoc% - The Current X-Axis Location in the array.  If you're at (8,9)
'               when you start, then you're at:
'
'                              X-Axis   1234567890
'                            <-------------------
'                                                | 1
'                                                | 3
'                                                | 5
'                                                | 7
'                                              x  | 9
'                                                 | Y-Axis
'                                                 
'
'               From this illustration, it's appearant that what we used to
'               refer to as "ROW" using a LOCATE statment, is now the
'               "COLUMN" (Y-Axis), and the "COLUMN" in reference to a LOCATE
'               statment is now the "ROW"(X-Axis). In other words, we're
'               referencing the array is if it were in a graphic SCREEN mode,
'               where instead of ROW, COLUMN, it's COLUMN, ROW.  Why do I
'               bring this up? Because if you decide to think of the array
'               as the standard ROW, COLUMN, you'll screw up. That's why in
'               the LOCATE statement in the main module, I have LOCATE Y%, X%
'               NOT LOCATE X%, Y%.  Remeber this! For if you use these
'               routines, you gotta load your MAP as I did in this program!
'
'CurrentYLoc% - The Current Y-Axis Location in the Array.  If you're at
'               (8,9) when you start the game, then you're at:
'
'                              X-Axis   1234567890
'                            <--------------------
'                                                 | 1
'                                                 | 3
'                                                 | 5
'                                                 | 7
'                                              xĴ| 9
'                                                 | Y-Axis
'                                                 
'
'Item%        - If, in the array, you stumble across anything except a
'               32 (SPACE), this will tell you what it is, ASCII key value
'               style.  You can use this to detect all sorts of things you
'               defined in your array.  If you run into a 179 (Defined as a
'               wall/boundary in this example), then in your loop you could
'               have code to handle that "collision."  There are other
'               possible uses.  Have fun!
'               NOTE: Item% returns ZERO (0) if there is nothing there.
'**************************************************************************
CONST UP = 18432, DOWN = 20480, LEFT = 19200, RIGHT = 19712 'Local use only!

X% = CurrentXLoc%      'Assign the current location values
Y% = CurrentYLoc%      'into terms of X% and Y% for easier understanding
'-------------------------------------------------------------------------

SELECT CASE KeyPressed%
  CASE UP
    'If the Y% Location (LOC) isn't at the lower end of the MapArray% (The
    'one (1) is added because we don't want to include the BORDERS in the
    'actual playing field. Example: Here's a sample map:
    '                                            x,y
    '           (X-Axis)           DIM SampleMap(1 TO 9,1 TO 7) AS INTEGER
    '           123456789         
    '           |-------| 1
    '           |       | 2
    '           |       | 3
    '           |       | 4  (Y-Axis)
    '           |       | 5
    '           |       | 6
    '           |-------| 7
    '
    'Notice the dimensions? They INCLUDE the borders, "|" and "-"!
    'The user doesn't want to move around on the walls (unless you want em
    'to), so u gotta set the wall boundaries so that you cannot move on the
    'walls and only within the wall space. Therefore, the dimensions of the
    'area that the user can only move within is:
    '
    '               SampleMap(2 TO 8, 2 TO 6)
    '
    '                        (X-Axis)
    '                        2345678  <----See? The borders aren't included
    '                       |-------|      in the area that the user can move
    '                       |you can| 2    around in.
    '                       | only  | 3
    '                       |move in| 4  (Y-Axis)
    '                       | this  | 5
    '                       | box!  | 6
    '                       |-------|
    '   
    '     Get it? No? Well consider the original dimensions again:
    '                   DIM SampleMap(1 TO 9, 1 TO 7) AS INTEGER
    '
    '               And our movable area dimensions:
    '                   SampleMap(2 TO 8, 2 TO 6)
    '
    '     Say you're going UP, and you change the value of the Y% until you
    'have reached the end of the map array. Without the "+ 1" you see below,
    'your 'movements' would also include the wall, where you DON'T want to
    'be. However, if you INCREMENT it ahead of time by 1, you'll be able to
    'check for the "wall" sooner, and your movements wouldn't include _THE_
    'wall.  The LBOUND of the SampleMap would be 1 (in 2D arrays, it only
    'looks at the "X" value (ex. Array%(X,Y)), which in our cheap illustration
    'includes a "|" as a wall. If 1 is added to that, then the value would be
    'a 2. So if I wanted to move along the X-Axis and I reached the X location
    'value of 2, and I ran into the Lower BOUNDs of the SampleMap + 1, I would
    'have to stop right there, cause my X location would be 2, plus the lower
    'bounds of the array (which is 1 in this case! Use OPTION BASE ALWAYS!)
    'with 1 added to it = 2.  See? I hope so...  Can't explain it better than
    'that.
    '
    '   In the case below, we use LBOUND(MapArray%) cause the LBOUND of ANY
    'portion of this array is one (1).  I could have put a 1 in place of
    'the LBOUND(array%) but it would be unreadable and hard to follow.
    '
    IF Y% <> LBOUND(MapArray%, 2) + 1 THEN 'If we make it beyond this point we
    '(*"IF THERE'S A WALL"*)             'haven't run into any "walls."

      'This loops checks to see if the current X%,Y% location contains
      'any barriers, such as a wall part like "" (179) or "" (196) as
      'defined in the BoundArray%().  By the way, I designed this so that
      'all you need to do is add an ASCII value of whatever item or character
      'you used in your HouseMap() to the BarDat() Array, in oder for the
      'user to not be able to penetrate/pass it. Since our BoundArray%()
      'only contains two things that can't be moved beyond, it'll loop
      'twice. Please note that as the list gets longer, the testing
      'gets longer.
      '
      FOR I% = LBOUND(BoundArray%) TO UBOUND(BoundArray%)
       'IF an Object at user Location X%,Y% is listed in the BoundArray%()
       '"listing", then just EXIT the SUB; you can't move past whatever
       'it is anyway...
       '
       IF Object(MapArray%(), X%, Y% - 1) = BoundArray%(I%) THEN EXIT SUB
      NEXT I%

         Y% = Y% - 1     'Since we made it to here and there are no
                         'barriers in the way, we can safely update our
                         'user's position. We SUBTRACT -1 from Y% to show that
                         'the player's going up in the array.
                         'Just to let you know, all that
                         'X, Y testing before was for the CURRENT location.
                         'We have now "Moved" to Y% Loc in our HouseMap.

         IF Object(MapArray%(), X%, Y%) THEN 'Now. At our NEW loc, we check
         '(*Object Testing*)                 'to see if there are any OBJECTS
                                             'there. If there is, the ASCII
                                             'value of the object (an item
                                             'perhaps?) as defined by the
                                             'HouseMap in the main module
                                             'will be returned, which you can
                                             'do with as you wish. This is
                                             'good for when the user runs
                                             'over an item, he/she can pick it
                                             'up, or you can pick it up for
                                             'them.  NOTE: For you greenhorns,
                                             'if the condition is true, it'll
                                             'return a non-zero. Any non-zero
                                             'is considered true with an
                                             'IF..THEN (unless u say otherwise)
                                             'condition.

          item% = Object(MapArray%(), X%, Y%) 'Return the ASCII value of the
                                              'object on the HouseMap "Floor".

         ELSE                                 'If NO Object was found (This
                                              'Object Function screens out
                                              'the ASCII 32's (spaces))...
          item% = 0                           'Then return a ZERO (0) for item
                                              'to show that no item was
                                              'detected....

         END IF  '(*Object testing*)
    END IF       '(*"IF THERE'S A WALL"*)


    CASE DOWN
        'The rest of this mess is the same as the above, except:
        '1) Yer going DOWN, LEFT, and RIGHT
        '2) In the case below, we're using UBOUND(Array%,2) cause we need
        '   to get at the last subscript of the second dimension.  Put the
        '   cursor under it and hit F1 to find out more info.
        '
        IF Y% <> UBOUND(MapArray%, 2) - 1 THEN 'If there aren't any WALLS going DOWN...
         FOR I% = LBOUND(BoundArray%) TO UBOUND(BoundArray%)
          'Check objects against our boundary array to see if we can
          'continue.  If there's a boundary, we EXIT the SUB.
          '
          IF Object(MapArray%(), X%, Y% + 1) = BoundArray%(I%) THEN EXIT SUB
         NEXT I%

          Y% = Y% + 1 'Update the player's position. We ADD +1 to Y% to
                      'show that he's going DOWN. In the case of going UP,
                      'we SUBTRACT -1 from Y%.

          IF Object(MapArray%(), X%, Y%) THEN    'If an object found, return
             item% = Object(MapArray%(), X%, Y%) 'the Item% value.
          ELSE
             item% = 0                           'If no object found, return
          END IF                                 'zero for Item%.
        END IF

    CASE LEFT
        IF X% <> LBOUND(MapArray%) + 1 THEN  'If no walls going LEFT...

         'Check for other boundaries...
         'If found, EXIT SUB.
         '
         FOR I% = LBOUND(BoundArray%) TO UBOUND(BoundArray%)
          IF Object(MapArray%(), X% - 1, Y%) = BoundArray%(I%) THEN EXIT SUB
         NEXT I%
          X% = X% - 1  'Update player's position, SUBTRACTING -1 from X% to
                       'go to the LEFT.

          IF Object(MapArray%(), X%, Y%) THEN     'If object found, return
             item% = Object(MapArray%(), X%, Y%)  'Item% value.
          ELSE
             item% = 0                            'If none found, return zero
          END IF                                  'for Item% value.
        END IF

    CASE RIGHT
        IF X% <> UBOUND(MapArray%) - 1 THEN      'If no WALLS going RIGHT...

      'Check for boundaries; EXIT SUB if any found
      '
      FOR I% = LBOUND(BoundArray%) TO UBOUND(BoundArray%)
       IF Object(MapArray%(), X% + 1, Y%) = BoundArray%(I%) THEN EXIT SUB
      NEXT I%
          X% = X% + 1    'Update player's position by ADDING +1 to X% to
                         'go to the RIGHT.

          IF Object(MapArray%(), X%, Y%) THEN    'If object found, return
             item% = Object(MapArray%(), X%, Y%) 'Item% value, blah blah blah.
          ELSE
             item% = 0                           'Return zero if none found.
          END IF
        END IF

END SELECT

CurrentXLoc% = X%  'After all is said and done, return the NEW coords of
CurrentYLoc% = Y%  'the player.

END SUB

FUNCTION Object% (MapArray%(), X%, Y%)
'This FUNCTION Detects whether or not the present (X%,Y%) location has
'a value other that a BLANK space in it. It's used to detect walls, items,
'people, etc.
'
'Parameters:
'-----------
'
'MapArray%() -- The array containing out HouseMap() as defined in our
'               DATA statements.
'
'X%, Y%      -- The X and Y coordinates of where the user is in respect to
'               the map dimensions.
'
'*************************************************************************
CONST BLANK = 32               'BLANK is CHR$(32) (Space). Local use only!

IF MapArray%(X%, Y%) <> BLANK THEN  'IF the location doesn't contain a
                                    'BLANK (CHR$(32))....
   Object = MapArray%(X%, Y%)       'Then return whatever item value is at
                                    'coords X%, Y%.
END IF

END FUNCTION

FUNCTION PlayerStart% (MapArray%(), PlayerChar%, CurXLoc%, CurYLoc%)
'This FUNCTION detects the user's starting point in the array. In this example,
'it's gonna be (8,9).
'
'Parameters:
'-----------
'
'MapArray%()  - The 2-D Map being looked at.
'
'PlayerChar%  - Whatever ASCII character value yer using for your player.
'               If yer using CHR$(2), then that's what it'll look for. If
'               it's CHR$(17), then it'll look for that, and so on.
'
'CurXLoc%     - Current X Location. Wherever you are on the X-Axis in the
'               array.  This value is returned.
'
'CurYLoc%     - Current Y Location. Wherever you are on the Y-Axis in the
'               array.  This value is returned.
'
'PlayerStart  - This function will return a TRUE (-1) if the player has been
'               found in the grid, and FALSE if it hasn't. This is really
'               more of a debug feature rather than anything useful.
'**************************************************************************
CONST BLANK = 32      'The ASCII Value for a space in the map. Local use only!
CONST TRUE = -1        'BOOLEAN for Local use!
CONST FALSE = NOT TRUE 'BOOLEAN for Local use!
CONST NOTDEF = -2  'Means that parameter PlayerChar% has NO value! Local use!


IF PlayerChar% THEN  'If a PlayerChar% value is there (NON-ZERO)...

  'This FOR loop loops until it reaches the Upper bound of the X-Axis.  It's
  'looking for the Player%.  Player% is the ASCII value of whatever character
  'it comes across in the MapArray%(). If it matches with the ASCII value of
  'the character YOU wanted to start with, it retrieves the X,Y location
  'of where it was found.
  '
  FOR X% = LBOUND(MapArray%) TO UBOUND(MapArray%)
   FOR Y% = LBOUND(MapArray%, 2) TO UBOUND(MapArray%, 2)
    Player% = MapArray%(X%, Y%)     'Bring in all ASCII values of the map
      IF Player% = PlayerChar% THEN 'If PLAYER% value equals the PlayerChar%
                                    'that was defined...
          MapArray%(X%, Y%) = BLANK 'Put a BLANK (ASCII 32) there
                                    '(Since we no longer need this info!),
          CurXLoc% = X%             'return the X-Axis position of the player,
          CurYLoc% = Y%             'return the Y-Axis position of the player,
          PlayerStart = TRUE        'Set FUNC to TRUE since we found starting
          EXIT FUNCTION             'point, and exit this function.
      END IF
   NEXT Y%
  NEXT X%
          PlayerStart = FALSE       'If we've made it here, then obviously
                                    'the FOR loop finished, and it couldn't
                                    'FIND the freakin Player% Character
                                    'anywhere in the array! I find that this
                                    'could be useful in EXE compilation, if
                                    'you decide to use DATA statements in yer
                                    'EXE. See the warning on DATA statements
                                    'in the main module.
ELSE

  PlayerStart = NOTDEF              'This is REALLY for DEBUGGING. Since
                                    'you haven't defined a value for
                                    'PlayerChar% in the parameters, we return
                                    'a -2 (NOTDEF).
END IF

END FUNCTION

DEFINT A-Z
SUB SetGameFlags (FlagArray%())
'This SUB Initializes all possible goals you can get to FALSE. This is good
'for RPG gaming, when you have your character complete certain tasks thruout
'your game.  However, the flag checking in this program example is only
'used to detect whether or not you have completed everything; if so, then
'you can run a SUB to do your ending sequence or whatever. You can probably
'modify this so that you can use it to track WHAT goals have been completed
'as opposed to HOW MANY goals have been completed.  The Example:
'
'DIM Flags(1 TO 20, 1 TO 2) AS STRING * 10
'
'Flags(1) = "TALKALIEN"  <--Talked to an Alien
'Flags(2) = "GOTGOLD"    <--Obtained some gold
'Flags(3) = "GOTLAID"    <--Guess?
'.
'.
'Flags(20) = "KILLDKING" <--Killed the king
'
'You get the idea. Instead of checking for a FALSE value (like in the
'CheckFlags FUNCTION), just check for a string indicating what tasks have
'been completed, and run a SUB or something in response. My example used
'lengthy strings, but yours can be as small and cryptic as you like. Heck,
'You can even use INTEGER values! Be creative!
'
'Parameters:
'-----------
'
'FlagArray%() -- The array that will contain BOOLEANS to check if any task
'                has NOT been completed before allowing you to complete
'                your mission and show the "YOU'VE WON" message.
'
'***************************************************************************
CONST FALSE = 0                                             'Local Use ONLY!


FOR X% = LBOUND(FlagArray%) TO UBOUND(FlagArray%) 'Cycle thru the FlagArray%()
   FlagArray%(X%) = FALSE                         'Initial everything to FALSE
NEXT X%


END SUB

DEFSNG A-Z
SUB ShowInv (InventArray%())
'This SUB is responsible for showing you the contents of your inventory.
'This SUB is tailor made just for this example, so I don't recommend you try
'to use this AS IS in one of your own programs.  You can probably gather an
'idea from this though. If you wanted to, you could use a 2D array for the
'inventory, and not have to do what you see below.  In the 2D inventory, not
'only could you have the number of an inventory item, but the description
'along with it.  Example:
'
'DIM Inventory(1 TO 5, 1 TO 1) AS STRING * 12
'
'Inventory(1,1) = "+"          <--an item that you defined
'Inventory(1,2) = "Big Sword"  <--Item description
'
'But I didn't do this cause of simplicity, and the fact that some dude
'wanted a demo of something like this really bad, so I wanted to cut a few
'corners.
'
'**************************************************************************
FOR X% = LBOUND(InventArray%) TO UBOUND(InventArray%)
    IF InventArray%(X%) <> 0 THEN             'If the slot's not blank...
       LOCATE X% + 1, 51                      'Locate Inventory box
       COLOR 15: PRINT LTRIM$(STR$(X%)); ") "; 'Print the number of the item
       COLOR 14: PRINT CHR$(InventArray%(X%)); 'And print the Item itself.
       SELECT CASE InventArray%(X%)            'See what ASC val of the item
                                               'is, check it against the
                                               'CONSTants as defined in the
                                               'main module, and print out
                                               'the description it matches.
        CASE MONEY: COLOR 12: PRINT " - Money Bag!"
        CASE BOOT: COLOR 12: PRINT " - Timberland Boots"
        CASE SWORD: COLOR 12: PRINT " - Double-Edged Sword"
        CASE RING: COLOR 12: PRINT " - Invisiblity Ring"
       END SELECT
    ELSEIF InventArray%(X%) = 0 THEN              'If there's an empty slot
        LOCATE X% + 1, 51: PRINT STRING$(26, 32); 'Just print a blank in the
                                                  'description's place.
    END IF
NEXT X%

END SUB

SUB ShowMove (MapArray%(), KeyPress%, X%, Y%)
'This SUB shows the movement of the player on the screen (If SHOW MAP
'is enabled).  Please note that this SUB is ONLY for this example, and will
'NOT be thoroughly commented.  If you figger you can use this in any of your
'own programs, go right ahead.
'
'****************************************************************************
CONST UP = 18432, DOWN = 20480, LEFT = 19200, RIGHT = 19712  'Local use only!


'This loop is constantly being called throughout the program to update
'the display of the MAP.
'
FOR a% = 1 TO 10
  FOR B% = 1 TO 10
       LOCATE B%, a%: PRINT CHR$(MapArray%(a%, B%));
       LOCATE Y%, X%: PRINT CHR$(35);  '# - what we use for the player's char
                                       'on screen.
  NEXT B%
NEXT a%

SELECT CASE KeyPress%                     'Update player's movement in the
   CASE UP, DOWN, LEFT, RIGHT             'MAP array.
     LOCATE Y%, X%: PRINT CHR$(35);
END SELECT

END SUB

