

   This file describes [1mClipHistory[0m, version 1.0, a program that adds
a history to the clipboard.

Introduction
************

   This is a program that I've been thinking of doing for a long time,
but I haven't actually implemented it until now. I think first I got
the idea when I had used the history feature of [1mPowerSnap[0m (by Nico
Franois) a little while. I soon realised that it was a very
convenient feature.

   But other programs uses the clipboard as well. The history
[1mPowerSnap[0m maintains only applies to the text that [1mPowerSnap[0m
writes to the clipboard, not the ones e.g. my editor writes. And I
thought that it would indeed be useful to have them in a history too.

   One problem with such a history is that it easily can eat up a lot
of memory, since cuts and copies in an editor can be rather large at
times. To remedy this problem, there are several filtering options,
that limits the amount of memory [1mClipHistory[0m may use. But more about
this later on in this document.

   One interesting detail: [1mClipHistory[0m is a completely system friendly
program, in that it doesn't patch any functions at all. It only uses
well documented features of the operating system. This does have a
minor drawback: [1mClipHistory[0m can miss clips, if several clips are
written in a very short time. But this shouldn't be any problem, I
think.. :)

Legal information
*****************

       [1mClipHistory[0m is freeware, i.e. copyrighted, freely distributable
software. Feel free to use and copy this program, as long as the
following restrictions are fulfilled:

   *  All files are copied without any alterations. If any extra files
     are added, it must be obvious that they don't belong to the
     original distribution, nor that they don't must be included in any
     redistribution.

     Exception: So called "BBS ads" may [3mnot [0mbe added.

   *  The copying is done on a non-commercial basis. A small fee to
     cover media costs etc. may be charged.

   *  The copier isn't claiming the copyright of this program.

   Any exeptions from the above requires a written permission from the
author.

No warranty
===========

   THERE IS NO WARRANTY FOR THE PROGRAMS, TO THE EXTENT PERMITTED BY
APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
HOLDER AND/OR OTHER PARTIES PROVIDE THE PROGRAMS "AS IS" WITHOUT
WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
OF THE PROGRAMS IS WITH YOU.  SHOULD THE PROGRAMS PROVE DEFECTIVE, YOU
ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

   IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
REDISTRIBUTE THE PROGRAMS AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL
DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAMS
(INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF
THE PROGRAMS TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER
OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

System requirements
*******************

       [1mClipHistory[0m have very modest system requirements. It needs OS
2.04 or better, although OS 3.0 or better will make [1mClipHistory[0m
operate slightly better.. :)

   If you have [1mReqTools[0m (by Nico Franois) installed, then
[1mClipHistory[0m will use [1mReqTools[0m for its requesters (you can
disable this if you like). Otherwise the "normal" system requesters
will be used.

Installation
************

       [1mClipHistory[0m is easy to install. Simply copy the program (and
its icon) to [1mWBStartup[0m, or whereever you find convenient. If you have
OS 2.1 or better, you might want to copy a catalog file as well, to make
[1mClipHistory[0m operate in another language than english.

   The easiest way is to let the [1mInstaller[0m do it (if you have it that
is!  :). If not, copy the file [1mcliphistory.catalog[0m as found in the
[1mCatalogs/<language>[0m drawer to [1mLocale:Catalogs/<language>[0m (or to a
the drawer [1mCatalogs/<language>[0m in the same drawer as you placed
[1mClipHistory[0m. In either case, <language> should be one of the
languages you have select in the [1mLocale[0m preferences editor.

   If there is no catalog file for your language, please try to fill in
the file [1mEmpty.ct[0m in the [1mCatalogs[0m drawer and send it to me. I will
then include the catalog in the next release of [1mClipHistory[0m.

Usage
*****

   To use [1mClipHistory[0m, you first make sure that the tooltypes are set
up properly. Then start it. You can also start if from a shell, but
then you must remember to [1mRun[0m it (and to write suitble arguments). To
make it permanently installed, simply drop it into [1mWBStartup[0m, or
enter a suitable line in your [1mS:User-Startup[0m file.

       [1mClipHistory[0m installs itself as a commodity, so you can use the
Commodities [1mExchange[0m program to show the interface, disable/enable it,
or remove it completely. Starting [1mClipHistory[0m a second time (for the
same clipboard unit) will cause the first copy to show the interface.
Pressing the hotkey will also open the interface ([1mCX_POPKEY[0m, see
Options).

   The user interface of [1mClipHistory[0m is very simple; it contains of a
window with a list gadget. This list contains all the remembered clips.
There is also a menu attached (see Menus).

   The text showed in the list is either the text - if it is a text
clip - or the type of the IFF clip (everything on the clipboard should
be in IFF format), followed by its size (in bytes). If you have OS 3.0
or higher, the non-text clips will be shown in bold (or at least
something similar to bold).

   To select an item in the list, you either click once on it with the
mouse, or you use the cursur up/down keys (optionally with the
shift/alt/ctrl qualifiers) to highlight the requested item.

   To copy an item to the clipboard, you double-click on the item, or
press return when the proper item is selected. Unless the [1mSTICKY[0m
option (see Options) have been used, the window will close.

   Escape closes the window.

Menus
*****

   The window [1mClipHistory[0m opens have the following menus:

[1mProject[0m
    [1mSave clip as...[0m
          This allows you to save the currently selected item to a file
          of your choice.

    [1mAbout...[0m
          Shows some information about the program and the history.

    [1mHide[0m
          Close the window, but don't quit.

    [1mQuit[0m
          Close the window and quit.

[1mEdit[0m
    [1mDelete...[0m
          This will delete the currently selected item. You can also
          press Del to do this.

    [1mDelete all...[0m
          This will delete [3mall [0mclips in the list. You can also press
          Shift-Del to do this.

[1mOptions[0m
    [1mCreate icons?[0m
          If checked, then icons will be created for the files you
          save. This is the same as the option [1mCREATEICONS[0m (see
          Options).

    [1mSave text as IFF?[0m
          If checked, then text clips (those that shows up as "normal"
          text in the window) will be saved as IFF files. If you save
          them as normal text, then some information might be lost
          (technical note: all CHRS chunks will be saved, but no
          other). Same as the option [1mTEXTASIFF[0m (see Options).

    [1mReqTools?[0m
          If checked, then [1mReqTools[0m will be used for requesters, if
          [1mReqTools[0m is available, that is. Same as the option
          [1mREQTOOLS[0m (see Options).

Options
*******

   Options can be specified in the tooltypes (when starting from the
[1mWorkbench[0m) or on the command line (when starting from a [1mShell[0m).

[1mCX_PRIORITY[0m
     This value specifies the priority [1mClipHistory[0m will have in the
     commodities input chain. This priority only applies to the hotkey.
     Default is 0. Accpted range is -128 to 127.

[1mCX_POPKEY[0m
     This specifies the hotkey to use to open the window. Default is
     "control lalt c". Please refer to your Amiga manual for more
     information about hotkey descriptors.

         [3mNote: [0mIf this string is 100 chars long or more,
     unpredictable things may happen when you open the window. There is
     (currently) no check for this.  I hope this doesn't cause any
     problems for anyone... :)

[1mCX_POPUP[0m
     If YES, then [1mClipHistory[0m will open the window upon startup (this
     is the default). Use NO to disable this.

[1mCLIPUNIT[0m
     This value specifies the clipboard unit to use. Default is 0.
     Accepted range is 0 to 255.

     You can start one copy of [1mClipHistory[0m for each clipboard unit. In
     Commodities [1mExchange[0m, the name will be "ClipHistory <unit>",
     where <unit> is the unit you specify here.

[1mTOOLPRI[0m
     This argument specifies the "normal" priority for [1mClipHistory[0m.
     To make sure that [1mClipHistory[0m doesn't miss any clips, even if
     the computer is doing much work, you might want to rise the task
     priority of [1mClipHistory[0m. Default is to use whatever priority
     [1mClipHistory[0m was started in (this is normally 0). Accepted range
     is -128 to 4.

     Note: The [1mWorkbench[0m also supports the [1mTOOLPRI[0m tooltype. It was
     added to [1mClipHistory[0m so that [1mShell[0m users easily can change the
     priority as well.

[1mWORKPRI[0m
     Some operations [1mClipHistory[0m does can take a little time
     sometimes.  Here you can specify the priority [1mClipHistory[0m should
     use during this time, so that other programs can run normally.
     Usually a negative value should be entered. Default is not to
     change the priority. Accepted range is -128 to 4.

[1mSILENT[0m
     If YES, then don't display any requesters for "clip operation
     errors", like when there was a problem reading/writing to the
     clipboard, or when there wasn't enough memory to save a clip.
     Default is NO.

[1mPUBSCREEN[0m
     This specifies the public screen on which [1mClipHistory[0m should
     open its window on. Default is the frontmost screen if it is
     public (if [1mOPENONALL[0m is on, it will use the frontmost screen
     anyway), or the default public screen.

[1mOPENONALL[0m
     If YES, then [1mClipHistory[0m will open on the frontmost screen,
     regardless if it is public or not. Default is NO.

         [3mNote: [0mIn order for this to work properly, a function in
     [1mIntuition[0m ([1mCloseScreen()[0m) needs to be patched (this patch
     is only installed if this option have been activated). This might
     make it impossible for [1mClipHistory[0m to remove itself from the
     system if some other program have patched the same function. If
     you have a [1mSetMan[0m-like program installed, this should never
     happen.

[1mFONTNAME[0m
     This string specifies the name of the font (including the ".font"
     extension) to use for the window/menus. If not specified, then the
     current screen font is used. You must specify both [1mFONTNAME[0m and
     [1mFONTSIZE[0m.

     Hint: If you have MagicWB, it can be a good idea to use e.g.
     XHelvetica, since that font is "complete", i.e. chars than
     normally aren't printable holds graphics to identify the char in
     question.

[1mFONTSIZE[0m
     This value specifies the size of the above font. You must specify
     both [1mFONTNAME[0m and [1mFONTSIZE[0m.

[1mWINDOWLEFT[0m
     Initial left edge of the window. Default is to center the window
     on the screen.

[1mWINDOWTOP[0m
     Initial top edge of the window. Default is to center the window on
     the screen.

[1mWINWIDTH[0m
     Initial width of the window. Default is <width of the screen>/2.

[1mWINHEIGHT[0m
     Initial height of the window. Default is <width of the screen>/3.

[1mSTICKY[0m
     If YES, [1mClipHistory[0m won't close the window after writing a clip
     to the clipboard. Default is NO.

[1mPOPSCREEN[0m
     If YES, then [1mClipHistory[0m will - when closing its window -
     restore the screen that was in front before the window was opened.
     This only needs to be done if that screen wasn't public. Default
     is NO.

         [3mNote: [0mUsing either [1mPUBSCREEN[0m, [1mOPENONALL[0m or [1mSTICKY[0m will
     disable this option.

[1mSAVEPOS[0m
     If YES, then [1mClipHistory[0m will remember the current position of
     the window when you close it. Otherwise it will reopen using the
     position specified in the arguments (or the defaults). Default is
     NO.

[1mSAVESIZE[0m
     If YES, then [1mClipHistory[0m will remember the current size of the
     window when you close it. Otherwise it will reopen using the size
     specified in the arguments (or the defaults). Default is NO.

[1mMAXCLIPS[0m
     Maximum number of clips that the history can hold. Any value
     accpted. Note that 0 really means 1... Default is 32767 (the
     listview handling routines in the OS can't cope with more, so.. :).

[1mMAXCLIPSIZE[0m
     If the clip is larger than this value, then it will not be saved
     in the history. Using 0 here will disable the history. Default is
     the [1mMAXMEM[0m limit (see below) if that one is specified. Otherwise
     there is no limit.

[1mMINCLIPSIZE[0m
     If the clip is smaller than this, then it will not be saved in the
     history.  Default is 0.

     Please note that this refers to the total size of the clip,
     including the extra overhead due to the IFF file format. For a
     minimal IFF file (as saved by e.g. [1mPowerSnap[0m), this overhead is
     20 bytes. Also, an IFF file is (read: should be) always padded to
     an even number of bytes.  Thus, a relatively useful minimum could
     be 22, which would force each saved clip to have at least 3 data
     bytes (when talking about saved text at least).

[1mMAXMEM[0m
     This specifies how much memory the history may use at most. The
     history is dynamically allocated, using so called memory pools (to
     reduce memory fragmentation). Thus, the actual amount of memory
     used might be a little more than this value. Default is no max
     (other than the amount of free memory :).

[1mMATCH[0m
     If YES, check all new items against the last one, and only save
     the new one if it is different. Default is NO.

[1mFULLMATCH[0m
     Like [1mMATCH[0m, but check [3mall [0mentries instead. Default is NO.

         [3mWarning: [0mThis can take some time if you have a large history
     ([1mClipHistory[0m will use the [1mWORKPRI[0m (see above) during this
     check). If more than one clip is written to the clipboard during
     this time, only the last one will be remembered.

[1mCASE[0m
     If NO, then [1mClipHistory[0m will ignore the case when comparing two
     clips (when either [1mMATCH[0m or [1mFULLMATCH[0m have been used).
     Obviously, this is only possible when the clip contains text
     (FTXT).  Default is YES.

[1mFILTER[0m
     Here you can specify which IFF types that should be saved (or not
     saved, if [1mREJECT[0m have been specified). Space separate the items.
     Case [3mis [0mimportant. There are many different IFF types available,
     and I can't mention them all, but here is a list over the most
     common ones:

    [1mFTXT[0m
          Text. ConClip and PowerSnap saves these ones.

    [1mILBM[0m
          Graphics/palettes. Saved by e.g. IconEdit.

    [1m8SVX[0m
          Sound (samples).

[1mREJECT[0m
     Make the [1mFILTER[0m (see above) reject on a match instead of accept,
     i.e.  reverse the action of the filter.

[1mTEXTASIFF[0m
     If YES, then FTXT clips will be saved as normal text instead of as
     an IFF file. All clips that shows up as "normal" text in the
     window are FTXT clips. Note that some information may be lost
     (e.g. font information). Default is NO.

[1mCREATEICONS[0m
     If YES, then an icon will be created for each clip saved. Default
     is NO.

[1mREQTOOLS[0m
     If YES, then [1mClipHistory[0m will use [1mReqTools[0m for requesters, if
     it should be available. Default is YES.

Future
******

   There are a few things I might add to [1mClipHistory[0m:

   *  More IFF parsing. Now it is minimal, only reading/writing exactly
     what is on the clipboard, with a minor "support" for FTXT.
     Enhanced parsing could e.g. reduce the overhead for FTXT clips, by
     only saving the actual text.

   *  Separate accept and reject filters. I would need to alter the way
     they are specified though (now I'm using [1mReadArgs()[0m "[1m/M[0m"
     specifier for this, and [1mReadArgs()[0m don't like several "[1m/M[0m"
     specifiers in one template.. :).

   *  Load of single clips and/or load/save of the entire history.

   *  Prefs window, to edit/save the settings. Perhaps as a separate
     prefs program.

   *  A way to view a large clip in full. I'm not sure how, but
     something could be nice. Perhaps writing the clip to a temporary
     file, and let some viewer program handle it (like [1mMultiView[0m)?

   *  Some other way of "highlighting" non-text clips on OS 3.0 or
     better.  Problem is that I don't know how I should change it.
     Please tell me if you have any ideas.

   *  Make a [1mTriton[0m version (maybe [1mClipHistory[0m will require
     [1mTriton[0m).

   None of these things are important for me, but feel free to send me
a note telling me what *you* would like to see added (see Author
contact).

Author contact
**************

   Feel free to send comments, bug reports, money, or whatever, to:

     S-mail:  Magnus Holmgren
              Rydsvgen 254 A:14
              S-582 51  Linkping
              SWEDEN
     
     E-mail:  cmh@augs.se (internet) or 2:204/404.6 (fidonet).

Acknowledgements
****************

   Thanks go to the following persons:

[1mNico Franois[0m
     His program [1mPowerSnap[0m inspired me do write this program in the
     first place. He also sent me a few small (but useful) functions I
     needed, and came with a few suggestions/bug reports.

[1mNikolai Waldman[0m
     Suggestions.

[1mMichael Berg[0m
     Bug report and suggestions.

Program history
***************

   Version 1.0: Initial release.

