/****************************************************************************

    Module  : FreeDock.h

    Version : v1.0alpha

    Date    : 20/8/93

    Changes : 20/8/93 - Added decl for RePaintSlot


*****************************************************************************/

#define VersionText "v1.07"


#include <windows.h>

#define STRICT

/*******************************************************************************
    Include file with data defs for dock program
*******************************************************************************/

#define DEFAULT_NUM_SLOTS   10     // Default number of slots

#define SLOT_FREE           0      // Slot is being used
#define SLOT_USED           1      // slot is empty

#define START_MINIMUM       0
#define START_MAXIMUM       1
#define START_NORMAL        2
#define START_STORE         3

#define SLOT_SPECIAL_TITLE  10     // slot is a special slot type (Tile Icon)
#define SLOT_SPECIAL_EXIT   11     // slot is a special slot type (Exit Windows)
#define SLOT_SPECIAL_CLOCK  12     // slot is a special slot type (Clock slot)
#define SLOT_SPECIAL_MAIL   13     // slot is a special slot type (Mail Check)

#define MAX_FPATH_LEN       128    // Max length of a path
#define TMP_BUFF_LEN        32     // Length of temp string buffer in main
#define MAX_CMDLINE_LEN     256    // Max len of command line

#define SLOT_BUTTON_WIDTH   38     // 32x32 icon + border of 3 on each side
#define SLOT_BUTTON_HEIGHT  38     // ditto

#define DOCK_LEFT           0
#define DOCK_RIGHT          1
#define DOCK_TOP            2
#define DOCK_BOTTOM         3

#define DEF_STORE_X         0       // Initial non-fatal values for
#define DEF_STORE_Y         0       // stored window position, incase
#define DEF_STORE_W       400       // user selects "stored" without
#define DEF_STORE_H       200       // then grabbing a window


#define MAIL_TIMER	    1	    // Timer ID for the mail checking slot

/******************************************************************
    Data structure to hold all data relating to a single slot 
******************************************************************/

typedef struct _SLOT_ENTRY{
    UINT        SlotType;                   // type of the slot
    char        AppName[MAX_FPATH_LEN];     // Application pathname
    char        CmdLine[MAX_FPATH_LEN];     // Application command line
    char        RunTimeDir[MAX_FPATH_LEN];  // Application Runtime dir
    UINT        StartState;                 // Application Start State (normal/min/max)
    UINT        WinX;                       // Application window x position
    UINT        WinY;                       // Application window y position
    UINT        WinWidth;                   // Application window width
    UINT        WinHeight;                  // Application window height
    char        IconFile[MAX_FPATH_LEN];    // Application icon file name
    UINT        IconPos;                    // Position in file of app icon
    HICON       IconHandle;                 // Handle to the icon
}SLOT_ENTRY;

/********************************************************************
    Data structure to hold main dock options
********************************************************************/

typedef struct _MAIN_OPTIONS{
    int  Position;
    int  DockSize;
    int  ScreenWidth;
    int  ScreenHeight;
    BOOL ClockActive;
    BOOL WinExitActive;
    BOOL MailActive;
    BOOL MaxView;
    BOOL AlwaysOnTop;
    char MailPath[MAX_FPATH_LEN];
    int  MailFreq;
    BOOL MailSound;
    unsigned long MailBoxSize;
    unsigned long MailBoxDateTime;
    BOOL WinExitConfirm;
}MAIN_OPTIONS;

/*********************************************************************
  Declarations for global variables accessible to all modules
*********************************************************************/
extern MAIN_OPTIONS DockOptions;
extern SLOT_ENTRY  *Slot;
extern SLOT_ENTRY   TmpSlot;
extern int          CurSlot;
extern char        *IniFile;
extern HANDLE	    hAppInst;
extern HWND         hwndDock;

/**************************************************************************
 *  Declare function prototypes for all of the procs associated with a    *
 *  specific window.                                                      *
 **************************************************************************/
long FAR PASCAL DockWinProc(HWND, WORD, WORD, LONG);
int ReadINIFile( HANDLE hInst, SLOT_ENTRY *Slot, int nDockSize);
int WriteINIFile(SLOT_ENTRY *Slot, int nDockSize);
void DrawBitmap(HDC hdc, HBITMAP hBitmap, short xStart, short yStart);
void PaintSlot( HDC hdc, HBITMAP hBlank, int i );
void RePaintSlot( int i, BOOL bErase );
BOOL IsCursorOutOfDock(int X, int Y);
int FindSlotHit( int DockPosition, int XHit, int YHit );

void ExecSlot( int SlotHit, char *CmdLine );

BOOL FAR PASCAL AppOptionsDlgProc(HWND hDlg, WORD iMessage,WORD wParam, LONG lParam);
BOOL FAR PASCAL MainOptionsDlgProc(HWND hDlg, WORD iMessage,WORD wParam, LONG lParam);
BOOL FAR PASCAL MailOptionsDlgProc(HWND hDlg, WORD iMessage,WORD wParam, LONG lParam);
BOOL FAR PASCAL WinExitOptionsDlgProc(HWND hDlg, WORD iMessage,WORD wParam, LONG lParam);
BOOL FAR PASCAL ClockOptionsDlgProc(HWND hDlg, WORD iMessage,WORD wParam, LONG lParam);
BOOL FAR PASCAL ExitDockDlgProc(HWND hDlg, WORD iMessage,WORD wParam, LONG lParam);
BOOL FAR PASCAL ChooseIconDlgProc(HWND hDlg, WORD iMessage, WORD wParam, LONG lParam);

BOOL FAR PASCAL fnAPPOPTIONSDLGDlgProc(HWND, WORD, WORD, LONG);

BOOL FAR PASCAL BrowseIconFile( HWND, char * );
BOOL FAR PASCAL BrowseFileName( HWND, char * );

/****************************************
 * Set definitions for the dialog items *
 ****************************************/

/***************************************************************
 * Definitions for the Application Options Dialog (APPOPTIONS) *
 ***************************************************************/

#define QX_OK		10
#define QX_CANCEL	11
#define QX_REMOVE   12

#define QX_VERSION  42

#define QX_NORMAL	201
#define QX_MINIMUM	202
#define QX_MAXIMUM	203
#define QX_STORE	204

#define QX_FILE		106
#define QX_CMDLINE	107
#define QX_RUNTIMEDIR	108
#define QX_ICONFILE	109

#define QX_ICONBOX	   211
#define QX_ICONNUM	   212
#define QX_ICONTOTAL   213
#define QX_PAGENUM     214
#define QX_PAGETOTAL   215

#define QX_ICONSCROLL	300
#define QX_CHOOSEICON   301
#define QX_BROWSEFILE   302
#define QX_BROWSEICON   303

#define QX_MAILCHECK	401
#define QX_WINEXIT	402
#define QX_CLOCK	403
#define QX_ON_TOP	404
#define QX_MAX_VIEW	405
#define QX_SAVE		406
#define QX_EXIT		407
#define QX_ABOUT	408
#define QX_LEFT     409
#define QX_RIGHT    410
#define QX_TOP      411
#define QX_BOTTOM   412

#define QX_WINEXITCONFIRM 420

#define QX_MAILPATH       430
#define QX_MAILFREQ       431
#define QX_MAILSOUND      432

#define QX_GRABWIN        450

#define QX_ICON1          600

#define QX_TESTBUTTON     800

