
;*************************************************************************
;*                                ADDUP.LSP                 ver. 4.00    *
;*                        *** IN-HOUSE SOFTWARE ***                      *
;*                          BY : GERALD W. GASTON                        *
;*                                                                       *
;*                This version requires ACAD R12 or greater.             *
;*                                                                       *
;*       ADDUP TAKES A SELECTION SET OF TEXT AND/OR DIMENSIONS AND       * 
;*       ADDS THEM UP. ASSOCIATIVE DIMENSION ARE NOT SUPPORTED IN        *
;*       VERSION.                                                        *
;*                                                                       *
;*      (IT'S CRUDE BUT IT WORKS ON ALL FORMATS EXCEPT SCI. NOTATION)    *
;*                                                                       *
;*************************************************************************

(DEFUN C:addup (/ *error* text dum)

 (SETVAR "cmdecho" 0)
  
 (IF (< (ATOI(GETVAR "acadver")) 12)
  (PRINC "ADDUP v4.00 requires ACAD R12 or greater.\n")
 
 (PROGN ;else 
 
  (PRINC "\nAddup  v4.00       IN-HOUSE SOFTWARE       Siemens Inc. \n")
  (PRINC "Select dimensions to Addup\n")

  (SETQ *error* x:adderr
           text (SSGET '((-4 . "<and")
                         (1 . "*#*")
                                   (-4 . "<or")
                                    (0 . "DIMENSION")
                                    (0 . "TEXT")
                                   (-4 . "or>")
                        (-4 . "and>")
                       )
               )
  )

  (PRINC 
    (IF text
       (x:grup text)  
       "Nothing selected. Nothing done.\n"
    ) ; endif
  )

 )) ; end PROGN and end IF 
 (PRINC)
) ; end of main function ADDUP  ver. 3.26

(DEFUN x:adderr (w)
  (IF (/= w "Function cancelled")
     (PRINC (STRCAT "\nError : " w))
     (alert w)
  )
  (SETQ text nil)
  (PRINC)
) ; end of error redefinition function ADDERR

(DEFUN x:grup (text / nsum valid numer stry str1 FTtoIN agood1
                           piece npie cnt isdim inch1 mult d dum) 
 (SETQ valid nil
        nsum 0
 )
 (while (setq name (SSNAME text 0))
  (SETQ stry (ENTGET name)
        mult 1
          str1 (CDR(ASSOC 1 stry))
         numit ""
        agood1 nil fset nil
        FTtoIN 0 cnt 0 numer 0 inch1 0
  )
  (ssdel name text)
  (REPEAT (STRLEN str1)
     (SETQ cnt (1+ cnt)
           piece (SUBSTR str1 cnt 1)
            npie (ASCII piece)
     )
      (IF (wcmatch piece "#,',.,-, ")
     (COND ((wcmatch piece "#")
            (SETQ numit (STRCAT numit piece)
                  valid T
                 agood1 T
            )
           ) ; end case #1

           ((= npie 46)
            (SETQ numit (IF (= numit "") "0." (strcat numit piece))
                 agood1 T
            )
           )
           
           ((AND (NOT agood1) (MINUSP mult))
            (setq mult 1)
           ) ; end case #2
            
           ((AND (NOT agood1) (= npie 45))
            (setq mult -1)
           ) ; end case #3

           ((AND agood1 (> cnt 1) (OR (= npie 32) (= npie 45)) (ZEROP numer)
            (NUMBERP (READ numit)))
              (SETQ inch1 (+ (ATOF numit) inch1)
                    numit ""
              )
           ) ; end case #4

           ((AND agood1 (> cnt 1) (= npie 47) (NUMBERP (READ numit)))
            (SETQ numer (ATOF numit)                                   
                  numit ""
            )
           ) ; end case #5

           ((= npie 39)
            (IF (NOT fset)
                   (SETQ FTtoIN (* 12 (ATOF numit))
                          numit ""
                           fset T
                   )
            ) ; endif
           ) ; end case #6
     ) ;end cond
     (SETQ mult (IF (AND (NOT agood1) (MINUSP mult)) 1 mult)) ;else
     ) ;endif 

  ) ; end of REPEAT loop [nest level 1]

  (SETQ numer (if (AND (> (ATOF numit) 0 ) (> numer 0)) (/ numer (ATOF numit)) (ATOF numit))   
          nsum (+ (* (+ numer inch1 FTtoIN) mult) nsum)
  )
  
 ) ; end of main WHILE loop

 (SETQ d (IF valid
             (STRCAT "\n  " (RTOS nsum 3 2) "   (" (RTOS nsum 2 2) 
                     " inches)   (" (RTOS (* nsum 25.4) 2 2) " mm)")
             "ERROR - Notify IN-HOUSE SOFTWARE!\n" ;With our filter this should never happen.
         ) ; else - endif
 )
) ; end function grup

(princ "\nAddup  v4.00       IN-HOUSE SOFTWARE       Siemens Inc. \n")
(princ "\nType ADDUP at the command prompt to run.\n")
(princ)
