#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include"fxf.h"

char font[FXF_NCHARS][FXF_NROWS][FXF_NBYTES], flags[FXF_NCHARS];

main(argc, argv)
	int argc;
	char **argv;
	{
	int fontfd, i, j, k, state, rowi, bytei;
	int yoffset, xoffset, chari, fmtcol;
	FILE *chrfd;
	char str[81];
	if(argc!=3)
		{
		printf("USAGE: chrtofxf <chrfile> <fxffile>\n");
		exit(1);
		}
	if((chrfd=fopen(argv[1], "r"))==NULL)
		{
		printf("Unable to open %s for read.\n", argv[1]);
		exit(2);
		}
	if((fontfd=open(argv[2], O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
		{
		printf("Unable to open %s for write.\n", argv[2]);
		exit(3);
		}
	for(chari=0;chari<FXF_NCHARS;chari++)
		{
		flags[chari]=0;
		for(rowi=0;rowi<FXF_NROWS;rowi++)
			{
			font[chari][rowi][0]=FXF_WIDTH;
			for(bytei=1;bytei<FXF_NBYTES;bytei++)
				font[chari][rowi][bytei]=0;
			}
		}
	printf("\nConverting glyphs, TeX / ASCII codes (in hex):\n");
	state=fmtcol=0;
	while(fgets(str, 80, chrfd))
		if(!state)
			if(sscanf(str, "\fchrcode :%o", &chari)==1)
				{
				printf("%02x", chari);
				if((++fmtcol)&0x0007)
					printf("\t");
				else
					printf("\n");
				if((chari>=FXF_FIRSTCHAR)&&((chari-FXF_FIRSTCHAR)<FXF_NCHARS))
					{
					chari-=FXF_FIRSTCHAR;
					state=1;
					}
				}
			else;
		else if(state==1)
			if(sscanf(str, "x offset :%d", &xoffset)==1)
				state=2;
			else;
		else if(state==2)
			if(sscanf(str, "y offset :%d", &yoffset)==1)
				state=3;
			else;
		else if(state==3)
			if((str[0]=='+')||(str[0]=='-'))
				{
				rowi=FXF_BASELINE-yoffset;
				if(rowi<0)
					{
					printf("\nCharacter %02x (hex) too high.\n", chari+' '+1);
					printf("y offset = %d\n", yoffset);
					state=-6;
					break;
					}
				state=4;
				}
			else;
		else if(state==4)
			if((str[0]=='\n')||!str[0])
				{
				flags[chari]=1;
				state=0;
				}
			else
				{
				if(rowi>=FXF_NROWS)
					{
					printf("\nCharacter %02x (hex) too low.\n", chari+' '+1);
					printf("Coming into absolute row %d (0-indexed); y offset %d\n", rowi, yoffset);
					state=-4;
					break;
					}
				bytei=0; /* White */
				font[chari][rowi][bytei]=-xoffset;
				for(i=0;str[i]&&(str[i]!='\n')&&(str[i]!='.')&&(str[i]!='*');++i);
				if((str[i]=='\n')||!str[i])
					continue; /* Junk blank line */
				do
					{
					for(;str[i]&&(str[i]!='\n')&&(str[i]==((bytei&1)?'*':'.'));++i)
						++font[chari][rowi][bytei];
					}
				while((++bytei)<FXF_NBYTES);
				for(k=0,j=0;k<FXF_NBYTES;k++)
					{
					j+=font[chari][rowi][k];
					if(j>FXF_WIDTH)
						{
						printf("\nCharacter %02x (hex) too wide (%d pels) after x-offset %d.\n", chari, j, xoffset);
						printf("Image line:\n%s\n", str);
						state=-10;
						}
					}
				rowi++;
			/* We don't enforce completeness for NBYTES odd. */
				for(;str[i]&&(str[i]!='\n');++i)
					if(str[i]!='.')
						{
						printf("\nToo much detail or alien bit char in ASCII char %02x (hex).\n", chari+FXF_FIRSTCHAR);
						printf("Image line reads:\n%s\n", str);
						state=-2;
						break;
						}
				}
		else
			break;
	/* Previous entire beast is an if-else-if composite body */
	if(state)
		printf("\nAbnormal termination of scan phase in state %d.\n", state);
	if(write(fontfd, font, FXF_NCHARS*FXF_NROWS*FXF_NBYTES)!=FXF_NCHARS*FXF_NROWS*FXF_NBYTES)
		printf("Font write error.\n");
	close(fontfd);
	fclose(chrfd);
	printf("\n\nAny ASCII codes below (hexadecimal) were not converted and are blanks:\n");
	for(i=0,j=0;i<FXF_NCHARS;i++)
		if(!flags[i])
			{
			printf("%02x", i+' '+1);
			if((++j)&0x0007)
				printf("\t");
			else
				printf("\n");
			}
	printf("\nTotal of %d not converted.  End of list.  Done.\n", j);
	}
