#include<stdio.h>

main(int argc, char **argv)
	{
	FILE *ifd, *ofd;
	int c;
	if(argc<2)
		{
		printf("\nUSAGE: dtmfcode <infile> <outfile> [/b]\n\n"
			"Without /b, strips non-decimal-digit characters.\n"
			"With /b, additionally converts digits to alphanumerics using extended broker code.\n\n"
			"EXTENDED BROKER CODE:\n\n"
			"Broker code is used in financial trading to generate alphabetics from DTMF.\n"
			"Here, we use a transparent embedded extension of broker code to also\n"
			"support numerics and space.\n\n"
			"Letters are entered by dialing the letter on a Metropolitan dial, followed\n"
			"by 1, 2 or 3 to indicate which of the letters on that button is desired.\n"
			"The letters Q and Z are taken as first and second letters on the 1 button.\n\n"
			"In this extension, for numerics, we simply use a 0 rather than a 1, 2 or 3.\n"
			"Also, space is 1,3, '.' is 0,1, ',' is 0,2 and '-' is 0,3.\n");
		
		exit(1);
		}
	if((ifd=fopen(argv[1], "r"))==NULL)
		{
		printf("Unable to open %s for input.\n", argv[1]);
		exit(2);
		}
	if((ofd=fopen(argv[2], "w"))==NULL)
		{
		printf("Unable to open %s for output.\n", argv[2]);
		exit(3);
		}
	if(argc<=3)
		{
		while((c=getc(ifd))!=EOF)
			if((c>='0')&&(c<='9'))
				putc(c, ofd);
		fclose(ifd);
		fclose(ofd);
		exit(0);
		}
	while(1)
		{
		if((c=getc(ifd))==EOF)
			break;
		switch(c)
			{
			case '0':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('0', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('.', ofd);
						break;
						}
					else if(c=='2')
						{
						putc(',', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('-', ofd);
						break;
						}
				break;
			case '1':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('1', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('Q', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('V', ofd);
						break;
						}
					else if(c=='3')
						{
						putc(' ', ofd);
						break;
						}
				break;
			case '2':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('2', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('A', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('B', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('C', ofd);
						break;
						}
				break;
			case '3':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('3', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('D', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('E', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('F', ofd);
						break;
						}
				break;
			case '4':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('4', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('G', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('H', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('I', ofd);
						break;
						}
				break;
			case '5':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('5', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('J', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('K', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('L', ofd);
						break;
						}
				break;
			case '6':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('6', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('M', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('N', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('O', ofd);
						break;
						}
				break;
			case '7':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('7', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('P', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('R', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('S', ofd);
						break;
						}
				break;
			case '8':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('8', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('T', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('U', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('V', ofd);
						break;
						}
				break;
			case '9':
				while((c=getc(ifd))!=EOF)
					if(c=='0')
						{
						putc('9', ofd);
						break;
						}
					else if(c=='1')
						{
						putc('W', ofd);
						break;
						}
					else if(c=='2')
						{
						putc('X', ofd);
						break;
						}
					else if(c=='3')
						{
						putc('Y', ofd);
						break;
						}
				break;
			}
		}
	fclose(ifd);
	fclose(ofd);
	exit(0);
	}
