/* Released to the Public Domain in 1992 by Peter Edward Cann. */


/* Substitution Tokens for Function Sequences */
/* n&0xff00 must be nonzero!!! */

#define END 0x0100
#define BINCOL 0x0101
#define BINROW 0x0102
#define ASCDECCOL 0x0103
#define ASCDECROW 0x0104
#define ASCDECSEMILIST 0x0105
#define GRABCHAR 0x0106
#define GRAPHCHAR_T 0x0107


/* Function Codes for Function Sequences */

#define CLEAR 0
#define HOME 1
#define CLREOL 2
#define UP 3
#define DOWN 4
#define LEFT 5
#define RIGHT 6
#define GOTO 7
#define NORMAL 8
#define FAINT 9
#define NOFAINT 10
#define BOLD 11
#define NOBOLD 12
#define BLINK 13
#define NOBLINK 14
#define INVERSE 15
#define NOINVERSE 16
#define UPN 17
#define DOWNN 18
#define LEFTN 19
#define RIGHTN 20
#define ANSIATTRIB 21
#define WRAP 22
#define NOWRAP 23
#define GOTOLINE 24
#define GOTOCOL 25
#define BINATTR 26
#define GRAPHCHAR 27
#define BEGGRAPH 28
#define ENDGRAPH 29
#define TAB 30  /* Non-destructive */
#define BELL 31
#define DTAB 32  /* Destructive */
#define CRLF 33
#define NOOP 34
#define SAVEPOS 35
#define RESTOREPOS 36
#define RESPOND 37
#define ANSICPR 38
#define LASTFUN 38


/* Miscellaneous */

#define NFUNCS 32  /* Number of Sequences */
#define FUNLEN 16

#define KEYLEN 16

struct emu_s
	{
	struct
		{
		short codes[FUNLEN];
		short func;
		}
		funcs[NFUNCS];
	struct
		{
		short len;
		unsigned char chars[KEYLEN];
		char nullpause_p;
		}
		keys[256];
	unsigned char gchars[256];
	int tophi_p;
	int binrowoff;
	int bincoloff;
	int default_wrap_p;
	int boldmask;
	int faintmask;
	int blinkmask;
	int inversemask;
	int attroffset;
	int firstcoladdr;
	int firstrowaddr;
	};
	
extern struct emu_s emu;
