#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<graph.h>
#include<bios.h>
#include<dos.h>
#include"fxf.h"

/* PCCP Font Editor. Copyright (C) 1994 Peter Edward Cann */

#define ESCSC 0x011b
#define SPSC 0x3920
#define ENTSC 0x1c0d
#define UPARR 0x4800
#define DNARR 0x5000
#define LTARR 0x4b00
#define RTARR 0x4d00
#define PGUP 0x4900
#define PGDN 0x5100
#define INS 0x5200
#define DEL 0x5300
#define HOME 0x4700
#define END 0x4f00
#define F1 0x3b00
#define F2 0x3c00
#define ALT_F2 0x6900

unsigned char f[FXF_NCHARS][FXF_NROWS][FXF_NBYTES];
unsigned char altf[FXF_NCHARS][FXF_NROWS][FXF_NBYTES];

unsigned char bm[FXF_NROWS][FXF_WIDTH]; /* Bytes for bits; few and fast */
unsigned char cbbm[FXF_NROWS][FXF_WIDTH]; /* Clipboard */

struct videoconfig vc;

void bmtofc(c)
	{
	int row, byte, x, blackp;
	for(row=0;row<FXF_NROWS;row++)
		{
		for(byte=0;byte<FXF_NBYTES;byte++)
			f[c][row][byte]=0;
		for(x=blackp=byte=0;x<FXF_WIDTH;x++)
			{
			if(bm[row][x])
				if(blackp)
					{
					f[c][row][byte]++;
					continue;
					}
				else;
			else
				if(!blackp)
					{
					f[c][row][byte]++;
					continue;
					}
			if((++byte)>FXF_NBYTES)
				putch(7);
			else
				{
				blackp=!blackp;
				f[c][row][byte]=1;
				}
			}
		}
	}

void fctobm(unsigned char c)
	{
	int x, y, bn, bv;
	for(y=0;y<FXF_NROWS;y++)
		for(x=0;x<FXF_WIDTH;x++)
			bm[y][x]=0;
	for(y=0;y<FXF_NCHARS;y++)
		for(x=0,bn=0;bn<FXF_NBYTES;bn++)
			for(bv=f[c][y][bn];bv--;x++)
				bm[y][x]=((bn&1)?1:0);
	/* Ce fini! (Habe Ich das richtig gesagt?) */
	}

int vbh, vbw; /* "Side-effect or argument, that is the question!"           */
	      /*  -Prince Hamlet of Denmark, recently contacted by experts */
	      /*   under an exclusive arrangement with CBS television.     */

void paintpix(int y, int x)
	{
	int sx, sy;
	_setcolor((bm[y][x])?0:1);
	_setlinestyle(0xffff);
	_setfillmask("\xff\xff\xff\xff\xff\xff\xff\xff");
	sx=(vbw*x)+1;
	sy=(vbh*y)+1; /* _GFILLINTERIOR? Pompous ass! */
	_rectangle(_GFILLINTERIOR, sx, sy, sx+vbw-2, sy+vbh-2);
	}

void curspix(int y, int x)
	{
	int sx, sy;
	sx=(vbw*x)+1;
	sy=(vbw*y)+1;
	_setcolor((bm[y][x])?1:0);
	_ellipse(_GBORDER, sx, sy, sx+vbw-2, sy+vbh-2);
	}

int vh, vw, vuh, vuw_qcs;

void redisplay()
	{
	int x, y, sx, sy, zy;
	_setcolor(0);
	_clearscreen(_GCLEARSCREEN);
	_setcolor(1);
	x=y=sx=sy=0;
	for(y=0,zy=0,sy=0;y<=FXF_NROWS;y++,zy++,sy+=vbh)
		{
		if(zy==FXF_BASELINE)
			_setlinestyle(0x1010);
		else
			_setlinestyle(0xbbbb);
		_moveto(0, sy);
		_lineto(vuw_qcs-1, sy);
		}
	_setlinestyle(0xbbbb);
	for(x=0,sx=0;x<=FXF_WIDTH;x++,sx+=vbw)
		{
		_moveto(sx, 0);
		_lineto(sx, vuh-1);
		}
	for(y=0;y<FXF_NROWS;y++)
		for(x=0;x<FXF_WIDTH;x++)
			paintpix(y, x);
	}

int vectexq; /* Vector text quantum, in screen pixels */
int vectex2q, vectex3q, vectex4q;
int vectex5q, vectex6q, vectex7q, vectex8q; /* Fast */

void paintalpha(int x, int y, char c)
	{
	switch(c)
		{
		case 'A':
			_moveto(x, y);
			_lineto(x, y-vectex4q);
			_lineto(x+vectex2q, y-vectex8q);
			_lineto(x+vectex4q, y-vectex4q);
			_lineto(x+vectex4q, y);
			_moveto(x, y-vectex4q);
			_lineto(x+vectex4q, y-vectex4q);
			break;
		case 'B':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex3q, y-vectex8q);
			_lineto(x+vectex4q, y-vectex7q);
			_lineto(x+vectex4q, y-vectex5q);
			_lineto(x+vectex3q, y-vectex4q);
			_lineto(x+vectex4q, y-vectex3q);
			_lineto(x+vectex4q, y-vectexq);
			_lineto(x+vectex3q, y);
			_lineto(x, y);
			_moveto(x, y-vectex4q);
			_lineto(x+vectex3q, y-vectex4q);
			break;
		case 'C':
			_moveto(x+vectex4q, y-vectex8q);
			_lineto(x+vectexq, y-vectex8q);
			_lineto(x, y-vectex7q);
			_lineto(x, y-vectexq);
			_lineto(x+vectexq, y);
			_lineto(x+vectex4q, y);
			break;
		case 'D':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex3q, y-vectex8q);
			_lineto(x+vectex4q, y-vectex7q);
			_lineto(x+vectex4q, y-vectexq);
			_lineto(x+vectex3q, y);
			_lineto(x, y);
			break;
		case 'E':
			_moveto(x+vectex4q, y);
			_lineto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			_moveto(x, y-vectex4q);
			_lineto(x+vectex3q, y-vectex4q);
			break;
		case 'F':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			_moveto(x, y-vectex4q);
			_lineto(x+vectex3q, y-vectex4q);
			break;
		case 'G':
			_moveto(x+vectex2q, y-vectex4q);
			_lineto(x+vectex4q, y-vectex4q); /* Serif was icky */
			_lineto(x+vectex4q, y);
			_lineto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case 'H':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_moveto(x+vectex4q, y);
			_lineto(x+vectex4q, y-vectex8q);
			_moveto(x, y-vectex4q);
			_lineto(x+vectex4q, y-vectex4q);
			break;
		case 'I':
			_moveto(x+vectex2q, y);
			_lineto(x+vectex2q, y-vectex8q);
			_moveto(x+vectexq, y);
			_lineto(x+vectex3q, y);
			_moveto(x+vectexq, y-vectex8q);
			_lineto(x+vectex3q, y-vectex8q);
			break;
		case 'J':
			_moveto(x+vectex2q, y);
			_lineto(x+vectex2q, y-vectex8q);
			_moveto(x+vectex2q, y);
			_lineto(x, y);
			_lineto(x, y-vectex2q);
			break;
		case 'K':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_moveto(x+vectex4q, y-vectex8q);
			_lineto(x, y-vectex4q);
			_lineto(x+vectex4q, y);
			break;
		case 'L':
			_moveto(x+vectex4q, y);
			_lineto(x, y);
			_lineto(x, y-vectex8q);
			break;
		case 'M':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex2q, y-vectex6q);
			_lineto(x+vectex4q, y-vectex8q);
			_lineto(x+vectex4q, y);
			break;
		case 'N':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case 'O':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			_lineto(x+vectex4q, y);
			_lineto(x, y);
			break;
		case 'P':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			_lineto(x+vectex4q, y-vectex4q);
			_lineto(x, y-vectex4q);
			break;
		case 'Q':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			_lineto(x+vectex4q, y);
			_lineto(x, y);
			_moveto(x+vectex3q, y-vectexq);
			_lineto(x+vectex5q, y+vectexq); /* Ah, fuck it! */
			break;
		case 'R':
			_moveto(x, y);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			_lineto(x+vectex4q, y-vectex4q);
			_lineto(x, y-vectex4q);
			_moveto(x+vectexq, y-vectex4q);
			_lineto(x+vectex4q, y);
			break;
		case 'S':
			_moveto(x, y);
			_lineto(x+vectex4q, y);
			_lineto(x+vectex4q, y-vectex4q);
			_lineto(x, y-vectex4q);
			_lineto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case 'T':
			_moveto(x+vectex2q, y);
			_lineto(x+vectex2q, y-vectex8q);
			_moveto(x, y-vectex8q);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case 'U':
			_moveto(x, y-vectex8q);
			_lineto(x, y);
			_lineto(x+vectex4q, y);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case 'V':
			_moveto(x, y-vectex8q);
			_lineto(x+vectex2q, y);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case 'W':
			_moveto(x, y-vectex8q);
			_lineto(x, y);
			_lineto(x+vectex2q, y-vectex2q);
			_lineto(x+vectex4q, y);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case 'X':
			_moveto(x, y);
			_lineto(x+vectex4q, y-vectex8q);
			_moveto(x, y-vectex8q);
			_lineto(x+vectex4q, y);
			break;
		case 'Y':
			_moveto(x+vectex2q, y);
			_lineto(x+vectex2q, y-vectex4q);
			_lineto(x, y-vectex8q);
			_moveto(x+vectex2q, y-vectex4q);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case 'Z':
			_moveto(x+vectex4q, y);
			_lineto(x, y);
			_lineto(x+vectex4q, y-vectex8q);
			_lineto(x, y-vectex8q);
			break;
		case '.':
			_moveto(x+1, y);
			_lineto(x+1, y-1);
			_lineto(x, y-1);
			_lineto(x, y);
			_lineto(x+1, y);
			break;
		case '0':
			_moveto(x+vectex2q, y);
			_lineto(x+vectex4q, y-vectex2q);
			_lineto(x+vectex4q, y-vectex6q);
			_lineto(x+vectex2q, y-vectex8q);
			_lineto(x, y-vectex6q);
			_lineto(x, y-vectex2q);
			_lineto(x+vectex2q, y);
			_moveto(x, y);
			_lineto(x+vectex4q, y-vectex8q);
			break;
		case '1':
			_moveto(x, y);
			_lineto(x+vectex4q, y);
			_moveto(x+vectex2q, y);
			_lineto(x+vectex2q, y-vectex8q);
			_lineto(x+vectexq, y-vectex6q);
			break;
		case '2':
			_moveto(x, y-vectex7q);
			_lineto(x+vectexq, y-vectex8q);
			_lineto(x+vectex3q, y-vectex8q);
			_lineto(x+vectex4q, y-vectex7q);
			_lineto(x+vectex4q, y-vectex5q);
			_lineto(x+vectex3q, y-vectex4q);
			_lineto(x+vectexq, y-vectex4q);
			_lineto(x, y-vectex3q);
			_lineto(x, y);
			_lineto(x+vectex4q, y);
			break;
		/* Don't need any more function keys yet */
		}
	}

/* Would you believe I typed those all in in one dead heat with no visual
 * aids at all? All I had to do after was de-serif the G. Is this the
 * kind of visualization the folks down at the food coop are always
 * flaming about?
 */

void paintstr(int x, int y, char *str)
	{
	char *cp;
	int xx, yy;
	for(xx=x,yy=y,cp=str;*cp;xx+=vectex7q,cp++)
		if((*cp)==' ')
			;
		else if((*cp)=='\n')
			{
			xx=x-vectex7q; /* Pre-de-increment */
			yy+=(2*vectex6q);
			}
		else
			paintalpha(xx, yy, *cp);
	}

char descrips[][16]=
	{
	"EXCLAMATION PT",
	"DOUBLE QUOTES",
	"POUND SIGN",
	"DOLLAR SIGN",
	"PERCENT SIGN",
	"AMPERSAND",
	"APOSTROPHE",
	"OPEN PAREN",
	"CLOSE PAREN",
	"ASTERISK",
	"PLUS SIGN",
	"COMMA",
	"HYPHEN",
	"PERIOD",
	"SLASH",
	"DIGIT ZERO",
	"DIGIT ONE",
	"DIGIT TWO",
	"DIGIT THREE",
	"DIGIT FOUR",
	"DIGIT FIVE",
	"DIGIT SIX",
	"DIGIT SEVEN",
	"DIGIT EIGHT",
	"DIGIT NINE",
	"COLON",
	"SEMICOLON",
	"LESS THAN",
	"EQUALS SIGN",
	"GREATER THAN",
	"QUESTION MARK",
	"AT SIGN",
	"UPPERCASE A",
	"UPPERCASE B",
	"UPPERCASE C",
	"UPPERCASE D",
	"UPPERCASE E",
	"UPPERCASE F",
	"UPPERCASE G",
	"UPPERCASE H",
	"UPPERCASE I",
	"UPPERCASE J",
	"UPPERCASE K",
	"UPPERCASE L",
	"UPPERCASE M",
	"UPPERCASE N",
	"UPPERCASE O",
	"UPPERCASE P",
	"UPPERCASE Q",
	"UPPERCASE R",
	"UPPERCASE S",
	"UPPERCASE T",
	"UPPERCASE U",
	"UPPERCASE V",
	"UPPERCASE W",
	"UPPERCASE X",
	"UPPERCASE Y",
	"UPPERCASE Z",
	"OPEN BRACKET",
	"BACK SLASH",
	"CLOSE BRACKET",
	"CARET",
	"UNDER BAR",
	"BACK QUOTE",
	"LOWERCASE A",
	"LOWERCASE B",
	"LOWERCASE C",
	"LOWERCASE D",
	"LOWERCASE E",
	"LOWERCASE F",
	"LOWERCASE G",
	"LOWERCASE H",
	"LOWERCASE I",
	"LOWERCASE J",
	"LOWERCASE K",
	"LOWERCASE L",
	"LOWERCASE M",
	"LOWERCASE N",
	"LOWERCASE O",
	"LOWERCASE P",
	"LOWERCASE Q",
	"LOWERCASE R",
	"LOWERCASE S",
	"LOWERCASE T",
	"LOWERCASE U",
	"LOWERCASE V",
	"LOWERCASE W",
	"LOWERCASE X",
	"LOWERCASE Y",
	"LOWERCASE Z",
	"OPEN BRACE",
	"VERTICAL BAR",
	"CLOSE BRACE",
	"TILDE",
	};
	

#define WORSTLEN 114 /* Amount needed on right for menu */
#define MENUHEIGHT 192 /* Vertical range needed for menu */

void menu(int c)
	{
	char str[256];
	if((FXF_FIRSTCHAR!='!')||(FXF_NCHARS!=('~'-' ')))
		sprintf(str, "COMPILE NOT\nSUPPORTED.\n\n"
			"F1 COPIES.\nF2 PASTES.\n\n"
			"ARROWS MOVE.\n\n"
			"SPACE OR ENTER\nTOGGLES BIT.\n\n"
			"PAGE KEYS\nSELECT CHAR.\n\n"
			"ESCAPE EXITS\nWITH QUERY.");
	else
		sprintf(str, "NOW DOING\n%s.\n\n"
			"ARROWS MOVE.\n\n"
			"F1 COPIES.\nF2 PASTES\n\n"
			"SPACE OR ENTER\nTOGGLES BIT.\n\n"
			"PAGE KEYS\nSELECT CHAR.\n\n"
			"ESCAPE EXITS\nWITH QUERY.",
				descrips[c]);
	paintstr(vuw_qcs+16, 24, str);
	}

main(int argc, char **argv)
	{
	/* vh,vw=video height & width; vbh,vbw=per bit; vuh,vuw=video used */
	/* qcs=QuickC sucks, 'cause it looks like they got a vuw in here! */
	int fd, altfd, i, j, k, c, oldc, px, py, flag, flag1, hmma, vmma;
	int inhibit_menu, mousep, ctbd; /* ctbd=Color To Be Drawn */
	unsigned kc;
	long fsiz;
	union REGS inr, outr;
	if((argc!=2)&&(argc!=3))
		{
		printf("\nUSAGE: fed <font file name> [<subst file name>]\n\n"
			"Edits PCCP fax font in graphics mode.\n"
			"If subst file is given, glyphs from that can be pasted to the corresponding\n"
			"glyph in the file being edited.\n\n"
			"If fed can't open the main file, it assumes it's new and starts out blank.\n"
			"There is a query for saving the file after exiting.\n"
			"The bell sounds if a bitmap has more than %d runs, starting with white,\n"
			"when you leave that character, and excess runs are discarded.\n\n"
			"COMMANDS:     Arrows...........Move cursor\n"
			"              Space, Enter.....Toggle bit\n"
			"              Insert...........Bit on (black)\n"
			"              Delete...........Bit off (white)\n"
			"              Home.............First Character (%c)\n"
			"              End..............Last Character (%c)\n"
			"              Page-Up..........Previous Character\n"
			"              Page-Down........Next Character\n"
			"              Escape...........Exit and query\n"
			"              F1...............Copy viewed bitmap to temp buffer\n"
			"              F2...............Copy temp buffer into viewed bitmap\n"
			"              Alt-F2...........Copy subst file glyph to this one\n"
			"              Any ASCII........Select character\n",
				FXF_NBYTES,
				FXF_FIRSTCHAR,
				FXF_FIRSTCHAR+FXF_NCHARS-1);
		exit(1);
		}
	if((fd=open(argv[1], O_RDONLY|O_BINARY))==-1)
		for(i=0;i<FXF_NCHARS;i++)
			for(j=0;j<FXF_NROWS;j++)
				for(k=0;k<FXF_NBYTES;k++)
					f[i][j][k]=0;
	else
		if(read(fd, f, sizeof(f))!=sizeof(f))
			{
			printf("Error reading font from file %s.\n", argv[1]);
			exit(5);
			}
		else
			close(fd);
	if(argc==3)
		{
		if((altfd=open(argv[2], O_RDONLY|O_BINARY))==-1)
			{
			printf("Error opening substitution file %s.\n", argv[2]);
			exit(5);
			}
		if(read(altfd, altf, sizeof(altf))!=sizeof(altf))
			{
			printf("Error reading substitution font from file %s.\n", argv[2]);
			exit(5);
			}
		close(altfd);
		}
	inr.x.ax=0x0000;
	int86(0x33, &inr, &outr);
	if(outr.x.ax)
		mousep=1;
	else
		mousep=0;
	_getvideoconfig(&vc);
	switch(vc.adapter)
		{
		case _MDPA:
			printf("My goD, you actually have a text-only monochrome adapter?\n"
				"Have you considered contacting the Smithsonian Institution museum?\n");
			exit(55);
			break; /* Good habit */
		case _HGC:
			if(_setvideomode(_HERCMONO)==-1)
				{
				printf("_setvideomode(_HERCMONO) => -1\n");
				exit(78);
				}
			vh=348;
			vw=720;
			break;
		case _CGA:
		case _OCGA:
			if(_setvideomode(_HRESBW)==-1)
				{
				printf("_setvideomode(_HRESBW) => -1\n");
				exit(78);
				}
			vh=200; /* Unfortunately, we didn't actually want */
			vw=640; /* to play Zap the Martian right now...   */
			break;
		case _EGA:
		case _OEGA:
			if(_setvideomode(_ERESNOCOLOR)==-1)
				{
				printf("_setvideomode(_ERESNOCOLOR) => -1\n");
				exit(78);
				}
			vh=350;
			vw=640;
			break;
		default: /* Hoping to avoid screwing SVGA etc. here */
			if(_setvideomode(_VRES2COLOR)==-1)
				{
				printf("_setvideomode(_VRES2COLOR) => -1\n");
				exit(78);
				}
			vh=480;
			vw=640;
			break;
		}
	/* Duh! We are now in graphics mode, or the ozone, one or the other */
	vbh=(vh-1)/FXF_NROWS;
	vbw=vbh; /* Fix aspect ratio here if you want to */
	vuh=FXF_NROWS*vbh;
	if((vuw_qcs=(FXF_WIDTH*vbw))>vw)
		{
		_setvideomode(_DEFAULTMODE);
		printf("The program cannot support the font parameters compiled into it by\n"
			"way of the include file FXF.H with the display subsystem that has been\n"
			"detected on the machine at this time. The program isn't very smart about\n"
			"unusual aspect ratios right now. Sorry.\n");
		exit(77);
		}
	if(vuw_qcs>=(vw-WORSTLEN))
		inhibit_menu=1;
	else if(vh<=MENUHEIGHT) /* Yeah, yeah. So combine it yourself. */
		inhibit_menu=1;
	else
		{
		inhibit_menu=0;
		i=(vw-vuw_qcs)/WORSTLEN;
		j=(vw-vuw_qcs)/MENUHEIGHT;
		if(i<j)
			vectexq=i;
		else
			vectexq=j;
		vectex2q=vectexq*2;
		vectex3q=vectexq*3;
		vectex4q=vectexq*4;
		vectex5q=vectexq*5;
		vectex6q=vectexq*6;
		vectex7q=vectexq*7;
		vectex8q=vectexq*8;
		}
	c=0; /* Start on first supported character */
	flag=0;
	for(i=0;i<FXF_NROWS;i++)
		for(j=0;j<FXF_WIDTH;j++)
			cbbm[i][j]=0;
	while(1)
		{
		fctobm(c);
		oldc=c;
		px=py=0;
		redisplay();
		if(!inhibit_menu)
			{
			_setcolor(1);
			menu(c);
			}
		flag1=0;
		while(1)
			{
			curspix(py, px);
			inr.x.ax=0x0005; /* Get button-press info */
			int86(0x33, &inr, &outr); /* Just to clear. BX=cnt */
			inr.x.ax=0x000b; /* Get raw motion accumulators. */
			int86(0x33, &inr, &outr); /* CX=Horiz; DX=Vert */
			hmma=vmma=0;
			while(1)
				if(_bios_keybrd(_KEYBRD_READY))
					{
					kc=_bios_keybrd(_KEYBRD_READ);
					break;
					}
				else if(mousep) /*Let me know if any of this*/
					{       /*violates your patent, etc.*/
					inr.x.ax=0x000b;
					int86(0x33, &inr, &outr);
					hmma+=outr.x.cx;
					vmma+=outr.x.dx;
					if((hmma&0x7ff0)||(vmma&0x7ff0))
						{
						paintpix(py, px);
						py+=(vmma>>4);
						vmma&=0x000f;
						if(py<0)
							py=0;
						else if(py>=FXF_NROWS)
							py=FXF_NROWS-1;
						px+=(hmma>>4);
						hmma&=0x000f;
						if(px<0)
							px=0;
						else if(px>=FXF_WIDTH)
							px=FXF_WIDTH-1;
						curspix(py, px);
						}
					inr.x.ax=0x0005;
					int86(0x33, &inr, &outr);
					if(outr.x.bx)
						{
						ctbd=bm[py][px]=!bm[py][px];
						paintpix(py, px);
						curspix(py, px);
						}
					else if(outr.x.ax&1) /* It's a drag */
						if(bm[py][px]!=ctbd)
							{
							bm[py][px]=ctbd;
							paintpix(py, px);
							curspix(py, px);
							}
					}
			paintpix(py, px);
			switch(kc)
				{
				case UPARR:
					if(py>0)
						py--;
					break;
				case DNARR:
					if(py<(FXF_NROWS-1))
						py++;
					break;
				case LTARR:
					if(px>0)
						px--;
					break;
				case RTARR:
					if(px<(FXF_WIDTH-1))
						px++;
					break;
				case PGUP:
					if(c>0)
						{
						c--;
						flag1=1;
						}
					break;
				case PGDN:
					if(c<(FXF_NCHARS-1))
						{
						c++;
						flag1=1;
						}
					break;
				case HOME:
					c=0;
					flag1=1;
					break;
				case END:
					c=FXF_NCHARS-1;
					flag1=1;
					break;
				case INS:
					bm[py][px]=1;
					paintpix(py, px);
					break;
				case DEL:
					bm[py][px]=0;
					paintpix(py, px);
					break;
				case SPSC:
				case ENTSC:
					bm[py][px]=!bm[py][px];
					paintpix(py, px);
					break;
				case ESCSC:
					flag=1;
					break;
				case F1: /* Copy */
					for(i=0;i<FXF_NROWS;i++)
						for(j=0;j<FXF_WIDTH;j++)
							cbbm[i][j]=bm[i][j];
					break;
				case F2: /* Paste */
					for(i=0;i<FXF_NROWS;i++)
						for(j=0;j<FXF_WIDTH;j++)
							bm[i][j]=cbbm[i][j];
					flag1=1;
					break;
				case ALT_F2: /* Paste subst */
					for(i=0;i<FXF_NROWS;i++)
						for(j=0;j<FXF_NBYTES;j++)
							f[c][i][j]=altf[c][i][j];
					fctobm(c);
					redisplay();
					curspix(py, px);
					break;
				default:
					if((i=(kc&0xff)-FXF_FIRSTCHAR)>=0)
						if(i<(FXF_NCHARS))
							{
							c=i;
							flag1=1;
							break;
							}
					break;
				}
			if(flag|flag1)
				break;
			}
		bmtofc(oldc);
		if(flag)
			break;
		}
	_setvideomode(_DEFAULTMODE);
	printf("Type any character to save, or Control-C to discard.\n--> ");
	getch();
	printf("Saving... ");
	if((fd=open(argv[1], O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
		{
		printf("\nError opening file %s for write.\n", argv[1]);
		exit(6);
		}
	if(write(fd, f, sizeof(f))!=sizeof(f))
		{
		printf("\nError writing to file %s.\n", argv[1]);
		exit(10);
		}
	printf(" Done.\n");
	exit(0);
	}
