/* Copyright (C) 1992,1993 Peter Edward Cann */

#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<bios.h>
#include<time.h>
#include<signal.h>
#include"port.h"

#define FBUFSIZ 4096
unsigned char fbuf[FBUFSIZ];
int fbufn;

int rfxfd;

putbyte(byte)
	unsigned char byte;
	{
	fbuf[fbufn++]=byte;
	if(fbufn>=FBUFSIZ)
		if(write(rfxfd, fbuf, fbufn)!=fbufn)
			{
			printf("File write error.\n");
			exit(72);
			}
		else
			fbufn=0;
	}

flush()
	{
	if(write(rfxfd, fbuf, fbufn)!=fbufn)
		{
		printf("File write error on explicit flush.\n");
		exit(73);
		}
	fbufn=0;
	}
	

#define NSCANS 4

unsigned char scans[NSCANS][16]=
	{
	"+FCON\r\n",
	"OK\r\n",
	"CONNECT\r\n",
	"+FHNG"
	};

int scani[NSCANS];

quit()
	{
	cleanup(0);
	exit(99);
	}

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)))
		if(_bios_keybrd(_KEYBRD_READY))
			if((_bios_keybrd(_KEYBRD_READ)&0xff)==0x03)
				quit();
	outp(basereg, c);
	}

int follow;

sendstr(str)
	char *str;
	{
	int i;
	for(i=0;str[i]!='\0';++i)
		sendchar(str[i]);
	}

int scan(seconds)
	int seconds;
	{
	long timestamp;
	int i, j;
	timestamp=time(NULL);
	for(i=0;i<NSCANS;++i)
		scani[i]=0;
	while(1)
		{
		while(follow==index)
			{
			if(kbhit())
				getch();
			if((time(NULL)-timestamp)>seconds)
				{
				for(j=0;j<NSCANS;j++)
					scani[j]=0;
				return(-1);
				}
			}
		putbyte(buf[follow]);
		putch(buf[follow]);
		for(i=0;i<NSCANS;i++)
			if(scans[i][scani[i]]==buf[follow])
				{
				scani[i]++;
				if(scans[i][scani[i]]=='\0')
					{
					for(j=0;j<NSCANS;j++)
						scani[j]=0;
					follow++;
					follow%=TBUFSIZ;
					return(i);
					}
				}
			else
				scani[i]=0;
		follow++;
		follow%=TBUFSIZ;
		}
	}

putstr(str)
	char *str;
	{
	char *strp;
	strp=str;
	if(*strp)
		do
			putbyte(*(strp++));
		while(*strp);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	long timestamp;
	int flag;
	unsigned char c;
	char fname[256];
	if(argc!=5)
		{
		printf("USAGE: rcvfax <comnum> <initspeed> <afterspeed> <dir>\n");
		exit(98);
		}
	fbufn=0;
	timestamp=time(NULL);
	sprintf(fname, "%s\\%08lx.rfx", argv[4], timestamp);
	printf("Opening received fax file %s.\n", fname);
	if((rfxfd=open(fname, O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
		{
		printf("Error opening file %s.\n", fname);
		exit(97);
		}
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits='1';
	setport();
	readset();
	follow=index=0;
	setup();
	speed=atoi(argv[3]);
	switch(scan(60))
		{
		case -1:
			cleanup(0);
			printf("Timeout waiting for +FCON.\n");
			close(rfxfd);
			unlink(fname);
			exit(1);
			break;
		case 0:
			break;
		case 3:
			cleanup(0);
			printf("Hangup waiting for +FCON.\n");
			close(rfxfd);
			unlink(fname);
			exit(1);
			break;
		default:
			cleanup(0);
			printf("Received recognized token other than +FCON.\n");
			close(rfxfd);
			unlink(fname);
			exit(2);
			break;
		}
	setport();
	setup();
	switch(scan(60))
		{
		case -1:
			putstr("\r\nTIMEOUT\r\n");
			cleanup(0);
			printf("Timeout waiting for initial OK.\n");
			flush();
			exit(3);
			break;
		case 1:
			break;
		case 3:
			scan(15);
			cleanup(0);
			printf("Waiting for initial OK received +FHNG.\n");
			flush();
			exit(30);
			break;
		default:
			cleanup(0);
			printf("Waiting for initial OK received other recognized token.\n");
			flush();
			exit(4);
			break;
		}
	while(1)
		{
		/* Loop over pages */
		sendstr("AT+FDR\r");
		switch(scan(60))
			{
			case -1:
				putstr("\nTIMEOUT\n");
				cleanup(0);
				printf("Timeout waiting for CONNECT.\n");
				flush();
				exit(5);
				break;
			case 2:
				break;
			case 3:
				if(scan(15)==1)
					{
					cleanup(0);
					flush();
					exit(0);
					}
				else
					{
					cleanup(0);
					printf("No OK after FHNG.\n");
					flush();
					exit(11);
					}
			default:
				cleanup(0);
				printf("Bad stuff after +FDR command.\n");
				flush();
				exit(6);
				break;
			}
		sendchar(0x11);
		flag=0;
		while(1)
			{
			/* Loop over characters */
			if(follow==index)
				{
				timestamp=time(NULL);
				while(follow==index)
					{
					if(_bios_keybrd(_KEYBRD_READY))
						if((_bios_keybrd(_KEYBRD_READ)&0xff)==0x03)
							quit();
					if((time(NULL)-timestamp)>30)
						/* If this times out, the main loop is */
						/* probably falling behind the stream. */
						{
						cleanup(0);
						putstr("\nTIMEOUT\n");
						printf("Data timeout.\n");
						flush();
						exit(7);
						}
					}
				}
			putbyte(buf[follow]);
			if(buf[follow]==0x10)
				flag=!flag;
			else
				if(buf[follow]==0x03)
					if(flag)
						{
						if((++follow)>=TBUFSIZ)
							follow=0;
						break;
						}
					else;
				else
					flag=0;
			if((++follow)>=TBUFSIZ)
				follow=0;
			}
		switch(scan(60))
			{
			case -1:
				putstr("\nTIMEOUT\n");
				cleanup(0);
				printf("Timeout waiting for post-data OK.\n");
				flush();
				exit(8);
				break;
			case 1:
				break;
			case 3:
				scan(15);
				printf("Hangup waiting for post-data OK.\n");
				cleanup(0);
				flush();
				exit(31);
				break;
			default:
				cleanup(0);
				printf("Got wrong token while waiting for post-data OK.\n");
				flush();
				exit(9);
				break;
			}
		}
	}
